/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.cockroachdb;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.database.cockroachdb.CockroachDBConnection;

public class CockroachDBDatabase
extends Database<CockroachDBConnection> {
    private final MigrationVersion determinedVersion;

    public CockroachDBDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
        this.determinedVersion = this.rawDetermineVersion(configuration);
    }

    protected CockroachDBConnection doGetConnection(Connection connection) {
        return new CockroachDBConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
        this.ensureDatabaseIsRecentEnough("1.1");
        this.recommendFlywayUpgradeIfNecessary("22.1");
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE IF NOT EXISTS " + String.valueOf(table) + " (\n    \"installed_rank\" INT NOT NULL PRIMARY KEY,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INTEGER,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP NOT NULL DEFAULT now(),\n    \"execution_time\" INTEGER NOT NULL,\n    \"success\" BOOLEAN NOT NULL\n);\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "CREATE INDEX IF NOT EXISTS \"" + table.getName() + "_s_idx\" ON " + String.valueOf(table) + " (\"success\");";
    }

    private MigrationVersion rawDetermineVersion(Configuration configuration) {
        String version;
        try {
            JdbcTemplate template = new JdbcTemplate(this.rawMainJdbcConnection, DatabaseTypeRegister.getDatabaseTypeForConnection((Connection)this.rawMainJdbcConnection, (Configuration)configuration));
            version = template.queryForString("SELECT value FROM crdb_internal.node_build_info where field='Version'", new String[0]);
            if (version == null) {
                version = template.queryForString("SELECT value FROM crdb_internal.node_build_info where field='Tag'", new String[0]);
            }
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine CockroachDB version", e);
        }
        int firstDot = version.indexOf(".");
        int majorVersion = Integer.parseInt(version.substring(1, firstDot));
        String minorPatch = version.substring(firstDot + 1);
        int minorVersion = Integer.parseInt(minorPatch.substring(0, minorPatch.indexOf(".")));
        return MigrationVersion.fromVersion((String)(majorVersion + "." + minorVersion));
    }

    protected MigrationVersion determineVersion() {
        return this.determinedVersion;
    }

    boolean supportsSchemas() {
        return this.getVersion().isAtLeast("20.2");
    }

    protected String doGetCurrentUser() throws SQLException {
        return ((CockroachDBConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT * FROM [SHOW SESSION_USER]", new String[0]);
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "TRUE";
    }

    public String getBooleanFalse() {
        return "FALSE";
    }

    public String doQuote(String identifier) {
        return this.getOpenQuote() + StringUtils.replaceAll((String)identifier, (String)this.getCloseQuote(), (String)this.getEscapedQuote()) + this.getCloseQuote();
    }

    public String getEscapedQuote() {
        return "\"\"";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public boolean useSingleConnection() {
        return false;
    }
}

