/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.densify;

import com.mongodb.annotations.Evolving;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.MongoTimeUnit;
import com.mongodb.client.model.densify.DateDensifyRange;
import com.mongodb.client.model.densify.DensifyConstructibleBson;
import com.mongodb.client.model.densify.NumberDensifyRange;
import java.time.Instant;
import java.util.Arrays;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;

@Evolving
public interface DensifyRange
extends Bson {
    public static NumberDensifyRange fullRangeWithStep(Number step) {
        return new DensifyConstructibleBson((Bson)new Document("bounds", (Object)"full").append("step", (Object)Assertions.notNull("step", step)));
    }

    public static NumberDensifyRange partitionRangeWithStep(Number step) {
        return new DensifyConstructibleBson((Bson)new Document("bounds", (Object)"partition").append("step", (Object)Assertions.notNull("step", step)));
    }

    public static NumberDensifyRange rangeWithStep(Number l, Number u, Number step) {
        Assertions.notNull("l", l);
        Assertions.notNull("u", u);
        Assertions.notNull("step", step);
        return new DensifyConstructibleBson((Bson)new Document("bounds", Arrays.asList(l, u)).append("step", (Object)Assertions.notNull("step", step)));
    }

    public static DateDensifyRange fullRangeWithStep(long step, MongoTimeUnit unit) {
        Assertions.notNull("unit", unit);
        return new DensifyConstructibleBson((Bson)new BsonDocument("bounds", (BsonValue)new BsonString("full")).append("step", (BsonValue)new BsonInt64(step)).append("unit", (BsonValue)new BsonString(unit.value())));
    }

    public static DateDensifyRange partitionRangeWithStep(long step, MongoTimeUnit unit) {
        Assertions.notNull("unit", unit);
        return new DensifyConstructibleBson((Bson)new BsonDocument("bounds", (BsonValue)new BsonString("partition")).append("step", (BsonValue)new BsonInt64(step)).append("unit", (BsonValue)new BsonString(unit.value())));
    }

    public static DateDensifyRange rangeWithStep(Instant l, Instant u, long step, MongoTimeUnit unit) {
        Assertions.notNull("l", l);
        Assertions.notNull("u", u);
        Assertions.notNull("unit", unit);
        return new DensifyConstructibleBson((Bson)new Document("bounds", Arrays.asList(l, u)).append("step", (Object)step).append("unit", (Object)unit.value()));
    }

    public static DensifyRange of(Bson range) {
        return new DensifyConstructibleBson(Assertions.notNull("range", range));
    }
}

