/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.MongoTimeUnit;
import com.mongodb.client.model.Window;
import com.mongodb.lang.Nullable;
import java.util.Objects;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.Decimal128;

public final class Windows {
    public static Window of(Bson window) {
        return new BsonWindow((Bson)Assertions.notNull((String)"window", (Object)window));
    }

    public static Window documents(int lower, int upper) {
        com.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", lower <= upper);
        return new SimpleWindow<Integer, Integer>("documents", lower, upper, null);
    }

    public static Window documents(Bound lower, int upper) {
        Assertions.notNull((String)"lower", (Object)((Object)lower));
        if (lower == Bound.CURRENT) {
            com.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", upper >= 0);
        }
        return new SimpleWindow<String, Integer>("documents", lower.value(), upper, null);
    }

    public static Window documents(int lower, Bound upper) {
        Assertions.notNull((String)"upper", (Object)((Object)upper));
        if (upper == Bound.CURRENT) {
            com.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", lower <= 0);
        }
        return new SimpleWindow<Integer, String>("documents", lower, upper.value(), null);
    }

    public static Window documents(Bound lower, Bound upper) {
        Assertions.notNull((String)"lower", (Object)((Object)lower));
        Assertions.notNull((String)"upper", (Object)((Object)upper));
        return new SimpleWindow<String, String>("documents", lower.value(), upper.value(), null);
    }

    public static Window range(long lower, long upper) {
        com.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", lower <= upper);
        return new SimpleWindow<Long, Long>("range", lower, upper, null);
    }

    public static Window range(double lower, double upper) {
        com.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", lower <= upper);
        return new SimpleWindow<Double, Double>("range", lower, upper, null);
    }

    public static Window range(Decimal128 lower, Decimal128 upper) {
        Assertions.notNull((String)"lower", (Object)lower);
        Assertions.notNull((String)"upper", (Object)upper);
        com.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", lower.compareTo(upper) <= 0);
        return new SimpleWindow<Decimal128, Decimal128>("range", lower, upper, null);
    }

    public static Window range(Bound lower, long upper) {
        Assertions.notNull((String)"lower", (Object)((Object)lower));
        return new SimpleWindow<String, Long>("range", lower.value(), upper, null);
    }

    public static Window range(Bound lower, double upper) {
        Assertions.notNull((String)"lower", (Object)((Object)lower));
        return new SimpleWindow<String, Double>("range", lower.value(), upper, null);
    }

    public static Window range(Bound lower, Decimal128 upper) {
        Assertions.notNull((String)"lower", (Object)((Object)lower));
        Assertions.notNull((String)"upper", (Object)upper);
        return new SimpleWindow<String, Decimal128>("range", lower.value(), upper, null);
    }

    public static Window range(long lower, Bound upper) {
        Assertions.notNull((String)"upper", (Object)((Object)upper));
        return new SimpleWindow<Long, String>("range", lower, upper.value(), null);
    }

    public static Window range(double lower, Bound upper) {
        Assertions.notNull((String)"upper", (Object)((Object)upper));
        return new SimpleWindow<Double, String>("range", lower, upper.value(), null);
    }

    public static Window range(Decimal128 lower, Bound upper) {
        Assertions.notNull((String)"lower", (Object)lower);
        Assertions.notNull((String)"upper", (Object)((Object)upper));
        return new SimpleWindow<Decimal128, String>("range", lower, upper.value(), null);
    }

    public static Window timeRange(long lower, long upper, MongoTimeUnit unit) {
        Assertions.notNull((String)"unit", (Object)((Object)unit));
        com.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", lower <= upper);
        return new SimpleWindow<Long, Long>("range", lower, upper, unit);
    }

    public static Window timeRange(Bound lower, long upper, MongoTimeUnit unit) {
        Assertions.notNull((String)"lower", (Object)((Object)lower));
        Assertions.notNull((String)"unit", (Object)((Object)unit));
        return new SimpleWindow<String, Long>("range", lower.value(), upper, unit);
    }

    public static Window timeRange(long lower, MongoTimeUnit unit, Bound upper) {
        Assertions.notNull((String)"unit", (Object)((Object)unit));
        Assertions.notNull((String)"upper", (Object)((Object)upper));
        return new SimpleWindow<Long, String>("range", lower, upper.value(), unit);
    }

    private Windows() {
        throw new UnsupportedOperationException();
    }

    private static final class BsonWindow
    implements Window {
        private final Bson wrapped;

        BsonWindow(Bson document) {
            this.wrapped = com.mongodb.assertions.Assertions.assertNotNull(document);
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            return this.wrapped.toBsonDocument(tDocumentClass, codecRegistry);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BsonWindow that = (BsonWindow)o;
            return this.wrapped.equals(that.wrapped);
        }

        public int hashCode() {
            return Objects.hash(this.wrapped);
        }

        public String toString() {
            return this.wrapped.toString();
        }
    }

    private static class SimpleWindow<L, U>
    implements Window {
        static final String TYPE_POSITION_BASED = "documents";
        static final String TYPE_RANGE_BASED = "range";
        private final String type;
        private final L lower;
        private final U upper;
        @Nullable
        private final MongoTimeUnit unit;

        SimpleWindow(String type, L lower, U upper, @Nullable MongoTimeUnit unit) {
            this.lower = lower;
            this.upper = upper;
            this.type = type;
            this.unit = unit;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeStartArray(this.type);
            BuildersHelper.encodeValue(writer, this.lower, codecRegistry);
            BuildersHelper.encodeValue(writer, this.upper, codecRegistry);
            writer.writeEndArray();
            if (this.unit != null) {
                writer.writeString("unit", this.unit.value());
            }
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleWindow that = (SimpleWindow)o;
            return this.type.equals(that.type) && this.lower.equals(that.lower) && this.upper.equals(that.upper) && this.unit == that.unit;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.lower, this.upper, this.unit});
        }

        public String toString() {
            return "Window{type=" + this.type + ", lower=" + this.lower + ", upper=" + this.upper + ", unit=" + (Object)((Object)this.unit) + '}';
        }
    }

    public static enum Bound {
        CURRENT("current"),
        UNBOUNDED("unbounded");

        private final String value;

        private Bound(String value) {
            this.value = value;
        }

        String value() {
            return this.value;
        }
    }
}

