//===----------------------------------------------------------------------===//
// Copyright © 2025-2026 Apple Inc. and the container project authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//===----------------------------------------------------------------------===//

//
// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the protocol buffer compiler.
// Source: Builder.proto
//
import GRPC
import NIO
import NIOConcurrencyHelpers
import SwiftProtobuf


/// Builder service implements APIs for performing an image build with
/// Container image builder agent.
///
/// To perform a build:
///
/// 1. CreateBuild to create a new build
/// 2. StartBuild to start the build execution where client and server
///    both have a stream for exchanging data during the build.
///
///    The client may send:
///      a) signal packet to signal to the build process (e.g. SIGINT)
///
///      b) command packet for executing a command in the build file on the
///      server
///         NOTE: the server will need to switch on the command to determine the
///         type of command to execute (e.g. RUN, ENV, etc.)
///
///      c) transfer build data either to or from the server
///         - INTO direction is for sending build data to the server at specific
///         location (e.g. COPY)
///         - OUTOF direction is for copying build data from the server to be
///         used in subsequent build stages
///
///      d) transfer image content data either to or from the server
///         - INTO direction is for sending inherited image content data to the
///         server's local content store
///         - OUTOF direction is for copying successfully built OCI image from
///         the server to the client
///
///    The server may send:
///      a) stdio packet for the build progress
///
///      b) build error indicating unsuccessful build
///
///      c) command complete packet indicating a command has finished executing
///
///      d) handle transfer build data either to or from the client
///
///      e) handle transfer image content data either to or from the client
///
///
///    NOTE: The build data and image content data transfer is ALWAYS initiated
///    by the client.
///
///    Sequence for transferring from the client to the server:
///      1. client send a BuildTransfer/ImageTransfer request with ID, direction
///      of 'INTO',
///         destination path, and first chunk of data
///      2. server starts to receive the data and stream to a temporary file
///      3. client continues to send all chunks of data until last chunk, which
///      client will
///         send with 'complete' set to true
///      4. server continues to receive until the last chunk with 'complete' set
///      to true,
///         server will finish writing the last chunk and un-archive the
///         temporary file to the destination path
///      5. server completes the transfer by sending a last
///      BuildTransfer/ImageTransfer with
///         'complete' set to true
///      6. client waits for the last BuildTransfer/ImageTransfer with 'complete'
///      set to true
///         before proceeding with the rest of the commands
///
///    Sequence for transferring from the server to the client:
///      1. client send a BuildTransfer/ImageTransfer request with ID, direction
///      of 'OUTOF',
///         source path, and empty data
///      2. server archives the data at source path, and starts to send chunks to
///      the client
///      3. server continues to send all chunks until last chunk, which server
///      will send with
///         'complete' set to true
///      4. client starts to receive the data and stream to a temporary file
///      5. client continues to receive until the last chunk with 'complete' set
///      to true,
///         client will finish writing last chunk and un-archive the temporary
///         file to the destination path
///      6. client MAY choose to send one last BuildTransfer/ImageTransfer with
///      'complete'
///         set to true, but NOT required.
///
///
///    NOTE: the client should close the send stream once it has finished
///    receiving the build output or abandon the current build due to error.
///    Server should keep the stream open until it receives the EOF that client
///    has closed the stream, which the server should then close its send stream.
///
/// Usage: instantiate `Com_Apple_Container_Build_V1_BuilderClient`, then call methods of this protocol to make API calls.
public protocol Com_Apple_Container_Build_V1_BuilderClientProtocol: GRPCClient {
  var serviceName: String { get }
  var interceptors: Com_Apple_Container_Build_V1_BuilderClientInterceptorFactoryProtocol? { get }

  func createBuild(
    _ request: Com_Apple_Container_Build_V1_CreateBuildRequest,
    callOptions: CallOptions?
  ) -> UnaryCall<Com_Apple_Container_Build_V1_CreateBuildRequest, Com_Apple_Container_Build_V1_CreateBuildResponse>

  func performBuild(
    callOptions: CallOptions?,
    handler: @escaping (Com_Apple_Container_Build_V1_ServerStream) -> Void
  ) -> BidirectionalStreamingCall<Com_Apple_Container_Build_V1_ClientStream, Com_Apple_Container_Build_V1_ServerStream>

  func info(
    _ request: Com_Apple_Container_Build_V1_InfoRequest,
    callOptions: CallOptions?
  ) -> UnaryCall<Com_Apple_Container_Build_V1_InfoRequest, Com_Apple_Container_Build_V1_InfoResponse>
}

extension Com_Apple_Container_Build_V1_BuilderClientProtocol {
  public var serviceName: String {
    return "com.apple.container.build.v1.Builder"
  }

  /// Create a build request.
  ///
  /// - Parameters:
  ///   - request: Request to send to CreateBuild.
  ///   - callOptions: Call options.
  /// - Returns: A `UnaryCall` with futures for the metadata, status and response.
  public func createBuild(
    _ request: Com_Apple_Container_Build_V1_CreateBuildRequest,
    callOptions: CallOptions? = nil
  ) -> UnaryCall<Com_Apple_Container_Build_V1_CreateBuildRequest, Com_Apple_Container_Build_V1_CreateBuildResponse> {
    return self.makeUnaryCall(
      path: Com_Apple_Container_Build_V1_BuilderClientMetadata.Methods.createBuild.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeCreateBuildInterceptors() ?? []
    )
  }

  /// Perform the build.
  /// Executes the entire build sequence with attaching input/output
  /// to handling data exchange with the server during the build.
  ///
  /// Callers should use the `send` method on the returned object to send messages
  /// to the server. The caller should send an `.end` after the final message has been sent.
  ///
  /// - Parameters:
  ///   - callOptions: Call options.
  ///   - handler: A closure called when each response is received from the server.
  /// - Returns: A `ClientStreamingCall` with futures for the metadata and status.
  public func performBuild(
    callOptions: CallOptions? = nil,
    handler: @escaping (Com_Apple_Container_Build_V1_ServerStream) -> Void
  ) -> BidirectionalStreamingCall<Com_Apple_Container_Build_V1_ClientStream, Com_Apple_Container_Build_V1_ServerStream> {
    return self.makeBidirectionalStreamingCall(
      path: Com_Apple_Container_Build_V1_BuilderClientMetadata.Methods.performBuild.path,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makePerformBuildInterceptors() ?? [],
      handler: handler
    )
  }

  /// Unary call to Info
  ///
  /// - Parameters:
  ///   - request: Request to send to Info.
  ///   - callOptions: Call options.
  /// - Returns: A `UnaryCall` with futures for the metadata, status and response.
  public func info(
    _ request: Com_Apple_Container_Build_V1_InfoRequest,
    callOptions: CallOptions? = nil
  ) -> UnaryCall<Com_Apple_Container_Build_V1_InfoRequest, Com_Apple_Container_Build_V1_InfoResponse> {
    return self.makeUnaryCall(
      path: Com_Apple_Container_Build_V1_BuilderClientMetadata.Methods.info.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeInfoInterceptors() ?? []
    )
  }
}

@available(*, deprecated)
extension Com_Apple_Container_Build_V1_BuilderClient: @unchecked Sendable {}

@available(*, deprecated, renamed: "Com_Apple_Container_Build_V1_BuilderNIOClient")
public final class Com_Apple_Container_Build_V1_BuilderClient: Com_Apple_Container_Build_V1_BuilderClientProtocol {
  private let lock = Lock()
  private var _defaultCallOptions: CallOptions
  private var _interceptors: Com_Apple_Container_Build_V1_BuilderClientInterceptorFactoryProtocol?
  public let channel: GRPCChannel
  public var defaultCallOptions: CallOptions {
    get { self.lock.withLock { return self._defaultCallOptions } }
    set { self.lock.withLockVoid { self._defaultCallOptions = newValue } }
  }
  public var interceptors: Com_Apple_Container_Build_V1_BuilderClientInterceptorFactoryProtocol? {
    get { self.lock.withLock { return self._interceptors } }
    set { self.lock.withLockVoid { self._interceptors = newValue } }
  }

  /// Creates a client for the com.apple.container.build.v1.Builder service.
  ///
  /// - Parameters:
  ///   - channel: `GRPCChannel` to the service host.
  ///   - defaultCallOptions: Options to use for each service call if the user doesn't provide them.
  ///   - interceptors: A factory providing interceptors for each RPC.
  public init(
    channel: GRPCChannel,
    defaultCallOptions: CallOptions = CallOptions(),
    interceptors: Com_Apple_Container_Build_V1_BuilderClientInterceptorFactoryProtocol? = nil
  ) {
    self.channel = channel
    self._defaultCallOptions = defaultCallOptions
    self._interceptors = interceptors
  }
}

public struct Com_Apple_Container_Build_V1_BuilderNIOClient: Com_Apple_Container_Build_V1_BuilderClientProtocol {
  public var channel: GRPCChannel
  public var defaultCallOptions: CallOptions
  public var interceptors: Com_Apple_Container_Build_V1_BuilderClientInterceptorFactoryProtocol?

  /// Creates a client for the com.apple.container.build.v1.Builder service.
  ///
  /// - Parameters:
  ///   - channel: `GRPCChannel` to the service host.
  ///   - defaultCallOptions: Options to use for each service call if the user doesn't provide them.
  ///   - interceptors: A factory providing interceptors for each RPC.
  public init(
    channel: GRPCChannel,
    defaultCallOptions: CallOptions = CallOptions(),
    interceptors: Com_Apple_Container_Build_V1_BuilderClientInterceptorFactoryProtocol? = nil
  ) {
    self.channel = channel
    self.defaultCallOptions = defaultCallOptions
    self.interceptors = interceptors
  }
}

/// Builder service implements APIs for performing an image build with
/// Container image builder agent.
///
/// To perform a build:
///
/// 1. CreateBuild to create a new build
/// 2. StartBuild to start the build execution where client and server
///    both have a stream for exchanging data during the build.
///
///    The client may send:
///      a) signal packet to signal to the build process (e.g. SIGINT)
///
///      b) command packet for executing a command in the build file on the
///      server
///         NOTE: the server will need to switch on the command to determine the
///         type of command to execute (e.g. RUN, ENV, etc.)
///
///      c) transfer build data either to or from the server
///         - INTO direction is for sending build data to the server at specific
///         location (e.g. COPY)
///         - OUTOF direction is for copying build data from the server to be
///         used in subsequent build stages
///
///      d) transfer image content data either to or from the server
///         - INTO direction is for sending inherited image content data to the
///         server's local content store
///         - OUTOF direction is for copying successfully built OCI image from
///         the server to the client
///
///    The server may send:
///      a) stdio packet for the build progress
///
///      b) build error indicating unsuccessful build
///
///      c) command complete packet indicating a command has finished executing
///
///      d) handle transfer build data either to or from the client
///
///      e) handle transfer image content data either to or from the client
///
///
///    NOTE: The build data and image content data transfer is ALWAYS initiated
///    by the client.
///
///    Sequence for transferring from the client to the server:
///      1. client send a BuildTransfer/ImageTransfer request with ID, direction
///      of 'INTO',
///         destination path, and first chunk of data
///      2. server starts to receive the data and stream to a temporary file
///      3. client continues to send all chunks of data until last chunk, which
///      client will
///         send with 'complete' set to true
///      4. server continues to receive until the last chunk with 'complete' set
///      to true,
///         server will finish writing the last chunk and un-archive the
///         temporary file to the destination path
///      5. server completes the transfer by sending a last
///      BuildTransfer/ImageTransfer with
///         'complete' set to true
///      6. client waits for the last BuildTransfer/ImageTransfer with 'complete'
///      set to true
///         before proceeding with the rest of the commands
///
///    Sequence for transferring from the server to the client:
///      1. client send a BuildTransfer/ImageTransfer request with ID, direction
///      of 'OUTOF',
///         source path, and empty data
///      2. server archives the data at source path, and starts to send chunks to
///      the client
///      3. server continues to send all chunks until last chunk, which server
///      will send with
///         'complete' set to true
///      4. client starts to receive the data and stream to a temporary file
///      5. client continues to receive until the last chunk with 'complete' set
///      to true,
///         client will finish writing last chunk and un-archive the temporary
///         file to the destination path
///      6. client MAY choose to send one last BuildTransfer/ImageTransfer with
///      'complete'
///         set to true, but NOT required.
///
///
///    NOTE: the client should close the send stream once it has finished
///    receiving the build output or abandon the current build due to error.
///    Server should keep the stream open until it receives the EOF that client
///    has closed the stream, which the server should then close its send stream.
@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
public protocol Com_Apple_Container_Build_V1_BuilderAsyncClientProtocol: GRPCClient {
  static var serviceDescriptor: GRPCServiceDescriptor { get }
  var interceptors: Com_Apple_Container_Build_V1_BuilderClientInterceptorFactoryProtocol? { get }

  func makeCreateBuildCall(
    _ request: Com_Apple_Container_Build_V1_CreateBuildRequest,
    callOptions: CallOptions?
  ) -> GRPCAsyncUnaryCall<Com_Apple_Container_Build_V1_CreateBuildRequest, Com_Apple_Container_Build_V1_CreateBuildResponse>

  func makePerformBuildCall(
    callOptions: CallOptions?
  ) -> GRPCAsyncBidirectionalStreamingCall<Com_Apple_Container_Build_V1_ClientStream, Com_Apple_Container_Build_V1_ServerStream>

  func makeInfoCall(
    _ request: Com_Apple_Container_Build_V1_InfoRequest,
    callOptions: CallOptions?
  ) -> GRPCAsyncUnaryCall<Com_Apple_Container_Build_V1_InfoRequest, Com_Apple_Container_Build_V1_InfoResponse>
}

@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
extension Com_Apple_Container_Build_V1_BuilderAsyncClientProtocol {
  public static var serviceDescriptor: GRPCServiceDescriptor {
    return Com_Apple_Container_Build_V1_BuilderClientMetadata.serviceDescriptor
  }

  public var interceptors: Com_Apple_Container_Build_V1_BuilderClientInterceptorFactoryProtocol? {
    return nil
  }

  public func makeCreateBuildCall(
    _ request: Com_Apple_Container_Build_V1_CreateBuildRequest,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncUnaryCall<Com_Apple_Container_Build_V1_CreateBuildRequest, Com_Apple_Container_Build_V1_CreateBuildResponse> {
    return self.makeAsyncUnaryCall(
      path: Com_Apple_Container_Build_V1_BuilderClientMetadata.Methods.createBuild.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeCreateBuildInterceptors() ?? []
    )
  }

  public func makePerformBuildCall(
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncBidirectionalStreamingCall<Com_Apple_Container_Build_V1_ClientStream, Com_Apple_Container_Build_V1_ServerStream> {
    return self.makeAsyncBidirectionalStreamingCall(
      path: Com_Apple_Container_Build_V1_BuilderClientMetadata.Methods.performBuild.path,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makePerformBuildInterceptors() ?? []
    )
  }

  public func makeInfoCall(
    _ request: Com_Apple_Container_Build_V1_InfoRequest,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncUnaryCall<Com_Apple_Container_Build_V1_InfoRequest, Com_Apple_Container_Build_V1_InfoResponse> {
    return self.makeAsyncUnaryCall(
      path: Com_Apple_Container_Build_V1_BuilderClientMetadata.Methods.info.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeInfoInterceptors() ?? []
    )
  }
}

@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
extension Com_Apple_Container_Build_V1_BuilderAsyncClientProtocol {
  public func createBuild(
    _ request: Com_Apple_Container_Build_V1_CreateBuildRequest,
    callOptions: CallOptions? = nil
  ) async throws -> Com_Apple_Container_Build_V1_CreateBuildResponse {
    return try await self.performAsyncUnaryCall(
      path: Com_Apple_Container_Build_V1_BuilderClientMetadata.Methods.createBuild.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeCreateBuildInterceptors() ?? []
    )
  }

  public func performBuild<RequestStream>(
    _ requests: RequestStream,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncResponseStream<Com_Apple_Container_Build_V1_ServerStream> where RequestStream: Sequence, RequestStream.Element == Com_Apple_Container_Build_V1_ClientStream {
    return self.performAsyncBidirectionalStreamingCall(
      path: Com_Apple_Container_Build_V1_BuilderClientMetadata.Methods.performBuild.path,
      requests: requests,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makePerformBuildInterceptors() ?? []
    )
  }

  public func performBuild<RequestStream>(
    _ requests: RequestStream,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncResponseStream<Com_Apple_Container_Build_V1_ServerStream> where RequestStream: AsyncSequence & Sendable, RequestStream.Element == Com_Apple_Container_Build_V1_ClientStream {
    return self.performAsyncBidirectionalStreamingCall(
      path: Com_Apple_Container_Build_V1_BuilderClientMetadata.Methods.performBuild.path,
      requests: requests,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makePerformBuildInterceptors() ?? []
    )
  }

  public func info(
    _ request: Com_Apple_Container_Build_V1_InfoRequest,
    callOptions: CallOptions? = nil
  ) async throws -> Com_Apple_Container_Build_V1_InfoResponse {
    return try await self.performAsyncUnaryCall(
      path: Com_Apple_Container_Build_V1_BuilderClientMetadata.Methods.info.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeInfoInterceptors() ?? []
    )
  }
}

@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
public struct Com_Apple_Container_Build_V1_BuilderAsyncClient: Com_Apple_Container_Build_V1_BuilderAsyncClientProtocol {
  public var channel: GRPCChannel
  public var defaultCallOptions: CallOptions
  public var interceptors: Com_Apple_Container_Build_V1_BuilderClientInterceptorFactoryProtocol?

  public init(
    channel: GRPCChannel,
    defaultCallOptions: CallOptions = CallOptions(),
    interceptors: Com_Apple_Container_Build_V1_BuilderClientInterceptorFactoryProtocol? = nil
  ) {
    self.channel = channel
    self.defaultCallOptions = defaultCallOptions
    self.interceptors = interceptors
  }
}

public protocol Com_Apple_Container_Build_V1_BuilderClientInterceptorFactoryProtocol: Sendable {

  /// - Returns: Interceptors to use when invoking 'createBuild'.
  func makeCreateBuildInterceptors() -> [ClientInterceptor<Com_Apple_Container_Build_V1_CreateBuildRequest, Com_Apple_Container_Build_V1_CreateBuildResponse>]

  /// - Returns: Interceptors to use when invoking 'performBuild'.
  func makePerformBuildInterceptors() -> [ClientInterceptor<Com_Apple_Container_Build_V1_ClientStream, Com_Apple_Container_Build_V1_ServerStream>]

  /// - Returns: Interceptors to use when invoking 'info'.
  func makeInfoInterceptors() -> [ClientInterceptor<Com_Apple_Container_Build_V1_InfoRequest, Com_Apple_Container_Build_V1_InfoResponse>]
}

public enum Com_Apple_Container_Build_V1_BuilderClientMetadata {
  public static let serviceDescriptor = GRPCServiceDescriptor(
    name: "Builder",
    fullName: "com.apple.container.build.v1.Builder",
    methods: [
      Com_Apple_Container_Build_V1_BuilderClientMetadata.Methods.createBuild,
      Com_Apple_Container_Build_V1_BuilderClientMetadata.Methods.performBuild,
      Com_Apple_Container_Build_V1_BuilderClientMetadata.Methods.info,
    ]
  )

  public enum Methods {
    public static let createBuild = GRPCMethodDescriptor(
      name: "CreateBuild",
      path: "/com.apple.container.build.v1.Builder/CreateBuild",
      type: GRPCCallType.unary
    )

    public static let performBuild = GRPCMethodDescriptor(
      name: "PerformBuild",
      path: "/com.apple.container.build.v1.Builder/PerformBuild",
      type: GRPCCallType.bidirectionalStreaming
    )

    public static let info = GRPCMethodDescriptor(
      name: "Info",
      path: "/com.apple.container.build.v1.Builder/Info",
      type: GRPCCallType.unary
    )
  }
}

/// Builder service implements APIs for performing an image build with
/// Container image builder agent.
///
/// To perform a build:
///
/// 1. CreateBuild to create a new build
/// 2. StartBuild to start the build execution where client and server
///    both have a stream for exchanging data during the build.
///
///    The client may send:
///      a) signal packet to signal to the build process (e.g. SIGINT)
///
///      b) command packet for executing a command in the build file on the
///      server
///         NOTE: the server will need to switch on the command to determine the
///         type of command to execute (e.g. RUN, ENV, etc.)
///
///      c) transfer build data either to or from the server
///         - INTO direction is for sending build data to the server at specific
///         location (e.g. COPY)
///         - OUTOF direction is for copying build data from the server to be
///         used in subsequent build stages
///
///      d) transfer image content data either to or from the server
///         - INTO direction is for sending inherited image content data to the
///         server's local content store
///         - OUTOF direction is for copying successfully built OCI image from
///         the server to the client
///
///    The server may send:
///      a) stdio packet for the build progress
///
///      b) build error indicating unsuccessful build
///
///      c) command complete packet indicating a command has finished executing
///
///      d) handle transfer build data either to or from the client
///
///      e) handle transfer image content data either to or from the client
///
///
///    NOTE: The build data and image content data transfer is ALWAYS initiated
///    by the client.
///
///    Sequence for transferring from the client to the server:
///      1. client send a BuildTransfer/ImageTransfer request with ID, direction
///      of 'INTO',
///         destination path, and first chunk of data
///      2. server starts to receive the data and stream to a temporary file
///      3. client continues to send all chunks of data until last chunk, which
///      client will
///         send with 'complete' set to true
///      4. server continues to receive until the last chunk with 'complete' set
///      to true,
///         server will finish writing the last chunk and un-archive the
///         temporary file to the destination path
///      5. server completes the transfer by sending a last
///      BuildTransfer/ImageTransfer with
///         'complete' set to true
///      6. client waits for the last BuildTransfer/ImageTransfer with 'complete'
///      set to true
///         before proceeding with the rest of the commands
///
///    Sequence for transferring from the server to the client:
///      1. client send a BuildTransfer/ImageTransfer request with ID, direction
///      of 'OUTOF',
///         source path, and empty data
///      2. server archives the data at source path, and starts to send chunks to
///      the client
///      3. server continues to send all chunks until last chunk, which server
///      will send with
///         'complete' set to true
///      4. client starts to receive the data and stream to a temporary file
///      5. client continues to receive until the last chunk with 'complete' set
///      to true,
///         client will finish writing last chunk and un-archive the temporary
///         file to the destination path
///      6. client MAY choose to send one last BuildTransfer/ImageTransfer with
///      'complete'
///         set to true, but NOT required.
///
///
///    NOTE: the client should close the send stream once it has finished
///    receiving the build output or abandon the current build due to error.
///    Server should keep the stream open until it receives the EOF that client
///    has closed the stream, which the server should then close its send stream.
///
/// To build a server, implement a class that conforms to this protocol.
public protocol Com_Apple_Container_Build_V1_BuilderProvider: CallHandlerProvider {
  var interceptors: Com_Apple_Container_Build_V1_BuilderServerInterceptorFactoryProtocol? { get }

  /// Create a build request.
  func createBuild(request: Com_Apple_Container_Build_V1_CreateBuildRequest, context: StatusOnlyCallContext) -> EventLoopFuture<Com_Apple_Container_Build_V1_CreateBuildResponse>

  /// Perform the build.
  /// Executes the entire build sequence with attaching input/output
  /// to handling data exchange with the server during the build.
  func performBuild(context: StreamingResponseCallContext<Com_Apple_Container_Build_V1_ServerStream>) -> EventLoopFuture<(StreamEvent<Com_Apple_Container_Build_V1_ClientStream>) -> Void>

  func info(request: Com_Apple_Container_Build_V1_InfoRequest, context: StatusOnlyCallContext) -> EventLoopFuture<Com_Apple_Container_Build_V1_InfoResponse>
}

extension Com_Apple_Container_Build_V1_BuilderProvider {
  public var serviceName: Substring {
    return Com_Apple_Container_Build_V1_BuilderServerMetadata.serviceDescriptor.fullName[...]
  }

  /// Determines, calls and returns the appropriate request handler, depending on the request's method.
  /// Returns nil for methods not handled by this service.
  public func handle(
    method name: Substring,
    context: CallHandlerContext
  ) -> GRPCServerHandlerProtocol? {
    switch name {
    case "CreateBuild":
      return UnaryServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Com_Apple_Container_Build_V1_CreateBuildRequest>(),
        responseSerializer: ProtobufSerializer<Com_Apple_Container_Build_V1_CreateBuildResponse>(),
        interceptors: self.interceptors?.makeCreateBuildInterceptors() ?? [],
        userFunction: self.createBuild(request:context:)
      )

    case "PerformBuild":
      return BidirectionalStreamingServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Com_Apple_Container_Build_V1_ClientStream>(),
        responseSerializer: ProtobufSerializer<Com_Apple_Container_Build_V1_ServerStream>(),
        interceptors: self.interceptors?.makePerformBuildInterceptors() ?? [],
        observerFactory: self.performBuild(context:)
      )

    case "Info":
      return UnaryServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Com_Apple_Container_Build_V1_InfoRequest>(),
        responseSerializer: ProtobufSerializer<Com_Apple_Container_Build_V1_InfoResponse>(),
        interceptors: self.interceptors?.makeInfoInterceptors() ?? [],
        userFunction: self.info(request:context:)
      )

    default:
      return nil
    }
  }
}

/// Builder service implements APIs for performing an image build with
/// Container image builder agent.
///
/// To perform a build:
///
/// 1. CreateBuild to create a new build
/// 2. StartBuild to start the build execution where client and server
///    both have a stream for exchanging data during the build.
///
///    The client may send:
///      a) signal packet to signal to the build process (e.g. SIGINT)
///
///      b) command packet for executing a command in the build file on the
///      server
///         NOTE: the server will need to switch on the command to determine the
///         type of command to execute (e.g. RUN, ENV, etc.)
///
///      c) transfer build data either to or from the server
///         - INTO direction is for sending build data to the server at specific
///         location (e.g. COPY)
///         - OUTOF direction is for copying build data from the server to be
///         used in subsequent build stages
///
///      d) transfer image content data either to or from the server
///         - INTO direction is for sending inherited image content data to the
///         server's local content store
///         - OUTOF direction is for copying successfully built OCI image from
///         the server to the client
///
///    The server may send:
///      a) stdio packet for the build progress
///
///      b) build error indicating unsuccessful build
///
///      c) command complete packet indicating a command has finished executing
///
///      d) handle transfer build data either to or from the client
///
///      e) handle transfer image content data either to or from the client
///
///
///    NOTE: The build data and image content data transfer is ALWAYS initiated
///    by the client.
///
///    Sequence for transferring from the client to the server:
///      1. client send a BuildTransfer/ImageTransfer request with ID, direction
///      of 'INTO',
///         destination path, and first chunk of data
///      2. server starts to receive the data and stream to a temporary file
///      3. client continues to send all chunks of data until last chunk, which
///      client will
///         send with 'complete' set to true
///      4. server continues to receive until the last chunk with 'complete' set
///      to true,
///         server will finish writing the last chunk and un-archive the
///         temporary file to the destination path
///      5. server completes the transfer by sending a last
///      BuildTransfer/ImageTransfer with
///         'complete' set to true
///      6. client waits for the last BuildTransfer/ImageTransfer with 'complete'
///      set to true
///         before proceeding with the rest of the commands
///
///    Sequence for transferring from the server to the client:
///      1. client send a BuildTransfer/ImageTransfer request with ID, direction
///      of 'OUTOF',
///         source path, and empty data
///      2. server archives the data at source path, and starts to send chunks to
///      the client
///      3. server continues to send all chunks until last chunk, which server
///      will send with
///         'complete' set to true
///      4. client starts to receive the data and stream to a temporary file
///      5. client continues to receive until the last chunk with 'complete' set
///      to true,
///         client will finish writing last chunk and un-archive the temporary
///         file to the destination path
///      6. client MAY choose to send one last BuildTransfer/ImageTransfer with
///      'complete'
///         set to true, but NOT required.
///
///
///    NOTE: the client should close the send stream once it has finished
///    receiving the build output or abandon the current build due to error.
///    Server should keep the stream open until it receives the EOF that client
///    has closed the stream, which the server should then close its send stream.
///
/// To implement a server, implement an object which conforms to this protocol.
@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
public protocol Com_Apple_Container_Build_V1_BuilderAsyncProvider: CallHandlerProvider, Sendable {
  static var serviceDescriptor: GRPCServiceDescriptor { get }
  var interceptors: Com_Apple_Container_Build_V1_BuilderServerInterceptorFactoryProtocol? { get }

  /// Create a build request.
  func createBuild(
    request: Com_Apple_Container_Build_V1_CreateBuildRequest,
    context: GRPCAsyncServerCallContext
  ) async throws -> Com_Apple_Container_Build_V1_CreateBuildResponse

  /// Perform the build.
  /// Executes the entire build sequence with attaching input/output
  /// to handling data exchange with the server during the build.
  func performBuild(
    requestStream: GRPCAsyncRequestStream<Com_Apple_Container_Build_V1_ClientStream>,
    responseStream: GRPCAsyncResponseStreamWriter<Com_Apple_Container_Build_V1_ServerStream>,
    context: GRPCAsyncServerCallContext
  ) async throws

  func info(
    request: Com_Apple_Container_Build_V1_InfoRequest,
    context: GRPCAsyncServerCallContext
  ) async throws -> Com_Apple_Container_Build_V1_InfoResponse
}

@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
extension Com_Apple_Container_Build_V1_BuilderAsyncProvider {
  public static var serviceDescriptor: GRPCServiceDescriptor {
    return Com_Apple_Container_Build_V1_BuilderServerMetadata.serviceDescriptor
  }

  public var serviceName: Substring {
    return Com_Apple_Container_Build_V1_BuilderServerMetadata.serviceDescriptor.fullName[...]
  }

  public var interceptors: Com_Apple_Container_Build_V1_BuilderServerInterceptorFactoryProtocol? {
    return nil
  }

  public func handle(
    method name: Substring,
    context: CallHandlerContext
  ) -> GRPCServerHandlerProtocol? {
    switch name {
    case "CreateBuild":
      return GRPCAsyncServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Com_Apple_Container_Build_V1_CreateBuildRequest>(),
        responseSerializer: ProtobufSerializer<Com_Apple_Container_Build_V1_CreateBuildResponse>(),
        interceptors: self.interceptors?.makeCreateBuildInterceptors() ?? [],
        wrapping: { try await self.createBuild(request: $0, context: $1) }
      )

    case "PerformBuild":
      return GRPCAsyncServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Com_Apple_Container_Build_V1_ClientStream>(),
        responseSerializer: ProtobufSerializer<Com_Apple_Container_Build_V1_ServerStream>(),
        interceptors: self.interceptors?.makePerformBuildInterceptors() ?? [],
        wrapping: { try await self.performBuild(requestStream: $0, responseStream: $1, context: $2) }
      )

    case "Info":
      return GRPCAsyncServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Com_Apple_Container_Build_V1_InfoRequest>(),
        responseSerializer: ProtobufSerializer<Com_Apple_Container_Build_V1_InfoResponse>(),
        interceptors: self.interceptors?.makeInfoInterceptors() ?? [],
        wrapping: { try await self.info(request: $0, context: $1) }
      )

    default:
      return nil
    }
  }
}

public protocol Com_Apple_Container_Build_V1_BuilderServerInterceptorFactoryProtocol: Sendable {

  /// - Returns: Interceptors to use when handling 'createBuild'.
  ///   Defaults to calling `self.makeInterceptors()`.
  func makeCreateBuildInterceptors() -> [ServerInterceptor<Com_Apple_Container_Build_V1_CreateBuildRequest, Com_Apple_Container_Build_V1_CreateBuildResponse>]

  /// - Returns: Interceptors to use when handling 'performBuild'.
  ///   Defaults to calling `self.makeInterceptors()`.
  func makePerformBuildInterceptors() -> [ServerInterceptor<Com_Apple_Container_Build_V1_ClientStream, Com_Apple_Container_Build_V1_ServerStream>]

  /// - Returns: Interceptors to use when handling 'info'.
  ///   Defaults to calling `self.makeInterceptors()`.
  func makeInfoInterceptors() -> [ServerInterceptor<Com_Apple_Container_Build_V1_InfoRequest, Com_Apple_Container_Build_V1_InfoResponse>]
}

public enum Com_Apple_Container_Build_V1_BuilderServerMetadata {
  public static let serviceDescriptor = GRPCServiceDescriptor(
    name: "Builder",
    fullName: "com.apple.container.build.v1.Builder",
    methods: [
      Com_Apple_Container_Build_V1_BuilderServerMetadata.Methods.createBuild,
      Com_Apple_Container_Build_V1_BuilderServerMetadata.Methods.performBuild,
      Com_Apple_Container_Build_V1_BuilderServerMetadata.Methods.info,
    ]
  )

  public enum Methods {
    public static let createBuild = GRPCMethodDescriptor(
      name: "CreateBuild",
      path: "/com.apple.container.build.v1.Builder/CreateBuild",
      type: GRPCCallType.unary
    )

    public static let performBuild = GRPCMethodDescriptor(
      name: "PerformBuild",
      path: "/com.apple.container.build.v1.Builder/PerformBuild",
      type: GRPCCallType.bidirectionalStreaming
    )

    public static let info = GRPCMethodDescriptor(
      name: "Info",
      path: "/com.apple.container.build.v1.Builder/Info",
      type: GRPCCallType.unary
    )
  }
}
