/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.testing.ElementTypesAreNonnullByDefault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public class TestLogHandler
extends Handler {
    private final List<LogRecord> list = new ArrayList<LogRecord>();

    @Override
    public synchronized void publish(@Nullable LogRecord record) {
        if (record != null) {
            this.list.add(record);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public synchronized void clear() {
        this.list.clear();
    }

    public synchronized List<LogRecord> getStoredLogRecords() {
        ArrayList<LogRecord> result = new ArrayList<LogRecord>(this.list);
        return Collections.unmodifiableList(result);
    }
}

