/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.lookup;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.lookup.CanonicalSymbolResolver;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.tree.Tree;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class MemberImportIndex {
    private final Map<String, Supplier<@Nullable ClassSymbol>> cache = new LinkedHashMap<String, Supplier<ClassSymbol>>();
    private final ImmutableList<Supplier<@Nullable ClassSymbol>> classes;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public MemberImportIndex(final SourceFile source, final CanonicalSymbolResolver resolve, final TopLevelIndex tli, ImmutableList<Tree.ImportDecl> imports) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ImmutableList.Builder packageScopes = ImmutableList.builder();
        for (final Tree.ImportDecl i : imports) {
            if (!i.stat()) continue;
            if (i.wild()) {
                packageScopes.add((Object)Suppliers.memoize((Supplier)new Supplier<ClassSymbol>(){

                    public @Nullable ClassSymbol get() {
                        LookupResult result = tli.scope().lookup(new LookupKey(i.type()));
                        if (result == null) {
                            return null;
                        }
                        ClassSymbol sym = (ClassSymbol)result.sym();
                        for (Tree.Ident bit : result.remaining()) {
                            sym = MemberImportIndex.resolveNext(resolve, source, i.position(), sym, bit);
                        }
                        return sym;
                    }
                }));
                continue;
            }
            this.cache.put(((Tree.Ident)Iterables.getLast(i.type())).value(), (Supplier<ClassSymbol>)Suppliers.memoize((Supplier)new Supplier<ClassSymbol>(){

                public @Nullable ClassSymbol get() {
                    LookupResult result = tli.scope().lookup(new LookupKey(i.type()));
                    if (result == null) {
                        return null;
                    }
                    ClassSymbol sym = (ClassSymbol)result.sym();
                    for (int i2 = 0; i2 < result.remaining().size() - 1; ++i2) {
                        if (sym == null) {
                            return null;
                        }
                        sym = resolve.resolveOne(sym, (Tree.Ident)result.remaining().get(i2));
                    }
                    return sym;
                }
            }));
        }
        this.classes = packageScopes.build();
    }

    private static ClassSymbol resolveNext(CanonicalSymbolResolver resolve, SourceFile source, int position, ClassSymbol sym, Tree.Ident bit) {
        ClassSymbol next = resolve.resolveOne(sym, bit);
        if (next == null) {
            throw TurbineError.format(source, position, TurbineError.ErrorKind.SYMBOL_NOT_FOUND, new ClassSymbol(sym.binaryName() + "$" + String.valueOf(bit)));
        }
        return next;
    }

    public @Nullable ClassSymbol singleMemberImport(String simpleName) {
        Supplier<@Nullable ClassSymbol> cachedResult = this.cache.get(simpleName);
        return cachedResult != null ? (ClassSymbol)cachedResult.get() : null;
    }

    public Iterator<ClassSymbol> onDemandImports() {
        return new WildcardSymbols((Iterator<Supplier<ClassSymbol>>)this.classes.iterator());
    }

    private static class WildcardSymbols
    implements Iterator<ClassSymbol> {
        private final Iterator<Supplier<ClassSymbol>> it;

        public WildcardSymbols(Iterator<Supplier<ClassSymbol>> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public ClassSymbol next() {
            return (ClassSymbol)this.it.next().get();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

