/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.lookup;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.lookup.CanonicalSymbolResolver;
import com.google.turbine.binder.lookup.ImportScope;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.diag.TurbineLog;
import com.google.turbine.tree.Tree;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class ImportIndex
implements ImportScope {
    private final Map<String, Supplier<ImportScope>> thunks;

    public ImportIndex(TurbineLog.TurbineLogWithSource log, ImmutableMap<String, Supplier<ImportScope>> thunks) {
        this.thunks = thunks;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static ImportIndex create(final TurbineLog.TurbineLogWithSource log, final CanonicalSymbolResolver resolve, final TopLevelIndex cpi, ImmutableList<Tree.ImportDecl> imports) {
        HashMap<String, @Nullable Supplier> thunks = new HashMap<String, Supplier>();
        for (final Tree.ImportDecl i : imports) {
            if (i.stat() || i.wild()) continue;
            thunks.put(((Tree.Ident)Iterables.getLast(i.type())).value(), Suppliers.memoize((Supplier)new Supplier<ImportScope>(){

                public @Nullable ImportScope get() {
                    return ImportIndex.namedImport(log, cpi, i, resolve);
                }
            }));
        }
        for (final Tree.ImportDecl i : imports) {
            if (!i.stat() || i.wild()) continue;
            String last = ((Tree.Ident)Iterables.getLast(i.type())).value();
            thunks.putIfAbsent(last, Suppliers.memoize((Supplier)new Supplier<ImportScope>(){

                public @Nullable ImportScope get() {
                    return ImportIndex.staticNamedImport(log, cpi, i);
                }
            }));
        }
        return new ImportIndex(log, (ImmutableMap<String, Supplier<ImportScope>>)ImmutableMap.copyOf(thunks));
    }

    private static @Nullable ImportScope namedImport(TurbineLog.TurbineLogWithSource log, TopLevelIndex cpi, Tree.ImportDecl i, CanonicalSymbolResolver resolve) {
        LookupResult result = cpi.scope().lookup(new LookupKey(i.type()));
        if (result == null) {
            log.error(i.position(), TurbineError.ErrorKind.SYMBOL_NOT_FOUND, new ClassSymbol(Joiner.on((char)'/').join(i.type())));
            return null;
        }
        ClassSymbol sym = (ClassSymbol)result.sym();
        for (Tree.Ident bit : result.remaining()) {
            if ((sym = ImportIndex.resolveNext(log, resolve, sym, bit)) != null) continue;
            return null;
        }
        final ClassSymbol resolved = sym;
        return new ImportScope(){

            @Override
            public LookupResult lookup(LookupKey lookupKey, ImportScope.ResolveFunction unused) {
                return new LookupResult(resolved, lookupKey);
            }
        };
    }

    private static @Nullable ClassSymbol resolveNext(TurbineLog.TurbineLogWithSource log, CanonicalSymbolResolver resolve, ClassSymbol sym, Tree.Ident bit) {
        ClassSymbol next = resolve.resolveOne(sym, bit);
        if (next == null) {
            log.error(bit.position(), TurbineError.ErrorKind.SYMBOL_NOT_FOUND, new ClassSymbol(sym.binaryName() + "$" + String.valueOf(bit)));
        }
        return next;
    }

    private static @Nullable ImportScope staticNamedImport(TurbineLog.TurbineLogWithSource log, TopLevelIndex cpi, Tree.ImportDecl i) {
        final LookupResult base = cpi.scope().lookup(new LookupKey(i.type()));
        if (base == null) {
            log.error(i.position(), TurbineError.ErrorKind.SYMBOL_NOT_FOUND, new ClassSymbol(Joiner.on((String)"/").join(i.type())));
            return null;
        }
        return new ImportScope(){

            @Override
            public @Nullable LookupResult lookup(LookupKey lookupKey, ImportScope.ResolveFunction resolve) {
                ClassSymbol sym = (ClassSymbol)base.sym();
                for (Tree.Ident bit : base.remaining()) {
                    if ((sym = resolve.resolveOne(sym, bit)) != null) continue;
                    return null;
                }
                return new LookupResult(sym, lookupKey);
            }
        };
    }

    @Override
    public @Nullable LookupResult lookup(LookupKey lookup, ImportScope.ResolveFunction resolve) {
        Supplier<ImportScope> thunk = this.thunks.get(lookup.first().value());
        if (thunk == null) {
            return null;
        }
        ImportScope scope = (ImportScope)thunk.get();
        if (scope == null) {
            return null;
        }
        return scope.lookup(lookup, resolve);
    }
}

