/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.truth.extensions.proto.SubScopeId;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;

class AnyUtils {
    private static final Descriptors.FieldDescriptor TYPE_URL_FIELD_DESCRIPTOR = Any.getDescriptor().findFieldByNumber(1);
    private static final SubScopeId TYPE_URL_SUB_SCOPE_ID = SubScopeId.of(TYPE_URL_FIELD_DESCRIPTOR);
    private static final Descriptors.FieldDescriptor VALUE_FIELD_DESCRIPTOR = Any.getDescriptor().findFieldByNumber(2);
    private static final SubScopeId VALUE_SUB_SCOPE_ID = SubScopeId.of(VALUE_FIELD_DESCRIPTOR);
    private static final TypeRegistry DEFAULT_TYPE_REGISTRY = TypeRegistry.getEmptyTypeRegistry();
    private static final ExtensionRegistry DEFAULT_EXTENSION_REGISTRY = ExtensionRegistry.getEmptyRegistry();

    static Descriptors.FieldDescriptor typeUrlFieldDescriptor() {
        return TYPE_URL_FIELD_DESCRIPTOR;
    }

    static SubScopeId typeUrlSubScopeId() {
        return TYPE_URL_SUB_SCOPE_ID;
    }

    static Descriptors.FieldDescriptor valueFieldDescriptor() {
        return VALUE_FIELD_DESCRIPTOR;
    }

    static SubScopeId valueSubScopeId() {
        return VALUE_SUB_SCOPE_ID;
    }

    static TypeRegistry defaultTypeRegistry() {
        return DEFAULT_TYPE_REGISTRY;
    }

    static ExtensionRegistry defaultExtensionRegistry() {
        return DEFAULT_EXTENSION_REGISTRY;
    }

    static Optional<Message> unpack(Message any, TypeRegistry typeRegistry, ExtensionRegistry extensionRegistry) {
        Preconditions.checkArgument((boolean)any.getDescriptorForType().equals(Any.getDescriptor()), (String)"Expected type google.protobuf.Any, but was: %s", (Object)any.getDescriptorForType().getFullName());
        String typeUrl = (String)any.getField(AnyUtils.typeUrlFieldDescriptor());
        ByteString value = (ByteString)any.getField(AnyUtils.valueFieldDescriptor());
        try {
            Descriptors.Descriptor descriptor = typeRegistry.getDescriptorForTypeUrl(typeUrl);
            if (descriptor == null) {
                return Optional.absent();
            }
            DynamicMessage defaultMessage = DynamicMessage.parseFrom((Descriptors.Descriptor)descriptor, (ByteString)value, (ExtensionRegistry)extensionRegistry);
            return Optional.of((Object)defaultMessage);
        }
        catch (InvalidProtocolBufferException e) {
            return Optional.absent();
        }
    }

    private AnyUtils() {
    }
}

