/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IgnoreJRERequirement;
import com.google.common.truth.Subject;
import java.util.OptionalLong;
import org.checkerframework.checker.nullness.qual.Nullable;

@IgnoreJRERequirement
public final class OptionalLongSubject
extends Subject {
    private final OptionalLong actual;

    OptionalLongSubject(FailureMetadata failureMetadata, @Nullable OptionalLong subject, @Nullable String typeDescription) {
        super(failureMetadata, subject, typeDescription);
        this.actual = subject;
    }

    public void isPresent() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected present optional"), new Fact[0]);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact("expected to be present"), new Fact[0]);
        }
    }

    public void isEmpty() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected empty optional"), new Fact[0]);
        } else if (this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact("expected to be empty"), Fact.fact("but was present with value", this.actual.getAsLong()));
        }
    }

    public void hasValue(long expected) {
        if (this.actual == null) {
            this.failWithActual("expected an optional with value", expected);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.fact("expected to have value", expected), Fact.simpleFact("but was absent"));
        } else {
            this.checkNoNeedToDisplayBothValues("getAsLong()", new Object[0]).that(this.actual.getAsLong()).isEqualTo(expected);
        }
    }

    public static Subject.Factory<OptionalLongSubject, OptionalLong> optionalLongs() {
        return (metadata, subject) -> new OptionalLongSubject(metadata, (OptionalLong)subject, "optionalLong");
    }
}

