/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.errorprone.refaster.AutoValue_ULabeledStatement;
import com.google.errorprone.refaster.Bindings;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.StringName;
import com.google.errorprone.refaster.USimpleStatement;
import com.google.errorprone.refaster.UStatement;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import org.jspecify.annotations.Nullable;

@AutoValue
abstract class ULabeledStatement
extends USimpleStatement
implements LabeledStatementTree {
    ULabeledStatement() {
    }

    static ULabeledStatement create(CharSequence label, UStatement statement) {
        return new AutoValue_ULabeledStatement(StringName.of(label), (USimpleStatement)statement);
    }

    static @Nullable Name inlineLabel(@Nullable CharSequence label, Inliner inliner) {
        return label == null ? null : inliner.asName((CharSequence)inliner.getOptionalBinding(new Key(label)).or((Object)label));
    }

    @Override
    public abstract StringName getLabel();

    @Override
    public abstract USimpleStatement getStatement();

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.LABELED_STATEMENT;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitLabeledStatement(this, data);
    }

    private Key key() {
        return new Key(this.getLabel());
    }

    @Override
    public JCTree.JCLabeledStatement inline(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.maker().Labelled(ULabeledStatement.inlineLabel(this.getLabel(), inliner), (JCTree.JCStatement)this.getStatement().inline(inliner));
    }

    @Override
    public Choice<Unifier> visitLabeledStatement(LabeledStatementTree node, Unifier unifier) {
        unifier.putBinding(this.key(), node.getLabel());
        return this.getStatement().unify(node.getStatement(), unifier);
    }

    static class Key
    extends Bindings.Key<CharSequence> {
        Key(CharSequence identifier) {
            super(identifier.toString());
        }
    }
}

