/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

@BugPattern(summary="@CanIgnoreReturnValue should not be applied to classes as it almost always overmatches (as it applies to constructors and all methods), and the CIRVness isn't conferred to its subclasses.", documentSuppression=false, suppressionAnnotations={}, severity=BugPattern.SeverityLevel.ERROR)
public final class NoCanIgnoreReturnValueOnClasses
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String CRV = "com.google.errorprone.annotations.CheckReturnValue";
    private static final String CIRV = "com.google.errorprone.annotations.CanIgnoreReturnValue";
    private static final String EXTRA_SUFFIX = "";
    @VisibleForTesting
    static final String METHOD_COMMENT = " // pushed down from class to method;";
    @VisibleForTesting
    static final String CTOR_COMMENT = " // pushed down from class to constructor;";
    private static final MultiMatcher<ClassTree, AnnotationTree> HAS_CIRV_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.isType((String)"com.google.errorprone.annotations.CanIgnoreReturnValue"));

    public Description matchClass(ClassTree tree, final VisitorState state) {
        MultiMatcher.MultiMatchResult cirvAnnotation = HAS_CIRV_ANNOTATION.multiMatchResult((Tree)tree, state);
        if (!cirvAnnotation.matches()) {
            return Description.NO_MATCH;
        }
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        final String cirvName = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)CIRV);
        fix.delete(cirvAnnotation.onlyMatchingNode());
        new TreePathScanner<Void, Void>(this){
            final /* synthetic */ NoCanIgnoreReturnValueOnClasses this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitClass(ClassTree classTree, Void unused) {
                return ASTHelpers.hasAnnotation((Tree)classTree, (String)NoCanIgnoreReturnValueOnClasses.CRV, (VisitorState)state) ? null : (Void)super.visitClass(classTree, null);
            }

            @Override
            public Void visitMethod(MethodTree methodTree, Void unused) {
                if (this.shouldAddCirv(methodTree, state)) {
                    String trailingComment = null;
                    trailingComment = methodTree.getReturnType() == null ? NoCanIgnoreReturnValueOnClasses.CTOR_COMMENT : (this.alwaysReturnsThis() ? NoCanIgnoreReturnValueOnClasses.EXTRA_SUFFIX : NoCanIgnoreReturnValueOnClasses.METHOD_COMMENT);
                    fix.prefixWith((Tree)methodTree, "@" + cirvName + trailingComment + "\n");
                }
                return null;
            }

            private boolean alwaysReturnsThis() {
                final AtomicBoolean allReturnThis = new AtomicBoolean(true);
                final AtomicBoolean atLeastOneReturn = new AtomicBoolean(false);
                new TreePathScanner<Void, Void>(this){
                    private final Set<Symbol.VarSymbol> thises = new HashSet<Symbol.VarSymbol>();
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public Void visitVariable(VariableTree variableTree, Void unused) {
                        Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)variableTree);
                        if (ASTHelpers.isConsideredFinal((Symbol)symbol) && this.maybeCastThis(variableTree.getInitializer())) {
                            this.thises.add(symbol);
                        }
                        return (Void)super.visitVariable(variableTree, null);
                    }

                    @Override
                    public Void visitReturn(ReturnTree returnTree, Void unused) {
                        atLeastOneReturn.set(true);
                        if (!this.isThis(returnTree.getExpression())) {
                            allReturnThis.set(false);
                            return null;
                        }
                        return (Void)super.visitReturn(returnTree, null);
                    }

                    private boolean isThis(ExpressionTree returnExpression) {
                        return this.maybeCastThis(returnExpression) || this.thises.contains(ASTHelpers.getSymbol((Tree)returnExpression));
                    }

                    @Override
                    public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                        return null;
                    }

                    @Override
                    public Void visitNewClass(NewClassTree node, Void unused) {
                        return null;
                    }

                    private boolean maybeCastThis(Tree tree) {
                        return (Boolean)MoreObjects.firstNonNull((Object)((Boolean)new SimpleTreeVisitor<Boolean, Void>(){

                            @Override
                            public Boolean visitParenthesized(ParenthesizedTree tree, Void unused) {
                                return (Boolean)this.visit(tree.getExpression(), null);
                            }

                            @Override
                            public Boolean visitTypeCast(TypeCastTree tree, Void unused) {
                                return (Boolean)this.visit(tree.getExpression(), null);
                            }

                            @Override
                            public Boolean visitIdentifier(IdentifierTree tree, Void unused) {
                                return tree.getName().contentEquals("this");
                            }

                            @Override
                            public Boolean visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                                return ((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).contentEquals("self") || ((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).contentEquals("getThis");
                            }
                        }.visit(tree, null)), (Object)false);
                    }
                }.scan(this.getCurrentPath(), (Void)null);
                return allReturnThis.get() && atLeastOneReturn.get();
            }

            private boolean shouldAddCirv(MethodTree methodTree, VisitorState state2) {
                if (ASTHelpers.isVoidType((Type)ASTHelpers.getType((Tree)methodTree.getReturnType()), (VisitorState)state2)) {
                    return false;
                }
                if (ASTHelpers.hasAnnotation((Tree)methodTree, (String)NoCanIgnoreReturnValueOnClasses.CIRV, (VisitorState)state2)) {
                    return false;
                }
                if (ASTHelpers.hasAnnotation((Tree)methodTree, (String)NoCanIgnoreReturnValueOnClasses.CRV, (VisitorState)state2)) {
                    return false;
                }
                if (ASTHelpers.isGeneratedConstructor((MethodTree)methodTree)) {
                    return false;
                }
                Symbol.ClassSymbol enclosingClass = ASTHelpers.enclosingClass((Symbol)ASTHelpers.getSymbol((MethodTree)methodTree));
                return !ASTHelpers.hasAnnotation((Symbol)enclosingClass, (String)"com.google.auto.value.AutoValue", (VisitorState)state2) && !ASTHelpers.hasAnnotation((Symbol)enclosingClass, (String)"com.google.auto.value.AutoValue.Builder", (VisitorState)state2) || methodTree.getBody() != null;
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                return null;
            }

            @Override
            public Void visitNewClass(NewClassTree node, Void unused) {
                return null;
            }
        }.scan(state.getPath(), (Void)null);
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

