/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Name;

@BugPattern(summary="`super.equals(obj)` and `super.hashCode()` are often bugs when they call the methods defined in `java.lang.Object`", severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"}, altNames={"SuperEqualsIsObjectEquals"})
public class SuperCallToObjectMethod
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree methodSelect = tree.getMethodSelect();
        if (methodSelect.getKind() != Tree.Kind.MEMBER_SELECT) {
            return Description.NO_MATCH;
        }
        MemberSelectTree memberSelect = (MemberSelectTree)methodSelect;
        ExpressionTree expression = memberSelect.getExpression();
        Name methodName = memberSelect.getIdentifier();
        boolean methodIsEquals = methodName.equals(state.getNames().equals);
        boolean methodIsHashCode = methodName.equals(state.getNames().hashCode);
        if (expression.getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)expression).getName().equals(state.getNames()._super) && ASTHelpers.enclosingClass((Symbol)ASTHelpers.getSymbol((MethodInvocationTree)tree)) == state.getSymtab().objectType.tsym && (methodIsEquals || methodIsHashCode) && !SuperCallToObjectMethod.methodBodyIsOnlyReturnSuper(state)) {
            String fix = methodIsEquals ? SuperCallToObjectMethod.maybeParenthesize("this == " + state.getSourceForNode((Tree)Iterables.getOnlyElement(tree.getArguments())), state) : "System.identityHashCode(this)";
            String message = methodIsEquals ? "`super.equals(obj)` is equivalent to `this == obj` here" : "`super.hashCode()` is equivalent to `System.identityHashCode(this)` here";
            return this.buildDescription(tree).setMessage(message).addFix((Fix)SuggestedFix.replace((Tree)tree, (String)fix)).build();
        }
        return Description.NO_MATCH;
    }

    private static String maybeParenthesize(String s, VisitorState state) {
        return state.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.LOGICAL_COMPLEMENT ? "(" + s + ")" : s;
    }

    private static boolean methodBodyIsOnlyReturnSuper(VisitorState state) {
        TreePath parentPath = state.getPath().getParentPath();
        if (parentPath.getLeaf().getKind() != Tree.Kind.RETURN) {
            return false;
        }
        TreePath grandparentPath = parentPath.getParentPath();
        Tree grandparent = grandparentPath.getLeaf();
        if (grandparent.getKind() != Tree.Kind.BLOCK) {
            return false;
        }
        if (((BlockTree)grandparent).getStatements().size() > 1) {
            return false;
        }
        Tree greatGrandparent = grandparentPath.getParentPath().getLeaf();
        return greatGrandparent.getKind() == Tree.Kind.METHOD;
    }
}

