/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Type;
import java.util.Optional;

@BugPattern(summary="Using an Optional variable which is expected to possibly be null is discouraged. It is best to indicate the absence of the value by assigning it an empty optional.", severity=BugPattern.SeverityLevel.WARNING)
public final class NullableOptional
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final TypePredicate IS_OPTIONAL_TYPE = TypePredicates.isExactTypeAny((Iterable)ImmutableSet.of((Object)Optional.class.getCanonicalName(), (Object)com.google.common.base.Optional.class.getCanonicalName()));

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (NullableOptional.hasNullableAnnotation(tree.getModifiers()) && NullableOptional.isOptional(ASTHelpers.getType((Tree)tree.getReturnType()), state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (NullableOptional.hasNullableAnnotation(tree.getModifiers()) && NullableOptional.isOptional(ASTHelpers.getType((Tree)tree), state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static boolean hasNullableAnnotation(ModifiersTree modifiersTree) {
        return ASTHelpers.getAnnotationWithSimpleName(modifiersTree.getAnnotations(), (String)"Nullable") != null;
    }

    private static boolean isOptional(Type type, VisitorState state) {
        return IS_OPTIONAL_TYPE.apply(type, state);
    }
}

