/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.errorprone.bugpatterns.AutoValue_AbstractMustBeClosedChecker_Change;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.UnusedReturnValueMatcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;
import org.jspecify.annotations.Nullable;

public abstract class AbstractMustBeClosedChecker
extends BugChecker {
    private static final String MUST_BE_CLOSED_ANNOTATION_NAME = MustBeClosed.class.getCanonicalName();
    protected static final Matcher<Tree> HAS_MUST_BE_CLOSED_ANNOTATION = Matchers.symbolHasAnnotation((String)MUST_BE_CLOSED_ANNOTATION_NAME);
    private static final Matcher<ExpressionTree> CLOSE_METHOD = Matchers.instanceMethod().onDescendantOf("java.lang.AutoCloseable").named("close");
    private static final Matcher<Tree> MOCKITO_MATCHER = Matchers.toType(MethodInvocationTree.class, (Matcher)MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("when"));

    protected Description scanEntireMethodFor(final Matcher<? super ExpressionTree> matcher, MethodTree tree, VisitorState state) {
        BlockTree body = tree.getBody();
        if (body == null) {
            return Description.NO_MATCH;
        }
        final SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        final NameSuggester suggester = new NameSuggester();
        HashMultiset closeBraceLocations = HashMultiset.create();
        Tree[] firstIssuedFixLocation = new Tree[1];
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state, (Multiset)closeBraceLocations, firstIssuedFixLocation){
            final /* synthetic */ Multiset val$closeBraceLocations;
            final /* synthetic */ Tree[] val$firstIssuedFixLocation;
            final /* synthetic */ AbstractMustBeClosedChecker this$0;
            {
                this.val$closeBraceLocations = multiset;
                this.val$firstIssuedFixLocation = treeArray;
                this.this$0 = this$0;
                super((BugChecker)this$0, state);
            }

            public Void visitMethod(MethodTree methodTree, Void aVoid) {
                return null;
            }

            private void visitNewClassOrMethodInvocation(ExpressionTree tree) {
                VisitorState localState = this.state.withPath(this.getCurrentPath());
                if (matcher.matches((Tree)tree, localState)) {
                    this.this$0.matchNewClassOrMethodInvocation(tree, localState, suggester).ifPresent(change -> {
                        fixBuilder.merge(change.otherFixes());
                        change.closeBraceAfter().ifPresent(arg_0 -> ((Multiset)this.val$closeBraceLocations).add(arg_0));
                        if (this.val$firstIssuedFixLocation[0] == null) {
                            this.val$firstIssuedFixLocation[0] = tree;
                        }
                    });
                }
            }

            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                this.visitNewClassOrMethodInvocation(tree);
                return (Void)super.visitMethodInvocation(tree, null);
            }

            public Void visitNewClass(NewClassTree tree, Void unused) {
                this.visitNewClassOrMethodInvocation(tree);
                return (Void)super.visitNewClass(tree, null);
            }
        }.scan(new TreePath(state.getPath(), body), null);
        if (firstIssuedFixLocation[0] == null) {
            return Description.NO_MATCH;
        }
        closeBraceLocations.forEachEntry((t, count) -> fixBuilder.postfixWith(t, "}".repeat(count)));
        return this.describeMatch(firstIssuedFixLocation[0], (Fix)fixBuilder.build());
    }

    private final Optional<Change> matchNewClassOrMethodInvocation(ExpressionTree tree, VisitorState state, NameSuggester suggester) {
        if (ASTHelpers.isInStaticInitializer((VisitorState)state)) {
            return Optional.empty();
        }
        return this.checkClosed(tree, state, suggester).filter(unusedFix -> !UnusedReturnValueMatcher.expectedExceptionTest((VisitorState)state) && !UnusedReturnValueMatcher.mockitoInvocation((Tree)tree, (VisitorState)state) && !MOCKITO_MATCHER.matches(state.getPath().getParentPath().getLeaf(), state) && !this.exemptChange(tree, state));
    }

    @ForOverride
    protected boolean exemptChange(ExpressionTree tree, VisitorState state) {
        return false;
    }

    private Optional<Change> checkClosed(ExpressionTree tree, VisitorState state, NameSuggester suggester) {
        MethodTree callerMethodTree = AbstractMustBeClosedChecker.enclosingMethod(state);
        TreePath path = state.getPath();
        block8: while (true) {
            TreePath prev = path;
            path = path.getParentPath();
            switch (path.getLeaf().getKind()) {
                case RETURN: {
                    if (callerMethodTree != null) {
                        if (HAS_MUST_BE_CLOSED_ANNOTATION.matches((Tree)callerMethodTree, state)) {
                            return Optional.empty();
                        }
                        return Change.of(SuggestedFix.builder().prefixWith((Tree)callerMethodTree, "@MustBeClosed\n").addImport(MustBeClosed.class.getCanonicalName()).build());
                    }
                    return AbstractMustBeClosedChecker.handleTailPositionInLambda(state);
                }
                case LAMBDA_EXPRESSION: {
                    return AbstractMustBeClosedChecker.handleTailPositionInLambda(state);
                }
                case CONDITIONAL_EXPRESSION: {
                    ConditionalExpressionTree conditionalExpressionTree = (ConditionalExpressionTree)path.getLeaf();
                    if (!conditionalExpressionTree.getTrueExpression().equals(prev.getLeaf()) && !conditionalExpressionTree.getFalseExpression().equals(prev.getLeaf())) break block8;
                    continue block8;
                }
                case MEMBER_SELECT: {
                    MemberSelectTree memberSelectTree = (MemberSelectTree)path.getLeaf();
                    if (!memberSelectTree.getExpression().equals(prev.getLeaf())) break block8;
                    Type type = ASTHelpers.getType((Tree)memberSelectTree);
                    Symbol sym = ASTHelpers.getSymbol((Tree)memberSelectTree);
                    Type streamType = state.getTypeFromString(Stream.class.getName());
                    if (!ASTHelpers.isSubtype((Type)sym.enclClass().asType(), (Type)streamType, (VisitorState)state) || !ASTHelpers.isSameType((Type)type.getReturnType(), (Type)streamType, (VisitorState)state)) break block8;
                    path = path.getParentPath();
                    continue block8;
                }
                case VARIABLE: {
                    Symbol.VarSymbol var;
                    Symbol sym = ASTHelpers.getSymbol((Tree)path.getLeaf());
                    if (!(sym instanceof Symbol.VarSymbol) || (var = (Symbol.VarSymbol)sym).getKind() != ElementKind.RESOURCE_VARIABLE && !AbstractMustBeClosedChecker.isClosedInFinallyClause(var, path, state) && !ASTHelpers.variableIsStaticFinal((Symbol.VarSymbol)var)) break block8;
                    return Optional.empty();
                }
                case ASSIGNMENT: {
                    return AbstractMustBeClosedChecker.findingWithNoFix();
                }
            }
            break;
        }
        return this.fix(tree, state, suggester);
    }

    protected Optional<Change> fix(ExpressionTree tree, VisitorState state, NameSuggester suggester) {
        return AbstractMustBeClosedChecker.chooseFixType(tree, state, suggester);
    }

    private static Optional<Change> handleTailPositionInLambda(VisitorState state) {
        LambdaExpressionTree lambda = (LambdaExpressionTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), LambdaExpressionTree.class);
        if (lambda == null) {
            return AbstractMustBeClosedChecker.findingWithNoFix();
        }
        if (ASTHelpers.hasAnnotation((Symbol)state.getTypes().findDescriptorSymbol(ASTHelpers.getType((Tree)lambda).tsym), (String)MUST_BE_CLOSED_ANNOTATION_NAME, (VisitorState)state)) {
            return Optional.empty();
        }
        return AbstractMustBeClosedChecker.findingWithNoFix();
    }

    private static Optional<Change> findingWithNoFix() {
        return Change.of(SuggestedFix.emptyFix());
    }

    private static @Nullable MethodTree enclosingMethod(VisitorState state) {
        for (Tree node : state.getPath().getParentPath()) {
            switch (node.getKind()) {
                case NEW_CLASS: 
                case LAMBDA_EXPRESSION: {
                    return null;
                }
                case METHOD: {
                    return (MethodTree)node;
                }
            }
        }
        return null;
    }

    private static boolean isClosedInFinallyClause(final Symbol.VarSymbol var, TreePath path, final VisitorState state) {
        if (!ASTHelpers.isConsideredFinal((Symbol)var)) {
            return false;
        }
        Tree parent = path.getParentPath().getLeaf();
        if (parent.getKind() != Tree.Kind.BLOCK) {
            return false;
        }
        BlockTree block = (BlockTree)parent;
        int idx = block.getStatements().indexOf(path.getLeaf());
        if (idx == -1 || idx == block.getStatements().size() - 1) {
            return false;
        }
        StatementTree next = block.getStatements().get(idx + 1);
        if (!(next instanceof TryTree)) {
            return false;
        }
        TryTree tryTree = (TryTree)next;
        if (tryTree.getFinallyBlock() == null) {
            return false;
        }
        final boolean[] closed = new boolean[]{false};
        tryTree.getFinallyBlock().accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                if (CLOSE_METHOD.matches((Tree)tree, state) && Objects.equals(ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)), var)) {
                    closed[0] = true;
                }
                return null;
            }
        }, null);
        return closed[0];
    }

    private static Optional<Change> chooseFixType(ExpressionTree tree, VisitorState state, NameSuggester suggester) {
        TreePath path = state.getPath();
        Tree parent = path.getParentPath().getLeaf();
        if (parent instanceof VariableTree) {
            return AbstractMustBeClosedChecker.wrapTryFinallyAroundVariableScope((VariableTree)parent, state);
        }
        StatementTree stmt = (StatementTree)state.findEnclosing(new Class[]{StatementTree.class});
        if (stmt == null) {
            return Optional.empty();
        }
        if (!(stmt instanceof VariableTree)) {
            return AbstractMustBeClosedChecker.introduceSingleStatementTry(tree, stmt, state, suggester);
        }
        Symbol.VarSymbol varSym = ASTHelpers.getSymbol((VariableTree)((VariableTree)stmt));
        if (varSym.getKind() == ElementKind.RESOURCE_VARIABLE) {
            return AbstractMustBeClosedChecker.extractToResourceInCurrentTry(tree, stmt, state, suggester);
        }
        return AbstractMustBeClosedChecker.splitVariableDeclarationAroundTry(tree, (VariableTree)stmt, state, suggester);
    }

    private static Optional<Change> introduceSingleStatementTry(ExpressionTree tree, StatementTree stmt, VisitorState state, NameSuggester suggester) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String name = suggester.suggestName(tree);
        if (state.getPath().getParentPath().getLeaf() instanceof ExpressionStatementTree) {
            fix.delete((Tree)stmt);
        } else {
            fix.replace((Tree)tree, name);
        }
        return Change.builder(fix.prefixWith((Tree)stmt, String.format("try (var %s = %s) {", name, state.getSourceForNode((Tree)tree))).build()).closeBraceAfter(stmt).wrapped();
    }

    private static Optional<Change> extractToResourceInCurrentTry(ExpressionTree tree, StatementTree declaringStatement, VisitorState state, NameSuggester suggester) {
        Type type = ASTHelpers.getType((Tree)tree);
        if (type == null) {
            return Optional.empty();
        }
        String name = suggester.suggestName(tree);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        return Change.of(SuggestedFix.builder().prefixWith((Tree)declaringStatement, String.format("%s %s = %s;", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (TypeMirror)type), name, state.getSourceForNode((Tree)tree))).replace((Tree)tree, name).build());
    }

    private static Optional<Change> splitVariableDeclarationAroundTry(ExpressionTree tree, VariableTree var, VisitorState state, NameSuggester suggester) {
        String typePrefix;
        int startPos;
        int initPos = ASTHelpers.getStartPosition((Tree)var.getInitializer());
        Tree type = var.getType();
        if (ASTHelpers.hasExplicitSource((Tree)type, (VisitorState)state)) {
            startPos = state.getEndPosition(type);
            typePrefix = "";
        } else {
            startPos = ASTHelpers.getStartPosition((Tree)var);
            typePrefix = SuggestedFixes.prettyType((Type)ASTHelpers.getType((Tree)type), (VisitorState)state);
        }
        String name = suggester.suggestName(tree);
        return Change.builder(SuggestedFix.builder().replace(startPos, initPos, String.format("%s %s;\ntry (var %s = %s) {\n%s =", typePrefix, var.getName(), name, state.getSourceForNode((Tree)tree), var.getName())).replace((Tree)tree, name).build()).closeBraceAfter(var).wrapped();
    }

    private static Optional<Change> wrapTryFinallyAroundVariableScope(VariableTree decl, VisitorState state) {
        BlockTree enclosingBlock = (BlockTree)state.findEnclosing(new Class[]{BlockTree.class});
        if (enclosingBlock == null) {
            return Optional.empty();
        }
        Tree declTree = decl.getType();
        String declType = state.getEndPosition(declTree) == -1 ? "var" : state.getSourceForNode(declTree);
        return Change.builder(SuggestedFix.builder().delete((Tree)decl).prefixWith((Tree)decl, String.format("try (%s %s = %s) {", declType, decl.getName(), state.getSourceForNode((Tree)decl.getInitializer()))).build()).closeBraceAfter(enclosingBlock).wrapped();
    }

    static final class NameSuggester {
        private final Multiset<String> assignedNamesInThisMethod = HashMultiset.create();

        NameSuggester() {
        }

        String uniquifyName(String basename) {
            int numPreviousConflicts = this.assignedNamesInThisMethod.add((Object)basename, 1);
            if (numPreviousConflicts == 0) {
                return basename;
            }
            return basename + (numPreviousConflicts + 1);
        }

        String suggestName(ExpressionTree tree) {
            return this.uniquifyName(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, switch (tree.getKind()) {
                case Tree.Kind.NEW_CLASS -> ASTHelpers.getSymbol((Tree)((NewClassTree)tree).getIdentifier()).getSimpleName().toString();
                case Tree.Kind.METHOD_INVOCATION -> ((Name)ASTHelpers.getReturnType((ExpressionTree)tree).asElement().getSimpleName()).toString();
                default -> throw new AssertionError((Object)tree.getKind());
            }));
        }
    }

    @AutoValue
    protected static abstract class Change {
        protected Change() {
        }

        abstract SuggestedFix otherFixes();

        abstract Optional<Tree> closeBraceAfter();

        static Builder builder(SuggestedFix otherFixes) {
            return new AutoValue_AbstractMustBeClosedChecker_Change.Builder().otherFixes(otherFixes);
        }

        static Optional<Change> of(SuggestedFix fix) {
            return Change.builder(fix).wrapped();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder otherFixes(SuggestedFix var1);

            abstract Builder closeBraceAfter(Tree var1);

            abstract Change build();

            Optional<Change> wrapped() {
                return Optional.of(this.build());
            }
        }
    }
}

