/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.Replacement;
import com.google.errorprone.fixes.Replacements;
import com.sun.tools.javac.tree.EndPosTable;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public class AppliedFix {
    private final String snippet;
    private final boolean isRemoveLine;

    private AppliedFix(String snippet, boolean isRemoveLine) {
        this.snippet = snippet;
        this.isRemoveLine = isRemoveLine;
    }

    public CharSequence getNewCodeSnippet() {
        return this.snippet;
    }

    public boolean isRemoveLine() {
        return this.isRemoveLine;
    }

    public static Applier fromSource(CharSequence source, EndPosTable endPositions) {
        return new Applier(source, endPositions);
    }

    public static class Applier {
        private final CharSequence source;
        private final EndPosTable endPositions;

        public Applier(CharSequence source, EndPosTable endPositions) {
            this.source = source;
            this.endPositions = endPositions;
        }

        public @Nullable AppliedFix apply(Fix suggestedFix) {
            ImmutableSet<Replacement> replacements = Applier.ascending(suggestedFix.getReplacements(this.endPositions));
            if (replacements.isEmpty()) {
                return null;
            }
            StringBuilder replaced = new StringBuilder();
            int positionInOriginal = 0;
            for (Replacement repl : replacements) {
                Preconditions.checkArgument((repl.endPosition() <= this.source.length() ? 1 : 0) != 0, (String)"End [%s] should not exceed source length [%s]", (int)repl.endPosition(), (int)this.source.length());
                replaced.append(this.source, positionInOriginal, repl.startPosition());
                replaced.append(repl.replaceWith());
                positionInOriginal = repl.endPosition();
            }
            replaced.append(this.source, positionInOriginal, this.source.length());
            String snippet = Applier.firstEditedLine(replaced, (Replacement)Iterables.get(replacements, (int)0));
            if (snippet.isEmpty()) {
                return new AppliedFix("to remove this line", true);
            }
            return new AppliedFix(snippet, false);
        }

        private static ImmutableSet<Replacement> ascending(Set<Replacement> set) {
            Replacements replacements = new Replacements();
            set.forEach(replacements::add);
            return replacements.ascending();
        }

        private static String firstEditedLine(StringBuilder content, Replacement firstEdit) {
            int startOfFirstEditedLine = content.lastIndexOf("\n", firstEdit.startPosition() - 1);
            int endOfFirstEditedLine = content.indexOf("\n", firstEdit.startPosition());
            if (startOfFirstEditedLine == -1) {
                startOfFirstEditedLine = 0;
            }
            if (endOfFirstEditedLine == -1) {
                endOfFirstEditedLine = content.length();
            }
            String snippet = content.substring(startOfFirstEditedLine, endOfFirstEditedLine);
            if ((snippet = snippet.trim()).contains("//")) {
                snippet = snippet.substring(0, snippet.indexOf("//")).trim();
            }
            return snippet;
        }
    }
}

