/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.io.ProgramClassWriter;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ProgramClassFilter;

public class ClassPoolClassLoader
extends ClassLoader {
    private final ClassPool classPool;

    public ClassPoolClassLoader(ClassPool classPool) {
        this.classPool = classPool;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Clazz clazz = this.classPool.getClass(ClassUtil.internalClassName(name));
        if (clazz == null) {
            throw new ClassNotFoundException("Class " + name + " not found in class pool");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        clazz.accept(new ProgramClassFilter(new ProgramClassWriter(new DataOutputStream(byteArrayOutputStream))));
        byte[] bytes = byteArrayOutputStream.toByteArray();
        return this.defineClass(name, bytes, 0, bytes.length);
    }
}

