/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.TypeAnnotation;
import proguard.classfile.attribute.annotation.TypePathInfo;
import proguard.classfile.attribute.annotation.visitor.TypeAnnotationVisitor;
import proguard.classfile.editor.AnnotationsAttributeEditor;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ElementValueAdder;
import proguard.classfile.editor.TargetInfoCopier;
import proguard.util.ArrayUtil;

public class TypeAnnotationAdder
implements TypeAnnotationVisitor {
    private static final ElementValue[] EMPTY_ELEMENT_VALUES = new ElementValue[0];
    private final ProgramClass targetClass;
    private final AnnotationElementValue targetAnnotationElementValue;
    private final AnnotationsAttributeEditor annotationsAttributeEditor;
    private final ConstantAdder constantAdder;

    public TypeAnnotationAdder(ProgramClass targetClass, AnnotationElementValue targetAnnotationElementValue) {
        this.targetClass = targetClass;
        this.targetAnnotationElementValue = targetAnnotationElementValue;
        this.annotationsAttributeEditor = null;
        this.constantAdder = new ConstantAdder(targetClass);
    }

    public TypeAnnotationAdder(ProgramClass targetClass, AnnotationsAttribute targetAnnotationsAttribute) {
        this.targetClass = targetClass;
        this.targetAnnotationElementValue = null;
        this.annotationsAttributeEditor = new AnnotationsAttributeEditor(targetAnnotationsAttribute);
        this.constantAdder = new ConstantAdder(targetClass);
    }

    @Override
    public void visitTypeAnnotation(Clazz clazz, TypeAnnotation typeAnnotation) {
        TypePathInfo[] typePath = typeAnnotation.typePath;
        TypePathInfo[] newTypePath = new TypePathInfo[typePath.length];
        TypeAnnotation newTypeAnnotation = new TypeAnnotation(this.constantAdder.addConstant(clazz, typeAnnotation.u2typeIndex), 0, typeAnnotation.u2elementValuesCount > 0 ? new ElementValue[typeAnnotation.u2elementValuesCount] : EMPTY_ELEMENT_VALUES, null, newTypePath);
        newTypeAnnotation.referencedClasses = ArrayUtil.cloneOrNull(typeAnnotation.referencedClasses);
        typeAnnotation.elementValuesAccept(clazz, new ElementValueAdder(this.targetClass, newTypeAnnotation, false));
        typeAnnotation.targetInfo.accept(clazz, typeAnnotation, new TargetInfoCopier(this.targetClass, newTypeAnnotation));
        for (int index = 0; index < typePath.length; ++index) {
            TypePathInfo newTypePathInfo;
            TypePathInfo typePathInfo = typePath[index];
            newTypePath[index] = newTypePathInfo = new TypePathInfo(typePathInfo.u1typePathKind, typePathInfo.u1typeArgumentIndex);
        }
        if (this.targetAnnotationElementValue != null) {
            this.targetAnnotationElementValue.annotationValue = newTypeAnnotation;
        } else {
            this.annotationsAttributeEditor.addAnnotation(newTypeAnnotation);
        }
    }
}

