/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.value;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import proguard.analysis.cpa.defaults.StackAbstractState;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.Precision;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.domain.value.ValueAbstractState;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.transfer.JvmTransferRelation;
import proguard.analysis.datastructure.CodeLocation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.analysis.datastructure.callgraph.ConcreteCall;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ReferencedClassesExtractor;
import proguard.evaluation.ExecutingInvocationUnit;
import proguard.evaluation.MethodResult;
import proguard.evaluation.value.IdentifiedReferenceValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TopValue;
import proguard.evaluation.value.TypedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.evaluation.value.object.AnalyzedObjectFactory;

public class JvmValueTransferRelation
extends JvmTransferRelation<ValueAbstractState> {
    private final ValueFactory valueFactory;
    public final ExecutingInvocationUnit executingInvocationUnit;
    private static final ValueAbstractState TOP_VALUE = new ValueAbstractState(new TopValue());

    public JvmValueTransferRelation(ValueFactory valueFactory, ExecutingInvocationUnit executingInvocationUnit) {
        this.valueFactory = valueFactory;
        this.executingInvocationUnit = executingInvocationUnit;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    @Override
    public ValueAbstractState getAbstractDefault() {
        return ValueAbstractState.UNKNOWN;
    }

    @Override
    public ValueAbstractState getAbstractByteConstant(byte b) {
        return new ValueAbstractState(this.valueFactory.createIntegerValue(b));
    }

    @Override
    public List<ValueAbstractState> getAbstractDoubleConstant(double d) {
        return Arrays.asList(TOP_VALUE, new ValueAbstractState(this.valueFactory.createDoubleValue(d)));
    }

    @Override
    public ValueAbstractState getAbstractFloatConstant(float f) {
        return new ValueAbstractState(this.valueFactory.createFloatValue(f));
    }

    @Override
    public ValueAbstractState getAbstractIntegerConstant(int i) {
        return new ValueAbstractState(this.valueFactory.createIntegerValue(i));
    }

    @Override
    public List<ValueAbstractState> getAbstractLongConstant(long l) {
        return Arrays.asList(TOP_VALUE, new ValueAbstractState(this.valueFactory.createLongValue(l)));
    }

    @Override
    public ValueAbstractState getAbstractNull() {
        return new ValueAbstractState(this.valueFactory.createReferenceValueNull());
    }

    @Override
    public ValueAbstractState getAbstractShortConstant(short s) {
        return new ValueAbstractState(this.valueFactory.createIntegerValue(s));
    }

    @Override
    public ValueAbstractState getAbstractReferenceValue(String className) {
        return this.getAbstractReferenceValue(className, null, true, true);
    }

    @Override
    public ValueAbstractState getAbstractReferenceValue(String internalType, Clazz referencedClazz, boolean mayBeExtension, boolean mayBeNull) {
        return new ValueAbstractState(this.valueFactory.createReferenceValue(internalType, referencedClazz, mayBeExtension, mayBeNull));
    }

    @Override
    public ValueAbstractState getAbstractReferenceValue(String internalType, Clazz referencedClazz, boolean mayBeExtension, boolean mayBeNull, Clazz creationClass, Method creationMethod, int creationOffset, Object value) {
        return new ValueAbstractState(this.valueFactory.createReferenceValue(referencedClazz, mayBeExtension, mayBeNull, new CodeLocation(creationClass, creationMethod, creationOffset), AnalyzedObjectFactory.create(value, internalType, referencedClazz)));
    }

    @Override
    protected void processCall(JvmAbstractState<ValueAbstractState> state, Call call) {
        LinkedList<ValueAbstractState> operands = new LinkedList<ValueAbstractState>();
        if (call.getTarget().descriptor.argumentTypes != null) {
            List<String> argumentTypes = call.getTarget().descriptor.argumentTypes;
            for (int i = argumentTypes.size() - 1; i >= 0; --i) {
                boolean isCategory2 = ClassUtil.isInternalCategory2Type(argumentTypes.get(i));
                operands.offerFirst(state.pop());
                if (!isCategory2) continue;
                state.pop();
            }
        }
        if (!call.isStatic()) {
            operands.offerFirst(state.pop());
        }
        this.invokeMethod(state, call, (List<ValueAbstractState>)operands);
    }

    @Override
    public void invokeMethod(JvmAbstractState<ValueAbstractState> state, Call call, List<ValueAbstractState> operands) {
        if (call instanceof ConcreteCall) {
            if (this.executingInvocationUnit.canExecute(call.getTarget())) {
                this.executeMethod((ConcreteCall)call, state, operands);
                return;
            }
            String returnType = call.getTarget().descriptor.returnType;
            String internalReturnClassName = ClassUtil.internalClassNameFromType(returnType);
            if (returnType != null && internalReturnClassName != null && this.executingInvocationUnit.supportsInstancesOf(internalReturnClassName)) {
                this.pushReturnTypedValue(state, operands, (ConcreteCall)call, returnType);
                return;
            }
        }
        super.invokeMethod(state, call, operands);
    }

    @Override
    protected ValueAbstractState handleCheckCast(ValueAbstractState state, String internalName) {
        boolean castSuccess;
        Value value = state.getValue();
        if (!(value instanceof TypedReferenceValue)) {
            return this.getAbstractDefault();
        }
        TypedReferenceValue typedValue = (TypedReferenceValue)value;
        if (typedValue.getValue().isNull()) {
            return state;
        }
        Clazz referencedClass = typedValue.getReferencedClass();
        if (referencedClass == null) {
            String typeName = ClassUtil.internalTypeFromClassName(internalName);
            castSuccess = Objects.equals(typeName, typedValue.getType());
        } else {
            castSuccess = referencedClass.extendsOrImplements(internalName);
        }
        return castSuccess ? state : this.getAbstractDefault();
    }

    private void executeMethod(ConcreteCall call, JvmAbstractState<ValueAbstractState> state, List<ValueAbstractState> operands) {
        Clazz targetClass = call.getTargetClass();
        Method targetMethod = call.getTargetMethod();
        Value[] operandsArray = (Value[])operands.stream().map(ValueAbstractState::getValue).toArray(Value[]::new);
        if (operandsArray.length != ClassUtil.internalMethodParameterCount(call.getTarget().descriptor.toString(), call.isStatic())) {
            throw new IllegalStateException("Unexpected number of parameters");
        }
        MethodResult result = null;
        result = !call.isStatic() && ValueAbstractState.UNKNOWN.getValue().equals(operandsArray[0]) ? MethodResult.invalidResult() : this.executingInvocationUnit.executeMethod(call, operandsArray);
        String returnType = ClassUtil.internalMethodReturnType(targetMethod.getDescriptor(targetClass));
        if (!this.isVoidReturnType(returnType)) {
            Value returnValue = result.isReturnValuePresent() ? result.getReturnValue() : ValueAbstractState.UNKNOWN.getValue();
            this.pushReturnValue(state, returnValue, returnType);
        }
        if (result.isInstanceUpdated()) {
            this.updateStack(state, result.getUpdatedInstance(), returnType);
            this.updateHeap(state, result.getUpdatedInstance());
        }
    }

    private void pushReturnTypedValue(JvmAbstractState<ValueAbstractState> state, List<ValueAbstractState> operands, ConcreteCall call, String returnType) {
        ReferencedClassesExtractor referencedClassesExtractor = new ReferencedClassesExtractor();
        call.targetMethodAccept(referencedClassesExtractor);
        if (referencedClassesExtractor.getReturnClass() == null) {
            super.invokeMethod(state, call, operands);
        } else {
            ReferenceValue result = this.valueFactory.createReferenceValue(ClassUtil.internalMethodReturnType(returnType), referencedClassesExtractor.getReturnClass(), ClassUtil.isExtendable(referencedClassesExtractor.getReturnClass()), true);
            this.pushReturnValue(state, result, returnType);
        }
    }

    private void pushReturnValue(JvmAbstractState<ValueAbstractState> state, Value result, String returnType) {
        if (ClassUtil.isInternalCategory2Type(returnType)) {
            state.push(TOP_VALUE);
        }
        state.push(new ValueAbstractState(result));
    }

    private void updateStack(JvmAbstractState<ValueAbstractState> state, Value result, String returnType) {
        int start;
        if (!(result instanceof IdentifiedReferenceValue)) {
            return;
        }
        IdentifiedReferenceValue identifiedReferenceValue = (IdentifiedReferenceValue)result;
        StackAbstractState<ValueAbstractState> operandStack = state.getFrame().getOperandStack();
        for (int i = start = this.isVoidReturnType(returnType) ? operandStack.size() - 1 : operandStack.size() - 2; i >= 0; --i) {
            ValueAbstractState stackEntry = (ValueAbstractState)operandStack.get(i);
            Value valueOnStack = stackEntry.getValue();
            if (!(valueOnStack instanceof IdentifiedReferenceValue) || !((IdentifiedReferenceValue)valueOnStack).id.equals(identifiedReferenceValue.id)) continue;
            stackEntry.setValue(identifiedReferenceValue);
        }
    }

    private boolean isVoidReturnType(String returnType) {
        return returnType.equals(String.valueOf('V'));
    }

    private void updateHeap(JvmAbstractState<ValueAbstractState> state, Value result) {
        if (!(result instanceof IdentifiedReferenceValue)) {
            return;
        }
        IdentifiedReferenceValue identifiedReferenceValue = (IdentifiedReferenceValue)result;
        state.setField(identifiedReferenceValue.id, new ValueAbstractState(identifiedReferenceValue));
    }

    @Override
    public Collection<? extends AbstractState> generateEdgeAbstractSuccessors(AbstractState abstractState, JvmCfaEdge edge, Precision precision) {
        return this.wrapAbstractSuccessorInCollection(this.generateEdgeAbstractSuccessor(abstractState, edge, precision));
    }
}

