/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.defaults;

import java.util.Set;
import proguard.analysis.cpa.bam.BamCache;
import proguard.analysis.cpa.bam.BamCacheImpl;
import proguard.analysis.cpa.bam.BamCpa;
import proguard.analysis.cpa.bam.CpaWithBamOperators;
import proguard.analysis.cpa.bam.ExpandOperator;
import proguard.analysis.cpa.bam.NoOpRebuildOperator;
import proguard.analysis.cpa.bam.RebuildOperator;
import proguard.analysis.cpa.bam.ReduceOperator;
import proguard.analysis.cpa.defaults.Cfa;
import proguard.analysis.cpa.defaults.CpaRun;
import proguard.analysis.cpa.defaults.NeverAbortOperator;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.CfaEdge;
import proguard.analysis.cpa.interfaces.CfaNode;
import proguard.analysis.cpa.interfaces.ConfigurableProgramAnalysis;
import proguard.classfile.Signature;

public abstract class BamCpaRun<CpaT extends ConfigurableProgramAnalysis, AbstractStateT extends AbstractState, CfaNodeT extends CfaNode<CfaEdgeT, SignatureT>, CfaEdgeT extends CfaEdge<CfaNodeT>, SignatureT extends Signature>
extends CpaRun<BamCpa<CfaNodeT, CfaEdgeT, SignatureT>, AbstractStateT> {
    private final int maxCallStackDepth;
    protected final boolean reduceHeap;

    protected BamCpaRun(AbortOperator abortOperator, int maxCallStackDepth) {
        this(abortOperator, maxCallStackDepth, true);
    }

    protected BamCpaRun(AbortOperator abortOperator, int maxCallStackDepth, boolean reduceHeap) {
        this.abortOperator = abortOperator;
        this.maxCallStackDepth = maxCallStackDepth;
        this.reduceHeap = reduceHeap;
    }

    @Override
    public BamCpa<CfaNodeT, CfaEdgeT, SignatureT> getCpa() {
        return this.cpa == null ? (this.cpa = new BamCpa<CfaNodeT, CfaEdgeT, SignatureT>(new CpaWithBamOperators<CfaNodeT, CfaEdgeT, SignatureT>((ConfigurableProgramAnalysis)this.createIntraproceduralCPA(), this.createReduceOperator(), this.createExpandOperator(), this.createRebuildOperator()), this.getCfa(), this.getMainSignature(), this.createCache(), this.getMaxCallStackDepth(), this.abortOperator)) : (BamCpa<CfaNodeT, CfaEdgeT, SignatureT>)super.getCpa();
    }

    public abstract CpaT createIntraproceduralCPA();

    public abstract ReduceOperator<CfaNodeT, CfaEdgeT, SignatureT> createReduceOperator();

    public abstract ExpandOperator<CfaNodeT, CfaEdgeT, SignatureT> createExpandOperator();

    public RebuildOperator createRebuildOperator() {
        return new NoOpRebuildOperator();
    }

    public BamCache<SignatureT> createCache() {
        return new BamCacheImpl();
    }

    public abstract Cfa<CfaNodeT, CfaEdgeT, SignatureT> getCfa();

    public abstract SignatureT getMainSignature();

    public int getMaxCallStackDepth() {
        return this.maxCallStackDepth;
    }

    public Set<SignatureT> getAnalyzedMethods() {
        return ((BamCpa)this.getCpa()).getCache().getAllMethods();
    }

    public static abstract class Builder {
        protected int maxCallStackDepth = -1;
        protected AbortOperator abortOperator = NeverAbortOperator.INSTANCE;
        protected boolean reduceHeap = true;

        public abstract BamCpaRun<?, ?, ?, ?, ?> build();

        public Builder setMaxCallStackDepth(int maxCallStackDepth) {
            this.maxCallStackDepth = maxCallStackDepth;
            return this;
        }

        public Builder setAbortOperator(AbortOperator abortOperator) {
            this.abortOperator = abortOperator;
            return this;
        }

        public Builder setReduceHeap(boolean reduceHeap) {
            this.reduceHeap = reduceHeap;
            return this;
        }
    }
}

