/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.ClassUsageMarker;
import proguard.shrink.SimpleUsageMarker;
import proguard.util.Processable;

public class UsedMemberFilter
implements MemberVisitor {
    private final SimpleUsageMarker usageMarker;
    private final MemberVisitor usedMemberFilter;
    private final MemberVisitor unusedMemberVisitor;

    public UsedMemberFilter(ClassUsageMarker classUsageMarker, MemberVisitor usedMemberFilter) {
        this(classUsageMarker.getUsageMarker(), usedMemberFilter);
    }

    public UsedMemberFilter(SimpleUsageMarker usageMarker, MemberVisitor usedMemberFilter) {
        this(usageMarker, usedMemberFilter, null);
    }

    public UsedMemberFilter(SimpleUsageMarker usageMarker, MemberVisitor usedMemberFilter, MemberVisitor unusedMemberVisitor) {
        this.usageMarker = usageMarker;
        this.usedMemberFilter = usedMemberFilter;
        this.unusedMemberVisitor = unusedMemberVisitor;
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        MemberVisitor delegateVisitor = this.delegateVisitor((Member)programField);
        if (delegateVisitor != null) {
            delegateVisitor.visitProgramField(programClass, programField);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        MemberVisitor delegateVisitor = this.delegateVisitor((Member)programMethod);
        if (delegateVisitor != null) {
            delegateVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        MemberVisitor delegateVisitor = this.delegateVisitor((Member)libraryField);
        if (delegateVisitor != null) {
            delegateVisitor.visitLibraryField(libraryClass, libraryField);
        }
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        MemberVisitor delegateVisitor = this.delegateVisitor((Member)libraryMethod);
        if (delegateVisitor != null) {
            delegateVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }

    private MemberVisitor delegateVisitor(Member member) {
        return this.usageMarker.isUsed((Processable)member) ? this.usedMemberFilter : this.unusedMemberVisitor;
    }
}

