/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.NonPrivateMemberMarker;

public class MemberPrivatizer
implements MemberVisitor {
    private final MemberVisitor extraMemberVisitor;

    public MemberPrivatizer() {
        this(null);
    }

    public MemberPrivatizer(MemberVisitor extraMemberVisitor) {
        this.extraMemberVisitor = extraMemberVisitor;
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (NonPrivateMemberMarker.canBeMadePrivate((Field)programField)) {
            programField.u2accessFlags = AccessUtil.replaceAccessFlags((int)programField.u2accessFlags, (int)2);
            if (this.extraMemberVisitor != null) {
                this.extraMemberVisitor.visitProgramField(programClass, programField);
            }
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (NonPrivateMemberMarker.canBeMadePrivate((Method)programMethod)) {
            programMethod.u2accessFlags = AccessUtil.replaceAccessFlags((int)programMethod.u2accessFlags, (int)2);
            if (this.extraMemberVisitor != null) {
                this.extraMemberVisitor.visitProgramMethod(programClass, programMethod);
            }
        }
    }
}

