/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.PrintWriter;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

public class MappingPrinter
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private final PrintWriter pw;
    private boolean printed;
    private static final Logger logger = LogManager.getLogger(MappingPrinter.class);

    public MappingPrinter(PrintWriter printWriter) {
        this.pw = printWriter;
    }

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        String name = programClass.getName();
        String newName = ClassObfuscator.newClassName((Clazz)programClass);
        this.pw.println(ClassUtil.externalClassName((String)name) + " -> " + ClassUtil.externalClassName((String)newName) + ":");
        SourceFileNamePrinter sourceFileNamePrinter = new SourceFileNamePrinter(this.pw);
        programClass.attributesAccept((AttributeVisitor)sourceFileNamePrinter);
        programClass.fieldsAccept((MemberVisitor)this);
        programClass.methodsAccept((MemberVisitor)this);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String fieldName = programField.getName((Clazz)programClass);
        String obfuscatedFieldName = MemberObfuscator.newMemberName((Member)programField);
        if (obfuscatedFieldName == null) {
            obfuscatedFieldName = fieldName;
        }
        this.pw.println("    " + ClassUtil.externalType((String)programField.getDescriptor((Clazz)programClass)) + " " + fieldName + " -> " + obfuscatedFieldName);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String methodName = programMethod.getName((Clazz)programClass);
        String obfuscatedMethodName = MemberObfuscator.newMemberName((Member)programMethod);
        if (obfuscatedMethodName == null) {
            obfuscatedMethodName = methodName;
        }
        this.printed = false;
        programMethod.attributesAccept(programClass, (AttributeVisitor)this);
        if (!this.printed) {
            this.pw.println("    " + ClassUtil.externalMethodReturnType((String)programMethod.getDescriptor((Clazz)programClass)) + " " + methodName + '(' + ClassUtil.externalMethodArguments((String)programMethod.getDescriptor((Clazz)programClass)) + ')' + " -> " + obfuscatedMethodName);
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, (AttributeVisitor)this);
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        LineNumberInfo[] lineNumberTable = lineNumberTableAttribute.lineNumberTable;
        int lineNumberTableLength = lineNumberTableAttribute.u2lineNumberTableLength;
        String methodName = method.getName(clazz);
        String methodDescriptor = method.getDescriptor(clazz);
        String obfuscatedMethodName = MemberObfuscator.newMemberName((Member)method);
        if (obfuscatedMethodName == null) {
            obfuscatedMethodName = methodName;
        }
        int lowestLineNumber = lineNumberTableAttribute.getLowestLineNumber();
        int highestLineNumber = lineNumberTableAttribute.getHighestLineNumber();
        if (lineNumberTableAttribute.getSource(codeAttribute.u4codeLength) == null) {
            if (lowestLineNumber > 0) {
                this.pw.println("    " + lowestLineNumber + ":" + highestLineNumber + ":" + ClassUtil.externalMethodReturnType((String)method.getDescriptor(clazz)) + " " + methodName + '(' + ClassUtil.externalMethodArguments((String)method.getDescriptor(clazz)) + ')' + " -> " + obfuscatedMethodName);
            } else {
                this.pw.println("    " + ClassUtil.externalMethodReturnType((String)method.getDescriptor(clazz)) + " " + methodName + '(' + ClassUtil.externalMethodArguments((String)method.getDescriptor(clazz)) + ')' + " -> " + obfuscatedMethodName);
            }
        }
        Stack<LineNumberInfo> enclosingLineNumbers = new Stack<LineNumberInfo>();
        LineNumberInfo previousInfo = new LineNumberInfo(0, 0);
        for (int index = 0; index < lineNumberTableLength; ++index) {
            LineNumberInfo info = lineNumberTable[index];
            String previousSource = previousInfo.getSource();
            String source = info.getSource();
            if (source != null && !source.equals(previousSource)) {
                int lineNumber = info.u2lineNumber;
                int previousLineNumber = previousInfo.u2lineNumber;
                if (lineNumber > previousLineNumber) {
                    if (index > 0) {
                        enclosingLineNumbers.push(previousInfo);
                    }
                    this.printInlinedMethodMapping(clazz.getName(), methodName, methodDescriptor, info, enclosingLineNumbers, obfuscatedMethodName);
                } else if (!enclosingLineNumbers.isEmpty()) {
                    enclosingLineNumbers.pop();
                }
            } else if (source == null && previousSource != null && !enclosingLineNumbers.isEmpty()) {
                enclosingLineNumbers.pop();
            }
            previousInfo = info;
        }
        this.printed = true;
    }

    private void printInlinedMethodMapping(String className, String methodName, String methodDescriptor, LineNumberInfo inlinedInfo, Stack<LineNumberInfo> enclosingLineNumbers, String obfuscatedMethodName) {
        String source = inlinedInfo.getSource();
        int separatorIndex1 = source.indexOf(46);
        int separatorIndex2 = source.indexOf(40, separatorIndex1 + 1);
        int separatorIndex3 = source.indexOf(58, separatorIndex2 + 1);
        int separatorIndex4 = source.indexOf(58, separatorIndex3 + 1);
        String inlinedClassName = source.substring(0, separatorIndex1);
        String inlinedMethodName = source.substring(separatorIndex1 + 1, separatorIndex2);
        String inlinedMethodDescriptor = source.substring(separatorIndex2, separatorIndex3);
        String inlinedRange = source.substring(separatorIndex3);
        int startLineNumber = Integer.parseInt(source.substring(separatorIndex3 + 1, separatorIndex4));
        int endLineNumber = Integer.parseInt(source.substring(separatorIndex4 + 1));
        int shiftedStartLineNumber = inlinedInfo.u2lineNumber;
        int shiftedEndLineNumber = shiftedStartLineNumber + endLineNumber - startLineNumber;
        this.pw.println("    " + shiftedStartLineNumber + ":" + shiftedEndLineNumber + ":" + ClassUtil.externalMethodReturnType((String)inlinedMethodDescriptor) + " " + (inlinedClassName.equals(className) ? "" : ClassUtil.externalClassName((String)inlinedClassName) + '.') + inlinedMethodName + '(' + ClassUtil.externalMethodArguments((String)inlinedMethodDescriptor) + ')' + inlinedRange + " -> " + obfuscatedMethodName);
        for (int enclosingIndex = enclosingLineNumbers.size() - 1; enclosingIndex >= 0; --enclosingIndex) {
            LineNumberInfo enclosingInfo = (LineNumberInfo)enclosingLineNumbers.get(enclosingIndex);
            this.printEnclosingMethodMapping(className, methodName, methodDescriptor, shiftedStartLineNumber + ":" + shiftedEndLineNumber, enclosingInfo, obfuscatedMethodName);
        }
    }

    private void printEnclosingMethodMapping(String className, String methodName, String methodDescriptor, String shiftedRange, LineNumberInfo enclosingInfo, String obfuscatedMethodName) {
        int enclosingLineNumber;
        String enclosingMethodDescriptor;
        String enclosingMethodName;
        String enclosingClassName;
        String enclosingSource = enclosingInfo.getSource();
        if (enclosingSource == null) {
            enclosingClassName = className;
            enclosingMethodName = methodName;
            enclosingMethodDescriptor = methodDescriptor;
            enclosingLineNumber = enclosingInfo.u2lineNumber;
        } else {
            int enclosingSeparatorIndex1 = enclosingSource.indexOf(46);
            int enclosingSeparatorIndex2 = enclosingSource.indexOf(40, enclosingSeparatorIndex1 + 1);
            int enclosingSeparatorIndex3 = enclosingSource.indexOf(58, enclosingSeparatorIndex2 + 1);
            int enclosingSeparatorIndex4 = enclosingSource.indexOf(58, enclosingSeparatorIndex3 + 1);
            int firstLineNumber = Integer.parseInt(enclosingSource.substring(enclosingSeparatorIndex3 + 1, enclosingSeparatorIndex4));
            enclosingClassName = enclosingSource.substring(0, enclosingSeparatorIndex1);
            enclosingMethodName = enclosingSource.substring(enclosingSeparatorIndex1 + 1, enclosingSeparatorIndex2);
            enclosingMethodDescriptor = enclosingSource.substring(enclosingSeparatorIndex2, enclosingSeparatorIndex3);
            enclosingLineNumber = (enclosingInfo.u2lineNumber - firstLineNumber) % 1000 + firstLineNumber;
        }
        this.pw.println("    " + shiftedRange + ":" + ClassUtil.externalMethodReturnType((String)enclosingMethodDescriptor) + " " + (enclosingClassName.equals(className) ? "" : ClassUtil.externalClassName((String)enclosingClassName) + '.') + enclosingMethodName + '(' + ClassUtil.externalMethodArguments((String)enclosingMethodDescriptor) + ')' + ":" + enclosingLineNumber + " -> " + obfuscatedMethodName);
    }

    private static class SourceFileNamePrinter
    implements AttributeVisitor {
        private final PrintWriter pw;

        public SourceFileNamePrinter(PrintWriter pw) {
            this.pw = pw;
        }

        public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
            String sourceFileName = clazz.getString(sourceFileAttribute.u2sourceFileIndex);
            JSONObject json = new JSONObject();
            try {
                json.put("id", (Object)"sourceFile");
                json.put("fileName", (Object)sourceFileName);
                this.pw.println("# " + json);
            }
            catch (JSONException e) {
                logger.info("Failed to convert source file name {} into JSON.", (Object)sourceFileName);
            }
        }

        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }
    }
}

