/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker.trial;

import com.google.caliper.model.Host;
import com.google.caliper.model.Run;
import com.google.caliper.model.Scenario;
import com.google.caliper.model.Trial;
import com.google.caliper.runner.experiment.Experiment;
import com.google.caliper.runner.instrument.MeasurementCollectingVisitor;
import com.google.caliper.runner.target.Target;
import com.google.caliper.runner.worker.WorkerModule;
import com.google.caliper.runner.worker.WorkerProcessor;
import com.google.caliper.runner.worker.WorkerRunner;
import com.google.caliper.runner.worker.WorkerScoped;
import com.google.caliper.runner.worker.WorkerSpec;
import com.google.caliper.runner.worker.trial.TrialId;
import com.google.caliper.runner.worker.trial.TrialProcessor;
import com.google.caliper.runner.worker.trial.TrialResult;
import com.google.caliper.runner.worker.trial.TrialResultFactory;
import com.google.caliper.runner.worker.trial.TrialSpec;
import com.google.caliper.runner.worker.trial.VmDataCollectingVisitor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import dagger.Binds;
import dagger.Provides;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import java.util.UUID;

@ProducerModule(includes={WorkerModule.class})
abstract class TrialModule {
    private TrialModule() {
    }

    @Produces
    static TrialResult trialResult(WorkerRunner<TrialResult> trialResultWorkerRunner) {
        return trialResultWorkerRunner.runWorker();
    }

    @Binds
    abstract WorkerProcessor<TrialResult> bindTrialProcessor(TrialProcessor var1);

    @Provides
    @WorkerScoped
    @TrialId
    static UUID provideTrialId() {
        return UUID.randomUUID();
    }

    @Provides
    static Target provideTarget(Experiment experiment) {
        return experiment.target();
    }

    @Binds
    abstract WorkerSpec bindWorkerSpec(TrialSpec var1);

    @Provides
    static MeasurementCollectingVisitor provideMeasurementCollectingVisitor(Experiment experiment) {
        return experiment.instrumentedMethod().getMeasurementCollectingVisitor();
    }

    @Provides
    static Host provideHost(Target target, ImmutableMap<Target, Host> hostsByTarget) {
        return (Host)hostsByTarget.get((Object)target);
    }

    @Provides
    static TrialResultFactory provideTrialFactory(final @TrialId UUID trialId, final Run run, final Host host, final Experiment experiment) {
        return new TrialResultFactory(){

            @Override
            public TrialResult newTrialResult(VmDataCollectingVisitor dataCollectingVisitor, MeasurementCollectingVisitor measurementCollectingVisitor) {
                Preconditions.checkState((boolean)measurementCollectingVisitor.isDoneCollecting());
                return new TrialResult(new Trial.Builder(trialId).run(run).instrumentSpec(experiment.instrumentedMethod().instrument().getSpec()).scenario(new Scenario.Builder().host(host).vmSpec(dataCollectingVisitor.vmSpec()).benchmarkSpec(experiment.benchmarkSpec())).addAllMeasurements(measurementCollectingVisitor.getMeasurements()).build(), experiment, measurementCollectingVisitor.getMessages());
            }
        };
    }
}

