/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker;

import com.google.caliper.model.Run;
import com.google.caliper.runner.config.CaliperConfig;
import com.google.caliper.runner.worker.WorkerOutputFactory;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
final class WorkerOutputFactoryService
extends AbstractIdleService
implements WorkerOutputFactory {
    private static final String LOG_DIRECTORY_PROPERTY = "worker.output";
    private final CaliperConfig config;
    private final Run run;
    @GuardedBy(value="this")
    private final Set<String> toDelete = new LinkedHashSet<String>();
    @GuardedBy(value="this")
    private File directory;
    @GuardedBy(value="this")
    private boolean persistFiles;

    @Inject
    WorkerOutputFactoryService(Run run, CaliperConfig config) {
        this.run = run;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkerOutputFactory.FileAndWriter getOutputFile(String fileName) throws FileNotFoundException {
        File dir;
        WorkerOutputFactoryService workerOutputFactoryService = this;
        synchronized (workerOutputFactoryService) {
            if (this.directory == null) {
                throw new RuntimeException(String.format("The output manager %s has not been started yet", this));
            }
            dir = this.directory;
        }
        File file = new File(dir, fileName);
        WorkerOutputFactoryService workerOutputFactoryService2 = this;
        synchronized (workerOutputFactoryService2) {
            if (!this.persistFiles) {
                this.toDelete.add(file.getPath());
            }
        }
        return new WorkerOutputFactory.FileAndWriter(file, new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8))));
    }

    @Override
    public synchronized void persistFile(File f) {
        if (!this.persistFiles) {
            Preconditions.checkArgument((boolean)this.toDelete.remove(f.getPath()), (String)"%s was not created by the output manager", (Object)f);
        }
    }

    protected synchronized void startUp() throws Exception {
        File directory;
        String dirName = (String)this.config.properties().get((Object)LOG_DIRECTORY_PROPERTY);
        boolean persistFiles = true;
        if (dirName != null) {
            directory = new File(dirName);
            if (!directory.exists()) {
                if (!directory.mkdirs()) {
                    throw new Exception(String.format("Unable to create directory %s indicated by property %s", dirName, LOG_DIRECTORY_PROPERTY));
                }
            } else if (!directory.isDirectory()) {
                throw new Exception(String.format("Configured directory %s indicated by property %s is not a directory", dirName, LOG_DIRECTORY_PROPERTY));
            }
            if (!(directory = new File(directory, String.format("run-%s", this.run.id()))).mkdir()) {
                String string = String.valueOf(directory);
                throw new Exception(new StringBuilder(33 + String.valueOf(string).length()).append("Unable to create a run directory ").append(string).toString());
            }
        } else {
            directory = Files.createTempDir();
            persistFiles = false;
        }
        this.directory = directory;
        this.persistFiles = persistFiles;
    }

    protected synchronized void shutDown() throws Exception {
        if (!this.persistFiles) {
            for (String f : this.toDelete) {
                new File(f).delete();
            }
            this.directory.delete();
        }
    }
}

