/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;

public class Value
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final Value DEFAULT = new Value();
    private double magnitude;
    private String unit;

    public static Value create(double value, String unit) {
        return new Value(value, (String)Preconditions.checkNotNull((Object)unit));
    }

    private Value() {
        this.magnitude = 0.0;
        this.unit = "";
    }

    private Value(double value, String unit) {
        this.magnitude = value;
        this.unit = unit;
    }

    public String unit() {
        return this.unit;
    }

    public double magnitude() {
        return this.magnitude;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Value) {
            Value that = (Value)obj;
            return this.magnitude == that.magnitude && this.unit.equals(that.unit);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.magnitude, this.unit});
    }

    public String toString() {
        return this.magnitude + this.unit;
    }
}

