#!/usr/bin/env bash

function bashunit::upgrade::upgrade() {
  local script_path
  script_path="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
  local latest_tag
  latest_tag="$(bashunit::helper::get_latest_tag)"

  if [[ "$BASHUNIT_VERSION" == "$latest_tag" ]]; then
    echo "> You are already on latest version"
    return
  fi

  echo "> Upgrading bashunit to latest version"
  cd "$script_path" || exit

  local url="https://github.com/TypedDevs/bashunit/releases/download/$latest_tag/bashunit"
  if ! bashunit::io::download_to "$url" "bashunit"; then
    echo "Failed to download bashunit"
  fi

  chmod u+x "bashunit"

  echo "> bashunit upgraded successfully to latest version $latest_tag"
}
