/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqparser;

import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQSequenceType;
import javax.xml.xquery.XQStaticContext;
import net.xqj.core.NamespaceContextImpl;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.xqparser.XQueryToken;
import net.xqj.core.xqparser.v30.XQueryStatement30;

public class XQueryStatement {
    private static final HashMap<Integer, XQueryStatement> compiledStatements = new HashMap();
    private static final int WAIT_FOR_QUERIES_WITH_SIZE = 4096;
    protected NamespaceContextImpl nsContext = new NamespaceContextImpl();
    protected final XQStaticContext staticContext;
    protected final HashMap<QName, XQSequenceType> externalVariableTypes = new HashMap();
    protected final Set<XQueryToken> tokenSet = new TreeSet<XQueryToken>();
    protected final HashMap<QName, String> options = new HashMap();
    protected int xqueryVersion = 10;
    protected int versionDeclStartIndex;
    protected int versionDeclEndIndex;
    protected int prologStartIndex = 0;
    protected boolean foundVersionDeclaration = false;
    protected boolean foundNamespaceDeclaration = false;
    protected boolean foundExternalVariableDeclaration = false;
    protected boolean foundOption = false;
    protected boolean foundBaseUri = false;
    protected boolean foundDefaultCollation = false;
    protected boolean foundDefaultElementTypeNamespace = false;
    protected boolean foundDefaultFunctionNamespace = false;
    protected boolean foundBoundarySpacePolicy = false;
    protected boolean foundConstructionMode = false;
    protected boolean foundCopyNamespaces = false;
    protected boolean foundDefaultOrderForEmptySequences = false;
    protected boolean foundOrderingMode = false;
    protected boolean foundContextItem = false;
    protected boolean foundContextItemExternalDeclaration = false;
    protected boolean foundHardCodedContextItemDeclaration = false;
    protected String baseUri = "";
    protected String defaultCollation = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    protected String defaultElementTypeNamespace = "";
    protected String defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";
    protected int boundarySpacePolicy = 1;
    protected int constructionMode = 1;
    protected int copyNamespacesModeInherit = 2;
    protected int copyNamespacesModePreserve = 2;
    protected int defaultOrderForEmptySequences = 1;
    protected int orderingMode = 1;
    protected final char[] query;
    public static final int XQUERY_VERSION_10 = 1;
    public static final int XQUERY_VERSION_30 = 2;
    public static final int XQUERY_VERSION_UNDEFINED = 10;
    public static final int XQUERY_VERSION_10_ML = 20;
    private static final char[] XQV = new char[]{'x', 'q', 'u', 'e', 'r', 'y', 'v', 'e', 'r', 's', 'i', 'o', 'n'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XQueryStatement compile(Reader reader, XQStaticContext staticContext) throws XQException {
        try {
            char[] query = XQToolkit.forceRead(reader);
            Integer hashCode = Arrays.hashCode(query);
            XQueryStatement statement = compiledStatements.get(hashCode);
            if (statement != null) {
                return statement;
            }
            if (query.length >= 4096) {
                HashMap<Integer, XQueryStatement> hashMap = compiledStatements;
                synchronized (hashMap) {
                    statement = compiledStatements.get(hashCode);
                    if (statement != null) {
                        return statement;
                    }
                    statement = new XQueryStatement30(query, staticContext);
                    compiledStatements.put(hashCode, statement);
                }
            }
            statement = new XQueryStatement30(query, staticContext);
            HashMap<Integer, XQueryStatement> hashMap = compiledStatements;
            synchronized (hashMap) {
                compiledStatements.put(hashCode, statement);
            }
            return statement;
        }
        catch (XQException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new XQExceptionImpl("Invalid XQuery syntax, syntax does not pass static validation.", "XQJQS001", e);
        }
    }

    protected XQueryStatement(char[] query, XQStaticContext staticContext) throws Exception {
        this.staticContext = staticContext;
        this.query = query;
    }

    protected XQueryStatement() {
        this.staticContext = null;
        this.query = null;
    }

    public String[] getNamespacePrefixes() {
        return this.nsContext.getNamespacePrefixes();
    }

    public String getNamespaceURI(String prefix) {
        return this.nsContext.getNamespaceURI(prefix);
    }

    public String getDefaultElementTypeNamespace() {
        return this.defaultElementTypeNamespace;
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    public int getConstructionMode() {
        return this.constructionMode;
    }

    public int getOrderingMode() {
        return this.orderingMode;
    }

    public int getDefaultOrderForEmptySequences() {
        return this.defaultOrderForEmptySequences;
    }

    public int getBoundarySpacePolicy() {
        return this.boundarySpacePolicy;
    }

    public int getCopyNamespacesModePreserve() {
        return this.copyNamespacesModePreserve;
    }

    public int getCopyNamespacesModeInherit() {
        return this.copyNamespacesModeInherit;
    }

    public String getBaseURI() {
        return this.baseUri;
    }

    public int getQueryLanguageTypeAndVersion() {
        return 1;
    }

    public int getQueryVersion() {
        return this.xqueryVersion;
    }

    public boolean isXQuery30() {
        return this.getQueryVersion() == 2;
    }

    public String getQueryLanguage() {
        switch (this.xqueryVersion) {
            case 1: {
                return "1.0";
            }
            case 2: {
                return "3.0";
            }
        }
        return "3.0";
    }

    public XQSequenceType getStaticVariableType(QName name) {
        return this.externalVariableTypes.get(name);
    }

    public Set getAllExternalVariablesAsSet() {
        return this.externalVariableTypes.keySet();
    }

    public QName[] getAllExternalVariables() {
        return this.getAllExternalVariablesAsSet().toArray(new QName[this.getAllExternalVariablesAsSet().size()]);
    }

    public boolean isStraightExpression() {
        return !this.foundNamespaceDeclaration && !this.foundExternalVariableDeclaration && !this.foundOption && !this.foundBaseUri && !this.foundDefaultCollation && !this.foundDefaultElementTypeNamespace && !this.foundDefaultFunctionNamespace && !this.foundBoundarySpacePolicy && !this.foundConstructionMode && !this.foundCopyNamespaces && !this.foundDefaultOrderForEmptySequences && !this.foundOrderingMode && !this.foundContextItem && !this.foundContextItemExternalDeclaration;
    }

    public int getVersionDeclarationStartIndex() {
        return this.versionDeclStartIndex;
    }

    public int getVersionDeclarationEndIndex() {
        return this.versionDeclEndIndex;
    }

    public int getPrologStartIndex() {
        return this.prologStartIndex;
    }

    public boolean foundVersionDeclaration() {
        return this.foundVersionDeclaration;
    }

    public boolean foundNamespaceDeclaration() {
        return this.foundNamespaceDeclaration;
    }

    public boolean foundExternalVariableDeclaration() {
        return this.foundExternalVariableDeclaration;
    }

    public boolean foundOption() {
        return this.foundOption;
    }

    public boolean foundBaseUri() {
        return this.foundBaseUri;
    }

    public boolean foundDefaultCollation() {
        return this.foundDefaultCollation;
    }

    public boolean foundDefaultElementTypeNamespace() {
        return this.foundDefaultElementTypeNamespace;
    }

    public boolean foundBoundarySpacePolicy() {
        return this.foundBoundarySpacePolicy;
    }

    public boolean foundDefaultFunctionNamespace() {
        return this.foundDefaultFunctionNamespace;
    }

    public boolean foundConstructionMode() {
        return this.foundConstructionMode;
    }

    public boolean foundCopyNamespaces() {
        return this.foundCopyNamespaces;
    }

    public boolean foundDefaultOrderForEmptySequences() {
        return this.foundDefaultOrderForEmptySequences;
    }

    public boolean foundOrderingMode() {
        return this.foundOrderingMode;
    }

    public boolean foundContextItem() {
        return this.foundContextItem;
    }

    public boolean foundHardCodedContextItemDeclaration() {
        return this.foundHardCodedContextItemDeclaration;
    }

    public boolean foundContextItemExternalDeclaration() {
        return this.foundContextItemExternalDeclaration;
    }

    public Iterator getTokensInOrder() {
        return this.tokenSet.iterator();
    }

    public char[] getQuery() {
        return this.query;
    }

    public static final int parseXQueryVersion(char[] buffer) throws XQException {
        int commentLevel = 0;
        int XQV_index = 0;
        int charsRead = buffer.length;
        int quoteStart = 0;
        int versionIndex = 0;
        int previousChar = 0;
        int xqVersionMajor = -1;
        int xqVersionMinor = -1;
        boolean xqVersionML = false;
        int j = 0;
        while (j < charsRead) {
            if (previousChar == 40 && buffer[j] == ':') {
                ++commentLevel;
            } else if (previousChar == 58 && buffer[j] == ')') {
                --commentLevel;
            } else if (commentLevel == 0 && !Character.isWhitespace(buffer[j]) && buffer[j] != '(') {
                if (XQV_index != XQV.length) {
                    if (buffer[j] != XQV[XQV_index++]) {
                        return 10;
                    }
                } else if (buffer[j] == '\"' || buffer[j] == '\'') {
                    if (quoteStart == 0) {
                        quoteStart = j;
                    }
                    if (versionIndex != 0) {
                        if (xqVersionMajor == 1 && xqVersionMinor == 0) {
                            return xqVersionML ? 20 : 1;
                        }
                        throw new XQExceptionImpl("Unrecognised XQuery version '" + new String(buffer, quoteStart + 1, j - (quoteStart + 1)) + "'", "XQJQS003");
                    }
                } else {
                    switch (versionIndex) {
                        case 0: {
                            xqVersionMajor = buffer[j] - 48;
                            break;
                        }
                        case 2: {
                            xqVersionMinor = buffer[j] - 48;
                            break;
                        }
                        case 4: {
                            if (buffer[j] != 'm') break;
                            xqVersionML = true;
                            break;
                        }
                        case 5: {
                            if (buffer[j] != 'l') break;
                            xqVersionML = true;
                        }
                    }
                    ++versionIndex;
                }
            }
            previousChar = buffer[j];
            ++j;
        }
        return 10;
    }
}

