/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.hash;

import java.util.Arrays;
import java.util.Iterator;
import org.basex.query.QueryBiPredicate;
import org.basex.query.QueryException;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.hash.ItemSet;
import org.basex.query.value.item.Item;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.InputInfo;
import org.basex.util.hash.ASet;

public class HashItemSet
extends ASet
implements ItemSet {
    private final QueryBiPredicate<Item, Item> equal;
    Item[] keys;

    public HashItemSet(ItemSet.Mode mode, InputInfo info) {
        this(mode, info, 2L);
    }

    public HashItemSet(ItemSet.Mode mode, InputInfo info, long capacity) {
        super(capacity);
        this.equal = switch (mode) {
            case ItemSet.Mode.ATOMIC -> Item::atomicEqual;
            case ItemSet.Mode.EQUAL -> (k1, k2) -> k1.compare((Item)k2, null, false, info) == 0;
            default -> new DeepEqual(info)::equal;
        };
        this.keys = new Item[this.capacity()];
    }

    public final Item key(int index) {
        return this.keys[index];
    }

    public Item[] keys() {
        return Arrays.copyOfRange(this.keys, 1, this.size);
    }

    @Override
    public final boolean add(Item key) throws QueryException {
        return this.store(key) >= 0;
    }

    public final int put(Item key) throws QueryException {
        int i = this.store(key);
        return Math.abs(i);
    }

    @Override
    public final boolean contains(Item key) throws QueryException {
        return this.index(key) > 0;
    }

    public final int index(Item key) throws QueryException {
        return this.index(key, key.hashCode() & this.capacity() - 1);
    }

    private int store(Item key) throws QueryException {
        int h = key.hashCode();
        int b = h & this.capacity() - 1;
        int i = this.index(key, b);
        if (i > 0) {
            this.keys[i] = key;
            return -i;
        }
        int s = this.size++;
        if (this.checkCapacity()) {
            b = h & this.capacity() - 1;
        }
        this.next[s] = this.buckets[b];
        this.keys[s] = key;
        this.buckets[b] = s;
        return s;
    }

    private int index(Item key, int b) throws QueryException {
        int i = this.buckets[b];
        while (i != 0) {
            if (this.equal.test(this.keys[i], key)) {
                return i;
            }
            i = this.next[i];
        }
        return 0;
    }

    @Override
    protected final int hashCode(int index) {
        return this.keys[index].hashCode();
    }

    @Override
    protected void rehash(int newSize) {
        this.keys = Array.copy(this.keys, new Item[newSize]);
    }

    @Override
    public final Iterator<Item> iterator() {
        return new ArrayIterator<Item>(this.keys, 1, this.size);
    }

    public String toString() {
        return this.toString(this.keys);
    }
}

