/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.util.list.ValueList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.map.XQRecordMap;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.RecordField;
import org.basex.query.value.type.RecordType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;
import org.basex.util.hash.TokenObjectMap;

public final class CRecord
extends Arr {
    public CRecord(InputInfo info, Type type, Expr[] args) {
        super(info, type.seqType(), args);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        return this.values(true, cc) ? cc.preEval(this) : this;
    }

    @Override
    public XQMap item(QueryContext qc, InputInfo ii) throws QueryException {
        RecordType rt = (RecordType)this.seqType().type;
        boolean extensible = rt.isExtensible();
        if (extensible || rt.hasOptional()) {
            MapBuilder mb = new MapBuilder(this.exprs.length);
            TokenObjectMap<RecordField> fields = rt.fields();
            int fs = fields.size();
            for (int f = 1; f <= fs; ++f) {
                RecordField rf;
                boolean add = true;
                Value value = this.exprs[f - 1].value(qc);
                if (value == Empty.VALUE && (rf = fields.value(f)).isOptional() && rf.expr() == null) {
                    add = false;
                }
                if (!add) continue;
                mb.put(fields.key(f), value);
            }
            if (extensible) {
                this.toMap(this.arg(fs), qc).forEach((k, v) -> {
                    if (!mb.contains((Item)k)) {
                        mb.put((Item)k, (Value)v);
                    }
                });
            }
            return mb.map();
        }
        ValueList values = new ValueList(this.exprs.length);
        for (Expr expr : this.exprs) {
            values.add(expr.value(qc));
        }
        return new XQRecordMap((Value[])values.finish(), rt);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new CRecord(this.info, this.seqType().type, CRecord.copyAll((CompileContext)cc, vm, (Expr[])this.args())));
    }

    @Override
    public String description() {
        return "record constructor";
    }

    @Override
    public void toString(QueryString qs) {
        RecordType rt = (RecordType)this.seqType().type;
        QNm name = rt.name();
        if (name != null) {
            qs.token(name).params(this.exprs);
        } else {
            qs.token("{ ");
            int e = -1;
            for (byte[] key : rt.fields()) {
                if (++e != 0) {
                    qs.token(',');
                }
                qs.quoted(key).token(':').token(this.exprs[e]);
            }
            qs.token(" }");
        }
    }
}

