/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.csv;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.csv.CsvSerializer;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.util.list.TokenList;

public final class CsvW3ArraysSerializer
extends CsvSerializer {
    public CsvW3ArraysSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts);
    }

    @Override
    public void serialize(Item item) throws IOException {
        if (!(item instanceof XQArray)) {
            throw QueryError.CSV_SERIALIZE_X_X.getIO("Array expected, found " + String.valueOf(item.seqType()), item);
        }
        XQArray array = (XQArray)item;
        TokenList tl = new TokenList();
        try {
            for (Value value : array.iterable()) {
                if (value.size() != 1L) {
                    throw QueryError.CSV_SERIALIZE_X_X.getIO("Item expected, found " + String.valueOf(value.seqType()), value);
                }
                tl.add(((Item)value).string(null));
            }
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
        this.record(tl);
    }
}

