'\"
'\" Generated from file 'critcl_literals\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2011-2024 Andreas Kupries
'\"
.TH "critcl::literals" n 1\&.4 doc "C Runtime In Tcl (CriTcl)"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
critcl::literals \- CriTcl - Code Gen - Constant string pools
.SH SYNOPSIS
package require \fBTcl 8\&.6\fR
.sp
package require \fBcritcl ?3\&.2?\fR
.sp
package require \fBcritcl::literals ?1\&.4?\fR
.sp
\fB::critcl::literals::def\fR \fIname\fR \fIdefinition\fR ?\fImode\fR?
.sp
.BE
.SH DESCRIPTION
.PP
Be welcome to the \fIC Runtime In Tcl\fR (short: \fICriTcl\fR), a system for embedding and using C
code from within \fITcl\fR [http://core\&.tcl-lang\&.org/tcl] scripts\&.
.PP
This document is the reference manpage for the
\fBcritcl::literals\fR package\&. This package provides convenience
commands for advanced functionality built on top of both critcl core
and package \fBcritcl::iassoc\fR\&.
.PP
Many packages will have a fixed set of string constants
occuring in one or places\&. Most of them will be coded to create a new
string \fBTcl_Obj*\fR from a C \fBchar*\fR every time the constant
is needed, as this is easy to to, despite the inherent waste of
memory\&.
.PP
This package was written to make declaration and management of
string pools which do not waste memory as easy as the wasteful
solution, hiding all attendant complexity from the user\&.
.PP
Its intended audience are mainly developers wishing to write
Tcl packages with embedded C code\&.
.PP
This package resides in the Core Package Layer of CriTcl\&.
.PP
.PS
.nf
+----------------+
|Applications    |
| critcl         |
| critcl::app    |
+----------------+

*================*
|Core Packages   |
| critcl         |
| critcl::util   |
*================*

+----------------+
|Support Packages|
| stubs::*       |
| md5, platform  |
|  \&.\&.\&.           |
+----------------+

.fi
.PE
.PP
.SH API
.TP
\fB::critcl::literals::def\fR \fIname\fR \fIdefinition\fR ?\fImode\fR?
This command defines a C function with the given \fIname\fR which
provides access to a pool of constant strings with a Tcl interpreter\&.
.sp
The \fIdefinition\fR dictionary provides the mapping from the
C-level symbolic names to the string themselves\&.
.sp
The \fImode\fR-list configures the output somewhat\&.
The three allowed modes are \fBc\fR, \fB+list\fR and \fBtcl\fR\&.
All modes can be used together\&.
The default mode is \fBtcl\fR\&.
Using mode \fB+list\fR implies \fBtcl\fR as well\&.
.sp
For mode \fBtcl\fR the new function has two arguments, a
\fBTcl_Interp*\fR pointer refering to the interpreter holding the
string pool, and a code of type "\fIname\fR_names" (see below), the
symbolic name of the literal to return\&. The result of the function is
a \fBTcl_Obj*\fR pointer to the requested string constant\&.
.sp
For mode \fBc\fR the new function has one argument, a code of
type "\fIname\fR_names" (see below), the symbolic name of the literal
to return\&. The result of the function is a \fBconst char*\fR
pointer to the requested string constant\&.
.sp
For mode \fB+list\fR all of \fBtcl\fR applies, plus an
additional function is generated which takes three arguments, in
order, a \fBTcl_Interp*\fR pointer refering to the interpreter
holding the string pool, an \fBint\fR holding the size of the last
argument, and an array of type "\fIname\fR_names" holding the codes
(see below), the symbolic names of the literals to return\&. The result
of the function is a \fBTcl_Obj*\fR pointer to a Tcl list holding the
requested string constants\&.
.sp
The underlying string pool is automatically initialized on
first access, and finalized on interpreter destruction\&.
.sp
The package generates multiple things (declarations and
definitions) with names derived from \fIname\fR, which has to be a
proper C identifier\&.
.RS
.TP
\fIname\fR
The mode \fBtcl\fR function providing access to the string pool\&.
Its signature is
.sp
.CS


Tcl_Obj* \fIname\fR (Tcl_Interp* interp, \fIname\fR_names literal);

.CE
.TP
\fIname\fR_list
The mode \fB+list\fR function providing multi-access to the string pool\&.
Its signature is
.sp
.CS


Tcl_Obj* \fIname\fR_list (Tcl_Interp* interp, int c, \fIname\fR_names* literal);

.CE
.TP
\fIname\fR_cstr
The mode \fBc\fR function providing access to the string pool\&.
Its signature is
.sp
.CS


const char* \fIname\fR_cstr (\fIname\fR_names literal);

.CE
.TP
\fIname\fR_names
A C enumeration type containing the symbolic names of the strings
provided by the pool\&.
.TP
\fIname\fR\&.h
A header file containing the declarations for the accessor functions
and the enumeration type, for use by other parts of the system, if
necessary\&.
.sp
The generated file is stored in a place where it will not
interfere with the overall system outside of the package, yet also be
available for easy inclusion by package files (\fBcsources\fR)\&.
.TP
\fIname\fR
\fINew in version 1\&.1\fR:
For mode \fBtcl\fR the command registers a new result-type for
\fBcritcl::cproc\fR with critcl, which takes an integer result from
the function and converts it to the equivalent string in the pool for
the script\&.
.RE
.PP
.SH EXAMPLE
The example shown below is the specification of the string pool pulled
from the draft work on a Tcl binding to Linux's inotify APIs\&.
.CS


package require Tcl 8\&.6
package require critcl 3\&.2

critcl::buildrequirement {
    package require critcl::literals
}

critcl::literals::def tcl_inotify_strings {
    w_create	"create"
    w_directory	"directory"
    w_events	"events"
    w_file	"file"
    w_handler	"handler"
    w_remove	"remove"
} {c tcl}

# Declarations: tcl_inotify_strings\&.h
# Type:         tcl_inotify_strings_names
# Accessor:     Tcl_Obj*    tcl_inotify_strings      (Tcl_Interp*               interp,
#                                                     tcl_inotify_strings_names literal);
# Accessor:     const char* tcl_inotify_strings_cstr (tcl_inotify_strings_names literal);
# ResultType:   tcl_inotify_strings

.CE
.SH AUTHORS
Andreas Kupries
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such at \fIhttps://github\&.com/andreas-kupries/critcl\fR\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH KEYWORDS
C code, Embedded C Code, Tcl Interp Association, code generator, compile & run, compiler, dynamic code generation, dynamic compilation, generate package, linker, literal pool, on demand compilation, on-the-fly compilation, singleton, string pool
.SH CATEGORY
Glueing/Embedded C code
.SH COPYRIGHT
.nf
Copyright (c) 2011-2024 Andreas Kupries

.fi
