/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.Block;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.PageViewport;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.pagination.RegionBody;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BalancingColumnBreakingAlgorithm;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.apache.fop.layoutmgr.BreakingAlgorithm;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.FloatContentLayoutManager;
import org.apache.fop.layoutmgr.FlowLayoutManager;
import org.apache.fop.layoutmgr.FootnoteBodyLayoutManager;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Page;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.StaticContentLayoutManager;
import org.apache.fop.layoutmgr.list.ListItemLayoutManager;
import org.apache.fop.traits.MinOptMax;

public class PageBreaker
extends AbstractBreaker {
    private boolean firstPart = true;
    private boolean pageBreakHandled;
    private boolean needColumnBalancing;
    private PageProvider pageProvider;
    private Block separatorArea;
    private boolean spanAllActive;
    private boolean layoutRedone;
    private int previousIndex;
    private boolean handlingStartOfFloat;
    private boolean handlingEndOfFloat;
    private int floatHeight;
    private int floatYOffset;
    private List<ListElement> relayedFootnotesList;
    private List<Integer> relayedLengthList;
    private int relayedTotalFootnotesLength;
    private int relayedInsertedFootnotesLength;
    private boolean relayedFootnotesPending;
    private boolean relayedNewFootnotes;
    private int relayedFirstNewFootnoteIndex;
    private int relayedFootnoteListIndex;
    private int relayedFootnoteElementIndex = -1;
    private MinOptMax relayedFootnoteSeparatorLength;
    private int previousFootnoteListIndex = -2;
    private int previousFootnoteElementIndex = -2;
    private int prevousColumnCount;
    private FlowLayoutManager childFLM;
    private StaticContentLayoutManager footnoteSeparatorLM;

    public PageBreaker(PageSequenceLayoutManager pslm) {
        this.pslm = pslm;
        this.pageProvider = pslm.getPageProvider();
        this.childFLM = pslm.getLayoutManagerMaker().makeFlowLayoutManager(pslm, pslm.getPageSequence().getMainFlow());
    }

    @Override
    protected void updateLayoutContext(LayoutContext context) {
        int flowIPD = this.pslm.getCurrentColumnWidth();
        context.setRefIPD(flowIPD);
    }

    @Override
    protected LayoutManager getTopLevelLM() {
        return this.pslm;
    }

    @Override
    protected PageProvider getPageProvider() {
        return this.pslm.getPageProvider();
    }

    boolean doLayout(int flowBPD) {
        return this.doLayout(flowBPD, false);
    }

    @Override
    protected PageBreakingAlgorithm.PageBreakingLayoutListener createLayoutListener() {
        return new PageBreakingAlgorithm.PageBreakingLayoutListener(){

            @Override
            public void notifyOverflow(int part, int amount, FObj obj) {
                Page p = PageBreaker.this.pageProvider.getPageFromColumnIndex(part);
                RegionBody body = (RegionBody)p.getSimplePageMaster().getRegion(58);
                BlockLevelEventProducer eventProducer = BlockLevelEventProducer.Provider.get(body.getUserAgent().getEventBroadcaster());
                boolean canRecover = body.getOverflow() != 42;
                boolean needClip = body.getOverflow() == 57 || body.getOverflow() == 42;
                eventProducer.regionOverflow(this, body.getName(), p.getPageViewport().getPageNumberString(), amount, needClip, canRecover, body.getLocator());
            }
        };
    }

    @Override
    protected int handleSpanChange(LayoutContext childLC, int nextSequenceStartsOn) {
        this.needColumnBalancing = false;
        if (childLC.getNextSpan() != 0) {
            nextSequenceStartsOn = childLC.getNextSpan();
            boolean bl = this.needColumnBalancing = childLC.getNextSpan() == 5 && childLC.getDisableColumnBalancing() == 48;
        }
        if (this.needColumnBalancing) {
            log.debug("Column balancing necessary for the next element list!!!");
        }
        return nextSequenceStartsOn;
    }

    @Override
    protected int getNextBlockList(LayoutContext childLC, int nextSequenceStartsOn) {
        return this.getNextBlockList(childLC, nextSequenceStartsOn, null, null, null);
    }

    @Override
    protected int getNextBlockList(LayoutContext childLC, int nextSequenceStartsOn, Position positionAtIPDChange, LayoutManager restartLM, List<ListElement> firstElements) {
        if (!this.layoutRedone && !this.handlingFloat()) {
            if (!this.firstPart) {
                this.handleBreakTrait(nextSequenceStartsOn);
            }
            this.firstPart = false;
            this.pageBreakHandled = true;
            this.pageProvider.setStartOfNextElementList(this.pslm.getCurrentPageNum(), this.pslm.getCurrentPV().getCurrentSpan().getCurrentFlowIndex(), this.spanAllActive);
        }
        return super.getNextBlockList(childLC, nextSequenceStartsOn, positionAtIPDChange, restartLM, firstElements);
    }

    private boolean containsFootnotes(List<ListElement> contentList, LayoutContext context) {
        boolean containsFootnotes = false;
        if (contentList != null) {
            for (ListElement aContentList : contentList) {
                ListElement element = aContentList;
                if (!(element instanceof KnuthBlockBox) || !((KnuthBlockBox)element).hasAnchors()) continue;
                containsFootnotes = true;
                KnuthBlockBox box = (KnuthBlockBox)element;
                List<List<KnuthElement>> footnotes = PageBreaker.getFootnoteKnuthElements(this.childFLM, context, box.getFootnoteBodyLMs());
                for (List<KnuthElement> footnote : footnotes) {
                    box.addElementList(footnote);
                }
            }
        }
        return containsFootnotes;
    }

    public static List<List<KnuthElement>> getFootnoteKnuthElements(FlowLayoutManager flowLM, LayoutContext context, List<FootnoteBodyLayoutManager> footnoteBodyLMs) {
        ArrayList<List<KnuthElement>> footnotes = new ArrayList<List<KnuthElement>>();
        LayoutContext footnoteContext = LayoutContext.copyOf(context);
        footnoteContext.setStackLimitBP(context.getStackLimitBP());
        footnoteContext.setRefIPD(flowLM.getPSLM().getCurrentPV().getRegionReference(58).getIPD());
        for (FootnoteBodyLayoutManager fblm : footnoteBodyLMs) {
            fblm.setParent(flowLM);
            fblm.initialize();
            List footnote = fblm.getNextKnuthElements(footnoteContext, 135);
            SpaceResolver.resolveElementList(footnote);
            footnotes.add(footnote);
        }
        return footnotes;
    }

    private void handleFootnoteSeparator() {
        StaticContent footnoteSeparator = this.pslm.getPageSequence().getStaticContent("xsl-footnote-separator");
        if (footnoteSeparator != null) {
            this.separatorArea = new Block();
            this.separatorArea.setIPD(this.pslm.getCurrentPV().getRegionReference(58).getIPD());
            this.footnoteSeparatorLM = this.pslm.getLayoutManagerMaker().makeStaticContentLayoutManager(this.pslm, footnoteSeparator, this.separatorArea);
            this.footnoteSeparatorLM.doLayout();
            this.footnoteSeparatorLength = MinOptMax.getInstance(this.separatorArea.getBPD());
        }
    }

    @Override
    protected List<ListElement> getNextKnuthElements(LayoutContext context, int alignment) {
        List<ListElement> contentList = null;
        while (!this.childFLM.isFinished() && contentList == null) {
            contentList = this.childFLM.getNextKnuthElements(context, alignment);
        }
        if (this.containsFootnotes(contentList, context)) {
            this.handleFootnoteSeparator();
        }
        return contentList;
    }

    @Override
    protected List<ListElement> getNextKnuthElements(LayoutContext context, int alignment, Position positionAtIPDChange, LayoutManager restartAtLM) {
        List<ListElement> contentList = null;
        do {
            contentList = this.childFLM.getNextKnuthElements(context, alignment, positionAtIPDChange, restartAtLM);
        } while (!this.childFLM.isFinished() && contentList == null);
        if (this.containsFootnotes(contentList, context)) {
            this.handleFootnoteSeparator();
        }
        return contentList;
    }

    @Override
    protected int getCurrentDisplayAlign() {
        return this.pslm.getCurrentPage().getSimplePageMaster().getRegion(58).getDisplayAlign();
    }

    @Override
    protected boolean hasMoreContent() {
        return !this.childFLM.isFinished();
    }

    @Override
    protected void addAreas(PositionIterator posIter, LayoutContext context) {
        if (this.footnoteSeparatorLM != null) {
            StaticContent footnoteSeparator = this.pslm.getPageSequence().getStaticContent("xsl-footnote-separator");
            this.separatorArea = new Block();
            this.separatorArea.setIPD(this.pslm.getCurrentPV().getRegionReference(58).getIPD());
            this.footnoteSeparatorLM = this.pslm.getLayoutManagerMaker().makeStaticContentLayoutManager(this.pslm, footnoteSeparator, this.separatorArea);
            this.footnoteSeparatorLM.doLayout();
        }
        this.childFLM.addAreas(posIter, context);
    }

    @Override
    protected void doPhase3(PageBreakingAlgorithm alg, int partCount, AbstractBreaker.BlockSequence originalList, AbstractBreaker.BlockSequence effectiveList) {
        if (this.needColumnBalancing) {
            this.redoLayout(alg, partCount, originalList, effectiveList);
            return;
        }
        if (this.shouldRedoLayout(partCount)) {
            this.redoLayout(alg, partCount, originalList, effectiveList);
            return;
        }
        this.addAreas(alg, partCount, originalList, effectiveList);
    }

    @Override
    protected void prepareToRedoLayout(PageBreakingAlgorithm alg, int partCount, AbstractBreaker.BlockSequence originalList, AbstractBreaker.BlockSequence effectiveList) {
        int newStartPos = 0;
        int restartPoint = this.pageProvider.getStartingPartIndexForLastPage(partCount);
        if (restartPoint > 0 && !this.layoutRedone) {
            this.addAreas(alg, restartPoint, originalList, effectiveList);
            AbstractBreaker.PageBreakPosition pbp = alg.getPageBreaks().get(restartPoint - 1);
            newStartPos = alg.par.getFirstBoxIndex(pbp.getLeafPos() + 1);
            if (newStartPos > 0) {
                this.handleBreakTrait(104);
            }
        }
        this.pageBreakHandled = true;
        int currentPageNum = this.pslm.getCurrentPageNum();
        int currentColumn = this.pslm.getCurrentPV().getCurrentSpan().getCurrentFlowIndex();
        this.pageProvider.setStartOfNextElementList(currentPageNum, currentColumn, this.spanAllActive);
        effectiveList.ignoreAtStart = newStartPos;
        if (!this.layoutRedone) {
            this.setLastPageIndex(currentPageNum);
            this.pslm.setCurrentPage(this.pageProvider.getPage(false, currentPageNum));
            this.previousIndex = this.pageProvider.getIndexOfCachedLastPage();
        } else {
            this.setLastPageIndex(currentPageNum + 1);
            this.pageProvider.discardCacheStartingWith(this.previousIndex);
            this.pslm.setCurrentPage(this.pageProvider.getPage(false, currentPageNum));
        }
        this.layoutRedone = true;
    }

    private void redoLayout(PageBreakingAlgorithm alg, int partCount, AbstractBreaker.BlockSequence originalList, AbstractBreaker.BlockSequence effectiveList) {
        boolean fitsOnePage;
        PageBreakingAlgorithm algRestart;
        int newStartPos = 0;
        int restartPoint = this.pageProvider.getStartingPartIndexForLastPage(partCount);
        if (restartPoint > 0) {
            this.addAreas(alg, restartPoint, originalList, effectiveList);
            AbstractBreaker.PageBreakPosition pbp = alg.getPageBreaks().get(restartPoint - 1);
            newStartPos = alg.par.getFirstBoxIndex(pbp.getLeafPos() + 1);
            if (newStartPos > 0) {
                this.handleBreakTrait(104);
            }
        }
        log.debug("Restarting at " + restartPoint + ", new start position: " + newStartPos);
        this.pageBreakHandled = true;
        int currentPageNum = this.pslm.getCurrentPageNum();
        this.pageProvider.setStartOfNextElementList(currentPageNum, this.pslm.getCurrentPV().getCurrentSpan().getCurrentFlowIndex(), this.spanAllActive);
        effectiveList.ignoreAtStart = newStartPos;
        if (this.needColumnBalancing) {
            log.debug("Column balancing now!!!");
            log.debug("===================================================");
            algRestart = new BalancingColumnBreakingAlgorithm(this.getTopLevelLM(), this.getPageProvider(), this.createLayoutListener(), this.alignment, 135, this.footnoteSeparatorLength, this.isPartOverflowRecoveryActivated(), this.pslm.getCurrentPV().getBodyRegion().getColumnCount());
            log.debug("===================================================");
        } else {
            BodyRegion currentBody = this.pageProvider.getPage(false, currentPageNum).getPageViewport().getBodyRegion();
            this.setLastPageIndex(currentPageNum);
            BodyRegion lastBody = this.pageProvider.getPage(false, currentPageNum).getPageViewport().getBodyRegion();
            lastBody.getMainReference().setSpans(currentBody.getMainReference().getSpans());
            log.debug("Last page handling now!!!");
            log.debug("===================================================");
            algRestart = new PageBreakingAlgorithm(this.getTopLevelLM(), this.getPageProvider(), this.createLayoutListener(), alg.getAlignment(), alg.getAlignmentLast(), this.footnoteSeparatorLength, this.isPartOverflowRecoveryActivated(), false, false, null);
            log.debug("===================================================");
        }
        int optimalPageCount = algRestart.findBreakingPoints(effectiveList, newStartPos, 1.0, true, 0);
        if (algRestart.getPageBreaks() != null) {
            log.debug("restart: optimalPageCount= " + optimalPageCount + " pageBreaks.size()= " + algRestart.getPageBreaks().size());
        }
        boolean bl = fitsOnePage = optimalPageCount <= this.pslm.getCurrentPV().getBodyRegion().getMainReference().getCurrentSpan().getColumnCount();
        if (this.needColumnBalancing) {
            if (!fitsOnePage) {
                log.warn("Breaking algorithm produced more columns than are available.");
            }
        } else {
            boolean ipdChange;
            boolean bl2 = ipdChange = algRestart.getIPDdifference() != 0;
            if (fitsOnePage && !ipdChange) {
                this.pslm.setCurrentPage(this.pageProvider.getPage(false, currentPageNum));
            } else {
                this.setLastPageIndex(currentPageNum + 1);
                this.addAreas(alg, restartPoint, partCount - restartPoint, originalList, effectiveList);
                if (!ipdChange && this.pslm.currentPageNum == currentPageNum) {
                    this.pslm.setCurrentPage(this.pslm.makeNewPage(true));
                }
                return;
            }
        }
        this.addAreas(algRestart, optimalPageCount, originalList, effectiveList);
    }

    private void setLastPageIndex(int currentPageNum) {
        int lastPageIndex = this.pslm.getForcedLastPageNum(currentPageNum);
        this.pageProvider.setLastPageIndex(lastPageIndex);
    }

    @Override
    protected void startPart(AbstractBreaker.BlockSequence list, int breakClass, boolean emptyContent) {
        log.debug("startPart() breakClass=" + PageBreaker.getBreakClassName(breakClass));
        if (this.pslm.getCurrentPage() == null) {
            throw new IllegalStateException("curPage must not be null");
        }
        if (!this.pageBreakHandled) {
            if (!this.firstPart) {
                this.handleBreakTrait(breakClass, emptyContent);
            }
            this.pageProvider.setStartOfNextElementList(this.pslm.getCurrentPageNum(), this.pslm.getCurrentPV().getCurrentSpan().getCurrentFlowIndex(), this.spanAllActive);
        }
        this.pageBreakHandled = false;
        this.firstPart = false;
    }

    @Override
    protected void handleEmptyContent() {
        this.pslm.getCurrentPV().getPage().fakeNonEmpty();
    }

    @Override
    protected void finishPart(PageBreakingAlgorithm alg, AbstractBreaker.PageBreakPosition pbp) {
        if (!this.pslm.getTableHeaderFootnotes().isEmpty() || pbp.footnoteFirstListIndex < pbp.footnoteLastListIndex || pbp.footnoteFirstElementIndex <= pbp.footnoteLastElementIndex || !this.pslm.getTableFooterFootnotes().isEmpty()) {
            for (List<KnuthElement> footnote : this.pslm.getTableHeaderFootnotes()) {
                this.addFootnoteAreas(footnote);
            }
            for (int i = pbp.footnoteFirstListIndex; i <= pbp.footnoteLastListIndex; ++i) {
                List<KnuthElement> elementList = alg.getFootnoteList(i);
                int firstIndex = i == pbp.footnoteFirstListIndex ? pbp.footnoteFirstElementIndex : 0;
                int lastIndex = i == pbp.footnoteLastListIndex ? pbp.footnoteLastElementIndex : elementList.size() - 1;
                this.addFootnoteAreas(elementList, firstIndex, lastIndex + 1);
            }
            for (List<KnuthElement> footnote : this.pslm.getTableFooterFootnotes()) {
                this.addFootnoteAreas(footnote);
            }
            Footnote parentArea = this.pslm.getCurrentPV().getBodyRegion().getFootnote();
            int topOffset = this.pslm.getCurrentPV().getBodyRegion().getBPD() - parentArea.getBPD();
            if (this.separatorArea != null) {
                topOffset -= this.separatorArea.getBPD();
            }
            parentArea.setTop(topOffset);
            parentArea.setSeparator(this.separatorArea);
        }
        this.pslm.getCurrentPV().getCurrentSpan().notifyFlowsFinished();
        this.pslm.clearTableHeadingFootnotes();
    }

    private void addFootnoteAreas(List<KnuthElement> footnote) {
        this.addFootnoteAreas(footnote, 0, footnote.size());
    }

    private void addFootnoteAreas(List<KnuthElement> footnote, int startIndex, int endIndex) {
        SpaceResolver.performConditionalsNotification(footnote, startIndex, endIndex - 1, -1);
        LayoutContext childLC = LayoutContext.newInstance();
        AreaAdditionUtil.addAreas(null, new KnuthPossPosIter(footnote, startIndex, endIndex), childLC);
    }

    @Override
    protected FlowLayoutManager getCurrentChildLM() {
        return this.childFLM;
    }

    @Override
    protected void observeElementList(List elementList) {
        ElementListObserver.observe(elementList, "breaker", this.pslm.getFObj().getId());
    }

    private void handleBreakTrait(int breakVal) {
        this.handleBreakTrait(breakVal, false);
    }

    private void handleBreakTrait(int breakVal, boolean emptyContent) {
        Page curPage = this.pslm.getCurrentPage();
        switch (breakVal) {
            case 5: {
                curPage.getPageViewport().createSpan(true);
                this.spanAllActive = true;
                return;
            }
            case 95: {
                curPage.getPageViewport().createSpan(false);
                this.spanAllActive = false;
                return;
            }
            case -1: 
            case 9: 
            case 28: 
            case 104: {
                PageViewport pv = curPage.getPageViewport();
                boolean forceNewPageWithSpan = false;
                RegionBody rb = (RegionBody)curPage.getSimplePageMaster().getRegion(58);
                boolean bl = forceNewPageWithSpan = rb.getColumnCount() > 1 && pv.getCurrentSpan().getColumnCount() == 1;
                if (forceNewPageWithSpan) {
                    this.checkPagePositionOnly();
                    log.trace("Forcing new page with span");
                    curPage = this.pslm.makeNewPage(false);
                    curPage.getPageViewport().createSpan(true);
                } else if (breakVal == 104) {
                    this.handleBreakBeforeFollowingPage(breakVal);
                } else if (pv.getCurrentSpan().hasMoreFlows()) {
                    log.trace("Moving to next flow");
                    pv.getCurrentSpan().moveToNextFlow();
                } else {
                    this.checkPagePositionOnly();
                    log.trace("Making new page");
                    this.pslm.makeNewPage(false, emptyContent);
                }
                return;
            }
        }
        this.handleBreakBeforeFollowingPage(breakVal);
    }

    private void checkPagePositionOnly() {
        if (this.pslm.getCurrentPage().isPagePositionOnly && !this.pslm.fobj.getUserAgent().isLegacySkipPagePositionOnly()) {
            throw new AbstractBreaker.PagePositionOnlyException();
        }
    }

    private void handleBreakBeforeFollowingPage(int breakVal) {
        log.debug("handling break-before after page " + this.pslm.getCurrentPageNum() + " breakVal=" + PageBreaker.getBreakClassName(breakVal));
        if (this.needBlankPageBeforeNew(breakVal)) {
            this.checkPagePositionOnly();
            log.trace("Inserting blank page");
            this.pslm.makeNewPage(true);
        }
        if (this.needNewPage(breakVal)) {
            this.checkPagePositionOnly();
            log.trace("Making new page");
            this.pslm.makeNewPage(false);
        }
    }

    private boolean needBlankPageBeforeNew(int breakVal) {
        if (breakVal == 104 || this.pslm.getCurrentPage().getPageViewport().getPage().isEmpty()) {
            return false;
        }
        if (this.pslm.getCurrentPageNum() % 2 == 0) {
            return breakVal == 44;
        }
        return breakVal == 100;
    }

    private boolean needNewPage(int breakVal) {
        if (this.pslm.getCurrentPage().getPageViewport().getPage().isEmpty()) {
            if (breakVal == 104) {
                return false;
            }
            if (this.pslm.getCurrentPageNum() % 2 == 0) {
                return breakVal == 100;
            }
            return breakVal == 44;
        }
        return true;
    }

    @Override
    protected boolean shouldRedoLayout() {
        return this.shouldRedoLayout(-1);
    }

    protected boolean shouldRedoLayout(int partCount) {
        boolean lastPageMasterDefined = this.pslm.getPageSequence().hasPagePositionLast();
        if (!lastPageMasterDefined && partCount != -1) {
            lastPageMasterDefined = this.pslm.getPageSequence().hasPagePositionOnly() && this.pslm.isOnFirstPage(partCount - 1);
        }
        return !this.hasMoreContent() && lastPageMasterDefined && !this.layoutRedone;
    }

    @Override
    protected boolean wasLayoutRedone() {
        return this.layoutRedone;
    }

    @Override
    protected boolean lastPageHasIPDChange(int optimalPageCount) {
        boolean lastPageMasterDefined = this.pslm.getPageSequence().hasPagePositionLast();
        boolean onlyPageMasterDefined = this.pslm.getPageSequence().hasPagePositionOnly();
        if (lastPageMasterDefined && !onlyPageMasterDefined) {
            int currentColumnCount = this.pageProvider.getCurrentColumnCount();
            boolean changeInColumnCount = this.prevousColumnCount > 0 && this.prevousColumnCount != currentColumnCount;
            this.prevousColumnCount = currentColumnCount;
            if (currentColumnCount > 1 && optimalPageCount % currentColumnCount == 0 || changeInColumnCount) {
                return false;
            }
            int currentIPD = this.pageProvider.getCurrentIPD();
            int lastPageIPD = this.pageProvider.getLastPageIPD();
            return lastPageIPD != -1 && currentIPD != lastPageIPD;
        }
        return false;
    }

    protected boolean handlingStartOfFloat() {
        return this.handlingStartOfFloat;
    }

    protected void handleStartOfFloat(int fHeight, int fYOffset) {
        this.handlingStartOfFloat = true;
        this.handlingEndOfFloat = false;
        this.floatHeight = fHeight;
        this.floatYOffset = fYOffset;
        this.childFLM.handleFloatOn();
    }

    protected int getFloatHeight() {
        return this.floatHeight;
    }

    protected int getFloatYOffset() {
        return this.floatYOffset;
    }

    protected boolean handlingEndOfFloat() {
        return this.handlingEndOfFloat;
    }

    protected void handleEndOfFloat(int fHeight) {
        this.handlingEndOfFloat = true;
        this.handlingStartOfFloat = false;
        this.floatHeight = fHeight;
        this.childFLM.handleFloatOff();
    }

    protected boolean handlingFloat() {
        return this.handlingStartOfFloat || this.handlingEndOfFloat;
    }

    public int getOffsetDueToFloat() {
        this.handlingEndOfFloat = false;
        return this.floatHeight + this.floatYOffset;
    }

    @Override
    protected int handleFloatLayout(PageBreakingAlgorithm alg, int optimalPageCount, AbstractBreaker.BlockSequence blockList, LayoutContext childLC) {
        this.pageBreakHandled = true;
        List firstElements = Collections.EMPTY_LIST;
        BreakingAlgorithm.KnuthNode floatNode = alg.getBestFloatEdgeNode();
        int floatPosition = floatNode.position;
        KnuthElement floatElem = alg.getElement(floatPosition);
        Position positionAtBreak = floatElem.getPosition();
        if (!(positionAtBreak instanceof SpaceResolver.SpaceHandlingBreakPosition)) {
            throw new UnsupportedOperationException("Don't know how to restart at position" + positionAtBreak);
        }
        positionAtBreak = positionAtBreak.getPosition();
        this.addAreas(alg, optimalPageCount, blockList, blockList);
        this.blockLists.clear();
        this.blockListIndex = -1;
        LayoutManager restartAtLM = null;
        if (positionAtBreak != null && positionAtBreak.getIndex() == -1) {
            if (positionAtBreak instanceof ListItemLayoutManager.ListItemPosition) {
                restartAtLM = positionAtBreak.getLM();
            } else {
                KnuthElement nextElement;
                Position position;
                ListIterator iter = blockList.listIterator(floatPosition + 1);
                while ((position = (nextElement = (KnuthElement)iter.next()).getPosition()) == null || position instanceof SpaceResolver.SpaceHandlingPosition || position instanceof SpaceResolver.SpaceHandlingBreakPosition && position.getPosition().getIndex() == -1) {
                }
                LayoutManager surroundingLM = positionAtBreak.getLM();
                while (position.getLM() != surroundingLM) {
                    position = position.getPosition();
                }
                restartAtLM = position.getPosition().getLM();
            }
        }
        int nextSequenceStartsOn = this.getNextBlockList(childLC, 28, positionAtBreak, restartAtLM, firstElements);
        return nextSequenceStartsOn;
    }

    @Override
    protected void addAreasForFloats(PageBreakingAlgorithm alg, int startPart, int partCount, AbstractBreaker.BlockSequence originalList, AbstractBreaker.BlockSequence effectiveList, LayoutContext childLC, int lastBreak, int startElementIndex, int endElementIndex) {
        KnuthPenalty pen;
        ListElement lastBreakElement;
        AbstractBreaker.FloatPosition pbp = alg.getFloatPosition();
        int lastBreakClass = startElementIndex == 0 ? effectiveList.getStartOn() : ((lastBreakElement = effectiveList.getElement(endElementIndex)).isPenalty() ? ((pen = (KnuthPenalty)lastBreakElement).getPenalty() == 1000 ? 28 : pen.getBreakClass()) : 28);
        endElementIndex = pbp.getLeafPos();
        log.debug("PLM> part: " + (startPart + partCount + 1) + ", start at pos " + (startElementIndex += startElementIndex == 0 ? effectiveList.ignoreAtStart : 0) + ", break at pos " + endElementIndex + ", break class = " + PageBreaker.getBreakClassName(lastBreakClass));
        this.startPart(effectiveList, lastBreakClass, false);
        int displayAlign = this.getCurrentDisplayAlign();
        int notificationEndElementIndex = endElementIndex;
        if (((KnuthElement)effectiveList.get(endElementIndex -= endElementIndex == originalList.size() - 1 ? effectiveList.ignoreAtEnd : 0)).isGlue()) {
            --endElementIndex;
        }
        if ((startElementIndex = alg.par.getFirstBoxIndex(startElementIndex)) <= endElementIndex) {
            if (log.isDebugEnabled()) {
                log.debug("     addAreas from " + startElementIndex + " to " + endElementIndex);
            }
            childLC.setSpaceAdjust(pbp.bpdAdjust);
            if (pbp.difference != 0 && displayAlign == 23) {
                childLC.setSpaceBefore(pbp.difference / 2);
            } else if (pbp.difference != 0 && displayAlign == 3) {
                childLC.setSpaceBefore(pbp.difference);
            }
            SpaceResolver.performConditionalsNotification(effectiveList, startElementIndex, notificationEndElementIndex, lastBreak);
            this.addAreas(new KnuthPossPosIter(effectiveList, startElementIndex, endElementIndex + 1), childLC);
            if (alg.handlingStartOfFloat()) {
                for (int k = startElementIndex; k < endElementIndex + 1; ++k) {
                    ListElement le = effectiveList.getElement(k);
                    if (!(le instanceof KnuthBlockBox)) continue;
                    KnuthBlockBox kbb = (KnuthBlockBox)le;
                    for (FloatContentLayoutManager fclm : kbb.getFloatContentLMs()) {
                        fclm.processAreas(childLC);
                        int floatHeight = fclm.getFloatHeight();
                        int floatYOffset = fclm.getFloatYOffset();
                        PageSequenceLayoutManager pslm = (PageSequenceLayoutManager)this.getTopLevelLM();
                        pslm.recordStartOfFloat(floatHeight, floatYOffset);
                    }
                }
            }
            if (alg.handlingEndOfFloat()) {
                PageSequenceLayoutManager pslm = (PageSequenceLayoutManager)this.getTopLevelLM();
                pslm.setEndIntrusionAdjustment(0);
                pslm.setStartIntrusionAdjustment(0);
                int effectiveFloatHeight = alg.getFloatHeight();
                pslm.recordEndOfFloat(effectiveFloatHeight);
            }
            if (alg.handlingFloat()) {
                PageSequenceLayoutManager pslm = (PageSequenceLayoutManager)this.getTopLevelLM();
                alg.relayFootnotes(pslm);
            }
        } else {
            this.handleEmptyContent();
        }
        this.pageBreakHandled = true;
    }

    public void holdFootnotes(List fl, List<Integer> ll, int tfl, int ifl, boolean fp, boolean nf, int fnfi, int fli, int fei, MinOptMax fsl, int pfli, int pfei) {
        this.relayedFootnotesList = fl;
        this.relayedLengthList = ll;
        this.relayedTotalFootnotesLength = tfl;
        this.relayedInsertedFootnotesLength = ifl;
        this.relayedFootnotesPending = fp;
        this.relayedNewFootnotes = nf;
        this.relayedFirstNewFootnoteIndex = fnfi;
        this.relayedFootnoteListIndex = fli;
        this.relayedFootnoteElementIndex = fei;
        this.relayedFootnoteSeparatorLength = fsl;
        this.previousFootnoteListIndex = pfli;
        this.previousFootnoteElementIndex = pfei;
    }

    public void retrieveFootones(PageBreakingAlgorithm alg) {
        if (this.relayedFootnotesList != null && this.relayedFootnotesList.size() > 0) {
            alg.loadFootnotes(this.relayedFootnotesList, this.relayedLengthList, this.relayedTotalFootnotesLength, this.relayedInsertedFootnotesLength, this.relayedFootnotesPending, this.relayedNewFootnotes, this.relayedFirstNewFootnoteIndex, this.relayedFootnoteListIndex, this.relayedFootnoteElementIndex, this.relayedFootnoteSeparatorLength, this.previousFootnoteListIndex, this.previousFootnoteElementIndex);
            if (alg.handlingFloat()) {
                this.relayedFootnotesList = null;
                this.relayedLengthList = null;
                this.relayedTotalFootnotesLength = 0;
                this.relayedInsertedFootnotesLength = 0;
                this.relayedFootnotesPending = false;
                this.relayedNewFootnotes = false;
                this.relayedFirstNewFootnoteIndex = 0;
                this.relayedFootnoteListIndex = 0;
                this.relayedFootnoteElementIndex = -1;
                this.relayedFootnoteSeparatorLength = null;
            }
        }
    }

    @Override
    protected void addAreas(PageBreakingAlgorithm alg, int startPart, int partCount, AbstractBreaker.BlockSequence originalList, AbstractBreaker.BlockSequence effectiveList, LayoutContext childLC) {
        super.addAreas(alg, startPart, partCount, originalList, effectiveList, childLC);
        if (!alg.handlingFloat()) {
            PageSequenceLayoutManager pslm = (PageSequenceLayoutManager)this.getTopLevelLM();
            alg.relayFootnotes(pslm);
        }
    }
}

