#include "HamClock.h"
                
/* manage a list of fixed lat/lng zones with screen coord polygons updated for the current projection.
 * since some zones may wrap or otherwise be split, we may need to create two polygons per zone.
 * vertices with s[0].x != 0 form the first polygon, the second are those with s[1].x != 0.
 * corresponding bounding boxes are in bound_b[0] and [1].
 */             
                
/* one zone polygon vertex 
 */             
typedef struct {
    const int16_t lat, lng;             // degs N E *100
    SCoord s[2];                        // Raw coord, two polygons whichever .x != 0
} ZoneVertex;           
                        
/* collection of vertices comprising a zone collection
 */                 
typedef struct {
    const uint16_t zone_n;              // zone number
    int16_t lat_lbl, lng_lbl;           // label, same encoding as ZoneVertex
    ZoneVertex *verts;                  // ploygon vertices, can be 2 lists
    uint16_t n_verts;
    SCoord s_lbl;                       // app screen coord of label
    SBox bound_b[2];                    // app screen coord bounding box, [1].x != only if required
} ZonePoly;     
                
#define LATC2DEG(l)     ((l) * 0.01F)   // ZoneVertex latitude compressed to degrees    
#define LNGC2DEG(l)     ((l) * 0.01F)   // ZoneVertex longitude compressed to degrees   
                    
static ZoneVertex cqz01[] = {
    { 9000, -10900, {}},
    { 8905, -10900, {}},
    { 8809, -10900, {}},
    { 8714, -10900, {}},
    { 8618, -10900, {}},
    { 8523, -10900, {}},
    { 8428, -10900, {}},
    { 8332, -10900, {}},
    { 8237, -10900, {}},
    { 8142, -10900, {}},
    { 8046, -10900, {}},
    { 7951, -10900, {}},
    { 7855, -10900, {}},
    { 7760, -10900, {}},
    { 7720, -10803, {}},
    { 7680, -10707, {}},
    { 7640, -10610, {}},
    { 7600, -10513, {}},
    { 7560, -10417, {}},
    { 7520, -10320, {}},
    { 7427, -10327, {}},
    { 7333, -10333, {}},
    { 7240, -10340, {}},
    { 7204, -10256, {}},
    { 7168, -10172, {}},
    { 7132, -10088, {}},
    { 7096, -10004, {}},
    { 7060, -9920, {}},
    { 6973, -10013, {}},
    { 6887, -10107, {}},
    { 6800, -10200, {}},
    { 6700, -10200, {}},
    { 6600, -10200, {}},
    { 6500, -10200, {}},
    { 6400, -10200, {}},
    { 6300, -10200, {}},
    { 6200, -10200, {}},
    { 6100, -10200, {}},
    { 6000, -10200, {}},
    { 6000, -10298, {}},
    { 6000, -10397, {}},
    { 6000, -10495, {}},
    { 6000, -10594, {}},
    { 6000, -10692, {}},
    { 6000, -10790, {}},
    { 6000, -10889, {}},
    { 6000, -10987, {}},
    { 6000, -11085, {}},
    { 6000, -11184, {}},
    { 6000, -11282, {}},
    { 6000, -11381, {}},
    { 6000, -11479, {}},
    { 6000, -11577, {}},
    { 6000, -11676, {}},
    { 6000, -11774, {}},
    { 6000, -11872, {}},
    { 6000, -11971, {}},
    { 6000, -12069, {}},
    { 6000, -12168, {}},
    { 6000, -12266, {}},
    { 6000, -12364, {}},
    { 6000, -12463, {}},
    { 6000, -12561, {}},
    { 6000, -12659, {}},
    { 6000, -12758, {}},
    { 6000, -12856, {}},
    { 6000, -12955, {}},
    { 6000, -13053, {}},
    { 6000, -13151, {}},
    { 6000, -13250, {}},
    { 6000, -13348, {}},
    { 6000, -13446, {}},
    { 6000, -13545, {}},
    { 6000, -13643, {}},
    { 6000, -13742, {}},
    { 6000, -13840, {}},
    { 6000, -13900, {}},
    { 6000, -13880, {}},
    { 5980, -13860, {}},
    { 5940, -13800, {}},
    { 5940, -13780, {}},
    { 5920, -13760, {}},
    { 5900, -13760, {}},
    { 5900, -13720, {}},
    { 5920, -13700, {}},
    { 5920, -13660, {}},
    { 5940, -13640, {}},
    { 5960, -13620, {}},
    { 5960, -13600, {}},
    { 5980, -13580, {}},
    { 5980, -13540, {}},
    { 5960, -13520, {}},
    { 5940, -13500, {}},
    { 5920, -13480, {}},
    { 5920, -13460, {}},
    { 5900, -13440, {}},
    { 5880, -13400, {}},
    { 5860, -13380, {}},
    { 5860, -13360, {}},
    { 5840, -13340, {}},
    { 5820, -13320, {}},
    { 5780, -13280, {}},
    { 5740, -13260, {}},
    { 5740, -13240, {}},
    { 5700, -13240, {}},
    { 5700, -13200, {}},
    { 5680, -13200, {}},
    { 5660, -13180, {}},
    { 5660, -13160, {}},
    { 5640, -13120, {}},
    { 5640, -13080, {}},
    { 5620, -13060, {}},
    { 5620, -13040, {}},
    { 5620, -13020, {}},
    { 5600, -13000, {}},
    { 5580, -13020, {}},
    { 5560, -13020, {}},
    { 5540, -13000, {}},
    { 5520, -13020, {}},
    { 5500, -13020, {}},
    { 5480, -13040, {}},
    { 5480, -13060, {}},
    { 5465, -13160, {}},
    { 5450, -13260, {}},
    { 5435, -13360, {}},
    { 5420, -13460, {}},
    { 5350, -13550, {}},
    { 5280, -13640, {}},
    { 5210, -13730, {}},
    { 5140, -13820, {}},
    { 5070, -13910, {}},
    { 5000, -14000, {}},
    { 4900, -14000, {}},
    { 4800, -14000, {}},
    { 4700, -14000, {}},
    { 4600, -14000, {}},
    { 4500, -14000, {}},
    { 4400, -14000, {}},
    { 4300, -14000, {}},
    { 4200, -14000, {}},
    { 4100, -14000, {}},
    { 4000, -14000, {}},
    { 4000, -14100, {}},
    { 4000, -14200, {}},
    { 4000, -14300, {}},
    { 4000, -14400, {}},
    { 4000, -14500, {}},
    { 4000, -14600, {}},
    { 4000, -14700, {}},
    { 4000, -14800, {}},
    { 4000, -14900, {}},
    { 4000, -15000, {}},
    { 4000, -15100, {}},
    { 4000, -15200, {}},
    { 4000, -15300, {}},
    { 4000, -15400, {}},
    { 4000, -15500, {}},
    { 4000, -15600, {}},
    { 4000, -15700, {}},
    { 4000, -15800, {}},
    { 4000, -15900, {}},
    { 4000, -16000, {}},
    { 4000, -16100, {}},
    { 4000, -16200, {}},
    { 4000, -16300, {}},
    { 4000, -16400, {}},
    { 4000, -16500, {}},
    { 4000, -16600, {}},
    { 4000, -16700, {}},
    { 4000, -16800, {}},
    { 4000, -16900, {}},
    { 4000, -17000, {}},
    { 4000, -17100, {}},
    { 4000, -17200, {}},
    { 4000, -17300, {}},
    { 4000, -17400, {}},
    { 4000, -17500, {}},
    { 4000, -17600, {}},
    { 4000, -17700, {}},
    { 4000, -17800, {}},
    { 4000, -17900, {}},
    { 4000, -18000, {}},
    { 4000, 17900, {}},
    { 4000, 17800, {}},
    { 4000, 17700, {}},
    { 4000, 17600, {}},
    { 4000, 17500, {}},
    { 4000, 17400, {}},
    { 4000, 17300, {}},
    { 4000, 17200, {}},
    { 4000, 17100, {}},
    { 4000, 17000, {}},
    { 4100, 17000, {}},
    { 4200, 17000, {}},
    { 4300, 17000, {}},
    { 4400, 17000, {}},
    { 4500, 17000, {}},
    { 4600, 17000, {}},
    { 4700, 17000, {}},
    { 4800, 17000, {}},
    { 4900, 17000, {}},
    { 5000, 17000, {}},
    { 5100, 17000, {}},
    { 5200, 17000, {}},
    { 5300, 17000, {}},
    { 5359, 17097, {}},
    { 5418, 17195, {}},
    { 5477, 17292, {}},
    { 5537, 17390, {}},
    { 5596, 17487, {}},
    { 5655, 17584, {}},
    { 5714, 17682, {}},
    { 5773, 17779, {}},
    { 5832, 17877, {}},
    { 5891, 17974, {}},
    { 5950, -17929, {}},
    { 6010, -17831, {}},
    { 6069, -17734, {}},
    { 6128, -17637, {}},
    { 6187, -17539, {}},
    { 6246, -17442, {}},
    { 6305, -17344, {}},
    { 6364, -17247, {}},
    { 6423, -17150, {}},
    { 6483, -17052, {}},
    { 6542, -16955, {}},
    { 6601, -16857, {}},
    { 6660, -16760, {}},
    { 6725, -16855, {}},
    { 6789, -16951, {}},
    { 6854, -17046, {}},
    { 6918, -17142, {}},
    { 6983, -17237, {}},
    { 7048, -17332, {}},
    { 7112, -17428, {}},
    { 7177, -17523, {}},
    { 7242, -17618, {}},
    { 7306, -17714, {}},
    { 7371, -17809, {}},
    { 7435, -17905, {}},
    { 7500, -18000, {}},
    { 7600, -18000, {}},
    { 7700, -18000, {}},
    { 7800, -18000, {}},
    { 7900, -18000, {}},
    { 8000, -18000, {}},
    { 8100, -18000, {}},
    { 8200, -18000, {}},
    { 8300, -18000, {}},
    { 8400, -18000, {}},
    { 8500, -18000, {}},
    { 8600, -18000, {}},
    { 8700, -18000, {}},
    { 8800, -18000, {}},
    { 8900, -18000, {}},
    { 9000, -18000, {}},
    { 9000, -17900, {}},
    { 9000, -17800, {}},
    { 9000, -17700, {}},
    { 9000, -17600, {}},
    { 9000, -17500, {}},
    { 9000, -17400, {}},
    { 9000, -17300, {}},
    { 9000, -17200, {}},
    { 9000, -17100, {}},
    { 9000, -17000, {}},
    { 9000, -16900, {}},
    { 9000, -16800, {}},
    { 9000, -16700, {}},
    { 9000, -16600, {}},
    { 9000, -16500, {}},
    { 9000, -16400, {}},
    { 9000, -16300, {}},
    { 9000, -16200, {}},
    { 9000, -16100, {}},
    { 9000, -16000, {}},
    { 9000, -15900, {}},
    { 9000, -15800, {}},
    { 9000, -15700, {}},
    { 9000, -15600, {}},
    { 9000, -15500, {}},
    { 9000, -15400, {}},
    { 9000, -15300, {}},
    { 9000, -15200, {}},
    { 9000, -15100, {}},
    { 9000, -15000, {}},
    { 9000, -14900, {}},
    { 9000, -14800, {}},
    { 9000, -14700, {}},
    { 9000, -14600, {}},
    { 9000, -14500, {}},
    { 9000, -14400, {}},
    { 9000, -14300, {}},
    { 9000, -14200, {}},
    { 9000, -14100, {}},
    { 9000, -14000, {}},
    { 9000, -13900, {}},
    { 9000, -13800, {}},
    { 9000, -13700, {}},
    { 9000, -13600, {}},
    { 9000, -13500, {}},
    { 9000, -13400, {}},
    { 9000, -13300, {}},
    { 9000, -13200, {}},
    { 9000, -13100, {}},
    { 9000, -13000, {}},
    { 9000, -12900, {}},
    { 9000, -12800, {}},
    { 9000, -12700, {}},
    { 9000, -12600, {}},
    { 9000, -12500, {}},
    { 9000, -12400, {}},
    { 9000, -12300, {}},
    { 9000, -12200, {}},
    { 9000, -12100, {}},
    { 9000, -12000, {}},
    { 9000, -11900, {}},
    { 9000, -11800, {}},
    { 9000, -11700, {}},
    { 9000, -11600, {}},
    { 9000, -11500, {}},
    { 9000, -11400, {}},
    { 9000, -11300, {}},
    { 9000, -11200, {}},
    { 9000, -11100, {}},
    { 9000, -11000, {}},
    { 9000, -10900, {}},
};

static ZoneVertex cqz02[] = {
    { 9000, -10900, {}},
    { 8905, -10900, {}},
    { 8809, -10900, {}},
    { 8714, -10900, {}},
    { 8618, -10900, {}},
    { 8523, -10900, {}},
    { 8428, -10900, {}},
    { 8332, -10900, {}},
    { 8237, -10900, {}},
    { 8142, -10900, {}},
    { 8046, -10900, {}},
    { 7951, -10900, {}},
    { 7855, -10900, {}},
    { 7760, -10900, {}},
    { 7720, -10803, {}},
    { 7680, -10707, {}},
    { 7640, -10610, {}},
    { 7600, -10513, {}},
    { 7560, -10417, {}},
    { 7520, -10320, {}},
    { 7427, -10327, {}},
    { 7333, -10333, {}},
    { 7240, -10340, {}},
    { 7204, -10256, {}},
    { 7168, -10172, {}},
    { 7132, -10088, {}},
    { 7096, -10004, {}},
    { 7060, -9920, {}},
    { 6973, -10013, {}},
    { 6887, -10107, {}},
    { 6800, -10200, {}},
    { 6700, -10200, {}},
    { 6600, -10200, {}},
    { 6500, -10200, {}},
    { 6400, -10200, {}},
    { 6300, -10200, {}},
    { 6200, -10200, {}},
    { 6100, -10200, {}},
    { 6000, -10200, {}},
    { 6000, -10100, {}},
    { 6000, -10000, {}},
    { 6000, -9900, {}},
    { 6000, -9800, {}},
    { 6000, -9700, {}},
    { 6000, -9600, {}},
    { 6000, -9500, {}},
    { 6000, -9400, {}},
    { 6000, -9300, {}},
    { 6000, -9200, {}},
    { 6000, -9100, {}},
    { 6000, -9000, {}},
    { 6000, -8900, {}},
    { 6000, -8800, {}},
    { 6000, -8700, {}},
    { 6000, -8600, {}},
    { 6000, -8500, {}},
    { 5910, -8430, {}},
    { 5820, -8360, {}},
    { 5730, -8290, {}},
    { 5640, -8220, {}},
    { 5550, -8150, {}},
    { 5460, -8080, {}},
    { 5367, -8047, {}},
    { 5273, -8013, {}},
    { 5180, -7980, {}},
    { 5160, -7960, {}},
    { 5120, -7960, {}},
    { 5100, -7960, {}},
    { 5080, -7960, {}},
    { 5000, -7960, {}},
    { 5000, -7862, {}},
    { 5000, -7764, {}},
    { 5000, -7666, {}},
    { 5000, -7568, {}},
    { 5000, -7470, {}},
    { 5000, -7372, {}},
    { 5000, -7274, {}},
    { 5000, -7176, {}},
    { 5000, -7078, {}},
    { 5000, -6980, {}},
    { 5000, -6882, {}},
    { 5000, -6784, {}},
    { 5000, -6686, {}},
    { 5000, -6588, {}},
    { 5000, -6490, {}},
    { 5000, -6392, {}},
    { 5000, -6294, {}},
    { 5000, -6196, {}},
    { 5000, -6098, {}},
    { 5000, -6000, {}},
    { 5045, -5900, {}},
    { 5090, -5800, {}},
    { 5135, -5700, {}},
    { 5180, -5600, {}},
    { 5180, -5540, {}},
    { 5197, -5449, {}},
    { 5214, -5357, {}},
    { 5231, -5266, {}},
    { 5249, -5174, {}},
    { 5266, -5083, {}},
    { 5283, -4991, {}},
    { 5300, -4900, {}},
    { 5394, -4946, {}},
    { 5489, -4991, {}},
    { 5583, -5037, {}},
    { 5677, -5083, {}},
    { 5771, -5129, {}},
    { 5866, -5174, {}},
    { 5960, -5220, {}},
    { 6055, -5290, {}},
    { 6150, -5360, {}},
    { 6245, -5430, {}},
    { 6340, -5500, {}},
    { 6435, -5570, {}},
    { 6530, -5640, {}},
    { 6625, -5710, {}},
    { 6720, -5780, {}},
    { 6790, -5880, {}},
    { 6860, -5980, {}},
    { 6930, -6080, {}},
    { 7000, -6180, {}},
    { 7070, -6280, {}},
    { 7140, -6380, {}},
    { 7210, -6480, {}},
    { 7280, -6580, {}},
    { 7350, -6680, {}},
    { 7420, -6780, {}},
    { 7437, -6869, {}},
    { 7454, -6957, {}},
    { 7471, -7046, {}},
    { 7489, -7134, {}},
    { 7506, -7223, {}},
    { 7523, -7311, {}},
    { 7540, -7400, {}},
    { 7640, -7440, {}},
    { 7740, -7480, {}},
    { 7800, -7420, {}},
    { 7860, -7360, {}},
    { 7885, -7265, {}},
    { 7910, -7170, {}},
    { 7935, -7075, {}},
    { 7960, -6980, {}},
    { 8000, -6900, {}},
    { 8040, -6820, {}},
    { 8060, -6729, {}},
    { 8080, -6638, {}},
    { 8100, -6547, {}},
    { 8120, -6456, {}},
    { 8140, -6364, {}},
    { 8160, -6273, {}},
    { 8180, -6182, {}},
    { 8200, -6091, {}},
    { 8220, -6000, {}},
    { 8318, -6000, {}},
    { 8415, -6000, {}},
    { 8513, -6000, {}},
    { 8610, -6000, {}},
    { 8708, -6000, {}},
    { 8805, -6000, {}},
    { 8903, -6000, {}},
    { 9000, -6000, {}},
    { 9000, -6100, {}},
    { 9000, -6200, {}},
    { 9000, -6300, {}},
    { 9000, -6400, {}},
    { 9000, -6500, {}},
    { 9000, -6600, {}},
    { 9000, -6700, {}},
    { 9000, -6800, {}},
    { 9000, -6900, {}},
    { 9000, -7000, {}},
    { 9000, -7100, {}},
    { 9000, -7200, {}},
    { 9000, -7300, {}},
    { 9000, -7400, {}},
    { 9000, -7500, {}},
    { 9000, -7600, {}},
    { 9000, -7700, {}},
    { 9000, -7800, {}},
    { 9000, -7900, {}},
    { 9000, -8000, {}},
    { 9000, -8100, {}},
    { 9000, -8200, {}},
    { 9000, -8300, {}},
    { 9000, -8400, {}},
    { 9000, -8500, {}},
    { 9000, -8600, {}},
    { 9000, -8700, {}},
    { 9000, -8800, {}},
    { 9000, -8900, {}},
    { 9000, -9000, {}},
    { 9000, -9100, {}},
    { 9000, -9200, {}},
    { 9000, -9300, {}},
    { 9000, -9400, {}},
    { 9000, -9500, {}},
    { 9000, -9600, {}},
    { 9000, -9700, {}},
    { 9000, -9800, {}},
    { 9000, -9900, {}},
    { 9000, -10000, {}},
    { 9000, -10100, {}},
    { 9000, -10200, {}},
    { 9000, -10300, {}},
    { 9000, -10400, {}},
    { 9000, -10500, {}},
    { 9000, -10600, {}},
    { 9000, -10700, {}},
    { 9000, -10800, {}},
    { 9000, -10900, {}},
};

static ZoneVertex cqz03[] = {
    { 6000, -12000, {}},
    { 6000, -12097, {}},
    { 6000, -12194, {}},
    { 6000, -12291, {}},
    { 6000, -12387, {}},
    { 6000, -12484, {}},
    { 6000, -12581, {}},
    { 6000, -12678, {}},
    { 6000, -12775, {}},
    { 6000, -12872, {}},
    { 6000, -12968, {}},
    { 6000, -13065, {}},
    { 6000, -13162, {}},
    { 6000, -13259, {}},
    { 6000, -13356, {}},
    { 6000, -13453, {}},
    { 6000, -13549, {}},
    { 6000, -13646, {}},
    { 6000, -13743, {}},
    { 6000, -13840, {}},
    { 6000, -13900, {}},
    { 6000, -13880, {}},
    { 5980, -13860, {}},
    { 5940, -13800, {}},
    { 5940, -13780, {}},
    { 5920, -13760, {}},
    { 5900, -13760, {}},
    { 5900, -13720, {}},
    { 5920, -13700, {}},
    { 5920, -13660, {}},
    { 5940, -13640, {}},
    { 5960, -13620, {}},
    { 5960, -13600, {}},
    { 5980, -13580, {}},
    { 5980, -13540, {}},
    { 5960, -13520, {}},
    { 5940, -13500, {}},
    { 5920, -13480, {}},
    { 5920, -13460, {}},
    { 5900, -13440, {}},
    { 5880, -13400, {}},
    { 5860, -13380, {}},
    { 5860, -13360, {}},
    { 5840, -13340, {}},
    { 5820, -13320, {}},
    { 5780, -13280, {}},
    { 5740, -13260, {}},
    { 5740, -13240, {}},
    { 5700, -13240, {}},
    { 5700, -13200, {}},
    { 5680, -13200, {}},
    { 5660, -13180, {}},
    { 5660, -13160, {}},
    { 5640, -13120, {}},
    { 5640, -13080, {}},
    { 5620, -13060, {}},
    { 5620, -13040, {}},
    { 5620, -13020, {}},
    { 5600, -13000, {}},
    { 5580, -13020, {}},
    { 5560, -13020, {}},
    { 5540, -13000, {}},
    { 5520, -13020, {}},
    { 5500, -13020, {}},
    { 5480, -13040, {}},
    { 5480, -13060, {}},
    { 5465, -13160, {}},
    { 5450, -13260, {}},
    { 5435, -13360, {}},
    { 5420, -13460, {}},
    { 5350, -13550, {}},
    { 5280, -13640, {}},
    { 5210, -13730, {}},
    { 5140, -13820, {}},
    { 5070, -13910, {}},
    { 5000, -14000, {}},
    { 4900, -14000, {}},
    { 4800, -14000, {}},
    { 4700, -14000, {}},
    { 4600, -14000, {}},
    { 4500, -14000, {}},
    { 4400, -14000, {}},
    { 4300, -14000, {}},
    { 4200, -14000, {}},
    { 4100, -14000, {}},
    { 4000, -14000, {}},
    { 4000, -13900, {}},
    { 4000, -13800, {}},
    { 4000, -13700, {}},
    { 4000, -13600, {}},
    { 4000, -13500, {}},
    { 4000, -13400, {}},
    { 4000, -13300, {}},
    { 4000, -13200, {}},
    { 4000, -13100, {}},
    { 4000, -13000, {}},
    { 3908, -13000, {}},
    { 3815, -13000, {}},
    { 3723, -13000, {}},
    { 3630, -13000, {}},
    { 3538, -13000, {}},
    { 3445, -13000, {}},
    { 3353, -13000, {}},
    { 3260, -13000, {}},
    { 3260, -12900, {}},
    { 3260, -12800, {}},
    { 3260, -12700, {}},
    { 3260, -12600, {}},
    { 3260, -12500, {}},
    { 3260, -12400, {}},
    { 3260, -12300, {}},
    { 3260, -12200, {}},
    { 3260, -12100, {}},
    { 3260, -12000, {}},
    { 3260, -11907, {}},
    { 3260, -11813, {}},
    { 3260, -11720, {}},
    { 3260, -11680, {}},
    { 3260, -11660, {}},
    { 3260, -11620, {}},
    { 3260, -11600, {}},
    { 3260, -11540, {}},
    { 3280, -11480, {}},
    { 3260, -11480, {}},
    { 3240, -11460, {}},
    { 3240, -11440, {}},
    { 3220, -11380, {}},
    { 3200, -11340, {}},
    { 3180, -11240, {}},
    { 3160, -11180, {}},
    { 3140, -11100, {}},
    { 3140, -11060, {}},
    { 3140, -11000, {}},
    { 3140, -10960, {}},
    { 3140, -10920, {}},
    { 3224, -10916, {}},
    { 3308, -10912, {}},
    { 3392, -10908, {}},
    { 3476, -10904, {}},
    { 3560, -10900, {}},
    { 3647, -10900, {}},
    { 3733, -10900, {}},
    { 3820, -10900, {}},
    { 3913, -10900, {}},
    { 4007, -10900, {}},
    { 4100, -10900, {}},
    { 4100, -10920, {}},
    { 4100, -10980, {}},
    { 4100, -11000, {}},
    { 4100, -11040, {}},
    { 4100, -11100, {}},
    { 4185, -11100, {}},
    { 4270, -11100, {}},
    { 4355, -11100, {}},
    { 4440, -11100, {}},
    { 4460, -11120, {}},
    { 4480, -11140, {}},
    { 4460, -11160, {}},
    { 4460, -11180, {}},
    { 4460, -11200, {}},
    { 4460, -11220, {}},
    { 4440, -11240, {}},
    { 4440, -11260, {}},
    { 4440, -11280, {}},
    { 4440, -11300, {}},
    { 4460, -11300, {}},
    { 4480, -11320, {}},
    { 4480, -11340, {}},
    { 4500, -11340, {}},
    { 4520, -11360, {}},
    { 4540, -11380, {}},
    { 4560, -11380, {}},
    { 4560, -11400, {}},
    { 4560, -11420, {}},
    { 4560, -11440, {}},
    { 4580, -11460, {}},
    { 4580, -11440, {}},
    { 4600, -11440, {}},
    { 4620, -11440, {}},
    { 4640, -11440, {}},
    { 4660, -11440, {}},
    { 4660, -11460, {}},
    { 4680, -11480, {}},
    { 4700, -11500, {}},
    { 4720, -11520, {}},
    { 4720, -11540, {}},
    { 4740, -11560, {}},
    { 4760, -11560, {}},
    { 4780, -11580, {}},
    { 4800, -11600, {}},
    { 4900, -11600, {}},
    { 4900, -11560, {}},
    { 4900, -11540, {}},
    { 4900, -11500, {}},
    { 4900, -11460, {}},
    { 4900, -11440, {}},
    { 4900, -11400, {}},
    { 4920, -11420, {}},
    { 4920, -11440, {}},
    { 4940, -11460, {}},
    { 4960, -11480, {}},
    { 4980, -11460, {}},
    { 5000, -11460, {}},
    { 5020, -11480, {}},
    { 5040, -11480, {}},
    { 5060, -11500, {}},
    { 5060, -11520, {}},
    { 5080, -11540, {}},
    { 5080, -11560, {}},
    { 5100, -11560, {}},
    { 5100, -11580, {}},
    { 5120, -11600, {}},
    { 5120, -11620, {}},
    { 5140, -11620, {}},
    { 5160, -11640, {}},
    { 5180, -11660, {}},
    { 5180, -11680, {}},
    { 5180, -11700, {}},
    { 5200, -11720, {}},
    { 5220, -11760, {}},
    { 5220, -11780, {}},
    { 5240, -11780, {}},
    { 5240, -11800, {}},
    { 5240, -11820, {}},
    { 5260, -11840, {}},
    { 5280, -11840, {}},
    { 5280, -11860, {}},
    { 5300, -11860, {}},
    { 5320, -11880, {}},
    { 5320, -11900, {}},
    { 5320, -11920, {}},
    { 5340, -11940, {}},
    { 5340, -11960, {}},
    { 5360, -11980, {}},
    { 5380, -12000, {}},
    { 5469, -12000, {}},
    { 5557, -12000, {}},
    { 5646, -12000, {}},
    { 5734, -12000, {}},
    { 5823, -12000, {}},
    { 5911, -12000, {}},
    { 6000, -12000, {}},
};

static ZoneVertex cqz04[] = {
    { 3133, -10905, {}},
    { 3219, -10904, {}},
    { 3304, -10903, {}},
    { 3389, -10902, {}},
    { 3475, -10901, {}},
    { 3560, -10900, {}},
    { 3647, -10900, {}},
    { 3733, -10900, {}},
    { 3820, -10900, {}},
    { 3913, -10900, {}},
    { 4007, -10900, {}},
    { 4100, -10900, {}},
    { 4100, -10920, {}},
    { 4100, -10980, {}},
    { 4100, -11000, {}},
    { 4100, -11040, {}},
    { 4100, -11100, {}},
    { 4185, -11100, {}},
    { 4270, -11100, {}},
    { 4355, -11100, {}},
    { 4440, -11100, {}},
    { 4460, -11120, {}},
    { 4480, -11140, {}},
    { 4460, -11160, {}},
    { 4460, -11180, {}},
    { 4460, -11200, {}},
    { 4460, -11220, {}},
    { 4440, -11240, {}},
    { 4440, -11260, {}},
    { 4440, -11280, {}},
    { 4440, -11300, {}},
    { 4460, -11300, {}},
    { 4480, -11320, {}},
    { 4480, -11340, {}},
    { 4500, -11340, {}},
    { 4520, -11360, {}},
    { 4540, -11380, {}},
    { 4560, -11380, {}},
    { 4560, -11400, {}},
    { 4560, -11420, {}},
    { 4560, -11440, {}},
    { 4580, -11460, {}},
    { 4580, -11440, {}},
    { 4600, -11440, {}},
    { 4620, -11440, {}},
    { 4640, -11440, {}},
    { 4660, -11440, {}},
    { 4660, -11460, {}},
    { 4680, -11480, {}},
    { 4700, -11500, {}},
    { 4720, -11520, {}},
    { 4720, -11540, {}},
    { 4740, -11560, {}},
    { 4760, -11560, {}},
    { 4780, -11580, {}},
    { 4800, -11600, {}},
    { 4900, -11600, {}},
    { 4900, -11560, {}},
    { 4900, -11540, {}},
    { 4900, -11500, {}},
    { 4900, -11460, {}},
    { 4900, -11440, {}},
    { 4900, -11400, {}},
    { 4920, -11420, {}},
    { 4920, -11440, {}},
    { 4940, -11460, {}},
    { 4960, -11480, {}},
    { 4980, -11460, {}},
    { 5000, -11460, {}},
    { 5020, -11480, {}},
    { 5040, -11480, {}},
    { 5060, -11500, {}},
    { 5060, -11520, {}},
    { 5080, -11540, {}},
    { 5080, -11560, {}},
    { 5100, -11560, {}},
    { 5100, -11580, {}},
    { 5120, -11600, {}},
    { 5120, -11620, {}},
    { 5140, -11620, {}},
    { 5160, -11640, {}},
    { 5180, -11660, {}},
    { 5180, -11680, {}},
    { 5180, -11700, {}},
    { 5200, -11720, {}},
    { 5220, -11760, {}},
    { 5220, -11780, {}},
    { 5240, -11780, {}},
    { 5240, -11800, {}},
    { 5240, -11820, {}},
    { 5260, -11840, {}},
    { 5280, -11840, {}},
    { 5280, -11860, {}},
    { 5300, -11860, {}},
    { 5320, -11880, {}},
    { 5320, -11900, {}},
    { 5320, -11920, {}},
    { 5340, -11940, {}},
    { 5340, -11960, {}},
    { 5360, -11980, {}},
    { 5380, -12000, {}},
    { 5469, -12000, {}},
    { 5557, -12000, {}},
    { 5646, -12000, {}},
    { 5734, -12000, {}},
    { 5823, -12000, {}},
    { 5911, -12000, {}},
    { 6000, -12000, {}},
    { 6000, -11900, {}},
    { 6000, -11800, {}},
    { 6000, -11700, {}},
    { 6000, -11600, {}},
    { 6000, -11500, {}},
    { 6000, -11400, {}},
    { 6000, -11300, {}},
    { 6000, -11200, {}},
    { 6000, -11100, {}},
    { 6000, -11000, {}},
    { 6000, -10900, {}},
    { 6000, -10800, {}},
    { 6000, -10700, {}},
    { 6000, -10600, {}},
    { 6000, -10500, {}},
    { 6000, -10400, {}},
    { 6000, -10300, {}},
    { 6000, -10200, {}},
    { 6000, -10100, {}},
    { 6000, -10000, {}},
    { 6000, -9900, {}},
    { 6000, -9800, {}},
    { 6000, -9700, {}},
    { 6000, -9600, {}},
    { 6000, -9500, {}},
    { 6000, -9400, {}},
    { 6000, -9300, {}},
    { 6000, -9200, {}},
    { 6000, -9100, {}},
    { 6000, -9000, {}},
    { 6000, -8900, {}},
    { 6000, -8800, {}},
    { 6000, -8700, {}},
    { 6000, -8600, {}},
    { 6000, -8500, {}},
    { 5910, -8430, {}},
    { 5820, -8360, {}},
    { 5730, -8290, {}},
    { 5640, -8220, {}},
    { 5550, -8150, {}},
    { 5460, -8080, {}},
    { 5367, -8047, {}},
    { 5273, -8013, {}},
    { 5180, -7980, {}},
    { 5160, -7960, {}},
    { 5120, -7960, {}},
    { 5100, -7960, {}},
    { 5080, -7960, {}},
    { 5000, -7960, {}},
    { 4920, -7960, {}},
    { 4840, -7960, {}},
    { 4760, -7960, {}},
    { 4720, -7940, {}},
    { 4700, -7940, {}},
    { 4680, -7920, {}},
    { 4660, -7900, {}},
    { 4640, -7880, {}},
    { 4640, -7860, {}},
    { 4620, -7840, {}},
    { 4620, -7820, {}},
    { 4620, -7800, {}},
    { 4620, -7780, {}},
    { 4620, -7760, {}},
    { 4600, -7740, {}},
    { 4580, -7720, {}},
    { 4580, -7700, {}},
    { 4580, -7680, {}},
    { 4560, -7660, {}},
    { 4540, -7640, {}},
    { 4560, -7620, {}},
    { 4540, -7600, {}},
    { 4540, -7580, {}},
    { 4540, -7560, {}},
    { 4560, -7540, {}},
    { 4560, -7520, {}},
    { 4560, -7500, {}},
    { 4560, -7480, {}},
    { 4560, -7460, {}},
    { 4560, -7440, {}},
    { 4540, -7440, {}},
    { 4520, -7440, {}},
    { 4500, -7460, {}},
    { 4500, -7480, {}},
    { 4500, -7500, {}},
    { 4480, -7520, {}},
    { 4480, -7540, {}},
    { 4460, -7560, {}},
    { 4440, -7580, {}},
    { 4440, -7600, {}},
    { 4420, -7620, {}},
    { 4400, -7640, {}},
    { 4360, -7680, {}},
    { 4360, -7770, {}},
    { 4360, -7860, {}},
    { 4340, -7920, {}},
    { 4320, -7900, {}},
    { 4300, -7900, {}},
    { 4240, -8000, {}},
    { 4240, -8060, {}},
    { 4150, -8060, {}},
    { 4060, -8060, {}},
    { 4040, -8060, {}},
    { 4020, -8060, {}},
    { 4000, -8080, {}},
    { 3980, -8080, {}},
    { 3960, -8100, {}},
    { 3940, -8120, {}},
    { 3940, -8140, {}},
    { 3920, -8160, {}},
    { 3900, -8180, {}},
    { 3900, -8200, {}},
    { 3880, -8220, {}},
    { 3860, -8220, {}},
    { 3840, -8240, {}},
    { 3820, -8260, {}},
    { 3800, -8260, {}},
    { 3780, -8240, {}},
    { 3760, -8220, {}},
    { 3760, -8200, {}},
    { 3740, -8220, {}},
    { 3720, -8240, {}},
    { 3720, -8260, {}},
    { 3700, -8280, {}},
    { 3680, -8300, {}},
    { 3680, -8320, {}},
    { 3660, -8340, {}},
    { 3660, -8360, {}},
    { 3660, -8340, {}},
    { 3660, -8270, {}},
    { 3660, -8200, {}},
    { 3660, -8180, {}},
    { 3640, -8180, {}},
    { 3620, -8200, {}},
    { 3620, -8220, {}},
    { 3600, -8240, {}},
    { 3600, -8260, {}},
    { 3600, -8280, {}},
    { 3580, -8300, {}},
    { 3580, -8320, {}},
    { 3560, -8340, {}},
    { 3560, -8360, {}},
    { 3560, -8380, {}},
    { 3540, -8400, {}},
    { 3520, -8420, {}},
    { 3500, -8440, {}},
    { 3500, -8500, {}},
    { 3500, -8560, {}},
    { 3480, -8560, {}},
    { 3460, -8560, {}},
    { 3440, -8540, {}},
    { 3420, -8540, {}},
    { 3360, -8530, {}},
    { 3300, -8520, {}},
    { 3280, -8520, {}},
    { 3260, -8500, {}},
    { 3240, -8500, {}},
    { 3220, -8500, {}},
    { 3200, -8500, {}},
    { 3180, -8520, {}},
    { 3160, -8500, {}},
    { 3140, -8500, {}},
    { 3120, -8520, {}},
    { 3100, -8500, {}},
    { 3100, -8520, {}},
    { 3100, -8540, {}},
    { 3100, -8600, {}},
    { 3100, -8620, {}},
    { 3100, -8660, {}},
    { 3100, -8700, {}},
    { 3100, -8760, {}},
    { 3080, -8760, {}},
    { 3060, -8740, {}},
    { 3040, -8740, {}},
    { 3000, -8760, {}},
    { 2913, -8760, {}},
    { 2827, -8760, {}},
    { 2740, -8760, {}},
    { 2653, -8760, {}},
    { 2567, -8760, {}},
    { 2480, -8760, {}},
    { 2487, -8840, {}},
    { 2493, -8920, {}},
    { 2500, -9000, {}},
    { 2513, -9090, {}},
    { 2525, -9180, {}},
    { 2538, -9270, {}},
    { 2550, -9360, {}},
    { 2563, -9450, {}},
    { 2575, -9540, {}},
    { 2588, -9630, {}},
    { 2600, -9720, {}},
    { 2580, -9740, {}},
    { 2600, -9760, {}},
    { 2600, -9780, {}},
    { 2600, -9800, {}},
    { 2600, -9820, {}},
    { 2620, -9840, {}},
    { 2620, -9860, {}},
    { 2640, -9880, {}},
    { 2640, -9900, {}},
    { 2660, -9920, {}},
    { 2680, -9920, {}},
    { 2700, -9940, {}},
    { 2720, -9940, {}},
    { 2740, -9940, {}},
    { 2760, -9960, {}},
    { 2780, -9980, {}},
    { 2800, -10000, {}},
    { 2820, -10020, {}},
    { 2840, -10040, {}},
    { 2860, -10040, {}},
    { 2880, -10060, {}},
    { 2900, -10060, {}},
    { 2920, -10080, {}},
    { 2940, -10100, {}},
    { 2960, -10120, {}},
    { 2980, -10140, {}},
    { 2980, -10160, {}},
    { 2980, -10180, {}},
    { 2980, -10200, {}},
    { 2980, -10220, {}},
    { 2980, -10240, {}},
    { 2980, -10260, {}},
    { 2960, -10280, {}},
    { 2940, -10280, {}},
    { 2920, -10300, {}},
    { 2900, -10320, {}},
    { 2900, -10340, {}},
    { 2920, -10360, {}},
    { 2920, -10380, {}},
    { 2940, -10400, {}},
    { 2940, -10420, {}},
    { 2960, -10440, {}},
    { 2980, -10460, {}},
    { 3000, -10460, {}},
    { 3020, -10480, {}},
    { 3040, -10480, {}},
    { 3060, -10500, {}},
    { 3080, -10520, {}},
    { 3080, -10540, {}},
    { 3100, -10560, {}},
    { 3120, -10580, {}},
    { 3140, -10600, {}},
    { 3140, -10620, {}},
    { 3160, -10640, {}},
    { 3170, -10730, {}},
    { 3180, -10820, {}},
    { 3140, -10820, {}},
    { 3140, -10900, {}},
};

static ZoneVertex cqz05[] = {
    { 2800, -7950, {}},
    { 2800, -7851, {}},
    { 2800, -7752, {}},
    { 2800, -7653, {}},
    { 2800, -7554, {}},
    { 2800, -7456, {}},
    { 2800, -7357, {}},
    { 2800, -7258, {}},
    { 2800, -7159, {}},
    { 2800, -7060, {}},
    { 2800, -6961, {}},
    { 2800, -6862, {}},
    { 2800, -6763, {}},
    { 2800, -6664, {}},
    { 2800, -6566, {}},
    { 2800, -6467, {}},
    { 2800, -6368, {}},
    { 2800, -6269, {}},
    { 2800, -6170, {}},
    { 2800, -6071, {}},
    { 2800, -5972, {}},
    { 2800, -5873, {}},
    { 2800, -5774, {}},
    { 2800, -5676, {}},
    { 2800, -5577, {}},
    { 2800, -5478, {}},
    { 2800, -5379, {}},
    { 2800, -5280, {}},
    { 2800, -5181, {}},
    { 2800, -5082, {}},
    { 2800, -4983, {}},
    { 2800, -4884, {}},
    { 2800, -4786, {}},
    { 2800, -4687, {}},
    { 2800, -4588, {}},
    { 2800, -4489, {}},
    { 2800, -4390, {}},
    { 2800, -4291, {}},
    { 2800, -4192, {}},
    { 2800, -4093, {}},
    { 2800, -3994, {}},
    { 2800, -3896, {}},
    { 2800, -3797, {}},
    { 2800, -3698, {}},
    { 2800, -3599, {}},
    { 2800, -3500, {}},
    { 2899, -3500, {}},
    { 2999, -3500, {}},
    { 3098, -3500, {}},
    { 3197, -3500, {}},
    { 3297, -3500, {}},
    { 3396, -3500, {}},
    { 3495, -3500, {}},
    { 3594, -3500, {}},
    { 3694, -3500, {}},
    { 3793, -3500, {}},
    { 3892, -3500, {}},
    { 3992, -3500, {}},
    { 4091, -3500, {}},
    { 4190, -3500, {}},
    { 4290, -3500, {}},
    { 4389, -3500, {}},
    { 4488, -3500, {}},
    { 4588, -3500, {}},
    { 4687, -3500, {}},
    { 4786, -3500, {}},
    { 4886, -3500, {}},
    { 4985, -3500, {}},
    { 5084, -3500, {}},
    { 5183, -3500, {}},
    { 5283, -3500, {}},
    { 5382, -3500, {}},
    { 5481, -3500, {}},
    { 5581, -3500, {}},
    { 5680, -3500, {}},
    { 5653, -3600, {}},
    { 5626, -3700, {}},
    { 5599, -3800, {}},
    { 5571, -3900, {}},
    { 5544, -4000, {}},
    { 5517, -4100, {}},
    { 5490, -4200, {}},
    { 5463, -4300, {}},
    { 5436, -4400, {}},
    { 5409, -4500, {}},
    { 5381, -4600, {}},
    { 5354, -4700, {}},
    { 5327, -4800, {}},
    { 5300, -4900, {}},
    { 5283, -4991, {}},
    { 5266, -5083, {}},
    { 5249, -5174, {}},
    { 5231, -5266, {}},
    { 5214, -5357, {}},
    { 5197, -5449, {}},
    { 5180, -5540, {}},
    { 5180, -5600, {}},
    { 5135, -5700, {}},
    { 5090, -5800, {}},
    { 5045, -5900, {}},
    { 5000, -6000, {}},
    { 5000, -6098, {}},
    { 5000, -6196, {}},
    { 5000, -6294, {}},
    { 5000, -6392, {}},
    { 5000, -6490, {}},
    { 5000, -6588, {}},
    { 5000, -6686, {}},
    { 5000, -6784, {}},
    { 5000, -6882, {}},
    { 5000, -6980, {}},
    { 5000, -7078, {}},
    { 5000, -7176, {}},
    { 5000, -7274, {}},
    { 5000, -7372, {}},
    { 5000, -7470, {}},
    { 5000, -7568, {}},
    { 5000, -7666, {}},
    { 5000, -7764, {}},
    { 5000, -7862, {}},
    { 5000, -7960, {}},
    { 4920, -7960, {}},
    { 4840, -7960, {}},
    { 4760, -7960, {}},
    { 4720, -7940, {}},
    { 4700, -7940, {}},
    { 4680, -7920, {}},
    { 4660, -7900, {}},
    { 4640, -7880, {}},
    { 4640, -7860, {}},
    { 4620, -7840, {}},
    { 4620, -7820, {}},
    { 4620, -7800, {}},
    { 4620, -7780, {}},
    { 4620, -7760, {}},
    { 4600, -7740, {}},
    { 4580, -7720, {}},
    { 4580, -7700, {}},
    { 4580, -7680, {}},
    { 4560, -7660, {}},
    { 4540, -7640, {}},
    { 4560, -7620, {}},
    { 4540, -7600, {}},
    { 4540, -7580, {}},
    { 4540, -7560, {}},
    { 4560, -7540, {}},
    { 4560, -7520, {}},
    { 4560, -7500, {}},
    { 4560, -7480, {}},
    { 4560, -7460, {}},
    { 4560, -7440, {}},
    { 4540, -7440, {}},
    { 4520, -7440, {}},
    { 4500, -7460, {}},
    { 4500, -7480, {}},
    { 4500, -7500, {}},
    { 4480, -7520, {}},
    { 4480, -7540, {}},
    { 4460, -7560, {}},
    { 4440, -7580, {}},
    { 4440, -7600, {}},
    { 4420, -7620, {}},
    { 4400, -7640, {}},
    { 4360, -7680, {}},
    { 4360, -7770, {}},
    { 4360, -7860, {}},
    { 4340, -7920, {}},
    { 4320, -7900, {}},
    { 4300, -7900, {}},
    { 4240, -8000, {}},
    { 4240, -8060, {}},
    { 4150, -8060, {}},
    { 4060, -8060, {}},
    { 4040, -8060, {}},
    { 4020, -8060, {}},
    { 4000, -8080, {}},
    { 3980, -8080, {}},
    { 3960, -8100, {}},
    { 3940, -8120, {}},
    { 3940, -8140, {}},
    { 3920, -8160, {}},
    { 3900, -8180, {}},
    { 3900, -8200, {}},
    { 3880, -8220, {}},
    { 3860, -8220, {}},
    { 3840, -8240, {}},
    { 3820, -8260, {}},
    { 3800, -8260, {}},
    { 3780, -8240, {}},
    { 3760, -8220, {}},
    { 3760, -8200, {}},
    { 3740, -8220, {}},
    { 3720, -8240, {}},
    { 3720, -8260, {}},
    { 3700, -8280, {}},
    { 3680, -8300, {}},
    { 3680, -8320, {}},
    { 3660, -8340, {}},
    { 3660, -8360, {}},
    { 3660, -8340, {}},
    { 3660, -8270, {}},
    { 3660, -8200, {}},
    { 3660, -8180, {}},
    { 3640, -8180, {}},
    { 3620, -8200, {}},
    { 3620, -8220, {}},
    { 3600, -8240, {}},
    { 3600, -8260, {}},
    { 3600, -8280, {}},
    { 3580, -8300, {}},
    { 3580, -8320, {}},
    { 3560, -8340, {}},
    { 3560, -8360, {}},
    { 3560, -8380, {}},
    { 3540, -8400, {}},
    { 3520, -8420, {}},
    { 3500, -8440, {}},
    { 3500, -8500, {}},
    { 3500, -8560, {}},
    { 3480, -8560, {}},
    { 3460, -8560, {}},
    { 3440, -8540, {}},
    { 3420, -8540, {}},
    { 3360, -8530, {}},
    { 3300, -8520, {}},
    { 3280, -8520, {}},
    { 3260, -8500, {}},
    { 3240, -8500, {}},
    { 3220, -8500, {}},
    { 3200, -8500, {}},
    { 3180, -8520, {}},
    { 3160, -8500, {}},
    { 3140, -8500, {}},
    { 3120, -8520, {}},
    { 3100, -8500, {}},
    { 3100, -8520, {}},
    { 3100, -8540, {}},
    { 3100, -8600, {}},
    { 3100, -8620, {}},
    { 3100, -8660, {}},
    { 3100, -8700, {}},
    { 3100, -8760, {}},
    { 3080, -8760, {}},
    { 3060, -8740, {}},
    { 3040, -8740, {}},
    { 3000, -8760, {}},
    { 2913, -8760, {}},
    { 2827, -8760, {}},
    { 2740, -8760, {}},
    { 2653, -8760, {}},
    { 2567, -8760, {}},
    { 2480, -8760, {}},
    { 2470, -8680, {}},
    { 2460, -8600, {}},
    { 2451, -8509, {}},
    { 2443, -8417, {}},
    { 2434, -8326, {}},
    { 2426, -8234, {}},
    { 2417, -8143, {}},
    { 2409, -8051, {}},
    { 2400, -7960, {}},
    { 2500, -7960, {}},
    { 2600, -7960, {}},
    { 2700, -7960, {}},
    { 2800, -7960, {}},
};

static ZoneVertex cqz06[] = {
    { 1400, -9300, {}},
    { 1400, -9400, {}},
    { 1400, -9500, {}},
    { 1400, -9600, {}},
    { 1400, -9700, {}},
    { 1400, -9800, {}},
    { 1400, -9900, {}},
    { 1400, -10000, {}},
    { 1400, -10100, {}},
    { 1400, -10200, {}},
    { 1400, -10300, {}},
    { 1400, -10400, {}},
    { 1400, -10500, {}},
    { 1400, -10600, {}},
    { 1400, -10700, {}},
    { 1400, -10800, {}},
    { 1400, -10900, {}},
    { 1400, -11000, {}},
    { 1400, -11100, {}},
    { 1400, -11200, {}},
    { 1400, -11300, {}},
    { 1400, -11400, {}},
    { 1400, -11500, {}},
    { 1400, -11600, {}},
    { 1400, -11700, {}},
    { 1400, -11800, {}},
    { 1400, -11900, {}},
    { 1400, -12000, {}},
    { 1400, -12100, {}},
    { 1400, -12200, {}},
    { 1400, -12300, {}},
    { 1400, -12400, {}},
    { 1400, -12500, {}},
    { 1400, -12600, {}},
    { 1400, -12700, {}},
    { 1400, -12800, {}},
    { 1400, -12900, {}},
    { 1400, -13000, {}},
    { 1498, -13000, {}},
    { 1596, -13000, {}},
    { 1694, -13000, {}},
    { 1792, -13000, {}},
    { 1889, -13000, {}},
    { 1987, -13000, {}},
    { 2085, -13000, {}},
    { 2183, -13000, {}},
    { 2281, -13000, {}},
    { 2379, -13000, {}},
    { 2477, -13000, {}},
    { 2575, -13000, {}},
    { 2673, -13000, {}},
    { 2771, -13000, {}},
    { 2868, -13000, {}},
    { 2966, -13000, {}},
    { 3064, -13000, {}},
    { 3162, -13000, {}},
    { 3260, -13000, {}},
    { 3260, -12900, {}},
    { 3260, -12800, {}},
    { 3260, -12700, {}},
    { 3260, -12600, {}},
    { 3260, -12500, {}},
    { 3260, -12400, {}},
    { 3260, -12300, {}},
    { 3260, -12200, {}},
    { 3260, -12100, {}},
    { 3260, -12000, {}},
    { 3260, -11907, {}},
    { 3260, -11813, {}},
    { 3260, -11720, {}},
    { 3260, -11680, {}},
    { 3260, -11660, {}},
    { 3260, -11620, {}},
    { 3260, -11600, {}},
    { 3260, -11540, {}},
    { 3280, -11480, {}},
    { 3260, -11480, {}},
    { 3240, -11460, {}},
    { 3240, -11440, {}},
    { 3220, -11380, {}},
    { 3200, -11340, {}},
    { 3180, -11240, {}},
    { 3160, -11180, {}},
    { 3140, -11100, {}},
    { 3140, -11060, {}},
    { 3140, -11000, {}},
    { 3140, -10960, {}},
    { 3140, -10920, {}},
    { 3140, -10820, {}},
    { 3180, -10820, {}},
    { 3180, -10740, {}},
    { 3180, -10660, {}},
    { 3180, -10640, {}},
    { 3160, -10620, {}},
    { 3140, -10600, {}},
    { 3120, -10580, {}},
    { 3100, -10560, {}},
    { 3080, -10540, {}},
    { 3080, -10520, {}},
    { 3060, -10500, {}},
    { 3040, -10480, {}},
    { 3020, -10460, {}},
    { 3000, -10460, {}},
    { 2980, -10460, {}},
    { 2960, -10440, {}},
    { 2940, -10420, {}},
    { 2920, -10400, {}},
    { 2920, -10380, {}},
    { 2920, -10360, {}},
    { 2900, -10340, {}},
    { 2900, -10320, {}},
    { 2920, -10300, {}},
    { 2940, -10280, {}},
    { 2960, -10280, {}},
    { 2980, -10260, {}},
    { 2980, -10240, {}},
    { 2980, -10220, {}},
    { 2980, -10200, {}},
    { 2980, -10180, {}},
    { 2980, -10160, {}},
    { 2980, -10140, {}},
    { 2960, -10140, {}},
    { 2960, -10120, {}},
    { 2940, -10100, {}},
    { 2920, -10080, {}},
    { 2900, -10060, {}},
    { 2880, -10060, {}},
    { 2860, -10040, {}},
    { 2840, -10040, {}},
    { 2820, -10020, {}},
    { 2800, -10000, {}},
    { 2780, -9980, {}},
    { 2760, -9960, {}},
    { 2740, -9940, {}},
    { 2720, -9940, {}},
    { 2700, -9940, {}},
    { 2680, -9920, {}},
    { 2660, -9920, {}},
    { 2640, -9900, {}},
    { 2640, -9880, {}},
    { 2620, -9860, {}},
    { 2620, -9840, {}},
    { 2600, -9820, {}},
    { 2600, -9800, {}},
    { 2600, -9780, {}},
    { 2600, -9760, {}},
    { 2580, -9740, {}},
    { 2600, -9720, {}},
    { 2588, -9630, {}},
    { 2575, -9540, {}},
    { 2563, -9450, {}},
    { 2550, -9360, {}},
    { 2538, -9270, {}},
    { 2525, -9180, {}},
    { 2513, -9090, {}},
    { 2500, -9000, {}},
    { 2490, -8900, {}},
    { 2480, -8800, {}},
    { 2470, -8700, {}},
    { 2460, -8600, {}},
    { 2371, -8600, {}},
    { 2283, -8600, {}},
    { 2194, -8600, {}},
    { 2106, -8600, {}},
    { 2017, -8600, {}},
    { 1929, -8600, {}},
    { 1840, -8600, {}},
    { 1830, -8690, {}},
    { 1820, -8780, {}},
    { 1840, -8800, {}},
    { 1840, -8840, {}},
    { 1820, -8860, {}},
    { 1800, -8880, {}},
    { 1800, -8900, {}},
    { 1790, -9000, {}},
    { 1780, -9100, {}},
    { 1720, -9100, {}},
    { 1720, -9140, {}},
    { 1700, -9120, {}},
    { 1680, -9100, {}},
    { 1680, -9080, {}},
    { 1660, -9060, {}},
    { 1640, -9040, {}},
    { 1620, -9040, {}},
    { 1610, -9110, {}},
    { 1600, -9180, {}},
    { 1520, -9220, {}},
    { 1500, -9220, {}},
    { 1480, -9220, {}},
    { 1460, -9220, {}},
    { 1400, -9300, {}},
};

static ZoneVertex cqz07[] = {
    { 1400, -13000, {}},
    { 1309, -13000, {}},
    { 1218, -13000, {}},
    { 1127, -13000, {}},
    { 1036, -13000, {}},
    {  945, -13000, {}},
    {  855, -13000, {}},
    {  764, -13000, {}},
    {  673, -13000, {}},
    {  582, -13000, {}},
    {  491, -13000, {}},
    {  400, -13000, {}},
    {  400, -12900, {}},
    {  400, -12800, {}},
    {  400, -12700, {}},
    {  400, -12600, {}},
    {  400, -12500, {}},
    {  400, -12400, {}},
    {  400, -12300, {}},
    {  400, -12200, {}},
    {  400, -12100, {}},
    {  400, -12000, {}},
    {  400, -11900, {}},
    {  400, -11800, {}},
    {  400, -11700, {}},
    {  400, -11600, {}},
    {  400, -11500, {}},
    {  400, -11400, {}},
    {  400, -11300, {}},
    {  400, -11200, {}},
    {  400, -11100, {}},
    {  400, -11000, {}},
    {  400, -10900, {}},
    {  400, -10800, {}},
    {  400, -10700, {}},
    {  400, -10600, {}},
    {  400, -10500, {}},
    {  400, -10400, {}},
    {  400, -10300, {}},
    {  400, -10200, {}},
    {  400, -10100, {}},
    {  400, -10000, {}},
    {  400, -9900, {}},
    {  400, -9800, {}},
    {  400, -9700, {}},
    {  400, -9600, {}},
    {  400, -9500, {}},
    {  400, -9400, {}},
    {  400, -9300, {}},
    {  400, -9200, {}},
    {  400, -9100, {}},
    {  400, -9000, {}},
    {  400, -8900, {}},
    {  400, -8800, {}},
    {  400, -8700, {}},
    {  400, -8600, {}},
    {  400, -8500, {}},
    {  400, -8400, {}},
    {  400, -8300, {}},
    {  400, -8200, {}},
    {  464, -8116, {}},
    {  528, -8032, {}},
    {  592, -7948, {}},
    {  656, -7864, {}},
    {  720, -7780, {}},
    {  740, -7780, {}},
    {  760, -7780, {}},
    {  760, -7760, {}},
    {  780, -7740, {}},
    {  800, -7720, {}},
    {  820, -7720, {}},
    {  840, -7740, {}},
    {  860, -7740, {}},
    {  930, -7720, {}},
    { 1000, -7700, {}},
    { 1100, -7700, {}},
    { 1200, -7700, {}},
    { 1300, -7700, {}},
    { 1400, -7700, {}},
    { 1500, -7700, {}},
    { 1538, -7800, {}},
    { 1576, -7900, {}},
    { 1613, -8000, {}},
    { 1651, -8100, {}},
    { 1689, -8200, {}},
    { 1727, -8300, {}},
    { 1764, -8400, {}},
    { 1802, -8500, {}},
    { 1840, -8600, {}},
    { 1830, -8690, {}},
    { 1820, -8780, {}},
    { 1840, -8800, {}},
    { 1840, -8840, {}},
    { 1820, -8860, {}},
    { 1800, -8880, {}},
    { 1800, -8900, {}},
    { 1790, -9000, {}},
    { 1780, -9100, {}},
    { 1720, -9100, {}},
    { 1720, -9140, {}},
    { 1700, -9120, {}},
    { 1680, -9100, {}},
    { 1680, -9080, {}},
    { 1660, -9060, {}},
    { 1640, -9040, {}},
    { 1620, -9040, {}},
    { 1610, -9110, {}},
    { 1600, -9180, {}},
    { 1520, -9220, {}},
    { 1500, -9220, {}},
    { 1480, -9220, {}},
    { 1460, -9220, {}},
    { 1400, -9300, {}},
    { 1400, -9400, {}},
    { 1400, -9500, {}},
    { 1400, -9600, {}},
    { 1400, -9700, {}},
    { 1400, -9800, {}},
    { 1400, -9900, {}},
    { 1400, -10000, {}},
    { 1400, -10100, {}},
    { 1400, -10200, {}},
    { 1400, -10300, {}},
    { 1400, -10400, {}},
    { 1400, -10500, {}},
    { 1400, -10600, {}},
    { 1400, -10700, {}},
    { 1400, -10800, {}},
    { 1400, -10900, {}},
    { 1400, -11000, {}},
    { 1400, -11100, {}},
    { 1400, -11200, {}},
    { 1400, -11300, {}},
    { 1400, -11400, {}},
    { 1400, -11500, {}},
    { 1400, -11600, {}},
    { 1400, -11700, {}},
    { 1400, -11800, {}},
    { 1400, -11900, {}},
    { 1400, -12000, {}},
    { 1400, -12100, {}},
    { 1400, -12200, {}},
    { 1400, -12300, {}},
    { 1400, -12400, {}},
    { 1400, -12500, {}},
    { 1400, -12600, {}},
    { 1400, -12700, {}},
    { 1400, -12800, {}},
    { 1400, -12900, {}},
    { 1400, -13000, {}},
};

static ZoneVertex cqz08[] = {
    { 2800, -3500, {}},
    { 2708, -3500, {}},
    { 2615, -3500, {}},
    { 2523, -3500, {}},
    { 2430, -3500, {}},
    { 2338, -3500, {}},
    { 2245, -3500, {}},
    { 2153, -3500, {}},
    { 2060, -3500, {}},
    { 2060, -3400, {}},
    { 2060, -3300, {}},
    { 2060, -3200, {}},
    { 2060, -3100, {}},
    { 2060, -3000, {}},
    { 2060, -2900, {}},
    { 2060, -2800, {}},
    { 2060, -2700, {}},
    { 2060, -2600, {}},
    { 1960, -2600, {}},
    { 1860, -2600, {}},
    { 1760, -2600, {}},
    { 1660, -2600, {}},
    { 1560, -2600, {}},
    { 1460, -2600, {}},
    { 1360, -2600, {}},
    { 1260, -2600, {}},
    { 1160, -2600, {}},
    { 1160, -2700, {}},
    { 1160, -2800, {}},
    { 1160, -2900, {}},
    { 1160, -3000, {}},
    { 1160, -3100, {}},
    { 1160, -3200, {}},
    { 1160, -3300, {}},
    { 1160, -3400, {}},
    { 1160, -3500, {}},
    { 1160, -3600, {}},
    { 1160, -3700, {}},
    { 1160, -3800, {}},
    { 1160, -3900, {}},
    { 1160, -4000, {}},
    { 1160, -4100, {}},
    { 1160, -4200, {}},
    { 1160, -4300, {}},
    { 1160, -4400, {}},
    { 1160, -4500, {}},
    { 1160, -4600, {}},
    { 1160, -4700, {}},
    { 1160, -4800, {}},
    { 1160, -4900, {}},
    { 1160, -5000, {}},
    { 1160, -5100, {}},
    { 1160, -5200, {}},
    { 1160, -5300, {}},
    { 1160, -5400, {}},
    { 1160, -5500, {}},
    { 1160, -5600, {}},
    { 1160, -5700, {}},
    { 1160, -5800, {}},
    { 1160, -5900, {}},
    { 1160, -6000, {}},
    { 1160, -6100, {}},
    { 1160, -6200, {}},
    { 1183, -6300, {}},
    { 1205, -6400, {}},
    { 1228, -6500, {}},
    { 1251, -6600, {}},
    { 1273, -6700, {}},
    { 1296, -6800, {}},
    { 1319, -6900, {}},
    { 1341, -7000, {}},
    { 1364, -7100, {}},
    { 1387, -7200, {}},
    { 1409, -7300, {}},
    { 1432, -7400, {}},
    { 1455, -7500, {}},
    { 1477, -7600, {}},
    { 1500, -7700, {}},
    { 1538, -7800, {}},
    { 1576, -7900, {}},
    { 1613, -8000, {}},
    { 1651, -8100, {}},
    { 1689, -8200, {}},
    { 1727, -8300, {}},
    { 1764, -8400, {}},
    { 1802, -8500, {}},
    { 1840, -8600, {}},
    { 1929, -8600, {}},
    { 2017, -8600, {}},
    { 2106, -8600, {}},
    { 2194, -8600, {}},
    { 2283, -8600, {}},
    { 2371, -8600, {}},
    { 2460, -8600, {}},
    { 2451, -8509, {}},
    { 2443, -8417, {}},
    { 2434, -8326, {}},
    { 2426, -8234, {}},
    { 2417, -8143, {}},
    { 2409, -8051, {}},
    { 2400, -7960, {}},
    { 2500, -7960, {}},
    { 2600, -7960, {}},
    { 2700, -7960, {}},
    { 2800, -7960, {}},
    { 2800, -7861, {}},
    { 2800, -7762, {}},
    { 2800, -7663, {}},
    { 2800, -7564, {}},
    { 2800, -7464, {}},
    { 2800, -7365, {}},
    { 2800, -7266, {}},
    { 2800, -7167, {}},
    { 2800, -7068, {}},
    { 2800, -6969, {}},
    { 2800, -6870, {}},
    { 2800, -6771, {}},
    { 2800, -6672, {}},
    { 2800, -6572, {}},
    { 2800, -6473, {}},
    { 2800, -6374, {}},
    { 2800, -6275, {}},
    { 2800, -6176, {}},
    { 2800, -6077, {}},
    { 2800, -5978, {}},
    { 2800, -5879, {}},
    { 2800, -5780, {}},
    { 2800, -5680, {}},
    { 2800, -5581, {}},
    { 2800, -5482, {}},
    { 2800, -5383, {}},
    { 2800, -5284, {}},
    { 2800, -5185, {}},
    { 2800, -5086, {}},
    { 2800, -4987, {}},
    { 2800, -4888, {}},
    { 2800, -4788, {}},
    { 2800, -4689, {}},
    { 2800, -4590, {}},
    { 2800, -4491, {}},
    { 2800, -4392, {}},
    { 2800, -4293, {}},
    { 2800, -4194, {}},
    { 2800, -4095, {}},
    { 2800, -3996, {}},
    { 2800, -3896, {}},
    { 2800, -3797, {}},
    { 2800, -3698, {}},
    { 2800, -3599, {}},
    { 2800, -3500, {}},
};

static ZoneVertex cqz09[] = {
    { 1150, -2600, {}},
    { 1057, -2600, {}},
    {  964, -2600, {}},
    {  871, -2600, {}},
    {  779, -2600, {}},
    {  686, -2600, {}},
    {  593, -2600, {}},
    {  500, -2600, {}},
    {  500, -2698, {}},
    {  500, -2797, {}},
    {  500, -2895, {}},
    {  500, -2994, {}},
    {  500, -3092, {}},
    {  500, -3191, {}},
    {  500, -3289, {}},
    {  500, -3388, {}},
    {  500, -3486, {}},
    {  500, -3585, {}},
    {  500, -3683, {}},
    {  500, -3782, {}},
    {  500, -3880, {}},
    {  500, -3978, {}},
    {  500, -4077, {}},
    {  500, -4175, {}},
    {  500, -4274, {}},
    {  500, -4372, {}},
    {  500, -4471, {}},
    {  500, -4569, {}},
    {  500, -4668, {}},
    {  500, -4766, {}},
    {  500, -4865, {}},
    {  500, -4963, {}},
    {  500, -5062, {}},
    {  500, -5160, {}},
    {  440, -5160, {}},
    {  420, -5160, {}},
    {  400, -5180, {}},
    {  380, -5200, {}},
    {  320, -5220, {}},
    {  300, -5240, {}},
    {  260, -5260, {}},
    {  240, -5260, {}},
    {  220, -5280, {}},
    {  220, -5300, {}},
    {  220, -5320, {}},
    {  220, -5340, {}},
    {  240, -5380, {}},
    {  220, -5400, {}},
    {  220, -5420, {}},
    {  220, -5440, {}},
    {  240, -5460, {}},
    {  240, -5480, {}},
    {  260, -5500, {}},
    {  240, -5520, {}},
    {  240, -5540, {}},
    {  240, -5580, {}},
    {  240, -5600, {}},
    {  220, -5600, {}},
    {  200, -5600, {}},
    {  200, -5620, {}},
    {  200, -5640, {}},
    {  200, -5660, {}},
    {  180, -5680, {}},
    {  200, -5700, {}},
    {  200, -5720, {}},
    {  200, -5740, {}},
    {  180, -5740, {}},
    {  160, -5760, {}},
    {  160, -5780, {}},
    {  160, -5800, {}},
    {  160, -5820, {}},
    {  140, -5840, {}},
    {  120, -5860, {}},
    {  120, -5880, {}},
    {  140, -5900, {}},
    {  140, -5920, {}},
    {  160, -5940, {}},
    {  180, -5960, {}},
    {  200, -5980, {}},
    {  220, -5980, {}},
    {  240, -5980, {}},
    {  260, -6000, {}},
    {  300, -6000, {}},
    {  320, -6000, {}},
    {  340, -5980, {}},
    {  360, -5980, {}},
    {  380, -5960, {}},
    {  400, -5960, {}},
    {  420, -5980, {}},
    {  440, -5980, {}},
    {  440, -6000, {}},
    {  460, -6020, {}},
    {  480, -6000, {}},
    {  500, -6000, {}},
    {  520, -6020, {}},
    {  520, -6040, {}},
    {  520, -6060, {}},
    {  500, -6060, {}},
    {  480, -6080, {}},
    {  460, -6100, {}},
    {  460, -6120, {}},
    {  440, -6140, {}},
    {  420, -6160, {}},
    {  420, -6180, {}},
    {  420, -6200, {}},
    {  420, -6220, {}},
    {  420, -6240, {}},
    {  400, -6260, {}},
    {  380, -6280, {}},
    {  360, -6300, {}},
    {  380, -6320, {}},
    {  400, -6340, {}},
    {  400, -6360, {}},
    {  400, -6380, {}},
    {  400, -6400, {}},
    {  420, -6420, {}},
    {  420, -6440, {}},
    {  420, -6460, {}},
    {  420, -6480, {}},
    {  400, -6460, {}},
    {  380, -6440, {}},
    {  360, -6420, {}},
    {  340, -6420, {}},
    {  320, -6420, {}},
    {  300, -6420, {}},
    {  280, -6400, {}},
    {  260, -6400, {}},
    {  240, -6380, {}},
    {  240, -6360, {}},
    {  240, -6340, {}},
    {  220, -6340, {}},
    {  220, -6360, {}},
    {  200, -6380, {}},
    {  200, -6400, {}},
    {  180, -6400, {}},
    {  160, -6420, {}},
    {  140, -6440, {}},
    {  140, -6460, {}},
    {  140, -6480, {}},
    {  120, -6500, {}},
    {  100, -6520, {}},
    {   80, -6540, {}},
    {   60, -6560, {}},
    {   80, -6560, {}},
    {  100, -6560, {}},
    {  100, -6580, {}},
    {   80, -6600, {}},
    {   80, -6640, {}},
    {  120, -6680, {}},
    {  120, -6700, {}},
    {  140, -6700, {}},
    {  160, -6720, {}},
    {  180, -6720, {}},
    {  200, -6740, {}},
    {  220, -6740, {}},
    {  200, -6760, {}},
    {  200, -6780, {}},
    {  180, -6800, {}},
    {  200, -6820, {}},
    {  180, -6820, {}},
    {  180, -6880, {}},
    {  180, -6940, {}},
    {  180, -6960, {}},
    {  180, -6980, {}},
    {  100, -6980, {}},
    {  100, -6960, {}},
    {  100, -6940, {}},
    {  100, -6920, {}},
    {   80, -6920, {}},
    {   60, -6920, {}},
    {   60, -6940, {}},
    {   60, -6960, {}},
    {   60, -6980, {}},
    {   60, -7000, {}},
    {  -20, -7000, {}},
    {  -40, -6980, {}},
    {  -60, -6960, {}},
    {  -80, -6960, {}},
    { -100, -6940, {}},
    { -120, -6940, {}},
    { -140, -6940, {}},
    { -233, -6960, {}},
    { -327, -6980, {}},
    { -420, -7000, {}},
    { -400, -7020, {}},
    { -380, -7040, {}},
    { -380, -7060, {}},
    { -280, -7000, {}},
    { -260, -7020, {}},
    { -260, -7040, {}},
    { -240, -7060, {}},
    { -220, -7080, {}},
    { -220, -7100, {}},
    { -240, -7120, {}},
    { -240, -7140, {}},
    { -220, -7160, {}},
    { -220, -7180, {}},
    { -240, -7200, {}},
    { -240, -7220, {}},
    { -240, -7240, {}},
    { -240, -7260, {}},
    { -240, -7280, {}},
    { -240, -7300, {}},
    { -220, -7320, {}},
    { -200, -7320, {}},
    { -180, -7320, {}},
    { -180, -7340, {}},
    { -160, -7340, {}},
    { -140, -7360, {}},
    { -120, -7380, {}},
    { -120, -7400, {}},
    { -100, -7420, {}},
    {  -80, -7420, {}},
    {  -60, -7440, {}},
    {  -40, -7460, {}},
    {  -20, -7480, {}},
    {  -20, -7500, {}},
    {    0, -7520, {}},
    {    0, -7540, {}},
    {    0, -7560, {}},
    {    0, -7580, {}},
    {   20, -7600, {}},
    {   40, -7620, {}},
    {   40, -7640, {}},
    {   20, -7660, {}},
    {   20, -7680, {}},
    {   20, -7700, {}},
    {   40, -7720, {}},
    {   40, -7740, {}},
    {   60, -7740, {}},
    {   60, -7760, {}},
    {   80, -7760, {}},
    {   80, -7780, {}},
    {   80, -7800, {}},
    {  100, -7820, {}},
    {  120, -7840, {}},
    {  120, -7860, {}},
    {  140, -7880, {}},
    {  200, -7980, {}},
    {  267, -8053, {}},
    {  333, -8127, {}},
    {  400, -8200, {}},
    {  464, -8116, {}},
    {  528, -8032, {}},
    {  592, -7948, {}},
    {  656, -7864, {}},
    {  720, -7780, {}},
    {  740, -7780, {}},
    {  760, -7780, {}},
    {  760, -7760, {}},
    {  780, -7740, {}},
    {  800, -7720, {}},
    {  820, -7720, {}},
    {  840, -7740, {}},
    {  860, -7740, {}},
    {  930, -7720, {}},
    { 1000, -7700, {}},
    { 1100, -7700, {}},
    { 1200, -7700, {}},
    { 1300, -7700, {}},
    { 1400, -7700, {}},
    { 1500, -7700, {}},
    { 1477, -7600, {}},
    { 1455, -7500, {}},
    { 1432, -7400, {}},
    { 1409, -7300, {}},
    { 1387, -7200, {}},
    { 1364, -7100, {}},
    { 1341, -7000, {}},
    { 1319, -6900, {}},
    { 1296, -6800, {}},
    { 1273, -6700, {}},
    { 1251, -6600, {}},
    { 1228, -6500, {}},
    { 1205, -6400, {}},
    { 1183, -6300, {}},
    { 1160, -6200, {}},
    { 1160, -6100, {}},
    { 1160, -6000, {}},
    { 1160, -5900, {}},
    { 1160, -5800, {}},
    { 1160, -5700, {}},
    { 1160, -5600, {}},
    { 1160, -5500, {}},
    { 1160, -5400, {}},
    { 1160, -5300, {}},
    { 1160, -5200, {}},
    { 1160, -5100, {}},
    { 1160, -5000, {}},
    { 1160, -4900, {}},
    { 1160, -4800, {}},
    { 1160, -4700, {}},
    { 1160, -4600, {}},
    { 1160, -4500, {}},
    { 1160, -4400, {}},
    { 1160, -4300, {}},
    { 1160, -4200, {}},
    { 1160, -4100, {}},
    { 1160, -4000, {}},
    { 1160, -3900, {}},
    { 1160, -3800, {}},
    { 1160, -3700, {}},
    { 1160, -3600, {}},
    { 1160, -3500, {}},
    { 1160, -3400, {}},
    { 1160, -3300, {}},
    { 1160, -3200, {}},
    { 1160, -3100, {}},
    { 1160, -3000, {}},
    { 1160, -2900, {}},
    { 1160, -2800, {}},
    { 1160, -2700, {}},
    { 1160, -2600, {}},
};

static ZoneVertex cqz10[] = {
    {  400, -13000, {}},
    {  400, -12900, {}},
    {  400, -12800, {}},
    {  400, -12700, {}},
    {  400, -12600, {}},
    {  400, -12500, {}},
    {  400, -12400, {}},
    {  400, -12300, {}},
    {  400, -12200, {}},
    {  400, -12100, {}},
    {  400, -12000, {}},
    {  400, -11900, {}},
    {  400, -11800, {}},
    {  400, -11700, {}},
    {  400, -11600, {}},
    {  400, -11500, {}},
    {  400, -11400, {}},
    {  400, -11300, {}},
    {  400, -11200, {}},
    {  400, -11100, {}},
    {  400, -11000, {}},
    {  400, -10900, {}},
    {  400, -10800, {}},
    {  400, -10700, {}},
    {  400, -10600, {}},
    {  400, -10500, {}},
    {  400, -10400, {}},
    {  400, -10300, {}},
    {  400, -10200, {}},
    {  400, -10100, {}},
    {  400, -10000, {}},
    {  400, -9900, {}},
    {  400, -9800, {}},
    {  400, -9700, {}},
    {  400, -9600, {}},
    {  400, -9500, {}},
    {  400, -9400, {}},
    {  400, -9300, {}},
    {  400, -9200, {}},
    {  400, -9100, {}},
    {  400, -9000, {}},
    {  400, -8900, {}},
    {  400, -8800, {}},
    {  400, -8700, {}},
    {  400, -8600, {}},
    {  400, -8500, {}},
    {  400, -8400, {}},
    {  400, -8300, {}},
    {  400, -8200, {}},
    {  333, -8127, {}},
    {  267, -8053, {}},
    {  200, -7980, {}},
    {  140, -7880, {}},
    {  120, -7860, {}},
    {  120, -7840, {}},
    {  100, -7820, {}},
    {   80, -7800, {}},
    {   80, -7780, {}},
    {   60, -7760, {}},
    {   40, -7740, {}},
    {   40, -7720, {}},
    {   20, -7700, {}},
    {   20, -7680, {}},
    {   20, -7660, {}},
    {   40, -7640, {}},
    {   40, -7620, {}},
    {   20, -7600, {}},
    {    0, -7580, {}},
    {    0, -7560, {}},
    {    0, -7540, {}},
    {    0, -7520, {}},
    {  -20, -7500, {}},
    {  -20, -7480, {}},
    {  -40, -7460, {}},
    {  -60, -7440, {}},
    {  -80, -7420, {}},
    { -100, -7420, {}},
    { -120, -7400, {}},
    { -120, -7380, {}},
    { -140, -7360, {}},
    { -160, -7360, {}},
    { -180, -7340, {}},
    { -180, -7320, {}},
    { -200, -7320, {}},
    { -220, -7320, {}},
    { -240, -7300, {}},
    { -240, -7280, {}},
    { -240, -7260, {}},
    { -240, -7240, {}},
    { -240, -7220, {}},
    { -240, -7200, {}},
    { -220, -7180, {}},
    { -220, -7160, {}},
    { -240, -7140, {}},
    { -240, -7120, {}},
    { -220, -7100, {}},
    { -220, -7080, {}},
    { -240, -7060, {}},
    { -240, -7040, {}},
    { -260, -7020, {}},
    { -320, -7050, {}},
    { -380, -7080, {}},
    { -380, -7060, {}},
    { -380, -7040, {}},
    { -400, -7020, {}},
    { -420, -7000, {}},
    { -440, -7020, {}},
    { -420, -7020, {}},
    { -420, -7040, {}},
    { -420, -7060, {}},
    { -420, -7080, {}},
    { -440, -7100, {}},
    { -440, -7120, {}},
    { -440, -7140, {}},
    { -460, -7160, {}},
    { -440, -7180, {}},
    { -460, -7200, {}},
    { -480, -7220, {}},
    { -480, -7240, {}},
    { -500, -7260, {}},
    { -520, -7280, {}},
    { -540, -7300, {}},
    { -560, -7300, {}},
    { -580, -7320, {}},
    { -600, -7320, {}},
    { -620, -7320, {}},
    { -640, -7320, {}},
    { -660, -7340, {}},
    { -680, -7360, {}},
    { -700, -7380, {}},
    { -720, -7380, {}},
    { -740, -7400, {}},
    { -760, -7380, {}},
    { -780, -7360, {}},
    { -800, -7360, {}},
    { -820, -7360, {}},
    { -840, -7340, {}},
    { -860, -7340, {}},
    { -860, -7320, {}},
    { -880, -7320, {}},
    { -900, -7300, {}},
    { -920, -7300, {}},
    { -940, -7320, {}},
    { -940, -7280, {}},
    { -940, -7260, {}},
    { -940, -7240, {}},
    { -960, -7220, {}},
    { -980, -7220, {}},
    {-1000, -7220, {}},
    {-1000, -7140, {}},
    {-1000, -7120, {}},
    { -980, -7100, {}},
    { -960, -7080, {}},
    { -940, -7060, {}},
    { -960, -7060, {}},
    { -980, -7060, {}},
    {-1040, -7060, {}},
    {-1100, -7060, {}},
    {-1100, -7040, {}},
    {-1100, -7020, {}},
    {-1100, -7000, {}},
    {-1100, -6980, {}},
    {-1100, -6960, {}},
    {-1100, -6940, {}},
    {-1100, -6920, {}},
    {-1100, -6900, {}},
    {-1100, -6880, {}},
    {-1120, -6860, {}},
    {-1100, -6840, {}},
    {-1080, -6820, {}},
    {-1060, -6800, {}},
    {-1060, -6780, {}},
    {-1060, -6760, {}},
    {-1040, -6740, {}},
    {-1040, -6720, {}},
    {-1020, -6700, {}},
    {-1000, -6680, {}},
    {-1000, -6660, {}},
    { -980, -6640, {}},
    { -980, -6620, {}},
    { -980, -6600, {}},
    { -980, -6580, {}},
    { -980, -6560, {}},
    { -960, -6540, {}},
    { -980, -6540, {}},
    {-1000, -6540, {}},
    {-1020, -6520, {}},
    {-1040, -6540, {}},
    {-1060, -6540, {}},
    {-1080, -6540, {}},
    {-1100, -6520, {}},
    {-1120, -6540, {}},
    {-1140, -6540, {}},
    {-1160, -6520, {}},
    {-1180, -6500, {}},
    {-1200, -6500, {}},
    {-1220, -6480, {}},
    {-1220, -6460, {}},
    {-1240, -6440, {}},
    {-1240, -6420, {}},
    {-1260, -6400, {}},
    {-1240, -6380, {}},
    {-1240, -6360, {}},
    {-1260, -6340, {}},
    {-1260, -6320, {}},
    {-1280, -6300, {}},
    {-1300, -6280, {}},
    {-1300, -6260, {}},
    {-1320, -6240, {}},
    {-1320, -6220, {}},
    {-1340, -6200, {}},
    {-1360, -6180, {}},
    {-1360, -6160, {}},
    {-1360, -6140, {}},
    {-1360, -6120, {}},
    {-1340, -6100, {}},
    {-1360, -6080, {}},
    {-1380, -6060, {}},
    {-1400, -6040, {}},
    {-1420, -6040, {}},
    {-1440, -6040, {}},
    {-1460, -6040, {}},
    {-1500, -6020, {}},
    {-1500, -6060, {}},
    {-1540, -6020, {}},
    {-1620, -6020, {}},
    {-1630, -5930, {}},
    {-1640, -5840, {}},
    {-1660, -5840, {}},
    {-1680, -5840, {}},
    {-1700, -5840, {}},
    {-1720, -5840, {}},
    {-1740, -5820, {}},
    {-1760, -5800, {}},
    {-1760, -5780, {}},
    {-1780, -5760, {}},
    {-1800, -5760, {}},
    {-1820, -5740, {}},
    {-1880, -5780, {}},
    {-1900, -5760, {}},
    {-1980, -5820, {}},
    {-2000, -5780, {}},
    {-2000, -5800, {}},
    {-2000, -5820, {}},
    {-1980, -5820, {}},
    {-1920, -5900, {}},
    {-1920, -6000, {}},
    {-1940, -6060, {}},
    {-1950, -6120, {}},
    {-1960, -6180, {}},
    {-2000, -6200, {}},
    {-2060, -6220, {}},
    {-2100, -6220, {}},
    {-2160, -6240, {}},
    {-2220, -6260, {}},
    {-2220, -6280, {}},
    {-2200, -6280, {}},
    {-2200, -6360, {}},
    {-2200, -6400, {}},
    {-2220, -6400, {}},
    {-2240, -6420, {}},
    {-2260, -6420, {}},
    {-2280, -6420, {}},
    {-2280, -6440, {}},
    {-2260, -6440, {}},
    {-2240, -6460, {}},
    {-2220, -6460, {}},
    {-2220, -6480, {}},
    {-2200, -6540, {}},
    {-2200, -6560, {}},
    {-2200, -6580, {}},
    {-2200, -6600, {}},
    {-2180, -6620, {}},
    {-2200, -6620, {}},
    {-2220, -6660, {}},
    {-2240, -6680, {}},
    {-2260, -6700, {}},
    {-2280, -6720, {}},
    {-2280, -6760, {}},
    {-2280, -6780, {}},
    {-2260, -6780, {}},
    {-2240, -6800, {}},
    {-2220, -6800, {}},
    {-2200, -6800, {}},
    {-2180, -6800, {}},
    {-2160, -6820, {}},
    {-2140, -6820, {}},
    {-2100, -6820, {}},
    {-2100, -6840, {}},
    {-2080, -6860, {}},
    {-2060, -6860, {}},
    {-2040, -6880, {}},
    {-2020, -6880, {}},
    {-2000, -6860, {}},
    {-1980, -6860, {}},
    {-1960, -6860, {}},
    {-1940, -6840, {}},
    {-1920, -6860, {}},
    {-1900, -6880, {}},
    {-1880, -6900, {}},
    {-1860, -6900, {}},
    {-1840, -6900, {}},
    {-1820, -6920, {}},
    {-1800, -6920, {}},
    {-1780, -6940, {}},
    {-1740, -6940, {}},
    {-1760, -6960, {}},
    {-1760, -6980, {}},
    {-1780, -6980, {}},
    {-1800, -6980, {}},
    {-1820, -7000, {}},
    {-1840, -7020, {}},
    {-1920, -7110, {}},
    {-2000, -7200, {}},
    {-2000, -7300, {}},
    {-2000, -7400, {}},
    {-2000, -7500, {}},
    {-2000, -7600, {}},
    {-2000, -7700, {}},
    {-2000, -7800, {}},
    {-2000, -7900, {}},
    {-2000, -8000, {}},
    {-2000, -8100, {}},
    {-2000, -8200, {}},
    {-2000, -8300, {}},
    {-2000, -8400, {}},
    {-2000, -8500, {}},
    {-2000, -8600, {}},
    {-2000, -8700, {}},
    {-2000, -8800, {}},
    {-2000, -8900, {}},
    {-2000, -9000, {}},
    {-2000, -9100, {}},
    {-2000, -9200, {}},
    {-2000, -9300, {}},
    {-2000, -9400, {}},
    {-2000, -9500, {}},
    {-2000, -9600, {}},
    {-2000, -9700, {}},
    {-2000, -9800, {}},
    {-2000, -9900, {}},
    {-2000, -10000, {}},
    {-2000, -10100, {}},
    {-2000, -10200, {}},
    {-2000, -10300, {}},
    {-2000, -10400, {}},
    {-2000, -10500, {}},
    {-2000, -10600, {}},
    {-2000, -10700, {}},
    {-2000, -10800, {}},
    {-2000, -10900, {}},
    {-2000, -11000, {}},
    {-2000, -11100, {}},
    {-2000, -11200, {}},
    {-2000, -11300, {}},
    {-2000, -11400, {}},
    {-2000, -11500, {}},
    {-2000, -11600, {}},
    {-2000, -11700, {}},
    {-2000, -11800, {}},
    {-2000, -11900, {}},
    {-2000, -12000, {}},
    {-1900, -12000, {}},
    {-1800, -12000, {}},
    {-1700, -12000, {}},
    {-1600, -12000, {}},
    {-1500, -12000, {}},
    {-1400, -12000, {}},
    {-1300, -12000, {}},
    {-1200, -12000, {}},
    {-1200, -12100, {}},
    {-1200, -12200, {}},
    {-1200, -12300, {}},
    {-1200, -12400, {}},
    {-1200, -12500, {}},
    {-1200, -12600, {}},
    {-1200, -12700, {}},
    {-1200, -12800, {}},
    {-1200, -12900, {}},
    {-1200, -13000, {}},
    {-1100, -13000, {}},
    {-1000, -13000, {}},
    { -900, -13000, {}},
    { -800, -13000, {}},
    { -700, -13000, {}},
    { -600, -13000, {}},
    { -500, -13000, {}},
    { -400, -13000, {}},
    { -300, -13000, {}},
    { -200, -13000, {}},
    { -100, -13000, {}},
    {    0, -13000, {}},
    {  100, -13000, {}},
    {  200, -13000, {}},
    {  300, -13000, {}},
    {  400, -13000, {}},
};

static ZoneVertex cqz11[] = {
    {  500, -2600, {}},
    {  500, -2698, {}},
    {  500, -2797, {}},
    {  500, -2895, {}},
    {  500, -2994, {}},
    {  500, -3092, {}},
    {  500, -3191, {}},
    {  500, -3289, {}},
    {  500, -3388, {}},
    {  500, -3486, {}},
    {  500, -3585, {}},
    {  500, -3683, {}},
    {  500, -3782, {}},
    {  500, -3880, {}},
    {  500, -3978, {}},
    {  500, -4077, {}},
    {  500, -4175, {}},
    {  500, -4274, {}},
    {  500, -4372, {}},
    {  500, -4471, {}},
    {  500, -4569, {}},
    {  500, -4668, {}},
    {  500, -4766, {}},
    {  500, -4865, {}},
    {  500, -4963, {}},
    {  500, -5062, {}},
    {  500, -5160, {}},
    {  440, -5160, {}},
    {  420, -5160, {}},
    {  400, -5180, {}},
    {  380, -5200, {}},
    {  320, -5220, {}},
    {  300, -5240, {}},
    {  260, -5260, {}},
    {  240, -5260, {}},
    {  220, -5280, {}},
    {  220, -5300, {}},
    {  220, -5320, {}},
    {  220, -5340, {}},
    {  240, -5380, {}},
    {  220, -5400, {}},
    {  220, -5420, {}},
    {  220, -5440, {}},
    {  240, -5460, {}},
    {  240, -5480, {}},
    {  260, -5500, {}},
    {  240, -5520, {}},
    {  240, -5540, {}},
    {  240, -5580, {}},
    {  240, -5600, {}},
    {  220, -5600, {}},
    {  200, -5600, {}},
    {  200, -5620, {}},
    {  200, -5640, {}},
    {  200, -5660, {}},
    {  180, -5680, {}},
    {  200, -5700, {}},
    {  200, -5720, {}},
    {  200, -5740, {}},
    {  180, -5740, {}},
    {  160, -5760, {}},
    {  160, -5780, {}},
    {  160, -5800, {}},
    {  160, -5820, {}},
    {  140, -5840, {}},
    {  120, -5860, {}},
    {  120, -5880, {}},
    {  140, -5900, {}},
    {  140, -5920, {}},
    {  160, -5940, {}},
    {  180, -5960, {}},
    {  200, -5980, {}},
    {  220, -5980, {}},
    {  240, -5980, {}},
    {  260, -6000, {}},
    {  300, -6000, {}},
    {  320, -6000, {}},
    {  340, -5980, {}},
    {  360, -5980, {}},
    {  380, -5960, {}},
    {  400, -5960, {}},
    {  420, -5980, {}},
    {  440, -5980, {}},
    {  440, -6000, {}},
    {  460, -6020, {}},
    {  480, -6000, {}},
    {  500, -6000, {}},
    {  520, -6020, {}},
    {  520, -6040, {}},
    {  520, -6060, {}},
    {  500, -6060, {}},
    {  480, -6080, {}},
    {  460, -6100, {}},
    {  460, -6120, {}},
    {  440, -6140, {}},
    {  420, -6160, {}},
    {  420, -6180, {}},
    {  420, -6200, {}},
    {  420, -6220, {}},
    {  420, -6240, {}},
    {  400, -6260, {}},
    {  380, -6280, {}},
    {  360, -6300, {}},
    {  380, -6320, {}},
    {  400, -6340, {}},
    {  400, -6360, {}},
    {  400, -6380, {}},
    {  400, -6400, {}},
    {  420, -6420, {}},
    {  420, -6440, {}},
    {  420, -6460, {}},
    {  420, -6480, {}},
    {  400, -6460, {}},
    {  380, -6440, {}},
    {  360, -6420, {}},
    {  340, -6420, {}},
    {  320, -6420, {}},
    {  300, -6420, {}},
    {  280, -6400, {}},
    {  260, -6400, {}},
    {  240, -6380, {}},
    {  240, -6360, {}},
    {  240, -6340, {}},
    {  220, -6340, {}},
    {  220, -6360, {}},
    {  200, -6380, {}},
    {  200, -6400, {}},
    {  180, -6400, {}},
    {  160, -6420, {}},
    {  140, -6440, {}},
    {  140, -6460, {}},
    {  140, -6480, {}},
    {  120, -6500, {}},
    {  100, -6520, {}},
    {   80, -6540, {}},
    {   60, -6560, {}},
    {   80, -6560, {}},
    {  100, -6560, {}},
    {  100, -6580, {}},
    {   80, -6600, {}},
    {   80, -6640, {}},
    {  120, -6680, {}},
    {  120, -6700, {}},
    {  140, -6700, {}},
    {  160, -6720, {}},
    {  180, -6720, {}},
    {  200, -6740, {}},
    {  220, -6740, {}},
    {  200, -6760, {}},
    {  200, -6780, {}},
    {  180, -6800, {}},
    {  200, -6820, {}},
    {  180, -6820, {}},
    {  180, -6880, {}},
    {  180, -6940, {}},
    {  180, -6960, {}},
    {  180, -6980, {}},
    {  100, -6980, {}},
    {  100, -6960, {}},
    {  100, -6940, {}},
    {  100, -6920, {}},
    {   80, -6920, {}},
    {   60, -6920, {}},
    {   60, -6940, {}},
    {   60, -6960, {}},
    {   60, -6980, {}},
    {   60, -7000, {}},
    {  -20, -7000, {}},
    {  -40, -6980, {}},
    {  -60, -6960, {}},
    {  -80, -6960, {}},
    { -100, -6940, {}},
    { -120, -6940, {}},
    { -140, -6940, {}},
    { -233, -6960, {}},
    { -327, -6980, {}},
    { -420, -7000, {}},
    { -440, -7020, {}},
    { -420, -7020, {}},
    { -420, -7040, {}},
    { -420, -7060, {}},
    { -420, -7080, {}},
    { -440, -7100, {}},
    { -440, -7120, {}},
    { -440, -7140, {}},
    { -460, -7160, {}},
    { -440, -7180, {}},
    { -460, -7200, {}},
    { -480, -7220, {}},
    { -480, -7240, {}},
    { -500, -7260, {}},
    { -520, -7280, {}},
    { -540, -7300, {}},
    { -560, -7300, {}},
    { -580, -7320, {}},
    { -600, -7320, {}},
    { -620, -7320, {}},
    { -640, -7320, {}},
    { -660, -7340, {}},
    { -680, -7360, {}},
    { -700, -7380, {}},
    { -720, -7380, {}},
    { -740, -7400, {}},
    { -760, -7380, {}},
    { -780, -7360, {}},
    { -800, -7360, {}},
    { -820, -7360, {}},
    { -840, -7340, {}},
    { -860, -7340, {}},
    { -860, -7320, {}},
    { -880, -7320, {}},
    { -900, -7300, {}},
    { -920, -7300, {}},
    { -940, -7320, {}},
    { -940, -7280, {}},
    { -940, -7260, {}},
    { -940, -7240, {}},
    { -960, -7220, {}},
    { -980, -7220, {}},
    {-1000, -7220, {}},
    {-1000, -7140, {}},
    {-1000, -7120, {}},
    { -980, -7100, {}},
    { -960, -7080, {}},
    { -940, -7060, {}},
    { -960, -7060, {}},
    { -980, -7060, {}},
    {-1040, -7060, {}},
    {-1100, -7060, {}},
    {-1100, -7040, {}},
    {-1100, -7020, {}},
    {-1100, -7000, {}},
    {-1100, -6980, {}},
    {-1100, -6960, {}},
    {-1100, -6940, {}},
    {-1100, -6920, {}},
    {-1100, -6900, {}},
    {-1100, -6880, {}},
    {-1120, -6860, {}},
    {-1100, -6840, {}},
    {-1080, -6820, {}},
    {-1060, -6800, {}},
    {-1060, -6780, {}},
    {-1060, -6760, {}},
    {-1040, -6740, {}},
    {-1040, -6720, {}},
    {-1020, -6700, {}},
    {-1000, -6680, {}},
    {-1000, -6660, {}},
    { -980, -6640, {}},
    { -980, -6620, {}},
    { -980, -6600, {}},
    { -980, -6580, {}},
    { -980, -6560, {}},
    { -960, -6540, {}},
    { -980, -6540, {}},
    {-1000, -6540, {}},
    {-1020, -6520, {}},
    {-1040, -6540, {}},
    {-1060, -6540, {}},
    {-1080, -6540, {}},
    {-1100, -6520, {}},
    {-1120, -6540, {}},
    {-1140, -6540, {}},
    {-1160, -6520, {}},
    {-1180, -6500, {}},
    {-1200, -6500, {}},
    {-1220, -6480, {}},
    {-1220, -6460, {}},
    {-1240, -6440, {}},
    {-1240, -6420, {}},
    {-1260, -6400, {}},
    {-1240, -6380, {}},
    {-1240, -6360, {}},
    {-1260, -6340, {}},
    {-1260, -6320, {}},
    {-1280, -6300, {}},
    {-1300, -6280, {}},
    {-1300, -6260, {}},
    {-1320, -6240, {}},
    {-1320, -6220, {}},
    {-1340, -6200, {}},
    {-1360, -6180, {}},
    {-1360, -6160, {}},
    {-1360, -6140, {}},
    {-1360, -6120, {}},
    {-1340, -6100, {}},
    {-1360, -6080, {}},
    {-1380, -6060, {}},
    {-1400, -6040, {}},
    {-1420, -6040, {}},
    {-1440, -6040, {}},
    {-1460, -6040, {}},
    {-1500, -6020, {}},
    {-1500, -6060, {}},
    {-1540, -6020, {}},
    {-1620, -6020, {}},
    {-1630, -5930, {}},
    {-1640, -5840, {}},
    {-1660, -5840, {}},
    {-1680, -5840, {}},
    {-1700, -5840, {}},
    {-1720, -5840, {}},
    {-1740, -5820, {}},
    {-1760, -5800, {}},
    {-1760, -5780, {}},
    {-1780, -5760, {}},
    {-1800, -5760, {}},
    {-1820, -5740, {}},
    {-1880, -5780, {}},
    {-1900, -5760, {}},
    {-1980, -5820, {}},
    {-2000, -5780, {}},
    {-2000, -5800, {}},
    {-2000, -5820, {}},
    {-1980, -5820, {}},
    {-1920, -5900, {}},
    {-1920, -6000, {}},
    {-1940, -6060, {}},
    {-1950, -6120, {}},
    {-1960, -6180, {}},
    {-2000, -6200, {}},
    {-2060, -6220, {}},
    {-2100, -6220, {}},
    {-2160, -6240, {}},
    {-2220, -6260, {}},
    {-2240, -6240, {}},
    {-2260, -6220, {}},
    {-2280, -6220, {}},
    {-2300, -6200, {}},
    {-2320, -6180, {}},
    {-2320, -6160, {}},
    {-2340, -6160, {}},
    {-2340, -6140, {}},
    {-2360, -6120, {}},
    {-2380, -6100, {}},
    {-2380, -6080, {}},
    {-2400, -6060, {}},
    {-2400, -6040, {}},
    {-2400, -6020, {}},
    {-2440, -5940, {}},
    {-2460, -5920, {}},
    {-2460, -5900, {}},
    {-2480, -5880, {}},
    {-2480, -5860, {}},
    {-2500, -5840, {}},
    {-2500, -5820, {}},
    {-2500, -5800, {}},
    {-2520, -5780, {}},
    {-2540, -5760, {}},
    {-2560, -5760, {}},
    {-2580, -5780, {}},
    {-2600, -5780, {}},
    {-2620, -5800, {}},
    {-2640, -5820, {}},
    {-2660, -5820, {}},
    {-2680, -5840, {}},
    {-2700, -5840, {}},
    {-2720, -5860, {}},
    {-2720, -5840, {}},
    {-2720, -5820, {}},
    {-2720, -5800, {}},
    {-2740, -5780, {}},
    {-2740, -5760, {}},
    {-2740, -5740, {}},
    {-2740, -5720, {}},
    {-2740, -5700, {}},
    {-2740, -5680, {}},
    {-2740, -5660, {}},
    {-2760, -5640, {}},
    {-2740, -5620, {}},
    {-2740, -5600, {}},
    {-2740, -5580, {}},
    {-2740, -5560, {}},
    {-2720, -5560, {}},
    {-2700, -5540, {}},
    {-2700, -5520, {}},
    {-2680, -5500, {}},
    {-2660, -5480, {}},
    {-2640, -5460, {}},
    {-2620, -5460, {}},
    {-2600, -5460, {}},
    {-2580, -5460, {}},
    {-2560, -5460, {}},
    {-2560, -5440, {}},
    {-2560, -5420, {}},
    {-2560, -5400, {}},
    {-2580, -5380, {}},
    {-2600, -5380, {}},
    {-2620, -5360, {}},
    {-2640, -5360, {}},
    {-2660, -5380, {}},
    {-2680, -5360, {}},
    {-2700, -5380, {}},
    {-2720, -5400, {}},
    {-2740, -5420, {}},
    {-2740, -5440, {}},
    {-2760, -5460, {}},
    {-2760, -5480, {}},
    {-2780, -5500, {}},
    {-2780, -5520, {}},
    {-2800, -5540, {}},
    {-2820, -5560, {}},
    {-2840, -5560, {}},
    {-2840, -5580, {}},
    {-2860, -5600, {}},
    {-2880, -5620, {}},
    {-2900, -5640, {}},
    {-2920, -5660, {}},
    {-2940, -5680, {}},
    {-2960, -5700, {}},
    {-2980, -5720, {}},
    {-3000, -5740, {}},
    {-3020, -5760, {}},
    {-3040, -5740, {}},
    {-3020, -5720, {}},
    {-3000, -5700, {}},
    {-3020, -5680, {}},
    {-3020, -5660, {}},
    {-3040, -5640, {}},
    {-3060, -5620, {}},
    {-3080, -5600, {}},
    {-3100, -5600, {}},
    {-3100, -5580, {}},
    {-3080, -5560, {}},
    {-3100, -5540, {}},
    {-3120, -5520, {}},
    {-3120, -5500, {}},
    {-3140, -5480, {}},
    {-3140, -5460, {}},
    {-3160, -5440, {}},
    {-3180, -5420, {}},
    {-3200, -5400, {}},
    {-3200, -5380, {}},
    {-3220, -5380, {}},
    {-3240, -5360, {}},
    {-3260, -5340, {}},
    {-3260, -5320, {}},
    {-3300, -5340, {}},
    {-3340, -5360, {}},
    {-3360, -5360, {}},
    {-3380, -5340, {}},
    {-3400, -5300, {}},
    {-3400, -5200, {}},
    {-3400, -5100, {}},
    {-3400, -5000, {}},
    {-3400, -4900, {}},
    {-3400, -4800, {}},
    {-3400, -4700, {}},
    {-3400, -4600, {}},
    {-3400, -4500, {}},
    {-3400, -4400, {}},
    {-3400, -4300, {}},
    {-3400, -4200, {}},
    {-3400, -4100, {}},
    {-3400, -4000, {}},
    {-3400, -3900, {}},
    {-3400, -3800, {}},
    {-3400, -3700, {}},
    {-3400, -3600, {}},
    {-3400, -3500, {}},
    {-3400, -3400, {}},
    {-3400, -3300, {}},
    {-3400, -3200, {}},
    {-3400, -3100, {}},
    {-3400, -3000, {}},
    {-3400, -2900, {}},
    {-3400, -2800, {}},
    {-3400, -2700, {}},
    {-3400, -2600, {}},
    {-3300, -2600, {}},
    {-3200, -2600, {}},
    {-3100, -2600, {}},
    {-3000, -2600, {}},
    {-2900, -2600, {}},
    {-2800, -2600, {}},
    {-2700, -2600, {}},
    {-2600, -2600, {}},
    {-2500, -2600, {}},
    {-2400, -2600, {}},
    {-2300, -2600, {}},
    {-2200, -2600, {}},
    {-2100, -2600, {}},
    {-2000, -2600, {}},
    {-1900, -2600, {}},
    {-1800, -2600, {}},
    {-1700, -2600, {}},
    {-1600, -2600, {}},
    {-1500, -2600, {}},
    {-1400, -2600, {}},
    {-1300, -2600, {}},
    {-1200, -2600, {}},
    {-1100, -2600, {}},
    {-1000, -2600, {}},
    { -900, -2600, {}},
    { -800, -2600, {}},
    { -700, -2600, {}},
    { -600, -2600, {}},
    { -500, -2600, {}},
    { -400, -2600, {}},
    { -300, -2600, {}},
    { -200, -2600, {}},
    { -100, -2600, {}},
    {    0, -2600, {}},
    {  100, -2600, {}},
    {  200, -2600, {}},
    {  300, -2600, {}},
    {  400, -2600, {}},
    {  500, -2600, {}},
};

static ZoneVertex cqz12[] = {
    {-2000, -12000, {}},
    {-2100, -12000, {}},
    {-2200, -12000, {}},
    {-2300, -12000, {}},
    {-2400, -12000, {}},
    {-2500, -12000, {}},
    {-2600, -12000, {}},
    {-2700, -12000, {}},
    {-2800, -12000, {}},
    {-2900, -12000, {}},
    {-3000, -12000, {}},
    {-3100, -12000, {}},
    {-3200, -12000, {}},
    {-3300, -12000, {}},
    {-3400, -12000, {}},
    {-3500, -12000, {}},
    {-3600, -12000, {}},
    {-3700, -12000, {}},
    {-3800, -12000, {}},
    {-3900, -12000, {}},
    {-4000, -12000, {}},
    {-4100, -12000, {}},
    {-4200, -12000, {}},
    {-4300, -12000, {}},
    {-4400, -12000, {}},
    {-4500, -12000, {}},
    {-4600, -12000, {}},
    {-4700, -12000, {}},
    {-4800, -12000, {}},
    {-4900, -12000, {}},
    {-5000, -12000, {}},
    {-5100, -12000, {}},
    {-5200, -12000, {}},
    {-5300, -12000, {}},
    {-5400, -12000, {}},
    {-5500, -12000, {}},
    {-5600, -12000, {}},
    {-5700, -12000, {}},
    {-5800, -12000, {}},
    {-5900, -12000, {}},
    {-6000, -12000, {}},
    {-6100, -12000, {}},
    {-6200, -12000, {}},
    {-6300, -12000, {}},
    {-6400, -12000, {}},
    {-6500, -12000, {}},
    {-6600, -12000, {}},
    {-6700, -12000, {}},
    {-6800, -12000, {}},
    {-6900, -12000, {}},
    {-7000, -12000, {}},
    {-7100, -12000, {}},
    {-7200, -12000, {}},
    {-7300, -12000, {}},
    {-7400, -12000, {}},
    {-7500, -12000, {}},
    {-7600, -12000, {}},
    {-7700, -12000, {}},
    {-7800, -12000, {}},
    {-7900, -12000, {}},
    {-8000, -12000, {}},
    {-8100, -12000, {}},
    {-8200, -12000, {}},
    {-8300, -12000, {}},
    {-8400, -12000, {}},
    {-8500, -12000, {}},
    {-8600, -12000, {}},
    {-8700, -12000, {}},
    {-8800, -12000, {}},
    {-8900, -12000, {}},
    {-9000, -12000, {}},
    {-9000, -11900, {}},
    {-9000, -11800, {}},
    {-9000, -11700, {}},
    {-9000, -11600, {}},
    {-9000, -11500, {}},
    {-9000, -11400, {}},
    {-9000, -11300, {}},
    {-9000, -11200, {}},
    {-9000, -11100, {}},
    {-9000, -11000, {}},
    {-9000, -10900, {}},
    {-9000, -10800, {}},
    {-9000, -10700, {}},
    {-9000, -10600, {}},
    {-9000, -10500, {}},
    {-9000, -10400, {}},
    {-9000, -10300, {}},
    {-9000, -10200, {}},
    {-9000, -10100, {}},
    {-9000, -10000, {}},
    {-9000, -9900, {}},
    {-9000, -9800, {}},
    {-9000, -9700, {}},
    {-9000, -9600, {}},
    {-9000, -9500, {}},
    {-9000, -9400, {}},
    {-9000, -9300, {}},
    {-9000, -9200, {}},
    {-9000, -9100, {}},
    {-9000, -9000, {}},
    {-9000, -8900, {}},
    {-9000, -8800, {}},
    {-9000, -8700, {}},
    {-9000, -8600, {}},
    {-9000, -8500, {}},
    {-9000, -8400, {}},
    {-9000, -8300, {}},
    {-9000, -8200, {}},
    {-9000, -8100, {}},
    {-9000, -8000, {}},
    {-9000, -7900, {}},
    {-9000, -7800, {}},
    {-9000, -7700, {}},
    {-9000, -7600, {}},
    {-9000, -7500, {}},
    {-9000, -7400, {}},
    {-9000, -7300, {}},
    {-9000, -7200, {}},
    {-9000, -7100, {}},
    {-9000, -7000, {}},
    {-8900, -7000, {}},
    {-8800, -7000, {}},
    {-8700, -7000, {}},
    {-8600, -7000, {}},
    {-8500, -7000, {}},
    {-8400, -7000, {}},
    {-8300, -7000, {}},
    {-8200, -7000, {}},
    {-8100, -7000, {}},
    {-8000, -7000, {}},
    {-7900, -7000, {}},
    {-7800, -7000, {}},
    {-7700, -7000, {}},
    {-7600, -7000, {}},
    {-7500, -7000, {}},
    {-7400, -7000, {}},
    {-7300, -7000, {}},
    {-7200, -7000, {}},
    {-7100, -7000, {}},
    {-7000, -7000, {}},
    {-6900, -7000, {}},
    {-6800, -7000, {}},
    {-6700, -7000, {}},
    {-6600, -7000, {}},
    {-6500, -7000, {}},
    {-6400, -7000, {}},
    {-6300, -7000, {}},
    {-6200, -7000, {}},
    {-6100, -7000, {}},
    {-6000, -7000, {}},
    {-5900, -7000, {}},
    {-5800, -7000, {}},
    {-5700, -7000, {}},
    {-5675, -6900, {}},
    {-5650, -6800, {}},
    {-5625, -6700, {}},
    {-5600, -6600, {}},
    {-5520, -6600, {}},
    {-5520, -6640, {}},
    {-5520, -6660, {}},
    {-5500, -6680, {}},
    {-5500, -6700, {}},
    {-5500, -6720, {}},
    {-5500, -6740, {}},
    {-5500, -6760, {}},
    {-5480, -6800, {}},
    {-5480, -6820, {}},
    {-5500, -6860, {}},
    {-5420, -6860, {}},
    {-5340, -6860, {}},
    {-5260, -6860, {}},
    {-5240, -6840, {}},
    {-5220, -6880, {}},
    {-5220, -6900, {}},
    {-5220, -6940, {}},
    {-5200, -7000, {}},
    {-5200, -7100, {}},
    {-5200, -7200, {}},
    {-5180, -7200, {}},
    {-5180, -7220, {}},
    {-5160, -7240, {}},
    {-5140, -7240, {}},
    {-5120, -7240, {}},
    {-5100, -7220, {}},
    {-5080, -7220, {}},
    {-5060, -7240, {}},
    {-5060, -7260, {}},
    {-5060, -7280, {}},
    {-5080, -7300, {}},
    {-5080, -7320, {}},
    {-5060, -7320, {}},
    {-5040, -7340, {}},
    {-5020, -7340, {}},
    {-5000, -7340, {}},
    {-4920, -7320, {}},
    {-4900, -7300, {}},
    {-4900, -7280, {}},
    {-4880, -7260, {}},
    {-4860, -7260, {}},
    {-4840, -7240, {}},
    {-4820, -7240, {}},
    {-4800, -7240, {}},
    {-4780, -7240, {}},
    {-4760, -7240, {}},
    {-4740, -7220, {}},
    {-4720, -7200, {}},
    {-4700, -7180, {}},
    {-4680, -7200, {}},
    {-4680, -7180, {}},
    {-4660, -7160, {}},
    {-4640, -7180, {}},
    {-4620, -7180, {}},
    {-4600, -7160, {}},
    {-4580, -7180, {}},
    {-4560, -7180, {}},
    {-4560, -7160, {}},
    {-4540, -7160, {}},
    {-4540, -7140, {}},
    {-4520, -7140, {}},
    {-4500, -7160, {}},
    {-4500, -7180, {}},
    {-4480, -7200, {}},
    {-4480, -7180, {}},
    {-4480, -7160, {}},
    {-4480, -7140, {}},
    {-4460, -7120, {}},
    {-4440, -7140, {}},
    {-4440, -7160, {}},
    {-4440, -7180, {}},
    {-4420, -7180, {}},
    {-4400, -7160, {}},
    {-4380, -7180, {}},
    {-4360, -7160, {}},
    {-4360, -7180, {}},
    {-4340, -7200, {}},
    {-4320, -7180, {}},
    {-4300, -7200, {}},
    {-4280, -7220, {}},
    {-4260, -7200, {}},
    {-4240, -7200, {}},
    {-4220, -7220, {}},
    {-4220, -7200, {}},
    {-4220, -7180, {}},
    {-4200, -7180, {}},
    {-4180, -7180, {}},
    {-4160, -7180, {}},
    {-4140, -7180, {}},
    {-4120, -7180, {}},
    {-4100, -7180, {}},
    {-4080, -7200, {}},
    {-4060, -7180, {}},
    {-4040, -7160, {}},
    {-4020, -7180, {}},
    {-4000, -7160, {}},
    {-3980, -7160, {}},
    {-3960, -7160, {}},
    {-3940, -7140, {}},
    {-3920, -7140, {}},
    {-3900, -7140, {}},
    {-3880, -7120, {}},
    {-3880, -7100, {}},
    {-3860, -7080, {}},
    {-3840, -7100, {}},
    {-3820, -7100, {}},
    {-3800, -7100, {}},
    {-3780, -7120, {}},
    {-3760, -7120, {}},
    {-3740, -7120, {}},
    {-3720, -7120, {}},
    {-3700, -7120, {}},
    {-3680, -7120, {}},
    {-3660, -7100, {}},
    {-3640, -7080, {}},
    {-3620, -7060, {}},
    {-3600, -7040, {}},
    {-3580, -7040, {}},
    {-3560, -7040, {}},
    {-3540, -7040, {}},
    {-3520, -7060, {}},
    {-3520, -7040, {}},
    {-3500, -7040, {}},
    {-3480, -7020, {}},
    {-3460, -7020, {}},
    {-3440, -7000, {}},
    {-3420, -6980, {}},
    {-3400, -6980, {}},
    {-3380, -6980, {}},
    {-3360, -6980, {}},
    {-3340, -6980, {}},
    {-3340, -7000, {}},
    {-3320, -7000, {}},
    {-3300, -7000, {}},
    {-3280, -7020, {}},
    {-3260, -7020, {}},
    {-3240, -7020, {}},
    {-3220, -7040, {}},
    {-3200, -7020, {}},
    {-3180, -7040, {}},
    {-3160, -7060, {}},
    {-3140, -7060, {}},
    {-3120, -7060, {}},
    {-3120, -7040, {}},
    {-3100, -7020, {}},
    {-3080, -7020, {}},
    {-3060, -7020, {}},
    {-3040, -7020, {}},
    {-3040, -7000, {}},
    {-3020, -6980, {}},
    {-3000, -7000, {}},
    {-2980, -7000, {}},
    {-2960, -7000, {}},
    {-2940, -7000, {}},
    {-2920, -7000, {}},
    {-2920, -6980, {}},
    {-2900, -6980, {}},
    {-2880, -6980, {}},
    {-2860, -6960, {}},
    {-2840, -6960, {}},
    {-2820, -6940, {}},
    {-2800, -6920, {}},
    {-2780, -6900, {}},
    {-2760, -6900, {}},
    {-2740, -6900, {}},
    {-2720, -6880, {}},
    {-2720, -6860, {}},
    {-2700, -6840, {}},
    {-2680, -6840, {}},
    {-2640, -6860, {}},
    {-2620, -6840, {}},
    {-2580, -6840, {}},
    {-2560, -6860, {}},
    {-2540, -6860, {}},
    {-2520, -6860, {}},
    {-2520, -6840, {}},
    {-2500, -6840, {}},
    {-2480, -6860, {}},
    {-2460, -6840, {}},
    {-2440, -6820, {}},
    {-2400, -6740, {}},
    {-2300, -6700, {}},
    {-2280, -6720, {}},
    {-2280, -6760, {}},
    {-2280, -6780, {}},
    {-2260, -6780, {}},
    {-2240, -6800, {}},
    {-2220, -6800, {}},
    {-2200, -6800, {}},
    {-2180, -6800, {}},
    {-2160, -6820, {}},
    {-2140, -6820, {}},
    {-2100, -6820, {}},
    {-2100, -6840, {}},
    {-2080, -6860, {}},
    {-2060, -6860, {}},
    {-2040, -6880, {}},
    {-2020, -6880, {}},
    {-2000, -6860, {}},
    {-1980, -6860, {}},
    {-1960, -6860, {}},
    {-1940, -6840, {}},
    {-1920, -6860, {}},
    {-1900, -6880, {}},
    {-1880, -6900, {}},
    {-1860, -6900, {}},
    {-1840, -6900, {}},
    {-1820, -6920, {}},
    {-1800, -6920, {}},
    {-1780, -6940, {}},
    {-1740, -6940, {}},
    {-1760, -6960, {}},
    {-1760, -6980, {}},
    {-1780, -6980, {}},
    {-1800, -6980, {}},
    {-1820, -7000, {}},
    {-1840, -7020, {}},
    {-1920, -7110, {}},
    {-2000, -7200, {}},
    {-2000, -7300, {}},
    {-2000, -7400, {}},
    {-2000, -7500, {}},
    {-2000, -7600, {}},
    {-2000, -7700, {}},
    {-2000, -7800, {}},
    {-2000, -7900, {}},
    {-2000, -8000, {}},
    {-2000, -8100, {}},
    {-2000, -8200, {}},
    {-2000, -8300, {}},
    {-2000, -8400, {}},
    {-2000, -8500, {}},
    {-2000, -8600, {}},
    {-2000, -8700, {}},
    {-2000, -8800, {}},
    {-2000, -8900, {}},
    {-2000, -9000, {}},
    {-2000, -9100, {}},
    {-2000, -9200, {}},
    {-2000, -9300, {}},
    {-2000, -9400, {}},
    {-2000, -9500, {}},
    {-2000, -9600, {}},
    {-2000, -9700, {}},
    {-2000, -9800, {}},
    {-2000, -9900, {}},
    {-2000, -10000, {}},
    {-2000, -10100, {}},
    {-2000, -10200, {}},
    {-2000, -10300, {}},
    {-2000, -10400, {}},
    {-2000, -10500, {}},
    {-2000, -10600, {}},
    {-2000, -10700, {}},
    {-2000, -10800, {}},
    {-2000, -10900, {}},
    {-2000, -11000, {}},
    {-2000, -11100, {}},
    {-2000, -11200, {}},
    {-2000, -11300, {}},
    {-2000, -11400, {}},
    {-2000, -11500, {}},
    {-2000, -11600, {}},
    {-2000, -11700, {}},
    {-2000, -11800, {}},
    {-2000, -11900, {}},
    {-2000, -12000, {}},
};

static ZoneVertex cqz13[] = {
    {-9000, -7000, {}},
    {-8900, -7000, {}},
    {-8800, -7000, {}},
    {-8700, -7000, {}},
    {-8600, -7000, {}},
    {-8500, -7000, {}},
    {-8400, -7000, {}},
    {-8300, -7000, {}},
    {-8200, -7000, {}},
    {-8100, -7000, {}},
    {-8000, -7000, {}},
    {-7900, -7000, {}},
    {-7800, -7000, {}},
    {-7700, -7000, {}},
    {-7600, -7000, {}},
    {-7500, -7000, {}},
    {-7400, -7000, {}},
    {-7300, -7000, {}},
    {-7200, -7000, {}},
    {-7100, -7000, {}},
    {-7000, -7000, {}},
    {-6900, -7000, {}},
    {-6800, -7000, {}},
    {-6700, -7000, {}},
    {-6600, -7000, {}},
    {-6500, -7000, {}},
    {-6400, -7000, {}},
    {-6300, -7000, {}},
    {-6200, -7000, {}},
    {-6100, -7000, {}},
    {-6000, -7000, {}},
    {-5900, -7000, {}},
    {-5800, -7000, {}},
    {-5700, -7000, {}},
    {-5675, -6900, {}},
    {-5650, -6800, {}},
    {-5625, -6700, {}},
    {-5600, -6600, {}},
    {-5520, -6600, {}},
    {-5520, -6640, {}},
    {-5520, -6660, {}},
    {-5500, -6680, {}},
    {-5500, -6700, {}},
    {-5500, -6720, {}},
    {-5500, -6740, {}},
    {-5500, -6760, {}},
    {-5480, -6800, {}},
    {-5480, -6820, {}},
    {-5500, -6860, {}},
    {-5420, -6860, {}},
    {-5340, -6860, {}},
    {-5260, -6860, {}},
    {-5240, -6840, {}},
    {-5220, -6880, {}},
    {-5220, -6900, {}},
    {-5220, -6940, {}},
    {-5200, -7000, {}},
    {-5200, -7100, {}},
    {-5200, -7200, {}},
    {-5180, -7200, {}},
    {-5180, -7220, {}},
    {-5160, -7240, {}},
    {-5140, -7240, {}},
    {-5120, -7240, {}},
    {-5100, -7220, {}},
    {-5080, -7220, {}},
    {-5060, -7240, {}},
    {-5060, -7260, {}},
    {-5060, -7280, {}},
    {-5080, -7300, {}},
    {-5080, -7320, {}},
    {-5060, -7320, {}},
    {-5040, -7340, {}},
    {-5020, -7340, {}},
    {-5000, -7340, {}},
    {-4920, -7320, {}},
    {-4900, -7300, {}},
    {-4900, -7280, {}},
    {-4880, -7260, {}},
    {-4860, -7260, {}},
    {-4840, -7240, {}},
    {-4820, -7240, {}},
    {-4800, -7240, {}},
    {-4780, -7240, {}},
    {-4760, -7240, {}},
    {-4740, -7220, {}},
    {-4720, -7200, {}},
    {-4700, -7180, {}},
    {-4680, -7200, {}},
    {-4680, -7180, {}},
    {-4660, -7160, {}},
    {-4640, -7180, {}},
    {-4620, -7180, {}},
    {-4600, -7160, {}},
    {-4580, -7180, {}},
    {-4560, -7180, {}},
    {-4560, -7160, {}},
    {-4540, -7160, {}},
    {-4540, -7140, {}},
    {-4520, -7140, {}},
    {-4500, -7160, {}},
    {-4500, -7180, {}},
    {-4480, -7200, {}},
    {-4480, -7180, {}},
    {-4480, -7160, {}},
    {-4480, -7140, {}},
    {-4460, -7120, {}},
    {-4440, -7140, {}},
    {-4440, -7160, {}},
    {-4440, -7180, {}},
    {-4420, -7180, {}},
    {-4400, -7160, {}},
    {-4380, -7180, {}},
    {-4360, -7160, {}},
    {-4360, -7180, {}},
    {-4340, -7200, {}},
    {-4320, -7180, {}},
    {-4300, -7200, {}},
    {-4280, -7220, {}},
    {-4260, -7200, {}},
    {-4240, -7200, {}},
    {-4220, -7220, {}},
    {-4220, -7200, {}},
    {-4220, -7180, {}},
    {-4200, -7180, {}},
    {-4180, -7180, {}},
    {-4160, -7180, {}},
    {-4140, -7180, {}},
    {-4120, -7180, {}},
    {-4100, -7180, {}},
    {-4080, -7200, {}},
    {-4060, -7180, {}},
    {-4040, -7160, {}},
    {-4020, -7180, {}},
    {-4000, -7160, {}},
    {-3980, -7160, {}},
    {-3960, -7160, {}},
    {-3940, -7140, {}},
    {-3920, -7140, {}},
    {-3900, -7140, {}},
    {-3880, -7120, {}},
    {-3880, -7100, {}},
    {-3860, -7080, {}},
    {-3840, -7100, {}},
    {-3820, -7100, {}},
    {-3800, -7100, {}},
    {-3780, -7120, {}},
    {-3760, -7120, {}},
    {-3740, -7120, {}},
    {-3720, -7120, {}},
    {-3700, -7120, {}},
    {-3680, -7120, {}},
    {-3660, -7100, {}},
    {-3640, -7080, {}},
    {-3620, -7060, {}},
    {-3600, -7040, {}},
    {-3580, -7040, {}},
    {-3560, -7040, {}},
    {-3540, -7040, {}},
    {-3520, -7060, {}},
    {-3520, -7040, {}},
    {-3500, -7040, {}},
    {-3480, -7020, {}},
    {-3460, -7020, {}},
    {-3440, -7000, {}},
    {-3420, -6980, {}},
    {-3400, -6980, {}},
    {-3380, -6980, {}},
    {-3360, -6980, {}},
    {-3340, -6980, {}},
    {-3340, -7000, {}},
    {-3320, -7000, {}},
    {-3300, -7000, {}},
    {-3280, -7020, {}},
    {-3260, -7020, {}},
    {-3240, -7020, {}},
    {-3220, -7040, {}},
    {-3200, -7020, {}},
    {-3180, -7040, {}},
    {-3160, -7060, {}},
    {-3140, -7060, {}},
    {-3120, -7060, {}},
    {-3120, -7040, {}},
    {-3100, -7020, {}},
    {-3080, -7020, {}},
    {-3060, -7020, {}},
    {-3040, -7020, {}},
    {-3040, -7000, {}},
    {-3020, -6980, {}},
    {-3000, -7000, {}},
    {-2980, -7000, {}},
    {-2960, -7000, {}},
    {-2940, -7000, {}},
    {-2920, -7000, {}},
    {-2920, -6980, {}},
    {-2900, -6980, {}},
    {-2880, -6980, {}},
    {-2860, -6960, {}},
    {-2840, -6960, {}},
    {-2820, -6940, {}},
    {-2800, -6920, {}},
    {-2780, -6900, {}},
    {-2760, -6900, {}},
    {-2740, -6900, {}},
    {-2720, -6880, {}},
    {-2720, -6860, {}},
    {-2700, -6840, {}},
    {-2680, -6840, {}},
    {-2640, -6860, {}},
    {-2620, -6840, {}},
    {-2580, -6840, {}},
    {-2560, -6860, {}},
    {-2540, -6860, {}},
    {-2520, -6860, {}},
    {-2520, -6840, {}},
    {-2500, -6840, {}},
    {-2480, -6860, {}},
    {-2460, -6840, {}},
    {-2440, -6820, {}},
    {-2400, -6740, {}},
    {-2300, -6700, {}},
    {-2280, -6720, {}},
    {-2260, -6700, {}},
    {-2240, -6680, {}},
    {-2220, -6660, {}},
    {-2220, -6640, {}},
    {-2200, -6620, {}},
    {-2180, -6620, {}},
    {-2200, -6600, {}},
    {-2200, -6580, {}},
    {-2200, -6560, {}},
    {-2200, -6500, {}},
    {-2220, -6480, {}},
    {-2220, -6460, {}},
    {-2240, -6460, {}},
    {-2260, -6440, {}},
    {-2280, -6440, {}},
    {-2260, -6420, {}},
    {-2240, -6420, {}},
    {-2220, -6400, {}},
    {-2200, -6400, {}},
    {-2200, -6380, {}},
    {-2200, -6280, {}},
    {-2220, -6280, {}},
    {-2240, -6260, {}},
    {-2240, -6240, {}},
    {-2260, -6220, {}},
    {-2280, -6220, {}},
    {-2300, -6200, {}},
    {-2320, -6180, {}},
    {-2320, -6160, {}},
    {-2340, -6160, {}},
    {-2340, -6140, {}},
    {-2360, -6120, {}},
    {-2380, -6100, {}},
    {-2380, -6080, {}},
    {-2400, -6060, {}},
    {-2400, -6040, {}},
    {-2400, -6020, {}},
    {-2440, -5940, {}},
    {-2460, -5920, {}},
    {-2460, -5900, {}},
    {-2480, -5880, {}},
    {-2480, -5860, {}},
    {-2500, -5840, {}},
    {-2500, -5820, {}},
    {-2500, -5800, {}},
    {-2520, -5780, {}},
    {-2540, -5760, {}},
    {-2560, -5760, {}},
    {-2580, -5780, {}},
    {-2600, -5780, {}},
    {-2620, -5800, {}},
    {-2640, -5820, {}},
    {-2660, -5820, {}},
    {-2680, -5840, {}},
    {-2700, -5840, {}},
    {-2720, -5860, {}},
    {-2720, -5840, {}},
    {-2720, -5820, {}},
    {-2720, -5800, {}},
    {-2740, -5780, {}},
    {-2740, -5760, {}},
    {-2740, -5740, {}},
    {-2740, -5720, {}},
    {-2740, -5700, {}},
    {-2740, -5680, {}},
    {-2740, -5660, {}},
    {-2760, -5640, {}},
    {-2740, -5620, {}},
    {-2740, -5600, {}},
    {-2740, -5580, {}},
    {-2740, -5560, {}},
    {-2720, -5560, {}},
    {-2700, -5540, {}},
    {-2700, -5520, {}},
    {-2680, -5500, {}},
    {-2660, -5480, {}},
    {-2640, -5460, {}},
    {-2620, -5460, {}},
    {-2600, -5460, {}},
    {-2580, -5460, {}},
    {-2560, -5460, {}},
    {-2560, -5440, {}},
    {-2560, -5420, {}},
    {-2560, -5400, {}},
    {-2580, -5380, {}},
    {-2600, -5380, {}},
    {-2620, -5360, {}},
    {-2640, -5360, {}},
    {-2660, -5380, {}},
    {-2680, -5360, {}},
    {-2700, -5380, {}},
    {-2720, -5400, {}},
    {-2740, -5420, {}},
    {-2740, -5440, {}},
    {-2760, -5460, {}},
    {-2760, -5480, {}},
    {-2780, -5500, {}},
    {-2780, -5520, {}},
    {-2800, -5540, {}},
    {-2820, -5560, {}},
    {-2840, -5560, {}},
    {-2840, -5580, {}},
    {-2860, -5600, {}},
    {-2880, -5620, {}},
    {-2900, -5640, {}},
    {-2920, -5660, {}},
    {-2940, -5680, {}},
    {-2960, -5700, {}},
    {-2980, -5720, {}},
    {-3000, -5740, {}},
    {-3020, -5760, {}},
    {-3040, -5740, {}},
    {-3020, -5720, {}},
    {-3000, -5700, {}},
    {-3020, -5680, {}},
    {-3020, -5660, {}},
    {-3040, -5640, {}},
    {-3060, -5620, {}},
    {-3080, -5600, {}},
    {-3100, -5600, {}},
    {-3100, -5580, {}},
    {-3080, -5560, {}},
    {-3100, -5540, {}},
    {-3120, -5520, {}},
    {-3120, -5500, {}},
    {-3140, -5480, {}},
    {-3140, -5460, {}},
    {-3160, -5440, {}},
    {-3180, -5420, {}},
    {-3200, -5400, {}},
    {-3200, -5380, {}},
    {-3220, -5380, {}},
    {-3240, -5360, {}},
    {-3260, -5340, {}},
    {-3260, -5320, {}},
    {-3300, -5340, {}},
    {-3340, -5360, {}},
    {-3360, -5360, {}},
    {-3380, -5340, {}},
    {-3400, -5300, {}},
    {-3400, -5200, {}},
    {-3400, -5100, {}},
    {-3400, -5000, {}},
    {-3400, -4900, {}},
    {-3400, -4800, {}},
    {-3400, -4700, {}},
    {-3400, -4600, {}},
    {-3400, -4500, {}},
    {-3400, -4400, {}},
    {-3400, -4300, {}},
    {-3400, -4200, {}},
    {-3400, -4100, {}},
    {-3400, -4000, {}},
    {-3400, -3900, {}},
    {-3400, -3800, {}},
    {-3400, -3700, {}},
    {-3400, -3600, {}},
    {-3400, -3500, {}},
    {-3400, -3400, {}},
    {-3400, -3300, {}},
    {-3400, -3200, {}},
    {-3400, -3100, {}},
    {-3400, -3000, {}},
    {-3400, -2900, {}},
    {-3400, -2800, {}},
    {-3400, -2700, {}},
    {-3400, -2600, {}},
    {-3500, -2600, {}},
    {-3600, -2600, {}},
    {-3700, -2600, {}},
    {-3800, -2600, {}},
    {-3900, -2600, {}},
    {-4000, -2600, {}},
    {-4100, -2600, {}},
    {-4200, -2600, {}},
    {-4300, -2600, {}},
    {-4400, -2600, {}},
    {-4500, -2600, {}},
    {-4600, -2600, {}},
    {-4700, -2600, {}},
    {-4800, -2600, {}},
    {-4900, -2600, {}},
    {-5000, -2600, {}},
    {-5100, -2600, {}},
    {-5200, -2600, {}},
    {-5300, -2600, {}},
    {-5400, -2600, {}},
    {-5500, -2600, {}},
    {-5600, -2600, {}},
    {-5700, -2600, {}},
    {-5800, -2600, {}},
    {-5900, -2600, {}},
    {-6000, -2600, {}},
    {-6100, -2600, {}},
    {-6200, -2600, {}},
    {-6300, -2600, {}},
    {-6400, -2600, {}},
    {-6500, -2600, {}},
    {-6600, -2600, {}},
    {-6700, -2600, {}},
    {-6800, -2600, {}},
    {-6900, -2600, {}},
    {-7000, -2600, {}},
    {-7100, -2600, {}},
    {-7200, -2600, {}},
    {-7300, -2600, {}},
    {-7400, -2600, {}},
    {-7500, -2600, {}},
    {-7600, -2600, {}},
    {-7700, -2600, {}},
    {-7800, -2600, {}},
    {-7900, -2600, {}},
    {-8000, -2600, {}},
    {-8100, -2600, {}},
    {-8200, -2600, {}},
    {-8300, -2600, {}},
    {-8400, -2600, {}},
    {-8500, -2600, {}},
    {-8600, -2600, {}},
    {-8700, -2600, {}},
    {-8800, -2600, {}},
    {-8900, -2600, {}},
    {-9000, -2600, {}},
    {-9000, -2700, {}},
    {-9000, -2800, {}},
    {-9000, -2900, {}},
    {-9000, -3000, {}},
    {-9000, -3100, {}},
    {-9000, -3200, {}},
    {-9000, -3300, {}},
    {-9000, -3400, {}},
    {-9000, -3500, {}},
    {-9000, -3600, {}},
    {-9000, -3700, {}},
    {-9000, -3800, {}},
    {-9000, -3900, {}},
    {-9000, -4000, {}},
    {-9000, -4100, {}},
    {-9000, -4200, {}},
    {-9000, -4300, {}},
    {-9000, -4400, {}},
    {-9000, -4500, {}},
    {-9000, -4600, {}},
    {-9000, -4700, {}},
    {-9000, -4800, {}},
    {-9000, -4900, {}},
    {-9000, -5000, {}},
    {-9000, -5100, {}},
    {-9000, -5200, {}},
    {-9000, -5300, {}},
    {-9000, -5400, {}},
    {-9000, -5500, {}},
    {-9000, -5600, {}},
    {-9000, -5700, {}},
    {-9000, -5800, {}},
    {-9000, -5900, {}},
    {-9000, -6000, {}},
    {-9000, -6100, {}},
    {-9000, -6200, {}},
    {-9000, -6300, {}},
    {-9000, -6400, {}},
    {-9000, -6500, {}},
    {-9000, -6600, {}},
    {-9000, -6700, {}},
    {-9000, -6800, {}},
    {-9000, -6900, {}},
    {-9000, -7000, {}},
};

static ZoneVertex cqz14[] = {
    { 3600, -3500, {}},
    { 3699, -3500, {}},
    { 3798, -3500, {}},
    { 3897, -3500, {}},
    { 3996, -3500, {}},
    { 4095, -3500, {}},
    { 4194, -3500, {}},
    { 4293, -3500, {}},
    { 4392, -3500, {}},
    { 4491, -3500, {}},
    { 4590, -3500, {}},
    { 4690, -3500, {}},
    { 4789, -3500, {}},
    { 4888, -3500, {}},
    { 4987, -3500, {}},
    { 5086, -3500, {}},
    { 5185, -3500, {}},
    { 5284, -3500, {}},
    { 5383, -3500, {}},
    { 5482, -3500, {}},
    { 5581, -3500, {}},
    { 5680, -3500, {}},
    { 5705, -3400, {}},
    { 5730, -3300, {}},
    { 5755, -3200, {}},
    { 5780, -3100, {}},
    { 5805, -3000, {}},
    { 5830, -2900, {}},
    { 5855, -2800, {}},
    { 5880, -2700, {}},
    { 5905, -2600, {}},
    { 5930, -2500, {}},
    { 5955, -2400, {}},
    { 5980, -2300, {}},
    { 6005, -2200, {}},
    { 6030, -2100, {}},
    { 6055, -2000, {}},
    { 6080, -1900, {}},
    { 6105, -1800, {}},
    { 6130, -1700, {}},
    { 6155, -1600, {}},
    { 6180, -1500, {}},
    { 6209, -1403, {}},
    { 6237, -1305, {}},
    { 6266, -1208, {}},
    { 6295, -1110, {}},
    { 6323, -1013, {}},
    { 6352,  -916, {}},
    { 6381,  -818, {}},
    { 6410,  -721, {}},
    { 6438,  -623, {}},
    { 6467,  -526, {}},
    { 6496,  -429, {}},
    { 6524,  -331, {}},
    { 6553,  -234, {}},
    { 6582,  -137, {}},
    { 6610,   -39, {}},
    { 6639,    58, {}},
    { 6668,   156, {}},
    { 6697,   253, {}},
    { 6725,   350, {}},
    { 6754,   448, {}},
    { 6783,   545, {}},
    { 6811,   643, {}},
    { 6840,   740, {}},
    { 6862,   838, {}},
    { 6885,   937, {}},
    { 6907,  1035, {}},
    { 6930,  1134, {}},
    { 6952,  1232, {}},
    { 6974,  1330, {}},
    { 6997,  1429, {}},
    { 7019,  1527, {}},
    { 7042,  1626, {}},
    { 7064,  1724, {}},
    { 7086,  1822, {}},
    { 7109,  1921, {}},
    { 7131,  2019, {}},
    { 7154,  2118, {}},
    { 7176,  2216, {}},
    { 7198,  2314, {}},
    { 7221,  2413, {}},
    { 7243,  2511, {}},
    { 7266,  2610, {}},
    { 7288,  2708, {}},
    { 7310,  2806, {}},
    { 7333,  2905, {}},
    { 7355,  3003, {}},
    { 7378,  3102, {}},
    { 7400,  3200, {}},
    { 7300,  3200, {}},
    { 7200,  3200, {}},
    { 7100,  3200, {}},
    { 7040,  3140, {}},
    { 6980,  3080, {}},
    { 6960,  3100, {}},
    { 6960,  3080, {}},
    { 6960,  3060, {}},
    { 6960,  3040, {}},
    { 6960,  3020, {}},
    { 6940,  3000, {}},
    { 6940,  2980, {}},
    { 6940,  2960, {}},
    { 6940,  2940, {}},
    { 6920,  2920, {}},
    { 6900,  2900, {}},
    { 6920,  2880, {}},
    { 6940,  2920, {}},
    { 6960,  2920, {}},
    { 6980,  2900, {}},
    { 6980,  2880, {}},
    { 6980,  2840, {}},
    { 7000,  2820, {}},
    { 7000,  2800, {}},
    { 7000,  2780, {}},
    { 7000,  2760, {}},
    { 7000,  2740, {}},
    { 7000,  2720, {}},
    { 7000,  2700, {}},
    { 7000,  2680, {}},
    { 7000,  2660, {}},
    { 6980,  2640, {}},
    { 6980,  2620, {}},
    { 6980,  2600, {}},
    { 6960,  2600, {}},
    { 6940,  2580, {}},
    { 6920,  2560, {}},
    { 6900,  2580, {}},
    { 6880,  2560, {}},
    { 6880,  2540, {}},
    { 6880,  2520, {}},
    { 6860,  2500, {}},
    { 6860,  2480, {}},
    { 6860,  2440, {}},
    { 6880,  2420, {}},
    { 6880,  2400, {}},
    { 6880,  2380, {}},
    { 6860,  2340, {}},
    { 6860,  2320, {}},
    { 6860,  2280, {}},
    { 6880,  2260, {}},
    { 6880,  2240, {}},
    { 6900,  2220, {}},
    { 6900,  2200, {}},
    { 6920,  2180, {}},
    { 6940,  2120, {}},
    { 6920,  2100, {}},
    { 6920,  2080, {}},
    { 6900,  2060, {}},
    { 6900,  2100, {}},
    { 6880,  2120, {}},
    { 6880,  2140, {}},
    { 6860,  2160, {}},
    { 6860,  2180, {}},
    { 6860,  2200, {}},
    { 6840,  2220, {}},
    { 6840,  2240, {}},
    { 6840,  2260, {}},
    { 6840,  2280, {}},
    { 6840,  2300, {}},
    { 6820,  2320, {}},
    { 6800,  2340, {}},
    { 6800,  2360, {}},
    { 6780,  2340, {}},
    { 6760,  2360, {}},
    { 6740,  2340, {}},
    { 6740,  2360, {}},
    { 6720,  2360, {}},
    { 6700,  2380, {}},
    { 6680,  2400, {}},
    { 6660,  2380, {}},
    { 6640,  2360, {}},
    { 6620,  2380, {}},
    { 6600,  2400, {}},
    { 6580,  2420, {}},
    { 6560,  2420, {}},
    { 6505,  2335, {}},
    { 6450,  2250, {}},
    { 6395,  2165, {}},
    { 6340,  2080, {}},
    { 6240,  2027, {}},
    { 6140,  1973, {}},
    { 6040,  1920, {}},
    { 5947,  1947, {}},
    { 5853,  1973, {}},
    { 5760,  2000, {}},
    { 5700,  1903, {}},
    { 5640,  1807, {}},
    { 5580,  1710, {}},
    { 5520,  1613, {}},
    { 5460,  1517, {}},
    { 5400,  1420, {}},
    { 5380,  1420, {}},
    { 5360,  1440, {}},
    { 5340,  1440, {}},
    { 5320,  1440, {}},
    { 5300,  1420, {}},
    { 5280,  1420, {}},
    { 5280,  1440, {}},
    { 5260,  1460, {}},
    { 5240,  1460, {}},
    { 5220,  1460, {}},
    { 5200,  1480, {}},
    { 5180,  1460, {}},
    { 5160,  1480, {}},
    { 5140,  1500, {}},
    { 5120,  1500, {}},
    { 5100,  1500, {}},
    { 5080,  1480, {}},
    { 5100,  1460, {}},
    { 5100,  1440, {}},
    { 5080,  1420, {}},
    { 5080,  1400, {}},
    { 5080,  1380, {}},
    { 5080,  1360, {}},
    { 5060,  1340, {}},
    { 5060,  1320, {}},
    { 5040,  1300, {}},
    { 5040,  1280, {}},
    { 5040,  1260, {}},
    { 5040,  1240, {}},
    { 5020,  1240, {}},
    { 5020,  1220, {}},
    { 5000,  1240, {}},
    { 4980,  1240, {}},
    { 4960,  1260, {}},
    { 4940,  1280, {}},
    { 4940,  1300, {}},
    { 4920,  1320, {}},
    { 4900,  1340, {}},
    { 4900,  1360, {}},
    { 4880,  1380, {}},
    { 4860,  1380, {}},
    { 4860,  1360, {}},
    { 4840,  1340, {}},
    { 4820,  1320, {}},
    { 4820,  1300, {}},
    { 4820,  1280, {}},
    { 4800,  1280, {}},
    { 4780,  1300, {}},
    { 4760,  1300, {}},
    { 4760,  1280, {}},
    { 4760,  1260, {}},
    { 4760,  1240, {}},
    { 4780,  1220, {}},
    { 4760,  1200, {}},
    { 4760,  1180, {}},
    { 4760,  1160, {}},
    { 4740,  1140, {}},
    { 4740,  1120, {}},
    { 4740,  1100, {}},
    { 4760,  1080, {}},
    { 4760,  1060, {}},
    { 4740,  1040, {}},
    { 4720,  1020, {}},
    { 4740,  1000, {}},
    { 4760,   980, {}},
    { 4760,   960, {}},
    { 4740,   960, {}},
    { 4720,   960, {}},
    { 4700,   980, {}},
    { 4700,  1000, {}},
    { 4680,  1020, {}},
    { 4700,  1040, {}},
    { 4680,  1040, {}},
    { 4660,  1040, {}},
    { 4660,  1020, {}},
    { 4640,  1020, {}},
    { 4620,  1000, {}},
    { 4640,   980, {}},
    { 4620,   960, {}},
    { 4640,   940, {}},
    { 4620,   920, {}},
    { 4600,   900, {}},
    { 4600,   880, {}},
    { 4620,   860, {}},
    { 4640,   840, {}},
    { 4620,   820, {}},
    { 4600,   800, {}},
    { 4600,   780, {}},
    { 4600,   760, {}},
    { 4580,   740, {}},
    { 4580,   720, {}},
    { 4580,   700, {}},
    { 4560,   700, {}},
    { 4540,   720, {}},
    { 4520,   700, {}},
    { 4520,   680, {}},
    { 4500,   680, {}},
    { 4480,   700, {}},
    { 4460,   700, {}},
    { 4440,   680, {}},
    { 4420,   700, {}},
    { 4420,   720, {}},
    { 4420,   740, {}},
    { 4420,   760, {}},
    { 4400,   760, {}},
    { 4380,   760, {}},
    { 4300,   700, {}},
    { 4212,   700, {}},
    { 4124,   700, {}},
    { 4036,   700, {}},
    { 3948,   700, {}},
    { 3860,   700, {}},
    { 3838,   600, {}},
    { 3817,   500, {}},
    { 3795,   400, {}},
    { 3773,   300, {}},
    { 3752,   200, {}},
    { 3730,   100, {}},
    { 3708,     0, {}},
    { 3687,  -100, {}},
    { 3665,  -200, {}},
    { 3643,  -300, {}},
    { 3622,  -400, {}},
    { 3600,  -500, {}},
    { 3600,  -560, {}},
    { 3600,  -600, {}},
    { 3600,  -700, {}},
    { 3600,  -800, {}},
    { 3600,  -900, {}},
    { 3600, -1000, {}},
    { 3600, -1100, {}},
    { 3600, -1200, {}},
    { 3600, -1300, {}},
    { 3600, -1400, {}},
    { 3600, -1500, {}},
    { 3600, -1600, {}},
    { 3600, -1700, {}},
    { 3600, -1800, {}},
    { 3600, -1900, {}},
    { 3600, -2000, {}},
    { 3600, -2100, {}},
    { 3600, -2200, {}},
    { 3600, -2300, {}},
    { 3600, -2400, {}},
    { 3600, -2500, {}},
    { 3600, -2600, {}},
    { 3600, -2700, {}},
    { 3600, -2800, {}},
    { 3600, -2900, {}},
    { 3600, -3000, {}},
    { 3600, -3100, {}},
    { 3600, -3200, {}},
    { 3600, -3300, {}},
    { 3600, -3400, {}},
    { 3600, -3500, {}},
};

static ZoneVertex cqz15[] = {
    { 6905,  2893, {}},
    { 6940,  2920, {}},
    { 6960,  2920, {}},
    { 6980,  2900, {}},
    { 6980,  2880, {}},
    { 6980,  2840, {}},
    { 7000,  2820, {}},
    { 7000,  2800, {}},
    { 7000,  2780, {}},
    { 7000,  2760, {}},
    { 7000,  2740, {}},
    { 7000,  2720, {}},
    { 7000,  2700, {}},
    { 7000,  2680, {}},
    { 7000,  2660, {}},
    { 6980,  2640, {}},
    { 6980,  2620, {}},
    { 6980,  2600, {}},
    { 6960,  2600, {}},
    { 6940,  2580, {}},
    { 6920,  2560, {}},
    { 6900,  2580, {}},
    { 6880,  2560, {}},
    { 6880,  2540, {}},
    { 6880,  2520, {}},
    { 6860,  2500, {}},
    { 6860,  2480, {}},
    { 6860,  2440, {}},
    { 6880,  2420, {}},
    { 6880,  2400, {}},
    { 6880,  2380, {}},
    { 6860,  2340, {}},
    { 6860,  2320, {}},
    { 6860,  2280, {}},
    { 6880,  2260, {}},
    { 6880,  2240, {}},
    { 6900,  2220, {}},
    { 6900,  2200, {}},
    { 6920,  2180, {}},
    { 6940,  2120, {}},
    { 6920,  2100, {}},
    { 6920,  2080, {}},
    { 6900,  2060, {}},
    { 6900,  2100, {}},
    { 6880,  2120, {}},
    { 6880,  2140, {}},
    { 6860,  2160, {}},
    { 6860,  2180, {}},
    { 6860,  2200, {}},
    { 6840,  2220, {}},
    { 6840,  2240, {}},
    { 6840,  2260, {}},
    { 6840,  2280, {}},
    { 6840,  2300, {}},
    { 6820,  2320, {}},
    { 6800,  2340, {}},
    { 6800,  2360, {}},
    { 6780,  2340, {}},
    { 6760,  2360, {}},
    { 6740,  2340, {}},
    { 6740,  2360, {}},
    { 6720,  2360, {}},
    { 6700,  2380, {}},
    { 6680,  2400, {}},
    { 6660,  2380, {}},
    { 6640,  2360, {}},
    { 6620,  2380, {}},
    { 6600,  2400, {}},
    { 6580,  2420, {}},
    { 6560,  2420, {}},
    { 6505,  2335, {}},
    { 6450,  2250, {}},
    { 6395,  2165, {}},
    { 6340,  2080, {}},
    { 6240,  2027, {}},
    { 6140,  1973, {}},
    { 6040,  1920, {}},
    { 5947,  1947, {}},
    { 5853,  1973, {}},
    { 5760,  2000, {}},
    { 5700,  1903, {}},
    { 5640,  1807, {}},
    { 5580,  1710, {}},
    { 5520,  1613, {}},
    { 5460,  1517, {}},
    { 5400,  1420, {}},
    { 5380,  1420, {}},
    { 5360,  1440, {}},
    { 5340,  1440, {}},
    { 5320,  1440, {}},
    { 5300,  1420, {}},
    { 5280,  1420, {}},
    { 5280,  1440, {}},
    { 5260,  1460, {}},
    { 5240,  1460, {}},
    { 5220,  1460, {}},
    { 5200,  1480, {}},
    { 5180,  1460, {}},
    { 5160,  1480, {}},
    { 5140,  1500, {}},
    { 5120,  1500, {}},
    { 5100,  1500, {}},
    { 5080,  1480, {}},
    { 5100,  1460, {}},
    { 5100,  1440, {}},
    { 5080,  1420, {}},
    { 5080,  1400, {}},
    { 5080,  1380, {}},
    { 5080,  1360, {}},
    { 5060,  1340, {}},
    { 5060,  1320, {}},
    { 5040,  1300, {}},
    { 5040,  1280, {}},
    { 5040,  1260, {}},
    { 5040,  1240, {}},
    { 5020,  1240, {}},
    { 5020,  1220, {}},
    { 5000,  1240, {}},
    { 4980,  1240, {}},
    { 4960,  1260, {}},
    { 4940,  1280, {}},
    { 4940,  1300, {}},
    { 4920,  1320, {}},
    { 4900,  1340, {}},
    { 4900,  1360, {}},
    { 4880,  1380, {}},
    { 4860,  1380, {}},
    { 4860,  1360, {}},
    { 4840,  1340, {}},
    { 4820,  1320, {}},
    { 4820,  1300, {}},
    { 4820,  1280, {}},
    { 4800,  1280, {}},
    { 4780,  1300, {}},
    { 4760,  1300, {}},
    { 4760,  1280, {}},
    { 4760,  1260, {}},
    { 4760,  1240, {}},
    { 4780,  1220, {}},
    { 4760,  1200, {}},
    { 4760,  1180, {}},
    { 4760,  1160, {}},
    { 4740,  1140, {}},
    { 4740,  1120, {}},
    { 4740,  1100, {}},
    { 4760,  1080, {}},
    { 4760,  1060, {}},
    { 4740,  1040, {}},
    { 4720,  1020, {}},
    { 4740,  1000, {}},
    { 4760,   980, {}},
    { 4760,   960, {}},
    { 4740,   960, {}},
    { 4720,   960, {}},
    { 4700,   980, {}},
    { 4700,  1000, {}},
    { 4680,  1020, {}},
    { 4700,  1040, {}},
    { 4680,  1040, {}},
    { 4660,  1040, {}},
    { 4660,  1020, {}},
    { 4640,  1020, {}},
    { 4620,  1000, {}},
    { 4640,   980, {}},
    { 4620,   960, {}},
    { 4640,   940, {}},
    { 4620,   920, {}},
    { 4600,   900, {}},
    { 4600,   880, {}},
    { 4620,   860, {}},
    { 4640,   840, {}},
    { 4620,   820, {}},
    { 4600,   800, {}},
    { 4600,   780, {}},
    { 4600,   760, {}},
    { 4580,   740, {}},
    { 4580,   720, {}},
    { 4580,   700, {}},
    { 4560,   700, {}},
    { 4540,   720, {}},
    { 4520,   700, {}},
    { 4520,   680, {}},
    { 4500,   680, {}},
    { 4480,   700, {}},
    { 4460,   700, {}},
    { 4440,   680, {}},
    { 4420,   700, {}},
    { 4420,   720, {}},
    { 4420,   740, {}},
    { 4420,   760, {}},
    { 4400,   760, {}},
    { 4380,   760, {}},
    { 4300,   700, {}},
    { 4212,   700, {}},
    { 4124,   700, {}},
    { 4036,   700, {}},
    { 3948,   700, {}},
    { 3860,   700, {}},
    { 3837,   787, {}},
    { 3813,   873, {}},
    { 3790,   960, {}},
    { 3767,  1047, {}},
    { 3743,  1133, {}},
    { 3720,  1220, {}},
    { 3660,  1270, {}},
    { 3600,  1320, {}},
    { 3500,  1400, {}},
    { 3500,  1500, {}},
    { 3500,  1600, {}},
    { 3500,  1700, {}},
    { 3500,  1800, {}},
    { 3500,  1900, {}},
    { 3600,  1900, {}},
    { 3700,  1900, {}},
    { 3800,  1900, {}},
    { 3900,  1900, {}},
    { 4000,  1900, {}},
    { 4000,  1980, {}},
    { 3980,  2000, {}},
    { 3960,  2020, {}},
    { 3980,  2020, {}},
    { 3980,  2040, {}},
    { 4000,  2040, {}},
    { 4000,  2060, {}},
    { 4020,  2080, {}},
    { 4040,  2080, {}},
    { 4060,  2100, {}},
    { 4080,  2100, {}},
    { 4080,  2120, {}},
    { 4100,  2140, {}},
    { 4080,  2160, {}},
    { 4100,  2180, {}},
    { 4120,  2200, {}},
    { 4120,  2220, {}},
    { 4120,  2240, {}},
    { 4120,  2260, {}},
    { 4140,  2280, {}},
    { 4160,  2300, {}},
    { 4180,  2300, {}},
    { 4200,  2280, {}},
    { 4220,  2260, {}},
    { 4220,  2240, {}},
    { 4240,  2260, {}},
    { 4260,  2240, {}},
    { 4280,  2240, {}},
    { 4280,  2260, {}},
    { 4300,  2280, {}},
    { 4320,  2300, {}},
    { 4340,  2280, {}},
    { 4340,  2260, {}},
    { 4360,  2240, {}},
    { 4380,  2240, {}},
    { 4400,  2240, {}},
    { 4400,  2260, {}},
    { 4420,  2260, {}},
    { 4440,  2240, {}},
    { 4460,  2260, {}},
    { 4460,  2240, {}},
    { 4440,  2220, {}},
    { 4460,  2200, {}},
    { 4460,  2180, {}},
    { 4480,  2160, {}},
    { 4480,  2140, {}},
    { 4500,  2140, {}},
    { 4520,  2140, {}},
    { 4520,  2120, {}},
    { 4540,  2100, {}},
    { 4540,  2080, {}},
    { 4560,  2080, {}},
    { 4580,  2060, {}},
    { 4600,  2040, {}},
    { 4620,  2060, {}},
    { 4620,  2080, {}},
    { 4620,  2100, {}},
    { 4640,  2120, {}},
    { 4660,  2140, {}},
    { 4680,  2160, {}},
    { 4700,  2160, {}},
    { 4720,  2180, {}},
    { 4740,  2200, {}},
    { 4760,  2220, {}},
    { 4780,  2240, {}},
    { 4780,  2260, {}},
    { 4800,  2280, {}},
    { 4820,  2260, {}},
    { 4820,  2240, {}},
    { 4840,  2220, {}},
    { 4860,  2220, {}},
    { 4880,  2240, {}},
    { 4900,  2260, {}},
    { 4900,  2280, {}},
    { 4920,  2280, {}},
    { 4940,  2280, {}},
    { 4960,  2280, {}},
    { 4980,  2300, {}},
    { 5000,  2320, {}},
    { 5020,  2340, {}},
    { 5020,  2360, {}},
    { 5040,  2380, {}},
    { 5040,  2400, {}},
    { 5060,  2400, {}},
    { 5080,  2400, {}},
    { 5100,  2400, {}},
    { 5120,  2380, {}},
    { 5140,  2380, {}},
    { 5160,  2360, {}},
    { 5180,  2360, {}},
    { 5200,  2360, {}},
    { 5220,  2340, {}},
    { 5220,  2320, {}},
    { 5240,  2340, {}},
    { 5260,  2360, {}},
    { 5260,  2380, {}},
    { 5280,  2400, {}},
    { 5300,  2400, {}},
    { 5320,  2380, {}},
    { 5340,  2380, {}},
    { 5360,  2360, {}},
    { 5380,  2360, {}},
    { 5400,  2380, {}},
    { 5400,  2420, {}},
    { 5400,  2440, {}},
    { 5400,  2460, {}},
    { 5400,  2480, {}},
    { 5420,  2500, {}},
    { 5420,  2520, {}},
    { 5420,  2540, {}},
    { 5420,  2560, {}},
    { 5440,  2560, {}},
    { 5460,  2580, {}},
    { 5480,  2580, {}},
    { 5500,  2600, {}},
    { 5500,  2620, {}},
    { 5520,  2640, {}},
    { 5520,  2660, {}},
    { 5520,  2680, {}},
    { 5540,  2660, {}},
    { 5560,  2660, {}},
    { 5560,  2680, {}},
    { 5580,  2700, {}},
    { 5580,  2720, {}},
    { 5580,  2740, {}},
    { 5580,  2760, {}},
    { 5600,  2780, {}},
    { 5620,  2800, {}},
    { 5620,  2820, {}},
    { 5640,  2820, {}},
    { 5660,  2800, {}},
    { 5680,  2800, {}},
    { 5680,  2780, {}},
    { 5700,  2780, {}},
    { 5720,  2780, {}},
    { 5740,  2760, {}},
    { 5760,  2740, {}},
    { 5780,  2760, {}},
    { 5780,  2780, {}},
    { 5800,  2760, {}},
    { 5820,  2740, {}},
    { 5880,  2740, {}},
    { 5900,  2780, {}},
    { 5920,  2800, {}},
    { 5940,  2820, {}},
    { 5960,  2760, {}},
    { 5980,  2700, {}},
    { 6000,  2680, {}},
    { 6020,  2760, {}},
    { 6040,  2760, {}},
    { 6060,  2780, {}},
    { 6060,  2800, {}},
    { 6080,  2820, {}},
    { 6080,  2840, {}},
    { 6100,  2860, {}},
    { 6100,  2880, {}},
    { 6120,  2900, {}},
    { 6120,  2920, {}},
    { 6140,  2940, {}},
    { 6160,  2960, {}},
    { 6160,  2980, {}},
    { 6180,  3000, {}},
    { 6180,  3020, {}},
    { 6200,  3040, {}},
    { 6220,  3060, {}},
    { 6220,  3080, {}},
    { 6240,  3100, {}},
    { 6240,  3120, {}},
    { 6260,  3140, {}},
    { 6300,  3160, {}},
    { 6300,  3140, {}},
    { 6320,  3120, {}},
    { 6340,  3100, {}},
    { 6340,  3080, {}},
    { 6340,  3040, {}},
    { 6360,  3020, {}},
    { 6380,  3000, {}},
    { 6380,  3020, {}},
    { 6400,  3040, {}},
    { 6420,  3040, {}},
    { 6440,  3020, {}},
    { 6460,  3000, {}},
    { 6480,  2980, {}},
    { 6500,  2960, {}},
    { 6500,  2980, {}},
    { 6520,  2980, {}},
    { 6540,  2980, {}},
    { 6560,  2980, {}},
    { 6560,  3000, {}},
    { 6580,  3000, {}},
    { 6600,  3000, {}},
    { 6620,  2980, {}},
    { 6640,  2960, {}},
    { 6660,  2940, {}},
    { 6680,  2920, {}},
    { 6700,  2920, {}},
    { 6720,  2960, {}},
    { 6740,  2980, {}},
    { 6760,  3000, {}},
    { 6780,  2960, {}},
    { 6800,  2940, {}},
    { 6820,  2860, {}},
    { 6860,  2840, {}},
    { 6880,  2880, {}},
    { 6880,  2840, {}},
    { 6900,  2900, {}},
};

static ZoneVertex cqz16[] = {
    { 8000,  7000, {}},
    { 7984,  6900, {}},
    { 7968,  6800, {}},
    { 7953,  6700, {}},
    { 7937,  6600, {}},
    { 7921,  6500, {}},
    { 7905,  6400, {}},
    { 7889,  6300, {}},
    { 7874,  6200, {}},
    { 7858,  6100, {}},
    { 7842,  6000, {}},
    { 7826,  5900, {}},
    { 7811,  5800, {}},
    { 7795,  5700, {}},
    { 7779,  5600, {}},
    { 7763,  5500, {}},
    { 7747,  5400, {}},
    { 7732,  5300, {}},
    { 7716,  5200, {}},
    { 7700,  5100, {}},
    { 7684,  5000, {}},
    { 7668,  4900, {}},
    { 7653,  4800, {}},
    { 7637,  4700, {}},
    { 7621,  4600, {}},
    { 7605,  4500, {}},
    { 7589,  4400, {}},
    { 7574,  4300, {}},
    { 7558,  4200, {}},
    { 7542,  4100, {}},
    { 7526,  4000, {}},
    { 7511,  3900, {}},
    { 7495,  3800, {}},
    { 7479,  3700, {}},
    { 7463,  3600, {}},
    { 7447,  3500, {}},
    { 7432,  3400, {}},
    { 7416,  3300, {}},
    { 7400,  3200, {}},
    { 7300,  3200, {}},
    { 7200,  3200, {}},
    { 7100,  3200, {}},
    { 7040,  3140, {}},
    { 6980,  3080, {}},
    { 6960,  3100, {}},
    { 6960,  3080, {}},
    { 6960,  3060, {}},
    { 6960,  3040, {}},
    { 6960,  3020, {}},
    { 6940,  3000, {}},
    { 6940,  2980, {}},
    { 6940,  2960, {}},
    { 6940,  2940, {}},
    { 6920,  2920, {}},
    { 6900,  2900, {}},
    { 6900,  2840, {}},
    { 6880,  2860, {}},
    { 6860,  2840, {}},
    { 6820,  2860, {}},
    { 6800,  2940, {}},
    { 6780,  2960, {}},
    { 6760,  3000, {}},
    { 6740,  2980, {}},
    { 6740,  2960, {}},
    { 6720,  2940, {}},
    { 6700,  2900, {}},
    { 6680,  2920, {}},
    { 6660,  2940, {}},
    { 6640,  2960, {}},
    { 6620,  2980, {}},
    { 6600,  3000, {}},
    { 6580,  3020, {}},
    { 6560,  2980, {}},
    { 6540,  2980, {}},
    { 6520,  2980, {}},
    { 6500,  2960, {}},
    { 6480,  2980, {}},
    { 6480,  3000, {}},
    { 6460,  3000, {}},
    { 6440,  3020, {}},
    { 6420,  3040, {}},
    { 6400,  3040, {}},
    { 6380,  3020, {}},
    { 6380,  3000, {}},
    { 6360,  3020, {}},
    { 6340,  3040, {}},
    { 6340,  3060, {}},
    { 6340,  3080, {}},
    { 6340,  3100, {}},
    { 6320,  3120, {}},
    { 6300,  3140, {}},
    { 6280,  3140, {}},
    { 6260,  3120, {}},
    { 6240,  3100, {}},
    { 6220,  3080, {}},
    { 6220,  3060, {}},
    { 6200,  3040, {}},
    { 6180,  3020, {}},
    { 6180,  3000, {}},
    { 6160,  2980, {}},
    { 6140,  2960, {}},
    { 6140,  2940, {}},
    { 6120,  2920, {}},
    { 6120,  2900, {}},
    { 6100,  2880, {}},
    { 6100,  2860, {}},
    { 6080,  2840, {}},
    { 6080,  2820, {}},
    { 6060,  2800, {}},
    { 6060,  2780, {}},
    { 6040,  2780, {}},
    { 6020,  2760, {}},
    { 6000,  2680, {}},
    { 5980,  2700, {}},
    { 5940,  2800, {}},
    { 5940,  2820, {}},
    { 5920,  2800, {}},
    { 5920,  2780, {}},
    { 5900,  2780, {}},
    { 5880,  2740, {}},
    { 5840,  2760, {}},
    { 5820,  2760, {}},
    { 5800,  2760, {}},
    { 5780,  2780, {}},
    { 5780,  2760, {}},
    { 5760,  2740, {}},
    { 5740,  2760, {}},
    { 5740,  2780, {}},
    { 5720,  2780, {}},
    { 5700,  2780, {}},
    { 5680,  2800, {}},
    { 5660,  2800, {}},
    { 5640,  2820, {}},
    { 5620,  2820, {}},
    { 5620,  2800, {}},
    { 5600,  2780, {}},
    { 5580,  2760, {}},
    { 5580,  2740, {}},
    { 5580,  2720, {}},
    { 5580,  2700, {}},
    { 5560,  2680, {}},
    { 5560,  2660, {}},
    { 5540,  2660, {}},
    { 5540,  2680, {}},
    { 5520,  2660, {}},
    { 5520,  2640, {}},
    { 5500,  2620, {}},
    { 5500,  2600, {}},
    { 5480,  2580, {}},
    { 5460,  2580, {}},
    { 5440,  2560, {}},
    { 5420,  2580, {}},
    { 5420,  2560, {}},
    { 5420,  2540, {}},
    { 5420,  2520, {}},
    { 5420,  2500, {}},
    { 5420,  2480, {}},
    { 5400,  2480, {}},
    { 5400,  2460, {}},
    { 5400,  2440, {}},
    { 5400,  2420, {}},
    { 5400,  2400, {}},
    { 5400,  2380, {}},
    { 5400,  2360, {}},
    { 5380,  2360, {}},
    { 5360,  2360, {}},
    { 5340,  2380, {}},
    { 5320,  2380, {}},
    { 5300,  2400, {}},
    { 5280,  2400, {}},
    { 5260,  2380, {}},
    { 5260,  2360, {}},
    { 5240,  2340, {}},
    { 5220,  2320, {}},
    { 5220,  2340, {}},
    { 5220,  2360, {}},
    { 5200,  2360, {}},
    { 5180,  2360, {}},
    { 5160,  2360, {}},
    { 5140,  2360, {}},
    { 5120,  2380, {}},
    { 5100,  2400, {}},
    { 5080,  2400, {}},
    { 5060,  2400, {}},
    { 5040,  2380, {}},
    { 5020,  2360, {}},
    { 5020,  2340, {}},
    { 5000,  2320, {}},
    { 4980,  2300, {}},
    { 4960,  2280, {}},
    { 4940,  2280, {}},
    { 4920,  2280, {}},
    { 4900,  2260, {}},
    { 4880,  2240, {}},
    { 4860,  2220, {}},
    { 4840,  2220, {}},
    { 4820,  2240, {}},
    { 4820,  2260, {}},
    { 4820,  2280, {}},
    { 4800,  2280, {}},
    { 4800,  2300, {}},
    { 4800,  2320, {}},
    { 4800,  2340, {}},
    { 4800,  2360, {}},
    { 4800,  2380, {}},
    { 4800,  2400, {}},
    { 4800,  2420, {}},
    { 4800,  2440, {}},
    { 4800,  2460, {}},
    { 4780,  2480, {}},
    { 4780,  2500, {}},
    { 4780,  2520, {}},
    { 4800,  2540, {}},
    { 4800,  2560, {}},
    { 4800,  2580, {}},
    { 4800,  2600, {}},
    { 4800,  2620, {}},
    { 4820,  2640, {}},
    { 4820,  2660, {}},
    { 4820,  2680, {}},
    { 4820,  2700, {}},
    { 4800,  2720, {}},
    { 4780,  2720, {}},
    { 4760,  2740, {}},
    { 4740,  2760, {}},
    { 4720,  2780, {}},
    { 4700,  2800, {}},
    { 4680,  2820, {}},
    { 4660,  2820, {}},
    { 4640,  2820, {}},
    { 4620,  2820, {}},
    { 4600,  2820, {}},
    { 4580,  2820, {}},
    { 4560,  2820, {}},
    { 4540,  2820, {}},
    { 4520,  2860, {}},
    { 4540,  2880, {}},
    { 4540,  2900, {}},
    { 4540,  2920, {}},
    { 4540,  2940, {}},
    { 4540,  2960, {}},
    { 4520,  2960, {}},
    { 4490,  3058, {}},
    { 4460,  3156, {}},
    { 4430,  3254, {}},
    { 4400,  3352, {}},
    { 4370,  3450, {}},
    { 4340,  3548, {}},
    { 4310,  3646, {}},
    { 4280,  3744, {}},
    { 4250,  3842, {}},
    { 4220,  3940, {}},
    { 4280,  3970, {}},
    { 4340,  4000, {}},
    { 4360,  4020, {}},
    { 4360,  4040, {}},
    { 4360,  4060, {}},
    { 4340,  4080, {}},
    { 4340,  4100, {}},
    { 4340,  4120, {}},
    { 4340,  4140, {}},
    { 4320,  4160, {}},
    { 4320,  4180, {}},
    { 4320,  4200, {}},
    { 4320,  4220, {}},
    { 4320,  4240, {}},
    { 4320,  4260, {}},
    { 4320,  4280, {}},
    { 4300,  4300, {}},
    { 4300,  4320, {}},
    { 4280,  4340, {}},
    { 4280,  4360, {}},
    { 4280,  4380, {}},
    { 4260,  4380, {}},
    { 4260,  4400, {}},
    { 4260,  4420, {}},
    { 4280,  4440, {}},
    { 4280,  4460, {}},
    { 4260,  4480, {}},
    { 4260,  4500, {}},
    { 4260,  4520, {}},
    { 4260,  4540, {}},
    { 4260,  4560, {}},
    { 4240,  4580, {}},
    { 4220,  4560, {}},
    { 4220,  4580, {}},
    { 4200,  4600, {}},
    { 4200,  4620, {}},
    { 4200,  4640, {}},
    { 4180,  4660, {}},
    { 4180,  4680, {}},
    { 4160,  4700, {}},
    { 4140,  4720, {}},
    { 4120,  4740, {}},
    { 4120,  4760, {}},
    { 4120,  4780, {}},
    { 4140,  4800, {}},
    { 4160,  4820, {}},
    { 4160,  4840, {}},
    { 4180,  4860, {}},
    { 4200,  4900, {}},
    { 4300,  4925, {}},
    { 4400,  4950, {}},
    { 4500,  4975, {}},
    { 4600,  5000, {}},
    { 4620,  4940, {}},
    { 4640,  4920, {}},
    { 4640,  4900, {}},
    { 4660,  4880, {}},
    { 4660,  4860, {}},
    { 4660,  4900, {}},
    { 4680,  4900, {}},
    { 4700,  4880, {}},
    { 4740,  4860, {}},
    { 4760,  4820, {}},
    { 4780,  4800, {}},
    { 4780,  4760, {}},
    { 4760,  4740, {}},
    { 4780,  4720, {}},
    { 4800,  4720, {}},
    { 4820,  4700, {}},
    { 4840,  4680, {}},
    { 4840,  4640, {}},
    { 4860,  4660, {}},
    { 4900,  4680, {}},
    { 4900,  4700, {}},
    { 4920,  4700, {}},
    { 4940,  4680, {}},
    { 4960,  4680, {}},
    { 4980,  4700, {}},
    { 5000,  4740, {}},
    { 5020,  4740, {}},
    { 5040,  4740, {}},
    { 5040,  4760, {}},
    { 5040,  4780, {}},
    { 5020,  4800, {}},
    { 5000,  4820, {}},
    { 4980,  4840, {}},
    { 5000,  4880, {}},
    { 5020,  4880, {}},
    { 5060,  4860, {}},
    { 5060,  4880, {}},
    { 5060,  4900, {}},
    { 5080,  4920, {}},
    { 5080,  4940, {}},
    { 5100,  4940, {}},
    { 5120,  4980, {}},
    { 5120,  5000, {}},
    { 5120,  5020, {}},
    { 5140,  5040, {}},
    { 5160,  5060, {}},
    { 5160,  5080, {}},
    { 5160,  5100, {}},
    { 5160,  5120, {}},
    { 5140,  5140, {}},
    { 5160,  5160, {}},
    { 5140,  5180, {}},
    { 5160,  5180, {}},
    { 5160,  5200, {}},
    { 5180,  5220, {}},
    { 5160,  5240, {}},
    { 5140,  5260, {}},
    { 5160,  5280, {}},
    { 5140,  5300, {}},
    { 5160,  5320, {}},
    { 5140,  5340, {}},
    { 5140,  5360, {}},
    { 5120,  5380, {}},
    { 5120,  5400, {}},
    { 5100,  5420, {}},
    { 5080,  5440, {}},
    { 5060,  5440, {}},
    { 5060,  5460, {}},
    { 5080,  5460, {}},
    { 5100,  5460, {}},
    { 5100,  5480, {}},
    { 5080,  5500, {}},
    { 5060,  5540, {}},
    { 5060,  5560, {}},
    { 5060,  5580, {}},
    { 5060,  5600, {}},
    { 5080,  5620, {}},
    { 5100,  5640, {}},
    { 5100,  5660, {}},
    { 5100,  5680, {}},
    { 5100,  5700, {}},
    { 5100,  5720, {}},
    { 5100,  5740, {}},
    { 5100,  5760, {}},
    { 5120,  5780, {}},
    { 5100,  5800, {}},
    { 5100,  5820, {}},
    { 5100,  5860, {}},
    { 5080,  5880, {}},
    { 5060,  5900, {}},
    { 5060,  5920, {}},
    { 5060,  5940, {}},
    { 5060,  5960, {}},
    { 5060,  5980, {}},
    { 5080,  6000, {}},
    { 5060,  6040, {}},
    { 5060,  6060, {}},
    { 5060,  6080, {}},
    { 5080,  6140, {}},
    { 5100,  6160, {}},
    { 5120,  6160, {}},
    { 5140,  6160, {}},
    { 5140,  6140, {}},
    { 5140,  6120, {}},
    { 5140,  6100, {}},
    { 5160,  6100, {}},
    { 5160,  6080, {}},
    { 5160,  6060, {}},
    { 5160,  6040, {}},
    { 5180,  6040, {}},
    { 5200,  6020, {}},
    { 5200,  6000, {}},
    { 5220,  6000, {}},
    { 5240,  6020, {}},
    { 5240,  6000, {}},
    { 5240,  5980, {}},
    { 5240,  5960, {}},
    { 5240,  5940, {}},
    { 5220,  5920, {}},
    { 5240,  5900, {}},
    { 5240,  5880, {}},
    { 5260,  5880, {}},
    { 5280,  5880, {}},
    { 5300,  5880, {}},
    { 5320,  5880, {}},
    { 5340,  5880, {}},
    { 5360,  5880, {}},
    { 5380,  5900, {}},
    { 5400,  5920, {}},
    { 5420,  5940, {}},
    { 5420,  5960, {}},
    { 5440,  5980, {}},
    { 5460,  5980, {}},
    { 5480,  6000, {}},
    { 5480,  5980, {}},
    { 5480,  5960, {}},
    { 5460,  5940, {}},
    { 5460,  5920, {}},
    { 5460,  5900, {}},
    { 5460,  5880, {}},
    { 5440,  5860, {}},
    { 5460,  5840, {}},
    { 5460,  5820, {}},
    { 5440,  5800, {}},
    { 5460,  5780, {}},
    { 5460,  5760, {}},
    { 5480,  5740, {}},
    { 5480,  5720, {}},
    { 5500,  5720, {}},
    { 5520,  5720, {}},
    { 5540,  5740, {}},
    { 5540,  5760, {}},
    { 5520,  5800, {}},
    { 5500,  5800, {}},
    { 5500,  5820, {}},
    { 5500,  5840, {}},
    { 5500,  5860, {}},
    { 5500,  5880, {}},
    { 5520,  5860, {}},
    { 5520,  5900, {}},
    { 5540,  5920, {}},
    { 5540,  5940, {}},
    { 5560,  5960, {}},
    { 5560,  5940, {}},
    { 5580,  5920, {}},
    { 5600,  5920, {}},
    { 5600,  5900, {}},
    { 5600,  5880, {}},
    { 5620,  5860, {}},
    { 5600,  5840, {}},
    { 5620,  5820, {}},
    { 5620,  5800, {}},
    { 5620,  5780, {}},
    { 5600,  5760, {}},
    { 5620,  5740, {}},
    { 5620,  5720, {}},
    { 5620,  5700, {}},
    { 5620,  5680, {}},
    { 5620,  5660, {}},
    { 5640,  5640, {}},
    { 5640,  5620, {}},
    { 5640,  5600, {}},
    { 5640,  5580, {}},
    { 5640,  5560, {}},
    { 5640,  5540, {}},
    { 5640,  5520, {}},
    { 5640,  5500, {}},
    { 5640,  5480, {}},
    { 5660,  5460, {}},
    { 5640,  5440, {}},
    { 5660,  5420, {}},
    { 5660,  5400, {}},
    { 5680,  5380, {}},
    { 5680,  5400, {}},
    { 5700,  5420, {}},
    { 5700,  5440, {}},
    { 5720,  5440, {}},
    { 5740,  5420, {}},
    { 5760,  5400, {}},
    { 5780,  5420, {}},
    { 5800,  5400, {}},
    { 5820,  5380, {}},
    { 5840,  5380, {}},
    { 5860,  5380, {}},
    { 5880,  5380, {}},
    { 5900,  5380, {}},
    { 5920,  5360, {}},
    { 5920,  5340, {}},
    { 5940,  5340, {}},
    { 5960,  5340, {}},
    { 5960,  5360, {}},
    { 6000,  5360, {}},
    { 6020,  5340, {}},
    { 6020,  5300, {}},
    { 6020,  5240, {}},
    { 6040,  5200, {}},
    { 6020,  5180, {}},
    { 6000,  5160, {}},
    { 6000,  5120, {}},
    { 6000,  5100, {}},
    { 5980,  5080, {}},
    { 5980,  5060, {}},
    { 5980,  5040, {}},
    { 5980,  5000, {}},
    { 5940,  4980, {}},
    { 5920,  4980, {}},
    { 5920,  4960, {}},
    { 5940,  4940, {}},
    { 5960,  4920, {}},
    { 5980,  4860, {}},
    { 6000,  4840, {}},
    { 6020,  4860, {}},
    { 6040,  4860, {}},
    { 6080,  4840, {}},
    { 6100,  4840, {}},
    { 6120,  4900, {}},
    { 6120,  4940, {}},
    { 6160,  4960, {}},
    { 6160,  4900, {}},
    { 6220,  4920, {}},
    { 6280,  4960, {}},
    { 6280,  4880, {}},
    { 6280,  4840, {}},
    { 6260,  4820, {}},
    { 6240,  4840, {}},
    { 6240,  4800, {}},
    { 6240,  4760, {}},
    { 6220,  4760, {}},
    { 6220,  4740, {}},
    { 6260,  4720, {}},
    { 6280,  4700, {}},
    { 6280,  4720, {}},
    { 6300,  4740, {}},
    { 6320,  4720, {}},
    { 6340,  4700, {}},
    { 6360,  4700, {}},
    { 6380,  4680, {}},
    { 6380,  4660, {}},
    { 6400,  4640, {}},
    { 6400,  4620, {}},
    { 6400,  4600, {}},
    { 6400,  4560, {}},
    { 6420,  4580, {}},
    { 6420,  4640, {}},
    { 6440,  4660, {}},
    { 6440,  4700, {}},
    { 6440,  4740, {}},
    { 6440,  4780, {}},
    { 6440,  4820, {}},
    { 6420,  4840, {}},
    { 6440,  4880, {}},
    { 6440,  4940, {}},
    { 6460,  4980, {}},
    { 6460,  5040, {}},
    { 6480,  5020, {}},
    { 6500,  5000, {}},
    { 6520,  4980, {}},
    { 6520,  4900, {}},
    { 6620,  4900, {}},
    { 6620,  4940, {}},
    { 6640,  5020, {}},
    { 6660,  5080, {}},
    { 6680,  5160, {}},
    { 6700,  5180, {}},
    { 6700,  5200, {}},
    { 6700,  5280, {}},
    { 6700,  5340, {}},
    { 6700,  5380, {}},
    { 6700,  5460, {}},
    { 6700,  5560, {}},
    { 6700,  5600, {}},
    { 6700,  5640, {}},
    { 6700,  5700, {}},
    { 6700,  5740, {}},
    { 6700,  5800, {}},
    { 6700,  5840, {}},
    { 6700,  5880, {}},
    { 6700,  5940, {}},
    { 6700,  6000, {}},
    { 6700,  6060, {}},
    { 6700,  6120, {}},
    { 6700,  6140, {}},
    { 6700,  6160, {}},
    { 6720,  6180, {}},
    { 6720,  6240, {}},
    { 6740,  6280, {}},
    { 6760,  6300, {}},
    { 6780,  6320, {}},
    { 6780,  6340, {}},
    { 6780,  6360, {}},
    { 6780,  6380, {}},
    { 6780,  6400, {}},
    { 6800,  6380, {}},
    { 6800,  6400, {}},
    { 6800,  6420, {}},
    { 6820,  6440, {}},
    { 6840,  6460, {}},
    { 6840,  6480, {}},
    { 6840,  6500, {}},
    { 6840,  6520, {}},
    { 6840,  6540, {}},
    { 6840,  6560, {}},
    { 6860,  6560, {}},
    { 6880,  6540, {}},
    { 6880,  6520, {}},
    { 6880,  6500, {}},
    { 6880,  6480, {}},
    { 6880,  6460, {}},
    { 6900,  6460, {}},
    { 6920,  6480, {}},
    { 6920,  6500, {}},
    { 7017,  6571, {}},
    { 7114,  6643, {}},
    { 7211,  6714, {}},
    { 7309,  6786, {}},
    { 7406,  6857, {}},
    { 7503,  6929, {}},
    { 7600,  7000, {}},
    { 7700,  7000, {}},
    { 7800,  7000, {}},
    { 7900,  7000, {}},
    { 8000,  7000, {}},
};

static ZoneVertex cqz17[] = {
    { 7600,  7000, {}},
    { 7506,  6931, {}},
    { 7411,  6863, {}},
    { 7317,  6794, {}},
    { 7223,  6726, {}},
    { 7129,  6657, {}},
    { 7034,  6589, {}},
    { 6940,  6520, {}},
    { 6920,  6500, {}},
    { 6920,  6480, {}},
    { 6900,  6460, {}},
    { 6880,  6480, {}},
    { 6880,  6500, {}},
    { 6880,  6520, {}},
    { 6880,  6540, {}},
    { 6860,  6560, {}},
    { 6840,  6540, {}},
    { 6840,  6520, {}},
    { 6840,  6500, {}},
    { 6840,  6480, {}},
    { 6840,  6460, {}},
    { 6820,  6460, {}},
    { 6820,  6440, {}},
    { 6820,  6420, {}},
    { 6800,  6400, {}},
    { 6780,  6380, {}},
    { 6780,  6360, {}},
    { 6780,  6340, {}},
    { 6780,  6320, {}},
    { 6760,  6300, {}},
    { 6740,  6280, {}},
    { 6720,  6240, {}},
    { 6720,  6180, {}},
    { 6700,  6160, {}},
    { 6700,  6140, {}},
    { 6700,  6120, {}},
    { 6700,  6020, {}},
    { 6700,  6000, {}},
    { 6700,  5940, {}},
    { 6700,  5880, {}},
    { 6700,  5840, {}},
    { 6700,  5800, {}},
    { 6700,  5740, {}},
    { 6700,  5700, {}},
    { 6700,  5640, {}},
    { 6700,  5600, {}},
    { 6700,  5560, {}},
    { 6700,  5460, {}},
    { 6700,  5400, {}},
    { 6700,  5380, {}},
    { 6700,  5340, {}},
    { 6700,  5280, {}},
    { 6720,  5220, {}},
    { 6700,  5200, {}},
    { 6700,  5180, {}},
    { 6700,  5160, {}},
    { 6680,  5160, {}},
    { 6660,  5080, {}},
    { 6640,  5020, {}},
    { 6620,  4940, {}},
    { 6620,  4900, {}},
    { 6520,  4900, {}},
    { 6520,  4960, {}},
    { 6500,  5000, {}},
    { 6480,  5020, {}},
    { 6480,  5060, {}},
    { 6460,  5040, {}},
    { 6460,  5000, {}},
    { 6460,  4960, {}},
    { 6440,  4900, {}},
    { 6440,  4860, {}},
    { 6420,  4820, {}},
    { 6440,  4800, {}},
    { 6440,  4760, {}},
    { 6440,  4740, {}},
    { 6440,  4720, {}},
    { 6440,  4700, {}},
    { 6440,  4660, {}},
    { 6420,  4640, {}},
    { 6420,  4580, {}},
    { 6420,  4540, {}},
    { 6400,  4580, {}},
    { 6400,  4600, {}},
    { 6400,  4640, {}},
    { 6380,  4660, {}},
    { 6380,  4680, {}},
    { 6360,  4700, {}},
    { 6340,  4700, {}},
    { 6320,  4720, {}},
    { 6320,  4740, {}},
    { 6300,  4740, {}},
    { 6280,  4700, {}},
    { 6260,  4720, {}},
    { 6240,  4720, {}},
    { 6220,  4740, {}},
    { 6220,  4760, {}},
    { 6240,  4800, {}},
    { 6240,  4820, {}},
    { 6280,  4840, {}},
    { 6280,  4860, {}},
    { 6280,  4960, {}},
    { 6220,  4940, {}},
    { 6160,  4900, {}},
    { 6160,  4960, {}},
    { 6120,  4940, {}},
    { 6120,  4920, {}},
    { 6120,  4900, {}},
    { 6100,  4840, {}},
    { 6060,  4860, {}},
    { 6040,  4860, {}},
    { 6020,  4840, {}},
    { 6000,  4860, {}},
    { 5980,  4860, {}},
    { 5960,  4920, {}},
    { 5940,  4960, {}},
    { 5920,  4980, {}},
    { 5940,  4980, {}},
    { 5960,  4980, {}},
    { 5960,  5000, {}},
    { 5980,  5020, {}},
    { 5980,  5040, {}},
    { 5980,  5080, {}},
    { 6000,  5100, {}},
    { 6000,  5140, {}},
    { 6000,  5160, {}},
    { 6020,  5180, {}},
    { 6040,  5200, {}},
    { 6020,  5240, {}},
    { 6020,  5300, {}},
    { 6020,  5340, {}},
    { 6020,  5360, {}},
    { 5980,  5360, {}},
    { 5960,  5340, {}},
    { 5940,  5320, {}},
    { 5920,  5340, {}},
    { 5920,  5380, {}},
    { 5900,  5380, {}},
    { 5880,  5400, {}},
    { 5880,  5380, {}},
    { 5860,  5380, {}},
    { 5840,  5380, {}},
    { 5820,  5380, {}},
    { 5800,  5400, {}},
    { 5780,  5420, {}},
    { 5760,  5400, {}},
    { 5740,  5420, {}},
    { 5720,  5440, {}},
    { 5700,  5440, {}},
    { 5700,  5420, {}},
    { 5680,  5400, {}},
    { 5680,  5380, {}},
    { 5660,  5380, {}},
    { 5660,  5400, {}},
    { 5640,  5420, {}},
    { 5640,  5440, {}},
    { 5660,  5460, {}},
    { 5640,  5480, {}},
    { 5640,  5500, {}},
    { 5640,  5520, {}},
    { 5640,  5540, {}},
    { 5640,  5560, {}},
    { 5640,  5580, {}},
    { 5640,  5600, {}},
    { 5640,  5620, {}},
    { 5640,  5640, {}},
    { 5620,  5660, {}},
    { 5620,  5680, {}},
    { 5620,  5700, {}},
    { 5620,  5720, {}},
    { 5640,  5740, {}},
    { 5620,  5760, {}},
    { 5620,  5780, {}},
    { 5620,  5800, {}},
    { 5620,  5820, {}},
    { 5620,  5840, {}},
    { 5620,  5860, {}},
    { 5600,  5880, {}},
    { 5620,  5900, {}},
    { 5620,  5920, {}},
    { 5600,  5920, {}},
    { 5580,  5920, {}},
    { 5560,  5920, {}},
    { 5560,  5940, {}},
    { 5560,  5960, {}},
    { 5540,  5940, {}},
    { 5540,  5920, {}},
    { 5520,  5900, {}},
    { 5520,  5880, {}},
    { 5520,  5860, {}},
    { 5500,  5880, {}},
    { 5500,  5860, {}},
    { 5500,  5840, {}},
    { 5520,  5820, {}},
    { 5500,  5820, {}},
    { 5500,  5800, {}},
    { 5520,  5820, {}},
    { 5520,  5800, {}},
    { 5540,  5780, {}},
    { 5540,  5760, {}},
    { 5540,  5740, {}},
    { 5520,  5720, {}},
    { 5500,  5720, {}},
    { 5480,  5720, {}},
    { 5480,  5740, {}},
    { 5460,  5760, {}},
    { 5440,  5780, {}},
    { 5440,  5800, {}},
    { 5460,  5820, {}},
    { 5460,  5840, {}},
    { 5440,  5860, {}},
    { 5460,  5880, {}},
    { 5460,  5900, {}},
    { 5460,  5920, {}},
    { 5480,  5940, {}},
    { 5480,  5960, {}},
    { 5480,  5980, {}},
    { 5480,  6000, {}},
    { 5460,  5980, {}},
    { 5440,  5980, {}},
    { 5420,  5980, {}},
    { 5420,  5960, {}},
    { 5420,  5940, {}},
    { 5400,  5920, {}},
    { 5400,  5900, {}},
    { 5380,  5900, {}},
    { 5360,  5880, {}},
    { 5340,  5880, {}},
    { 5320,  5900, {}},
    { 5300,  5880, {}},
    { 5280,  5880, {}},
    { 5260,  5880, {}},
    { 5240,  5900, {}},
    { 5240,  5920, {}},
    { 5240,  5940, {}},
    { 5240,  5960, {}},
    { 5240,  5980, {}},
    { 5240,  6000, {}},
    { 5220,  6000, {}},
    { 5200,  6000, {}},
    { 5180,  6040, {}},
    { 5160,  6080, {}},
    { 5140,  6100, {}},
    { 5140,  6120, {}},
    { 5140,  6140, {}},
    { 5120,  6160, {}},
    { 5100,  6140, {}},
    { 5060,  6080, {}},
    { 5060,  6060, {}},
    { 5060,  6040, {}},
    { 5080,  6020, {}},
    { 5080,  6000, {}},
    { 5060,  5980, {}},
    { 5040,  5960, {}},
    { 5060,  5960, {}},
    { 5060,  5920, {}},
    { 5060,  5900, {}},
    { 5080,  5880, {}},
    { 5080,  5860, {}},
    { 5100,  5860, {}},
    { 5100,  5840, {}},
    { 5100,  5820, {}},
    { 5100,  5800, {}},
    { 5120,  5780, {}},
    { 5100,  5780, {}},
    { 5100,  5760, {}},
    { 5100,  5740, {}},
    { 5120,  5720, {}},
    { 5100,  5700, {}},
    { 5100,  5680, {}},
    { 5100,  5660, {}},
    { 5100,  5640, {}},
    { 5100,  5620, {}},
    { 5080,  5620, {}},
    { 5060,  5600, {}},
    { 5060,  5580, {}},
    { 5060,  5560, {}},
    { 5060,  5540, {}},
    { 5080,  5520, {}},
    { 5100,  5500, {}},
    { 5100,  5480, {}},
    { 5100,  5460, {}},
    { 5080,  5460, {}},
    { 5060,  5460, {}},
    { 5080,  5460, {}},
    { 5080,  5440, {}},
    { 5100,  5420, {}},
    { 5120,  5400, {}},
    { 5120,  5380, {}},
    { 5140,  5360, {}},
    { 5140,  5340, {}},
    { 5160,  5320, {}},
    { 5140,  5300, {}},
    { 5140,  5280, {}},
    { 5140,  5260, {}},
    { 5160,  5240, {}},
    { 5180,  5220, {}},
    { 5160,  5200, {}},
    { 5160,  5180, {}},
    { 5160,  5160, {}},
    { 5140,  5140, {}},
    { 5160,  5140, {}},
    { 5160,  5120, {}},
    { 5160,  5100, {}},
    { 5180,  5080, {}},
    { 5160,  5080, {}},
    { 5160,  5060, {}},
    { 5140,  5040, {}},
    { 5120,  5000, {}},
    { 5120,  4980, {}},
    { 5120,  4960, {}},
    { 5100,  4940, {}},
    { 5080,  4920, {}},
    { 5060,  4900, {}},
    { 5060,  4880, {}},
    { 5060,  4860, {}},
    { 5040,  4860, {}},
    { 5020,  4880, {}},
    { 5000,  4880, {}},
    { 4980,  4840, {}},
    { 5000,  4820, {}},
    { 5020,  4800, {}},
    { 5040,  4780, {}},
    { 5040,  4760, {}},
    { 5040,  4740, {}},
    { 5020,  4720, {}},
    { 5000,  4720, {}},
    { 4980,  4700, {}},
    { 4960,  4680, {}},
    { 4940,  4680, {}},
    { 4920,  4700, {}},
    { 4900,  4680, {}},
    { 4860,  4660, {}},
    { 4840,  4660, {}},
    { 4840,  4680, {}},
    { 4820,  4720, {}},
    { 4800,  4700, {}},
    { 4780,  4720, {}},
    { 4780,  4740, {}},
    { 4780,  4760, {}},
    { 4780,  4800, {}},
    { 4740,  4840, {}},
    { 4700,  4880, {}},
    { 4680,  4900, {}},
    { 4660,  4880, {}},
    { 4680,  4860, {}},
    { 4660,  4860, {}},
    { 4640,  4880, {}},
    { 4640,  4900, {}},
    { 4620,  4920, {}},
    { 4620,  4940, {}},
    { 4600,  5000, {}},
    { 4500,  4975, {}},
    { 4400,  4950, {}},
    { 4300,  4925, {}},
    { 4200,  4900, {}},
    { 4108,  5000, {}},
    { 4016,  5100, {}},
    { 3924,  5200, {}},
    { 3832,  5300, {}},
    { 3740,  5400, {}},
    { 3740,  5420, {}},
    { 3740,  5440, {}},
    { 3740,  5460, {}},
    { 3760,  5480, {}},
    { 3780,  5500, {}},
    { 3800,  5520, {}},
    { 3800,  5540, {}},
    { 3820,  5560, {}},
    { 3820,  5580, {}},
    { 3800,  5600, {}},
    { 3800,  5620, {}},
    { 3820,  5640, {}},
    { 3820,  5660, {}},
    { 3820,  5680, {}},
    { 3820,  5700, {}},
    { 3820,  5720, {}},
    { 3800,  5740, {}},
    { 3800,  5760, {}},
    { 3780,  5780, {}},
    { 3780,  5800, {}},
    { 3780,  5820, {}},
    { 3760,  5840, {}},
    { 3760,  5860, {}},
    { 3760,  5880, {}},
    { 3760,  5900, {}},
    { 3760,  5920, {}},
    { 3740,  5940, {}},
    { 3720,  5960, {}},
    { 3720,  5980, {}},
    { 3700,  6000, {}},
    { 3680,  6020, {}},
    { 3660,  6040, {}},
    { 3660,  6060, {}},
    { 3660,  6080, {}},
    { 3660,  6120, {}},
    { 3640,  6120, {}},
    { 3620,  6120, {}},
    { 3600,  6120, {}},
    { 3580,  6120, {}},
    { 3560,  6140, {}},
    { 3540,  6180, {}},
    { 3540,  6200, {}},
    { 3520,  6220, {}},
    { 3520,  6240, {}},
    { 3520,  6260, {}},
    { 3520,  6280, {}},
    { 3540,  6300, {}},
    { 3560,  6300, {}},
    { 3560,  6320, {}},
    { 3580,  6320, {}},
    { 3600,  6360, {}},
    { 3600,  6400, {}},
    { 3620,  6420, {}},
    { 3620,  6440, {}},
    { 3640,  6460, {}},
    { 3660,  6460, {}},
    { 3700,  6480, {}},
    { 3720,  6500, {}},
    { 3720,  6520, {}},
    { 3720,  6560, {}},
    { 3740,  6560, {}},
    { 3760,  6580, {}},
    { 3740,  6600, {}},
    { 3740,  6620, {}},
    { 3740,  6640, {}},
    { 3740,  6660, {}},
    { 3740,  6680, {}},
    { 3740,  6700, {}},
    { 3720,  6720, {}},
    { 3720,  6740, {}},
    { 3720,  6760, {}},
    { 3700,  6780, {}},
    { 3700,  6800, {}},
    { 3700,  6820, {}},
    { 3720,  6840, {}},
    { 3720,  6860, {}},
    { 3740,  6900, {}},
    { 3720,  6920, {}},
    { 3720,  6940, {}},
    { 3760,  6940, {}},
    { 3760,  6980, {}},
    { 3760,  7000, {}},
    { 3760,  7020, {}},
    { 3780,  7020, {}},
    { 3800,  7040, {}},
    { 3820,  7060, {}},
    { 3840,  7060, {}},
    { 3840,  7080, {}},
    { 3840,  7100, {}},
    { 3840,  7120, {}},
    { 3820,  7140, {}},
    { 3800,  7120, {}},
    { 3800,  7140, {}},
    { 3780,  7160, {}},
    { 3760,  7140, {}},
    { 3740,  7140, {}},
    { 3720,  7140, {}},
    { 3700,  7140, {}},
    { 3680,  7160, {}},
    { 3660,  7180, {}},
    { 3680,  7200, {}},
    { 3700,  7220, {}},
    { 3700,  7240, {}},
    { 3700,  7260, {}},
    { 3720,  7280, {}},
    { 3740,  7300, {}},
    { 3740,  7320, {}},
    { 3740,  7340, {}},
    { 3740,  7360, {}},
    { 3720,  7380, {}},
    { 3720,  7400, {}},
    { 3740,  7420, {}},
    { 3740,  7440, {}},
    { 3740,  7460, {}},
    { 3740,  7480, {}},
    { 3720,  7500, {}},
    { 3740,  7520, {}},
    { 3760,  7500, {}},
    { 3780,  7500, {}},
    { 3800,  7500, {}},
    { 3820,  7480, {}},
    { 3840,  7460, {}},
    { 3860,  7420, {}},
    { 3860,  7400, {}},
    { 3860,  7380, {}},
    { 3880,  7380, {}},
    { 3900,  7380, {}},
    { 3920,  7360, {}},
    { 3940,  7360, {}},
    { 3940,  7380, {}},
    { 3960,  7400, {}},
    { 3980,  7380, {}},
    { 4000,  7400, {}},
    { 4020,  7420, {}},
    { 4020,  7440, {}},
    { 4020,  7460, {}},
    { 4040,  7480, {}},
    { 4040,  7500, {}},
    { 4040,  7520, {}},
    { 4060,  7540, {}},
    { 4060,  7560, {}},
    { 4040,  7560, {}},
    { 4040,  7580, {}},
    { 4040,  7600, {}},
    { 4040,  7620, {}},
    { 4040,  7640, {}},
    { 4060,  7660, {}},
    { 4080,  7680, {}},
    { 4100,  7680, {}},
    { 4100,  7700, {}},
    { 4100,  7720, {}},
    { 4100,  7740, {}},
    { 4100,  7760, {}},
    { 4100,  7780, {}},
    { 4120,  7800, {}},
    { 4140,  7820, {}},
    { 4140,  7840, {}},
    { 4140,  7860, {}},
    { 4160,  7880, {}},
    { 4160,  7900, {}},
    { 4180,  7920, {}},
    { 4180,  7940, {}},
    { 4180,  7960, {}},
    { 4200,  7980, {}},
    { 4200,  8000, {}},
    { 4200,  8020, {}},
    { 4220,  8020, {}},
    { 4240,  8020, {}},
    { 4260,  8020, {}},
    { 4280,  8020, {}},
    { 4280,  8040, {}},
    { 4300,  8040, {}},
    { 4320,  8060, {}},
    { 4320,  8080, {}},
    { 4340,  8080, {}},
    { 4380,  8060, {}},
    { 4400,  8040, {}},
    { 4420,  8040, {}},
    { 4440,  8040, {}},
    { 4460,  8040, {}},
    { 4480,  8020, {}},
    { 4480,  8000, {}},
    { 4500,  8000, {}},
    { 4500,  8020, {}},
    { 4500,  8040, {}},
    { 4520,  8060, {}},
    { 4520,  8080, {}},
    { 4520,  8100, {}},
    { 4520,  8120, {}},
    { 4520,  8140, {}},
    { 4540,  8160, {}},
    { 4540,  8180, {}},
    { 4520,  8200, {}},
    { 4520,  8220, {}},
    { 4520,  8240, {}},
    { 4540,  8260, {}},
    { 4560,  8220, {}},
    { 4580,  8240, {}},
    { 4620,  8260, {}},
    { 4640,  8260, {}},
    { 4660,  8280, {}},
    { 4680,  8280, {}},
    { 4700,  8300, {}},
    { 4720,  8300, {}},
    { 4720,  8320, {}},
    { 4720,  8340, {}},
    { 4700,  8360, {}},
    { 4700,  8380, {}},
    { 4700,  8400, {}},
    { 4700,  8420, {}},
    { 4700,  8440, {}},
    { 4700,  8460, {}},
    { 4700,  8480, {}},
    { 4700,  8500, {}},
    { 4700,  8520, {}},
    { 4700,  8540, {}},
    { 4720,  8560, {}},
    { 4740,  8560, {}},
    { 4800,  8560, {}},
    { 4820,  8560, {}},
    { 4840,  8580, {}},
    { 4840,  8600, {}},
    { 4840,  8620, {}},
    { 4840,  8640, {}},
    { 4860,  8660, {}},
    { 4880,  8680, {}},
    { 4900,  8680, {}},
    { 4920,  8700, {}},
    { 4920,  8720, {}},
    { 4940,  8700, {}},
    { 4960,  8680, {}},
    { 4960,  8660, {}},
    { 4980,  8660, {}},
    { 4960,  8640, {}},
    { 4940,  8620, {}},
    { 4940,  8600, {}},
    { 4960,  8580, {}},
    { 4960,  8560, {}},
    { 4960,  8540, {}},
    { 4980,  8520, {}},
    { 5000,  8500, {}},
    { 5020,  8480, {}},
    { 5020,  8460, {}},
    { 5020,  8440, {}},
    { 5040,  8420, {}},
    { 5060,  8420, {}},
    { 5080,  8400, {}},
    { 5080,  8380, {}},
    { 5100,  8360, {}},
    { 5100,  8340, {}},
    { 5100,  8320, {}},
    { 5080,  8300, {}},
    { 5100,  8280, {}},
    { 5080,  8260, {}},
    { 5080,  8240, {}},
    { 5080,  8220, {}},
    { 5080,  8200, {}},
    { 5080,  8180, {}},
    { 5080,  8160, {}},
    { 5100,  8140, {}},
    { 5100,  8120, {}},
    { 5120,  8120, {}},
    { 5120,  8100, {}},
    { 5120,  8080, {}},
    { 5120,  8040, {}},
    { 5100,  8040, {}},
    { 5080,  8020, {}},
    { 5180,  7920, {}},
    { 5220,  7900, {}},
    { 5240,  7880, {}},
    { 5260,  7860, {}},
    { 5300,  7820, {}},
    { 5320,  7800, {}},
    { 5340,  7780, {}},
    { 5360,  7740, {}},
    { 5380,  7700, {}},
    { 5380,  7680, {}},
    { 5400,  7660, {}},
    { 5420,  7680, {}},
    { 5440,  7680, {}},
    { 5440,  7660, {}},
    { 5440,  7640, {}},
    { 5440,  7620, {}},
    { 5420,  7560, {}},
    { 5460,  7560, {}},
    { 5460,  7580, {}},
    { 5480,  7560, {}},
    { 5500,  7540, {}},
    { 5520,  7520, {}},
    { 5540,  7520, {}},
    { 5560,  7520, {}},
    { 5580,  7540, {}},
    { 5600,  7560, {}},
    { 5620,  7600, {}},
    { 5620,  7620, {}},
    { 5640,  7600, {}},
    { 5660,  7600, {}},
    { 5660,  7620, {}},
    { 5680,  7620, {}},
    { 5720,  7600, {}},
    { 5760,  7560, {}},
    { 5780,  7560, {}},
    { 5820,  7500, {}},
    { 5820,  7520, {}},
    { 5840,  7540, {}},
    { 5860,  7520, {}},
    { 5900,  7560, {}},
    { 5920,  7560, {}},
    { 5920,  7580, {}},
    { 5960,  7620, {}},
    { 5960,  7640, {}},
    { 5960,  7660, {}},
    { 6000,  7680, {}},
    { 6020,  7680, {}},
    { 6040,  7680, {}},
    { 6060,  7700, {}},
    { 6080,  7700, {}},
    { 6080,  7720, {}},
    { 6080,  7740, {}},
    { 6080,  7780, {}},
    { 6080,  7820, {}},
    { 6080,  7860, {}},
    { 6080,  7880, {}},
    { 6080,  7900, {}},
    { 6080,  7920, {}},
    { 6060,  7940, {}},
    { 6060,  7960, {}},
    { 6060,  8000, {}},
    { 6080,  8040, {}},
    { 6080,  8060, {}},
    { 6080,  8100, {}},
    { 6060,  8140, {}},
    { 6060,  8180, {}},
    { 6060,  8220, {}},
    { 6060,  8240, {}},
    { 6080,  8280, {}},
    { 6100,  8320, {}},
    { 6100,  8340, {}},
    { 6080,  8400, {}},
    { 6080,  8420, {}},
    { 6100,  8460, {}},
    { 6100,  8480, {}},
    { 6120,  8500, {}},
    { 6120,  8520, {}},
    { 6120,  8560, {}},
    { 6140,  8580, {}},
    { 6160,  8540, {}},
    { 6180,  8520, {}},
    { 6180,  8500, {}},
    { 6180,  8480, {}},
    { 6200,  8460, {}},
    { 6220,  8440, {}},
    { 6240,  8460, {}},
    { 6240,  8480, {}},
    { 6260,  8500, {}},
    { 6280,  8520, {}},
    { 6280,  8540, {}},
    { 6300,  8560, {}},
    { 6320,  8560, {}},
    { 6340,  8540, {}},
    { 6360,  8520, {}},
    { 6380,  8540, {}},
    { 6400,  8560, {}},
    { 6400,  8580, {}},
    { 6420,  8600, {}},
    { 6440,  8600, {}},
    { 6460,  8580, {}},
    { 6480,  8580, {}},
    { 6480,  8560, {}},
    { 6480,  8540, {}},
    { 6480,  8520, {}},
    { 6480,  8500, {}},
    { 6500,  8480, {}},
    { 6500,  8460, {}},
    { 6500,  8440, {}},
    { 6520,  8440, {}},
    { 6540,  8440, {}},
    { 6560,  8420, {}},
    { 6580,  8400, {}},
    { 6580,  8360, {}},
    { 6600,  8340, {}},
    { 6640,  8320, {}},
    { 6660,  8320, {}},
    { 6680,  8320, {}},
    { 6720,  8240, {}},
    { 6720,  8220, {}},
    { 6740,  8220, {}},
    { 6740,  8240, {}},
    { 6760,  8220, {}},
    { 6780,  8200, {}},
    { 6780,  8180, {}},
    { 6800,  8200, {}},
    { 6800,  8220, {}},
    { 6820,  8260, {}},
    { 6840,  8280, {}},
    { 6860,  8260, {}},
    { 6860,  8280, {}},
    { 6880,  8260, {}},
    { 6900,  8240, {}},
    { 6920,  8220, {}},
    { 6920,  8200, {}},
    { 6940,  8180, {}},
    { 6920,  8160, {}},
    { 6920,  8140, {}},
    { 6920,  8120, {}},
    { 6920,  8100, {}},
    { 6920,  8080, {}},
    { 6940,  8060, {}},
    { 6940,  8040, {}},
    { 6940,  8020, {}},
    { 6940,  8000, {}},
    { 6940,  7980, {}},
    { 6940,  7960, {}},
    { 6960,  7940, {}},
    { 6960,  7920, {}},
    { 6980,  7900, {}},
    { 7000,  7920, {}},
    { 7020,  7940, {}},
    { 7020,  7960, {}},
    { 7020,  7980, {}},
    { 7040,  8000, {}},
    { 7040,  8020, {}},
    { 7040,  8040, {}},
    { 7040,  8060, {}},
    { 7040,  8080, {}},
    { 7060,  8080, {}},
    { 7080,  8080, {}},
    { 7100,  8060, {}},
    { 7100,  8040, {}},
    { 7120,  8000, {}},
    { 7140,  7940, {}},
    { 7140,  7920, {}},
    { 7160,  7940, {}},
    { 7160,  7960, {}},
    { 7160,  7980, {}},
    { 7160,  8000, {}},
    { 7180,  8000, {}},
    { 7180,  8020, {}},
    { 7200,  8000, {}},
    { 7200,  7980, {}},
    { 7200,  7960, {}},
    { 7200,  7940, {}},
    { 7200,  7920, {}},
    { 7200,  7900, {}},
    { 7220,  7880, {}},
    { 7220,  7860, {}},
    { 7260,  7900, {}},
    { 7300,  7800, {}},
    { 7400,  7800, {}},
    { 7425,  7700, {}},
    { 7450,  7600, {}},
    { 7475,  7500, {}},
    { 7500,  7400, {}},
    { 7525,  7300, {}},
    { 7550,  7200, {}},
    { 7575,  7100, {}},
    { 7600,  7000, {}},
};

static ZoneVertex cqz18[] = {
    { 9000, 11500, {}},
    { 9000, 11402, {}},
    { 9000, 11304, {}},
    { 9000, 11207, {}},
    { 9000, 11109, {}},
    { 9000, 11011, {}},
    { 9000, 10913, {}},
    { 9000, 10815, {}},
    { 9000, 10717, {}},
    { 9000, 10620, {}},
    { 9000, 10522, {}},
    { 9000, 10424, {}},
    { 9000, 10326, {}},
    { 9000, 10228, {}},
    { 9000, 10130, {}},
    { 9000, 10033, {}},
    { 9000,  9935, {}},
    { 9000,  9837, {}},
    { 9000,  9739, {}},
    { 9000,  9641, {}},
    { 9000,  9543, {}},
    { 9000,  9446, {}},
    { 9000,  9348, {}},
    { 9000,  9250, {}},
    { 9000,  9152, {}},
    { 9000,  9054, {}},
    { 9000,  8957, {}},
    { 9000,  8859, {}},
    { 9000,  8761, {}},
    { 9000,  8663, {}},
    { 9000,  8565, {}},
    { 9000,  8467, {}},
    { 9000,  8370, {}},
    { 9000,  8272, {}},
    { 9000,  8174, {}},
    { 9000,  8076, {}},
    { 9000,  7978, {}},
    { 9000,  7880, {}},
    { 9000,  7783, {}},
    { 9000,  7685, {}},
    { 9000,  7587, {}},
    { 9000,  7489, {}},
    { 9000,  7391, {}},
    { 9000,  7293, {}},
    { 9000,  7196, {}},
    { 9000,  7098, {}},
    { 9000,  7000, {}},
    { 8900,  7000, {}},
    { 8800,  7000, {}},
    { 8700,  7000, {}},
    { 8600,  7000, {}},
    { 8500,  7000, {}},
    { 8400,  7000, {}},
    { 8300,  7000, {}},
    { 8200,  7000, {}},
    { 8100,  7000, {}},
    { 8000,  7000, {}},
    { 7900,  7000, {}},
    { 7800,  7000, {}},
    { 7700,  7000, {}},
    { 7600,  7000, {}},
    { 7575,  7100, {}},
    { 7550,  7200, {}},
    { 7525,  7300, {}},
    { 7500,  7400, {}},
    { 7475,  7500, {}},
    { 7450,  7600, {}},
    { 7425,  7700, {}},
    { 7400,  7800, {}},
    { 7300,  7800, {}},
    { 7260,  7900, {}},
    { 7240,  7840, {}},
    { 7220,  7860, {}},
    { 7220,  7880, {}},
    { 7220,  7900, {}},
    { 7200,  7920, {}},
    { 7200,  7940, {}},
    { 7200,  7960, {}},
    { 7200,  7980, {}},
    { 7200,  8000, {}},
    { 7200,  8020, {}},
    { 7180,  8000, {}},
    { 7160,  8000, {}},
    { 7160,  7980, {}},
    { 7160,  7960, {}},
    { 7160,  7940, {}},
    { 7140,  7920, {}},
    { 7140,  7940, {}},
    { 7120,  8000, {}},
    { 7100,  8020, {}},
    { 7100,  8040, {}},
    { 7080,  8060, {}},
    { 7060,  8080, {}},
    { 7040,  8080, {}},
    { 7040,  8060, {}},
    { 7040,  8040, {}},
    { 7040,  8020, {}},
    { 7040,  8000, {}},
    { 7020,  7980, {}},
    { 7020,  7960, {}},
    { 7020,  7940, {}},
    { 7000,  7920, {}},
    { 6980,  7900, {}},
    { 6960,  7920, {}},
    { 6960,  7940, {}},
    { 6960,  7960, {}},
    { 6940,  7980, {}},
    { 6940,  8000, {}},
    { 6940,  8020, {}},
    { 6940,  8040, {}},
    { 6940,  8060, {}},
    { 6920,  8080, {}},
    { 6920,  8100, {}},
    { 6920,  8120, {}},
    { 6920,  8140, {}},
    { 6920,  8160, {}},
    { 6940,  8160, {}},
    { 6940,  8200, {}},
    { 6920,  8180, {}},
    { 6920,  8200, {}},
    { 6920,  8220, {}},
    { 6920,  8240, {}},
    { 6900,  8240, {}},
    { 6880,  8260, {}},
    { 6880,  8280, {}},
    { 6860,  8260, {}},
    { 6840,  8280, {}},
    { 6820,  8260, {}},
    { 6820,  8240, {}},
    { 6800,  8240, {}},
    { 6800,  8220, {}},
    { 6800,  8200, {}},
    { 6800,  8180, {}},
    { 6780,  8200, {}},
    { 6760,  8220, {}},
    { 6760,  8240, {}},
    { 6740,  8220, {}},
    { 6720,  8240, {}},
    { 6680,  8300, {}},
    { 6680,  8320, {}},
    { 6660,  8320, {}},
    { 6640,  8320, {}},
    { 6620,  8360, {}},
    { 6620,  8340, {}},
    { 6600,  8340, {}},
    { 6580,  8360, {}},
    { 6580,  8380, {}},
    { 6580,  8400, {}},
    { 6560,  8420, {}},
    { 6560,  8440, {}},
    { 6540,  8460, {}},
    { 6520,  8440, {}},
    { 6500,  8440, {}},
    { 6500,  8460, {}},
    { 6500,  8480, {}},
    { 6500,  8500, {}},
    { 6480,  8520, {}},
    { 6480,  8540, {}},
    { 6480,  8560, {}},
    { 6480,  8580, {}},
    { 6460,  8600, {}},
    { 6440,  8600, {}},
    { 6420,  8600, {}},
    { 6400,  8580, {}},
    { 6400,  8560, {}},
    { 6380,  8540, {}},
    { 6360,  8520, {}},
    { 6340,  8540, {}},
    { 6340,  8560, {}},
    { 6320,  8560, {}},
    { 6300,  8560, {}},
    { 6280,  8540, {}},
    { 6280,  8520, {}},
    { 6260,  8500, {}},
    { 6240,  8480, {}},
    { 6240,  8460, {}},
    { 6220,  8440, {}},
    { 6200,  8460, {}},
    { 6180,  8480, {}},
    { 6180,  8500, {}},
    { 6160,  8520, {}},
    { 6160,  8540, {}},
    { 6160,  8580, {}},
    { 6140,  8560, {}},
    { 6120,  8540, {}},
    { 6120,  8500, {}},
    { 6100,  8480, {}},
    { 6100,  8460, {}},
    { 6100,  8440, {}},
    { 6080,  8420, {}},
    { 6080,  8400, {}},
    { 6100,  8340, {}},
    { 6100,  8320, {}},
    { 6080,  8280, {}},
    { 6080,  8240, {}},
    { 6060,  8220, {}},
    { 6060,  8180, {}},
    { 6060,  8160, {}},
    { 6060,  8120, {}},
    { 6080,  8100, {}},
    { 6080,  8080, {}},
    { 6080,  8040, {}},
    { 6060,  8020, {}},
    { 6060,  8000, {}},
    { 6060,  7960, {}},
    { 6060,  7940, {}},
    { 6080,  7920, {}},
    { 6080,  7900, {}},
    { 6080,  7880, {}},
    { 6080,  7860, {}},
    { 6080,  7820, {}},
    { 6080,  7800, {}},
    { 6080,  7780, {}},
    { 6080,  7760, {}},
    { 6080,  7740, {}},
    { 6080,  7720, {}},
    { 6060,  7700, {}},
    { 6040,  7680, {}},
    { 6020,  7680, {}},
    { 6000,  7680, {}},
    { 5980,  7680, {}},
    { 5960,  7660, {}},
    { 5960,  7620, {}},
    { 5940,  7600, {}},
    { 5920,  7560, {}},
    { 5900,  7580, {}},
    { 5880,  7540, {}},
    { 5860,  7520, {}},
    { 5840,  7500, {}},
    { 5820,  7520, {}},
    { 5800,  7560, {}},
    { 5760,  7560, {}},
    { 5740,  7580, {}},
    { 5720,  7600, {}},
    { 5700,  7620, {}},
    { 5660,  7620, {}},
    { 5660,  7600, {}},
    { 5640,  7600, {}},
    { 5620,  7620, {}},
    { 5620,  7600, {}},
    { 5620,  7580, {}},
    { 5600,  7560, {}},
    { 5600,  7540, {}},
    { 5580,  7540, {}},
    { 5580,  7520, {}},
    { 5560,  7520, {}},
    { 5540,  7500, {}},
    { 5520,  7520, {}},
    { 5500,  7540, {}},
    { 5480,  7560, {}},
    { 5460,  7580, {}},
    { 5420,  7560, {}},
    { 5420,  7620, {}},
    { 5440,  7640, {}},
    { 5440,  7660, {}},
    { 5440,  7680, {}},
    { 5420,  7680, {}},
    { 5420,  7660, {}},
    { 5400,  7660, {}},
    { 5380,  7700, {}},
    { 5360,  7720, {}},
    { 5360,  7740, {}},
    { 5340,  7780, {}},
    { 5320,  7800, {}},
    { 5300,  7820, {}},
    { 5260,  7860, {}},
    { 5220,  7900, {}},
    { 5200,  7920, {}},
    { 5140,  7960, {}},
    { 5080,  8000, {}},
    { 5080,  8020, {}},
    { 5100,  8040, {}},
    { 5120,  8040, {}},
    { 5120,  8060, {}},
    { 5120,  8080, {}},
    { 5120,  8100, {}},
    { 5100,  8100, {}},
    { 5100,  8120, {}},
    { 5100,  8140, {}},
    { 5080,  8140, {}},
    { 5080,  8180, {}},
    { 5080,  8200, {}},
    { 5080,  8220, {}},
    { 5080,  8240, {}},
    { 5080,  8260, {}},
    { 5100,  8280, {}},
    { 5100,  8300, {}},
    { 5100,  8320, {}},
    { 5100,  8340, {}},
    { 5100,  8360, {}},
    { 5080,  8380, {}},
    { 5060,  8400, {}},
    { 5060,  8420, {}},
    { 5040,  8420, {}},
    { 5020,  8440, {}},
    { 5020,  8460, {}},
    { 5020,  8480, {}},
    { 5000,  8500, {}},
    { 4980,  8520, {}},
    { 4960,  8520, {}},
    { 4960,  8540, {}},
    { 4960,  8560, {}},
    { 4960,  8580, {}},
    { 4960,  8600, {}},
    { 4940,  8620, {}},
    { 4960,  8640, {}},
    { 4980,  8660, {}},
    { 4960,  8660, {}},
    { 4960,  8680, {}},
    { 4940,  8700, {}},
    { 4920,  8720, {}},
    { 4900,  8740, {}},
    { 4920,  8760, {}},
    { 4920,  8780, {}},
    { 4920,  8800, {}},
    { 4940,  8820, {}},
    { 4940,  8840, {}},
    { 4960,  8860, {}},
    { 4940,  8880, {}},
    { 4940,  8900, {}},
    { 4960,  8920, {}},
    { 4960,  8940, {}},
    { 4960,  8960, {}},
    { 4980,  8960, {}},
    { 5000,  8960, {}},
    { 5020,  8940, {}},
    { 5040,  8940, {}},
    { 5040,  8960, {}},
    { 5040,  8980, {}},
    { 5060,  8960, {}},
    { 5080,  8940, {}},
    { 5100,  8920, {}},
    { 5120,  8900, {}},
    { 5140,  8900, {}},
    { 5160,  8880, {}},
    { 5160,  8900, {}},
    { 5160,  8920, {}},
    { 5160,  8940, {}},
    { 5160,  8960, {}},
    { 5160,  8980, {}},
    { 5180,  9000, {}},
    { 5200,  9000, {}},
    { 5220,  9020, {}},
    { 5220,  9040, {}},
    { 5220,  9060, {}},
    { 5200,  9080, {}},
    { 5200,  9100, {}},
    { 5200,  9120, {}},
    { 5180,  9140, {}},
    { 5180,  9160, {}},
    { 5180,  9180, {}},
    { 5180,  9200, {}},
    { 5180,  9220, {}},
    { 5180,  9240, {}},
    { 5180,  9260, {}},
    { 5180,  9280, {}},
    { 5200,  9300, {}},
    { 5200,  9320, {}},
    { 5220,  9340, {}},
    { 5220,  9360, {}},
    { 5240,  9380, {}},
    { 5260,  9400, {}},
    { 5280,  9420, {}},
    { 5300,  9440, {}},
    { 5320,  9460, {}},
    { 5340,  9480, {}},
    { 5340,  9500, {}},
    { 5340,  9520, {}},
    { 5340,  9540, {}},
    { 5340,  9560, {}},
    { 5360,  9580, {}},
    { 5340,  9600, {}},
    { 5360,  9620, {}},
    { 5360,  9640, {}},
    { 5360,  9660, {}},
    { 5380,  9680, {}},
    { 5360,  9700, {}},
    { 5360,  9720, {}},
    { 5360,  9740, {}},
    { 5340,  9760, {}},
    { 5340,  9780, {}},
    { 5320,  9800, {}},
    { 5320,  9820, {}},
    { 5320,  9840, {}},
    { 5320,  9860, {}},
    { 5320,  9880, {}},
    { 5320,  9900, {}},
    { 5300,  9920, {}},
    { 5300,  9900, {}},
    { 5280,  9900, {}},
    { 5260,  9880, {}},
    { 5240,  9860, {}},
    { 5220,  9880, {}},
    { 5200,  9900, {}},
    { 5200,  9920, {}},
    { 5200,  9940, {}},
    { 5200,  9960, {}},
    { 5200,  9980, {}},
    { 5180,  9980, {}},
    { 5180, 10000, {}},
    { 5180, 10020, {}},
    { 5180, 10040, {}},
    { 5180, 10060, {}},
    { 5160, 10080, {}},
    { 5160, 10100, {}},
    { 5160, 10120, {}},
    { 5140, 10140, {}},
    { 5140, 10160, {}},
    { 5140, 10180, {}},
    { 5140, 10200, {}},
    { 5120, 10220, {}},
    { 5100, 10220, {}},
    { 5080, 10220, {}},
    { 5060, 10240, {}},
    { 5060, 10260, {}},
    { 5040, 10260, {}},
    { 5040, 10280, {}},
    { 5040, 10300, {}},
    { 5040, 10320, {}},
    { 5020, 10320, {}},
    { 5020, 10340, {}},
    { 5020, 10360, {}},
    { 5020, 10380, {}},
    { 5020, 10400, {}},
    { 5020, 10420, {}},
    { 5040, 10440, {}},
    { 5040, 10460, {}},
    { 5040, 10480, {}},
    { 5040, 10500, {}},
    { 5040, 10520, {}},
    { 5040, 10540, {}},
    { 5040, 10560, {}},
    { 5040, 10580, {}},
    { 5040, 10600, {}},
    { 5040, 10620, {}},
    { 5040, 10640, {}},
    { 5040, 10680, {}},
    { 5020, 10700, {}},
    { 5000, 10720, {}},
    { 5000, 10740, {}},
    { 5000, 10760, {}},
    { 5000, 10780, {}},
    { 4980, 10800, {}},
    { 4960, 10800, {}},
    { 4960, 10820, {}},
    { 4940, 10840, {}},
    { 4940, 10860, {}},
    { 4940, 10880, {}},
    { 4940, 10900, {}},
    { 4940, 10940, {}},
    { 4920, 10960, {}},
    { 4920, 10980, {}},
    { 4920, 11000, {}},
    { 4920, 11020, {}},
    { 4920, 11040, {}},
    { 4920, 11060, {}},
    { 4920, 11080, {}},
    { 4920, 11100, {}},
    { 4940, 11120, {}},
    { 4940, 11140, {}},
    { 4940, 11160, {}},
    { 4940, 11180, {}},
    { 4940, 11220, {}},
    { 4960, 11240, {}},
    { 4960, 11260, {}},
    { 4960, 11280, {}},
    { 4960, 11300, {}},
    { 4980, 11320, {}},
    { 5000, 11340, {}},
    { 5000, 11360, {}},
    { 5020, 11380, {}},
    { 5020, 11420, {}},
    { 5020, 11440, {}},
    { 5020, 11460, {}},
    { 5020, 11480, {}},
    { 5020, 11500, {}},
    { 5000, 11520, {}},
    { 5000, 11560, {}},
    { 5000, 11580, {}},
    { 5000, 11600, {}},
    { 5000, 11620, {}},
    { 5000, 11640, {}},
    { 5000, 11660, {}},
    { 4960, 11700, {}},
    { 4960, 11720, {}},
    { 4960, 11740, {}},
    { 4960, 11760, {}},
    { 4960, 11780, {}},
    { 4960, 11800, {}},
    { 4960, 11820, {}},
    { 4980, 11840, {}},
    { 4980, 11860, {}},
    { 5000, 11880, {}},
    { 5000, 11900, {}},
    { 5000, 11920, {}},
    { 5020, 11940, {}},
    { 5040, 11920, {}},
    { 5060, 11920, {}},
    { 5060, 11940, {}},
    { 5080, 11960, {}},
    { 5100, 11960, {}},
    { 5120, 11980, {}},
    { 5140, 12000, {}},
    { 5160, 12000, {}},
    { 5180, 12020, {}},
    { 5180, 12040, {}},
    { 5200, 12060, {}},
    { 5220, 12080, {}},
    { 5240, 12060, {}},
    { 5260, 12060, {}},
    { 5260, 12040, {}},
    { 5260, 12020, {}},
    { 5280, 12020, {}},
    { 5300, 12040, {}},
    { 5320, 12060, {}},
    { 5320, 12080, {}},
    { 5320, 12100, {}},
    { 5320, 12120, {}},
    { 5340, 12140, {}},
    { 5340, 12160, {}},
    { 5340, 12180, {}},
    { 5340, 12200, {}},
    { 5360, 12200, {}},
    { 5380, 12200, {}},
    { 5400, 12180, {}},
    { 5420, 12180, {}},
    { 5440, 12160, {}},
    { 5440, 12180, {}},
    { 5440, 12200, {}},
    { 5460, 12200, {}},
    { 5480, 12200, {}},
    { 5480, 12180, {}},
    { 5500, 12200, {}},
    { 5520, 12200, {}},
    { 5540, 12200, {}},
    { 5560, 12180, {}},
    { 5560, 12160, {}},
    { 5560, 12140, {}},
    { 5580, 12140, {}},
    { 5600, 12120, {}},
    { 5600, 12100, {}},
    { 5600, 12080, {}},
    { 5600, 12060, {}},
    { 5580, 12040, {}},
    { 5580, 12020, {}},
    { 5600, 12020, {}},
    { 5620, 12020, {}},
    { 5620, 12040, {}},
    { 5640, 12020, {}},
    { 5640, 12000, {}},
    { 5660, 11980, {}},
    { 5680, 11960, {}},
    { 5680, 11980, {}},
    { 5700, 11960, {}},
    { 5720, 11960, {}},
    { 5740, 11940, {}},
    { 5760, 11940, {}},
    { 5760, 11920, {}},
    { 5780, 11900, {}},
    { 5800, 11920, {}},
    { 5820, 11920, {}},
    { 5840, 11920, {}},
    { 5860, 11900, {}},
    { 5860, 11880, {}},
    { 5880, 11880, {}},
    { 5900, 11880, {}},
    { 5920, 11860, {}},
    { 5920, 11880, {}},
    { 5940, 11880, {}},
    { 5940, 11860, {}},
    { 5960, 11840, {}},
    { 5960, 11820, {}},
    { 5960, 11800, {}},
    { 5960, 11780, {}},
    { 5960, 11760, {}},
    { 5960, 11740, {}},
    { 5960, 11720, {}},
    { 5980, 11720, {}},
    { 6000, 11740, {}},
    { 6000, 11720, {}},
    { 6020, 11700, {}},
    { 6020, 11680, {}},
    { 6040, 11660, {}},
    { 6040, 11640, {}},
    { 6040, 11620, {}},
    { 6040, 11600, {}},
    { 6060, 11580, {}},
    { 6060, 11560, {}},
    { 6040, 11540, {}},
    { 6040, 11520, {}},
    { 6020, 11500, {}},
    { 6020, 11480, {}},
    { 6020, 11460, {}},
    { 6000, 11460, {}},
    { 6000, 11440, {}},
    { 5980, 11420, {}},
    { 5980, 11400, {}},
    { 5960, 11380, {}},
    { 5960, 11360, {}},
    { 5940, 11340, {}},
    { 5920, 11340, {}},
    { 5920, 11320, {}},
    { 5920, 11300, {}},
    { 5920, 11280, {}},
    { 5920, 11260, {}},
    { 5900, 11260, {}},
    { 5920, 11240, {}},
    { 5920, 11260, {}},
    { 5940, 11240, {}},
    { 5940, 11220, {}},
    { 5940, 11200, {}},
    { 5920, 11180, {}},
    { 5920, 11160, {}},
    { 5920, 11140, {}},
    { 5920, 11120, {}},
    { 5920, 11100, {}},
    { 5920, 11080, {}},
    { 5920, 11060, {}},
    { 5900, 11040, {}},
    { 5900, 11020, {}},
    { 5900, 11000, {}},
    { 5900, 10980, {}},
    { 5920, 10960, {}},
    { 5940, 10940, {}},
    { 5960, 10940, {}},
    { 5980, 10960, {}},
    { 6000, 10980, {}},
    { 6020, 10980, {}},
    { 6040, 11000, {}},
    { 6060, 11020, {}},
    { 6080, 11020, {}},
    { 6100, 11040, {}},
    { 6120, 11040, {}},
    { 6120, 11020, {}},
    { 6140, 11000, {}},
    { 6140, 10980, {}},
    { 6160, 10980, {}},
    { 6180, 10960, {}},
    { 6200, 10980, {}},
    { 6220, 11000, {}},
    { 6240, 11000, {}},
    { 6240, 10960, {}},
    { 6240, 10940, {}},
    { 6260, 10920, {}},
    { 6260, 10940, {}},
    { 6280, 10960, {}},
    { 6300, 10960, {}},
    { 6320, 10940, {}},
    { 6340, 10940, {}},
    { 6360, 10920, {}},
    { 6360, 10900, {}},
    { 6360, 10880, {}},
    { 6360, 10860, {}},
    { 6360, 10840, {}},
    { 6360, 10820, {}},
    { 6380, 10820, {}},
    { 6380, 10840, {}},
    { 6380, 10860, {}},
    { 6380, 10880, {}},
    { 6400, 10880, {}},
    { 6420, 10860, {}},
    { 6440, 10840, {}},
    { 6420, 10820, {}},
    { 6420, 10800, {}},
    { 6420, 10780, {}},
    { 6440, 10760, {}},
    { 6420, 10740, {}},
    { 6440, 10720, {}},
    { 6440, 10700, {}},
    { 6440, 10680, {}},
    { 6460, 10660, {}},
    { 6440, 10640, {}},
    { 6440, 10620, {}},
    { 6460, 10600, {}},
    { 6440, 10580, {}},
    { 6460, 10580, {}},
    { 6480, 10580, {}},
    { 6500, 10600, {}},
    { 6480, 10620, {}},
    { 6500, 10600, {}},
    { 6520, 10620, {}},
    { 6520, 10640, {}},
    { 6540, 10660, {}},
    { 6540, 10680, {}},
    { 6560, 10660, {}},
    { 6580, 10640, {}},
    { 6600, 10640, {}},
    { 6620, 10620, {}},
    { 6640, 10620, {}},
    { 6660, 10620, {}},
    { 6680, 10620, {}},
    { 6680, 10600, {}},
    { 6700, 10560, {}},
    { 6700, 10600, {}},
    { 6720, 10620, {}},
    { 6720, 10640, {}},
    { 6720, 10660, {}},
    { 6740, 10680, {}},
    { 6760, 10680, {}},
    { 6800, 10680, {}},
    { 6880, 10700, {}},
    { 6900, 10660, {}},
    { 6940, 10620, {}},
    { 6960, 10640, {}},
    { 6960, 10660, {}},
    { 6960, 10680, {}},
    { 6960, 10700, {}},
    { 6960, 10720, {}},
    { 6960, 10740, {}},
    { 6960, 10760, {}},
    { 6960, 10780, {}},
    { 6980, 10800, {}},
    { 6980, 10820, {}},
    { 6980, 10840, {}},
    { 6980, 10860, {}},
    { 6980, 10880, {}},
    { 6980, 10900, {}},
    { 6980, 10920, {}},
    { 7000, 10940, {}},
    { 7020, 10940, {}},
    { 7020, 10960, {}},
    { 7040, 10980, {}},
    { 7040, 11000, {}},
    { 7040, 11020, {}},
    { 7060, 11020, {}},
    { 7080, 11040, {}},
    { 7080, 11060, {}},
    { 7080, 11080, {}},
    { 7080, 11100, {}},
    { 7080, 11120, {}},
    { 7080, 11140, {}},
    { 7100, 11160, {}},
    { 7100, 11180, {}},
    { 7100, 11200, {}},
    { 7100, 11220, {}},
    { 7100, 11240, {}},
    { 7120, 11260, {}},
    { 7140, 11240, {}},
    { 7140, 11220, {}},
    { 7200, 11200, {}},
    { 7220, 11180, {}},
    { 7220, 11160, {}},
    { 7240, 11140, {}},
    { 7240, 11120, {}},
    { 7240, 11100, {}},
    { 7240, 11120, {}},
    { 7260, 11100, {}},
    { 7260, 11080, {}},
    { 7280, 11080, {}},
    { 7300, 11080, {}},
    { 7320, 11060, {}},
    { 7320, 11040, {}},
    { 7320, 11060, {}},
    { 7340, 11040, {}},
    { 7340, 11020, {}},
    { 7340, 11040, {}},
    { 7340, 11060, {}},
    { 7360, 11080, {}},
    { 7360, 11100, {}},
    { 7360, 11120, {}},
    { 7360, 11100, {}},
    { 7380, 11100, {}},
    { 7380, 11120, {}},
    { 7400, 11200, {}},
    { 7410, 11140, {}},
    { 7420, 11080, {}},
    { 7448, 11164, {}},
    { 7476, 11248, {}},
    { 7504, 11332, {}},
    { 7532, 11416, {}},
    { 7560, 11500, {}},
    { 7656, 11500, {}},
    { 7752, 11500, {}},
    { 7848, 11500, {}},
    { 7944, 11500, {}},
    { 8040, 11500, {}},
    { 8136, 11500, {}},
    { 8232, 11500, {}},
    { 8328, 11500, {}},
    { 8424, 11500, {}},
    { 8520, 11500, {}},
    { 8616, 11500, {}},
    { 8712, 11500, {}},
    { 8808, 11500, {}},
    { 8904, 11500, {}},
    { 9000, 11500, {}},
};

static ZoneVertex cqz19[] = {
    { 9000, 11500, {}},
    { 8904, 11500, {}},
    { 8808, 11500, {}},
    { 8712, 11500, {}},
    { 8616, 11500, {}},
    { 8520, 11500, {}},
    { 8424, 11500, {}},
    { 8328, 11500, {}},
    { 8232, 11500, {}},
    { 8136, 11500, {}},
    { 8040, 11500, {}},
    { 7944, 11500, {}},
    { 7848, 11500, {}},
    { 7752, 11500, {}},
    { 7656, 11500, {}},
    { 7560, 11500, {}},
    { 7532, 11416, {}},
    { 7504, 11332, {}},
    { 7476, 11248, {}},
    { 7448, 11164, {}},
    { 7420, 11080, {}},
    { 7410, 11140, {}},
    { 7400, 11200, {}},
    { 7380, 11140, {}},
    { 7380, 11120, {}},
    { 7380, 11100, {}},
    { 7360, 11120, {}},
    { 7360, 11100, {}},
    { 7360, 11080, {}},
    { 7340, 11060, {}},
    { 7340, 11040, {}},
    { 7340, 11020, {}},
    { 7340, 11040, {}},
    { 7320, 11060, {}},
    { 7320, 11040, {}},
    { 7320, 11060, {}},
    { 7320, 11080, {}},
    { 7300, 11060, {}},
    { 7300, 11080, {}},
    { 7280, 11080, {}},
    { 7260, 11080, {}},
    { 7260, 11100, {}},
    { 7260, 11120, {}},
    { 7240, 11100, {}},
    { 7240, 11120, {}},
    { 7240, 11140, {}},
    { 7240, 11160, {}},
    { 7220, 11180, {}},
    { 7200, 11200, {}},
    { 7140, 11200, {}},
    { 7140, 11220, {}},
    { 7140, 11240, {}},
    { 7120, 11260, {}},
    { 7100, 11240, {}},
    { 7100, 11220, {}},
    { 7100, 11200, {}},
    { 7100, 11180, {}},
    { 7100, 11160, {}},
    { 7080, 11140, {}},
    { 7080, 11120, {}},
    { 7080, 11100, {}},
    { 7080, 11080, {}},
    { 7080, 11060, {}},
    { 7060, 11040, {}},
    { 7060, 11020, {}},
    { 7040, 11000, {}},
    { 7040, 10980, {}},
    { 7040, 10960, {}},
    { 7020, 10940, {}},
    { 7000, 10960, {}},
    { 7000, 10940, {}},
    { 6980, 10940, {}},
    { 6980, 10920, {}},
    { 6980, 10900, {}},
    { 6980, 10880, {}},
    { 6980, 10860, {}},
    { 6980, 10840, {}},
    { 6980, 10820, {}},
    { 6960, 10800, {}},
    { 6960, 10780, {}},
    { 6960, 10760, {}},
    { 6960, 10720, {}},
    { 6960, 10700, {}},
    { 6960, 10680, {}},
    { 6960, 10660, {}},
    { 6960, 10640, {}},
    { 6940, 10620, {}},
    { 6900, 10660, {}},
    { 6880, 10700, {}},
    { 6820, 10700, {}},
    { 6760, 10680, {}},
    { 6740, 10680, {}},
    { 6720, 10660, {}},
    { 6720, 10640, {}},
    { 6720, 10620, {}},
    { 6700, 10600, {}},
    { 6700, 10580, {}},
    { 6700, 10560, {}},
    { 6700, 10580, {}},
    { 6680, 10600, {}},
    { 6660, 10620, {}},
    { 6640, 10620, {}},
    { 6620, 10620, {}},
    { 6600, 10640, {}},
    { 6580, 10640, {}},
    { 6560, 10660, {}},
    { 6560, 10680, {}},
    { 6540, 10680, {}},
    { 6540, 10660, {}},
    { 6520, 10640, {}},
    { 6520, 10620, {}},
    { 6500, 10600, {}},
    { 6480, 10620, {}},
    { 6500, 10600, {}},
    { 6480, 10580, {}},
    { 6460, 10580, {}},
    { 6460, 10600, {}},
    { 6440, 10620, {}},
    { 6440, 10660, {}},
    { 6440, 10680, {}},
    { 6440, 10700, {}},
    { 6440, 10720, {}},
    { 6420, 10740, {}},
    { 6440, 10760, {}},
    { 6420, 10780, {}},
    { 6420, 10800, {}},
    { 6420, 10820, {}},
    { 6420, 10840, {}},
    { 6420, 10860, {}},
    { 6400, 10880, {}},
    { 6380, 10860, {}},
    { 6380, 10840, {}},
    { 6360, 10820, {}},
    { 6360, 10840, {}},
    { 6360, 10860, {}},
    { 6360, 10880, {}},
    { 6360, 10900, {}},
    { 6340, 10920, {}},
    { 6340, 10940, {}},
    { 6320, 10940, {}},
    { 6300, 10960, {}},
    { 6280, 10960, {}},
    { 6260, 10940, {}},
    { 6240, 10960, {}},
    { 6240, 10980, {}},
    { 6220, 11000, {}},
    { 6200, 10980, {}},
    { 6200, 10960, {}},
    { 6180, 10960, {}},
    { 6160, 10980, {}},
    { 6140, 10980, {}},
    { 6140, 11000, {}},
    { 6120, 11020, {}},
    { 6120, 11040, {}},
    { 6100, 11040, {}},
    { 6080, 11020, {}},
    { 6060, 11020, {}},
    { 6060, 11000, {}},
    { 6040, 10980, {}},
    { 6020, 10980, {}},
    { 6000, 10960, {}},
    { 5980, 10960, {}},
    { 5960, 10940, {}},
    { 5940, 10920, {}},
    { 5940, 10940, {}},
    { 5920, 10960, {}},
    { 5900, 10980, {}},
    { 5900, 11000, {}},
    { 5900, 11020, {}},
    { 5900, 11040, {}},
    { 5920, 11060, {}},
    { 5920, 11080, {}},
    { 5920, 11100, {}},
    { 5920, 11120, {}},
    { 5920, 11140, {}},
    { 5920, 11160, {}},
    { 5920, 11180, {}},
    { 5940, 11200, {}},
    { 5960, 11220, {}},
    { 5940, 11220, {}},
    { 5940, 11240, {}},
    { 5940, 11260, {}},
    { 5920, 11240, {}},
    { 5900, 11240, {}},
    { 5900, 11260, {}},
    { 5920, 11280, {}},
    { 5920, 11300, {}},
    { 5920, 11320, {}},
    { 5920, 11340, {}},
    { 5940, 11340, {}},
    { 5960, 11360, {}},
    { 5960, 11380, {}},
    { 5980, 11400, {}},
    { 5980, 11420, {}},
    { 6000, 11440, {}},
    { 6020, 11460, {}},
    { 6020, 11480, {}},
    { 6020, 11500, {}},
    { 6040, 11520, {}},
    { 6060, 11540, {}},
    { 6060, 11560, {}},
    { 6060, 11580, {}},
    { 6040, 11600, {}},
    { 6040, 11620, {}},
    { 6040, 11640, {}},
    { 6040, 11660, {}},
    { 6020, 11680, {}},
    { 6020, 11700, {}},
    { 6000, 11720, {}},
    { 5980, 11720, {}},
    { 5960, 11720, {}},
    { 5960, 11740, {}},
    { 5960, 11760, {}},
    { 5940, 11780, {}},
    { 5960, 11800, {}},
    { 5960, 11820, {}},
    { 5960, 11840, {}},
    { 5940, 11860, {}},
    { 5940, 11880, {}},
    { 5920, 11860, {}},
    { 5900, 11880, {}},
    { 5880, 11880, {}},
    { 5860, 11880, {}},
    { 5860, 11900, {}},
    { 5840, 11900, {}},
    { 5820, 11920, {}},
    { 5800, 11920, {}},
    { 5780, 11900, {}},
    { 5760, 11920, {}},
    { 5760, 11940, {}},
    { 5740, 11940, {}},
    { 5720, 11960, {}},
    { 5700, 11960, {}},
    { 5700, 11980, {}},
    { 5680, 11960, {}},
    { 5660, 11980, {}},
    { 5640, 12000, {}},
    { 5640, 12020, {}},
    { 5640, 12040, {}},
    { 5620, 12020, {}},
    { 5600, 12020, {}},
    { 5580, 12040, {}},
    { 5600, 12060, {}},
    { 5600, 12080, {}},
    { 5600, 12100, {}},
    { 5600, 12120, {}},
    { 5580, 12140, {}},
    { 5560, 12140, {}},
    { 5560, 12160, {}},
    { 5560, 12180, {}},
    { 5540, 12200, {}},
    { 5520, 12200, {}},
    { 5500, 12200, {}},
    { 5500, 12180, {}},
    { 5480, 12160, {}},
    { 5480, 12180, {}},
    { 5460, 12200, {}},
    { 5440, 12200, {}},
    { 5440, 12180, {}},
    { 5420, 12180, {}},
    { 5400, 12180, {}},
    { 5380, 12200, {}},
    { 5360, 12200, {}},
    { 5340, 12220, {}},
    { 5340, 12240, {}},
    { 5340, 12260, {}},
    { 5340, 12280, {}},
    { 5340, 12300, {}},
    { 5360, 12320, {}},
    { 5360, 12340, {}},
    { 5360, 12360, {}},
    { 5340, 12380, {}},
    { 5340, 12400, {}},
    { 5340, 12420, {}},
    { 5320, 12440, {}},
    { 5320, 12460, {}},
    { 5320, 12480, {}},
    { 5320, 12500, {}},
    { 5320, 12520, {}},
    { 5320, 12540, {}},
    { 5300, 12560, {}},
    { 5280, 12580, {}},
    { 5280, 12600, {}},
    { 5260, 12600, {}},
    { 5260, 12620, {}},
    { 5240, 12640, {}},
    { 5220, 12640, {}},
    { 5200, 12640, {}},
    { 5180, 12660, {}},
    { 5160, 12660, {}},
    { 5160, 12680, {}},
    { 5140, 12700, {}},
    { 5120, 12680, {}},
    { 5100, 12700, {}},
    { 5080, 12720, {}},
    { 5060, 12740, {}},
    { 5040, 12740, {}},
    { 5020, 12760, {}},
    { 5000, 12740, {}},
    { 4980, 12760, {}},
    { 4960, 12780, {}},
    { 4960, 12800, {}},
    { 4960, 12820, {}},
    { 4960, 12840, {}},
    { 4960, 12860, {}},
    { 4940, 12880, {}},
    { 4940, 12900, {}},
    { 4940, 12920, {}},
    { 4940, 12940, {}},
    { 4920, 12960, {}},
    { 4920, 12980, {}},
    { 4900, 13000, {}},
    { 4880, 13020, {}},
    { 4900, 13040, {}},
    { 4880, 13060, {}},
    { 4860, 13060, {}},
    { 4840, 13080, {}},
    { 4820, 13080, {}},
    { 4800, 13080, {}},
    { 4780, 13100, {}},
    { 4780, 13120, {}},
    { 4780, 13140, {}},
    { 4760, 13160, {}},
    { 4760, 13180, {}},
    { 4780, 13200, {}},
    { 4780, 13220, {}},
    { 4780, 13240, {}},
    { 4780, 13260, {}},
    { 4800, 13280, {}},
    { 4820, 13300, {}},
    { 4800, 13320, {}},
    { 4800, 13340, {}},
    { 4820, 13360, {}},
    { 4820, 13380, {}},
    { 4820, 13400, {}},
    { 4840, 13420, {}},
    { 4840, 13440, {}},
    { 4840, 13460, {}},
    { 4820, 13460, {}},
    { 4800, 13460, {}},
    { 4780, 13480, {}},
    { 4760, 13460, {}},
    { 4740, 13440, {}},
    { 4740, 13420, {}},
    { 4720, 13420, {}},
    { 4700, 13400, {}},
    { 4680, 13400, {}},
    { 4660, 13400, {}},
    { 4640, 13400, {}},
    { 4620, 13380, {}},
    { 4600, 13360, {}},
    { 4580, 13340, {}},
    { 4560, 13340, {}},
    { 4560, 13320, {}},
    { 4540, 13320, {}},
    { 4520, 13320, {}},
    { 4500, 13300, {}},
    { 4520, 13200, {}},
    { 4520, 13180, {}},
    { 4500, 13160, {}},
    { 4500, 13140, {}},
    { 4500, 13120, {}},
    { 4480, 13100, {}},
    { 4400, 13140, {}},
    { 4360, 13120, {}},
    { 4340, 13140, {}},
    { 4320, 13120, {}},
    { 4300, 13120, {}},
    { 4280, 13100, {}},
    { 4280, 13080, {}},
    { 4280, 13060, {}},
    { 4280, 13040, {}},
    { 4260, 13060, {}},
    { 4240, 13060, {}},
    { 4237, 13160, {}},
    { 4233, 13260, {}},
    { 4230, 13360, {}},
    { 4227, 13460, {}},
    { 4223, 13560, {}},
    { 4220, 13660, {}},
    { 4310, 13740, {}},
    { 4400, 13820, {}},
    { 4490, 13900, {}},
    { 4580, 13980, {}},
    { 4580, 14074, {}},
    { 4580, 14169, {}},
    { 4580, 14263, {}},
    { 4580, 14357, {}},
    { 4580, 14451, {}},
    { 4580, 14546, {}},
    { 4580, 14640, {}},
    { 4480, 14580, {}},
    { 4380, 14520, {}},
    { 4360, 14560, {}},
    { 4320, 14620, {}},
    { 4297, 14719, {}},
    { 4274, 14817, {}},
    { 4251, 14916, {}},
    { 4229, 15014, {}},
    { 4206, 15113, {}},
    { 4183, 15211, {}},
    { 4160, 15310, {}},
    { 4137, 15409, {}},
    { 4114, 15507, {}},
    { 4091, 15606, {}},
    { 4069, 15704, {}},
    { 4046, 15803, {}},
    { 4023, 15901, {}},
    { 4000, 16000, {}},
    { 4000, 16100, {}},
    { 4000, 16200, {}},
    { 4000, 16300, {}},
    { 4000, 16400, {}},
    { 4000, 16500, {}},
    { 4000, 16600, {}},
    { 4000, 16700, {}},
    { 4000, 16800, {}},
    { 4000, 16900, {}},
    { 4000, 17000, {}},
    { 4100, 17000, {}},
    { 4200, 17000, {}},
    { 4300, 17000, {}},
    { 4400, 17000, {}},
    { 4500, 17000, {}},
    { 4600, 17000, {}},
    { 4700, 17000, {}},
    { 4800, 17000, {}},
    { 4900, 17000, {}},
    { 5000, 17000, {}},
    { 5100, 17000, {}},
    { 5200, 17000, {}},
    { 5300, 17000, {}},
    { 5359, 17097, {}},
    { 5418, 17195, {}},
    { 5477, 17292, {}},
    { 5537, 17390, {}},
    { 5596, 17487, {}},
    { 5655, 17584, {}},
    { 5714, 17682, {}},
    { 5773, 17779, {}},
    { 5832, 17877, {}},
    { 5891, 17974, {}},
    { 5950, -17929, {}},
    { 6010, -17831, {}},
    { 6069, -17734, {}},
    { 6128, -17637, {}},
    { 6187, -17539, {}},
    { 6246, -17442, {}},
    { 6305, -17344, {}},
    { 6364, -17247, {}},
    { 6423, -17150, {}},
    { 6483, -17052, {}},
    { 6542, -16955, {}},
    { 6601, -16857, {}},
    { 6660, -16760, {}},
    { 6725, -16855, {}},
    { 6789, -16951, {}},
    { 6854, -17046, {}},
    { 6918, -17142, {}},
    { 6983, -17237, {}},
    { 7048, -17332, {}},
    { 7112, -17428, {}},
    { 7177, -17523, {}},
    { 7242, -17618, {}},
    { 7306, -17714, {}},
    { 7371, -17809, {}},
    { 7435, -17905, {}},
    { 7500, -18000, {}},
    { 7600, -18000, {}},
    { 7700, -18000, {}},
    { 7800, -18000, {}},
    { 7900, -18000, {}},
    { 8000, -18000, {}},
    { 8100, -18000, {}},
    { 8200, -18000, {}},
    { 8300, -18000, {}},
    { 8400, -18000, {}},
    { 8500, -18000, {}},
    { 8600, -18000, {}},
    { 8700, -18000, {}},
    { 8800, -18000, {}},
    { 8900, -18000, {}},
    { 9000, -18000, {}},
    { 9000, 17900, {}},
    { 9000, 17800, {}},
    { 9000, 17700, {}},
    { 9000, 17600, {}},
    { 9000, 17500, {}},
    { 9000, 17400, {}},
    { 9000, 17300, {}},
    { 9000, 17200, {}},
    { 9000, 17100, {}},
    { 9000, 17000, {}},
    { 9000, 16900, {}},
    { 9000, 16800, {}},
    { 9000, 16700, {}},
    { 9000, 16600, {}},
    { 9000, 16500, {}},
    { 9000, 16400, {}},
    { 9000, 16300, {}},
    { 9000, 16200, {}},
    { 9000, 16100, {}},
    { 9000, 16000, {}},
    { 9000, 15900, {}},
    { 9000, 15800, {}},
    { 9000, 15700, {}},
    { 9000, 15600, {}},
    { 9000, 15500, {}},
    { 9000, 15400, {}},
    { 9000, 15300, {}},
    { 9000, 15200, {}},
    { 9000, 15100, {}},
    { 9000, 15000, {}},
    { 9000, 14900, {}},
    { 9000, 14800, {}},
    { 9000, 14700, {}},
    { 9000, 14600, {}},
    { 9000, 14500, {}},
    { 9000, 14400, {}},
    { 9000, 14300, {}},
    { 9000, 14200, {}},
    { 9000, 14100, {}},
    { 9000, 14000, {}},
    { 9000, 13900, {}},
    { 9000, 13800, {}},
    { 9000, 13700, {}},
    { 9000, 13600, {}},
    { 9000, 13500, {}},
    { 9000, 13400, {}},
    { 9000, 13300, {}},
    { 9000, 13200, {}},
    { 9000, 13100, {}},
    { 9000, 13000, {}},
    { 9000, 12900, {}},
    { 9000, 12800, {}},
    { 9000, 12700, {}},
    { 9000, 12600, {}},
    { 9000, 12500, {}},
    { 9000, 12400, {}},
    { 9000, 12300, {}},
    { 9000, 12200, {}},
    { 9000, 12100, {}},
    { 9000, 12000, {}},
    { 9000, 11900, {}},
    { 9000, 11800, {}},
    { 9000, 11700, {}},
    { 9000, 11600, {}},
    { 9000, 11500, {}},
};

static ZoneVertex cqz20[] = {
    { 4226,  3931, {}},
    { 4204,  4007, {}},
    { 4182,  4084, {}},
    { 4160,  4160, {}},
    { 4140,  4180, {}},
    { 4160,  4200, {}},
    { 4140,  4220, {}},
    { 4140,  4240, {}},
    { 4160,  4260, {}},
    { 4160,  4280, {}},
    { 4140,  4300, {}},
    { 4140,  4320, {}},
    { 4120,  4320, {}},
    { 4120,  4340, {}},
    { 4100,  4360, {}},
    { 4080,  4380, {}},
    { 4060,  4360, {}},
    { 4040,  4360, {}},
    { 4020,  4360, {}},
    { 4000,  4380, {}},
    { 4000,  4400, {}},
    { 4000,  4420, {}},
    { 4000,  4440, {}},
    { 3980,  4460, {}},
    { 3960,  4480, {}},
    { 3960,  4440, {}},
    { 3940,  4440, {}},
    { 3940,  4420, {}},
    { 3920,  4420, {}},
    { 3900,  4420, {}},
    { 3880,  4440, {}},
    { 3860,  4440, {}},
    { 3840,  4440, {}},
    { 3820,  4440, {}},
    { 3800,  4420, {}},
    { 3780,  4440, {}},
    { 3780,  4460, {}},
    { 3760,  4460, {}},
    { 3740,  4460, {}},
    { 3720,  4480, {}},
    { 3720,  4460, {}},
    { 3700,  4440, {}},
    { 3700,  4420, {}},
    { 3720,  4420, {}},
    { 3740,  4400, {}},
    { 3720,  4380, {}},
    { 3720,  4360, {}},
    { 3720,  4340, {}},
    { 3740,  4320, {}},
    { 3740,  4300, {}},
    { 3740,  4280, {}},
    { 3720,  4260, {}},
    { 3720,  4240, {}},
    { 3680,  4220, {}},
    { 3680,  4200, {}},
    { 3660,  4180, {}},
    { 3660,  4140, {}},
    { 3640,  4120, {}},
    { 3620,  4120, {}},
    { 3600,  4140, {}},
    { 3580,  4140, {}},
    { 3540,  4120, {}},
    { 3520,  4120, {}},
    { 3500,  4120, {}},
    { 3480,  4120, {}},
    { 3460,  4100, {}},
    { 3440,  4100, {}},
    { 3440,  4060, {}},
    { 3400,  4020, {}},
    { 3380,  3980, {}},
    { 3360,  3920, {}},
    { 3340,  3880, {}},
    { 3260,  3900, {}},
    { 3240,  3900, {}},
    { 3240,  3920, {}},
    { 3220,  3920, {}},
    { 3200,  3900, {}},
    { 3180,  3840, {}},
    { 3180,  3800, {}},
    { 3160,  3740, {}},
    { 3160,  3700, {}},
    { 3100,  3740, {}},
    { 3080,  3780, {}},
    { 3060,  3800, {}},
    { 3040,  3780, {}},
    { 3020,  3760, {}},
    { 3000,  3740, {}},
    { 2980,  3680, {}},
    { 2960,  3660, {}},
    { 2940,  3620, {}},
    { 2920,  3600, {}},
    { 2920,  3580, {}},
    { 2920,  3560, {}},
    { 2920,  3540, {}},
    { 2940,  3500, {}},
    { 2960,  3480, {}},
    { 2980,  3480, {}},
    { 3000,  3480, {}},
    { 3020,  3460, {}},
    { 3040,  3460, {}},
    { 3060,  3440, {}},
    { 3080,  3440, {}},
    { 3100,  3440, {}},
    { 3120,  3420, {}},
    { 3144,  3325, {}},
    { 3168,  3230, {}},
    { 3191,  3135, {}},
    { 3215,  3040, {}},
    { 3239,  2945, {}},
    { 3263,  2850, {}},
    { 3286,  2755, {}},
    { 3310,  2660, {}},
    { 3334,  2565, {}},
    { 3358,  2470, {}},
    { 3381,  2375, {}},
    { 3405,  2280, {}},
    { 3429,  2185, {}},
    { 3453,  2090, {}},
    { 3476,  1995, {}},
    { 3500,  1900, {}},
    { 3600,  1900, {}},
    { 3700,  1900, {}},
    { 3800,  1900, {}},
    { 3900,  1900, {}},
    { 4000,  1900, {}},
    { 4000,  1980, {}},
    { 3980,  2000, {}},
    { 3960,  2020, {}},
    { 3980,  2020, {}},
    { 3980,  2040, {}},
    { 4000,  2040, {}},
    { 4000,  2060, {}},
    { 4020,  2080, {}},
    { 4040,  2080, {}},
    { 4060,  2100, {}},
    { 4080,  2100, {}},
    { 4080,  2120, {}},
    { 4100,  2140, {}},
    { 4080,  2160, {}},
    { 4100,  2180, {}},
    { 4120,  2200, {}},
    { 4120,  2220, {}},
    { 4120,  2240, {}},
    { 4120,  2260, {}},
    { 4140,  2280, {}},
    { 4160,  2300, {}},
    { 4180,  2300, {}},
    { 4200,  2280, {}},
    { 4220,  2260, {}},
    { 4220,  2240, {}},
    { 4240,  2260, {}},
    { 4260,  2240, {}},
    { 4280,  2240, {}},
    { 4280,  2260, {}},
    { 4300,  2280, {}},
    { 4320,  2300, {}},
    { 4340,  2280, {}},
    { 4340,  2260, {}},
    { 4360,  2240, {}},
    { 4380,  2240, {}},
    { 4400,  2240, {}},
    { 4400,  2260, {}},
    { 4420,  2260, {}},
    { 4440,  2240, {}},
    { 4460,  2260, {}},
    { 4460,  2240, {}},
    { 4440,  2220, {}},
    { 4460,  2200, {}},
    { 4460,  2180, {}},
    { 4480,  2160, {}},
    { 4480,  2140, {}},
    { 4500,  2140, {}},
    { 4520,  2140, {}},
    { 4520,  2120, {}},
    { 4540,  2100, {}},
    { 4540,  2080, {}},
    { 4560,  2080, {}},
    { 4580,  2060, {}},
    { 4600,  2040, {}},
    { 4620,  2060, {}},
    { 4620,  2080, {}},
    { 4620,  2100, {}},
    { 4640,  2120, {}},
    { 4660,  2140, {}},
    { 4680,  2160, {}},
    { 4700,  2160, {}},
    { 4720,  2180, {}},
    { 4740,  2200, {}},
    { 4760,  2220, {}},
    { 4780,  2240, {}},
    { 4780,  2260, {}},
    { 4800,  2280, {}},
    { 4800,  2300, {}},
    { 4800,  2320, {}},
    { 4800,  2340, {}},
    { 4800,  2360, {}},
    { 4800,  2380, {}},
    { 4800,  2400, {}},
    { 4800,  2420, {}},
    { 4800,  2440, {}},
    { 4800,  2460, {}},
    { 4780,  2480, {}},
    { 4780,  2500, {}},
    { 4780,  2520, {}},
    { 4800,  2540, {}},
    { 4800,  2560, {}},
    { 4800,  2580, {}},
    { 4800,  2600, {}},
    { 4800,  2620, {}},
    { 4820,  2640, {}},
    { 4820,  2660, {}},
    { 4820,  2680, {}},
    { 4820,  2700, {}},
    { 4800,  2720, {}},
    { 4780,  2720, {}},
    { 4760,  2740, {}},
    { 4740,  2760, {}},
    { 4720,  2780, {}},
    { 4700,  2800, {}},
    { 4680,  2820, {}},
    { 4660,  2820, {}},
    { 4640,  2820, {}},
    { 4620,  2820, {}},
    { 4600,  2820, {}},
    { 4580,  2820, {}},
    { 4560,  2820, {}},
    { 4540,  2820, {}},
    { 4520,  2860, {}},
    { 4540,  2880, {}},
    { 4540,  2900, {}},
    { 4540,  2920, {}},
    { 4540,  2940, {}},
    { 4540,  2960, {}},
    { 4520,  2960, {}},
    { 4490,  3058, {}},
    { 4460,  3156, {}},
    { 4430,  3254, {}},
    { 4400,  3352, {}},
    { 4370,  3450, {}},
    { 4340,  3548, {}},
    { 4310,  3646, {}},
    { 4280,  3744, {}},
    { 4250,  3842, {}},
    { 4220,  3940, {}},
};

static ZoneVertex cqz21[] = {
    { 4226,  3931, {}},
    { 4283,  3965, {}},
    { 4340,  4000, {}},
    { 4360,  4020, {}},
    { 4360,  4040, {}},
    { 4360,  4060, {}},
    { 4340,  4080, {}},
    { 4340,  4100, {}},
    { 4340,  4120, {}},
    { 4340,  4140, {}},
    { 4320,  4160, {}},
    { 4320,  4180, {}},
    { 4320,  4200, {}},
    { 4320,  4220, {}},
    { 4320,  4240, {}},
    { 4320,  4260, {}},
    { 4320,  4280, {}},
    { 4300,  4300, {}},
    { 4300,  4320, {}},
    { 4280,  4340, {}},
    { 4280,  4360, {}},
    { 4280,  4380, {}},
    { 4260,  4380, {}},
    { 4260,  4400, {}},
    { 4260,  4420, {}},
    { 4280,  4440, {}},
    { 4280,  4460, {}},
    { 4260,  4480, {}},
    { 4260,  4500, {}},
    { 4260,  4520, {}},
    { 4260,  4540, {}},
    { 4260,  4560, {}},
    { 4240,  4580, {}},
    { 4220,  4560, {}},
    { 4220,  4580, {}},
    { 4200,  4600, {}},
    { 4200,  4620, {}},
    { 4200,  4640, {}},
    { 4180,  4660, {}},
    { 4180,  4680, {}},
    { 4160,  4700, {}},
    { 4140,  4720, {}},
    { 4120,  4740, {}},
    { 4120,  4760, {}},
    { 4120,  4780, {}},
    { 4140,  4800, {}},
    { 4160,  4820, {}},
    { 4160,  4840, {}},
    { 4180,  4860, {}},
    { 4200,  4900, {}},
    { 4108,  5000, {}},
    { 4016,  5100, {}},
    { 3924,  5200, {}},
    { 3832,  5300, {}},
    { 3740,  5400, {}},
    { 3740,  5420, {}},
    { 3740,  5440, {}},
    { 3740,  5460, {}},
    { 3760,  5480, {}},
    { 3780,  5500, {}},
    { 3800,  5520, {}},
    { 3800,  5540, {}},
    { 3820,  5560, {}},
    { 3820,  5580, {}},
    { 3800,  5600, {}},
    { 3800,  5620, {}},
    { 3820,  5640, {}},
    { 3820,  5660, {}},
    { 3820,  5680, {}},
    { 3820,  5700, {}},
    { 3820,  5720, {}},
    { 3800,  5740, {}},
    { 3800,  5760, {}},
    { 3780,  5780, {}},
    { 3780,  5800, {}},
    { 3780,  5820, {}},
    { 3760,  5840, {}},
    { 3760,  5860, {}},
    { 3760,  5880, {}},
    { 3760,  5900, {}},
    { 3760,  5920, {}},
    { 3740,  5940, {}},
    { 3720,  5960, {}},
    { 3720,  5980, {}},
    { 3700,  6000, {}},
    { 3680,  6020, {}},
    { 3660,  6040, {}},
    { 3660,  6060, {}},
    { 3660,  6080, {}},
    { 3660,  6120, {}},
    { 3640,  6120, {}},
    { 3620,  6120, {}},
    { 3600,  6120, {}},
    { 3580,  6120, {}},
    { 3560,  6140, {}},
    { 3540,  6180, {}},
    { 3540,  6200, {}},
    { 3520,  6220, {}},
    { 3520,  6240, {}},
    { 3520,  6260, {}},
    { 3520,  6280, {}},
    { 3540,  6300, {}},
    { 3560,  6300, {}},
    { 3560,  6320, {}},
    { 3580,  6320, {}},
    { 3600,  6360, {}},
    { 3600,  6400, {}},
    { 3620,  6420, {}},
    { 3620,  6440, {}},
    { 3640,  6460, {}},
    { 3660,  6460, {}},
    { 3700,  6480, {}},
    { 3720,  6500, {}},
    { 3720,  6520, {}},
    { 3720,  6560, {}},
    { 3740,  6560, {}},
    { 3760,  6580, {}},
    { 3740,  6600, {}},
    { 3740,  6620, {}},
    { 3740,  6640, {}},
    { 3740,  6660, {}},
    { 3740,  6680, {}},
    { 3740,  6700, {}},
    { 3720,  6720, {}},
    { 3720,  6740, {}},
    { 3720,  6760, {}},
    { 3700,  6780, {}},
    { 3700,  6800, {}},
    { 3700,  6820, {}},
    { 3720,  6840, {}},
    { 3720,  6860, {}},
    { 3740,  6900, {}},
    { 3720,  6920, {}},
    { 3720,  6940, {}},
    { 3760,  6940, {}},
    { 3760,  6980, {}},
    { 3760,  7000, {}},
    { 3760,  7020, {}},
    { 3780,  7020, {}},
    { 3800,  7040, {}},
    { 3820,  7060, {}},
    { 3840,  7060, {}},
    { 3840,  7080, {}},
    { 3840,  7100, {}},
    { 3840,  7120, {}},
    { 3820,  7140, {}},
    { 3800,  7120, {}},
    { 3800,  7140, {}},
    { 3780,  7160, {}},
    { 3760,  7140, {}},
    { 3740,  7140, {}},
    { 3720,  7140, {}},
    { 3700,  7140, {}},
    { 3680,  7160, {}},
    { 3660,  7180, {}},
    { 3680,  7200, {}},
    { 3700,  7220, {}},
    { 3700,  7240, {}},
    { 3700,  7260, {}},
    { 3720,  7280, {}},
    { 3740,  7300, {}},
    { 3740,  7320, {}},
    { 3740,  7340, {}},
    { 3740,  7360, {}},
    { 3720,  7380, {}},
    { 3720,  7400, {}},
    { 3740,  7420, {}},
    { 3740,  7440, {}},
    { 3740,  7460, {}},
    { 3740,  7480, {}},
    { 3720,  7460, {}},
    { 3700,  7480, {}},
    { 3700,  7500, {}},
    { 3700,  7520, {}},
    { 3700,  7540, {}},
    { 3680,  7540, {}},
    { 3680,  7560, {}},
    { 3680,  7580, {}},
    { 3660,  7600, {}},
    { 3640,  7600, {}},
    { 3620,  7600, {}},
    { 3600,  7600, {}},
    { 3580,  7620, {}},
    { 3580,  7640, {}},
    { 3580,  7660, {}},
    { 3560,  7680, {}},
    { 3540,  7680, {}},
    { 3520,  7700, {}},
    { 3500,  7700, {}},
    { 3500,  7680, {}},
    { 3480,  7660, {}},
    { 3480,  7620, {}},
    { 3460,  7600, {}},
    { 3460,  7580, {}},
    { 3460,  7560, {}},
    { 3460,  7540, {}},
    { 3460,  7520, {}},
    { 3460,  7500, {}},
    { 3460,  7480, {}},
    { 3480,  7460, {}},
    { 3480,  7440, {}},
    { 3460,  7420, {}},
    { 3460,  7400, {}},
    { 3440,  7380, {}},
    { 3420,  7400, {}},
    { 3400,  7420, {}},
    { 3380,  7400, {}},
    { 3360,  7400, {}},
    { 3340,  7420, {}},
    { 3320,  7400, {}},
    { 3300,  7420, {}},
    { 3280,  7440, {}},
    { 3280,  7460, {}},
    { 3260,  7460, {}},
    { 3240,  7480, {}},
    { 3240,  7500, {}},
    { 3240,  7520, {}},
    { 3220,  7540, {}},
    { 3200,  7520, {}},
    { 3200,  7500, {}},
    { 3200,  7480, {}},
    { 3180,  7460, {}},
    { 3160,  7460, {}},
    { 3140,  7460, {}},
    { 3120,  7460, {}},
    { 3100,  7460, {}},
    { 3100,  7440, {}},
    { 3080,  7420, {}},
    { 3060,  7420, {}},
    { 3060,  7400, {}},
    { 3040,  7400, {}},
    { 3020,  7400, {}},
    { 3000,  7360, {}},
    { 3000,  7340, {}},
    { 2980,  7340, {}},
    { 2960,  7320, {}},
    { 2920,  7300, {}},
    { 2900,  7280, {}},
    { 2880,  7240, {}},
    { 2840,  7220, {}},
    { 2820,  7200, {}},
    { 2800,  7180, {}},
    { 2780,  7140, {}},
    { 2780,  7100, {}},
    { 2780,  7080, {}},
    { 2800,  7060, {}},
    { 2800,  7040, {}},
    { 2780,  7020, {}},
    { 2760,  7000, {}},
    { 2740,  6980, {}},
    { 2720,  6960, {}},
    { 2680,  6940, {}},
    { 2660,  6980, {}},
    { 2660,  7000, {}},
    { 2640,  7020, {}},
    { 2620,  7020, {}},
    { 2600,  7000, {}},
    { 2580,  7020, {}},
    { 2560,  7060, {}},
    { 2540,  7060, {}},
    { 2520,  7080, {}},
    { 2500,  7100, {}},
    { 2480,  7100, {}},
    { 2460,  7100, {}},
    { 2440,  7120, {}},
    { 2440,  7100, {}},
    { 2420,  7080, {}},
    { 2420,  7060, {}},
    { 2440,  7060, {}},
    { 2440,  7040, {}},
    { 2440,  7020, {}},
    { 2420,  7000, {}},
    { 2420,  6980, {}},
    { 2420,  6960, {}},
    { 2420,  6940, {}},
    { 2420,  6920, {}},
    { 2420,  6900, {}},
    { 2440,  6880, {}},
    { 2400,  6880, {}},
    { 2400,  6840, {}},
    { 2380,  6820, {}},
    { 2290,  6760, {}},
    { 2200,  6700, {}},
    { 2143,  6601, {}},
    { 2086,  6503, {}},
    { 2029,  6404, {}},
    { 1971,  6306, {}},
    { 1914,  6207, {}},
    { 1857,  6109, {}},
    { 1800,  6010, {}},
    { 1743,  5911, {}},
    { 1686,  5813, {}},
    { 1629,  5714, {}},
    { 1571,  5616, {}},
    { 1514,  5517, {}},
    { 1457,  5419, {}},
    { 1400,  5320, {}},
    { 1369,  5220, {}},
    { 1338,  5120, {}},
    { 1307,  5020, {}},
    { 1276,  4920, {}},
    { 1244,  4820, {}},
    { 1213,  4720, {}},
    { 1182,  4620, {}},
    { 1151,  4520, {}},
    { 1120,  4420, {}},
    { 1193,  4380, {}},
    { 1267,  4340, {}},
    { 1340,  4300, {}},
    { 1360,  4260, {}},
    { 1460,  4200, {}},
    { 1560,  4140, {}},
    { 1660,  4080, {}},
    { 1760,  4020, {}},
    { 1860,  3960, {}},
    { 1958,  3902, {}},
    { 2056,  3844, {}},
    { 2153,  3787, {}},
    { 2251,  3729, {}},
    { 2349,  3671, {}},
    { 2447,  3613, {}},
    { 2544,  3556, {}},
    { 2642,  3498, {}},
    { 2740,  3440, {}},
    { 2800,  3440, {}},
    { 2870,  3460, {}},
    { 2940,  3480, {}},
    { 2940,  3500, {}},
    { 2940,  3520, {}},
    { 2920,  3540, {}},
    { 2920,  3560, {}},
    { 2920,  3600, {}},
    { 2920,  3620, {}},
    { 2940,  3660, {}},
    { 2960,  3660, {}},
    { 2980,  3680, {}},
    { 3000,  3720, {}},
    { 3000,  3740, {}},
    { 3020,  3760, {}},
    { 3060,  3800, {}},
    { 3080,  3780, {}},
    { 3100,  3760, {}},
    { 3160,  3700, {}},
    { 3160,  3740, {}},
    { 3180,  3800, {}},
    { 3180,  3840, {}},
    { 3200,  3900, {}},
    { 3220,  3920, {}},
    { 3240,  3900, {}},
    { 3340,  3880, {}},
    { 3360,  3920, {}},
    { 3380,  3980, {}},
    { 3400,  4020, {}},
    { 3440,  4060, {}},
    { 3440,  4100, {}},
    { 3460,  4120, {}},
    { 3500,  4120, {}},
    { 3520,  4120, {}},
    { 3540,  4120, {}},
    { 3560,  4140, {}},
    { 3580,  4140, {}},
    { 3600,  4120, {}},
    { 3620,  4120, {}},
    { 3640,  4140, {}},
    { 3660,  4160, {}},
    { 3660,  4180, {}},
    { 3680,  4220, {}},
    { 3700,  4240, {}},
    { 3720,  4260, {}},
    { 3740,  4280, {}},
    { 3740,  4300, {}},
    { 3740,  4320, {}},
    { 3720,  4340, {}},
    { 3720,  4360, {}},
    { 3720,  4380, {}},
    { 3740,  4400, {}},
    { 3720,  4420, {}},
    { 3700,  4420, {}},
    { 3700,  4440, {}},
    { 3720,  4460, {}},
    { 3720,  4480, {}},
    { 3740,  4460, {}},
    { 3760,  4460, {}},
    { 3780,  4440, {}},
    { 3800,  4420, {}},
    { 3820,  4440, {}},
    { 3840,  4440, {}},
    { 3860,  4440, {}},
    { 3880,  4440, {}},
    { 3900,  4420, {}},
    { 3920,  4400, {}},
    { 3940,  4400, {}},
    { 3940,  4420, {}},
    { 3940,  4440, {}},
    { 3960,  4440, {}},
    { 3980,  4460, {}},
    { 3960,  4480, {}},
    { 3980,  4460, {}},
    { 4000,  4440, {}},
    { 4000,  4420, {}},
    { 4000,  4400, {}},
    { 4000,  4380, {}},
    { 4020,  4360, {}},
    { 4040,  4360, {}},
    { 4060,  4380, {}},
    { 4080,  4380, {}},
    { 4100,  4360, {}},
    { 4120,  4340, {}},
    { 4120,  4320, {}},
    { 4140,  4300, {}},
    { 4140,  4280, {}},
    { 4160,  4260, {}},
    { 4140,  4240, {}},
    { 4160,  4220, {}},
    { 4160,  4200, {}},
    { 4140,  4180, {}},
    { 4160,  4160, {}},
    { 4180,  4087, {}},
    { 4200,  4013, {}},
    { 4220,  3940, {}},
};

static ZoneVertex cqz22[] = {
    { 2200,  6700, {}},
    { 2280,  6760, {}},
    { 2360,  6820, {}},
    { 2380,  6820, {}},
    { 2400,  6880, {}},
    { 2420,  6880, {}},
    { 2420,  6900, {}},
    { 2420,  6940, {}},
    { 2420,  6980, {}},
    { 2420,  7000, {}},
    { 2440,  7020, {}},
    { 2440,  7040, {}},
    { 2420,  7060, {}},
    { 2420,  7080, {}},
    { 2440,  7100, {}},
    { 2460,  7100, {}},
    { 2480,  7100, {}},
    { 2520,  7080, {}},
    { 2540,  7060, {}},
    { 2560,  7060, {}},
    { 2560,  7040, {}},
    { 2580,  7020, {}},
    { 2600,  7000, {}},
    { 2620,  7020, {}},
    { 2640,  7020, {}},
    { 2660,  7000, {}},
    { 2660,  6980, {}},
    { 2680,  6960, {}},
    { 2700,  6960, {}},
    { 2720,  6960, {}},
    { 2740,  6980, {}},
    { 2760,  7000, {}},
    { 2780,  7020, {}},
    { 2800,  7040, {}},
    { 2800,  7060, {}},
    { 2780,  7080, {}},
    { 2780,  7120, {}},
    { 2780,  7160, {}},
    { 2800,  7180, {}},
    { 2820,  7200, {}},
    { 2840,  7220, {}},
    { 2860,  7220, {}},
    { 2880,  7240, {}},
    { 2900,  7280, {}},
    { 2920,  7300, {}},
    { 2960,  7320, {}},
    { 3000,  7340, {}},
    { 3000,  7380, {}},
    { 3020,  7400, {}},
    { 3040,  7400, {}},
    { 3060,  7400, {}},
    { 3060,  7420, {}},
    { 3080,  7440, {}},
    { 3100,  7460, {}},
    { 3120,  7460, {}},
    { 3140,  7460, {}},
    { 3160,  7460, {}},
    { 3180,  7460, {}},
    { 3200,  7480, {}},
    { 3200,  7500, {}},
    { 3200,  7520, {}},
    { 3220,  7540, {}},
    { 3240,  7520, {}},
    { 3240,  7500, {}},
    { 3240,  7480, {}},
    { 3260,  7460, {}},
    { 3280,  7460, {}},
    { 3300,  7440, {}},
    { 3300,  7420, {}},
    { 3320,  7400, {}},
    { 3340,  7420, {}},
    { 3360,  7400, {}},
    { 3380,  7400, {}},
    { 3380,  7420, {}},
    { 3400,  7420, {}},
    { 3400,  7400, {}},
    { 3420,  7400, {}},
    { 3440,  7380, {}},
    { 3460,  7400, {}},
    { 3480,  7420, {}},
    { 3480,  7440, {}},
    { 3480,  7460, {}},
    { 3460,  7480, {}},
    { 3460,  7500, {}},
    { 3460,  7520, {}},
    { 3460,  7560, {}},
    { 3460,  7580, {}},
    { 3460,  7600, {}},
    { 3460,  7620, {}},
    { 3480,  7640, {}},
    { 3480,  7660, {}},
    { 3500,  7680, {}},
    { 3500,  7700, {}},
    { 3520,  7700, {}},
    { 3540,  7700, {}},
    { 3540,  7680, {}},
    { 3560,  7680, {}},
    { 3560,  7700, {}},
    { 3560,  7720, {}},
    { 3540,  7740, {}},
    { 3540,  7760, {}},
    { 3560,  7780, {}},
    { 3540,  7800, {}},
    { 3520,  7800, {}},
    { 3500,  7820, {}},
    { 3480,  7820, {}},
    { 3460,  7840, {}},
    { 3460,  7860, {}},
    { 3440,  7880, {}},
    { 3440,  7900, {}},
    { 3420,  7900, {}},
    { 3420,  7880, {}},
    { 3400,  7880, {}},
    { 3380,  7880, {}},
    { 3360,  7880, {}},
    { 3340,  7900, {}},
    { 3320,  7920, {}},
    { 3320,  7940, {}},
    { 3300,  7940, {}},
    { 3280,  7940, {}},
    { 3260,  7940, {}},
    { 3260,  7920, {}},
    { 3240,  7920, {}},
    { 3240,  7900, {}},
    { 3240,  7880, {}},
    { 3260,  7880, {}},
    { 3260,  7860, {}},
    { 3260,  7840, {}},
    { 3240,  7840, {}},
    { 3220,  7840, {}},
    { 3200,  7860, {}},
    { 3180,  7880, {}},
    { 3160,  7880, {}},
    { 3140,  7880, {}},
    { 3140,  7900, {}},
    { 3140,  7920, {}},
    { 3120,  7940, {}},
    { 3100,  7960, {}},
    { 3100,  7980, {}},
    { 3080,  8000, {}},
    { 3080,  8020, {}},
    { 3060,  8020, {}},
    { 3060,  8040, {}},
    { 3040,  8060, {}},
    { 3040,  8080, {}},
    { 3020,  8100, {}},
    { 3000,  8120, {}},
    { 3020,  8140, {}},
    { 3040,  8140, {}},
    { 3040,  8160, {}},
    { 3040,  8180, {}},
    { 3040,  8200, {}},
    { 3020,  8220, {}},
    { 3000,  8240, {}},
    { 2980,  8260, {}},
    { 2980,  8280, {}},
    { 2960,  8300, {}},
    { 2960,  8320, {}},
    { 2940,  8340, {}},
    { 2920,  8360, {}},
    { 2940,  8380, {}},
    { 2940,  8400, {}},
    { 2920,  8420, {}},
    { 2900,  8420, {}},
    { 2880,  8440, {}},
    { 2880,  8460, {}},
    { 2860,  8480, {}},
    { 2860,  8500, {}},
    { 2840,  8520, {}},
    { 2840,  8540, {}},
    { 2820,  8560, {}},
    { 2820,  8580, {}},
    { 2800,  8600, {}},
    { 2820,  8620, {}},
    { 2800,  8620, {}},
    { 2800,  8640, {}},
    { 2820,  8660, {}},
    { 2800,  8680, {}},
    { 2800,  8700, {}},
    { 2780,  8720, {}},
    { 2780,  8740, {}},
    { 2780,  8760, {}},
    { 2800,  8780, {}},
    { 2780,  8800, {}},
    { 2800,  8820, {}},
    { 2800,  8840, {}},
    { 2800,  8860, {}},
    { 2800,  8880, {}},
    { 2780,  8880, {}},
    { 2760,  8880, {}},
    { 2740,  8880, {}},
    { 2740,  8900, {}},
    { 2760,  8900, {}},
    { 2780,  8920, {}},
    { 2800,  8940, {}},
    { 2820,  8960, {}},
    { 2820,  8980, {}},
    { 2840,  9000, {}},
    { 2840,  9020, {}},
    { 2820,  9040, {}},
    { 2820,  9060, {}},
    { 2800,  9080, {}},
    { 2800,  9100, {}},
    { 2800,  9120, {}},
    { 2800,  9140, {}},
    { 2780,  9160, {}},
    { 2780,  9180, {}},
    { 2780,  9200, {}},
    { 2780,  9220, {}},
    { 2780,  9240, {}},
    { 2800,  9260, {}},
    { 2820,  9280, {}},
    { 2820,  9300, {}},
    { 2840,  9320, {}},
    { 2860,  9340, {}},
    { 2860,  9360, {}},
    { 2880,  9380, {}},
    { 2880,  9400, {}},
    { 2900,  9420, {}},
    { 2920,  9440, {}},
    { 2920,  9460, {}},
    { 2920,  9480, {}},
    { 2920,  9500, {}},
    { 2920,  9520, {}},
    { 2920,  9540, {}},
    { 2920,  9560, {}},
    { 2940,  9580, {}},
    { 2940,  9600, {}},
    { 2920,  9620, {}},
    { 2900,  9640, {}},
    { 2880,  9660, {}},
    { 2860,  9660, {}},
    { 2860,  9680, {}},
    { 2840,  9680, {}},
    { 2840,  9700, {}},
    { 2840,  9720, {}},
    { 2820,  9740, {}},
    { 2800,  9740, {}},
    { 2780,  9720, {}},
    { 2760,  9700, {}},
    { 2740,  9700, {}},
    { 2720,  9720, {}},
    { 2720,  9700, {}},
    { 2740,  9680, {}},
    { 2740,  9660, {}},
    { 2720,  9640, {}},
    { 2720,  9620, {}},
    { 2720,  9600, {}},
    { 2700,  9580, {}},
    { 2680,  9560, {}},
    { 2660,  9540, {}},
    { 2660,  9520, {}},
    { 2640,  9520, {}},
    { 2620,  9520, {}},
    { 2600,  9520, {}},
    { 2580,  9500, {}},
    { 2560,  9480, {}},
    { 2540,  9460, {}},
    { 2520,  9460, {}},
    { 2500,  9480, {}},
    { 2480,  9460, {}},
    { 2460,  9460, {}},
    { 2440,  9440, {}},
    { 2420,  9420, {}},
    { 2400,  9420, {}},
    { 2400,  9400, {}},
    { 2400,  9380, {}},
    { 2400,  9360, {}},
    { 2400,  9340, {}},
    { 2380,  9340, {}},
    { 2360,  9340, {}},
    { 2340,  9340, {}},
    { 2320,  9340, {}},
    { 2300,  9320, {}},
    { 2280,  9300, {}},
    { 2260,  9320, {}},
    { 2240,  9320, {}},
    { 2220,  9320, {}},
    { 2200,  9300, {}},
    { 2220,  9280, {}},
    { 2200,  9260, {}},
    { 2180,  9260, {}},
    { 2160,  9260, {}},
    { 2140,  9260, {}},
    { 2140,  9240, {}},
    { 2140,  9220, {}},
    { 2120,  9220, {}},
    { 2100,  9220, {}},
    { 2080,  9240, {}},
    { 2053,  9160, {}},
    { 2027,  9080, {}},
    { 2000,  9000, {}},
    { 1900,  9000, {}},
    { 1800,  9000, {}},
    { 1700,  9000, {}},
    { 1600,  9000, {}},
    { 1500,  9000, {}},
    { 1400,  9000, {}},
    { 1300,  9000, {}},
    { 1200,  9000, {}},
    { 1100,  9000, {}},
    { 1000,  9000, {}},
    {  900,  9000, {}},
    {  800,  9000, {}},
    {  700,  9000, {}},
    {  600,  9000, {}},
    {  500,  9000, {}},
    {  400,  9000, {}},
    {  300,  9000, {}},
    {  200,  9000, {}},
    {  100,  9000, {}},
    {    0,  9000, {}},
    { -100,  9000, {}},
    { -200,  9000, {}},
    { -300,  9000, {}},
    { -300,  8900, {}},
    { -300,  8800, {}},
    { -300,  8700, {}},
    { -300,  8600, {}},
    { -300,  8500, {}},
    { -300,  8400, {}},
    { -300,  8300, {}},
    { -300,  8200, {}},
    { -300,  8100, {}},
    { -300,  8000, {}},
    { -300,  7900, {}},
    { -300,  7800, {}},
    { -300,  7700, {}},
    { -300,  7600, {}},
    { -300,  7500, {}},
    { -300,  7400, {}},
    { -300,  7300, {}},
    { -300,  7200, {}},
    { -300,  7100, {}},
    { -300,  7000, {}},
    { -300,  6900, {}},
    { -300,  6800, {}},
    { -300,  6700, {}},
    { -200,  6700, {}},
    { -100,  6700, {}},
    {    0,  6700, {}},
    {  100,  6700, {}},
    {  200,  6700, {}},
    {  300,  6700, {}},
    {  400,  6700, {}},
    {  500,  6700, {}},
    {  600,  6700, {}},
    {  700,  6700, {}},
    {  800,  6700, {}},
    {  900,  6700, {}},
    { 1000,  6700, {}},
    { 1100,  6700, {}},
    { 1200,  6700, {}},
    { 1300,  6700, {}},
    { 1400,  6700, {}},
    { 1500,  6700, {}},
    { 1600,  6700, {}},
    { 1700,  6700, {}},
    { 1800,  6700, {}},
    { 1900,  6700, {}},
    { 2000,  6700, {}},
    { 2100,  6700, {}},
    { 2200,  6700, {}},
};

static ZoneVertex cqz23[] = {
    { 5333, 12147, {}},
    { 5320, 12120, {}},
    { 5320, 12100, {}},
    { 5320, 12080, {}},
    { 5300, 12060, {}},
    { 5300, 12040, {}},
    { 5280, 12020, {}},
    { 5260, 12000, {}},
    { 5260, 12020, {}},
    { 5260, 12040, {}},
    { 5260, 12060, {}},
    { 5240, 12060, {}},
    { 5220, 12080, {}},
    { 5200, 12060, {}},
    { 5180, 12040, {}},
    { 5180, 12020, {}},
    { 5160, 12000, {}},
    { 5140, 12000, {}},
    { 5120, 11980, {}},
    { 5100, 11960, {}},
    { 5080, 11960, {}},
    { 5060, 11940, {}},
    { 5040, 11920, {}},
    { 5020, 11940, {}},
    { 5000, 11920, {}},
    { 5000, 11900, {}},
    { 5000, 11880, {}},
    { 4980, 11860, {}},
    { 4980, 11840, {}},
    { 4960, 11820, {}},
    { 4960, 11800, {}},
    { 4960, 11760, {}},
    { 4960, 11720, {}},
    { 4980, 11680, {}},
    { 5000, 11660, {}},
    { 5000, 11640, {}},
    { 5000, 11620, {}},
    { 5000, 11600, {}},
    { 4980, 11580, {}},
    { 5000, 11560, {}},
    { 5000, 11540, {}},
    { 5000, 11520, {}},
    { 5020, 11500, {}},
    { 5020, 11480, {}},
    { 5020, 11460, {}},
    { 5020, 11440, {}},
    { 5020, 11420, {}},
    { 5020, 11400, {}},
    { 5000, 11380, {}},
    { 5000, 11340, {}},
    { 4980, 11320, {}},
    { 4960, 11300, {}},
    { 4960, 11280, {}},
    { 4960, 11260, {}},
    { 4940, 11220, {}},
    { 4940, 11200, {}},
    { 4940, 11180, {}},
    { 4940, 11160, {}},
    { 4940, 11140, {}},
    { 4920, 11120, {}},
    { 4920, 11100, {}},
    { 4920, 11080, {}},
    { 4920, 11060, {}},
    { 4920, 11040, {}},
    { 4920, 11020, {}},
    { 4920, 11000, {}},
    { 4920, 10960, {}},
    { 4940, 10940, {}},
    { 4940, 10920, {}},
    { 4940, 10900, {}},
    { 4940, 10880, {}},
    { 4940, 10860, {}},
    { 4940, 10840, {}},
    { 4960, 10820, {}},
    { 4960, 10800, {}},
    { 4980, 10800, {}},
    { 5000, 10780, {}},
    { 5000, 10760, {}},
    { 5000, 10740, {}},
    { 5000, 10720, {}},
    { 5020, 10700, {}},
    { 5040, 10680, {}},
    { 5040, 10660, {}},
    { 5040, 10640, {}},
    { 5040, 10620, {}},
    { 5040, 10600, {}},
    { 5040, 10580, {}},
    { 5040, 10560, {}},
    { 5040, 10540, {}},
    { 5040, 10520, {}},
    { 5040, 10500, {}},
    { 5040, 10480, {}},
    { 5040, 10460, {}},
    { 5040, 10440, {}},
    { 5020, 10420, {}},
    { 5020, 10400, {}},
    { 5020, 10380, {}},
    { 5020, 10360, {}},
    { 5020, 10340, {}},
    { 5040, 10320, {}},
    { 5040, 10300, {}},
    { 5040, 10280, {}},
    { 5060, 10260, {}},
    { 5060, 10240, {}},
    { 5080, 10220, {}},
    { 5100, 10220, {}},
    { 5120, 10220, {}},
    { 5140, 10200, {}},
    { 5140, 10180, {}},
    { 5140, 10160, {}},
    { 5140, 10140, {}},
    { 5160, 10120, {}},
    { 5160, 10100, {}},
    { 5160, 10080, {}},
    { 5180, 10060, {}},
    { 5180, 10040, {}},
    { 5180, 10020, {}},
    { 5180, 10000, {}},
    { 5200,  9980, {}},
    { 5200,  9960, {}},
    { 5200,  9940, {}},
    { 5200,  9920, {}},
    { 5200,  9900, {}},
    { 5220,  9900, {}},
    { 5220,  9880, {}},
    { 5240,  9860, {}},
    { 5260,  9880, {}},
    { 5280,  9900, {}},
    { 5280,  9920, {}},
    { 5300,  9920, {}},
    { 5300,  9900, {}},
    { 5320,  9880, {}},
    { 5320,  9860, {}},
    { 5300,  9840, {}},
    { 5320,  9840, {}},
    { 5320,  9820, {}},
    { 5320,  9800, {}},
    { 5340,  9780, {}},
    { 5340,  9760, {}},
    { 5360,  9740, {}},
    { 5360,  9720, {}},
    { 5360,  9700, {}},
    { 5380,  9680, {}},
    { 5360,  9660, {}},
    { 5360,  9640, {}},
    { 5360,  9620, {}},
    { 5340,  9600, {}},
    { 5360,  9580, {}},
    { 5340,  9560, {}},
    { 5340,  9540, {}},
    { 5340,  9520, {}},
    { 5340,  9500, {}},
    { 5340,  9480, {}},
    { 5340,  9460, {}},
    { 5320,  9460, {}},
    { 5300,  9460, {}},
    { 5300,  9440, {}},
    { 5280,  9420, {}},
    { 5260,  9400, {}},
    { 5240,  9380, {}},
    { 5220,  9360, {}},
    { 5220,  9340, {}},
    { 5200,  9320, {}},
    { 5200,  9300, {}},
    { 5180,  9280, {}},
    { 5180,  9260, {}},
    { 5180,  9240, {}},
    { 5180,  9220, {}},
    { 5180,  9200, {}},
    { 5180,  9180, {}},
    { 5180,  9160, {}},
    { 5180,  9140, {}},
    { 5200,  9120, {}},
    { 5200,  9100, {}},
    { 5200,  9080, {}},
    { 5220,  9060, {}},
    { 5220,  9040, {}},
    { 5220,  9020, {}},
    { 5200,  9000, {}},
    { 5180,  9020, {}},
    { 5180,  9000, {}},
    { 5160,  8980, {}},
    { 5160,  8960, {}},
    { 5160,  8940, {}},
    { 5160,  8920, {}},
    { 5160,  8900, {}},
    { 5160,  8880, {}},
    { 5140,  8900, {}},
    { 5120,  8900, {}},
    { 5100,  8920, {}},
    { 5080,  8940, {}},
    { 5060,  8960, {}},
    { 5060,  8980, {}},
    { 5040,  8980, {}},
    { 5040,  8960, {}},
    { 5040,  8940, {}},
    { 5020,  8940, {}},
    { 5000,  8960, {}},
    { 4980,  8960, {}},
    { 4960,  8940, {}},
    { 4960,  8920, {}},
    { 4940,  8900, {}},
    { 4940,  8880, {}},
    { 4960,  8860, {}},
    { 4940,  8840, {}},
    { 4940,  8820, {}},
    { 4920,  8800, {}},
    { 4920,  8780, {}},
    { 4920,  8760, {}},
    { 4900,  8740, {}},
    { 4920,  8720, {}},
    { 4920,  8700, {}},
    { 4900,  8680, {}},
    { 4880,  8680, {}},
    { 4860,  8660, {}},
    { 4840,  8640, {}},
    { 4840,  8600, {}},
    { 4840,  8580, {}},
    { 4820,  8560, {}},
    { 4800,  8560, {}},
    { 4760,  8560, {}},
    { 4740,  8560, {}},
    { 4720,  8560, {}},
    { 4700,  8540, {}},
    { 4700,  8520, {}},
    { 4700,  8500, {}},
    { 4700,  8480, {}},
    { 4700,  8460, {}},
    { 4700,  8440, {}},
    { 4700,  8420, {}},
    { 4700,  8400, {}},
    { 4700,  8380, {}},
    { 4700,  8360, {}},
    { 4720,  8340, {}},
    { 4720,  8320, {}},
    { 4700,  8300, {}},
    { 4660,  8280, {}},
    { 4640,  8260, {}},
    { 4620,  8260, {}},
    { 4600,  8240, {}},
    { 4580,  8240, {}},
    { 4560,  8220, {}},
    { 4540,  8240, {}},
    { 4520,  8240, {}},
    { 4520,  8220, {}},
    { 4520,  8200, {}},
    { 4540,  8180, {}},
    { 4540,  8160, {}},
    { 4520,  8140, {}},
    { 4520,  8120, {}},
    { 4520,  8100, {}},
    { 4520,  8080, {}},
    { 4520,  8060, {}},
    { 4500,  8040, {}},
    { 4500,  8020, {}},
    { 4500,  8000, {}},
    { 4480,  8000, {}},
    { 4480,  8020, {}},
    { 4460,  8040, {}},
    { 4440,  8040, {}},
    { 4420,  8040, {}},
    { 4400,  8040, {}},
    { 4360,  8060, {}},
    { 4340,  8080, {}},
    { 4320,  8080, {}},
    { 4320,  8060, {}},
    { 4300,  8040, {}},
    { 4280,  8020, {}},
    { 4260,  8020, {}},
    { 4240,  8020, {}},
    { 4220,  8020, {}},
    { 4200,  8000, {}},
    { 4180,  7980, {}},
    { 4180,  7960, {}},
    { 4180,  7940, {}},
    { 4180,  7920, {}},
    { 4160,  7900, {}},
    { 4160,  7880, {}},
    { 4140,  7860, {}},
    { 4140,  7840, {}},
    { 4140,  7820, {}},
    { 4120,  7800, {}},
    { 4100,  7780, {}},
    { 4100,  7760, {}},
    { 4100,  7740, {}},
    { 4100,  7720, {}},
    { 4100,  7700, {}},
    { 4100,  7680, {}},
    { 4080,  7680, {}},
    { 4060,  7660, {}},
    { 4040,  7640, {}},
    { 4040,  7620, {}},
    { 4040,  7600, {}},
    { 4040,  7580, {}},
    { 4060,  7560, {}},
    { 4060,  7540, {}},
    { 4040,  7520, {}},
    { 4040,  7500, {}},
    { 4040,  7480, {}},
    { 4020,  7460, {}},
    { 4020,  7440, {}},
    { 4020,  7420, {}},
    { 4000,  7400, {}},
    { 3980,  7380, {}},
    { 3960,  7400, {}},
    { 3940,  7380, {}},
    { 3940,  7360, {}},
    { 3920,  7360, {}},
    { 3900,  7380, {}},
    { 3880,  7380, {}},
    { 3860,  7380, {}},
    { 3860,  7400, {}},
    { 3860,  7420, {}},
    { 3840,  7460, {}},
    { 3820,  7480, {}},
    { 3800,  7500, {}},
    { 3780,  7500, {}},
    { 3760,  7500, {}},
    { 3740,  7520, {}},
    { 3720,  7500, {}},
    { 3720,  7480, {}},
    { 3720,  7460, {}},
    { 3700,  7480, {}},
    { 3700,  7500, {}},
    { 3700,  7520, {}},
    { 3700,  7540, {}},
    { 3680,  7540, {}},
    { 3680,  7560, {}},
    { 3680,  7580, {}},
    { 3660,  7600, {}},
    { 3640,  7600, {}},
    { 3620,  7600, {}},
    { 3600,  7600, {}},
    { 3580,  7620, {}},
    { 3580,  7640, {}},
    { 3580,  7660, {}},
    { 3560,  7680, {}},
    { 3560,  7700, {}},
    { 3560,  7720, {}},
    { 3540,  7740, {}},
    { 3540,  7760, {}},
    { 3560,  7780, {}},
    { 3540,  7800, {}},
    { 3520,  7800, {}},
    { 3500,  7820, {}},
    { 3480,  7820, {}},
    { 3460,  7840, {}},
    { 3460,  7860, {}},
    { 3440,  7880, {}},
    { 3440,  7900, {}},
    { 3420,  7900, {}},
    { 3420,  7880, {}},
    { 3400,  7880, {}},
    { 3380,  7880, {}},
    { 3360,  7880, {}},
    { 3340,  7900, {}},
    { 3320,  7920, {}},
    { 3320,  7940, {}},
    { 3300,  7940, {}},
    { 3280,  7940, {}},
    { 3260,  7940, {}},
    { 3260,  7920, {}},
    { 3240,  7920, {}},
    { 3240,  7900, {}},
    { 3240,  7880, {}},
    { 3260,  7880, {}},
    { 3260,  7860, {}},
    { 3260,  7840, {}},
    { 3240,  7840, {}},
    { 3220,  7840, {}},
    { 3200,  7860, {}},
    { 3180,  7880, {}},
    { 3160,  7880, {}},
    { 3140,  7880, {}},
    { 3140,  7900, {}},
    { 3140,  7920, {}},
    { 3120,  7940, {}},
    { 3100,  7960, {}},
    { 3100,  7980, {}},
    { 3080,  8000, {}},
    { 3080,  8020, {}},
    { 3060,  8020, {}},
    { 3060,  8040, {}},
    { 3040,  8060, {}},
    { 3040,  8080, {}},
    { 3020,  8100, {}},
    { 3000,  8120, {}},
    { 3020,  8140, {}},
    { 3040,  8140, {}},
    { 3040,  8160, {}},
    { 3040,  8180, {}},
    { 3040,  8200, {}},
    { 3020,  8220, {}},
    { 3000,  8240, {}},
    { 2980,  8260, {}},
    { 2980,  8280, {}},
    { 2960,  8300, {}},
    { 2960,  8320, {}},
    { 2940,  8340, {}},
    { 2920,  8360, {}},
    { 2940,  8380, {}},
    { 2940,  8400, {}},
    { 2920,  8420, {}},
    { 2900,  8420, {}},
    { 2880,  8440, {}},
    { 2880,  8460, {}},
    { 2860,  8480, {}},
    { 2860,  8500, {}},
    { 2840,  8520, {}},
    { 2840,  8540, {}},
    { 2820,  8560, {}},
    { 2820,  8580, {}},
    { 2800,  8600, {}},
    { 2820,  8620, {}},
    { 2800,  8620, {}},
    { 2800,  8640, {}},
    { 2820,  8660, {}},
    { 2800,  8680, {}},
    { 2800,  8700, {}},
    { 2780,  8720, {}},
    { 2780,  8740, {}},
    { 2780,  8760, {}},
    { 2800,  8780, {}},
    { 2780,  8800, {}},
    { 2800,  8820, {}},
    { 2800,  8840, {}},
    { 2800,  8860, {}},
    { 2800,  8880, {}},
    { 2780,  8880, {}},
    { 2760,  8880, {}},
    { 2740,  8880, {}},
    { 2740,  8900, {}},
    { 2760,  8900, {}},
    { 2780,  8920, {}},
    { 2800,  8940, {}},
    { 2820,  8960, {}},
    { 2820,  8980, {}},
    { 2840,  9000, {}},
    { 2840,  9020, {}},
    { 2820,  9040, {}},
    { 2820,  9060, {}},
    { 2800,  9080, {}},
    { 2800,  9100, {}},
    { 2800,  9120, {}},
    { 2800,  9140, {}},
    { 2780,  9160, {}},
    { 2780,  9180, {}},
    { 2780,  9200, {}},
    { 2780,  9220, {}},
    { 2780,  9240, {}},
    { 2800,  9260, {}},
    { 2820,  9280, {}},
    { 2820,  9300, {}},
    { 2840,  9320, {}},
    { 2860,  9340, {}},
    { 2860,  9360, {}},
    { 2880,  9380, {}},
    { 2880,  9400, {}},
    { 2900,  9420, {}},
    { 2920,  9440, {}},
    { 2920,  9460, {}},
    { 2920,  9480, {}},
    { 2920,  9500, {}},
    { 2920,  9520, {}},
    { 2920,  9540, {}},
    { 2920,  9560, {}},
    { 2940,  9580, {}},
    { 2940,  9600, {}},
    { 2920,  9620, {}},
    { 2900,  9640, {}},
    { 2880,  9660, {}},
    { 2860,  9660, {}},
    { 2860,  9680, {}},
    { 2840,  9680, {}},
    { 2840,  9700, {}},
    { 2840,  9720, {}},
    { 2820,  9740, {}},
    { 2840,  9760, {}},
    { 2840,  9780, {}},
    { 2820,  9800, {}},
    { 2820,  9820, {}},
    { 2820,  9840, {}},
    { 2820,  9860, {}},
    { 2840,  9860, {}},
    { 2860,  9860, {}},
    { 2880,  9860, {}},
    { 2900,  9880, {}},
    { 2900,  9900, {}},
    { 2920,  9900, {}},
    { 2960,  9900, {}},
    { 2980,  9900, {}},
    { 3000,  9900, {}},
    { 3020,  9900, {}},
    { 3040,  9900, {}},
    { 3060,  9900, {}},
    { 3080,  9880, {}},
    { 3100,  9880, {}},
    { 3120,  9860, {}},
    { 3120,  9880, {}},
    { 3140,  9880, {}},
    { 3160,  9860, {}},
    { 3180,  9840, {}},
    { 3200,  9840, {}},
    { 3220,  9820, {}},
    { 3240,  9800, {}},
    { 3260,  9780, {}},
    { 3260,  9760, {}},
    { 3280,  9740, {}},
    { 3300,  9760, {}},
    { 3320,  9760, {}},
    { 3340,  9780, {}},
    { 3340,  9760, {}},
    { 3360,  9740, {}},
    { 3380,  9740, {}},
    { 3400,  9760, {}},
    { 3420,  9780, {}},
    { 3420,  9800, {}},
    { 3400,  9820, {}},
    { 3400,  9840, {}},
    { 3380,  9840, {}},
    { 3360,  9860, {}},
    { 3340,  9880, {}},
    { 3320,  9880, {}},
    { 3300,  9900, {}},
    { 3300,  9920, {}},
    { 3280,  9940, {}},
    { 3280,  9980, {}},
    { 3300,  9980, {}},
    { 3300, 10000, {}},
    { 3280, 10020, {}},
    { 3280, 10040, {}},
    { 3260, 10060, {}},
    { 3260, 10100, {}},
    { 3280, 10120, {}},
    { 3300, 10120, {}},
    { 3320, 10120, {}},
    { 3320, 10140, {}},
    { 3300, 10160, {}},
    { 3320, 10160, {}},
    { 3340, 10160, {}},
    { 3360, 10180, {}},
    { 3340, 10180, {}},
    { 3320, 10180, {}},
    { 3320, 10200, {}},
    { 3320, 10220, {}},
    { 3340, 10220, {}},
    { 3340, 10240, {}},
    { 3360, 10240, {}},
    { 3380, 10220, {}},
    { 3400, 10240, {}},
    { 3420, 10260, {}},
    { 3420, 10280, {}},
    { 3420, 10320, {}},
    { 3400, 10320, {}},
    { 3380, 10320, {}},
    { 3380, 10340, {}},
    { 3360, 10380, {}},
    { 3360, 10400, {}},
    { 3340, 10420, {}},
    { 3340, 10440, {}},
    { 3320, 10440, {}},
    { 3300, 10440, {}},
    { 3280, 10440, {}},
    { 3260, 10460, {}},
    { 3260, 10480, {}},
    { 3260, 10500, {}},
    { 3260, 10520, {}},
    { 3280, 10540, {}},
    { 3280, 10560, {}},
    { 3300, 10580, {}},
    { 3320, 10600, {}},
    { 3320, 10580, {}},
    { 3340, 10580, {}},
    { 3360, 10600, {}},
    { 3360, 10620, {}},
    { 3360, 10640, {}},
    { 3380, 10640, {}},
    { 3400, 10640, {}},
    { 3420, 10660, {}},
    { 3440, 10660, {}},
    { 3460, 10640, {}},
    { 3480, 10660, {}},
    { 3500, 10660, {}},
    { 3500, 10680, {}},
    { 3500, 10700, {}},
    { 3480, 10720, {}},
    { 3500, 10760, {}},
    { 3500, 10780, {}},
    { 3520, 10760, {}},
    { 3520, 10780, {}},
    { 3520, 10800, {}},
    { 3520, 10820, {}},
    { 3520, 10840, {}},
    { 3540, 10860, {}},
    { 3560, 10860, {}},
    { 3580, 10860, {}},
    { 3600, 10860, {}},
    { 3620, 10860, {}},
    { 3640, 10860, {}},
    { 3660, 10840, {}},
    { 3660, 10820, {}},
    { 3660, 10800, {}},
    { 3680, 10760, {}},
    { 3700, 10740, {}},
    { 3720, 10720, {}},
    { 3740, 10720, {}},
    { 3760, 10740, {}},
    { 3780, 10760, {}},
    { 3780, 10800, {}},
    { 3760, 10820, {}},
    { 3760, 10840, {}},
    { 3760, 10860, {}},
    { 3780, 10880, {}},
    { 3800, 10880, {}},
    { 3800, 10900, {}},
    { 3820, 10900, {}},
    { 3840, 10900, {}},
    { 3860, 10920, {}},
    { 3880, 10940, {}},
    { 3880, 10960, {}},
    { 3920, 10980, {}},
    { 3920, 11000, {}},
    { 3920, 11020, {}},
    { 3940, 11020, {}},
    { 3940, 11040, {}},
    { 3920, 11060, {}},
    { 3960, 11080, {}},
    { 3960, 11100, {}},
    { 3940, 11120, {}},
    { 3960, 11140, {}},
    { 3960, 11160, {}},
    { 3960, 11180, {}},
    { 3980, 11200, {}},
    { 4020, 11220, {}},
    { 4040, 11240, {}},
    { 4020, 11260, {}},
    { 4020, 11280, {}},
    { 4040, 11320, {}},
    { 4040, 11360, {}},
    { 4040, 11380, {}},
    { 4060, 11400, {}},
    { 4080, 11420, {}},
    { 4100, 11400, {}},
    { 4120, 11400, {}},
    { 4140, 11380, {}},
    { 4160, 11400, {}},
    { 4160, 11420, {}},
    { 4200, 11440, {}},
    { 4220, 11460, {}},
    { 4220, 11480, {}},
    { 4180, 11500, {}},
    { 4160, 11480, {}},
    { 4160, 11500, {}},
    { 4160, 11520, {}},
    { 4180, 11540, {}},
    { 4180, 11560, {}},
    { 4200, 11580, {}},
    { 4180, 11600, {}},
    { 4180, 11620, {}},
    { 4200, 11640, {}},
    { 4200, 11680, {}},
    { 4220, 11700, {}},
    { 4240, 11700, {}},
    { 4240, 11720, {}},
    { 4240, 11740, {}},
    { 4260, 11740, {}},
    { 4260, 11760, {}},
    { 4260, 11780, {}},
    { 4240, 11800, {}},
    { 4220, 11820, {}},
    { 4200, 11840, {}},
    { 4180, 11820, {}},
    { 4160, 11820, {}},
    { 4140, 11840, {}},
    { 4140, 11860, {}},
    { 4140, 11880, {}},
    { 4120, 11920, {}},
    { 4140, 11940, {}},
    { 4160, 11940, {}},
    { 4200, 11940, {}},
    { 4220, 11920, {}},
    { 4240, 11940, {}},
    { 4220, 11960, {}},
    { 4220, 11980, {}},
    { 4200, 12000, {}},
    { 4180, 12000, {}},
    { 4180, 12020, {}},
    { 4200, 12040, {}},
    { 4220, 12060, {}},
    { 4220, 12100, {}},
    { 4240, 12120, {}},
    { 4240, 12140, {}},
    { 4240, 12160, {}},
    { 4260, 12180, {}},
    { 4280, 12200, {}},
    { 4280, 12220, {}},
    { 4260, 12240, {}},
    { 4280, 12240, {}},
    { 4280, 12260, {}},
    { 4280, 12280, {}},
    { 4280, 12300, {}},
    { 4280, 12320, {}},
    { 4300, 12340, {}},
    { 4320, 12360, {}},
    { 4340, 12360, {}},
    { 4340, 12340, {}},
    { 4360, 12340, {}},
    { 4380, 12340, {}},
    { 4400, 12340, {}},
    { 4420, 12320, {}},
    { 4440, 12320, {}},
    { 4440, 12280, {}},
    { 4420, 12240, {}},
    { 4440, 12220, {}},
    { 4460, 12220, {}},
    { 4500, 12200, {}},
    { 4520, 12220, {}},
    { 4540, 12220, {}},
    { 4560, 12200, {}},
    { 4580, 12180, {}},
    { 4600, 12180, {}},
    { 4600, 12200, {}},
    { 4580, 12220, {}},
    { 4600, 12240, {}},
    { 4580, 12260, {}},
    { 4580, 12280, {}},
    { 4600, 12280, {}},
    { 4600, 12300, {}},
    { 4620, 12320, {}},
    { 4640, 12300, {}},
    { 4660, 12300, {}},
    { 4660, 12320, {}},
    { 4660, 12360, {}},
    { 4680, 12360, {}},
    { 4680, 12340, {}},
    { 4680, 12320, {}},
    { 4680, 12300, {}},
    { 4700, 12280, {}},
    { 4720, 12260, {}},
    { 4760, 12260, {}},
    { 4760, 12280, {}},
    { 4780, 12300, {}},
    { 4780, 12320, {}},
    { 4800, 12360, {}},
    { 4840, 12400, {}},
    { 4860, 12420, {}},
    { 4840, 12440, {}},
    { 4820, 12440, {}},
    { 4840, 12460, {}},
    { 4860, 12460, {}},
    { 4880, 12460, {}},
    { 4900, 12480, {}},
    { 4920, 12500, {}},
    { 4920, 12520, {}},
    { 4940, 12520, {}},
    { 4960, 12520, {}},
    { 4980, 12520, {}},
    { 5000, 12520, {}},
    { 5020, 12540, {}},
    { 5040, 12560, {}},
    { 5060, 12580, {}},
    { 5080, 12600, {}},
    { 5100, 12600, {}},
    { 5120, 12580, {}},
    { 5140, 12560, {}},
    { 5160, 12540, {}},
    { 5160, 12520, {}},
    { 5140, 12500, {}},
    { 5140, 12480, {}},
    { 5140, 12460, {}},
    { 5140, 12420, {}},
    { 5140, 12400, {}},
    { 5140, 12380, {}},
    { 5120, 12320, {}},
    { 5140, 12300, {}},
    { 5160, 12280, {}},
    { 5180, 12280, {}},
    { 5200, 12260, {}},
    { 5220, 12280, {}},
    { 5220, 12260, {}},
    { 5240, 12240, {}},
    { 5260, 12220, {}},
    { 5240, 12200, {}},
    { 5240, 12180, {}},
    { 5240, 12160, {}},
    { 5260, 12140, {}},
    { 5260, 12120, {}},
    { 5280, 12140, {}},
    { 5280, 12160, {}},
    { 5300, 12180, {}},
    { 5320, 12160, {}},
};

static ZoneVertex cqz24[] = {
    { 2816,  9817, {}},
    { 2840,  9820, {}},
    { 2820,  9840, {}},
    { 2820,  9860, {}},
    { 2840,  9860, {}},
    { 2860,  9860, {}},
    { 2880,  9860, {}},
    { 2900,  9880, {}},
    { 2900,  9900, {}},
    { 2920,  9900, {}},
    { 2960,  9900, {}},
    { 2980,  9900, {}},
    { 3000,  9900, {}},
    { 3020,  9900, {}},
    { 3040,  9900, {}},
    { 3060,  9900, {}},
    { 3080,  9880, {}},
    { 3100,  9880, {}},
    { 3120,  9860, {}},
    { 3120,  9880, {}},
    { 3140,  9880, {}},
    { 3160,  9860, {}},
    { 3180,  9840, {}},
    { 3200,  9840, {}},
    { 3220,  9820, {}},
    { 3240,  9800, {}},
    { 3260,  9780, {}},
    { 3260,  9760, {}},
    { 3280,  9740, {}},
    { 3300,  9760, {}},
    { 3320,  9760, {}},
    { 3340,  9780, {}},
    { 3340,  9760, {}},
    { 3360,  9740, {}},
    { 3380,  9740, {}},
    { 3400,  9760, {}},
    { 3420,  9780, {}},
    { 3420,  9800, {}},
    { 3400,  9820, {}},
    { 3400,  9840, {}},
    { 3380,  9840, {}},
    { 3360,  9860, {}},
    { 3340,  9880, {}},
    { 3320,  9880, {}},
    { 3300,  9900, {}},
    { 3300,  9920, {}},
    { 3280,  9940, {}},
    { 3280,  9980, {}},
    { 3300,  9980, {}},
    { 3300, 10000, {}},
    { 3280, 10020, {}},
    { 3280, 10040, {}},
    { 3260, 10060, {}},
    { 3260, 10100, {}},
    { 3280, 10120, {}},
    { 3300, 10120, {}},
    { 3320, 10120, {}},
    { 3320, 10140, {}},
    { 3300, 10160, {}},
    { 3320, 10160, {}},
    { 3340, 10160, {}},
    { 3360, 10180, {}},
    { 3340, 10180, {}},
    { 3320, 10180, {}},
    { 3320, 10200, {}},
    { 3320, 10220, {}},
    { 3340, 10220, {}},
    { 3340, 10240, {}},
    { 3360, 10240, {}},
    { 3380, 10220, {}},
    { 3400, 10240, {}},
    { 3420, 10260, {}},
    { 3420, 10280, {}},
    { 3420, 10320, {}},
    { 3400, 10320, {}},
    { 3380, 10320, {}},
    { 3380, 10340, {}},
    { 3360, 10380, {}},
    { 3360, 10400, {}},
    { 3340, 10420, {}},
    { 3340, 10440, {}},
    { 3320, 10440, {}},
    { 3300, 10440, {}},
    { 3280, 10440, {}},
    { 3260, 10460, {}},
    { 3260, 10480, {}},
    { 3260, 10500, {}},
    { 3260, 10520, {}},
    { 3280, 10540, {}},
    { 3280, 10560, {}},
    { 3300, 10580, {}},
    { 3320, 10600, {}},
    { 3320, 10580, {}},
    { 3340, 10580, {}},
    { 3360, 10600, {}},
    { 3360, 10620, {}},
    { 3360, 10640, {}},
    { 3380, 10640, {}},
    { 3400, 10640, {}},
    { 3420, 10660, {}},
    { 3440, 10660, {}},
    { 3460, 10640, {}},
    { 3480, 10660, {}},
    { 3500, 10660, {}},
    { 3500, 10680, {}},
    { 3500, 10700, {}},
    { 3480, 10720, {}},
    { 3500, 10760, {}},
    { 3500, 10780, {}},
    { 3520, 10760, {}},
    { 3520, 10780, {}},
    { 3520, 10800, {}},
    { 3520, 10820, {}},
    { 3520, 10840, {}},
    { 3540, 10860, {}},
    { 3560, 10860, {}},
    { 3580, 10860, {}},
    { 3600, 10860, {}},
    { 3620, 10860, {}},
    { 3640, 10860, {}},
    { 3660, 10840, {}},
    { 3660, 10820, {}},
    { 3660, 10800, {}},
    { 3680, 10760, {}},
    { 3700, 10740, {}},
    { 3720, 10720, {}},
    { 3740, 10720, {}},
    { 3760, 10740, {}},
    { 3780, 10760, {}},
    { 3780, 10800, {}},
    { 3760, 10820, {}},
    { 3760, 10840, {}},
    { 3760, 10860, {}},
    { 3780, 10880, {}},
    { 3800, 10880, {}},
    { 3800, 10900, {}},
    { 3820, 10900, {}},
    { 3840, 10900, {}},
    { 3860, 10920, {}},
    { 3880, 10940, {}},
    { 3880, 10960, {}},
    { 3920, 10980, {}},
    { 3920, 11000, {}},
    { 3920, 11020, {}},
    { 3940, 11020, {}},
    { 3940, 11040, {}},
    { 3920, 11060, {}},
    { 3960, 11080, {}},
    { 3960, 11100, {}},
    { 3940, 11120, {}},
    { 3960, 11140, {}},
    { 3960, 11160, {}},
    { 3960, 11180, {}},
    { 3980, 11200, {}},
    { 4020, 11220, {}},
    { 4040, 11240, {}},
    { 4020, 11260, {}},
    { 4020, 11280, {}},
    { 4040, 11320, {}},
    { 4040, 11360, {}},
    { 4040, 11380, {}},
    { 4060, 11400, {}},
    { 4080, 11420, {}},
    { 4100, 11400, {}},
    { 4120, 11400, {}},
    { 4140, 11380, {}},
    { 4160, 11400, {}},
    { 4160, 11420, {}},
    { 4200, 11440, {}},
    { 4220, 11460, {}},
    { 4220, 11480, {}},
    { 4180, 11500, {}},
    { 4160, 11480, {}},
    { 4160, 11500, {}},
    { 4160, 11520, {}},
    { 4180, 11540, {}},
    { 4180, 11560, {}},
    { 4200, 11580, {}},
    { 4180, 11600, {}},
    { 4180, 11620, {}},
    { 4200, 11640, {}},
    { 4200, 11680, {}},
    { 4220, 11700, {}},
    { 4240, 11700, {}},
    { 4240, 11720, {}},
    { 4240, 11740, {}},
    { 4260, 11740, {}},
    { 4260, 11760, {}},
    { 4260, 11780, {}},
    { 4240, 11800, {}},
    { 4220, 11820, {}},
    { 4200, 11840, {}},
    { 4180, 11820, {}},
    { 4160, 11820, {}},
    { 4140, 11840, {}},
    { 4140, 11860, {}},
    { 4140, 11880, {}},
    { 4120, 11920, {}},
    { 4140, 11940, {}},
    { 4160, 11940, {}},
    { 4200, 11940, {}},
    { 4220, 11920, {}},
    { 4240, 11940, {}},
    { 4220, 11960, {}},
    { 4220, 11980, {}},
    { 4200, 12000, {}},
    { 4180, 12000, {}},
    { 4180, 12020, {}},
    { 4200, 12040, {}},
    { 4220, 12060, {}},
    { 4220, 12100, {}},
    { 4240, 12120, {}},
    { 4240, 12140, {}},
    { 4240, 12160, {}},
    { 4260, 12180, {}},
    { 4280, 12200, {}},
    { 4280, 12220, {}},
    { 4260, 12240, {}},
    { 4280, 12240, {}},
    { 4280, 12260, {}},
    { 4280, 12280, {}},
    { 4280, 12300, {}},
    { 4280, 12320, {}},
    { 4300, 12340, {}},
    { 4320, 12360, {}},
    { 4340, 12360, {}},
    { 4340, 12340, {}},
    { 4360, 12340, {}},
    { 4380, 12340, {}},
    { 4400, 12340, {}},
    { 4420, 12320, {}},
    { 4440, 12320, {}},
    { 4440, 12280, {}},
    { 4420, 12240, {}},
    { 4440, 12220, {}},
    { 4460, 12220, {}},
    { 4500, 12200, {}},
    { 4520, 12220, {}},
    { 4540, 12220, {}},
    { 4560, 12200, {}},
    { 4580, 12180, {}},
    { 4600, 12180, {}},
    { 4600, 12200, {}},
    { 4580, 12220, {}},
    { 4600, 12240, {}},
    { 4580, 12260, {}},
    { 4580, 12280, {}},
    { 4600, 12280, {}},
    { 4600, 12300, {}},
    { 4620, 12320, {}},
    { 4640, 12300, {}},
    { 4660, 12300, {}},
    { 4660, 12320, {}},
    { 4660, 12360, {}},
    { 4680, 12360, {}},
    { 4680, 12340, {}},
    { 4680, 12320, {}},
    { 4680, 12300, {}},
    { 4700, 12280, {}},
    { 4720, 12260, {}},
    { 4760, 12260, {}},
    { 4760, 12280, {}},
    { 4780, 12300, {}},
    { 4780, 12320, {}},
    { 4800, 12360, {}},
    { 4840, 12400, {}},
    { 4860, 12420, {}},
    { 4840, 12440, {}},
    { 4820, 12440, {}},
    { 4840, 12460, {}},
    { 4860, 12460, {}},
    { 4880, 12460, {}},
    { 4900, 12480, {}},
    { 4920, 12500, {}},
    { 4920, 12520, {}},
    { 4940, 12520, {}},
    { 4960, 12520, {}},
    { 4980, 12520, {}},
    { 5000, 12520, {}},
    { 5020, 12540, {}},
    { 5040, 12560, {}},
    { 5060, 12580, {}},
    { 5080, 12600, {}},
    { 5100, 12600, {}},
    { 5120, 12580, {}},
    { 5140, 12560, {}},
    { 5160, 12540, {}},
    { 5160, 12520, {}},
    { 5140, 12500, {}},
    { 5140, 12480, {}},
    { 5140, 12460, {}},
    { 5140, 12420, {}},
    { 5140, 12400, {}},
    { 5140, 12380, {}},
    { 5120, 12320, {}},
    { 5140, 12300, {}},
    { 5160, 12280, {}},
    { 5180, 12280, {}},
    { 5200, 12260, {}},
    { 5220, 12280, {}},
    { 5220, 12260, {}},
    { 5240, 12240, {}},
    { 5260, 12220, {}},
    { 5240, 12200, {}},
    { 5240, 12180, {}},
    { 5240, 12160, {}},
    { 5260, 12140, {}},
    { 5260, 12120, {}},
    { 5280, 12140, {}},
    { 5280, 12160, {}},
    { 5300, 12180, {}},
    { 5320, 12160, {}},
    { 5340, 12180, {}},
    { 5340, 12200, {}},
    { 5340, 12220, {}},
    { 5340, 12240, {}},
    { 5340, 12260, {}},
    { 5340, 12280, {}},
    { 5340, 12300, {}},
    { 5360, 12320, {}},
    { 5360, 12340, {}},
    { 5360, 12360, {}},
    { 5340, 12380, {}},
    { 5340, 12400, {}},
    { 5340, 12420, {}},
    { 5320, 12440, {}},
    { 5320, 12460, {}},
    { 5320, 12480, {}},
    { 5320, 12500, {}},
    { 5320, 12520, {}},
    { 5320, 12540, {}},
    { 5300, 12560, {}},
    { 5280, 12580, {}},
    { 5280, 12600, {}},
    { 5260, 12600, {}},
    { 5260, 12620, {}},
    { 5240, 12640, {}},
    { 5220, 12640, {}},
    { 5200, 12640, {}},
    { 5180, 12660, {}},
    { 5160, 12660, {}},
    { 5160, 12680, {}},
    { 5140, 12700, {}},
    { 5120, 12680, {}},
    { 5100, 12700, {}},
    { 5080, 12720, {}},
    { 5060, 12740, {}},
    { 5040, 12740, {}},
    { 5020, 12760, {}},
    { 5000, 12740, {}},
    { 4980, 12760, {}},
    { 4960, 12780, {}},
    { 4960, 12800, {}},
    { 4960, 12820, {}},
    { 4960, 12840, {}},
    { 4960, 12860, {}},
    { 4940, 12880, {}},
    { 4940, 12900, {}},
    { 4940, 12920, {}},
    { 4940, 12940, {}},
    { 4920, 12960, {}},
    { 4920, 12980, {}},
    { 4900, 13000, {}},
    { 4880, 13020, {}},
    { 4900, 13040, {}},
    { 4880, 13060, {}},
    { 4860, 13060, {}},
    { 4840, 13080, {}},
    { 4820, 13080, {}},
    { 4800, 13080, {}},
    { 4780, 13100, {}},
    { 4780, 13120, {}},
    { 4780, 13140, {}},
    { 4760, 13160, {}},
    { 4760, 13180, {}},
    { 4780, 13200, {}},
    { 4780, 13220, {}},
    { 4780, 13240, {}},
    { 4780, 13260, {}},
    { 4800, 13280, {}},
    { 4820, 13300, {}},
    { 4800, 13320, {}},
    { 4800, 13340, {}},
    { 4820, 13360, {}},
    { 4820, 13380, {}},
    { 4820, 13400, {}},
    { 4840, 13420, {}},
    { 4840, 13440, {}},
    { 4840, 13460, {}},
    { 4820, 13460, {}},
    { 4800, 13460, {}},
    { 4780, 13480, {}},
    { 4760, 13460, {}},
    { 4740, 13440, {}},
    { 4740, 13420, {}},
    { 4720, 13420, {}},
    { 4700, 13400, {}},
    { 4680, 13400, {}},
    { 4660, 13400, {}},
    { 4640, 13400, {}},
    { 4620, 13380, {}},
    { 4600, 13360, {}},
    { 4580, 13340, {}},
    { 4560, 13340, {}},
    { 4560, 13320, {}},
    { 4540, 13320, {}},
    { 4520, 13320, {}},
    { 4500, 13300, {}},
    { 4520, 13200, {}},
    { 4520, 13180, {}},
    { 4500, 13160, {}},
    { 4500, 13140, {}},
    { 4500, 13120, {}},
    { 4480, 13100, {}},
    { 4400, 13140, {}},
    { 4360, 13120, {}},
    { 4340, 13140, {}},
    { 4320, 13120, {}},
    { 4300, 13120, {}},
    { 4280, 13100, {}},
    { 4280, 13080, {}},
    { 4280, 13060, {}},
    { 4280, 13040, {}},
    { 4260, 13060, {}},
    { 4260, 13040, {}},
    { 4280, 13020, {}},
    { 4300, 13000, {}},
    { 4280, 12980, {}},
    { 4260, 12980, {}},
    { 4240, 12960, {}},
    { 4240, 12940, {}},
    { 4240, 12920, {}},
    { 4220, 12920, {}},
    { 4200, 12900, {}},
    { 4200, 12880, {}},
    { 4200, 12860, {}},
    { 4200, 12820, {}},
    { 4180, 12820, {}},
    { 4160, 12840, {}},
    { 4140, 12820, {}},
    { 4140, 12800, {}},
    { 4140, 12780, {}},
    { 4140, 12760, {}},
    { 4140, 12740, {}},
    { 4160, 12720, {}},
    { 4180, 12700, {}},
    { 4180, 12680, {}},
    { 4160, 12660, {}},
    { 4140, 12660, {}},
    { 4140, 12640, {}},
    { 4120, 12640, {}},
    { 4120, 12620, {}},
    { 4100, 12600, {}},
    { 4080, 12580, {}},
    { 4080, 12560, {}},
    { 4060, 12540, {}},
    { 4060, 12520, {}},
    { 4040, 12500, {}},
    { 4040, 12480, {}},
    { 4020, 12460, {}},
    { 4020, 12440, {}},
    { 4000, 12440, {}},
    { 3980, 12420, {}},
    { 3900, 12400, {}},
    { 3800, 12400, {}},
    { 3700, 12400, {}},
    { 3600, 12400, {}},
    { 3500, 12400, {}},
    { 3400, 12400, {}},
    { 3300, 12400, {}},
    { 3200, 12400, {}},
    { 3100, 12400, {}},
    { 3000, 12400, {}},
    { 2900, 12373, {}},
    { 2800, 12345, {}},
    { 2700, 12318, {}},
    { 2600, 12290, {}},
    { 2500, 12263, {}},
    { 2400, 12235, {}},
    { 2300, 12208, {}},
    { 2200, 12180, {}},
    { 2103, 12111, {}},
    { 2006, 12043, {}},
    { 1909, 11974, {}},
    { 1811, 11906, {}},
    { 1714, 11837, {}},
    { 1617, 11769, {}},
    { 1520, 11700, {}},
    { 1520, 11600, {}},
    { 1520, 11500, {}},
    { 1520, 11400, {}},
    { 1520, 11300, {}},
    { 1520, 11200, {}},
    { 1520, 11100, {}},
    { 1520, 11000, {}},
    { 1613, 10940, {}},
    { 1707, 10880, {}},
    { 1800, 10820, {}},
    { 1885, 10820, {}},
    { 1970, 10820, {}},
    { 2055, 10820, {}},
    { 2140, 10820, {}},
    { 2160, 10800, {}},
    { 2160, 10780, {}},
    { 2160, 10760, {}},
    { 2160, 10740, {}},
    { 2180, 10720, {}},
    { 2200, 10700, {}},
    { 2200, 10680, {}},
    { 2220, 10660, {}},
    { 2240, 10660, {}},
    { 2260, 10660, {}},
    { 2280, 10680, {}},
    { 2300, 10660, {}},
    { 2280, 10640, {}},
    { 2300, 10620, {}},
    { 2300, 10600, {}},
    { 2300, 10580, {}},
    { 2300, 10560, {}},
    { 2320, 10540, {}},
    { 2320, 10520, {}},
    { 2320, 10500, {}},
    { 2300, 10480, {}},
    { 2280, 10460, {}},
    { 2280, 10440, {}},
    { 2280, 10420, {}},
    { 2260, 10400, {}},
    { 2260, 10380, {}},
    { 2260, 10360, {}},
    { 2280, 10340, {}},
    { 2260, 10320, {}},
    { 2240, 10300, {}},
    { 2260, 10280, {}},
    { 2280, 10260, {}},
    { 2260, 10240, {}},
    { 2240, 10220, {}},
    { 2240, 10200, {}},
    { 2240, 10180, {}},
    { 2220, 10160, {}},
    { 2200, 10160, {}},
    { 2180, 10180, {}},
    { 2160, 10180, {}},
    { 2140, 10180, {}},
    { 2120, 10180, {}},
    { 2120, 10160, {}},
    { 2120, 10140, {}},
    { 2140, 10120, {}},
    { 2160, 10120, {}},
    { 2160, 10100, {}},
    { 2160, 10080, {}},
    { 2140, 10060, {}},
    { 2160, 10040, {}},
    { 2160, 10020, {}},
    { 2180, 10000, {}},
    { 2200, 10000, {}},
    { 2200,  9980, {}},
    { 2220,  9960, {}},
    { 2200,  9940, {}},
    { 2220,  9920, {}},
    { 2240,  9920, {}},
    { 2260,  9940, {}},
    { 2280,  9940, {}},
    { 2300,  9960, {}},
    { 2320,  9940, {}},
    { 2320,  9920, {}},
    { 2320,  9900, {}},
    { 2340,  9900, {}},
    { 2360,  9880, {}},
    { 2380,  9860, {}},
    { 2400,  9880, {}},
    { 2400,  9860, {}},
    { 2420,  9840, {}},
    { 2420,  9820, {}},
    { 2400,  9800, {}},
    { 2400,  9780, {}},
    { 2380,  9760, {}},
    { 2400,  9760, {}},
    { 2420,  9780, {}},
    { 2440,  9760, {}},
    { 2460,  9760, {}},
    { 2480,  9760, {}},
    { 2500,  9780, {}},
    { 2520,  9780, {}},
    { 2520,  9800, {}},
    { 2540,  9820, {}},
    { 2560,  9820, {}},
    { 2560,  9840, {}},
    { 2580,  9840, {}},
    { 2580,  9860, {}},
    { 2600,  9860, {}},
    { 2620,  9880, {}},
    { 2640,  9880, {}},
    { 2660,  9880, {}},
    { 2680,  9880, {}},
    { 2700,  9880, {}},
    { 2720,  9860, {}},
    { 2740,  9880, {}},
    { 2760,  9860, {}},
    { 2760,  9840, {}},
    { 2780,  9820, {}},
    { 2800,  9820, {}},
};

static ZoneVertex cqz25[] = {
    { 3900, 12400, {}},
    { 3800, 12400, {}},
    { 3700, 12400, {}},
    { 3600, 12400, {}},
    { 3500, 12400, {}},
    { 3400, 12400, {}},
    { 3300, 12400, {}},
    { 3200, 12400, {}},
    { 3100, 12400, {}},
    { 3000, 12400, {}},
    { 2900, 12373, {}},
    { 2800, 12345, {}},
    { 2700, 12318, {}},
    { 2600, 12290, {}},
    { 2500, 12263, {}},
    { 2400, 12235, {}},
    { 2300, 12208, {}},
    { 2200, 12180, {}},
    { 2200, 12271, {}},
    { 2200, 12362, {}},
    { 2200, 12453, {}},
    { 2200, 12544, {}},
    { 2200, 12636, {}},
    { 2200, 12727, {}},
    { 2200, 12818, {}},
    { 2200, 12909, {}},
    { 2200, 13000, {}},
    { 2260, 13100, {}},
    { 2320, 13200, {}},
    { 2380, 13300, {}},
    { 2440, 13400, {}},
    { 2500, 13500, {}},
    { 2560, 13600, {}},
    { 2620, 13700, {}},
    { 2680, 13800, {}},
    { 2740, 13900, {}},
    { 2800, 14000, {}},
    { 2860, 14100, {}},
    { 2920, 14200, {}},
    { 2980, 14300, {}},
    { 3040, 14400, {}},
    { 3100, 14500, {}},
    { 3160, 14600, {}},
    { 3220, 14700, {}},
    { 3280, 14800, {}},
    { 3340, 14900, {}},
    { 3400, 15000, {}},
    { 3460, 15100, {}},
    { 3520, 15200, {}},
    { 3580, 15300, {}},
    { 3640, 15400, {}},
    { 3700, 15500, {}},
    { 3760, 15600, {}},
    { 3820, 15700, {}},
    { 3880, 15800, {}},
    { 3940, 15900, {}},
    { 4000, 16000, {}},
    { 4023, 15901, {}},
    { 4046, 15803, {}},
    { 4069, 15704, {}},
    { 4091, 15606, {}},
    { 4114, 15507, {}},
    { 4137, 15409, {}},
    { 4160, 15310, {}},
    { 4183, 15211, {}},
    { 4206, 15113, {}},
    { 4229, 15014, {}},
    { 4251, 14916, {}},
    { 4274, 14817, {}},
    { 4297, 14719, {}},
    { 4320, 14620, {}},
    { 4360, 14560, {}},
    { 4380, 14520, {}},
    { 4480, 14580, {}},
    { 4580, 14640, {}},
    { 4580, 14546, {}},
    { 4580, 14451, {}},
    { 4580, 14357, {}},
    { 4580, 14263, {}},
    { 4580, 14169, {}},
    { 4580, 14074, {}},
    { 4580, 13980, {}},
    { 4490, 13900, {}},
    { 4400, 13820, {}},
    { 4310, 13740, {}},
    { 4220, 13660, {}},
    { 4220, 13563, {}},
    { 4220, 13467, {}},
    { 4220, 13370, {}},
    { 4220, 13273, {}},
    { 4220, 13177, {}},
    { 4220, 13080, {}},
    { 4240, 13060, {}},
    { 4260, 13060, {}},
    { 4260, 13040, {}},
    { 4280, 13020, {}},
    { 4300, 13000, {}},
    { 4280, 12980, {}},
    { 4260, 12980, {}},
    { 4240, 12960, {}},
    { 4240, 12940, {}},
    { 4240, 12920, {}},
    { 4220, 12920, {}},
    { 4200, 12900, {}},
    { 4200, 12880, {}},
    { 4200, 12860, {}},
    { 4200, 12820, {}},
    { 4180, 12820, {}},
    { 4160, 12840, {}},
    { 4140, 12820, {}},
    { 4140, 12800, {}},
    { 4140, 12780, {}},
    { 4140, 12760, {}},
    { 4140, 12740, {}},
    { 4160, 12720, {}},
    { 4180, 12700, {}},
    { 4180, 12680, {}},
    { 4160, 12660, {}},
    { 4140, 12660, {}},
    { 4140, 12640, {}},
    { 4120, 12640, {}},
    { 4120, 12620, {}},
    { 4100, 12600, {}},
    { 4080, 12580, {}},
    { 4080, 12560, {}},
    { 4060, 12540, {}},
    { 4060, 12520, {}},
    { 4040, 12500, {}},
    { 4040, 12480, {}},
    { 4020, 12460, {}},
    { 4020, 12440, {}},
    { 4000, 12440, {}},
    { 3980, 12420, {}},
    { 3900, 12400, {}},
};

static ZoneVertex cqz26[] = {
    { 2815,  9814, {}},
    { 2840,  9800, {}},
    { 2840,  9780, {}},
    { 2860,  9760, {}},
    { 2840,  9740, {}},
    { 2820,  9740, {}},
    { 2800,  9740, {}},
    { 2780,  9720, {}},
    { 2760,  9700, {}},
    { 2740,  9700, {}},
    { 2720,  9720, {}},
    { 2720,  9700, {}},
    { 2740,  9680, {}},
    { 2740,  9660, {}},
    { 2720,  9640, {}},
    { 2720,  9620, {}},
    { 2720,  9600, {}},
    { 2700,  9580, {}},
    { 2680,  9560, {}},
    { 2660,  9540, {}},
    { 2660,  9520, {}},
    { 2640,  9520, {}},
    { 2620,  9520, {}},
    { 2600,  9520, {}},
    { 2580,  9500, {}},
    { 2560,  9480, {}},
    { 2540,  9460, {}},
    { 2520,  9460, {}},
    { 2500,  9480, {}},
    { 2480,  9460, {}},
    { 2460,  9460, {}},
    { 2440,  9440, {}},
    { 2420,  9420, {}},
    { 2400,  9420, {}},
    { 2400,  9400, {}},
    { 2400,  9380, {}},
    { 2400,  9360, {}},
    { 2400,  9340, {}},
    { 2380,  9340, {}},
    { 2360,  9340, {}},
    { 2340,  9340, {}},
    { 2320,  9340, {}},
    { 2300,  9320, {}},
    { 2280,  9300, {}},
    { 2260,  9320, {}},
    { 2240,  9320, {}},
    { 2220,  9320, {}},
    { 2200,  9300, {}},
    { 2220,  9280, {}},
    { 2200,  9260, {}},
    { 2180,  9260, {}},
    { 2160,  9260, {}},
    { 2140,  9260, {}},
    { 2140,  9240, {}},
    { 2140,  9220, {}},
    { 2120,  9220, {}},
    { 2100,  9220, {}},
    { 2080,  9240, {}},
    { 2053,  9160, {}},
    { 2027,  9080, {}},
    { 2000,  9000, {}},
    { 1903,  9000, {}},
    { 1806,  9000, {}},
    { 1709,  9000, {}},
    { 1611,  9000, {}},
    { 1514,  9000, {}},
    { 1417,  9000, {}},
    { 1320,  9000, {}},
    { 1223,  9000, {}},
    { 1126,  9000, {}},
    { 1029,  9000, {}},
    {  931,  9000, {}},
    {  834,  9000, {}},
    {  737,  9000, {}},
    {  640,  9000, {}},
    {  640,  9096, {}},
    {  640,  9192, {}},
    {  640,  9288, {}},
    {  640,  9384, {}},
    {  640,  9480, {}},
    {  640,  9576, {}},
    {  640,  9672, {}},
    {  640,  9768, {}},
    {  640,  9864, {}},
    {  640,  9960, {}},
    {  660,  9980, {}},
    {  640, 10020, {}},
    {  660, 10020, {}},
    {  660, 10040, {}},
    {  640, 10060, {}},
    {  640, 10080, {}},
    {  620, 10100, {}},
    {  600, 10120, {}},
    {  580, 10100, {}},
    {  560, 10120, {}},
    {  580, 10120, {}},
    {  580, 10140, {}},
    {  600, 10160, {}},
    {  580, 10160, {}},
    {  580, 10180, {}},
    {  600, 10200, {}},
    {  620, 10200, {}},
    {  629, 10294, {}},
    {  637, 10389, {}},
    {  646, 10483, {}},
    {  654, 10577, {}},
    {  663, 10671, {}},
    {  671, 10766, {}},
    {  680, 10860, {}},
    {  666, 10949, {}},
    {  651, 11037, {}},
    {  637, 11126, {}},
    {  623, 11214, {}},
    {  609, 11303, {}},
    {  594, 11391, {}},
    {  580, 11480, {}},
    {  670, 11580, {}},
    {  760, 11680, {}},
    {  860, 11680, {}},
    {  927, 11740, {}},
    {  993, 11800, {}},
    { 1060, 11860, {}},
    { 1152, 11828, {}},
    { 1244, 11796, {}},
    { 1336, 11764, {}},
    { 1428, 11732, {}},
    { 1520, 11700, {}},
    { 1520, 11600, {}},
    { 1520, 11500, {}},
    { 1520, 11400, {}},
    { 1520, 11300, {}},
    { 1520, 11200, {}},
    { 1520, 11100, {}},
    { 1520, 11000, {}},
    { 1613, 10940, {}},
    { 1707, 10880, {}},
    { 1800, 10820, {}},
    { 1885, 10820, {}},
    { 1970, 10820, {}},
    { 2055, 10820, {}},
    { 2140, 10820, {}},
    { 2160, 10800, {}},
    { 2160, 10780, {}},
    { 2160, 10760, {}},
    { 2160, 10740, {}},
    { 2180, 10720, {}},
    { 2200, 10700, {}},
    { 2200, 10680, {}},
    { 2220, 10660, {}},
    { 2240, 10660, {}},
    { 2260, 10660, {}},
    { 2280, 10680, {}},
    { 2300, 10660, {}},
    { 2280, 10640, {}},
    { 2300, 10620, {}},
    { 2300, 10600, {}},
    { 2300, 10580, {}},
    { 2300, 10560, {}},
    { 2320, 10540, {}},
    { 2320, 10520, {}},
    { 2320, 10500, {}},
    { 2300, 10480, {}},
    { 2280, 10460, {}},
    { 2280, 10440, {}},
    { 2280, 10420, {}},
    { 2260, 10400, {}},
    { 2260, 10380, {}},
    { 2260, 10360, {}},
    { 2280, 10340, {}},
    { 2260, 10320, {}},
    { 2240, 10300, {}},
    { 2260, 10280, {}},
    { 2280, 10260, {}},
    { 2260, 10240, {}},
    { 2240, 10220, {}},
    { 2240, 10200, {}},
    { 2240, 10180, {}},
    { 2220, 10160, {}},
    { 2200, 10160, {}},
    { 2180, 10180, {}},
    { 2160, 10180, {}},
    { 2140, 10180, {}},
    { 2120, 10180, {}},
    { 2120, 10160, {}},
    { 2120, 10140, {}},
    { 2140, 10120, {}},
    { 2160, 10120, {}},
    { 2160, 10100, {}},
    { 2160, 10080, {}},
    { 2140, 10060, {}},
    { 2160, 10040, {}},
    { 2160, 10020, {}},
    { 2180, 10000, {}},
    { 2200, 10000, {}},
    { 2200,  9980, {}},
    { 2220,  9960, {}},
    { 2200,  9940, {}},
    { 2220,  9920, {}},
    { 2240,  9920, {}},
    { 2260,  9940, {}},
    { 2280,  9940, {}},
    { 2300,  9960, {}},
    { 2320,  9940, {}},
    { 2320,  9920, {}},
    { 2320,  9900, {}},
    { 2340,  9900, {}},
    { 2360,  9880, {}},
    { 2380,  9860, {}},
    { 2400,  9880, {}},
    { 2400,  9860, {}},
    { 2420,  9840, {}},
    { 2420,  9820, {}},
    { 2400,  9800, {}},
    { 2400,  9780, {}},
    { 2380,  9760, {}},
    { 2400,  9760, {}},
    { 2420,  9780, {}},
    { 2440,  9760, {}},
    { 2460,  9760, {}},
    { 2480,  9760, {}},
    { 2500,  9780, {}},
    { 2520,  9780, {}},
    { 2520,  9800, {}},
    { 2540,  9820, {}},
    { 2560,  9820, {}},
    { 2560,  9840, {}},
    { 2580,  9840, {}},
    { 2580,  9860, {}},
    { 2600,  9860, {}},
    { 2620,  9880, {}},
    { 2640,  9880, {}},
    { 2660,  9880, {}},
    { 2680,  9880, {}},
    { 2700,  9880, {}},
    { 2720,  9860, {}},
    { 2740,  9880, {}},
    { 2760,  9860, {}},
    { 2760,  9840, {}},
    { 2780,  9820, {}},
    { 2800,  9820, {}},
};

static ZoneVertex cqz27[] = {
    {    0, 16500, {}},
    {    0, 16400, {}},
    {    0, 16300, {}},
    {    0, 16200, {}},
    {    0, 16100, {}},
    {    0, 16000, {}},
    {    0, 15900, {}},
    {    0, 15800, {}},
    {    0, 15700, {}},
    {    0, 15600, {}},
    {    0, 15500, {}},
    {    0, 15400, {}},
    {    0, 15300, {}},
    {    0, 15200, {}},
    {    0, 15100, {}},
    {    0, 15000, {}},
    {    0, 14900, {}},
    {    0, 14800, {}},
    {    0, 14700, {}},
    {    0, 14600, {}},
    {    0, 14500, {}},
    {    0, 14400, {}},
    {    0, 14300, {}},
    {    0, 14200, {}},
    {    0, 14100, {}},
    {    0, 14000, {}},
    {   26, 13900, {}},
    {   52, 13800, {}},
    {   78, 13700, {}},
    {  104, 13600, {}},
    {  130, 13500, {}},
    {  156, 13400, {}},
    {  182, 13300, {}},
    {  208, 13200, {}},
    {  234, 13100, {}},
    {  260, 13000, {}},
    {  335, 12925, {}},
    {  410, 12850, {}},
    {  485, 12775, {}},
    {  560, 12700, {}},
    {  543, 12603, {}},
    {  525, 12505, {}},
    {  508, 12408, {}},
    {  490, 12310, {}},
    {  473, 12213, {}},
    {  455, 12115, {}},
    {  438, 12018, {}},
    {  420, 11920, {}},
    {  480, 11900, {}},
    {  540, 11940, {}},
    {  570, 11880, {}},
    {  600, 11820, {}},
    {  660, 11800, {}},
    {  740, 11740, {}},
    {  760, 11680, {}},
    {  860, 11680, {}},
    {  927, 11740, {}},
    {  993, 11800, {}},
    { 1060, 11860, {}},
    { 1152, 11828, {}},
    { 1244, 11796, {}},
    { 1336, 11764, {}},
    { 1428, 11732, {}},
    { 1520, 11700, {}},
    { 1617, 11769, {}},
    { 1714, 11837, {}},
    { 1811, 11906, {}},
    { 1909, 11974, {}},
    { 2006, 12043, {}},
    { 2103, 12111, {}},
    { 2200, 12180, {}},
    { 2200, 12271, {}},
    { 2200, 12362, {}},
    { 2200, 12453, {}},
    { 2200, 12544, {}},
    { 2200, 12636, {}},
    { 2200, 12727, {}},
    { 2200, 12818, {}},
    { 2200, 12909, {}},
    { 2200, 13000, {}},
    { 2260, 13100, {}},
    { 2320, 13200, {}},
    { 2380, 13300, {}},
    { 2440, 13400, {}},
    { 2500, 13500, {}},
    { 2560, 13600, {}},
    { 2620, 13700, {}},
    { 2680, 13800, {}},
    { 2740, 13900, {}},
    { 2800, 14000, {}},
    { 2860, 14100, {}},
    { 2920, 14200, {}},
    { 2980, 14300, {}},
    { 3040, 14400, {}},
    { 3100, 14500, {}},
    { 3160, 14600, {}},
    { 3220, 14700, {}},
    { 3280, 14800, {}},
    { 3340, 14900, {}},
    { 3400, 15000, {}},
    { 3460, 15100, {}},
    { 3520, 15200, {}},
    { 3580, 15300, {}},
    { 3640, 15400, {}},
    { 3700, 15500, {}},
    { 3760, 15600, {}},
    { 3820, 15700, {}},
    { 3880, 15800, {}},
    { 3940, 15900, {}},
    { 4000, 16000, {}},
    { 3900, 16000, {}},
    { 3800, 16000, {}},
    { 3700, 16000, {}},
    { 3600, 16000, {}},
    { 3500, 16000, {}},
    { 3400, 16000, {}},
    { 3300, 16000, {}},
    { 3200, 16000, {}},
    { 3100, 16000, {}},
    { 3000, 16000, {}},
    { 2900, 16000, {}},
    { 2800, 16000, {}},
    { 2700, 16000, {}},
    { 2600, 16000, {}},
    { 2500, 16000, {}},
    { 2400, 16000, {}},
    { 2300, 16000, {}},
    { 2200, 16000, {}},
    { 2100, 16000, {}},
    { 2000, 16000, {}},
    { 1900, 16000, {}},
    { 1800, 16000, {}},
    { 1700, 16000, {}},
    { 1600, 16000, {}},
    { 1500, 16000, {}},
    { 1400, 16000, {}},
    { 1300, 16000, {}},
    { 1200, 16000, {}},
    { 1100, 16000, {}},
    { 1000, 16000, {}},
    {  900, 16000, {}},
    {  800, 16000, {}},
    {  740, 16100, {}},
    {  680, 16200, {}},
    {  620, 16300, {}},
    {  560, 16400, {}},
    {  500, 16500, {}},
    {  400, 16500, {}},
    {  300, 16500, {}},
    {  200, 16500, {}},
    {  100, 16500, {}},
    {    0, 16500, {}},
};

static ZoneVertex cqz28[] = {
    {    0, 16500, {}},
    {    0, 16400, {}},
    {    0, 16300, {}},
    {    0, 16200, {}},
    {    0, 16100, {}},
    {    0, 16000, {}},
    {    0, 15900, {}},
    {    0, 15800, {}},
    {    0, 15700, {}},
    {    0, 15600, {}},
    {    0, 15500, {}},
    {    0, 15400, {}},
    {    0, 15300, {}},
    {    0, 15200, {}},
    {    0, 15100, {}},
    {    0, 15000, {}},
    {    0, 14900, {}},
    {    0, 14800, {}},
    {    0, 14700, {}},
    {    0, 14600, {}},
    {    0, 14500, {}},
    {    0, 14400, {}},
    {    0, 14300, {}},
    {    0, 14200, {}},
    {    0, 14100, {}},
    {    0, 14000, {}},
    {   26, 13900, {}},
    {   52, 13800, {}},
    {   78, 13700, {}},
    {  104, 13600, {}},
    {  130, 13500, {}},
    {  156, 13400, {}},
    {  182, 13300, {}},
    {  208, 13200, {}},
    {  234, 13100, {}},
    {  260, 13000, {}},
    {  335, 12925, {}},
    {  410, 12850, {}},
    {  485, 12775, {}},
    {  560, 12700, {}},
    {  543, 12603, {}},
    {  525, 12505, {}},
    {  508, 12408, {}},
    {  490, 12310, {}},
    {  473, 12213, {}},
    {  455, 12115, {}},
    {  438, 12018, {}},
    {  420, 11920, {}},
    {  480, 11900, {}},
    {  540, 11940, {}},
    {  570, 11880, {}},
    {  600, 11820, {}},
    {  660, 11800, {}},
    {  740, 11740, {}},
    {  760, 11680, {}},
    {  670, 11580, {}},
    {  580, 11480, {}},
    {  594, 11391, {}},
    {  609, 11303, {}},
    {  623, 11214, {}},
    {  637, 11126, {}},
    {  651, 11037, {}},
    {  666, 10949, {}},
    {  680, 10860, {}},
    {  671, 10769, {}},
    {  663, 10677, {}},
    {  654, 10586, {}},
    {  646, 10494, {}},
    {  637, 10403, {}},
    {  629, 10311, {}},
    {  620, 10220, {}},
    {  600, 10200, {}},
    {  580, 10180, {}},
    {  600, 10160, {}},
    {  580, 10140, {}},
    {  560, 10120, {}},
    {  580, 10100, {}},
    {  600, 10120, {}},
    {  620, 10120, {}},
    {  620, 10100, {}},
    {  640, 10080, {}},
    {  640, 10060, {}},
    {  660, 10040, {}},
    {  680, 10020, {}},
    {  660, 10020, {}},
    {  660,  9980, {}},
    {  640,  9960, {}},
    {  640,  9864, {}},
    {  640,  9768, {}},
    {  640,  9672, {}},
    {  640,  9576, {}},
    {  640,  9480, {}},
    {  640,  9384, {}},
    {  640,  9288, {}},
    {  640,  9192, {}},
    {  640,  9096, {}},
    {  640,  9000, {}},
    {  544,  9000, {}},
    {  447,  9000, {}},
    {  351,  9000, {}},
    {  254,  9000, {}},
    {  158,  9000, {}},
    {   61,  9000, {}},
    {  -35,  9000, {}},
    { -132,  9000, {}},
    { -228,  9000, {}},
    { -325,  9000, {}},
    { -421,  9000, {}},
    { -518,  9000, {}},
    { -614,  9000, {}},
    { -711,  9000, {}},
    { -807,  9000, {}},
    { -904,  9000, {}},
    {-1000,  9000, {}},
    {-1000,  9100, {}},
    {-1000,  9200, {}},
    {-1000,  9300, {}},
    {-1000,  9400, {}},
    {-1000,  9500, {}},
    {-1000,  9600, {}},
    {-1000,  9700, {}},
    {-1000,  9800, {}},
    {-1000,  9900, {}},
    {-1000, 10000, {}},
    {-1000, 10100, {}},
    {-1000, 10200, {}},
    {-1000, 10300, {}},
    {-1000, 10400, {}},
    {-1000, 10500, {}},
    {-1000, 10600, {}},
    {-1000, 10700, {}},
    {-1000, 10800, {}},
    {-1000, 10900, {}},
    {-1000, 11000, {}},
    {-1009, 11100, {}},
    {-1018, 11200, {}},
    {-1028, 11300, {}},
    {-1037, 11400, {}},
    {-1046, 11500, {}},
    {-1055, 11600, {}},
    {-1065, 11700, {}},
    {-1074, 11800, {}},
    {-1083, 11900, {}},
    {-1092, 12000, {}},
    {-1102, 12100, {}},
    {-1111, 12200, {}},
    {-1120, 12300, {}},
    {-1112, 12400, {}},
    {-1104, 12500, {}},
    {-1096, 12600, {}},
    {-1088, 12700, {}},
    {-1080, 12800, {}},
    {-1072, 12900, {}},
    {-1064, 13000, {}},
    {-1056, 13100, {}},
    {-1048, 13200, {}},
    {-1040, 13300, {}},
    {-1032, 13400, {}},
    {-1024, 13500, {}},
    {-1016, 13600, {}},
    {-1008, 13700, {}},
    {-1000, 13800, {}},
    { -984, 13884, {}},
    { -968, 13968, {}},
    { -952, 14052, {}},
    { -936, 14136, {}},
    { -920, 14220, {}},
    { -940, 14260, {}},
    { -940, 14330, {}},
    { -940, 14400, {}},
    {-1030, 14500, {}},
    {-1120, 14600, {}},
    {-1210, 14700, {}},
    {-1300, 14800, {}},
    {-1300, 14900, {}},
    {-1300, 15000, {}},
    {-1300, 15100, {}},
    {-1300, 15200, {}},
    {-1300, 15300, {}},
    {-1300, 15400, {}},
    {-1300, 15500, {}},
    {-1300, 15600, {}},
    {-1300, 15700, {}},
    {-1300, 15800, {}},
    {-1300, 15900, {}},
    {-1300, 16000, {}},
    {-1300, 16100, {}},
    {-1300, 16200, {}},
    {-1300, 16300, {}},
    {-1200, 16340, {}},
    {-1100, 16380, {}},
    {-1000, 16420, {}},
    { -900, 16460, {}},
    { -800, 16500, {}},
    { -700, 16500, {}},
    { -600, 16500, {}},
    { -500, 16500, {}},
    { -400, 16500, {}},
    { -300, 16500, {}},
    { -200, 16500, {}},
    { -100, 16500, {}},
    {    0, 16500, {}},
};

static ZoneVertex cqz29[] = {
    {-9000,  9000, {}},
    {-9000,  9100, {}},
    {-9000,  9200, {}},
    {-9000,  9300, {}},
    {-9000,  9400, {}},
    {-9000,  9500, {}},
    {-9000,  9600, {}},
    {-9000,  9700, {}},
    {-9000,  9800, {}},
    {-9000,  9900, {}},
    {-9000, 10000, {}},
    {-9000, 10100, {}},
    {-9000, 10200, {}},
    {-9000, 10300, {}},
    {-9000, 10400, {}},
    {-9000, 10500, {}},
    {-9000, 10600, {}},
    {-9000, 10700, {}},
    {-9000, 10800, {}},
    {-9000, 10900, {}},
    {-9000, 11000, {}},
    {-9000, 11100, {}},
    {-9000, 11200, {}},
    {-9000, 11300, {}},
    {-9000, 11400, {}},
    {-9000, 11500, {}},
    {-9000, 11600, {}},
    {-9000, 11700, {}},
    {-9000, 11800, {}},
    {-9000, 11900, {}},
    {-9000, 12000, {}},
    {-9000, 12100, {}},
    {-9000, 12200, {}},
    {-9000, 12300, {}},
    {-9000, 12400, {}},
    {-9000, 12500, {}},
    {-9000, 12600, {}},
    {-9000, 12700, {}},
    {-9000, 12800, {}},
    {-9000, 12900, {}},
    {-8900, 12900, {}},
    {-8800, 12900, {}},
    {-8700, 12900, {}},
    {-8600, 12900, {}},
    {-8500, 12900, {}},
    {-8400, 12900, {}},
    {-8300, 12900, {}},
    {-8200, 12900, {}},
    {-8100, 12900, {}},
    {-8000, 12900, {}},
    {-7900, 12900, {}},
    {-7800, 12900, {}},
    {-7700, 12900, {}},
    {-7600, 12900, {}},
    {-7500, 12900, {}},
    {-7400, 12900, {}},
    {-7300, 12900, {}},
    {-7200, 12900, {}},
    {-7100, 12900, {}},
    {-7000, 12900, {}},
    {-6900, 12900, {}},
    {-6800, 12900, {}},
    {-6700, 12900, {}},
    {-6600, 12900, {}},
    {-6500, 12900, {}},
    {-6400, 12900, {}},
    {-6300, 12900, {}},
    {-6200, 12900, {}},
    {-6100, 12900, {}},
    {-6000, 12900, {}},
    {-5900, 12900, {}},
    {-5800, 12900, {}},
    {-5700, 12900, {}},
    {-5600, 12900, {}},
    {-5500, 12900, {}},
    {-5400, 12900, {}},
    {-5300, 12900, {}},
    {-5200, 12900, {}},
    {-5100, 12900, {}},
    {-5000, 12900, {}},
    {-4900, 12900, {}},
    {-4800, 12900, {}},
    {-4700, 12900, {}},
    {-4600, 12900, {}},
    {-4500, 12900, {}},
    {-4400, 12900, {}},
    {-4300, 12900, {}},
    {-4200, 12900, {}},
    {-4100, 12900, {}},
    {-4000, 12900, {}},
    {-3900, 12900, {}},
    {-3800, 12900, {}},
    {-3700, 12900, {}},
    {-3600, 12900, {}},
    {-3500, 12900, {}},
    {-3400, 12900, {}},
    {-3300, 12900, {}},
    {-3200, 12900, {}},
    {-3160, 12900, {}},
    {-3067, 12900, {}},
    {-2973, 12900, {}},
    {-2880, 12900, {}},
    {-2787, 12900, {}},
    {-2693, 12900, {}},
    {-2600, 12900, {}},
    {-2600, 13000, {}},
    {-2600, 13100, {}},
    {-2600, 13200, {}},
    {-2600, 13300, {}},
    {-2600, 13400, {}},
    {-2600, 13500, {}},
    {-2600, 13600, {}},
    {-2600, 13700, {}},
    {-2600, 13800, {}},
    {-2506, 13800, {}},
    {-2412, 13800, {}},
    {-2318, 13800, {}},
    {-2224, 13800, {}},
    {-2130, 13800, {}},
    {-2036, 13800, {}},
    {-1942, 13800, {}},
    {-1848, 13800, {}},
    {-1754, 13800, {}},
    {-1660, 13800, {}},
    {-1566, 13800, {}},
    {-1471, 13800, {}},
    {-1377, 13800, {}},
    {-1283, 13800, {}},
    {-1189, 13800, {}},
    {-1094, 13800, {}},
    {-1000, 13800, {}},
    {-1008, 13700, {}},
    {-1016, 13600, {}},
    {-1024, 13500, {}},
    {-1032, 13400, {}},
    {-1040, 13300, {}},
    {-1048, 13200, {}},
    {-1056, 13100, {}},
    {-1064, 13000, {}},
    {-1072, 12900, {}},
    {-1080, 12800, {}},
    {-1088, 12700, {}},
    {-1096, 12600, {}},
    {-1104, 12500, {}},
    {-1112, 12400, {}},
    {-1120, 12300, {}},
    {-1111, 12200, {}},
    {-1102, 12100, {}},
    {-1092, 12000, {}},
    {-1083, 11900, {}},
    {-1074, 11800, {}},
    {-1065, 11700, {}},
    {-1055, 11600, {}},
    {-1046, 11500, {}},
    {-1037, 11400, {}},
    {-1028, 11300, {}},
    {-1018, 11200, {}},
    {-1009, 11100, {}},
    {-1000, 11000, {}},
    {-1000, 10900, {}},
    {-1000, 10800, {}},
    {-1000, 10700, {}},
    {-1000, 10600, {}},
    {-1000, 10500, {}},
    {-1000, 10400, {}},
    {-1000, 10300, {}},
    {-1000, 10200, {}},
    {-1000, 10100, {}},
    {-1000, 10000, {}},
    {-1000,  9900, {}},
    {-1000,  9800, {}},
    {-1000,  9700, {}},
    {-1000,  9600, {}},
    {-1000,  9500, {}},
    {-1000,  9400, {}},
    {-1000,  9300, {}},
    {-1000,  9200, {}},
    {-1000,  9100, {}},
    {-1000,  9000, {}},
    {-1100,  9000, {}},
    {-1200,  9000, {}},
    {-1300,  9000, {}},
    {-1400,  9000, {}},
    {-1500,  9000, {}},
    {-1600,  9000, {}},
    {-1700,  9000, {}},
    {-1800,  9000, {}},
    {-1900,  9000, {}},
    {-2000,  9000, {}},
    {-2100,  9000, {}},
    {-2200,  9000, {}},
    {-2300,  9000, {}},
    {-2400,  9000, {}},
    {-2500,  9000, {}},
    {-2600,  9000, {}},
    {-2700,  9000, {}},
    {-2800,  9000, {}},
    {-2900,  9000, {}},
    {-3000,  9000, {}},
    {-3100,  9000, {}},
    {-3200,  9000, {}},
    {-3300,  9000, {}},
    {-3400,  9000, {}},
    {-3500,  9000, {}},
    {-3600,  9000, {}},
    {-3700,  9000, {}},
    {-3800,  9000, {}},
    {-3900,  9000, {}},
    {-4000,  9000, {}},
    {-4100,  9000, {}},
    {-4200,  9000, {}},
    {-4300,  9000, {}},
    {-4400,  9000, {}},
    {-4500,  9000, {}},
    {-4600,  9000, {}},
    {-4700,  9000, {}},
    {-4800,  9000, {}},
    {-4900,  9000, {}},
    {-5000,  9000, {}},
    {-5100,  9000, {}},
    {-5200,  9000, {}},
    {-5300,  9000, {}},
    {-5400,  9000, {}},
    {-5500,  9000, {}},
    {-5600,  9000, {}},
    {-5700,  9000, {}},
    {-5800,  9000, {}},
    {-5900,  9000, {}},
    {-6000,  9000, {}},
    {-6100,  9000, {}},
    {-6200,  9000, {}},
    {-6300,  9000, {}},
    {-6400,  9000, {}},
    {-6500,  9000, {}},
    {-6600,  9000, {}},
    {-6700,  9000, {}},
    {-6800,  9000, {}},
    {-6900,  9000, {}},
    {-7000,  9000, {}},
    {-7100,  9000, {}},
    {-7200,  9000, {}},
    {-7300,  9000, {}},
    {-7400,  9000, {}},
    {-7500,  9000, {}},
    {-7600,  9000, {}},
    {-7700,  9000, {}},
    {-7800,  9000, {}},
    {-7900,  9000, {}},
    {-8000,  9000, {}},
    {-8100,  9000, {}},
    {-8200,  9000, {}},
    {-8300,  9000, {}},
    {-8400,  9000, {}},
    {-8500,  9000, {}},
    {-8600,  9000, {}},
    {-8700,  9000, {}},
    {-8800,  9000, {}},
    {-8900,  9000, {}},
    {-9000,  9000, {}},
};

static ZoneVertex cqz30[] = {
    {-9000, 12900, {}},
    {-8900, 12900, {}},
    {-8800, 12900, {}},
    {-8700, 12900, {}},
    {-8600, 12900, {}},
    {-8500, 12900, {}},
    {-8400, 12900, {}},
    {-8300, 12900, {}},
    {-8200, 12900, {}},
    {-8100, 12900, {}},
    {-8000, 12900, {}},
    {-7900, 12900, {}},
    {-7800, 12900, {}},
    {-7700, 12900, {}},
    {-7600, 12900, {}},
    {-7500, 12900, {}},
    {-7400, 12900, {}},
    {-7300, 12900, {}},
    {-7200, 12900, {}},
    {-7100, 12900, {}},
    {-7000, 12900, {}},
    {-6900, 12900, {}},
    {-6800, 12900, {}},
    {-6700, 12900, {}},
    {-6600, 12900, {}},
    {-6500, 12900, {}},
    {-6400, 12900, {}},
    {-6300, 12900, {}},
    {-6200, 12900, {}},
    {-6100, 12900, {}},
    {-6000, 12900, {}},
    {-5900, 12900, {}},
    {-5800, 12900, {}},
    {-5700, 12900, {}},
    {-5600, 12900, {}},
    {-5500, 12900, {}},
    {-5400, 12900, {}},
    {-5300, 12900, {}},
    {-5200, 12900, {}},
    {-5100, 12900, {}},
    {-5000, 12900, {}},
    {-4900, 12900, {}},
    {-4800, 12900, {}},
    {-4700, 12900, {}},
    {-4600, 12900, {}},
    {-4500, 12900, {}},
    {-4400, 12900, {}},
    {-4300, 12900, {}},
    {-4200, 12900, {}},
    {-4100, 12900, {}},
    {-4000, 12900, {}},
    {-3900, 12900, {}},
    {-3800, 12900, {}},
    {-3700, 12900, {}},
    {-3600, 12900, {}},
    {-3500, 12900, {}},
    {-3400, 12900, {}},
    {-3300, 12900, {}},
    {-3200, 12900, {}},
    {-3160, 12900, {}},
    {-3067, 12900, {}},
    {-2973, 12900, {}},
    {-2880, 12900, {}},
    {-2787, 12900, {}},
    {-2693, 12900, {}},
    {-2600, 12900, {}},
    {-2600, 13000, {}},
    {-2600, 13100, {}},
    {-2600, 13200, {}},
    {-2600, 13300, {}},
    {-2600, 13400, {}},
    {-2600, 13500, {}},
    {-2600, 13600, {}},
    {-2600, 13700, {}},
    {-2600, 13800, {}},
    {-2506, 13800, {}},
    {-2412, 13800, {}},
    {-2318, 13800, {}},
    {-2224, 13800, {}},
    {-2130, 13800, {}},
    {-2036, 13800, {}},
    {-1942, 13800, {}},
    {-1848, 13800, {}},
    {-1754, 13800, {}},
    {-1660, 13800, {}},
    {-1566, 13800, {}},
    {-1471, 13800, {}},
    {-1377, 13800, {}},
    {-1283, 13800, {}},
    {-1189, 13800, {}},
    {-1094, 13800, {}},
    {-1000, 13800, {}},
    { -984, 13884, {}},
    { -968, 13968, {}},
    { -952, 14052, {}},
    { -936, 14136, {}},
    { -920, 14220, {}},
    { -940, 14260, {}},
    { -940, 14330, {}},
    { -940, 14400, {}},
    {-1030, 14500, {}},
    {-1120, 14600, {}},
    {-1210, 14700, {}},
    {-1300, 14800, {}},
    {-1300, 14900, {}},
    {-1300, 15000, {}},
    {-1300, 15100, {}},
    {-1300, 15200, {}},
    {-1300, 15300, {}},
    {-1300, 15400, {}},
    {-1300, 15500, {}},
    {-1300, 15600, {}},
    {-1300, 15700, {}},
    {-1300, 15800, {}},
    {-1300, 15900, {}},
    {-1300, 16000, {}},
    {-1300, 16100, {}},
    {-1300, 16200, {}},
    {-1300, 16300, {}},
    {-1400, 16257, {}},
    {-1500, 16214, {}},
    {-1600, 16171, {}},
    {-1700, 16129, {}},
    {-1800, 16086, {}},
    {-1900, 16043, {}},
    {-2000, 16000, {}},
    {-2000, 15900, {}},
    {-2000, 15800, {}},
    {-2000, 15700, {}},
    {-2000, 15600, {}},
    {-2000, 15500, {}},
    {-2100, 15583, {}},
    {-2200, 15667, {}},
    {-2300, 15750, {}},
    {-2400, 15833, {}},
    {-2500, 15917, {}},
    {-2600, 16000, {}},
    {-2700, 16083, {}},
    {-2800, 16167, {}},
    {-2900, 16250, {}},
    {-3000, 16333, {}},
    {-3100, 16417, {}},
    {-3200, 16500, {}},
    {-3300, 16500, {}},
    {-3400, 16500, {}},
    {-3500, 16500, {}},
    {-3600, 16500, {}},
    {-3700, 16500, {}},
    {-3800, 16500, {}},
    {-3900, 16500, {}},
    {-4000, 16500, {}},
    {-4100, 16500, {}},
    {-4200, 16500, {}},
    {-4300, 16500, {}},
    {-4400, 16500, {}},
    {-4500, 16500, {}},
    {-4600, 16500, {}},
    {-4700, 16500, {}},
    {-4800, 16500, {}},
    {-4900, 16500, {}},
    {-5000, 16500, {}},
    {-5100, 16500, {}},
    {-5200, 16500, {}},
    {-5300, 16500, {}},
    {-5400, 16500, {}},
    {-5500, 16500, {}},
    {-5600, 16500, {}},
    {-5700, 16500, {}},
    {-5800, 16500, {}},
    {-5900, 16500, {}},
    {-6000, 16500, {}},
    {-6100, 16500, {}},
    {-6200, 16500, {}},
    {-6300, 16500, {}},
    {-6400, 16500, {}},
    {-6500, 16500, {}},
    {-6600, 16500, {}},
    {-6700, 16500, {}},
    {-6800, 16500, {}},
    {-6860, 16600, {}},
    {-6920, 16700, {}},
    {-6980, 16800, {}},
    {-7040, 16900, {}},
    {-7100, 17000, {}},
    {-7200, 17000, {}},
    {-7300, 17000, {}},
    {-7400, 17000, {}},
    {-7500, 17000, {}},
    {-7600, 17000, {}},
    {-7700, 17000, {}},
    {-7800, 17000, {}},
    {-7900, 17000, {}},
    {-8000, 17000, {}},
    {-8100, 17000, {}},
    {-8200, 17000, {}},
    {-8300, 17000, {}},
    {-8400, 17000, {}},
    {-8500, 17000, {}},
    {-8600, 17000, {}},
    {-8700, 17000, {}},
    {-8800, 17000, {}},
    {-8900, 17000, {}},
    {-9000, 17000, {}},
    {-9000, 16900, {}},
    {-9000, 16800, {}},
    {-9000, 16700, {}},
    {-9000, 16600, {}},
    {-9000, 16500, {}},
    {-9000, 16400, {}},
    {-9000, 16300, {}},
    {-9000, 16200, {}},
    {-9000, 16100, {}},
    {-9000, 16000, {}},
    {-9000, 15900, {}},
    {-9000, 15800, {}},
    {-9000, 15700, {}},
    {-9000, 15600, {}},
    {-9000, 15500, {}},
    {-9000, 15400, {}},
    {-9000, 15300, {}},
    {-9000, 15200, {}},
    {-9000, 15100, {}},
    {-9000, 15000, {}},
    {-9000, 14900, {}},
    {-9000, 14800, {}},
    {-9000, 14700, {}},
    {-9000, 14600, {}},
    {-9000, 14500, {}},
    {-9000, 14400, {}},
    {-9000, 14300, {}},
    {-9000, 14200, {}},
    {-9000, 14100, {}},
    {-9000, 14000, {}},
    {-9000, 13900, {}},
    {-9000, 13800, {}},
    {-9000, 13700, {}},
    {-9000, 13600, {}},
    {-9000, 13500, {}},
    {-9000, 13400, {}},
    {-9000, 13300, {}},
    {-9000, 13200, {}},
    {-9000, 13100, {}},
    {-9000, 13000, {}},
    {-9000, 12900, {}},
};

static ZoneVertex cqz31[] = {
    {-1200, 18000, {}},
    {-1179, -17900, {}},
    {-1158, -17800, {}},
    {-1138, -17700, {}},
    {-1117, -17600, {}},
    {-1096, -17500, {}},
    {-1075, -17400, {}},
    {-1054, -17300, {}},
    {-1033, -17200, {}},
    {-1013, -17100, {}},
    { -992, -17000, {}},
    { -971, -16900, {}},
    { -950, -16800, {}},
    { -929, -16700, {}},
    { -908, -16600, {}},
    { -888, -16500, {}},
    { -867, -16400, {}},
    { -846, -16300, {}},
    { -825, -16200, {}},
    { -804, -16100, {}},
    { -783, -16000, {}},
    { -763, -15900, {}},
    { -742, -15800, {}},
    { -721, -15700, {}},
    { -700, -15600, {}},
    { -800, -15560, {}},
    { -900, -15520, {}},
    {-1000, -15480, {}},
    {-1100, -15440, {}},
    {-1200, -15400, {}},
    {-1200, -15300, {}},
    {-1200, -15200, {}},
    {-1200, -15100, {}},
    {-1200, -15000, {}},
    {-1200, -14900, {}},
    {-1200, -14800, {}},
    {-1200, -14700, {}},
    {-1200, -14600, {}},
    {-1200, -14500, {}},
    {-1200, -14400, {}},
    {-1200, -14300, {}},
    {-1200, -14200, {}},
    {-1200, -14100, {}},
    {-1200, -14000, {}},
    {-1200, -13900, {}},
    {-1200, -13800, {}},
    {-1200, -13700, {}},
    {-1200, -13600, {}},
    {-1200, -13500, {}},
    {-1200, -13400, {}},
    {-1200, -13300, {}},
    {-1200, -13200, {}},
    {-1200, -13100, {}},
    {-1200, -13000, {}},
    {-1100, -13000, {}},
    {-1000, -13000, {}},
    { -900, -13000, {}},
    { -800, -13000, {}},
    { -700, -13000, {}},
    { -600, -13000, {}},
    { -500, -13000, {}},
    { -400, -13000, {}},
    { -300, -13000, {}},
    { -200, -13000, {}},
    { -100, -13000, {}},
    {    0, -13000, {}},
    {  100, -13000, {}},
    {  200, -13000, {}},
    {  300, -13000, {}},
    {  400, -13000, {}},
    {  500, -13000, {}},
    {  600, -13000, {}},
    {  700, -13000, {}},
    {  800, -13000, {}},
    {  900, -13000, {}},
    { 1000, -13000, {}},
    { 1100, -13000, {}},
    { 1200, -13000, {}},
    { 1300, -13000, {}},
    { 1400, -13000, {}},
    { 1500, -13000, {}},
    { 1600, -13000, {}},
    { 1700, -13000, {}},
    { 1800, -13000, {}},
    { 1900, -13000, {}},
    { 2000, -13000, {}},
    { 2100, -13000, {}},
    { 2200, -13000, {}},
    { 2300, -13000, {}},
    { 2400, -13000, {}},
    { 2500, -13000, {}},
    { 2600, -13000, {}},
    { 2700, -13000, {}},
    { 2800, -13000, {}},
    { 2900, -13000, {}},
    { 3000, -13000, {}},
    { 3100, -13000, {}},
    { 3200, -13000, {}},
    { 3300, -13000, {}},
    { 3400, -13000, {}},
    { 3500, -13000, {}},
    { 3600, -13000, {}},
    { 3700, -13000, {}},
    { 3800, -13000, {}},
    { 3900, -13000, {}},
    { 4000, -13000, {}},
    { 4000, -13100, {}},
    { 4000, -13200, {}},
    { 4000, -13300, {}},
    { 4000, -13400, {}},
    { 4000, -13500, {}},
    { 4000, -13600, {}},
    { 4000, -13700, {}},
    { 4000, -13800, {}},
    { 4000, -13900, {}},
    { 4000, -14000, {}},
    { 4000, -14100, {}},
    { 4000, -14200, {}},
    { 4000, -14300, {}},
    { 4000, -14400, {}},
    { 4000, -14500, {}},
    { 4000, -14600, {}},
    { 4000, -14700, {}},
    { 4000, -14800, {}},
    { 4000, -14900, {}},
    { 4000, -15000, {}},
    { 4000, -15100, {}},
    { 4000, -15200, {}},
    { 4000, -15300, {}},
    { 4000, -15400, {}},
    { 4000, -15500, {}},
    { 4000, -15600, {}},
    { 4000, -15700, {}},
    { 4000, -15800, {}},
    { 4000, -15900, {}},
    { 4000, -16000, {}},
    { 4000, -16100, {}},
    { 4000, -16200, {}},
    { 4000, -16300, {}},
    { 4000, -16400, {}},
    { 4000, -16500, {}},
    { 4000, -16600, {}},
    { 4000, -16700, {}},
    { 4000, -16800, {}},
    { 4000, -16900, {}},
    { 4000, -17000, {}},
    { 4000, -17100, {}},
    { 4000, -17200, {}},
    { 4000, -17300, {}},
    { 4000, -17400, {}},
    { 4000, -17500, {}},
    { 4000, -17600, {}},
    { 4000, -17700, {}},
    { 4000, -17800, {}},
    { 4000, -17900, {}},
    { 4000, -18000, {}},
    { 4000, 17900, {}},
    { 4000, 17800, {}},
    { 4000, 17700, {}},
    { 4000, 17600, {}},
    { 4000, 17500, {}},
    { 4000, 17400, {}},
    { 4000, 17300, {}},
    { 4000, 17200, {}},
    { 4000, 17100, {}},
    { 4000, 17000, {}},
    { 4000, 16900, {}},
    { 4000, 16800, {}},
    { 4000, 16700, {}},
    { 4000, 16600, {}},
    { 4000, 16500, {}},
    { 4000, 16400, {}},
    { 4000, 16300, {}},
    { 4000, 16200, {}},
    { 4000, 16100, {}},
    { 4000, 16000, {}},
    { 3900, 16000, {}},
    { 3800, 16000, {}},
    { 3700, 16000, {}},
    { 3600, 16000, {}},
    { 3500, 16000, {}},
    { 3400, 16000, {}},
    { 3300, 16000, {}},
    { 3200, 16000, {}},
    { 3100, 16000, {}},
    { 3000, 16000, {}},
    { 2900, 16000, {}},
    { 2800, 16000, {}},
    { 2700, 16000, {}},
    { 2600, 16000, {}},
    { 2500, 16000, {}},
    { 2400, 16000, {}},
    { 2300, 16000, {}},
    { 2200, 16000, {}},
    { 2100, 16000, {}},
    { 2000, 16000, {}},
    { 1900, 16000, {}},
    { 1800, 16000, {}},
    { 1700, 16000, {}},
    { 1600, 16000, {}},
    { 1500, 16000, {}},
    { 1400, 16000, {}},
    { 1300, 16000, {}},
    { 1200, 16000, {}},
    { 1100, 16000, {}},
    { 1000, 16000, {}},
    {  900, 16000, {}},
    {  800, 16000, {}},
    {  740, 16100, {}},
    {  680, 16200, {}},
    {  620, 16300, {}},
    {  560, 16400, {}},
    {  500, 16500, {}},
    {  400, 16500, {}},
    {  300, 16500, {}},
    {  200, 16500, {}},
    {  100, 16500, {}},
    {    0, 16500, {}},
    { -100, 16500, {}},
    { -200, 16500, {}},
    { -300, 16500, {}},
    { -400, 16500, {}},
    { -500, 16500, {}},
    { -600, 16500, {}},
    { -700, 16500, {}},
    { -800, 16500, {}},
    { -827, 16600, {}},
    { -853, 16700, {}},
    { -880, 16800, {}},
    { -907, 16900, {}},
    { -933, 17000, {}},
    { -960, 17100, {}},
    { -987, 17200, {}},
    {-1013, 17300, {}},
    {-1040, 17400, {}},
    {-1067, 17500, {}},
    {-1093, 17600, {}},
    {-1120, 17700, {}},
    {-1147, 17800, {}},
    {-1173, 17900, {}},
    {-1200, -18000, {}},
};

static ZoneVertex cqz32[] = {
    {-1200, 18000, {}},
    {-1179, -17900, {}},
    {-1158, -17800, {}},
    {-1138, -17700, {}},
    {-1117, -17600, {}},
    {-1096, -17500, {}},
    {-1075, -17400, {}},
    {-1054, -17300, {}},
    {-1033, -17200, {}},
    {-1013, -17100, {}},
    { -992, -17000, {}},
    { -971, -16900, {}},
    { -950, -16800, {}},
    { -929, -16700, {}},
    { -908, -16600, {}},
    { -888, -16500, {}},
    { -867, -16400, {}},
    { -846, -16300, {}},
    { -825, -16200, {}},
    { -804, -16100, {}},
    { -783, -16000, {}},
    { -763, -15900, {}},
    { -742, -15800, {}},
    { -721, -15700, {}},
    { -700, -15600, {}},
    { -800, -15560, {}},
    { -900, -15520, {}},
    {-1000, -15480, {}},
    {-1100, -15440, {}},
    {-1200, -15400, {}},
    {-1200, -15300, {}},
    {-1200, -15200, {}},
    {-1200, -15100, {}},
    {-1200, -15000, {}},
    {-1200, -14900, {}},
    {-1200, -14800, {}},
    {-1200, -14700, {}},
    {-1200, -14600, {}},
    {-1200, -14500, {}},
    {-1200, -14400, {}},
    {-1200, -14300, {}},
    {-1200, -14200, {}},
    {-1200, -14100, {}},
    {-1200, -14000, {}},
    {-1200, -13900, {}},
    {-1200, -13800, {}},
    {-1200, -13700, {}},
    {-1200, -13600, {}},
    {-1200, -13500, {}},
    {-1200, -13400, {}},
    {-1200, -13300, {}},
    {-1200, -13200, {}},
    {-1200, -13100, {}},
    {-1200, -13000, {}},
    {-1200, -12900, {}},
    {-1200, -12800, {}},
    {-1200, -12700, {}},
    {-1200, -12600, {}},
    {-1200, -12500, {}},
    {-1200, -12400, {}},
    {-1200, -12300, {}},
    {-1200, -12200, {}},
    {-1200, -12100, {}},
    {-1200, -12000, {}},
    {-1300, -12000, {}},
    {-1400, -12000, {}},
    {-1500, -12000, {}},
    {-1600, -12000, {}},
    {-1700, -12000, {}},
    {-1800, -12000, {}},
    {-1900, -12000, {}},
    {-2000, -12000, {}},
    {-2100, -12000, {}},
    {-2200, -12000, {}},
    {-2300, -12000, {}},
    {-2400, -12000, {}},
    {-2500, -12000, {}},
    {-2600, -12000, {}},
    {-2700, -12000, {}},
    {-2800, -12000, {}},
    {-2900, -12000, {}},
    {-3000, -12000, {}},
    {-3100, -12000, {}},
    {-3200, -12000, {}},
    {-3300, -12000, {}},
    {-3400, -12000, {}},
    {-3500, -12000, {}},
    {-3600, -12000, {}},
    {-3700, -12000, {}},
    {-3800, -12000, {}},
    {-3900, -12000, {}},
    {-4000, -12000, {}},
    {-4100, -12000, {}},
    {-4200, -12000, {}},
    {-4300, -12000, {}},
    {-4400, -12000, {}},
    {-4500, -12000, {}},
    {-4600, -12000, {}},
    {-4700, -12000, {}},
    {-4800, -12000, {}},
    {-4900, -12000, {}},
    {-5000, -12000, {}},
    {-5100, -12000, {}},
    {-5200, -12000, {}},
    {-5300, -12000, {}},
    {-5400, -12000, {}},
    {-5500, -12000, {}},
    {-5600, -12000, {}},
    {-5700, -12000, {}},
    {-5800, -12000, {}},
    {-5900, -12000, {}},
    {-6000, -12000, {}},
    {-6100, -12000, {}},
    {-6200, -12000, {}},
    {-6300, -12000, {}},
    {-6400, -12000, {}},
    {-6500, -12000, {}},
    {-6600, -12000, {}},
    {-6700, -12000, {}},
    {-6800, -12000, {}},
    {-6900, -12000, {}},
    {-7000, -12000, {}},
    {-7100, -12000, {}},
    {-7200, -12000, {}},
    {-7300, -12000, {}},
    {-7400, -12000, {}},
    {-7500, -12000, {}},
    {-7600, -12000, {}},
    {-7700, -12000, {}},
    {-7800, -12000, {}},
    {-7900, -12000, {}},
    {-8000, -12000, {}},
    {-8100, -12000, {}},
    {-8200, -12000, {}},
    {-8300, -12000, {}},
    {-8400, -12000, {}},
    {-8500, -12000, {}},
    {-8600, -12000, {}},
    {-8700, -12000, {}},
    {-8800, -12000, {}},
    {-8900, -12000, {}},
    {-9000, -12000, {}},
    {-9000, -12100, {}},
    {-9000, -12200, {}},
    {-9000, -12300, {}},
    {-9000, -12400, {}},
    {-9000, -12500, {}},
    {-9000, -12600, {}},
    {-9000, -12700, {}},
    {-9000, -12800, {}},
    {-9000, -12900, {}},
    {-9000, -13000, {}},
    {-9000, -13100, {}},
    {-9000, -13200, {}},
    {-9000, -13300, {}},
    {-9000, -13400, {}},
    {-9000, -13500, {}},
    {-9000, -13600, {}},
    {-9000, -13700, {}},
    {-9000, -13800, {}},
    {-9000, -13900, {}},
    {-9000, -14000, {}},
    {-9000, -14100, {}},
    {-9000, -14200, {}},
    {-9000, -14300, {}},
    {-9000, -14400, {}},
    {-9000, -14500, {}},
    {-9000, -14600, {}},
    {-9000, -14700, {}},
    {-9000, -14800, {}},
    {-9000, -14900, {}},
    {-9000, -15000, {}},
    {-9000, -15100, {}},
    {-9000, -15200, {}},
    {-9000, -15300, {}},
    {-9000, -15400, {}},
    {-9000, -15500, {}},
    {-9000, -15600, {}},
    {-9000, -15700, {}},
    {-9000, -15800, {}},
    {-9000, -15900, {}},
    {-9000, -16000, {}},
    {-9000, -16100, {}},
    {-9000, -16200, {}},
    {-9000, -16300, {}},
    {-9000, -16400, {}},
    {-9000, -16500, {}},
    {-9000, -16600, {}},
    {-9000, -16700, {}},
    {-9000, -16800, {}},
    {-9000, -16900, {}},
    {-9000, -17000, {}},
    {-9000, -17100, {}},
    {-9000, -17200, {}},
    {-9000, -17300, {}},
    {-9000, -17400, {}},
    {-9000, -17500, {}},
    {-9000, -17600, {}},
    {-9000, -17700, {}},
    {-9000, -17800, {}},
    {-9000, -17900, {}},
    {-9000, -18000, {}},
    {-9000, 17900, {}},
    {-9000, 17800, {}},
    {-9000, 17700, {}},
    {-9000, 17600, {}},
    {-9000, 17500, {}},
    {-9000, 17400, {}},
    {-9000, 17300, {}},
    {-9000, 17200, {}},
    {-9000, 17100, {}},
    {-9000, 17000, {}},
    {-8900, 17000, {}},
    {-8800, 17000, {}},
    {-8700, 17000, {}},
    {-8600, 17000, {}},
    {-8500, 17000, {}},
    {-8400, 17000, {}},
    {-8300, 17000, {}},
    {-8200, 17000, {}},
    {-8100, 17000, {}},
    {-8000, 17000, {}},
    {-7900, 17000, {}},
    {-7800, 17000, {}},
    {-7700, 17000, {}},
    {-7600, 17000, {}},
    {-7500, 17000, {}},
    {-7400, 17000, {}},
    {-7300, 17000, {}},
    {-7200, 17000, {}},
    {-7100, 17000, {}},
    {-7040, 16900, {}},
    {-6980, 16800, {}},
    {-6920, 16700, {}},
    {-6860, 16600, {}},
    {-6800, 16500, {}},
    {-6700, 16500, {}},
    {-6600, 16500, {}},
    {-6500, 16500, {}},
    {-6400, 16500, {}},
    {-6300, 16500, {}},
    {-6200, 16500, {}},
    {-6100, 16500, {}},
    {-6000, 16500, {}},
    {-5900, 16500, {}},
    {-5800, 16500, {}},
    {-5700, 16500, {}},
    {-5600, 16500, {}},
    {-5500, 16500, {}},
    {-5400, 16500, {}},
    {-5300, 16500, {}},
    {-5200, 16500, {}},
    {-5100, 16500, {}},
    {-5000, 16500, {}},
    {-4900, 16500, {}},
    {-4800, 16500, {}},
    {-4700, 16500, {}},
    {-4600, 16500, {}},
    {-4500, 16500, {}},
    {-4400, 16500, {}},
    {-4300, 16500, {}},
    {-4200, 16500, {}},
    {-4100, 16500, {}},
    {-4000, 16500, {}},
    {-3900, 16500, {}},
    {-3800, 16500, {}},
    {-3700, 16500, {}},
    {-3600, 16500, {}},
    {-3500, 16500, {}},
    {-3400, 16500, {}},
    {-3300, 16500, {}},
    {-3200, 16500, {}},
    {-3100, 16417, {}},
    {-3000, 16333, {}},
    {-2900, 16250, {}},
    {-2800, 16167, {}},
    {-2700, 16083, {}},
    {-2600, 16000, {}},
    {-2500, 15917, {}},
    {-2400, 15833, {}},
    {-2300, 15750, {}},
    {-2200, 15667, {}},
    {-2100, 15583, {}},
    {-2000, 15500, {}},
    {-2000, 15600, {}},
    {-2000, 15700, {}},
    {-2000, 15800, {}},
    {-2000, 15900, {}},
    {-2000, 16000, {}},
    {-1900, 16043, {}},
    {-1800, 16086, {}},
    {-1700, 16129, {}},
    {-1600, 16171, {}},
    {-1500, 16214, {}},
    {-1400, 16257, {}},
    {-1300, 16300, {}},
    {-1200, 16340, {}},
    {-1100, 16380, {}},
    {-1000, 16420, {}},
    { -900, 16460, {}},
    { -800, 16500, {}},
    { -827, 16600, {}},
    { -853, 16700, {}},
    { -880, 16800, {}},
    { -907, 16900, {}},
    { -933, 17000, {}},
    { -960, 17100, {}},
    { -987, 17200, {}},
    {-1013, 17300, {}},
    {-1040, 17400, {}},
    {-1067, 17500, {}},
    {-1093, 17600, {}},
    {-1120, 17700, {}},
    {-1147, 17800, {}},
    {-1173, 17900, {}},
    {-1200, -18000, {}},
};

static ZoneVertex cqz33[] = {
    { 3600, -3500, {}},
    { 3504, -3500, {}},
    { 3408, -3500, {}},
    { 3311, -3500, {}},
    { 3215, -3500, {}},
    { 3119, -3500, {}},
    { 3023, -3500, {}},
    { 2926, -3500, {}},
    { 2830, -3500, {}},
    { 2734, -3500, {}},
    { 2638, -3500, {}},
    { 2541, -3500, {}},
    { 2445, -3500, {}},
    { 2349, -3500, {}},
    { 2253, -3500, {}},
    { 2156, -3500, {}},
    { 2060, -3500, {}},
    { 2060, -3400, {}},
    { 2060, -3300, {}},
    { 2060, -3200, {}},
    { 2060, -3100, {}},
    { 2060, -3000, {}},
    { 2060, -2900, {}},
    { 2060, -2800, {}},
    { 2060, -2700, {}},
    { 2060, -2600, {}},
    { 2060, -2500, {}},
    { 2060, -2400, {}},
    { 2060, -2300, {}},
    { 2060, -2200, {}},
    { 2060, -2100, {}},
    { 2060, -2000, {}},
    { 2060, -1900, {}},
    { 2060, -1800, {}},
    { 2060, -1700, {}},
    { 2080, -1700, {}},
    { 2100, -1700, {}},
    { 2140, -1700, {}},
    { 2140, -1600, {}},
    { 2140, -1500, {}},
    { 2140, -1400, {}},
    { 2140, -1300, {}},
    { 2200, -1300, {}},
    { 2260, -1300, {}},
    { 2280, -1320, {}},
    { 2300, -1300, {}},
    { 2320, -1260, {}},
    { 2340, -1240, {}},
    { 2340, -1220, {}},
    { 2427, -1213, {}},
    { 2513, -1207, {}},
    { 2600, -1200, {}},
    { 2600, -1115, {}},
    { 2600, -1030, {}},
    { 2600,  -945, {}},
    { 2600,  -860, {}},
    { 2670,  -860, {}},
    { 2740,  -860, {}},
    { 2680,  -765, {}},
    { 2620,  -670, {}},
    { 2560,  -575, {}},
    { 2500,  -480, {}},
    { 2460,  -430, {}},
    { 2420,  -380, {}},
    { 2360,  -280, {}},
    { 2300,  -180, {}},
    { 2240,   -80, {}},
    { 2180,    20, {}},
    { 2120,   120, {}},
    { 2100,   120, {}},
    { 2080,   120, {}},
    { 2060,   160, {}},
    { 2020,   180, {}},
    { 2020,   200, {}},
    { 2040,   220, {}},
    { 2020,   240, {}},
    { 2000,   260, {}},
    { 2000,   280, {}},
    { 2000,   300, {}},
    { 1980,   320, {}},
    { 1960,   320, {}},
    { 1940,   320, {}},
    { 1920,   320, {}},
    { 1900,   320, {}},
    { 1913,   407, {}},
    { 1927,   493, {}},
    { 1940,   580, {}},
    { 2010,   660, {}},
    { 2080,   740, {}},
    { 2132,   832, {}},
    { 2184,   924, {}},
    { 2236,  1016, {}},
    { 2288,  1108, {}},
    { 2340,  1200, {}},
    { 2420,  1160, {}},
    { 2440,  1120, {}},
    { 2440,  1100, {}},
    { 2460,  1080, {}},
    { 2460,  1060, {}},
    { 2460,  1040, {}},
    { 2460,  1020, {}},
    { 2480,  1020, {}},
    { 2540,  1000, {}},
    { 2620,   940, {}},
    { 2660,   980, {}},
    { 2680,  1000, {}},
    { 2700,   980, {}},
    { 2720,   980, {}},
    { 2740,   980, {}},
    { 2760,   980, {}},
    { 2780,  1000, {}},
    { 2820,   980, {}},
    { 2880,  1000, {}},
    { 2940,   980, {}},
    { 2980,   960, {}},
    { 3000,   940, {}},
    { 3040,  1000, {}},
    { 3060,  1020, {}},
    { 3080,  1040, {}},
    { 3100,  1020, {}},
    { 3140,  1020, {}},
    { 3180,  1040, {}},
    { 3180,  1060, {}},
    { 3200,  1080, {}},
    { 3220,  1120, {}},
    { 3240,  1160, {}},
    { 3260,  1140, {}},
    { 3300,  1140, {}},
    { 3320,  1160, {}},
    { 3413,  1213, {}},
    { 3507,  1267, {}},
    { 3600,  1320, {}},
    { 3660,  1270, {}},
    { 3720,  1220, {}},
    { 3743,  1133, {}},
    { 3767,  1047, {}},
    { 3790,   960, {}},
    { 3813,   873, {}},
    { 3837,   787, {}},
    { 3860,   700, {}},
    { 3838,   600, {}},
    { 3817,   500, {}},
    { 3795,   400, {}},
    { 3773,   300, {}},
    { 3752,   200, {}},
    { 3730,   100, {}},
    { 3708,     0, {}},
    { 3687,  -100, {}},
    { 3665,  -200, {}},
    { 3643,  -300, {}},
    { 3622,  -400, {}},
    { 3600,  -500, {}},
    { 3600,  -560, {}},
    { 3600,  -600, {}},
    { 3600,  -700, {}},
    { 3600,  -800, {}},
    { 3600,  -900, {}},
    { 3600, -1000, {}},
    { 3600, -1100, {}},
    { 3600, -1200, {}},
    { 3600, -1300, {}},
    { 3600, -1400, {}},
    { 3600, -1500, {}},
    { 3600, -1600, {}},
    { 3600, -1700, {}},
    { 3600, -1800, {}},
    { 3600, -1900, {}},
    { 3600, -2000, {}},
    { 3600, -2100, {}},
    { 3600, -2200, {}},
    { 3600, -2300, {}},
    { 3600, -2400, {}},
    { 3600, -2500, {}},
    { 3600, -2600, {}},
    { 3600, -2700, {}},
    { 3600, -2800, {}},
    { 3600, -2900, {}},
    { 3600, -3000, {}},
    { 3600, -3100, {}},
    { 3600, -3200, {}},
    { 3600, -3300, {}},
    { 3600, -3400, {}},
    { 3600, -3500, {}},
};

static ZoneVertex cqz34[] = {
    { 1854,  3970, {}},
    { 1827,  3915, {}},
    { 1800,  3860, {}},
    { 1780,  3840, {}},
    { 1760,  3820, {}},
    { 1760,  3800, {}},
    { 1760,  3780, {}},
    { 1740,  3780, {}},
    { 1740,  3760, {}},
    { 1720,  3740, {}},
    { 1700,  3720, {}},
    { 1700,  3700, {}},
    { 1680,  3700, {}},
    { 1660,  3680, {}},
    { 1640,  3700, {}},
    { 1580,  3680, {}},
    { 1560,  3660, {}},
    { 1520,  3660, {}},
    { 1440,  3660, {}},
    { 1400,  3640, {}},
    { 1380,  3640, {}},
    { 1360,  3640, {}},
    { 1340,  3620, {}},
    { 1300,  3620, {}},
    { 1260,  3620, {}},
    { 1260,  3580, {}},
    { 1220,  3540, {}},
    { 1200,  3520, {}},
    { 1180,  3500, {}},
    { 1160,  3500, {}},
    { 1140,  3500, {}},
    { 1120,  3500, {}},
    { 1100,  3500, {}},
    { 1080,  3480, {}},
    { 1080,  3440, {}},
    { 1060,  3420, {}},
    { 1040,  3420, {}},
    { 1020,  3440, {}},
    { 1000,  3420, {}},
    {  980,  3420, {}},
    {  960,  3420, {}},
    {  900,  3420, {}},
    {  860,  3420, {}},
    {  840,  3400, {}},
    {  840,  3380, {}},
    {  840,  3360, {}},
    {  840,  3340, {}},
    {  840,  3320, {}},
    {  820,  3320, {}},
    {  800,  3300, {}},
    {  780,  3300, {}},
    {  780,  3320, {}},
    {  780,  3340, {}},
    {  760,  3360, {}},
    {  760,  3380, {}},
    {  740,  3400, {}},
    {  720,  3420, {}},
    {  700,  3420, {}},
    {  700,  3440, {}},
    {  680,  3460, {}},
    {  660,  3480, {}},
    {  640,  3500, {}},
    {  620,  3500, {}},
    {  600,  3500, {}},
    {  560,  3520, {}},
    {  540,  3520, {}},
    {  540,  3540, {}},
    {  540,  3560, {}},
    {  540,  3580, {}},
    {  520,  3580, {}},
    {  480,  3580, {}},
    {  460,  3580, {}},
    {  460,  3560, {}},
    {  480,  3560, {}},
    {  500,  3540, {}},
    {  500,  3500, {}},
    {  480,  3460, {}},
    {  460,  3440, {}},
    {  440,  3400, {}},
    {  380,  3360, {}},
    {  380,  3320, {}},
    {  380,  3300, {}},
    {  380,  3280, {}},
    {  380,  3240, {}},
    {  360,  3220, {}},
    {  360,  3200, {}},
    {  380,  3180, {}},
    {  360,  3160, {}},
    {  380,  3120, {}},
    {  380,  3100, {}},
    {  360,  3100, {}},
    {  360,  3080, {}},
    {  360,  3060, {}},
    {  380,  3060, {}},
    {  380,  3040, {}},
    {  400,  3020, {}},
    {  420,  3000, {}},
    {  440,  2980, {}},
    {  460,  2960, {}},
    {  440,  2940, {}},
    {  440,  2920, {}},
    {  440,  2900, {}},
    {  460,  2880, {}},
    {  440,  2860, {}},
    {  420,  2840, {}},
    {  440,  2820, {}},
    {  460,  2800, {}},
    {  460,  2780, {}},
    {  480,  2780, {}},
    {  480,  2760, {}},
    {  500,  2740, {}},
    {  520,  2740, {}},
    {  540,  2720, {}},
    {  560,  2720, {}},
    {  580,  2720, {}},
    {  580,  2700, {}},
    {  600,  2680, {}},
    {  600,  2660, {}},
    {  620,  2660, {}},
    {  640,  2640, {}},
    {  660,  2640, {}},
    {  680,  2620, {}},
    {  700,  2600, {}},
    {  720,  2580, {}},
    {  720,  2560, {}},
    {  740,  2540, {}},
    {  760,  2520, {}},
    {  780,  2520, {}},
    {  800,  2500, {}},
    {  820,  2480, {}},
    {  820,  2460, {}},
    {  820,  2440, {}},
    {  840,  2420, {}},
    {  860,  2420, {}},
    {  880,  2400, {}},
    {  880,  2380, {}},
    {  880,  2360, {}},
    {  900,  2360, {}},
    {  920,  2360, {}},
    {  940,  2360, {}},
    {  960,  2360, {}},
    {  980,  2360, {}},
    { 1040,  2340, {}},
    { 1060,  2320, {}},
    { 1080,  2300, {}},
    { 1100,  2300, {}},
    { 1120,  2300, {}},
    { 1140,  2300, {}},
    { 1140,  2280, {}},
    { 1160,  2260, {}},
    { 1180,  2260, {}},
    { 1200,  2260, {}},
    { 1220,  2240, {}},
    { 1240,  2240, {}},
    { 1260,  2240, {}},
    { 1260,  2220, {}},
    { 1260,  2200, {}},
    { 1280,  2180, {}},
    { 1300,  2200, {}},
    { 1320,  2220, {}},
    { 1340,  2220, {}},
    { 1360,  2220, {}},
    { 1400,  2220, {}},
    { 1400,  2240, {}},
    { 1420,  2260, {}},
    { 1440,  2240, {}},
    { 1460,  2240, {}},
    { 1460,  2280, {}},
    { 1480,  2260, {}},
    { 1500,  2280, {}},
    { 1520,  2300, {}},
    { 1540,  2300, {}},
    { 1560,  2300, {}},
    { 1580,  2320, {}},
    { 1560,  2340, {}},
    { 1580,  2360, {}},
    { 1580,  2380, {}},
    { 1560,  2400, {}},
    { 1660,  2400, {}},
    { 1760,  2400, {}},
    { 1860,  2400, {}},
    { 1960,  2400, {}},
    { 2004,  2316, {}},
    { 2048,  2232, {}},
    { 2092,  2148, {}},
    { 2136,  2064, {}},
    { 2180,  1980, {}},
    { 2200,  1920, {}},
    { 2220,  1860, {}},
    { 2260,  1800, {}},
    { 2300,  1700, {}},
    { 2340,  1600, {}},
    { 2300,  1510, {}},
    { 2260,  1420, {}},
    { 2300,  1380, {}},
    { 2320,  1360, {}},
    { 2330,  1280, {}},
    { 2340,  1200, {}},
    { 2420,  1160, {}},
    { 2440,  1120, {}},
    { 2440,  1100, {}},
    { 2460,  1080, {}},
    { 2460,  1060, {}},
    { 2460,  1040, {}},
    { 2460,  1020, {}},
    { 2480,  1020, {}},
    { 2540,  1000, {}},
    { 2620,   940, {}},
    { 2660,   980, {}},
    { 2680,  1000, {}},
    { 2700,   980, {}},
    { 2720,   980, {}},
    { 2740,   980, {}},
    { 2760,   980, {}},
    { 2780,  1000, {}},
    { 2820,   980, {}},
    { 2880,  1000, {}},
    { 2940,   980, {}},
    { 2980,   960, {}},
    { 3000,   940, {}},
    { 3040,  1000, {}},
    { 3060,  1020, {}},
    { 3080,  1040, {}},
    { 3100,  1020, {}},
    { 3140,  1020, {}},
    { 3180,  1040, {}},
    { 3180,  1060, {}},
    { 3200,  1080, {}},
    { 3220,  1120, {}},
    { 3240,  1160, {}},
    { 3260,  1140, {}},
    { 3300,  1140, {}},
    { 3320,  1160, {}},
    { 3413,  1213, {}},
    { 3507,  1267, {}},
    { 3600,  1320, {}},
    { 3500,  1400, {}},
    { 3500,  1500, {}},
    { 3500,  1600, {}},
    { 3500,  1700, {}},
    { 3500,  1800, {}},
    { 3500,  1900, {}},
    { 3478,  1995, {}},
    { 3455,  2090, {}},
    { 3433,  2185, {}},
    { 3410,  2280, {}},
    { 3388,  2375, {}},
    { 3365,  2470, {}},
    { 3343,  2565, {}},
    { 3320,  2660, {}},
    { 3298,  2755, {}},
    { 3275,  2850, {}},
    { 3253,  2945, {}},
    { 3230,  3040, {}},
    { 3208,  3135, {}},
    { 3185,  3230, {}},
    { 3163,  3325, {}},
    { 3140,  3420, {}},
    { 3100,  3440, {}},
    { 3060,  3440, {}},
    { 3040,  3460, {}},
    { 3020,  3480, {}},
    { 3000,  3480, {}},
    { 2980,  3480, {}},
    { 2960,  3480, {}},
    { 2940,  3480, {}},
    { 2870,  3460, {}},
    { 2800,  3440, {}},
    { 2740,  3440, {}},
    { 2642,  3498, {}},
    { 2544,  3556, {}},
    { 2447,  3613, {}},
    { 2349,  3671, {}},
    { 2251,  3729, {}},
    { 2153,  3787, {}},
    { 2056,  3844, {}},
    { 1958,  3902, {}},
    { 1860,  3960, {}},
};

static ZoneVertex cqz35[] = {
    { 2050, -2600, {}},
    { 2051, -2510, {}},
    { 2052, -2420, {}},
    { 2053, -2330, {}},
    { 2054, -2240, {}},
    { 2055, -2150, {}},
    { 2056, -2060, {}},
    { 2057, -1970, {}},
    { 2058, -1880, {}},
    { 2059, -1790, {}},
    { 2060, -1700, {}},
    { 2080, -1700, {}},
    { 2100, -1700, {}},
    { 2140, -1700, {}},
    { 2140, -1600, {}},
    { 2140, -1500, {}},
    { 2140, -1400, {}},
    { 2140, -1300, {}},
    { 2200, -1300, {}},
    { 2260, -1300, {}},
    { 2280, -1320, {}},
    { 2300, -1300, {}},
    { 2320, -1260, {}},
    { 2340, -1240, {}},
    { 2340, -1220, {}},
    { 2427, -1213, {}},
    { 2513, -1207, {}},
    { 2600, -1200, {}},
    { 2600, -1115, {}},
    { 2600, -1030, {}},
    { 2600,  -945, {}},
    { 2600,  -860, {}},
    { 2670,  -860, {}},
    { 2740,  -860, {}},
    { 2680,  -765, {}},
    { 2620,  -670, {}},
    { 2560,  -575, {}},
    { 2500,  -480, {}},
    { 2460,  -430, {}},
    { 2420,  -380, {}},
    { 2360,  -280, {}},
    { 2300,  -180, {}},
    { 2240,   -80, {}},
    { 2180,    20, {}},
    { 2120,   120, {}},
    { 2100,   120, {}},
    { 2080,   120, {}},
    { 2060,   160, {}},
    { 2020,   180, {}},
    { 2020,   200, {}},
    { 2040,   220, {}},
    { 2020,   240, {}},
    { 2000,   260, {}},
    { 2000,   280, {}},
    { 2000,   300, {}},
    { 1980,   320, {}},
    { 1960,   320, {}},
    { 1940,   320, {}},
    { 1920,   320, {}},
    { 1900,   320, {}},
    { 1913,   407, {}},
    { 1927,   493, {}},
    { 1940,   580, {}},
    { 2010,   660, {}},
    { 2080,   740, {}},
    { 2132,   832, {}},
    { 2184,   924, {}},
    { 2236,  1016, {}},
    { 2288,  1108, {}},
    { 2340,  1200, {}},
    { 2330,  1270, {}},
    { 2320,  1340, {}},
    { 2320,  1360, {}},
    { 2300,  1380, {}},
    { 2260,  1420, {}},
    { 2300,  1500, {}},
    { 2200,  1520, {}},
    { 2140,  1520, {}},
    { 2100,  1540, {}},
    { 2080,  1540, {}},
    { 2060,  1560, {}},
    { 2040,  1600, {}},
    { 2000,  1580, {}},
    { 1940,  1560, {}},
    { 1880,  1560, {}},
    { 1780,  1560, {}},
    { 1680,  1560, {}},
    { 1620,  1500, {}},
    { 1600,  1460, {}},
    { 1580,  1440, {}},
    { 1560,  1420, {}},
    { 1540,  1400, {}},
    { 1520,  1400, {}},
    { 1480,  1380, {}},
    { 1460,  1360, {}},
    { 1380,  1360, {}},
    { 1300,  1400, {}},
    { 1260,  1420, {}},
    { 1240,  1420, {}},
    { 1240,  1440, {}},
    { 1220,  1460, {}},
    { 1200,  1460, {}},
    { 1180,  1460, {}},
    { 1160,  1460, {}},
    { 1140,  1440, {}},
    { 1120,  1420, {}},
    { 1140,  1400, {}},
    { 1120,  1380, {}},
    { 1100,  1380, {}},
    { 1080,  1360, {}},
    { 1060,  1360, {}},
    { 1040,  1360, {}},
    { 1020,  1340, {}},
    { 1000,  1320, {}},
    {  980,  1320, {}},
    {  960,  1320, {}},
    {  940,  1300, {}},
    {  920,  1280, {}},
    {  900,  1280, {}},
    {  880,  1280, {}},
    {  860,  1260, {}},
    {  840,  1240, {}},
    {  820,  1220, {}},
    {  800,  1220, {}},
    {  780,  1200, {}},
    {  760,  1200, {}},
    {  740,  1200, {}},
    {  720,  1180, {}},
    {  700,  1160, {}},
    {  680,  1160, {}},
    {  660,  1140, {}},
    {  660,  1120, {}},
    {  660,  1100, {}},
    {  680,  1080, {}},
    {  700,  1060, {}},
    {  680,  1020, {}},
    {  700,  1020, {}},
    {  680,   980, {}},
    {  660,   980, {}},
    {  660,   960, {}},
    {  640,   940, {}},
    {  620,   920, {}},
    {  600,   900, {}},
    {  580,   880, {}},
    {  560,   900, {}},
    {  540,   880, {}},
    {  520,   880, {}},
    {  500,   860, {}},
    {  480,   860, {}},
    {  384,   768, {}},
    {  288,   676, {}},
    {  192,   584, {}},
    {   96,   492, {}},
    {    0,   400, {}},
    {    0,   300, {}},
    {    0,   200, {}},
    {    0,   100, {}},
    {    0,     0, {}},
    {    0,  -100, {}},
    {    0,  -200, {}},
    {    0,  -300, {}},
    {    0,  -400, {}},
    {    0,  -500, {}},
    {    0,  -600, {}},
    {    0,  -700, {}},
    {    0,  -800, {}},
    {    0,  -900, {}},
    {    0, -1000, {}},
    {    0, -1100, {}},
    {    0, -1200, {}},
    {    0, -1300, {}},
    {    0, -1400, {}},
    {    0, -1500, {}},
    {    0, -1600, {}},
    {    0, -1700, {}},
    {    0, -1800, {}},
    {    0, -1900, {}},
    {    0, -2000, {}},
    {    0, -2100, {}},
    {    0, -2200, {}},
    {    0, -2300, {}},
    {    0, -2400, {}},
    {    0, -2500, {}},
    {    0, -2600, {}},
    {   98, -2600, {}},
    {  196, -2600, {}},
    {  294, -2600, {}},
    {  392, -2600, {}},
    {  490, -2600, {}},
    {  589, -2600, {}},
    {  687, -2600, {}},
    {  785, -2600, {}},
    {  883, -2600, {}},
    {  981, -2600, {}},
    { 1079, -2600, {}},
    { 1177, -2600, {}},
    { 1275, -2600, {}},
    { 1373, -2600, {}},
    { 1471, -2600, {}},
    { 1570, -2600, {}},
    { 1668, -2600, {}},
    { 1766, -2600, {}},
    { 1864, -2600, {}},
    { 1962, -2600, {}},
    { 2060, -2600, {}},
};

static ZoneVertex cqz36[] = {
    {-1700, -2600, {}},
    {-1700, -2501, {}},
    {-1700, -2402, {}},
    {-1700, -2303, {}},
    {-1700, -2204, {}},
    {-1700, -2105, {}},
    {-1700, -2006, {}},
    {-1700, -1907, {}},
    {-1700, -1808, {}},
    {-1700, -1709, {}},
    {-1700, -1611, {}},
    {-1700, -1512, {}},
    {-1700, -1413, {}},
    {-1700, -1314, {}},
    {-1700, -1215, {}},
    {-1700, -1116, {}},
    {-1700, -1017, {}},
    {-1700,  -918, {}},
    {-1700,  -819, {}},
    {-1700,  -720, {}},
    {-1700,  -621, {}},
    {-1700,  -522, {}},
    {-1700,  -423, {}},
    {-1700,  -324, {}},
    {-1700,  -225, {}},
    {-1700,  -126, {}},
    {-1700,   -27, {}},
    {-1700,    72, {}},
    {-1700,   171, {}},
    {-1700,   269, {}},
    {-1700,   368, {}},
    {-1700,   467, {}},
    {-1700,   566, {}},
    {-1700,   665, {}},
    {-1700,   764, {}},
    {-1700,   863, {}},
    {-1700,   962, {}},
    {-1700,  1061, {}},
    {-1700,  1160, {}},
    {-1720,  1180, {}},
    {-1720,  1200, {}},
    {-1720,  1220, {}},
    {-1720,  1240, {}},
    {-1720,  1260, {}},
    {-1720,  1280, {}},
    {-1700,  1300, {}},
    {-1700,  1320, {}},
    {-1700,  1340, {}},
    {-1720,  1360, {}},
    {-1740,  1380, {}},
    {-1740,  1400, {}},
    {-1740,  1420, {}},
    {-1740,  1504, {}},
    {-1740,  1588, {}},
    {-1740,  1672, {}},
    {-1740,  1756, {}},
    {-1740,  1840, {}},
    {-1760,  1860, {}},
    {-1780,  1880, {}},
    {-1780,  1900, {}},
    {-1780,  1940, {}},
    {-1780,  1960, {}},
    {-1780,  1980, {}},
    {-1800,  2020, {}},
    {-1800,  2040, {}},
    {-1800,  2060, {}},
    {-1800,  2080, {}},
    {-1800,  2120, {}},
    {-1800,  2140, {}},
    {-1780,  2240, {}},
    {-1760,  2340, {}},
    {-1740,  2420, {}},
    {-1740,  2440, {}},
    {-1760,  2460, {}},
    {-1760,  2480, {}},
    {-1760,  2500, {}},
    {-1780,  2520, {}},
    {-1780,  2540, {}},
    {-1780,  2560, {}},
    {-1780,  2580, {}},
    {-1800,  2600, {}},
    {-1780,  2620, {}},
    {-1800,  2640, {}},
    {-1800,  2660, {}},
    {-1800,  2680, {}},
    {-1800,  2700, {}},
    {-1760,  2740, {}},
    {-1740,  2760, {}},
    {-1700,  2780, {}},
    {-1680,  2820, {}},
    {-1660,  2860, {}},
    {-1640,  2880, {}},
    {-1620,  2880, {}},
    {-1600,  2880, {}},
    {-1600,  2900, {}},
    {-1580,  2920, {}},
    {-1560,  2940, {}},
    {-1560,  2960, {}},
    {-1560,  2980, {}},
    {-1560,  3000, {}},
    {-1560,  3020, {}},
    {-1560,  3040, {}},
    {-1540,  3040, {}},
    {-1520,  3020, {}},
    {-1500,  3020, {}},
    {-1500,  3040, {}},
    {-1480,  3060, {}},
    {-1480,  3100, {}},
    {-1460,  3120, {}},
    {-1460,  3140, {}},
    {-1460,  3160, {}},
    {-1440,  3180, {}},
    {-1440,  3200, {}},
    {-1440,  3220, {}},
    {-1420,  3240, {}},
    {-1420,  3280, {}},
    {-1400,  3320, {}},
    {-1400,  3300, {}},
    {-1380,  3280, {}},
    {-1360,  3260, {}},
    {-1360,  3280, {}},
    {-1340,  3300, {}},
    {-1320,  3300, {}},
    {-1300,  3300, {}},
    {-1280,  3300, {}},
    {-1260,  3300, {}},
    {-1260,  3320, {}},
    {-1260,  3340, {}},
    {-1240,  3360, {}},
    {-1240,  3340, {}},
    {-1220,  3340, {}},
    {-1200,  3340, {}},
    {-1180,  3340, {}},
    {-1160,  3340, {}},
    {-1140,  3320, {}},
    {-1120,  3340, {}},
    {-1100,  3340, {}},
    {-1080,  3340, {}},
    {-1060,  3360, {}},
    {-1040,  3360, {}},
    {-1020,  3360, {}},
    {-1020,  3340, {}},
    {-1000,  3340, {}},
    { -980,  3320, {}},
    { -960,  3320, {}},
    { -940,  3300, {}},
    { -940,  3280, {}},
    { -920,  3260, {}},
    { -920,  3240, {}},
    { -900,  3220, {}},
    { -900,  3200, {}},
    { -880,  3180, {}},
    { -880,  3160, {}},
    { -860,  3140, {}},
    { -860,  3120, {}},
    { -860,  3100, {}},
    { -840,  3080, {}},
    { -800,  3080, {}},
    { -780,  3060, {}},
    { -760,  3040, {}},
    { -740,  3040, {}},
    { -720,  3040, {}},
    { -700,  3020, {}},
    { -680,  2980, {}},
    { -640,  2960, {}},
    { -620,  2960, {}},
    { -600,  2940, {}},
    { -580,  2960, {}},
    { -560,  2960, {}},
    { -520,  2940, {}},
    { -480,  2940, {}},
    { -460,  2940, {}},
    { -440,  2960, {}},
    { -440,  2980, {}},
    { -420,  3000, {}},
    { -400,  3020, {}},
    { -380,  3040, {}},
    { -360,  3040, {}},
    { -340,  3060, {}},
    { -320,  3080, {}},
    { -300,  3080, {}},
    { -280,  3060, {}},
    { -260,  3040, {}},
    { -240,  3060, {}},
    { -240,  3080, {}},
    { -200,  3080, {}},
    { -160,  3080, {}},
    { -140,  3060, {}},
    { -120,  3060, {}},
    { -100,  3040, {}},
    { -120,  3020, {}},
    { -140,  3000, {}},
    { -140,  2980, {}},
    { -140,  2960, {}},
    { -120,  2960, {}},
    { -100,  2960, {}},
    {  -80,  2960, {}},
    {  -60,  2960, {}},
    {    0,  2980, {}},
    {   40,  2980, {}},
    {   60,  3000, {}},
    {   80,  3000, {}},
    {  100,  3020, {}},
    {  120,  3040, {}},
    {  160,  3080, {}},
    {  180,  3100, {}},
    {  200,  3120, {}},
    {  220,  3120, {}},
    {  240,  3100, {}},
    {  240,  3080, {}},
    {  260,  3080, {}},
    {  280,  3080, {}},
    {  300,  3080, {}},
    {  320,  3080, {}},
    {  340,  3100, {}},
    {  360,  3080, {}},
    {  360,  3060, {}},
    {  380,  3060, {}},
    {  380,  3040, {}},
    {  400,  3020, {}},
    {  420,  3000, {}},
    {  440,  2980, {}},
    {  460,  2960, {}},
    {  440,  2940, {}},
    {  440,  2920, {}},
    {  440,  2900, {}},
    {  460,  2880, {}},
    {  440,  2860, {}},
    {  420,  2840, {}},
    {  440,  2820, {}},
    {  460,  2800, {}},
    {  460,  2780, {}},
    {  480,  2780, {}},
    {  480,  2760, {}},
    {  500,  2740, {}},
    {  520,  2740, {}},
    {  540,  2720, {}},
    {  560,  2720, {}},
    {  580,  2720, {}},
    {  580,  2700, {}},
    {  600,  2680, {}},
    {  600,  2660, {}},
    {  620,  2660, {}},
    {  640,  2640, {}},
    {  660,  2640, {}},
    {  680,  2620, {}},
    {  700,  2600, {}},
    {  720,  2580, {}},
    {  720,  2560, {}},
    {  740,  2540, {}},
    {  760,  2520, {}},
    {  780,  2520, {}},
    {  800,  2500, {}},
    {  820,  2480, {}},
    {  820,  2460, {}},
    {  820,  2440, {}},
    {  840,  2420, {}},
    {  860,  2420, {}},
    {  880,  2400, {}},
    {  880,  2380, {}},
    {  880,  2360, {}},
    {  900,  2360, {}},
    {  920,  2360, {}},
    {  940,  2360, {}},
    {  960,  2360, {}},
    {  980,  2360, {}},
    { 1040,  2340, {}},
    { 1060,  2320, {}},
    { 1080,  2300, {}},
    { 1100,  2300, {}},
    { 1120,  2300, {}},
    { 1140,  2300, {}},
    { 1140,  2280, {}},
    { 1160,  2260, {}},
    { 1180,  2260, {}},
    { 1200,  2260, {}},
    { 1220,  2240, {}},
    { 1240,  2240, {}},
    { 1260,  2240, {}},
    { 1260,  2220, {}},
    { 1260,  2200, {}},
    { 1280,  2180, {}},
    { 1300,  2200, {}},
    { 1320,  2220, {}},
    { 1340,  2220, {}},
    { 1360,  2220, {}},
    { 1400,  2220, {}},
    { 1400,  2240, {}},
    { 1420,  2260, {}},
    { 1440,  2240, {}},
    { 1460,  2240, {}},
    { 1460,  2280, {}},
    { 1480,  2260, {}},
    { 1500,  2280, {}},
    { 1520,  2300, {}},
    { 1540,  2300, {}},
    { 1560,  2300, {}},
    { 1580,  2320, {}},
    { 1560,  2340, {}},
    { 1580,  2360, {}},
    { 1580,  2380, {}},
    { 1560,  2400, {}},
    { 1660,  2400, {}},
    { 1760,  2400, {}},
    { 1860,  2400, {}},
    { 1960,  2400, {}},
    { 2004,  2316, {}},
    { 2048,  2232, {}},
    { 2092,  2148, {}},
    { 2136,  2064, {}},
    { 2180,  1980, {}},
    { 2200,  1920, {}},
    { 2220,  1860, {}},
    { 2260,  1800, {}},
    { 2300,  1700, {}},
    { 2340,  1600, {}},
    { 2300,  1500, {}},
    { 2200,  1520, {}},
    { 2140,  1520, {}},
    { 2100,  1540, {}},
    { 2080,  1540, {}},
    { 2060,  1560, {}},
    { 2040,  1600, {}},
    { 2000,  1580, {}},
    { 1940,  1560, {}},
    { 1880,  1560, {}},
    { 1780,  1560, {}},
    { 1680,  1560, {}},
    { 1620,  1500, {}},
    { 1600,  1460, {}},
    { 1580,  1440, {}},
    { 1560,  1420, {}},
    { 1540,  1400, {}},
    { 1520,  1400, {}},
    { 1480,  1380, {}},
    { 1460,  1360, {}},
    { 1380,  1360, {}},
    { 1300,  1400, {}},
    { 1260,  1420, {}},
    { 1240,  1420, {}},
    { 1240,  1440, {}},
    { 1220,  1460, {}},
    { 1200,  1460, {}},
    { 1180,  1460, {}},
    { 1160,  1460, {}},
    { 1140,  1440, {}},
    { 1120,  1420, {}},
    { 1140,  1400, {}},
    { 1120,  1380, {}},
    { 1100,  1380, {}},
    { 1080,  1360, {}},
    { 1060,  1360, {}},
    { 1040,  1360, {}},
    { 1020,  1340, {}},
    { 1000,  1320, {}},
    {  980,  1320, {}},
    {  960,  1320, {}},
    {  940,  1300, {}},
    {  920,  1280, {}},
    {  900,  1280, {}},
    {  880,  1280, {}},
    {  860,  1260, {}},
    {  840,  1240, {}},
    {  820,  1220, {}},
    {  800,  1220, {}},
    {  780,  1200, {}},
    {  760,  1200, {}},
    {  740,  1200, {}},
    {  720,  1180, {}},
    {  700,  1160, {}},
    {  680,  1160, {}},
    {  660,  1140, {}},
    {  660,  1120, {}},
    {  660,  1100, {}},
    {  680,  1080, {}},
    {  700,  1060, {}},
    {  680,  1020, {}},
    {  700,  1020, {}},
    {  680,   980, {}},
    {  660,   980, {}},
    {  660,   960, {}},
    {  640,   940, {}},
    {  620,   920, {}},
    {  600,   900, {}},
    {  580,   880, {}},
    {  560,   900, {}},
    {  540,   880, {}},
    {  520,   880, {}},
    {  500,   860, {}},
    {  480,   860, {}},
    {  384,   768, {}},
    {  288,   676, {}},
    {  192,   584, {}},
    {   96,   492, {}},
    {    0,   400, {}},
    {    0,   300, {}},
    {    0,   200, {}},
    {    0,   100, {}},
    {    0,     0, {}},
    {    0,  -100, {}},
    {    0,  -200, {}},
    {    0,  -300, {}},
    {    0,  -400, {}},
    {    0,  -500, {}},
    {    0,  -600, {}},
    {    0,  -700, {}},
    {    0,  -800, {}},
    {    0,  -900, {}},
    {    0, -1000, {}},
    {    0, -1100, {}},
    {    0, -1200, {}},
    {    0, -1300, {}},
    {    0, -1400, {}},
    {    0, -1500, {}},
    {    0, -1600, {}},
    {    0, -1700, {}},
    {    0, -1800, {}},
    {    0, -1900, {}},
    {    0, -2000, {}},
    {    0, -2100, {}},
    {    0, -2200, {}},
    {    0, -2300, {}},
    {    0, -2400, {}},
    {    0, -2500, {}},
    {    0, -2600, {}},
    { -100, -2600, {}},
    { -200, -2600, {}},
    { -300, -2600, {}},
    { -400, -2600, {}},
    { -500, -2600, {}},
    { -600, -2600, {}},
    { -700, -2600, {}},
    { -800, -2600, {}},
    { -900, -2600, {}},
    {-1000, -2600, {}},
    {-1100, -2600, {}},
    {-1200, -2600, {}},
    {-1300, -2600, {}},
    {-1400, -2600, {}},
    {-1500, -2600, {}},
    {-1600, -2600, {}},
    {-1700, -2600, {}},
};

static ZoneVertex cqz37[] = {
    {  350,  3085, {}},
    {  380,  3100, {}},
    {  380,  3120, {}},
    {  360,  3160, {}},
    {  380,  3180, {}},
    {  360,  3200, {}},
    {  360,  3220, {}},
    {  380,  3240, {}},
    {  380,  3280, {}},
    {  380,  3300, {}},
    {  380,  3360, {}},
    {  420,  3400, {}},
    {  460,  3440, {}},
    {  480,  3460, {}},
    {  500,  3500, {}},
    {  500,  3520, {}},
    {  500,  3540, {}},
    {  480,  3560, {}},
    {  460,  3580, {}},
    {  520,  3580, {}},
    {  540,  3560, {}},
    {  540,  3540, {}},
    {  560,  3520, {}},
    {  580,  3500, {}},
    {  600,  3500, {}},
    {  620,  3500, {}},
    {  640,  3500, {}},
    {  660,  3480, {}},
    {  680,  3460, {}},
    {  700,  3440, {}},
    {  700,  3420, {}},
    {  720,  3400, {}},
    {  740,  3400, {}},
    {  760,  3380, {}},
    {  760,  3360, {}},
    {  780,  3340, {}},
    {  780,  3320, {}},
    {  780,  3300, {}},
    {  800,  3300, {}},
    {  820,  3320, {}},
    {  840,  3320, {}},
    {  840,  3340, {}},
    {  840,  3360, {}},
    {  840,  3380, {}},
    {  840,  3400, {}},
    {  860,  3420, {}},
    {  900,  3420, {}},
    {  960,  3420, {}},
    {  980,  3420, {}},
    { 1000,  3420, {}},
    { 1020,  3440, {}},
    { 1040,  3440, {}},
    { 1060,  3440, {}},
    { 1080,  3440, {}},
    { 1100,  3460, {}},
    { 1080,  3480, {}},
    { 1120,  3500, {}},
    { 1140,  3500, {}},
    { 1160,  3500, {}},
    { 1180,  3500, {}},
    { 1200,  3520, {}},
    { 1220,  3540, {}},
    { 1260,  3560, {}},
    { 1280,  3600, {}},
    { 1300,  3620, {}},
    { 1340,  3620, {}},
    { 1360,  3640, {}},
    { 1380,  3640, {}},
    { 1420,  3660, {}},
    { 1500,  3640, {}},
    { 1520,  3660, {}},
    { 1540,  3660, {}},
    { 1580,  3680, {}},
    { 1620,  3680, {}},
    { 1640,  3700, {}},
    { 1660,  3680, {}},
    { 1680,  3700, {}},
    { 1700,  3700, {}},
    { 1700,  3720, {}},
    { 1700,  3740, {}},
    { 1720,  3760, {}},
    { 1740,  3780, {}},
    { 1760,  3800, {}},
    { 1760,  3820, {}},
    { 1780,  3840, {}},
    { 1800,  3860, {}},
    { 1860,  3960, {}},
    { 1760,  4020, {}},
    { 1660,  4080, {}},
    { 1560,  4140, {}},
    { 1460,  4200, {}},
    { 1360,  4260, {}},
    { 1340,  4300, {}},
    { 1267,  4340, {}},
    { 1193,  4380, {}},
    { 1120,  4420, {}},
    { 1151,  4520, {}},
    { 1182,  4620, {}},
    { 1213,  4720, {}},
    { 1244,  4820, {}},
    { 1276,  4920, {}},
    { 1307,  5020, {}},
    { 1338,  5120, {}},
    { 1369,  5220, {}},
    { 1400,  5320, {}},
    { 1457,  5419, {}},
    { 1514,  5517, {}},
    { 1571,  5616, {}},
    { 1629,  5714, {}},
    { 1686,  5813, {}},
    { 1743,  5911, {}},
    { 1800,  6010, {}},
    { 1857,  6109, {}},
    { 1914,  6207, {}},
    { 1971,  6306, {}},
    { 2029,  6404, {}},
    { 2086,  6503, {}},
    { 2143,  6601, {}},
    { 2200,  6700, {}},
    { 2100,  6700, {}},
    { 2000,  6700, {}},
    { 1900,  6700, {}},
    { 1800,  6700, {}},
    { 1700,  6700, {}},
    { 1600,  6700, {}},
    { 1500,  6700, {}},
    { 1400,  6700, {}},
    { 1300,  6700, {}},
    { 1200,  6700, {}},
    { 1100,  6700, {}},
    { 1000,  6700, {}},
    {  900,  6700, {}},
    {  800,  6700, {}},
    {  700,  6700, {}},
    {  600,  6700, {}},
    {  500,  6700, {}},
    {  400,  6700, {}},
    {  300,  6700, {}},
    {  200,  6700, {}},
    {  100,  6700, {}},
    {    0,  6700, {}},
    { -100,  6700, {}},
    { -200,  6700, {}},
    { -300,  6700, {}},
    { -300,  6600, {}},
    { -300,  6500, {}},
    { -300,  6400, {}},
    { -300,  6300, {}},
    { -300,  6200, {}},
    { -300,  6100, {}},
    { -300,  6000, {}},
    { -300,  5900, {}},
    { -300,  5800, {}},
    { -300,  5700, {}},
    { -300,  5600, {}},
    { -300,  5500, {}},
    { -338,  5400, {}},
    { -377,  5300, {}},
    { -415,  5200, {}},
    { -454,  5100, {}},
    { -492,  5000, {}},
    { -531,  4900, {}},
    { -569,  4800, {}},
    { -608,  4700, {}},
    { -646,  4600, {}},
    { -685,  4500, {}},
    { -723,  4400, {}},
    { -762,  4300, {}},
    { -800,  4200, {}},
    { -900,  4200, {}},
    {-1000,  4200, {}},
    {-1100,  4200, {}},
    {-1200,  4200, {}},
    {-1300,  4200, {}},
    {-1400,  4200, {}},
    {-1500,  4200, {}},
    {-1587,  4133, {}},
    {-1673,  4067, {}},
    {-1760,  4000, {}},
    {-1855,  3969, {}},
    {-1951,  3938, {}},
    {-2046,  3908, {}},
    {-2142,  3877, {}},
    {-2237,  3846, {}},
    {-2332,  3815, {}},
    {-2428,  3785, {}},
    {-2523,  3754, {}},
    {-2618,  3723, {}},
    {-2714,  3692, {}},
    {-2809,  3662, {}},
    {-2905,  3631, {}},
    {-3000,  3600, {}},
    {-2920,  3520, {}},
    {-2840,  3440, {}},
    {-2760,  3360, {}},
    {-2680,  3280, {}},
    {-2680,  3260, {}},
    {-2680,  3240, {}},
    {-2680,  3220, {}},
    {-2660,  3220, {}},
    {-2640,  3200, {}},
    {-2620,  3220, {}},
    {-2600,  3200, {}},
    {-2560,  3200, {}},
    {-2540,  3200, {}},
    {-2520,  3200, {}},
    {-2500,  3200, {}},
    {-2460,  3200, {}},
    {-2440,  3200, {}},
    {-2420,  3200, {}},
    {-2400,  3180, {}},
    {-2380,  3160, {}},
    {-2360,  3160, {}},
    {-2320,  3160, {}},
    {-2240,  3140, {}},
    {-2200,  3180, {}},
    {-2140,  3240, {}},
    {-2120,  3240, {}},
    {-2100,  3240, {}},
    {-2080,  3240, {}},
    {-2060,  3260, {}},
    {-2040,  3280, {}},
    {-2020,  3280, {}},
    {-2000,  3300, {}},
    {-1980,  3300, {}},
    {-1960,  3280, {}},
    {-1940,  3280, {}},
    {-1920,  3280, {}},
    {-1900,  3280, {}},
    {-1880,  3280, {}},
    {-1860,  3300, {}},
    {-1840,  3300, {}},
    {-1820,  3300, {}},
    {-1800,  3300, {}},
    {-1780,  3300, {}},
    {-1760,  3300, {}},
    {-1740,  3300, {}},
    {-1720,  3300, {}},
    {-1700,  3280, {}},
    {-1680,  3300, {}},
    {-1680,  3280, {}},
    {-1660,  3280, {}},
    {-1660,  3260, {}},
    {-1640,  3220, {}},
    {-1640,  3200, {}},
    {-1620,  3180, {}},
    {-1620,  3160, {}},
    {-1600,  3140, {}},
    {-1600,  3120, {}},
    {-1600,  3100, {}},
    {-1600,  3040, {}},
    {-1560,  3040, {}},
    {-1540,  3040, {}},
    {-1520,  3020, {}},
    {-1500,  3020, {}},
    {-1500,  3040, {}},
    {-1480,  3060, {}},
    {-1480,  3100, {}},
    {-1460,  3120, {}},
    {-1460,  3140, {}},
    {-1460,  3160, {}},
    {-1440,  3180, {}},
    {-1440,  3200, {}},
    {-1440,  3220, {}},
    {-1420,  3240, {}},
    {-1420,  3280, {}},
    {-1400,  3320, {}},
    {-1400,  3300, {}},
    {-1380,  3280, {}},
    {-1360,  3260, {}},
    {-1360,  3280, {}},
    {-1340,  3300, {}},
    {-1320,  3300, {}},
    {-1300,  3300, {}},
    {-1280,  3300, {}},
    {-1260,  3300, {}},
    {-1260,  3320, {}},
    {-1260,  3340, {}},
    {-1240,  3360, {}},
    {-1240,  3340, {}},
    {-1220,  3340, {}},
    {-1200,  3340, {}},
    {-1180,  3340, {}},
    {-1160,  3340, {}},
    {-1140,  3320, {}},
    {-1120,  3340, {}},
    {-1100,  3340, {}},
    {-1080,  3340, {}},
    {-1060,  3360, {}},
    {-1040,  3360, {}},
    {-1020,  3360, {}},
    {-1020,  3340, {}},
    {-1000,  3340, {}},
    { -980,  3320, {}},
    { -960,  3320, {}},
    { -940,  3300, {}},
    { -940,  3280, {}},
    { -920,  3260, {}},
    { -920,  3240, {}},
    { -900,  3220, {}},
    { -900,  3200, {}},
    { -880,  3180, {}},
    { -880,  3160, {}},
    { -860,  3140, {}},
    { -860,  3120, {}},
    { -860,  3100, {}},
    { -840,  3080, {}},
    { -800,  3080, {}},
    { -780,  3060, {}},
    { -760,  3040, {}},
    { -740,  3040, {}},
    { -720,  3040, {}},
    { -700,  3020, {}},
    { -680,  2980, {}},
    { -640,  2960, {}},
    { -620,  2960, {}},
    { -600,  2940, {}},
    { -580,  2960, {}},
    { -560,  2960, {}},
    { -520,  2940, {}},
    { -480,  2940, {}},
    { -460,  2940, {}},
    { -440,  2960, {}},
    { -440,  2980, {}},
    { -420,  3000, {}},
    { -400,  3020, {}},
    { -380,  3040, {}},
    { -360,  3040, {}},
    { -340,  3060, {}},
    { -320,  3080, {}},
    { -300,  3080, {}},
    { -280,  3060, {}},
    { -260,  3040, {}},
    { -240,  3060, {}},
    { -240,  3080, {}},
    { -200,  3080, {}},
    { -160,  3080, {}},
    { -140,  3060, {}},
    { -120,  3060, {}},
    { -100,  3040, {}},
    { -120,  3020, {}},
    { -140,  3000, {}},
    { -140,  2980, {}},
    { -140,  2960, {}},
    { -120,  2960, {}},
    { -100,  2960, {}},
    {  -80,  2960, {}},
    {  -60,  2960, {}},
    {    0,  2980, {}},
    {   40,  2980, {}},
    {   60,  3000, {}},
    {   80,  3000, {}},
    {  100,  3020, {}},
    {  120,  3040, {}},
    {  160,  3080, {}},
    {  180,  3100, {}},
    {  200,  3120, {}},
    {  220,  3120, {}},
    {  240,  3100, {}},
    {  240,  3080, {}},
    {  260,  3080, {}},
    {  280,  3080, {}},
    {  300,  3080, {}},
    {  320,  3080, {}},
    {  340,  3100, {}},
};

static ZoneVertex cqz38[] = {
    {-1700, -2600, {}},
    {-1700, -2501, {}},
    {-1700, -2402, {}},
    {-1700, -2303, {}},
    {-1700, -2204, {}},
    {-1700, -2105, {}},
    {-1700, -2006, {}},
    {-1700, -1907, {}},
    {-1700, -1808, {}},
    {-1700, -1709, {}},
    {-1700, -1611, {}},
    {-1700, -1512, {}},
    {-1700, -1413, {}},
    {-1700, -1314, {}},
    {-1700, -1215, {}},
    {-1700, -1116, {}},
    {-1700, -1017, {}},
    {-1700,  -918, {}},
    {-1700,  -819, {}},
    {-1700,  -720, {}},
    {-1700,  -621, {}},
    {-1700,  -522, {}},
    {-1700,  -423, {}},
    {-1700,  -324, {}},
    {-1700,  -225, {}},
    {-1700,  -126, {}},
    {-1700,   -27, {}},
    {-1700,    72, {}},
    {-1700,   171, {}},
    {-1700,   269, {}},
    {-1700,   368, {}},
    {-1700,   467, {}},
    {-1700,   566, {}},
    {-1700,   665, {}},
    {-1700,   764, {}},
    {-1700,   863, {}},
    {-1700,   962, {}},
    {-1700,  1061, {}},
    {-1700,  1160, {}},
    {-1720,  1180, {}},
    {-1720,  1200, {}},
    {-1720,  1220, {}},
    {-1720,  1240, {}},
    {-1720,  1260, {}},
    {-1720,  1280, {}},
    {-1700,  1300, {}},
    {-1700,  1320, {}},
    {-1700,  1340, {}},
    {-1720,  1360, {}},
    {-1740,  1380, {}},
    {-1740,  1400, {}},
    {-1740,  1420, {}},
    {-1740,  1504, {}},
    {-1740,  1588, {}},
    {-1740,  1672, {}},
    {-1740,  1756, {}},
    {-1740,  1840, {}},
    {-1760,  1860, {}},
    {-1780,  1880, {}},
    {-1780,  1900, {}},
    {-1780,  1940, {}},
    {-1780,  1960, {}},
    {-1780,  1980, {}},
    {-1800,  2020, {}},
    {-1800,  2040, {}},
    {-1800,  2060, {}},
    {-1800,  2080, {}},
    {-1800,  2120, {}},
    {-1800,  2140, {}},
    {-1780,  2240, {}},
    {-1760,  2340, {}},
    {-1740,  2420, {}},
    {-1740,  2440, {}},
    {-1760,  2460, {}},
    {-1760,  2480, {}},
    {-1760,  2500, {}},
    {-1780,  2520, {}},
    {-1780,  2540, {}},
    {-1780,  2560, {}},
    {-1780,  2580, {}},
    {-1800,  2600, {}},
    {-1780,  2620, {}},
    {-1800,  2640, {}},
    {-1800,  2660, {}},
    {-1800,  2680, {}},
    {-1800,  2700, {}},
    {-1760,  2740, {}},
    {-1740,  2760, {}},
    {-1700,  2780, {}},
    {-1680,  2820, {}},
    {-1660,  2860, {}},
    {-1640,  2880, {}},
    {-1620,  2880, {}},
    {-1600,  2880, {}},
    {-1600,  2900, {}},
    {-1580,  2920, {}},
    {-1560,  2940, {}},
    {-1560,  2960, {}},
    {-1560,  2980, {}},
    {-1560,  3000, {}},
    {-1560,  3020, {}},
    {-1560,  3040, {}},
    {-1600,  3040, {}},
    {-1600,  3100, {}},
    {-1600,  3120, {}},
    {-1620,  3140, {}},
    {-1620,  3160, {}},
    {-1620,  3180, {}},
    {-1640,  3200, {}},
    {-1640,  3220, {}},
    {-1640,  3240, {}},
    {-1660,  3280, {}},
    {-1680,  3300, {}},
    {-1700,  3300, {}},
    {-1740,  3300, {}},
    {-1760,  3300, {}},
    {-1780,  3300, {}},
    {-1800,  3300, {}},
    {-1820,  3300, {}},
    {-1840,  3300, {}},
    {-1860,  3300, {}},
    {-1880,  3280, {}},
    {-1900,  3280, {}},
    {-1920,  3280, {}},
    {-1940,  3280, {}},
    {-1960,  3280, {}},
    {-1980,  3300, {}},
    {-2000,  3300, {}},
    {-2020,  3280, {}},
    {-2040,  3280, {}},
    {-2060,  3260, {}},
    {-2080,  3260, {}},
    {-2120,  3240, {}},
    {-2200,  3180, {}},
    {-2240,  3140, {}},
    {-2320,  3160, {}},
    {-2340,  3160, {}},
    {-2360,  3160, {}},
    {-2380,  3180, {}},
    {-2420,  3200, {}},
    {-2440,  3200, {}},
    {-2460,  3200, {}},
    {-2500,  3200, {}},
    {-2520,  3200, {}},
    {-2540,  3200, {}},
    {-2560,  3200, {}},
    {-2580,  3200, {}},
    {-2600,  3200, {}},
    {-2640,  3200, {}},
    {-2680,  3220, {}},
    {-2680,  3260, {}},
    {-2680,  3280, {}},
    {-2760,  3360, {}},
    {-2840,  3440, {}},
    {-2920,  3520, {}},
    {-3000,  3600, {}},
    {-3100,  3600, {}},
    {-3200,  3600, {}},
    {-3300,  3600, {}},
    {-3400,  3600, {}},
    {-3500,  3600, {}},
    {-3600,  3600, {}},
    {-3700,  3600, {}},
    {-3800,  3600, {}},
    {-3900,  3600, {}},
    {-4000,  3600, {}},
    {-4100,  3600, {}},
    {-4200,  3600, {}},
    {-4300,  3600, {}},
    {-4400,  3600, {}},
    {-4400,  3700, {}},
    {-4400,  3800, {}},
    {-4400,  3900, {}},
    {-4400,  4000, {}},
    {-4500,  4000, {}},
    {-4600,  4000, {}},
    {-4700,  4000, {}},
    {-4800,  4000, {}},
    {-4900,  4000, {}},
    {-4900,  3900, {}},
    {-4900,  3800, {}},
    {-4900,  3700, {}},
    {-4900,  3600, {}},
    {-5000,  3600, {}},
    {-5100,  3600, {}},
    {-5200,  3600, {}},
    {-5300,  3600, {}},
    {-5400,  3600, {}},
    {-5500,  3600, {}},
    {-5600,  3600, {}},
    {-5700,  3600, {}},
    {-5800,  3600, {}},
    {-5900,  3600, {}},
    {-6000,  3600, {}},
    {-6100,  3600, {}},
    {-6200,  3600, {}},
    {-6300,  3600, {}},
    {-6400,  3600, {}},
    {-6500,  3600, {}},
    {-6600,  3600, {}},
    {-6700,  3600, {}},
    {-6800,  3600, {}},
    {-6900,  3600, {}},
    {-7000,  3600, {}},
    {-7100,  3600, {}},
    {-7200,  3600, {}},
    {-7300,  3600, {}},
    {-7400,  3600, {}},
    {-7500,  3600, {}},
    {-7600,  3600, {}},
    {-7700,  3600, {}},
    {-7800,  3600, {}},
    {-7900,  3600, {}},
    {-8000,  3600, {}},
    {-8100,  3600, {}},
    {-8200,  3600, {}},
    {-8300,  3600, {}},
    {-8400,  3600, {}},
    {-8500,  3600, {}},
    {-8600,  3600, {}},
    {-8700,  3600, {}},
    {-8800,  3600, {}},
    {-8900,  3600, {}},
    {-9000,  3600, {}},
    {-9000,  3500, {}},
    {-9000,  3400, {}},
    {-9000,  3300, {}},
    {-9000,  3200, {}},
    {-9000,  3100, {}},
    {-9000,  3000, {}},
    {-9000,  2900, {}},
    {-9000,  2800, {}},
    {-9000,  2700, {}},
    {-9000,  2600, {}},
    {-9000,  2500, {}},
    {-9000,  2400, {}},
    {-9000,  2300, {}},
    {-9000,  2200, {}},
    {-9000,  2100, {}},
    {-9000,  2000, {}},
    {-9000,  1900, {}},
    {-9000,  1800, {}},
    {-9000,  1700, {}},
    {-9000,  1600, {}},
    {-9000,  1500, {}},
    {-9000,  1400, {}},
    {-9000,  1300, {}},
    {-9000,  1200, {}},
    {-9000,  1100, {}},
    {-9000,  1000, {}},
    {-9000,   900, {}},
    {-9000,   800, {}},
    {-9000,   700, {}},
    {-9000,   600, {}},
    {-9000,   500, {}},
    {-9000,   400, {}},
    {-9000,   300, {}},
    {-9000,   200, {}},
    {-9000,   100, {}},
    {-9000,     0, {}},
    {-9000,  -100, {}},
    {-9000,  -200, {}},
    {-9000,  -300, {}},
    {-9000,  -400, {}},
    {-9000,  -500, {}},
    {-9000,  -600, {}},
    {-9000,  -700, {}},
    {-9000,  -800, {}},
    {-9000,  -900, {}},
    {-9000, -1000, {}},
    {-9000, -1100, {}},
    {-9000, -1200, {}},
    {-9000, -1300, {}},
    {-9000, -1400, {}},
    {-9000, -1500, {}},
    {-9000, -1600, {}},
    {-9000, -1700, {}},
    {-9000, -1800, {}},
    {-9000, -1900, {}},
    {-9000, -2000, {}},
    {-9000, -2100, {}},
    {-9000, -2200, {}},
    {-9000, -2300, {}},
    {-9000, -2400, {}},
    {-9000, -2500, {}},
    {-9000, -2600, {}},
    {-8900, -2600, {}},
    {-8800, -2600, {}},
    {-8700, -2600, {}},
    {-8600, -2600, {}},
    {-8500, -2600, {}},
    {-8400, -2600, {}},
    {-8300, -2600, {}},
    {-8200, -2600, {}},
    {-8100, -2600, {}},
    {-8000, -2600, {}},
    {-7900, -2600, {}},
    {-7800, -2600, {}},
    {-7700, -2600, {}},
    {-7600, -2600, {}},
    {-7500, -2600, {}},
    {-7400, -2600, {}},
    {-7300, -2600, {}},
    {-7200, -2600, {}},
    {-7100, -2600, {}},
    {-7000, -2600, {}},
    {-6900, -2600, {}},
    {-6800, -2600, {}},
    {-6700, -2600, {}},
    {-6600, -2600, {}},
    {-6500, -2600, {}},
    {-6400, -2600, {}},
    {-6300, -2600, {}},
    {-6200, -2600, {}},
    {-6100, -2600, {}},
    {-6000, -2600, {}},
    {-5900, -2600, {}},
    {-5800, -2600, {}},
    {-5700, -2600, {}},
    {-5600, -2600, {}},
    {-5500, -2600, {}},
    {-5400, -2600, {}},
    {-5300, -2600, {}},
    {-5200, -2600, {}},
    {-5100, -2600, {}},
    {-5000, -2600, {}},
    {-4900, -2600, {}},
    {-4800, -2600, {}},
    {-4700, -2600, {}},
    {-4600, -2600, {}},
    {-4500, -2600, {}},
    {-4400, -2600, {}},
    {-4300, -2600, {}},
    {-4200, -2600, {}},
    {-4100, -2600, {}},
    {-4000, -2600, {}},
    {-3900, -2600, {}},
    {-3800, -2600, {}},
    {-3700, -2600, {}},
    {-3600, -2600, {}},
    {-3500, -2600, {}},
    {-3400, -2600, {}},
    {-3300, -2600, {}},
    {-3200, -2600, {}},
    {-3100, -2600, {}},
    {-3000, -2600, {}},
    {-2900, -2600, {}},
    {-2800, -2600, {}},
    {-2700, -2600, {}},
    {-2600, -2600, {}},
    {-2500, -2600, {}},
    {-2400, -2600, {}},
    {-2300, -2600, {}},
    {-2200, -2600, {}},
    {-2100, -2600, {}},
    {-2000, -2600, {}},
    {-1900, -2600, {}},
    {-1800, -2600, {}},
    {-1700, -2600, {}},
};

static ZoneVertex cqz39[] = {
    {-9000,  3600, {}},
    {-8900,  3600, {}},
    {-8800,  3600, {}},
    {-8700,  3600, {}},
    {-8600,  3600, {}},
    {-8500,  3600, {}},
    {-8400,  3600, {}},
    {-8300,  3600, {}},
    {-8200,  3600, {}},
    {-8100,  3600, {}},
    {-8000,  3600, {}},
    {-7900,  3600, {}},
    {-7800,  3600, {}},
    {-7700,  3600, {}},
    {-7600,  3600, {}},
    {-7500,  3600, {}},
    {-7400,  3600, {}},
    {-7300,  3600, {}},
    {-7200,  3600, {}},
    {-7100,  3600, {}},
    {-7000,  3600, {}},
    {-6900,  3600, {}},
    {-6800,  3600, {}},
    {-6700,  3600, {}},
    {-6600,  3600, {}},
    {-6500,  3600, {}},
    {-6400,  3600, {}},
    {-6300,  3600, {}},
    {-6200,  3600, {}},
    {-6100,  3600, {}},
    {-6000,  3600, {}},
    {-5900,  3600, {}},
    {-5800,  3600, {}},
    {-5700,  3600, {}},
    {-5600,  3600, {}},
    {-5500,  3600, {}},
    {-5400,  3600, {}},
    {-5300,  3600, {}},
    {-5200,  3600, {}},
    {-5100,  3600, {}},
    {-5000,  3600, {}},
    {-4900,  3600, {}},
    {-4900,  3700, {}},
    {-4900,  3800, {}},
    {-4900,  3900, {}},
    {-4900,  4000, {}},
    {-4800,  4000, {}},
    {-4700,  4000, {}},
    {-4600,  4000, {}},
    {-4500,  4000, {}},
    {-4400,  4000, {}},
    {-4400,  3900, {}},
    {-4400,  3800, {}},
    {-4400,  3700, {}},
    {-4400,  3600, {}},
    {-4300,  3600, {}},
    {-4200,  3600, {}},
    {-4100,  3600, {}},
    {-4000,  3600, {}},
    {-3900,  3600, {}},
    {-3800,  3600, {}},
    {-3700,  3600, {}},
    {-3600,  3600, {}},
    {-3500,  3600, {}},
    {-3400,  3600, {}},
    {-3300,  3600, {}},
    {-3200,  3600, {}},
    {-3100,  3600, {}},
    {-3000,  3600, {}},
    {-2905,  3631, {}},
    {-2809,  3662, {}},
    {-2714,  3692, {}},
    {-2618,  3723, {}},
    {-2523,  3754, {}},
    {-2428,  3785, {}},
    {-2332,  3815, {}},
    {-2237,  3846, {}},
    {-2142,  3877, {}},
    {-2046,  3908, {}},
    {-1951,  3938, {}},
    {-1855,  3969, {}},
    {-1760,  4000, {}},
    {-1673,  4067, {}},
    {-1587,  4133, {}},
    {-1500,  4200, {}},
    {-1400,  4200, {}},
    {-1300,  4200, {}},
    {-1200,  4200, {}},
    {-1100,  4200, {}},
    {-1000,  4200, {}},
    { -900,  4200, {}},
    { -800,  4200, {}},
    { -762,  4300, {}},
    { -723,  4400, {}},
    { -685,  4500, {}},
    { -646,  4600, {}},
    { -608,  4700, {}},
    { -569,  4800, {}},
    { -531,  4900, {}},
    { -492,  5000, {}},
    { -454,  5100, {}},
    { -415,  5200, {}},
    { -377,  5300, {}},
    { -338,  5400, {}},
    { -300,  5500, {}},
    { -300,  5600, {}},
    { -300,  5700, {}},
    { -300,  5800, {}},
    { -300,  5900, {}},
    { -300,  6000, {}},
    { -300,  6100, {}},
    { -300,  6200, {}},
    { -300,  6300, {}},
    { -300,  6400, {}},
    { -300,  6500, {}},
    { -300,  6600, {}},
    { -300,  6700, {}},
    { -300,  6800, {}},
    { -300,  6900, {}},
    { -300,  7000, {}},
    { -300,  7100, {}},
    { -300,  7200, {}},
    { -300,  7300, {}},
    { -300,  7400, {}},
    { -300,  7500, {}},
    { -300,  7600, {}},
    { -300,  7700, {}},
    { -300,  7800, {}},
    { -300,  7900, {}},
    { -300,  8000, {}},
    { -300,  8100, {}},
    { -300,  8200, {}},
    { -300,  8300, {}},
    { -300,  8400, {}},
    { -300,  8500, {}},
    { -300,  8600, {}},
    { -300,  8700, {}},
    { -300,  8800, {}},
    { -300,  8900, {}},
    { -300,  9000, {}},
    { -400,  9000, {}},
    { -500,  9000, {}},
    { -600,  9000, {}},
    { -700,  9000, {}},
    { -800,  9000, {}},
    { -900,  9000, {}},
    {-1000,  9000, {}},
    {-1100,  9000, {}},
    {-1200,  9000, {}},
    {-1300,  9000, {}},
    {-1400,  9000, {}},
    {-1500,  9000, {}},
    {-1600,  9000, {}},
    {-1700,  9000, {}},
    {-1800,  9000, {}},
    {-1900,  9000, {}},
    {-2000,  9000, {}},
    {-2100,  9000, {}},
    {-2200,  9000, {}},
    {-2300,  9000, {}},
    {-2400,  9000, {}},
    {-2500,  9000, {}},
    {-2600,  9000, {}},
    {-2700,  9000, {}},
    {-2800,  9000, {}},
    {-2900,  9000, {}},
    {-3000,  9000, {}},
    {-3100,  9000, {}},
    {-3200,  9000, {}},
    {-3300,  9000, {}},
    {-3400,  9000, {}},
    {-3500,  9000, {}},
    {-3600,  9000, {}},
    {-3700,  9000, {}},
    {-3800,  9000, {}},
    {-3900,  9000, {}},
    {-4000,  9000, {}},
    {-4100,  9000, {}},
    {-4200,  9000, {}},
    {-4300,  9000, {}},
    {-4400,  9000, {}},
    {-4500,  9000, {}},
    {-4600,  9000, {}},
    {-4700,  9000, {}},
    {-4800,  9000, {}},
    {-4900,  9000, {}},
    {-5000,  9000, {}},
    {-5100,  9000, {}},
    {-5200,  9000, {}},
    {-5300,  9000, {}},
    {-5400,  9000, {}},
    {-5500,  9000, {}},
    {-5600,  9000, {}},
    {-5700,  9000, {}},
    {-5800,  9000, {}},
    {-5900,  9000, {}},
    {-6000,  9000, {}},
    {-6100,  9000, {}},
    {-6200,  9000, {}},
    {-6300,  9000, {}},
    {-6400,  9000, {}},
    {-6500,  9000, {}},
    {-6600,  9000, {}},
    {-6700,  9000, {}},
    {-6800,  9000, {}},
    {-6900,  9000, {}},
    {-7000,  9000, {}},
    {-7100,  9000, {}},
    {-7200,  9000, {}},
    {-7300,  9000, {}},
    {-7400,  9000, {}},
    {-7500,  9000, {}},
    {-7600,  9000, {}},
    {-7700,  9000, {}},
    {-7800,  9000, {}},
    {-7900,  9000, {}},
    {-8000,  9000, {}},
    {-8100,  9000, {}},
    {-8200,  9000, {}},
    {-8300,  9000, {}},
    {-8400,  9000, {}},
    {-8500,  9000, {}},
    {-8600,  9000, {}},
    {-8700,  9000, {}},
    {-8800,  9000, {}},
    {-8900,  9000, {}},
    {-9000,  9000, {}},
    {-9000,  8900, {}},
    {-9000,  8800, {}},
    {-9000,  8700, {}},
    {-9000,  8600, {}},
    {-9000,  8500, {}},
    {-9000,  8400, {}},
    {-9000,  8300, {}},
    {-9000,  8200, {}},
    {-9000,  8100, {}},
    {-9000,  8000, {}},
    {-9000,  7900, {}},
    {-9000,  7800, {}},
    {-9000,  7700, {}},
    {-9000,  7600, {}},
    {-9000,  7500, {}},
    {-9000,  7400, {}},
    {-9000,  7300, {}},
    {-9000,  7200, {}},
    {-9000,  7100, {}},
    {-9000,  7000, {}},
    {-9000,  6900, {}},
    {-9000,  6800, {}},
    {-9000,  6700, {}},
    {-9000,  6600, {}},
    {-9000,  6500, {}},
    {-9000,  6400, {}},
    {-9000,  6300, {}},
    {-9000,  6200, {}},
    {-9000,  6100, {}},
    {-9000,  6000, {}},
    {-9000,  5900, {}},
    {-9000,  5800, {}},
    {-9000,  5700, {}},
    {-9000,  5600, {}},
    {-9000,  5500, {}},
    {-9000,  5400, {}},
    {-9000,  5300, {}},
    {-9000,  5200, {}},
    {-9000,  5100, {}},
    {-9000,  5000, {}},
    {-9000,  4900, {}},
    {-9000,  4800, {}},
    {-9000,  4700, {}},
    {-9000,  4600, {}},
    {-9000,  4500, {}},
    {-9000,  4400, {}},
    {-9000,  4300, {}},
    {-9000,  4200, {}},
    {-9000,  4100, {}},
    {-9000,  4000, {}},
    {-9000,  3900, {}},
    {-9000,  3800, {}},
    {-9000,  3700, {}},
    {-9000,  3600, {}},
};

static ZoneVertex cqz40[] = {
    { 9000,  7000, {}},
    { 8900,  7000, {}},
    { 8800,  7000, {}},
    { 8700,  7000, {}},
    { 8600,  7000, {}},
    { 8500,  7000, {}},
    { 8400,  7000, {}},
    { 8300,  7000, {}},
    { 8200,  7000, {}},
    { 8100,  7000, {}},
    { 8000,  7000, {}},
    { 7986,  6900, {}},
    { 7971,  6800, {}},
    { 7957,  6700, {}},
    { 7942,  6600, {}},
    { 7928,  6500, {}},
    { 7914,  6400, {}},
    { 7899,  6300, {}},
    { 7885,  6200, {}},
    { 7870,  6100, {}},
    { 7856,  6000, {}},
    { 7842,  5900, {}},
    { 7827,  5800, {}},
    { 7813,  5700, {}},
    { 7798,  5600, {}},
    { 7784,  5500, {}},
    { 7770,  5400, {}},
    { 7755,  5300, {}},
    { 7741,  5200, {}},
    { 7726,  5100, {}},
    { 7712,  5000, {}},
    { 7698,  4900, {}},
    { 7683,  4800, {}},
    { 7669,  4700, {}},
    { 7654,  4600, {}},
    { 7640,  4500, {}},
    { 7621,  4401, {}},
    { 7601,  4301, {}},
    { 7582,  4202, {}},
    { 7563,  4103, {}},
    { 7544,  4004, {}},
    { 7524,  3904, {}},
    { 7505,  3805, {}},
    { 7486,  3706, {}},
    { 7467,  3607, {}},
    { 7447,  3507, {}},
    { 7428,  3408, {}},
    { 7409,  3309, {}},
    { 7390,  3210, {}},
    { 7370,  3110, {}},
    { 7351,  3011, {}},
    { 7332,  2912, {}},
    { 7313,  2813, {}},
    { 7293,  2713, {}},
    { 7274,  2614, {}},
    { 7255,  2515, {}},
    { 7236,  2416, {}},
    { 7216,  2316, {}},
    { 7197,  2217, {}},
    { 7178,  2118, {}},
    { 7159,  2019, {}},
    { 7139,  1919, {}},
    { 7120,  1820, {}},
    { 7092,  1722, {}},
    { 7065,  1625, {}},
    { 7037,  1527, {}},
    { 7009,  1429, {}},
    { 6982,  1332, {}},
    { 6954,  1234, {}},
    { 6926,  1136, {}},
    { 6899,  1039, {}},
    { 6871,   941, {}},
    { 6844,   844, {}},
    { 6816,   746, {}},
    { 6788,   648, {}},
    { 6761,   551, {}},
    { 6733,   453, {}},
    { 6705,   355, {}},
    { 6678,   258, {}},
    { 6650,   160, {}},
    { 6622,    62, {}},
    { 6595,   -35, {}},
    { 6567,  -133, {}},
    { 6539,  -231, {}},
    { 6512,  -328, {}},
    { 6484,  -426, {}},
    { 6456,  -524, {}},
    { 6429,  -621, {}},
    { 6401,  -719, {}},
    { 6374,  -816, {}},
    { 6346,  -914, {}},
    { 6318, -1012, {}},
    { 6291, -1109, {}},
    { 6263, -1207, {}},
    { 6235, -1305, {}},
    { 6208, -1402, {}},
    { 6180, -1500, {}},
    { 6155, -1600, {}},
    { 6130, -1700, {}},
    { 6105, -1800, {}},
    { 6080, -1900, {}},
    { 6055, -2000, {}},
    { 6030, -2100, {}},
    { 6005, -2200, {}},
    { 5980, -2300, {}},
    { 5955, -2400, {}},
    { 5930, -2500, {}},
    { 5905, -2600, {}},
    { 5880, -2700, {}},
    { 5855, -2800, {}},
    { 5830, -2900, {}},
    { 5805, -3000, {}},
    { 5780, -3100, {}},
    { 5755, -3200, {}},
    { 5730, -3300, {}},
    { 5705, -3400, {}},
    { 5680, -3500, {}},
    { 5653, -3600, {}},
    { 5626, -3700, {}},
    { 5599, -3800, {}},
    { 5571, -3900, {}},
    { 5544, -4000, {}},
    { 5517, -4100, {}},
    { 5490, -4200, {}},
    { 5463, -4300, {}},
    { 5436, -4400, {}},
    { 5409, -4500, {}},
    { 5381, -4600, {}},
    { 5354, -4700, {}},
    { 5327, -4800, {}},
    { 5300, -4900, {}},
    { 5394, -4946, {}},
    { 5489, -4991, {}},
    { 5583, -5037, {}},
    { 5677, -5083, {}},
    { 5771, -5129, {}},
    { 5866, -5174, {}},
    { 5960, -5220, {}},
    { 6055, -5290, {}},
    { 6150, -5360, {}},
    { 6245, -5430, {}},
    { 6340, -5500, {}},
    { 6435, -5570, {}},
    { 6530, -5640, {}},
    { 6625, -5710, {}},
    { 6720, -5780, {}},
    { 6790, -5880, {}},
    { 6860, -5980, {}},
    { 6930, -6080, {}},
    { 7000, -6180, {}},
    { 7070, -6280, {}},
    { 7140, -6380, {}},
    { 7210, -6480, {}},
    { 7280, -6580, {}},
    { 7350, -6680, {}},
    { 7420, -6780, {}},
    { 7437, -6869, {}},
    { 7454, -6957, {}},
    { 7471, -7046, {}},
    { 7489, -7134, {}},
    { 7506, -7223, {}},
    { 7523, -7311, {}},
    { 7540, -7400, {}},
    { 7640, -7440, {}},
    { 7740, -7480, {}},
    { 7800, -7420, {}},
    { 7860, -7360, {}},
    { 7885, -7265, {}},
    { 7910, -7170, {}},
    { 7935, -7075, {}},
    { 7960, -6980, {}},
    { 8000, -6900, {}},
    { 8040, -6820, {}},
    { 8060, -6729, {}},
    { 8080, -6638, {}},
    { 8100, -6547, {}},
    { 8120, -6456, {}},
    { 8140, -6364, {}},
    { 8160, -6273, {}},
    { 8180, -6182, {}},
    { 8200, -6091, {}},
    { 8220, -6000, {}},
    { 8318, -6000, {}},
    { 8415, -6000, {}},
    { 8513, -6000, {}},
    { 8610, -6000, {}},
    { 8708, -6000, {}},
    { 8805, -6000, {}},
    { 8903, -6000, {}},
    { 9000, -6000, {}},
    { 9000, -5900, {}},
    { 9000, -5800, {}},
    { 9000, -5700, {}},
    { 9000, -5600, {}},
    { 9000, -5500, {}},
    { 9000, -5400, {}},
    { 9000, -5300, {}},
    { 9000, -5200, {}},
    { 9000, -5100, {}},
    { 9000, -5000, {}},
    { 9000, -4900, {}},
    { 9000, -4800, {}},
    { 9000, -4700, {}},
    { 9000, -4600, {}},
    { 9000, -4500, {}},
    { 9000, -4400, {}},
    { 9000, -4300, {}},
    { 9000, -4200, {}},
    { 9000, -4100, {}},
    { 9000, -4000, {}},
    { 9000, -3900, {}},
    { 9000, -3800, {}},
    { 9000, -3700, {}},
    { 9000, -3600, {}},
    { 9000, -3500, {}},
    { 9000, -3400, {}},
    { 9000, -3300, {}},
    { 9000, -3200, {}},
    { 9000, -3100, {}},
    { 9000, -3000, {}},
    { 9000, -2900, {}},
    { 9000, -2800, {}},
    { 9000, -2700, {}},
    { 9000, -2600, {}},
    { 9000, -2500, {}},
    { 9000, -2400, {}},
    { 9000, -2300, {}},
    { 9000, -2200, {}},
    { 9000, -2100, {}},
    { 9000, -2000, {}},
    { 9000, -1900, {}},
    { 9000, -1800, {}},
    { 9000, -1700, {}},
    { 9000, -1600, {}},
    { 9000, -1500, {}},
    { 9000, -1400, {}},
    { 9000, -1300, {}},
    { 9000, -1200, {}},
    { 9000, -1100, {}},
    { 9000, -1000, {}},
    { 9000,  -900, {}},
    { 9000,  -800, {}},
    { 9000,  -700, {}},
    { 9000,  -600, {}},
    { 9000,  -500, {}},
    { 9000,  -400, {}},
    { 9000,  -300, {}},
    { 9000,  -200, {}},
    { 9000,  -100, {}},
    { 9000,     0, {}},
    { 9000,   100, {}},
    { 9000,   200, {}},
    { 9000,   300, {}},
    { 9000,   400, {}},
    { 9000,   500, {}},
    { 9000,   600, {}},
    { 9000,   700, {}},
    { 9000,   800, {}},
    { 9000,   900, {}},
    { 9000,  1000, {}},
    { 9000,  1100, {}},
    { 9000,  1200, {}},
    { 9000,  1300, {}},
    { 9000,  1400, {}},
    { 9000,  1500, {}},
    { 9000,  1600, {}},
    { 9000,  1700, {}},
    { 9000,  1800, {}},
    { 9000,  1900, {}},
    { 9000,  2000, {}},
    { 9000,  2100, {}},
    { 9000,  2200, {}},
    { 9000,  2300, {}},
    { 9000,  2400, {}},
    { 9000,  2500, {}},
    { 9000,  2600, {}},
    { 9000,  2700, {}},
    { 9000,  2800, {}},
    { 9000,  2900, {}},
    { 9000,  3000, {}},
    { 9000,  3100, {}},
    { 9000,  3200, {}},
    { 9000,  3300, {}},
    { 9000,  3400, {}},
    { 9000,  3500, {}},
    { 9000,  3600, {}},
    { 9000,  3700, {}},
    { 9000,  3800, {}},
    { 9000,  3900, {}},
    { 9000,  4000, {}},
    { 9000,  4100, {}},
    { 9000,  4200, {}},
    { 9000,  4300, {}},
    { 9000,  4400, {}},
    { 9000,  4500, {}},
    { 9000,  4600, {}},
    { 9000,  4700, {}},
    { 9000,  4800, {}},
    { 9000,  4900, {}},
    { 9000,  5000, {}},
    { 9000,  5100, {}},
    { 9000,  5200, {}},
    { 9000,  5300, {}},
    { 9000,  5400, {}},
    { 9000,  5500, {}},
    { 9000,  5600, {}},
    { 9000,  5700, {}},
    { 9000,  5800, {}},
    { 9000,  5900, {}},
    { 9000,  6000, {}},
    { 9000,  6100, {}},
    { 9000,  6200, {}},
    { 9000,  6300, {}},
    { 9000,  6400, {}},
    { 9000,  6500, {}},
    { 9000,  6600, {}},
    { 9000,  6700, {}},
    { 9000,  6800, {}},
    { 9000,  6900, {}},
    { 9000,  7000, {}},
};

static ZoneVertex ituz01[] = {
    { 8000, -14100, {}},
    { 7900, -14100, {}},
    { 7800, -14100, {}},
    { 7700, -14100, {}},
    { 7600, -14100, {}},
    { 7500, -14100, {}},
    { 7400, -14100, {}},
    { 7300, -14100, {}},
    { 7200, -14100, {}},
    { 7100, -14100, {}},
    { 7000, -14100, {}},
    { 6900, -14100, {}},
    { 6800, -14100, {}},
    { 6700, -14100, {}},
    { 6600, -14100, {}},
    { 6500, -14100, {}},
    { 6400, -14100, {}},
    { 6300, -14100, {}},
    { 6200, -14100, {}},
    { 6100, -14100, {}},
    { 6000, -14100, {}},
    { 5900, -14100, {}},
    { 5800, -14100, {}},
    { 5772, -14200, {}},
    { 5745, -14300, {}},
    { 5717, -14400, {}},
    { 5690, -14500, {}},
    { 5662, -14600, {}},
    { 5634, -14700, {}},
    { 5607, -14800, {}},
    { 5579, -14900, {}},
    { 5552, -15000, {}},
    { 5524, -15100, {}},
    { 5497, -15200, {}},
    { 5469, -15300, {}},
    { 5441, -15400, {}},
    { 5414, -15500, {}},
    { 5386, -15600, {}},
    { 5359, -15700, {}},
    { 5331, -15800, {}},
    { 5303, -15900, {}},
    { 5276, -16000, {}},
    { 5248, -16100, {}},
    { 5221, -16200, {}},
    { 5193, -16300, {}},
    { 5166, -16400, {}},
    { 5138, -16500, {}},
    { 5110, -16600, {}},
    { 5083, -16700, {}},
    { 5055, -16800, {}},
    { 5028, -16900, {}},
    { 5000, -17000, {}},
    { 5000, -17100, {}},
    { 5000, -17200, {}},
    { 5000, -17300, {}},
    { 5000, -17400, {}},
    { 5000, -17500, {}},
    { 5000, -17600, {}},
    { 5000, -17700, {}},
    { 5000, -17800, {}},
    { 5000, -17900, {}},
    { 5000, -18000, {}},
    { 5000, 17900, {}},
    { 5000, 17800, {}},
    { 5000, 17700, {}},
    { 5000, 17600, {}},
    { 5000, 17500, {}},
    { 5000, 17400, {}},
    { 5000, 17300, {}},
    { 5000, 17200, {}},
    { 5000, 17100, {}},
    { 5000, 17000, {}},
    { 5000, 16900, {}},
    { 5000, 16800, {}},
    { 5000, 16700, {}},
    { 5000, 16600, {}},
    { 5000, 16500, {}},
    { 5000, 16400, {}},
    { 5000, 16300, {}},
    { 5000, 16200, {}},
    { 5000, 16100, {}},
    { 5000, 16000, {}},
    { 5050, 16100, {}},
    { 5100, 16200, {}},
    { 5150, 16300, {}},
    { 5200, 16400, {}},
    { 5250, 16500, {}},
    { 5300, 16600, {}},
    { 5350, 16700, {}},
    { 5400, 16800, {}},
    { 5450, 16900, {}},
    { 5500, 17000, {}},
    { 5550, 17100, {}},
    { 5600, 17200, {}},
    { 5650, 17300, {}},
    { 5700, 17400, {}},
    { 5750, 17500, {}},
    { 5800, 17600, {}},
    { 5850, 17700, {}},
    { 5900, 17800, {}},
    { 5950, 17900, {}},
    { 6000, -18000, {}},
    { 6053, -17900, {}},
    { 6105, -17800, {}},
    { 6158, -17700, {}},
    { 6211, -17600, {}},
    { 6264, -17500, {}},
    { 6316, -17400, {}},
    { 6369, -17300, {}},
    { 6422, -17200, {}},
    { 6475, -17100, {}},
    { 6527, -17000, {}},
    { 6580, -16900, {}},
    { 6675, -16907, {}},
    { 6769, -16913, {}},
    { 6864, -16920, {}},
    { 6959, -16927, {}},
    { 7053, -16933, {}},
    { 7148, -16940, {}},
    { 7243, -16947, {}},
    { 7337, -16953, {}},
    { 7432, -16960, {}},
    { 7527, -16967, {}},
    { 7621, -16973, {}},
    { 7716, -16980, {}},
    { 7811, -16987, {}},
    { 7905, -16993, {}},
    { 8000, -17000, {}},
    { 8000, -16900, {}},
    { 8000, -16800, {}},
    { 8000, -16700, {}},
    { 8000, -16600, {}},
    { 8000, -16500, {}},
    { 8000, -16400, {}},
    { 8000, -16300, {}},
    { 8000, -16200, {}},
    { 8000, -16100, {}},
    { 8000, -16000, {}},
    { 8000, -15900, {}},
    { 8000, -15800, {}},
    { 8000, -15700, {}},
    { 8000, -15600, {}},
    { 8000, -15500, {}},
    { 8000, -15400, {}},
    { 8000, -15300, {}},
    { 8000, -15200, {}},
    { 8000, -15100, {}},
    { 8000, -15000, {}},
    { 8000, -14900, {}},
    { 8000, -14800, {}},
    { 8000, -14700, {}},
    { 8000, -14600, {}},
    { 8000, -14500, {}},
    { 8000, -14400, {}},
    { 8000, -14300, {}},
    { 8000, -14200, {}},
    { 8000, -14100, {}},
};

static ZoneVertex ituz02[] = {
    { 8000, -14100, {}},
    { 7904, -14100, {}},
    { 7809, -14100, {}},
    { 7713, -14100, {}},
    { 7617, -14100, {}},
    { 7522, -14100, {}},
    { 7426, -14100, {}},
    { 7330, -14100, {}},
    { 7235, -14100, {}},
    { 7139, -14100, {}},
    { 7043, -14100, {}},
    { 6948, -14100, {}},
    { 6852, -14100, {}},
    { 6757, -14100, {}},
    { 6661, -14100, {}},
    { 6565, -14100, {}},
    { 6470, -14100, {}},
    { 6374, -14100, {}},
    { 6278, -14100, {}},
    { 6183, -14100, {}},
    { 6087, -14100, {}},
    { 5991, -14100, {}},
    { 5896, -14100, {}},
    { 5800, -14100, {}},
    { 5715, -14007, {}},
    { 5629, -13915, {}},
    { 5544, -13822, {}},
    { 5458, -13729, {}},
    { 5373, -13636, {}},
    { 5287, -13544, {}},
    { 5202, -13451, {}},
    { 5116, -13358, {}},
    { 5031, -13265, {}},
    { 4945, -13173, {}},
    { 4860, -13080, {}},
    { 4860, -12980, {}},
    { 4860, -12880, {}},
    { 4860, -12780, {}},
    { 4860, -12680, {}},
    { 4860, -12580, {}},
    { 4860, -12480, {}},
    { 4840, -12420, {}},
    { 4820, -12360, {}},
    { 4820, -12320, {}},
    { 4840, -12320, {}},
    { 4860, -12320, {}},
    { 4880, -12300, {}},
    { 4900, -12340, {}},
    { 4900, -12300, {}},
    { 4900, -12200, {}},
    { 4900, -12100, {}},
    { 4900, -12000, {}},
    { 4900, -11900, {}},
    { 4900, -11800, {}},
    { 4900, -11700, {}},
    { 4900, -11600, {}},
    { 4900, -11500, {}},
    { 4900, -11400, {}},
    { 4900, -11300, {}},
    { 4900, -11200, {}},
    { 4900, -11100, {}},
    { 4900, -11000, {}},
    { 5000, -11000, {}},
    { 5100, -11000, {}},
    { 5200, -11000, {}},
    { 5300, -11000, {}},
    { 5400, -11000, {}},
    { 5500, -11000, {}},
    { 5600, -11000, {}},
    { 5700, -11000, {}},
    { 5800, -11000, {}},
    { 5900, -11000, {}},
    { 6000, -11000, {}},
    { 6100, -11000, {}},
    { 6200, -11000, {}},
    { 6300, -11000, {}},
    { 6400, -11000, {}},
    { 6500, -11000, {}},
    { 6600, -11000, {}},
    { 6700, -11000, {}},
    { 6800, -11000, {}},
    { 6900, -11000, {}},
    { 7000, -11000, {}},
    { 7100, -11000, {}},
    { 7200, -11000, {}},
    { 7300, -11000, {}},
    { 7400, -11000, {}},
    { 7500, -11000, {}},
    { 7600, -11000, {}},
    { 7700, -11000, {}},
    { 7800, -11000, {}},
    { 7900, -11000, {}},
    { 8000, -11000, {}},
    { 8000, -11100, {}},
    { 8000, -11200, {}},
    { 8000, -11300, {}},
    { 8000, -11400, {}},
    { 8000, -11500, {}},
    { 8000, -11600, {}},
    { 8000, -11700, {}},
    { 8000, -11800, {}},
    { 8000, -11900, {}},
    { 8000, -12000, {}},
    { 8000, -12100, {}},
    { 8000, -12200, {}},
    { 8000, -12300, {}},
    { 8000, -12400, {}},
    { 8000, -12500, {}},
    { 8000, -12600, {}},
    { 8000, -12700, {}},
    { 8000, -12800, {}},
    { 8000, -12900, {}},
    { 8000, -13000, {}},
    { 8000, -13100, {}},
    { 8000, -13200, {}},
    { 8000, -13300, {}},
    { 8000, -13400, {}},
    { 8000, -13500, {}},
    { 8000, -13600, {}},
    { 8000, -13700, {}},
    { 8000, -13800, {}},
    { 8000, -13900, {}},
    { 8000, -14000, {}},
    { 8000, -14100, {}},
};

static ZoneVertex ituz03[] = {
    { 8000, -11001, {}},
    { 7900, -11001, {}},
    { 7800, -11001, {}},
    { 7700, -11001, {}},
    { 7600, -11001, {}},
    { 7500, -11001, {}},
    { 7400, -11000, {}},
    { 7300, -11000, {}},
    { 7200, -11000, {}},
    { 7100, -11000, {}},
    { 7000, -11000, {}},
    { 6900, -11000, {}},
    { 6800, -11000, {}},
    { 6700, -11000, {}},
    { 6600, -11000, {}},
    { 6500, -11000, {}},
    { 6400, -11000, {}},
    { 6300, -11000, {}},
    { 6200, -11000, {}},
    { 6100, -11000, {}},
    { 6000, -11000, {}},
    { 5900, -11000, {}},
    { 5800, -11000, {}},
    { 5700, -11000, {}},
    { 5600, -11000, {}},
    { 5500, -11000, {}},
    { 5400, -11000, {}},
    { 5300, -11000, {}},
    { 5200, -11000, {}},
    { 5100, -11000, {}},
    { 5000, -11000, {}},
    { 4900, -11000, {}},
    { 4900, -10901, {}},
    { 4900, -10803, {}},
    { 4900, -10704, {}},
    { 4900, -10605, {}},
    { 4900, -10507, {}},
    { 4900, -10408, {}},
    { 4900, -10309, {}},
    { 4900, -10211, {}},
    { 4900, -10112, {}},
    { 4900, -10013, {}},
    { 4900, -9915, {}},
    { 4900, -9816, {}},
    { 4900, -9717, {}},
    { 4900, -9619, {}},
    { 4900, -9520, {}},
    { 4940, -9520, {}},
    { 4940, -9500, {}},
    { 4920, -9480, {}},
    { 4880, -9460, {}},
    { 4880, -9440, {}},
    { 4860, -9420, {}},
    { 4860, -9400, {}},
    { 4860, -9380, {}},
    { 4860, -9360, {}},
    { 4860, -9340, {}},
    { 4860, -9320, {}},
    { 4860, -9300, {}},
    { 4860, -9280, {}},
    { 4840, -9260, {}},
    { 4820, -9240, {}},
    { 4840, -9220, {}},
    { 4820, -9200, {}},
    { 4820, -9180, {}},
    { 4820, -9160, {}},
    { 4800, -9140, {}},
    { 4820, -9120, {}},
    { 4820, -9100, {}},
    { 4820, -9080, {}},
    { 4820, -9060, {}},
    { 4820, -9040, {}},
    { 4820, -9020, {}},
    { 4800, -9000, {}},
    { 4900, -9000, {}},
    { 5000, -9000, {}},
    { 5100, -9000, {}},
    { 5200, -9000, {}},
    { 5300, -9000, {}},
    { 5400, -9000, {}},
    { 5500, -9000, {}},
    { 5600, -9000, {}},
    { 5700, -9000, {}},
    { 5800, -9000, {}},
    { 5900, -9000, {}},
    { 6000, -9000, {}},
    { 6100, -9000, {}},
    { 6200, -9000, {}},
    { 6300, -9000, {}},
    { 6400, -9000, {}},
    { 6500, -9000, {}},
    { 6600, -9000, {}},
    { 6700, -9000, {}},
    { 6800, -9000, {}},
    { 6900, -9000, {}},
    { 7000, -9000, {}},
    { 7100, -9000, {}},
    { 7200, -9000, {}},
    { 7300, -9000, {}},
    { 7400, -9000, {}},
    { 7500, -9000, {}},
    { 7600, -9000, {}},
    { 7700, -9000, {}},
    { 7800, -9000, {}},
    { 7900, -9000, {}},
    { 8000, -9000, {}},
    { 8000, -9100, {}},
    { 8000, -9200, {}},
    { 8000, -9300, {}},
    { 8000, -9400, {}},
    { 8000, -9500, {}},
    { 8000, -9600, {}},
    { 8000, -9700, {}},
    { 8000, -9800, {}},
    { 8000, -9900, {}},
    { 8000, -10000, {}},
    { 8000, -10100, {}},
    { 8000, -10200, {}},
    { 8000, -10300, {}},
    { 8000, -10400, {}},
    { 8000, -10500, {}},
    { 8000, -10600, {}},
    { 8000, -10700, {}},
    { 8000, -10800, {}},
    { 8000, -10900, {}},
    { 8000, -11000, {}},
};

static ZoneVertex ituz04[] = {
    { 4806, -9000, {}},
    { 4906, -9000, {}},
    { 5006, -9000, {}},
    { 5105, -9000, {}},
    { 5205, -9000, {}},
    { 5305, -9000, {}},
    { 5405, -9000, {}},
    { 5505, -9000, {}},
    { 5604, -9000, {}},
    { 5704, -9000, {}},
    { 5804, -9000, {}},
    { 5904, -9000, {}},
    { 6004, -9000, {}},
    { 6104, -9000, {}},
    { 6203, -9000, {}},
    { 6303, -9000, {}},
    { 6403, -9000, {}},
    { 6503, -9000, {}},
    { 6603, -9000, {}},
    { 6702, -9000, {}},
    { 6802, -9000, {}},
    { 6902, -9000, {}},
    { 7002, -9000, {}},
    { 7102, -9000, {}},
    { 7201, -9000, {}},
    { 7301, -9000, {}},
    { 7401, -9000, {}},
    { 7501, -9000, {}},
    { 7601, -9000, {}},
    { 7701, -9000, {}},
    { 7800, -9000, {}},
    { 7900, -9000, {}},
    { 8000, -9000, {}},
    { 8000, -8900, {}},
    { 8000, -8800, {}},
    { 8000, -8700, {}},
    { 8000, -8600, {}},
    { 8000, -8500, {}},
    { 8000, -8400, {}},
    { 8000, -8300, {}},
    { 8000, -8200, {}},
    { 8000, -8100, {}},
    { 8000, -8000, {}},
    { 8000, -7900, {}},
    { 8000, -7800, {}},
    { 8000, -7700, {}},
    { 8000, -7600, {}},
    { 8000, -7500, {}},
    { 8000, -7400, {}},
    { 8000, -7300, {}},
    { 8000, -7200, {}},
    { 8000, -7100, {}},
    { 8000, -7000, {}},
    { 8000, -6900, {}},
    { 7975, -6990, {}},
    { 7950, -7080, {}},
    { 7925, -7170, {}},
    { 7900, -7260, {}},
    { 7847, -7347, {}},
    { 7793, -7433, {}},
    { 7740, -7520, {}},
    { 7707, -7429, {}},
    { 7673, -7338, {}},
    { 7640, -7247, {}},
    { 7607, -7156, {}},
    { 7573, -7064, {}},
    { 7540, -6973, {}},
    { 7507, -6882, {}},
    { 7473, -6791, {}},
    { 7440, -6700, {}},
    { 7346, -6609, {}},
    { 7251, -6517, {}},
    { 7157, -6426, {}},
    { 7063, -6334, {}},
    { 6969, -6243, {}},
    { 6874, -6151, {}},
    { 6780, -6060, {}},
    { 6686, -5969, {}},
    { 6591, -5877, {}},
    { 6497, -5786, {}},
    { 6403, -5694, {}},
    { 6309, -5603, {}},
    { 6214, -5511, {}},
    { 6120, -5420, {}},
    { 6120, -5519, {}},
    { 6120, -5618, {}},
    { 6120, -5716, {}},
    { 6120, -5815, {}},
    { 6120, -5914, {}},
    { 6120, -6013, {}},
    { 6120, -6111, {}},
    { 6120, -6210, {}},
    { 6120, -6309, {}},
    { 6120, -6408, {}},
    { 6120, -6506, {}},
    { 6120, -6605, {}},
    { 6120, -6704, {}},
    { 6120, -6803, {}},
    { 6120, -6901, {}},
    { 6120, -7000, {}},
    { 6023, -7000, {}},
    { 5925, -7000, {}},
    { 5828, -7000, {}},
    { 5731, -7000, {}},
    { 5633, -7000, {}},
    { 5536, -7000, {}},
    { 5439, -7000, {}},
    { 5341, -7000, {}},
    { 5244, -7000, {}},
    { 5147, -7000, {}},
    { 5049, -7000, {}},
    { 4952, -7000, {}},
    { 4855, -7000, {}},
    { 4757, -7000, {}},
    { 4660, -7000, {}},
    { 4640, -7020, {}},
    { 4620, -7020, {}},
    { 4600, -7020, {}},
    { 4580, -7040, {}},
    { 4560, -7080, {}},
    { 4540, -7060, {}},
    { 4540, -7080, {}},
    { 4540, -7100, {}},
    { 4520, -7120, {}},
    { 4520, -7140, {}},
    { 4500, -7240, {}},
    { 4500, -7320, {}},
    { 4500, -7420, {}},
    { 4500, -7480, {}},
    { 4480, -7540, {}},
    { 4440, -7580, {}},
    { 4420, -7620, {}},
    { 4400, -7640, {}},
    { 4360, -7680, {}},
    { 4360, -7770, {}},
    { 4360, -7860, {}},
    { 4340, -7920, {}},
    { 4320, -7900, {}},
    { 4300, -7900, {}},
    { 4240, -8000, {}},
    { 4230, -8060, {}},
    { 4220, -8120, {}},
    { 4190, -8180, {}},
    { 4160, -8240, {}},
    { 4160, -8260, {}},
    { 4180, -8300, {}},
    { 4200, -8320, {}},
    { 4220, -8320, {}},
    { 4240, -8280, {}},
    { 4260, -8260, {}},
    { 4300, -8240, {}},
    { 4360, -8220, {}},
    { 4450, -8240, {}},
    { 4540, -8260, {}},
    { 4580, -8360, {}},
    { 4620, -8360, {}},
    { 4620, -8380, {}},
    { 4620, -8400, {}},
    { 4660, -8420, {}},
    { 4660, -8440, {}},
    { 4660, -8480, {}},
    { 4680, -8480, {}},
    { 4720, -8570, {}},
    { 4760, -8660, {}},
    { 4800, -8750, {}},
    { 4840, -8840, {}},
    { 4820, -8860, {}},
    { 4800, -8940, {}},
    { 4800, -8960, {}},
    { 4800, -8980, {}},
    { 4800, -9000, {}},
};

static ZoneVertex ituz05[] = {
    { 7300, -1000, {}},
    { 7400, -1000, {}},
    { 7500, -1000, {}},
    { 7600, -1000, {}},
    { 7700, -1000, {}},
    { 7800, -1000, {}},
    { 7900, -1000, {}},
    { 8000, -1000, {}},
    { 8000, -1100, {}},
    { 8000, -1200, {}},
    { 8000, -1300, {}},
    { 8000, -1400, {}},
    { 8000, -1500, {}},
    { 8000, -1600, {}},
    { 8000, -1700, {}},
    { 8000, -1800, {}},
    { 8000, -1900, {}},
    { 8000, -2000, {}},
    { 8000, -2100, {}},
    { 8000, -2200, {}},
    { 8000, -2300, {}},
    { 8000, -2400, {}},
    { 8000, -2500, {}},
    { 8000, -2600, {}},
    { 8000, -2700, {}},
    { 8000, -2800, {}},
    { 8000, -2900, {}},
    { 8000, -3000, {}},
    { 8000, -3100, {}},
    { 8000, -3200, {}},
    { 8000, -3300, {}},
    { 8000, -3400, {}},
    { 8000, -3500, {}},
    { 8000, -3600, {}},
    { 8000, -3700, {}},
    { 8000, -3800, {}},
    { 8000, -3900, {}},
    { 8000, -4000, {}},
    { 8000, -4100, {}},
    { 8000, -4200, {}},
    { 8000, -4300, {}},
    { 8000, -4400, {}},
    { 8000, -4500, {}},
    { 8000, -4600, {}},
    { 8000, -4700, {}},
    { 8000, -4800, {}},
    { 8000, -4900, {}},
    { 8000, -5000, {}},
    { 8000, -5100, {}},
    { 8000, -5200, {}},
    { 8000, -5300, {}},
    { 8000, -5400, {}},
    { 8000, -5500, {}},
    { 8000, -5600, {}},
    { 8000, -5700, {}},
    { 8000, -5800, {}},
    { 8000, -5900, {}},
    { 8000, -6000, {}},
    { 8000, -6100, {}},
    { 8000, -6200, {}},
    { 8000, -6300, {}},
    { 8000, -6400, {}},
    { 8000, -6500, {}},
    { 8000, -6600, {}},
    { 8000, -6700, {}},
    { 8000, -6800, {}},
    { 8000, -6900, {}},
    { 7975, -6990, {}},
    { 7950, -7080, {}},
    { 7925, -7170, {}},
    { 7900, -7260, {}},
    { 7847, -7347, {}},
    { 7793, -7433, {}},
    { 7740, -7520, {}},
    { 7707, -7429, {}},
    { 7673, -7338, {}},
    { 7640, -7247, {}},
    { 7607, -7156, {}},
    { 7573, -7064, {}},
    { 7540, -6973, {}},
    { 7507, -6882, {}},
    { 7473, -6791, {}},
    { 7440, -6700, {}},
    { 7346, -6609, {}},
    { 7251, -6517, {}},
    { 7157, -6426, {}},
    { 7063, -6334, {}},
    { 6969, -6243, {}},
    { 6874, -6151, {}},
    { 6780, -6060, {}},
    { 6686, -5969, {}},
    { 6591, -5877, {}},
    { 6497, -5786, {}},
    { 6403, -5694, {}},
    { 6309, -5603, {}},
    { 6214, -5511, {}},
    { 6120, -5420, {}},
    { 6030, -5368, {}},
    { 5940, -5315, {}},
    { 5850, -5263, {}},
    { 5760, -5210, {}},
    { 5670, -5158, {}},
    { 5580, -5105, {}},
    { 5490, -5053, {}},
    { 5400, -5000, {}},
    { 5448, -4900, {}},
    { 5495, -4800, {}},
    { 5543, -4700, {}},
    { 5590, -4600, {}},
    { 5638, -4500, {}},
    { 5685, -4400, {}},
    { 5733, -4300, {}},
    { 5780, -4200, {}},
    { 5828, -4100, {}},
    { 5875, -4000, {}},
    { 5923, -3900, {}},
    { 5970, -3800, {}},
    { 6018, -3700, {}},
    { 6065, -3600, {}},
    { 6113, -3500, {}},
    { 6160, -3400, {}},
    { 6208, -3300, {}},
    { 6255, -3200, {}},
    { 6303, -3100, {}},
    { 6350, -3000, {}},
    { 6398, -2900, {}},
    { 6445, -2800, {}},
    { 6493, -2700, {}},
    { 6540, -2600, {}},
    { 6588, -2500, {}},
    { 6635, -2400, {}},
    { 6683, -2300, {}},
    { 6730, -2200, {}},
    { 6778, -2100, {}},
    { 6825, -2000, {}},
    { 6872, -1900, {}},
    { 6920, -1800, {}},
    { 6968, -1700, {}},
    { 7015, -1600, {}},
    { 7063, -1500, {}},
    { 7110, -1400, {}},
    { 7158, -1300, {}},
    { 7205, -1200, {}},
    { 7253, -1100, {}},
    { 7300, -1000, {}},
};

static ZoneVertex ituz06[] = {
    { 4900, -11000, {}},
    { 4820, -11000, {}},
    { 4740, -11000, {}},
    { 4660, -11000, {}},
    { 4580, -11000, {}},
    { 4500, -11000, {}},
    { 4500, -11040, {}},
    { 4500, -11060, {}},
    { 4500, -11100, {}},
    { 4400, -11100, {}},
    { 4300, -11100, {}},
    { 4200, -11100, {}},
    { 4100, -11100, {}},
    { 4100, -11000, {}},
    { 4004, -11000, {}},
    { 3908, -11000, {}},
    { 3812, -11000, {}},
    { 3716, -11000, {}},
    { 3620, -11000, {}},
    { 3524, -11000, {}},
    { 3428, -11000, {}},
    { 3332, -11000, {}},
    { 3236, -11000, {}},
    { 3140, -11000, {}},
    { 3140, -11100, {}},
    { 3165, -11195, {}},
    { 3190, -11290, {}},
    { 3215, -11385, {}},
    { 3240, -11480, {}},
    { 3260, -11480, {}},
    { 3260, -11560, {}},
    { 3260, -11640, {}},
    { 3260, -11720, {}},
    { 3258, -11813, {}},
    { 3255, -11905, {}},
    { 3253, -11998, {}},
    { 3250, -12090, {}},
    { 3248, -12183, {}},
    { 3245, -12275, {}},
    { 3242, -12368, {}},
    { 3240, -12460, {}},
    { 3335, -12496, {}},
    { 3431, -12533, {}},
    { 3526, -12569, {}},
    { 3621, -12606, {}},
    { 3716, -12642, {}},
    { 3812, -12679, {}},
    { 3907, -12715, {}},
    { 4002, -12752, {}},
    { 4098, -12788, {}},
    { 4193, -12825, {}},
    { 4288, -12861, {}},
    { 4384, -12898, {}},
    { 4479, -12934, {}},
    { 4574, -12971, {}},
    { 4669, -13007, {}},
    { 4765, -13044, {}},
    { 4860, -13080, {}},
    { 4860, -12980, {}},
    { 4860, -12880, {}},
    { 4860, -12780, {}},
    { 4860, -12680, {}},
    { 4860, -12580, {}},
    { 4860, -12480, {}},
    { 4840, -12420, {}},
    { 4820, -12360, {}},
    { 4820, -12320, {}},
    { 4840, -12320, {}},
    { 4860, -12320, {}},
    { 4880, -12300, {}},
    { 4900, -12340, {}},
    { 4900, -12240, {}},
    { 4900, -12140, {}},
    { 4900, -12052, {}},
    { 4900, -11964, {}},
    { 4900, -11876, {}},
    { 4900, -11788, {}},
    { 4900, -11700, {}},
    { 4900, -11600, {}},
    { 4900, -11500, {}},
    { 4900, -11400, {}},
    { 4900, -11300, {}},
    { 4900, -11200, {}},
    { 4900, -11100, {}},
    { 4900, -11000, {}},
};

static ZoneVertex ituz07[] = {
    { 4900, -11000, {}},
    { 4820, -11000, {}},
    { 4740, -11000, {}},
    { 4660, -11000, {}},
    { 4580, -11000, {}},
    { 4500, -11000, {}},
    { 4500, -11040, {}},
    { 4500, -11060, {}},
    { 4500, -11100, {}},
    { 4400, -11100, {}},
    { 4300, -11100, {}},
    { 4200, -11100, {}},
    { 4100, -11100, {}},
    { 4100, -11000, {}},
    { 4004, -11000, {}},
    { 3908, -11000, {}},
    { 3812, -11000, {}},
    { 3716, -11000, {}},
    { 3620, -11000, {}},
    { 3524, -11000, {}},
    { 3428, -11000, {}},
    { 3332, -11000, {}},
    { 3236, -11000, {}},
    { 3140, -11000, {}},
    { 3140, -10910, {}},
    { 3140, -10820, {}},
    { 3180, -10820, {}},
    { 3180, -10740, {}},
    { 3180, -10660, {}},
    { 3180, -10640, {}},
    { 3160, -10620, {}},
    { 3140, -10600, {}},
    { 3120, -10580, {}},
    { 3100, -10560, {}},
    { 3080, -10540, {}},
    { 3080, -10520, {}},
    { 3060, -10500, {}},
    { 3040, -10480, {}},
    { 3020, -10460, {}},
    { 3000, -10460, {}},
    { 2980, -10460, {}},
    { 2960, -10440, {}},
    { 2940, -10420, {}},
    { 2920, -10400, {}},
    { 2920, -10380, {}},
    { 2920, -10360, {}},
    { 2900, -10340, {}},
    { 2900, -10320, {}},
    { 2920, -10300, {}},
    { 2940, -10280, {}},
    { 2960, -10280, {}},
    { 2980, -10260, {}},
    { 2980, -10240, {}},
    { 2980, -10220, {}},
    { 2980, -10200, {}},
    { 2980, -10180, {}},
    { 2980, -10160, {}},
    { 2980, -10140, {}},
    { 2960, -10140, {}},
    { 2960, -10120, {}},
    { 2940, -10100, {}},
    { 2920, -10080, {}},
    { 2900, -10060, {}},
    { 2880, -10060, {}},
    { 2860, -10040, {}},
    { 2840, -10040, {}},
    { 2820, -10020, {}},
    { 2800, -10000, {}},
    { 2780, -9980, {}},
    { 2760, -9960, {}},
    { 2740, -9940, {}},
    { 2720, -9940, {}},
    { 2700, -9940, {}},
    { 2680, -9920, {}},
    { 2660, -9920, {}},
    { 2640, -9900, {}},
    { 2640, -9880, {}},
    { 2620, -9860, {}},
    { 2620, -9840, {}},
    { 2600, -9820, {}},
    { 2600, -9800, {}},
    { 2600, -9780, {}},
    { 2600, -9760, {}},
    { 2580, -9740, {}},
    { 2600, -9720, {}},
    { 2588, -9630, {}},
    { 2575, -9540, {}},
    { 2563, -9450, {}},
    { 2550, -9360, {}},
    { 2538, -9270, {}},
    { 2525, -9180, {}},
    { 2513, -9090, {}},
    { 2500, -9000, {}},
    { 2600, -9000, {}},
    { 2700, -9000, {}},
    { 2800, -9000, {}},
    { 2900, -9000, {}},
    { 3000, -9000, {}},
    { 3100, -9000, {}},
    { 3200, -9000, {}},
    { 3300, -9000, {}},
    { 3400, -9000, {}},
    { 3500, -9000, {}},
    { 3600, -9000, {}},
    { 3700, -9000, {}},
    { 3800, -9000, {}},
    { 3900, -9000, {}},
    { 4000, -9000, {}},
    { 4100, -9000, {}},
    { 4200, -9000, {}},
    { 4300, -9000, {}},
    { 4400, -9000, {}},
    { 4500, -9000, {}},
    { 4600, -9000, {}},
    { 4700, -9000, {}},
    { 4800, -9000, {}},
    { 4820, -9020, {}},
    { 4820, -9040, {}},
    { 4820, -9060, {}},
    { 4820, -9080, {}},
    { 4820, -9100, {}},
    { 4820, -9120, {}},
    { 4800, -9140, {}},
    { 4820, -9160, {}},
    { 4820, -9180, {}},
    { 4820, -9200, {}},
    { 4840, -9220, {}},
    { 4820, -9240, {}},
    { 4840, -9240, {}},
    { 4840, -9260, {}},
    { 4860, -9280, {}},
    { 4860, -9300, {}},
    { 4860, -9320, {}},
    { 4860, -9340, {}},
    { 4860, -9360, {}},
    { 4860, -9380, {}},
    { 4860, -9400, {}},
    { 4860, -9420, {}},
    { 4880, -9440, {}},
    { 4880, -9460, {}},
    { 4900, -9480, {}},
    { 4920, -9480, {}},
    { 4940, -9500, {}},
    { 4900, -9520, {}},
    { 4900, -9619, {}},
    { 4900, -9717, {}},
    { 4900, -9816, {}},
    { 4900, -9915, {}},
    { 4900, -10013, {}},
    { 4900, -10112, {}},
    { 4900, -10211, {}},
    { 4900, -10309, {}},
    { 4900, -10408, {}},
    { 4900, -10507, {}},
    { 4900, -10605, {}},
    { 4900, -10704, {}},
    { 4900, -10803, {}},
    { 4900, -10901, {}},
    { 4900, -11000, {}},
};

static ZoneVertex ituz08[] = {
    { 4803, -9000, {}},
    { 4707, -9000, {}},
    { 4611, -9000, {}},
    { 4515, -9000, {}},
    { 4420, -9000, {}},
    { 4324, -9000, {}},
    { 4228, -9000, {}},
    { 4132, -9000, {}},
    { 4036, -9000, {}},
    { 3940, -9000, {}},
    { 3844, -9000, {}},
    { 3748, -9000, {}},
    { 3652, -9000, {}},
    { 3556, -9000, {}},
    { 3460, -9000, {}},
    { 3364, -9000, {}},
    { 3268, -9000, {}},
    { 3172, -9000, {}},
    { 3076, -9000, {}},
    { 2980, -9000, {}},
    { 2884, -9000, {}},
    { 2788, -9000, {}},
    { 2692, -9000, {}},
    { 2596, -9000, {}},
    { 2500, -9000, {}},
    { 2490, -8900, {}},
    { 2480, -8800, {}},
    { 2470, -8700, {}},
    { 2460, -8600, {}},
    { 2455, -8515, {}},
    { 2450, -8430, {}},
    { 2445, -8345, {}},
    { 2440, -8260, {}},
    { 2440, -8180, {}},
    { 2440, -8100, {}},
    { 2440, -8000, {}},
    { 2520, -7940, {}},
    { 2620, -7940, {}},
    { 2720, -7940, {}},
    { 2820, -7940, {}},
    { 2920, -7940, {}},
    { 3020, -7940, {}},
    { 3080, -7880, {}},
    { 3140, -7820, {}},
    { 3237, -7727, {}},
    { 3333, -7633, {}},
    { 3430, -7540, {}},
    { 3527, -7447, {}},
    { 3623, -7353, {}},
    { 3720, -7260, {}},
    { 3817, -7167, {}},
    { 3913, -7073, {}},
    { 4010, -6980, {}},
    { 4107, -6887, {}},
    { 4203, -6793, {}},
    { 4300, -6700, {}},
    { 4380, -6700, {}},
    { 4460, -6700, {}},
    { 4480, -6700, {}},
    { 4520, -6720, {}},
    { 4520, -6740, {}},
    { 4540, -6740, {}},
    { 4560, -6780, {}},
    { 4630, -6780, {}},
    { 4700, -6780, {}},
    { 4720, -6800, {}},
    { 4740, -6820, {}},
    { 4720, -6840, {}},
    { 4720, -6860, {}},
    { 4720, -6900, {}},
    { 4740, -6900, {}},
    { 4740, -6920, {}},
    { 4660, -7000, {}},
    { 4640, -7020, {}},
    { 4620, -7020, {}},
    { 4600, -7020, {}},
    { 4580, -7040, {}},
    { 4560, -7080, {}},
    { 4540, -7060, {}},
    { 4540, -7080, {}},
    { 4540, -7100, {}},
    { 4520, -7120, {}},
    { 4520, -7140, {}},
    { 4500, -7240, {}},
    { 4500, -7320, {}},
    { 4500, -7420, {}},
    { 4500, -7480, {}},
    { 4480, -7540, {}},
    { 4440, -7580, {}},
    { 4420, -7620, {}},
    { 4400, -7640, {}},
    { 4360, -7680, {}},
    { 4360, -7770, {}},
    { 4360, -7860, {}},
    { 4340, -7920, {}},
    { 4320, -7900, {}},
    { 4300, -7900, {}},
    { 4240, -8000, {}},
    { 4230, -8060, {}},
    { 4220, -8120, {}},
    { 4190, -8180, {}},
    { 4160, -8240, {}},
    { 4160, -8260, {}},
    { 4180, -8300, {}},
    { 4200, -8320, {}},
    { 4220, -8320, {}},
    { 4240, -8280, {}},
    { 4260, -8260, {}},
    { 4300, -8240, {}},
    { 4360, -8220, {}},
    { 4450, -8240, {}},
    { 4540, -8260, {}},
    { 4580, -8360, {}},
    { 4620, -8360, {}},
    { 4620, -8380, {}},
    { 4620, -8400, {}},
    { 4660, -8420, {}},
    { 4640, -8460, {}},
    { 4680, -8480, {}},
    { 4715, -8570, {}},
    { 4750, -8660, {}},
    { 4785, -8750, {}},
    { 4820, -8840, {}},
    { 4800, -8940, {}},
    { 4800, -9000, {}},
};

static ZoneVertex ituz09[] = {
    { 4670, -7000, {}},
    { 4740, -6920, {}},
    { 4720, -6900, {}},
    { 4720, -6860, {}},
    { 4720, -6840, {}},
    { 4740, -6820, {}},
    { 4720, -6800, {}},
    { 4700, -6780, {}},
    { 4630, -6780, {}},
    { 4560, -6780, {}},
    { 4560, -6740, {}},
    { 4540, -6740, {}},
    { 4520, -6740, {}},
    { 4520, -6720, {}},
    { 4500, -6700, {}},
    { 4480, -6680, {}},
    { 4460, -6700, {}},
    { 4380, -6700, {}},
    { 4300, -6700, {}},
    { 4300, -6600, {}},
    { 4300, -6500, {}},
    { 4300, -6400, {}},
    { 4300, -6300, {}},
    { 4300, -6200, {}},
    { 4300, -6100, {}},
    { 4300, -6000, {}},
    { 4300, -5900, {}},
    { 4300, -5800, {}},
    { 4300, -5700, {}},
    { 4300, -5600, {}},
    { 4300, -5500, {}},
    { 4300, -5400, {}},
    { 4300, -5300, {}},
    { 4300, -5200, {}},
    { 4300, -5100, {}},
    { 4300, -5000, {}},
    { 4400, -5000, {}},
    { 4500, -5000, {}},
    { 4600, -5000, {}},
    { 4700, -5000, {}},
    { 4800, -5000, {}},
    { 4900, -5000, {}},
    { 5000, -5000, {}},
    { 5100, -5000, {}},
    { 5200, -5000, {}},
    { 5300, -5000, {}},
    { 5400, -5000, {}},
    { 5490, -5053, {}},
    { 5580, -5105, {}},
    { 5670, -5158, {}},
    { 5760, -5210, {}},
    { 5850, -5263, {}},
    { 5940, -5315, {}},
    { 6030, -5368, {}},
    { 6120, -5420, {}},
    { 6120, -5519, {}},
    { 6120, -5618, {}},
    { 6120, -5716, {}},
    { 6120, -5815, {}},
    { 6120, -5914, {}},
    { 6120, -6013, {}},
    { 6120, -6111, {}},
    { 6120, -6210, {}},
    { 6120, -6309, {}},
    { 6120, -6408, {}},
    { 6120, -6506, {}},
    { 6120, -6605, {}},
    { 6120, -6704, {}},
    { 6120, -6803, {}},
    { 6120, -6901, {}},
    { 6120, -7000, {}},
    { 6023, -7000, {}},
    { 5925, -7000, {}},
    { 5828, -7000, {}},
    { 5731, -7000, {}},
    { 5633, -7000, {}},
    { 5536, -7000, {}},
    { 5439, -7000, {}},
    { 5341, -7000, {}},
    { 5244, -7000, {}},
    { 5147, -7000, {}},
    { 5049, -7000, {}},
    { 4952, -7000, {}},
    { 4855, -7000, {}},
    { 4757, -7000, {}},
    { 4660, -7000, {}},
};

static ZoneVertex ituz10[] = {
    { 1454, -9224, {}},
    { 1359, -9223, {}},
    { 1264, -9223, {}},
    { 1169, -9222, {}},
    { 1074, -9222, {}},
    {  979, -9222, {}},
    {  885, -9221, {}},
    {  790, -9221, {}},
    {  695, -9220, {}},
    {  600, -9220, {}},
    {  602, -9318, {}},
    {  604, -9416, {}},
    {  607, -9513, {}},
    {  609, -9611, {}},
    {  611, -9709, {}},
    {  613, -9807, {}},
    {  616, -9904, {}},
    {  618, -10002, {}},
    {  620, -10100, {}},
    {  622, -10198, {}},
    {  624, -10296, {}},
    {  627, -10393, {}},
    {  629, -10491, {}},
    {  631, -10589, {}},
    {  633, -10687, {}},
    {  636, -10784, {}},
    {  638, -10882, {}},
    {  640, -10980, {}},
    {  740, -11037, {}},
    {  840, -11094, {}},
    {  940, -11151, {}},
    { 1040, -11208, {}},
    { 1140, -11265, {}},
    { 1240, -11322, {}},
    { 1340, -11378, {}},
    { 1440, -11435, {}},
    { 1540, -11492, {}},
    { 1640, -11549, {}},
    { 1740, -11606, {}},
    { 1840, -11663, {}},
    { 1940, -11720, {}},
    { 2040, -11777, {}},
    { 2140, -11834, {}},
    { 2240, -11891, {}},
    { 2340, -11948, {}},
    { 2440, -12005, {}},
    { 2540, -12062, {}},
    { 2640, -12118, {}},
    { 2740, -12175, {}},
    { 2840, -12232, {}},
    { 2940, -12289, {}},
    { 3040, -12346, {}},
    { 3140, -12403, {}},
    { 3240, -12460, {}},
    { 3242, -12368, {}},
    { 3245, -12275, {}},
    { 3248, -12183, {}},
    { 3250, -12090, {}},
    { 3253, -11998, {}},
    { 3255, -11905, {}},
    { 3258, -11813, {}},
    { 3260, -11720, {}},
    { 3260, -11660, {}},
    { 3260, -11600, {}},
    { 3270, -11540, {}},
    { 3280, -11480, {}},
    { 3260, -11480, {}},
    { 3230, -11390, {}},
    { 3200, -11300, {}},
    { 3170, -11200, {}},
    { 3140, -11100, {}},
    { 3140, -11000, {}},
    { 3140, -10910, {}},
    { 3140, -10820, {}},
    { 3180, -10820, {}},
    { 3180, -10740, {}},
    { 3180, -10660, {}},
    { 3180, -10640, {}},
    { 3160, -10620, {}},
    { 3140, -10600, {}},
    { 3120, -10580, {}},
    { 3100, -10560, {}},
    { 3080, -10540, {}},
    { 3080, -10520, {}},
    { 3060, -10500, {}},
    { 3040, -10480, {}},
    { 3020, -10460, {}},
    { 3000, -10460, {}},
    { 2980, -10460, {}},
    { 2960, -10440, {}},
    { 2940, -10420, {}},
    { 2920, -10400, {}},
    { 2920, -10380, {}},
    { 2920, -10360, {}},
    { 2900, -10340, {}},
    { 2900, -10320, {}},
    { 2920, -10300, {}},
    { 2940, -10280, {}},
    { 2960, -10280, {}},
    { 2980, -10260, {}},
    { 2980, -10240, {}},
    { 2980, -10220, {}},
    { 2980, -10200, {}},
    { 2980, -10180, {}},
    { 2980, -10160, {}},
    { 2980, -10140, {}},
    { 2960, -10140, {}},
    { 2960, -10120, {}},
    { 2940, -10100, {}},
    { 2920, -10080, {}},
    { 2900, -10060, {}},
    { 2880, -10060, {}},
    { 2860, -10040, {}},
    { 2840, -10040, {}},
    { 2820, -10020, {}},
    { 2800, -10000, {}},
    { 2780, -9980, {}},
    { 2760, -9960, {}},
    { 2740, -9940, {}},
    { 2720, -9940, {}},
    { 2700, -9940, {}},
    { 2680, -9920, {}},
    { 2660, -9920, {}},
    { 2640, -9900, {}},
    { 2640, -9880, {}},
    { 2620, -9860, {}},
    { 2620, -9840, {}},
    { 2600, -9820, {}},
    { 2600, -9800, {}},
    { 2600, -9780, {}},
    { 2600, -9760, {}},
    { 2580, -9740, {}},
    { 2600, -9720, {}},
    { 2588, -9630, {}},
    { 2575, -9540, {}},
    { 2563, -9450, {}},
    { 2550, -9360, {}},
    { 2538, -9270, {}},
    { 2525, -9180, {}},
    { 2513, -9090, {}},
    { 2500, -9000, {}},
    { 2490, -8900, {}},
    { 2480, -8800, {}},
    { 2470, -8700, {}},
    { 2460, -8600, {}},
    { 2371, -8600, {}},
    { 2283, -8600, {}},
    { 2194, -8600, {}},
    { 2106, -8600, {}},
    { 2017, -8600, {}},
    { 1929, -8600, {}},
    { 1840, -8600, {}},
    { 1830, -8690, {}},
    { 1820, -8780, {}},
    { 1840, -8800, {}},
    { 1840, -8840, {}},
    { 1820, -8860, {}},
    { 1800, -8880, {}},
    { 1800, -8900, {}},
    { 1790, -9000, {}},
    { 1780, -9100, {}},
    { 1720, -9100, {}},
    { 1720, -9140, {}},
    { 1700, -9120, {}},
    { 1680, -9100, {}},
    { 1680, -9080, {}},
    { 1660, -9060, {}},
    { 1640, -9040, {}},
    { 1620, -9040, {}},
    { 1610, -9110, {}},
    { 1600, -9180, {}},
    { 1520, -9220, {}},
    { 1500, -9220, {}},
    { 1480, -9220, {}},
    { 1460, -9220, {}},
};

static ZoneVertex ituz11[] = {
    { 1454, -9224, {}},
    { 1359, -9223, {}},
    { 1264, -9223, {}},
    { 1169, -9222, {}},
    { 1074, -9222, {}},
    {  979, -9222, {}},
    {  885, -9221, {}},
    {  790, -9221, {}},
    {  695, -9220, {}},
    {  600, -9220, {}},
    {  600, -9124, {}},
    {  600, -9029, {}},
    {  600, -8933, {}},
    {  600, -8837, {}},
    {  600, -8741, {}},
    {  600, -8646, {}},
    {  600, -8550, {}},
    {  600, -8454, {}},
    {  600, -8359, {}},
    {  600, -8263, {}},
    {  600, -8167, {}},
    {  600, -8071, {}},
    {  600, -7976, {}},
    {  600, -7880, {}},
    {  660, -7830, {}},
    {  720, -7780, {}},
    {  740, -7780, {}},
    {  760, -7780, {}},
    {  760, -7760, {}},
    {  780, -7740, {}},
    {  800, -7720, {}},
    {  820, -7720, {}},
    {  840, -7740, {}},
    {  860, -7740, {}},
    {  940, -7684, {}},
    { 1020, -7628, {}},
    { 1100, -7572, {}},
    { 1180, -7516, {}},
    { 1260, -7460, {}},
    { 1260, -7376, {}},
    { 1260, -7292, {}},
    { 1260, -7208, {}},
    { 1260, -7124, {}},
    { 1260, -7040, {}},
    { 1210, -6960, {}},
    { 1160, -6880, {}},
    { 1210, -6810, {}},
    { 1260, -6740, {}},
    { 1240, -6647, {}},
    { 1220, -6553, {}},
    { 1200, -6460, {}},
    { 1180, -6367, {}},
    { 1160, -6273, {}},
    { 1140, -6180, {}},
    { 1040, -6180, {}},
    { 1000, -6200, {}},
    { 1000, -6100, {}},
    { 1000, -6000, {}},
    { 1000, -5900, {}},
    { 1000, -5800, {}},
    { 1000, -5700, {}},
    { 1100, -5700, {}},
    { 1200, -5700, {}},
    { 1300, -5700, {}},
    { 1400, -5700, {}},
    { 1500, -5700, {}},
    { 1600, -5700, {}},
    { 1700, -5700, {}},
    { 1800, -5700, {}},
    { 1900, -5700, {}},
    { 2000, -5700, {}},
    { 2100, -5700, {}},
    { 2200, -5700, {}},
    { 2300, -5700, {}},
    { 2400, -5700, {}},
    { 2500, -5700, {}},
    { 2600, -5700, {}},
    { 2700, -5700, {}},
    { 2800, -5700, {}},
    { 2900, -5700, {}},
    { 3000, -5700, {}},
    { 3100, -5700, {}},
    { 3200, -5700, {}},
    { 3300, -5700, {}},
    { 3400, -5700, {}},
    { 3500, -5700, {}},
    { 3600, -5700, {}},
    { 3700, -5700, {}},
    { 3800, -5700, {}},
    { 3900, -5700, {}},
    { 4000, -5700, {}},
    { 4100, -5700, {}},
    { 4200, -5700, {}},
    { 4300, -5700, {}},
    { 4300, -5800, {}},
    { 4300, -5900, {}},
    { 4300, -6000, {}},
    { 4300, -6100, {}},
    { 4300, -6200, {}},
    { 4300, -6300, {}},
    { 4300, -6400, {}},
    { 4300, -6500, {}},
    { 4300, -6600, {}},
    { 4300, -6700, {}},
    { 4203, -6793, {}},
    { 4107, -6887, {}},
    { 4010, -6980, {}},
    { 3913, -7073, {}},
    { 3817, -7167, {}},
    { 3720, -7260, {}},
    { 3623, -7353, {}},
    { 3527, -7447, {}},
    { 3430, -7540, {}},
    { 3333, -7633, {}},
    { 3237, -7727, {}},
    { 3140, -7820, {}},
    { 3080, -7880, {}},
    { 3020, -7940, {}},
    { 2920, -7940, {}},
    { 2820, -7940, {}},
    { 2720, -7940, {}},
    { 2620, -7940, {}},
    { 2520, -7940, {}},
    { 2440, -8000, {}},
    { 2440, -8100, {}},
    { 2440, -8180, {}},
    { 2440, -8260, {}},
    { 2445, -8345, {}},
    { 2450, -8430, {}},
    { 2455, -8515, {}},
    { 2460, -8600, {}},
    { 2371, -8600, {}},
    { 2283, -8600, {}},
    { 2194, -8600, {}},
    { 2106, -8600, {}},
    { 2017, -8600, {}},
    { 1929, -8600, {}},
    { 1840, -8600, {}},
    { 1830, -8690, {}},
    { 1820, -8780, {}},
    { 1840, -8800, {}},
    { 1840, -8840, {}},
    { 1820, -8860, {}},
    { 1800, -8880, {}},
    { 1800, -8900, {}},
    { 1790, -9000, {}},
    { 1780, -9100, {}},
    { 1720, -9100, {}},
    { 1720, -9140, {}},
    { 1700, -9120, {}},
    { 1680, -9100, {}},
    { 1680, -9080, {}},
    { 1660, -9060, {}},
    { 1640, -9040, {}},
    { 1620, -9040, {}},
    { 1610, -9110, {}},
    { 1600, -9180, {}},
    { 1520, -9220, {}},
    { 1500, -9220, {}},
    { 1480, -9220, {}},
    { 1460, -9220, {}},
};

static ZoneVertex ituz12[] = {
    {  601, -9219, {}},
    {  601, -9123, {}},
    {  601, -9028, {}},
    {  601, -8932, {}},
    {  601, -8836, {}},
    {  601, -8741, {}},
    {  601, -8645, {}},
    {  601, -8549, {}},
    {  600, -8454, {}},
    {  600, -8358, {}},
    {  600, -8263, {}},
    {  600, -8167, {}},
    {  600, -8071, {}},
    {  600, -7976, {}},
    {  600, -7880, {}},
    {  660, -7830, {}},
    {  720, -7780, {}},
    {  740, -7780, {}},
    {  760, -7780, {}},
    {  760, -7760, {}},
    {  780, -7740, {}},
    {  800, -7720, {}},
    {  820, -7720, {}},
    {  840, -7740, {}},
    {  860, -7740, {}},
    {  940, -7684, {}},
    { 1020, -7628, {}},
    { 1100, -7572, {}},
    { 1180, -7516, {}},
    { 1260, -7460, {}},
    { 1260, -7376, {}},
    { 1260, -7292, {}},
    { 1260, -7208, {}},
    { 1260, -7124, {}},
    { 1260, -7040, {}},
    { 1210, -6960, {}},
    { 1160, -6880, {}},
    { 1210, -6810, {}},
    { 1260, -6740, {}},
    { 1240, -6647, {}},
    { 1220, -6553, {}},
    { 1200, -6460, {}},
    { 1180, -6367, {}},
    { 1160, -6273, {}},
    { 1140, -6180, {}},
    { 1040, -6180, {}},
    { 1000, -6200, {}},
    { 1000, -6100, {}},
    { 1000, -6000, {}},
    {  967, -5907, {}},
    {  933, -5813, {}},
    {  900, -5720, {}},
    {  867, -5627, {}},
    {  833, -5533, {}},
    {  800, -5440, {}},
    {  767, -5347, {}},
    {  733, -5253, {}},
    {  700, -5160, {}},
    {  607, -5160, {}},
    {  513, -5160, {}},
    {  420, -5160, {}},
    {  400, -5180, {}},
    {  380, -5200, {}},
    {  320, -5220, {}},
    {  260, -5260, {}},
    {  220, -5280, {}},
    {  220, -5300, {}},
    {  220, -5320, {}},
    {  220, -5360, {}},
    {  220, -5420, {}},
    {  240, -5460, {}},
    {  240, -5480, {}},
    {  260, -5500, {}},
    {  260, -5520, {}},
    {  240, -5540, {}},
    {  240, -5580, {}},
    {  220, -5620, {}},
    {  200, -5580, {}},
    {  180, -5600, {}},
    {  200, -5620, {}},
    {  200, -5640, {}},
    {  200, -5660, {}},
    {  180, -5680, {}},
    {  200, -5700, {}},
    {  200, -5720, {}},
    {  200, -5740, {}},
    {  180, -5740, {}},
    {  160, -5760, {}},
    {  160, -5780, {}},
    {  160, -5800, {}},
    {  160, -5820, {}},
    {  140, -5840, {}},
    {  120, -5860, {}},
    {  120, -5880, {}},
    {  140, -5900, {}},
    {  140, -5920, {}},
    {  160, -5940, {}},
    {  180, -5960, {}},
    {  200, -5980, {}},
    {  220, -5980, {}},
    {  240, -5980, {}},
    {  260, -6000, {}},
    {  164, -6000, {}},
    {   68, -6000, {}},
    {  -28, -6000, {}},
    { -124, -6000, {}},
    { -220, -6000, {}},
    { -316, -6000, {}},
    { -412, -6000, {}},
    { -508, -6000, {}},
    { -604, -6000, {}},
    { -700, -6000, {}},
    { -796, -6000, {}},
    { -892, -6000, {}},
    { -988, -6000, {}},
    {-1084, -6000, {}},
    {-1180, -6000, {}},
    {-1276, -6000, {}},
    {-1372, -6000, {}},
    {-1468, -6000, {}},
    {-1564, -6000, {}},
    {-1660, -6000, {}},
    {-1660, -6100, {}},
    {-1660, -6200, {}},
    {-1660, -6300, {}},
    {-1660, -6400, {}},
    {-1660, -6500, {}},
    {-1660, -6600, {}},
    {-1660, -6700, {}},
    {-1660, -6800, {}},
    {-1660, -6900, {}},
    {-1680, -6920, {}},
    {-1700, -6940, {}},
    {-1720, -6960, {}},
    {-1740, -6940, {}},
    {-1760, -6960, {}},
    {-1780, -6980, {}},
    {-1820, -6980, {}},
    {-1820, -7000, {}},
    {-1840, -7020, {}},
    {-1840, -7120, {}},
    {-1840, -7220, {}},
    {-1840, -7320, {}},
    {-1840, -7420, {}},
    {-1840, -7520, {}},
    {-1840, -7620, {}},
    {-1840, -7720, {}},
    {-1757, -7819, {}},
    {-1675, -7917, {}},
    {-1592, -8016, {}},
    {-1509, -8115, {}},
    {-1427, -8213, {}},
    {-1344, -8312, {}},
    {-1261, -8411, {}},
    {-1179, -8509, {}},
    {-1096, -8608, {}},
    {-1013, -8707, {}},
    { -931, -8805, {}},
    { -848, -8904, {}},
    { -765, -9003, {}},
    { -683, -9101, {}},
    { -600, -9200, {}},
    { -500, -9202, {}},
    { -400, -9203, {}},
    { -300, -9205, {}},
    { -200, -9207, {}},
    { -100, -9208, {}},
    {    0, -9210, {}},
    {  100, -9212, {}},
    {  200, -9213, {}},
    {  300, -9215, {}},
    {  400, -9217, {}},
    {  500, -9218, {}},
    {  600, -9220, {}},
};

static ZoneVertex ituz13[] = {
    {  700, -2800, {}},
    {  700, -2898, {}},
    {  700, -2997, {}},
    {  700, -3095, {}},
    {  700, -3193, {}},
    {  700, -3292, {}},
    {  700, -3390, {}},
    {  700, -3488, {}},
    {  700, -3587, {}},
    {  700, -3685, {}},
    {  700, -3783, {}},
    {  700, -3882, {}},
    {  700, -3980, {}},
    {  700, -4078, {}},
    {  700, -4177, {}},
    {  700, -4275, {}},
    {  700, -4373, {}},
    {  700, -4472, {}},
    {  700, -4570, {}},
    {  700, -4668, {}},
    {  700, -4767, {}},
    {  700, -4865, {}},
    {  700, -4963, {}},
    {  700, -5062, {}},
    {  700, -5160, {}},
    {  607, -5160, {}},
    {  513, -5160, {}},
    {  420, -5160, {}},
    {  400, -5180, {}},
    {  380, -5200, {}},
    {  320, -5220, {}},
    {  260, -5260, {}},
    {  220, -5280, {}},
    {  220, -5300, {}},
    {  220, -5320, {}},
    {  220, -5360, {}},
    {  220, -5420, {}},
    {  240, -5460, {}},
    {  240, -5480, {}},
    {  260, -5500, {}},
    {  260, -5520, {}},
    {  240, -5540, {}},
    {  240, -5580, {}},
    {  220, -5620, {}},
    {  200, -5580, {}},
    {  180, -5600, {}},
    {  200, -5620, {}},
    {  200, -5640, {}},
    {  200, -5660, {}},
    {  180, -5680, {}},
    {  200, -5700, {}},
    {  200, -5720, {}},
    {  200, -5740, {}},
    {  180, -5740, {}},
    {  160, -5760, {}},
    {  160, -5780, {}},
    {  160, -5800, {}},
    {  160, -5820, {}},
    {  140, -5840, {}},
    {  120, -5860, {}},
    {  120, -5880, {}},
    {  140, -5900, {}},
    {  140, -5920, {}},
    {  160, -5940, {}},
    {  180, -5960, {}},
    {  200, -5980, {}},
    {  220, -5980, {}},
    {  240, -5980, {}},
    {  260, -6000, {}},
    {  164, -6000, {}},
    {   68, -6000, {}},
    {  -28, -6000, {}},
    { -124, -6000, {}},
    { -220, -6000, {}},
    { -316, -6000, {}},
    { -412, -6000, {}},
    { -508, -6000, {}},
    { -604, -6000, {}},
    { -700, -6000, {}},
    { -796, -6000, {}},
    { -892, -6000, {}},
    { -988, -6000, {}},
    {-1084, -6000, {}},
    {-1180, -6000, {}},
    {-1276, -6000, {}},
    {-1372, -6000, {}},
    {-1468, -6000, {}},
    {-1564, -6000, {}},
    {-1660, -6000, {}},
    {-1660, -5900, {}},
    {-1660, -5800, {}},
    {-1660, -5700, {}},
    {-1660, -5600, {}},
    {-1660, -5500, {}},
    {-1660, -5400, {}},
    {-1660, -5300, {}},
    {-1660, -5200, {}},
    {-1660, -5100, {}},
    {-1660, -5000, {}},
    {-1660, -4900, {}},
    {-1660, -4800, {}},
    {-1660, -4700, {}},
    {-1660, -4600, {}},
    {-1660, -4500, {}},
    {-1660, -4400, {}},
    {-1660, -4300, {}},
    {-1660, -4200, {}},
    {-1660, -4100, {}},
    {-1660, -4000, {}},
    {-1660, -3900, {}},
    {-1660, -3800, {}},
    {-1660, -3700, {}},
    {-1660, -3600, {}},
    {-1660, -3500, {}},
    {-1660, -3400, {}},
    {-1660, -3300, {}},
    {-1660, -3200, {}},
    {-1660, -3100, {}},
    {-1660, -3000, {}},
    {-1660, -2900, {}},
    {-1660, -2800, {}},
    {-1562, -2800, {}},
    {-1463, -2800, {}},
    {-1365, -2800, {}},
    {-1267, -2800, {}},
    {-1168, -2800, {}},
    {-1070, -2800, {}},
    { -972, -2800, {}},
    { -873, -2800, {}},
    { -775, -2800, {}},
    { -677, -2800, {}},
    { -578, -2800, {}},
    { -480, -2800, {}},
    { -382, -2800, {}},
    { -283, -2800, {}},
    { -185, -2800, {}},
    {  -87, -2800, {}},
    {   12, -2800, {}},
    {  110, -2800, {}},
    {  208, -2800, {}},
    {  307, -2800, {}},
    {  405, -2800, {}},
    {  503, -2800, {}},
    {  602, -2800, {}},
    {  700, -2800, {}},
};

static ZoneVertex ituz14[] = {
    {-1650, -5834, {}},
    {-1651, -5931, {}},
    {-1652, -6028, {}},
    {-1653, -6125, {}},
    {-1654, -6221, {}},
    {-1655, -6318, {}},
    {-1655, -6415, {}},
    {-1656, -6512, {}},
    {-1657, -6609, {}},
    {-1658, -6706, {}},
    {-1659, -6803, {}},
    {-1660, -6900, {}},
    {-1680, -6920, {}},
    {-1700, -6940, {}},
    {-1720, -6960, {}},
    {-1740, -6940, {}},
    {-1760, -6960, {}},
    {-1780, -6980, {}},
    {-1820, -6980, {}},
    {-1820, -7000, {}},
    {-1840, -7020, {}},
    {-1840, -7120, {}},
    {-1840, -7220, {}},
    {-1840, -7320, {}},
    {-1840, -7420, {}},
    {-1840, -7520, {}},
    {-1840, -7620, {}},
    {-1840, -7720, {}},
    {-1936, -7765, {}},
    {-2033, -7811, {}},
    {-2129, -7856, {}},
    {-2225, -7902, {}},
    {-2322, -7947, {}},
    {-2418, -7993, {}},
    {-2515, -8038, {}},
    {-2611, -8084, {}},
    {-2707, -8129, {}},
    {-2804, -8175, {}},
    {-2900, -8220, {}},
    {-3000, -8195, {}},
    {-3100, -8169, {}},
    {-3200, -8144, {}},
    {-3300, -8118, {}},
    {-3400, -8093, {}},
    {-3500, -8067, {}},
    {-3600, -8042, {}},
    {-3700, -8016, {}},
    {-3800, -7991, {}},
    {-3900, -7965, {}},
    {-4000, -7940, {}},
    {-4000, -7842, {}},
    {-4000, -7744, {}},
    {-4000, -7646, {}},
    {-4000, -7549, {}},
    {-4000, -7451, {}},
    {-4000, -7353, {}},
    {-4000, -7255, {}},
    {-4000, -7157, {}},
    {-4000, -7059, {}},
    {-4000, -6961, {}},
    {-4000, -6864, {}},
    {-4000, -6766, {}},
    {-4000, -6668, {}},
    {-4000, -6570, {}},
    {-4000, -6472, {}},
    {-4000, -6374, {}},
    {-4000, -6276, {}},
    {-4000, -6179, {}},
    {-4000, -6081, {}},
    {-4000, -5983, {}},
    {-4000, -5885, {}},
    {-4000, -5787, {}},
    {-4000, -5689, {}},
    {-4000, -5591, {}},
    {-4000, -5494, {}},
    {-4000, -5396, {}},
    {-4000, -5298, {}},
    {-4000, -5200, {}},
    {-3911, -5200, {}},
    {-3823, -5200, {}},
    {-3734, -5200, {}},
    {-3646, -5200, {}},
    {-3557, -5200, {}},
    {-3469, -5200, {}},
    {-3380, -5200, {}},
    {-3380, -5270, {}},
    {-3380, -5340, {}},
    {-3360, -5360, {}},
    {-3340, -5360, {}},
    {-3320, -5360, {}},
    {-3300, -5320, {}},
    {-3280, -5320, {}},
    {-3260, -5340, {}},
    {-3240, -5360, {}},
    {-3220, -5360, {}},
    {-3200, -5380, {}},
    {-3200, -5400, {}},
    {-3180, -5420, {}},
    {-3180, -5440, {}},
    {-3160, -5440, {}},
    {-3140, -5460, {}},
    {-3140, -5480, {}},
    {-3120, -5500, {}},
    {-3120, -5520, {}},
    {-3100, -5540, {}},
    {-3080, -5560, {}},
    {-3100, -5580, {}},
    {-3100, -5600, {}},
    {-3080, -5600, {}},
    {-3060, -5620, {}},
    {-3040, -5640, {}},
    {-3020, -5660, {}},
    {-3020, -5680, {}},
    {-3000, -5700, {}},
    {-3020, -5720, {}},
    {-3020, -5740, {}},
    {-3020, -5760, {}},
    {-3000, -5740, {}},
    {-2980, -5720, {}},
    {-2960, -5700, {}},
    {-2940, -5680, {}},
    {-2920, -5660, {}},
    {-2900, -5640, {}},
    {-2880, -5620, {}},
    {-2860, -5600, {}},
    {-2840, -5580, {}},
    {-2820, -5560, {}},
    {-2800, -5540, {}},
    {-2780, -5520, {}},
    {-2780, -5500, {}},
    {-2760, -5480, {}},
    {-2760, -5460, {}},
    {-2740, -5440, {}},
    {-2740, -5420, {}},
    {-2720, -5400, {}},
    {-2720, -5380, {}},
    {-2700, -5380, {}},
    {-2680, -5380, {}},
    {-2660, -5380, {}},
    {-2640, -5380, {}},
    {-2620, -5360, {}},
    {-2600, -5380, {}},
    {-2580, -5380, {}},
    {-2560, -5400, {}},
    {-2560, -5420, {}},
    {-2560, -5440, {}},
    {-2560, -5460, {}},
    {-2540, -5460, {}},
    {-2520, -5440, {}},
    {-2500, -5440, {}},
    {-2480, -5440, {}},
    {-2460, -5440, {}},
    {-2440, -5420, {}},
    {-2420, -5440, {}},
    {-2400, -5440, {}},
    {-2380, -5460, {}},
    {-2380, -5480, {}},
    {-2400, -5500, {}},
    {-2400, -5520, {}},
    {-2400, -5540, {}},
    {-2380, -5540, {}},
    {-2360, -5560, {}},
    {-2340, -5560, {}},
    {-2320, -5560, {}},
    {-2300, -5560, {}},
    {-2280, -5560, {}},
    {-2260, -5560, {}},
    {-2240, -5580, {}},
    {-2220, -5600, {}},
    {-2220, -5620, {}},
    {-2200, -5640, {}},
    {-2220, -5660, {}},
    {-2220, -5680, {}},
    {-2220, -5700, {}},
    {-2220, -5720, {}},
    {-2220, -5740, {}},
    {-2220, -5760, {}},
    {-2220, -5780, {}},
    {-2200, -5800, {}},
    {-2180, -5800, {}},
    {-2160, -5800, {}},
    {-2140, -5800, {}},
    {-2120, -5780, {}},
    {-2100, -5780, {}},
    {-2080, -5780, {}},
    {-2060, -5800, {}},
    {-2040, -5800, {}},
    {-2020, -5820, {}},
    {-2000, -5800, {}},
    {-1980, -5820, {}},
    {-1940, -5800, {}},
    {-1900, -5780, {}},
    {-1820, -5760, {}},
    {-1780, -5780, {}},
    {-1760, -5780, {}},
    {-1760, -5800, {}},
    {-1740, -5820, {}},
    {-1720, -5840, {}},
    {-1700, -5840, {}},
    {-1680, -5840, {}},
    {-1660, -5840, {}},
};

static ZoneVertex ituz15[] = {
    {-1652, -5835, {}},
    {-1653, -5738, {}},
    {-1653, -5640, {}},
    {-1653, -5542, {}},
    {-1653, -5444, {}},
    {-1654, -5346, {}},
    {-1654, -5248, {}},
    {-1654, -5150, {}},
    {-1654, -5052, {}},
    {-1655, -4954, {}},
    {-1655, -4856, {}},
    {-1655, -4758, {}},
    {-1655, -4660, {}},
    {-1656, -4563, {}},
    {-1656, -4465, {}},
    {-1656, -4367, {}},
    {-1656, -4269, {}},
    {-1657, -4171, {}},
    {-1657, -4073, {}},
    {-1657, -3975, {}},
    {-1657, -3877, {}},
    {-1658, -3779, {}},
    {-1658, -3681, {}},
    {-1658, -3583, {}},
    {-1658, -3485, {}},
    {-1659, -3388, {}},
    {-1659, -3290, {}},
    {-1659, -3192, {}},
    {-1659, -3094, {}},
    {-1660, -2996, {}},
    {-1660, -2898, {}},
    {-1660, -2800, {}},
    {-1758, -2800, {}},
    {-1855, -2800, {}},
    {-1953, -2800, {}},
    {-2050, -2800, {}},
    {-2148, -2800, {}},
    {-2245, -2800, {}},
    {-2343, -2800, {}},
    {-2440, -2800, {}},
    {-2538, -2800, {}},
    {-2635, -2800, {}},
    {-2733, -2800, {}},
    {-2830, -2800, {}},
    {-2928, -2800, {}},
    {-3025, -2800, {}},
    {-3123, -2800, {}},
    {-3220, -2800, {}},
    {-3317, -2800, {}},
    {-3415, -2800, {}},
    {-3513, -2800, {}},
    {-3610, -2800, {}},
    {-3708, -2800, {}},
    {-3805, -2800, {}},
    {-3903, -2800, {}},
    {-4000, -2800, {}},
    {-4000, -2900, {}},
    {-4000, -3000, {}},
    {-4000, -3100, {}},
    {-4000, -3200, {}},
    {-4000, -3300, {}},
    {-4000, -3400, {}},
    {-4000, -3500, {}},
    {-4000, -3600, {}},
    {-4000, -3700, {}},
    {-4000, -3800, {}},
    {-4000, -3900, {}},
    {-4000, -4000, {}},
    {-4000, -4100, {}},
    {-4000, -4200, {}},
    {-4000, -4300, {}},
    {-4000, -4400, {}},
    {-4000, -4500, {}},
    {-4000, -4600, {}},
    {-4000, -4700, {}},
    {-4000, -4800, {}},
    {-4000, -4900, {}},
    {-4000, -5000, {}},
    {-4000, -5100, {}},
    {-4000, -5200, {}},
    {-3911, -5200, {}},
    {-3823, -5200, {}},
    {-3734, -5200, {}},
    {-3646, -5200, {}},
    {-3557, -5200, {}},
    {-3469, -5200, {}},
    {-3380, -5200, {}},
    {-3380, -5270, {}},
    {-3380, -5340, {}},
    {-3360, -5360, {}},
    {-3340, -5360, {}},
    {-3320, -5360, {}},
    {-3300, -5320, {}},
    {-3280, -5320, {}},
    {-3260, -5340, {}},
    {-3240, -5360, {}},
    {-3220, -5360, {}},
    {-3200, -5380, {}},
    {-3200, -5400, {}},
    {-3180, -5420, {}},
    {-3180, -5440, {}},
    {-3160, -5440, {}},
    {-3140, -5460, {}},
    {-3140, -5480, {}},
    {-3120, -5500, {}},
    {-3120, -5520, {}},
    {-3100, -5540, {}},
    {-3080, -5560, {}},
    {-3100, -5580, {}},
    {-3100, -5600, {}},
    {-3080, -5600, {}},
    {-3060, -5620, {}},
    {-3040, -5640, {}},
    {-3020, -5660, {}},
    {-3020, -5680, {}},
    {-3000, -5700, {}},
    {-3020, -5720, {}},
    {-3020, -5740, {}},
    {-3020, -5760, {}},
    {-3000, -5740, {}},
    {-2980, -5720, {}},
    {-2960, -5700, {}},
    {-2940, -5680, {}},
    {-2920, -5660, {}},
    {-2900, -5640, {}},
    {-2880, -5620, {}},
    {-2860, -5600, {}},
    {-2840, -5580, {}},
    {-2820, -5560, {}},
    {-2800, -5540, {}},
    {-2780, -5520, {}},
    {-2780, -5500, {}},
    {-2760, -5480, {}},
    {-2760, -5460, {}},
    {-2740, -5440, {}},
    {-2740, -5420, {}},
    {-2720, -5400, {}},
    {-2720, -5380, {}},
    {-2700, -5380, {}},
    {-2680, -5380, {}},
    {-2660, -5380, {}},
    {-2640, -5380, {}},
    {-2620, -5360, {}},
    {-2600, -5380, {}},
    {-2580, -5380, {}},
    {-2560, -5400, {}},
    {-2560, -5420, {}},
    {-2560, -5440, {}},
    {-2560, -5460, {}},
    {-2540, -5460, {}},
    {-2520, -5440, {}},
    {-2500, -5440, {}},
    {-2480, -5440, {}},
    {-2460, -5440, {}},
    {-2440, -5420, {}},
    {-2420, -5440, {}},
    {-2400, -5440, {}},
    {-2380, -5460, {}},
    {-2380, -5480, {}},
    {-2400, -5500, {}},
    {-2400, -5520, {}},
    {-2400, -5540, {}},
    {-2380, -5540, {}},
    {-2360, -5560, {}},
    {-2340, -5560, {}},
    {-2320, -5560, {}},
    {-2300, -5560, {}},
    {-2280, -5560, {}},
    {-2260, -5560, {}},
    {-2240, -5580, {}},
    {-2220, -5600, {}},
    {-2220, -5620, {}},
    {-2200, -5640, {}},
    {-2220, -5660, {}},
    {-2220, -5680, {}},
    {-2220, -5700, {}},
    {-2220, -5720, {}},
    {-2220, -5740, {}},
    {-2220, -5760, {}},
    {-2220, -5780, {}},
    {-2200, -5800, {}},
    {-2180, -5800, {}},
    {-2160, -5800, {}},
    {-2140, -5800, {}},
    {-2120, -5780, {}},
    {-2100, -5780, {}},
    {-2080, -5780, {}},
    {-2060, -5800, {}},
    {-2040, -5800, {}},
    {-2020, -5820, {}},
    {-2000, -5800, {}},
    {-1980, -5820, {}},
    {-1940, -5800, {}},
    {-1900, -5780, {}},
    {-1820, -5760, {}},
    {-1780, -5780, {}},
    {-1760, -5780, {}},
    {-1760, -5800, {}},
    {-1740, -5820, {}},
    {-1720, -5840, {}},
    {-1700, -5840, {}},
    {-1680, -5840, {}},
    {-1660, -5840, {}},
};

static ZoneVertex ituz16[] = {
    {-4000, -7800, {}},
    {-4000, -7700, {}},
    {-4000, -7600, {}},
    {-4000, -7500, {}},
    {-4000, -7400, {}},
    {-4000, -7300, {}},
    {-4000, -7200, {}},
    {-4000, -7100, {}},
    {-4000, -7000, {}},
    {-4000, -6900, {}},
    {-4000, -6800, {}},
    {-4000, -6700, {}},
    {-4000, -6600, {}},
    {-4000, -6500, {}},
    {-4000, -6400, {}},
    {-4000, -6300, {}},
    {-4000, -6200, {}},
    {-4000, -6100, {}},
    {-4000, -6000, {}},
    {-4000, -5900, {}},
    {-4000, -5800, {}},
    {-4000, -5700, {}},
    {-4000, -5600, {}},
    {-4000, -5500, {}},
    {-4100, -5500, {}},
    {-4200, -5500, {}},
    {-4300, -5500, {}},
    {-4400, -5500, {}},
    {-4500, -5500, {}},
    {-4600, -5500, {}},
    {-4700, -5500, {}},
    {-4800, -5500, {}},
    {-4900, -5500, {}},
    {-5000, -5500, {}},
    {-5100, -5500, {}},
    {-5200, -5500, {}},
    {-5300, -5500, {}},
    {-5400, -5500, {}},
    {-5500, -5500, {}},
    {-5600, -5500, {}},
    {-5700, -5500, {}},
    {-5800, -5500, {}},
    {-5900, -5500, {}},
    {-6000, -5500, {}},
    {-6000, -5600, {}},
    {-6000, -5700, {}},
    {-6000, -5800, {}},
    {-6000, -5900, {}},
    {-6000, -6000, {}},
    {-6000, -6100, {}},
    {-6000, -6200, {}},
    {-6000, -6300, {}},
    {-6000, -6400, {}},
    {-6000, -6500, {}},
    {-6000, -6600, {}},
    {-6000, -6700, {}},
    {-6000, -6800, {}},
    {-6000, -6900, {}},
    {-6000, -7000, {}},
    {-6000, -7100, {}},
    {-6000, -7200, {}},
    {-6000, -7300, {}},
    {-6000, -7400, {}},
    {-6000, -7500, {}},
    {-6000, -7600, {}},
    {-6000, -7700, {}},
    {-6000, -7800, {}},
    {-5900, -7800, {}},
    {-5800, -7800, {}},
    {-5700, -7800, {}},
    {-5600, -7800, {}},
    {-5500, -7800, {}},
    {-5400, -7800, {}},
    {-5300, -7800, {}},
    {-5200, -7800, {}},
    {-5100, -7800, {}},
    {-5000, -7800, {}},
    {-4900, -7800, {}},
    {-4800, -7800, {}},
    {-4700, -7800, {}},
    {-4600, -7800, {}},
    {-4500, -7800, {}},
    {-4400, -7800, {}},
    {-4300, -7800, {}},
    {-4200, -7800, {}},
    {-4100, -7800, {}},
    {-4000, -7800, {}},
};

static ZoneVertex ituz17[] = {
    { 7300, -1000, {}},
    { 7253, -1100, {}},
    { 7205, -1200, {}},
    { 7158, -1300, {}},
    { 7110, -1400, {}},
    { 7063, -1500, {}},
    { 7015, -1600, {}},
    { 6968, -1700, {}},
    { 6920, -1800, {}},
    { 6872, -1900, {}},
    { 6825, -2000, {}},
    { 6778, -2100, {}},
    { 6730, -2200, {}},
    { 6683, -2300, {}},
    { 6635, -2400, {}},
    { 6588, -2500, {}},
    { 6540, -2600, {}},
    { 6493, -2700, {}},
    { 6445, -2800, {}},
    { 6398, -2900, {}},
    { 6350, -3000, {}},
    { 6303, -3100, {}},
    { 6255, -3200, {}},
    { 6208, -3300, {}},
    { 6160, -3400, {}},
    { 6113, -3500, {}},
    { 6065, -3600, {}},
    { 6018, -3700, {}},
    { 5970, -3800, {}},
    { 5923, -3900, {}},
    { 5875, -4000, {}},
    { 5828, -4100, {}},
    { 5780, -4200, {}},
    { 5733, -4300, {}},
    { 5685, -4400, {}},
    { 5638, -4500, {}},
    { 5590, -4600, {}},
    { 5543, -4700, {}},
    { 5495, -4800, {}},
    { 5448, -4900, {}},
    { 5400, -5000, {}},
    { 5418, -4900, {}},
    { 5435, -4800, {}},
    { 5453, -4700, {}},
    { 5470, -4600, {}},
    { 5488, -4500, {}},
    { 5505, -4400, {}},
    { 5523, -4300, {}},
    { 5540, -4200, {}},
    { 5558, -4100, {}},
    { 5575, -4000, {}},
    { 5593, -3900, {}},
    { 5610, -3800, {}},
    { 5628, -3700, {}},
    { 5645, -3600, {}},
    { 5663, -3500, {}},
    { 5680, -3400, {}},
    { 5698, -3300, {}},
    { 5715, -3200, {}},
    { 5733, -3100, {}},
    { 5750, -3000, {}},
    { 5768, -2900, {}},
    { 5785, -2800, {}},
    { 5803, -2700, {}},
    { 5820, -2600, {}},
    { 5838, -2500, {}},
    { 5855, -2400, {}},
    { 5873, -2300, {}},
    { 5890, -2200, {}},
    { 5908, -2100, {}},
    { 5925, -2000, {}},
    { 5943, -1900, {}},
    { 5960, -1800, {}},
    { 5978, -1700, {}},
    { 5995, -1600, {}},
    { 6013, -1500, {}},
    { 6030, -1400, {}},
    { 6048, -1300, {}},
    { 6065, -1200, {}},
    { 6083, -1100, {}},
    { 6100, -1000, {}},
    { 6200, -1000, {}},
    { 6300, -1000, {}},
    { 6400, -1000, {}},
    { 6500, -1000, {}},
    { 6600, -1000, {}},
    { 6700, -1000, {}},
    { 6800, -1000, {}},
    { 6900, -1000, {}},
    { 7000, -1000, {}},
    { 7100, -1000, {}},
    { 7200, -1000, {}},
    { 7300, -1000, {}},
};

static ZoneVertex ituz18[] = {
    { 6100,   200, {}},
    { 6100,   100, {}},
    { 6100,     0, {}},
    { 6100,  -100, {}},
    { 6100,  -200, {}},
    { 6100,  -300, {}},
    { 6100,  -400, {}},
    { 6100,  -500, {}},
    { 6100,  -600, {}},
    { 6100,  -700, {}},
    { 6100,  -800, {}},
    { 6100,  -900, {}},
    { 6100, -1000, {}},
    { 6200, -1000, {}},
    { 6300, -1000, {}},
    { 6400, -1000, {}},
    { 6500, -1000, {}},
    { 6600, -1000, {}},
    { 6700, -1000, {}},
    { 6800, -1000, {}},
    { 6900, -1000, {}},
    { 7000, -1000, {}},
    { 7100, -1000, {}},
    { 7200, -1000, {}},
    { 7300, -1000, {}},
    { 7400, -1000, {}},
    { 7500, -1000, {}},
    { 7600, -1000, {}},
    { 7700, -1000, {}},
    { 7800, -1000, {}},
    { 7900, -1000, {}},
    { 8000, -1000, {}},
    { 8000,  -900, {}},
    { 8000,  -800, {}},
    { 8000,  -700, {}},
    { 8000,  -600, {}},
    { 8000,  -500, {}},
    { 8000,  -400, {}},
    { 8000,  -300, {}},
    { 8000,  -200, {}},
    { 8000,  -100, {}},
    { 8000,     0, {}},
    { 8000,   100, {}},
    { 8000,   200, {}},
    { 8000,   300, {}},
    { 8000,   400, {}},
    { 8000,   500, {}},
    { 8000,   600, {}},
    { 8000,   700, {}},
    { 8000,   800, {}},
    { 8000,   900, {}},
    { 8000,  1000, {}},
    { 8000,  1100, {}},
    { 8000,  1200, {}},
    { 8000,  1300, {}},
    { 8000,  1400, {}},
    { 8000,  1500, {}},
    { 8000,  1600, {}},
    { 8000,  1700, {}},
    { 8000,  1800, {}},
    { 8000,  1900, {}},
    { 8000,  2000, {}},
    { 8000,  2100, {}},
    { 8000,  2200, {}},
    { 8000,  2300, {}},
    { 8000,  2400, {}},
    { 8000,  2500, {}},
    { 8000,  2600, {}},
    { 8000,  2700, {}},
    { 8000,  2800, {}},
    { 8000,  2900, {}},
    { 8000,  3000, {}},
    { 8000,  3100, {}},
    { 8000,  3200, {}},
    { 7900,  3200, {}},
    { 7800,  3200, {}},
    { 7700,  3200, {}},
    { 7600,  3200, {}},
    { 7500,  3200, {}},
    { 7400,  3200, {}},
    { 7300,  3200, {}},
    { 7200,  3200, {}},
    { 7100,  3200, {}},
    { 7000,  3200, {}},
    { 6990,  3140, {}},
    { 6980,  3080, {}},
    { 6960,  3100, {}},
    { 6960,  3060, {}},
    { 6960,  3040, {}},
    { 6960,  3020, {}},
    { 6940,  3000, {}},
    { 6940,  2980, {}},
    { 6940,  2960, {}},
    { 6940,  2940, {}},
    { 6920,  2920, {}},
    { 6900,  2900, {}},
    { 6900,  2860, {}},
    { 6880,  2880, {}},
    { 6860,  2840, {}},
    { 6820,  2860, {}},
    { 6800,  2940, {}},
    { 6780,  2960, {}},
    { 6760,  3000, {}},
    { 6700,  2900, {}},
    { 6680,  2920, {}},
    { 6660,  2940, {}},
    { 6620,  2980, {}},
    { 6600,  3000, {}},
    { 6560,  3020, {}},
    { 6560,  3000, {}},
    { 6560,  2980, {}},
    { 6540,  2980, {}},
    { 6520,  2980, {}},
    { 6500,  2960, {}},
    { 6480,  2980, {}},
    { 6480,  3000, {}},
    { 6460,  3000, {}},
    { 6440,  3020, {}},
    { 6420,  3040, {}},
    { 6400,  3040, {}},
    { 6380,  3020, {}},
    { 6380,  3000, {}},
    { 6340,  3060, {}},
    { 6340,  3100, {}},
    { 6320,  3120, {}},
    { 6300,  3160, {}},
    { 6240,  3120, {}},
    { 6210,  3060, {}},
    { 6180,  3000, {}},
    { 6140,  2940, {}},
    { 6120,  2900, {}},
    { 6100,  2880, {}},
    { 6100,  2860, {}},
    { 6080,  2820, {}},
    { 6060,  2780, {}},
    { 6040,  2780, {}},
    { 6020,  2760, {}},
    { 6003,  2660, {}},
    { 5986,  2560, {}},
    { 5969,  2460, {}},
    { 5951,  2360, {}},
    { 5934,  2260, {}},
    { 5917,  2160, {}},
    { 5900,  2060, {}},
    { 5807,  2020, {}},
    { 5713,  1980, {}},
    { 5620,  1940, {}},
    { 5592,  1852, {}},
    { 5564,  1764, {}},
    { 5536,  1676, {}},
    { 5508,  1588, {}},
    { 5480,  1500, {}},
    { 5480,  1420, {}},
    { 5480,  1340, {}},
    { 5460,  1280, {}},
    { 5440,  1220, {}},
    { 5460,  1120, {}},
    { 5470,  1060, {}},
    { 5480,  1000, {}},
    { 5480,   960, {}},
    { 5480,   940, {}},
    { 5480,   920, {}},
    { 5500,   900, {}},
    { 5480,   880, {}},
    { 5500,   860, {}},
    { 5500,   773, {}},
    { 5500,   687, {}},
    { 5500,   600, {}},
    { 5600,   533, {}},
    { 5700,   467, {}},
    { 5800,   400, {}},
    { 5900,   333, {}},
    { 6000,   267, {}},
    { 6100,   200, {}},
};

static ZoneVertex ituz19[] = {
    { 6000,  5000, {}},
    { 6100,  5000, {}},
    { 6200,  5000, {}},
    { 6300,  5000, {}},
    { 6400,  5000, {}},
    { 6500,  5000, {}},
    { 6600,  5000, {}},
    { 6700,  5000, {}},
    { 6800,  5000, {}},
    { 6900,  5000, {}},
    { 7000,  5000, {}},
    { 7100,  5000, {}},
    { 7200,  5000, {}},
    { 7300,  5000, {}},
    { 7400,  5000, {}},
    { 7500,  5000, {}},
    { 7600,  5000, {}},
    { 7700,  5000, {}},
    { 7800,  5000, {}},
    { 7900,  5000, {}},
    { 8000,  5000, {}},
    { 8000,  4900, {}},
    { 8000,  4800, {}},
    { 8000,  4700, {}},
    { 8000,  4600, {}},
    { 8000,  4500, {}},
    { 8000,  4400, {}},
    { 8000,  4300, {}},
    { 8000,  4200, {}},
    { 8000,  4100, {}},
    { 8000,  4000, {}},
    { 8000,  3900, {}},
    { 8000,  3800, {}},
    { 8000,  3700, {}},
    { 8000,  3600, {}},
    { 8000,  3500, {}},
    { 8000,  3400, {}},
    { 8000,  3300, {}},
    { 8000,  3200, {}},
    { 7900,  3200, {}},
    { 7800,  3200, {}},
    { 7700,  3200, {}},
    { 7600,  3200, {}},
    { 7500,  3200, {}},
    { 7400,  3200, {}},
    { 7300,  3200, {}},
    { 7200,  3200, {}},
    { 7100,  3200, {}},
    { 7000,  3200, {}},
    { 6990,  3140, {}},
    { 6980,  3080, {}},
    { 6960,  3100, {}},
    { 6960,  3060, {}},
    { 6960,  3040, {}},
    { 6960,  3020, {}},
    { 6940,  3000, {}},
    { 6940,  2980, {}},
    { 6940,  2960, {}},
    { 6940,  2940, {}},
    { 6920,  2920, {}},
    { 6900,  2900, {}},
    { 6900,  2860, {}},
    { 6880,  2880, {}},
    { 6860,  2840, {}},
    { 6820,  2860, {}},
    { 6800,  2940, {}},
    { 6780,  2960, {}},
    { 6760,  3000, {}},
    { 6700,  2900, {}},
    { 6680,  2920, {}},
    { 6660,  2940, {}},
    { 6620,  2980, {}},
    { 6600,  3000, {}},
    { 6560,  3020, {}},
    { 6560,  3000, {}},
    { 6560,  2980, {}},
    { 6540,  2980, {}},
    { 6520,  2980, {}},
    { 6500,  2960, {}},
    { 6480,  2980, {}},
    { 6480,  3000, {}},
    { 6460,  3000, {}},
    { 6440,  3020, {}},
    { 6420,  3040, {}},
    { 6400,  3040, {}},
    { 6380,  3020, {}},
    { 6380,  3000, {}},
    { 6340,  3060, {}},
    { 6340,  3100, {}},
    { 6320,  3120, {}},
    { 6300,  3160, {}},
    { 6240,  3120, {}},
    { 6210,  3060, {}},
    { 6180,  3000, {}},
    { 6140,  2940, {}},
    { 6120,  2960, {}},
    { 6120,  3040, {}},
    { 6060,  3090, {}},
    { 6000,  3140, {}},
    { 6000,  3238, {}},
    { 6000,  3336, {}},
    { 6000,  3434, {}},
    { 6000,  3532, {}},
    { 6000,  3629, {}},
    { 6000,  3727, {}},
    { 6000,  3825, {}},
    { 6000,  3923, {}},
    { 6000,  4021, {}},
    { 6000,  4119, {}},
    { 6000,  4217, {}},
    { 6000,  4315, {}},
    { 6000,  4413, {}},
    { 6000,  4511, {}},
    { 6000,  4608, {}},
    { 6000,  4706, {}},
    { 6000,  4804, {}},
    { 6000,  4902, {}},
    { 6000,  5000, {}},
};

static ZoneVertex ituz20[] = {
    { 8000,  5000, {}},
    { 8000,  5100, {}},
    { 8000,  5200, {}},
    { 8000,  5300, {}},
    { 8000,  5400, {}},
    { 8000,  5500, {}},
    { 8000,  5600, {}},
    { 8000,  5700, {}},
    { 8000,  5800, {}},
    { 8000,  5900, {}},
    { 8000,  6000, {}},
    { 8000,  6100, {}},
    { 8000,  6200, {}},
    { 8000,  6300, {}},
    { 8000,  6400, {}},
    { 8000,  6500, {}},
    { 8000,  6600, {}},
    { 8000,  6700, {}},
    { 8000,  6800, {}},
    { 8000,  6900, {}},
    { 8000,  7000, {}},
    { 8000,  7100, {}},
    { 8000,  7200, {}},
    { 8000,  7300, {}},
    { 8000,  7400, {}},
    { 8000,  7500, {}},
    { 7900,  7500, {}},
    { 7800,  7500, {}},
    { 7700,  7500, {}},
    { 7600,  7500, {}},
    { 7500,  7500, {}},
    { 7400,  7500, {}},
    { 7300,  7500, {}},
    { 7200,  7500, {}},
    { 7100,  7500, {}},
    { 7000,  7500, {}},
    { 6900,  7500, {}},
    { 6800,  7500, {}},
    { 6700,  7500, {}},
    { 6600,  7500, {}},
    { 6500,  7500, {}},
    { 6400,  7500, {}},
    { 6300,  7500, {}},
    { 6200,  7500, {}},
    { 6100,  7500, {}},
    { 6000,  7500, {}},
    { 6000,  7400, {}},
    { 6000,  7300, {}},
    { 6000,  7200, {}},
    { 6000,  7100, {}},
    { 6000,  7000, {}},
    { 6000,  6900, {}},
    { 6000,  6800, {}},
    { 6000,  6700, {}},
    { 6000,  6600, {}},
    { 6000,  6500, {}},
    { 6000,  6400, {}},
    { 6000,  6300, {}},
    { 6000,  6200, {}},
    { 6000,  6100, {}},
    { 6000,  6000, {}},
    { 6000,  5900, {}},
    { 6000,  5800, {}},
    { 6000,  5700, {}},
    { 6000,  5600, {}},
    { 6000,  5500, {}},
    { 6000,  5400, {}},
    { 6000,  5300, {}},
    { 6000,  5200, {}},
    { 6000,  5100, {}},
    { 6000,  5000, {}},
    { 6100,  5000, {}},
    { 6200,  5000, {}},
    { 6300,  5000, {}},
    { 6400,  5000, {}},
    { 6500,  5000, {}},
    { 6600,  5000, {}},
    { 6700,  5000, {}},
    { 6800,  5000, {}},
    { 6900,  5000, {}},
    { 7000,  5000, {}},
    { 7100,  5000, {}},
    { 7200,  5000, {}},
    { 7300,  5000, {}},
    { 7400,  5000, {}},
    { 7500,  5000, {}},
    { 7600,  5000, {}},
    { 7700,  5000, {}},
    { 7800,  5000, {}},
    { 7900,  5000, {}},
    { 8000,  5000, {}},
};

static ZoneVertex ituz21[] = {
    { 8000,  7500, {}},
    { 8000,  7600, {}},
    { 8000,  7700, {}},
    { 8000,  7800, {}},
    { 8000,  7900, {}},
    { 8000,  8000, {}},
    { 8000,  8100, {}},
    { 8000,  8200, {}},
    { 8000,  8300, {}},
    { 8000,  8400, {}},
    { 8000,  8500, {}},
    { 8000,  8600, {}},
    { 8000,  8700, {}},
    { 8000,  8800, {}},
    { 8000,  8900, {}},
    { 8000,  9000, {}},
    { 7900,  9000, {}},
    { 7800,  9000, {}},
    { 7700,  9000, {}},
    { 7600,  9000, {}},
    { 7500,  9000, {}},
    { 7400,  9000, {}},
    { 7300,  9000, {}},
    { 7200,  9000, {}},
    { 7100,  9000, {}},
    { 7000,  9000, {}},
    { 6900,  9000, {}},
    { 6800,  9000, {}},
    { 6700,  9000, {}},
    { 6600,  9000, {}},
    { 6500,  9000, {}},
    { 6400,  9000, {}},
    { 6300,  9000, {}},
    { 6200,  9000, {}},
    { 6100,  9000, {}},
    { 6000,  9000, {}},
    { 6000,  8900, {}},
    { 6000,  8800, {}},
    { 6000,  8700, {}},
    { 6000,  8600, {}},
    { 6000,  8500, {}},
    { 6000,  8400, {}},
    { 6000,  8300, {}},
    { 6000,  8200, {}},
    { 6000,  8100, {}},
    { 6000,  8000, {}},
    { 6000,  7900, {}},
    { 6000,  7800, {}},
    { 6000,  7700, {}},
    { 6000,  7600, {}},
    { 6000,  7500, {}},
    { 6100,  7500, {}},
    { 6200,  7500, {}},
    { 6300,  7500, {}},
    { 6400,  7500, {}},
    { 6500,  7500, {}},
    { 6600,  7500, {}},
    { 6700,  7500, {}},
    { 6800,  7500, {}},
    { 6900,  7500, {}},
    { 7000,  7500, {}},
    { 7100,  7500, {}},
    { 7200,  7500, {}},
    { 7300,  7500, {}},
    { 7400,  7500, {}},
    { 7500,  7500, {}},
    { 7600,  7500, {}},
    { 7700,  7500, {}},
    { 7800,  7500, {}},
    { 7900,  7500, {}},
    { 8000,  7500, {}},
};

static ZoneVertex ituz22[] = {
    { 8000,  9000, {}},
    { 8000,  9100, {}},
    { 8000,  9200, {}},
    { 8000,  9300, {}},
    { 8000,  9400, {}},
    { 8000,  9500, {}},
    { 8000,  9600, {}},
    { 8000,  9700, {}},
    { 8000,  9800, {}},
    { 8000,  9900, {}},
    { 8000, 10000, {}},
    { 8000, 10100, {}},
    { 8000, 10200, {}},
    { 8000, 10300, {}},
    { 8000, 10400, {}},
    { 8000, 10500, {}},
    { 8000, 10600, {}},
    { 8000, 10700, {}},
    { 8000, 10800, {}},
    { 8000, 10900, {}},
    { 8000, 11000, {}},
    { 7900, 11000, {}},
    { 7800, 11000, {}},
    { 7700, 11000, {}},
    { 7600, 11000, {}},
    { 7500, 11000, {}},
    { 7400, 11000, {}},
    { 7300, 11000, {}},
    { 7200, 11000, {}},
    { 7100, 11000, {}},
    { 7000, 11000, {}},
    { 6900, 11000, {}},
    { 6800, 11000, {}},
    { 6700, 11000, {}},
    { 6600, 11000, {}},
    { 6500, 11000, {}},
    { 6400, 11000, {}},
    { 6300, 11000, {}},
    { 6200, 11000, {}},
    { 6100, 11000, {}},
    { 6000, 11000, {}},
    { 6000, 10900, {}},
    { 6000, 10800, {}},
    { 6000, 10700, {}},
    { 6000, 10600, {}},
    { 6000, 10500, {}},
    { 6000, 10400, {}},
    { 6000, 10300, {}},
    { 6000, 10200, {}},
    { 6000, 10100, {}},
    { 6000, 10000, {}},
    { 6000,  9900, {}},
    { 6000,  9800, {}},
    { 6000,  9700, {}},
    { 6000,  9600, {}},
    { 6000,  9500, {}},
    { 6000,  9400, {}},
    { 6000,  9300, {}},
    { 6000,  9200, {}},
    { 6000,  9100, {}},
    { 6000,  9000, {}},
    { 6100,  9000, {}},
    { 6200,  9000, {}},
    { 6300,  9000, {}},
    { 6400,  9000, {}},
    { 6500,  9000, {}},
    { 6600,  9000, {}},
    { 6700,  9000, {}},
    { 6800,  9000, {}},
    { 6900,  9000, {}},
    { 7000,  9000, {}},
    { 7100,  9000, {}},
    { 7200,  9000, {}},
    { 7300,  9000, {}},
    { 7400,  9000, {}},
    { 7500,  9000, {}},
    { 7600,  9000, {}},
    { 7700,  9000, {}},
    { 7800,  9000, {}},
    { 7900,  9000, {}},
    { 8000,  9000, {}},
};

static ZoneVertex ituz23[] = {
    { 8000, 11000, {}},
    { 8000, 11100, {}},
    { 8000, 11200, {}},
    { 8000, 11300, {}},
    { 8000, 11400, {}},
    { 8000, 11500, {}},
    { 8000, 11600, {}},
    { 8000, 11700, {}},
    { 8000, 11800, {}},
    { 8000, 11900, {}},
    { 8000, 12000, {}},
    { 8000, 12100, {}},
    { 8000, 12200, {}},
    { 8000, 12300, {}},
    { 8000, 12400, {}},
    { 8000, 12500, {}},
    { 8000, 12600, {}},
    { 8000, 12700, {}},
    { 8000, 12800, {}},
    { 8000, 12900, {}},
    { 8000, 13000, {}},
    { 8000, 13100, {}},
    { 8000, 13200, {}},
    { 8000, 13300, {}},
    { 8000, 13400, {}},
    { 8000, 13500, {}},
    { 7900, 13500, {}},
    { 7800, 13500, {}},
    { 7700, 13500, {}},
    { 7600, 13500, {}},
    { 7500, 13500, {}},
    { 7400, 13500, {}},
    { 7300, 13500, {}},
    { 7200, 13500, {}},
    { 7100, 13500, {}},
    { 7000, 13500, {}},
    { 6900, 13500, {}},
    { 6800, 13500, {}},
    { 6700, 13500, {}},
    { 6600, 13500, {}},
    { 6500, 13500, {}},
    { 6400, 13500, {}},
    { 6300, 13500, {}},
    { 6200, 13500, {}},
    { 6100, 13500, {}},
    { 6000, 13500, {}},
    { 6000, 13400, {}},
    { 6000, 13300, {}},
    { 6000, 13200, {}},
    { 6000, 13100, {}},
    { 6000, 13000, {}},
    { 6000, 12900, {}},
    { 6000, 12800, {}},
    { 6000, 12700, {}},
    { 6000, 12600, {}},
    { 6000, 12500, {}},
    { 6000, 12400, {}},
    { 6000, 12300, {}},
    { 6000, 12200, {}},
    { 6000, 12100, {}},
    { 6000, 12000, {}},
    { 6000, 11900, {}},
    { 6000, 11800, {}},
    { 6000, 11700, {}},
    { 6000, 11600, {}},
    { 6000, 11500, {}},
    { 6000, 11400, {}},
    { 6000, 11300, {}},
    { 6000, 11200, {}},
    { 6000, 11100, {}},
    { 6000, 11000, {}},
    { 6100, 11000, {}},
    { 6200, 11000, {}},
    { 6300, 11000, {}},
    { 6400, 11000, {}},
    { 6500, 11000, {}},
    { 6600, 11000, {}},
    { 6700, 11000, {}},
    { 6800, 11000, {}},
    { 6900, 11000, {}},
    { 7000, 11000, {}},
    { 7100, 11000, {}},
    { 7200, 11000, {}},
    { 7300, 11000, {}},
    { 7400, 11000, {}},
    { 7500, 11000, {}},
    { 7600, 11000, {}},
    { 7700, 11000, {}},
    { 7800, 11000, {}},
    { 7900, 11000, {}},
    { 8000, 11000, {}},
};

static ZoneVertex ituz24[] = {
    { 8000, 13500, {}},
    { 8000, 13600, {}},
    { 8000, 13700, {}},
    { 8000, 13800, {}},
    { 8000, 13900, {}},
    { 8000, 14000, {}},
    { 8000, 14100, {}},
    { 8000, 14200, {}},
    { 8000, 14300, {}},
    { 8000, 14400, {}},
    { 8000, 14500, {}},
    { 8000, 14600, {}},
    { 8000, 14700, {}},
    { 8000, 14800, {}},
    { 8000, 14900, {}},
    { 8000, 15000, {}},
    { 8000, 15100, {}},
    { 8000, 15200, {}},
    { 8000, 15300, {}},
    { 8000, 15400, {}},
    { 8000, 15500, {}},
    { 7900, 15500, {}},
    { 7800, 15500, {}},
    { 7700, 15500, {}},
    { 7600, 15500, {}},
    { 7500, 15500, {}},
    { 7400, 15500, {}},
    { 7300, 15500, {}},
    { 7200, 15500, {}},
    { 7100, 15500, {}},
    { 7000, 15500, {}},
    { 6900, 15500, {}},
    { 6800, 15500, {}},
    { 6700, 15500, {}},
    { 6600, 15500, {}},
    { 6500, 15500, {}},
    { 6400, 15500, {}},
    { 6300, 15500, {}},
    { 6200, 15500, {}},
    { 6100, 15500, {}},
    { 6000, 15500, {}},
    { 6000, 15400, {}},
    { 6000, 15300, {}},
    { 6000, 15200, {}},
    { 6000, 15100, {}},
    { 6000, 15000, {}},
    { 6000, 14900, {}},
    { 6000, 14800, {}},
    { 6000, 14700, {}},
    { 6000, 14600, {}},
    { 6000, 14500, {}},
    { 6000, 14400, {}},
    { 6000, 14300, {}},
    { 6000, 14200, {}},
    { 6000, 14100, {}},
    { 6000, 14000, {}},
    { 6000, 13900, {}},
    { 6000, 13800, {}},
    { 6000, 13700, {}},
    { 6000, 13600, {}},
    { 6000, 13500, {}},
    { 6100, 13500, {}},
    { 6200, 13500, {}},
    { 6300, 13500, {}},
    { 6400, 13500, {}},
    { 6500, 13500, {}},
    { 6600, 13500, {}},
    { 6700, 13500, {}},
    { 6800, 13500, {}},
    { 6900, 13500, {}},
    { 7000, 13500, {}},
    { 7100, 13500, {}},
    { 7200, 13500, {}},
    { 7300, 13500, {}},
    { 7400, 13500, {}},
    { 7500, 13500, {}},
    { 7600, 13500, {}},
    { 7700, 13500, {}},
    { 7800, 13500, {}},
    { 7900, 13500, {}},
    { 8000, 13500, {}},
};

static ZoneVertex ituz25[] = {
    { 8000, 15500, {}},
    { 8000, 15600, {}},
    { 8000, 15700, {}},
    { 8000, 15800, {}},
    { 8000, 15900, {}},
    { 8000, 16000, {}},
    { 8000, 16100, {}},
    { 8000, 16200, {}},
    { 8000, 16300, {}},
    { 8000, 16400, {}},
    { 8000, 16500, {}},
    { 8000, 16600, {}},
    { 8000, 16700, {}},
    { 8000, 16800, {}},
    { 8000, 16900, {}},
    { 8000, 17000, {}},
    { 7900, 17000, {}},
    { 7800, 17000, {}},
    { 7700, 17000, {}},
    { 7600, 17000, {}},
    { 7500, 17000, {}},
    { 7400, 17000, {}},
    { 7300, 17000, {}},
    { 7200, 17000, {}},
    { 7100, 17000, {}},
    { 7000, 17000, {}},
    { 6900, 17000, {}},
    { 6800, 17000, {}},
    { 6700, 17000, {}},
    { 6600, 17000, {}},
    { 6500, 17000, {}},
    { 6400, 17000, {}},
    { 6300, 17000, {}},
    { 6200, 17000, {}},
    { 6100, 17000, {}},
    { 6000, 17000, {}},
    { 6000, 16900, {}},
    { 6000, 16800, {}},
    { 6000, 16700, {}},
    { 6000, 16600, {}},
    { 6000, 16500, {}},
    { 6000, 16400, {}},
    { 6000, 16300, {}},
    { 6000, 16200, {}},
    { 6000, 16100, {}},
    { 6000, 16000, {}},
    { 6000, 15900, {}},
    { 6000, 15800, {}},
    { 6000, 15700, {}},
    { 6000, 15600, {}},
    { 6000, 15500, {}},
    { 6100, 15500, {}},
    { 6200, 15500, {}},
    { 6300, 15500, {}},
    { 6400, 15500, {}},
    { 6500, 15500, {}},
    { 6600, 15500, {}},
    { 6700, 15500, {}},
    { 6800, 15500, {}},
    { 6900, 15500, {}},
    { 7000, 15500, {}},
    { 7100, 15500, {}},
    { 7200, 15500, {}},
    { 7300, 15500, {}},
    { 7400, 15500, {}},
    { 7500, 15500, {}},
    { 7600, 15500, {}},
    { 7700, 15500, {}},
    { 7800, 15500, {}},
    { 7900, 15500, {}},
    { 8000, 15500, {}},
};

static ZoneVertex ituz26[] = {
    { 8000, 17000, {}},
    { 8000, 17100, {}},
    { 8000, 17200, {}},
    { 8000, 17300, {}},
    { 8000, 17400, {}},
    { 8000, 17500, {}},
    { 8000, 17600, {}},
    { 8000, 17700, {}},
    { 8000, 17800, {}},
    { 8000, 17900, {}},
    { 8000, -18000, {}},
    { 8000, -17900, {}},
    { 8000, -17800, {}},
    { 8000, -17700, {}},
    { 8000, -17600, {}},
    { 8000, -17500, {}},
    { 8000, -17400, {}},
    { 8000, -17300, {}},
    { 8000, -17200, {}},
    { 8000, -17100, {}},
    { 8000, -17000, {}},
    { 7905, -16993, {}},
    { 7811, -16987, {}},
    { 7716, -16980, {}},
    { 7621, -16973, {}},
    { 7527, -16967, {}},
    { 7432, -16960, {}},
    { 7337, -16953, {}},
    { 7243, -16947, {}},
    { 7148, -16940, {}},
    { 7053, -16933, {}},
    { 6959, -16927, {}},
    { 6864, -16920, {}},
    { 6769, -16913, {}},
    { 6675, -16907, {}},
    { 6580, -16900, {}},
    { 6527, -17000, {}},
    { 6475, -17100, {}},
    { 6422, -17200, {}},
    { 6369, -17300, {}},
    { 6316, -17400, {}},
    { 6264, -17500, {}},
    { 6211, -17600, {}},
    { 6158, -17700, {}},
    { 6105, -17800, {}},
    { 6053, -17900, {}},
    { 6000, -18000, {}},
    { 6000, 17900, {}},
    { 6000, 17800, {}},
    { 6000, 17700, {}},
    { 6000, 17600, {}},
    { 6000, 17500, {}},
    { 6000, 17400, {}},
    { 6000, 17300, {}},
    { 6000, 17200, {}},
    { 6000, 17100, {}},
    { 6000, 17000, {}},
    { 6100, 17000, {}},
    { 6200, 17000, {}},
    { 6300, 17000, {}},
    { 6400, 17000, {}},
    { 6500, 17000, {}},
    { 6600, 17000, {}},
    { 6700, 17000, {}},
    { 6800, 17000, {}},
    { 6900, 17000, {}},
    { 7000, 17000, {}},
    { 7100, 17000, {}},
    { 7200, 17000, {}},
    { 7300, 17000, {}},
    { 7400, 17000, {}},
    { 7500, 17000, {}},
    { 7600, 17000, {}},
    { 7700, 17000, {}},
    { 7800, 17000, {}},
    { 7900, 17000, {}},
    { 8000, 17000, {}},
};

static ZoneVertex ituz27[] = {
    { 4244,   750, {}},
    { 4243,   664, {}},
    { 4242,   578, {}},
    { 4241,   492, {}},
    { 4241,   406, {}},
    { 4240,   320, {}},
    { 4240,   300, {}},
    { 4240,   280, {}},
    { 4240,   260, {}},
    { 4240,   240, {}},
    { 4240,   220, {}},
    { 4240,   200, {}},
    { 4240,   180, {}},
    { 4240,   160, {}},
    { 4260,   140, {}},
    { 4280,   120, {}},
    { 4280,   100, {}},
    { 4280,    80, {}},
    { 4260,    60, {}},
    { 4260,    40, {}},
    { 4280,    20, {}},
    { 4260,     0, {}},
    { 4280,   -20, {}},
    { 4280,   -40, {}},
    { 4280,   -60, {}},
    { 4300,   -80, {}},
    { 4300,  -100, {}},
    { 4300,  -120, {}},
    { 4300,  -140, {}},
    { 4320,  -140, {}},
    { 4320,  -160, {}},
    { 4340,  -180, {}},
    { 4370,  -240, {}},
    { 4400,  -300, {}},
    { 4400,  -400, {}},
    { 4400,  -500, {}},
    { 4400,  -600, {}},
    { 4400,  -700, {}},
    { 4400,  -800, {}},
    { 4400,  -900, {}},
    { 4400, -1000, {}},
    { 4400, -1100, {}},
    { 4400, -1200, {}},
    { 4400, -1300, {}},
    { 4496, -1306, {}},
    { 4593, -1312, {}},
    { 4689, -1318, {}},
    { 4786, -1324, {}},
    { 4882, -1329, {}},
    { 4979, -1335, {}},
    { 5075, -1341, {}},
    { 5172, -1347, {}},
    { 5268, -1353, {}},
    { 5365, -1359, {}},
    { 5461, -1365, {}},
    { 5558, -1371, {}},
    { 5654, -1376, {}},
    { 5751, -1382, {}},
    { 5847, -1388, {}},
    { 5944, -1394, {}},
    { 6040, -1400, {}},
    { 6055, -1300, {}},
    { 6070, -1200, {}},
    { 6085, -1100, {}},
    { 6100, -1000, {}},
    { 6100,  -900, {}},
    { 6100,  -800, {}},
    { 6100,  -700, {}},
    { 6100,  -600, {}},
    { 6100,  -500, {}},
    { 6100,  -400, {}},
    { 6100,  -300, {}},
    { 6100,  -200, {}},
    { 6100,  -100, {}},
    { 6100,     0, {}},
    { 6100,   100, {}},
    { 6100,   200, {}},
    { 6000,   267, {}},
    { 5900,   333, {}},
    { 5800,   400, {}},
    { 5700,   467, {}},
    { 5600,   533, {}},
    { 5500,   600, {}},
    { 5430,   630, {}},
    { 5360,   660, {}},
    { 5340,   700, {}},
    { 5320,   720, {}},
    { 5300,   720, {}},
    { 5260,   700, {}},
    { 5260,   680, {}},
    { 5240,   700, {}},
    { 5220,   700, {}},
    { 5220,   680, {}},
    { 5200,   680, {}},
    { 5180,   660, {}},
    { 5180,   640, {}},
    { 5180,   620, {}},
    { 5180,   600, {}},
    { 5160,   620, {}},
    { 5140,   620, {}},
    { 5120,   600, {}},
    { 5100,   580, {}},
    { 5100,   600, {}},
    { 5080,   600, {}},
    { 5060,   620, {}},
    { 5040,   640, {}},
    { 5020,   620, {}},
    { 5000,   620, {}},
    { 4980,   640, {}},
    { 4960,   640, {}},
    { 4940,   660, {}},
    { 4920,   680, {}},
    { 4920,   700, {}},
    { 4920,   720, {}},
    { 4920,   740, {}},
    { 4900,   760, {}},
    { 4900,   780, {}},
    { 4900,   800, {}},
    { 4900,   820, {}},
    { 4880,   800, {}},
    { 4860,   780, {}},
    { 4840,   780, {}},
    { 4820,   760, {}},
    { 4800,   760, {}},
    { 4780,   760, {}},
    { 4760,   760, {}},
    { 4740,   740, {}},
    { 4740,   720, {}},
    { 4740,   700, {}},
    { 4720,   680, {}},
    { 4700,   660, {}},
    { 4680,   640, {}},
    { 4660,   620, {}},
    { 4640,   620, {}},
    { 4620,   600, {}},
    { 4620,   620, {}},
    { 4640,   640, {}},
    { 4640,   660, {}},
    { 4640,   680, {}},
    { 4620,   680, {}},
    { 4600,   700, {}},
    { 4580,   680, {}},
    { 4560,   700, {}},
    { 4540,   720, {}},
    { 4520,   700, {}},
    { 4520,   680, {}},
    { 4500,   680, {}},
    { 4480,   700, {}},
    { 4460,   700, {}},
    { 4440,   680, {}},
    { 4420,   700, {}},
    { 4420,   720, {}},
    { 4420,   740, {}},
    { 4420,   760, {}},
    { 4400,   760, {}},
    { 4380,   760, {}},
    { 4310,   760, {}},
    { 4240,   760, {}},
};

static ZoneVertex ituz28[] = {
    { 5624,  1940, {}},
    { 5595,  1852, {}},
    { 5566,  1764, {}},
    { 5538,  1676, {}},
    { 5509,  1588, {}},
    { 5480,  1500, {}},
    { 5480,  1420, {}},
    { 5480,  1340, {}},
    { 5460,  1280, {}},
    { 5440,  1220, {}},
    { 5460,  1120, {}},
    { 5470,  1060, {}},
    { 5480,  1000, {}},
    { 5480,   960, {}},
    { 5480,   940, {}},
    { 5480,   920, {}},
    { 5500,   900, {}},
    { 5480,   880, {}},
    { 5500,   860, {}},
    { 5500,   773, {}},
    { 5500,   687, {}},
    { 5500,   600, {}},
    { 5430,   630, {}},
    { 5360,   660, {}},
    { 5340,   700, {}},
    { 5320,   720, {}},
    { 5300,   720, {}},
    { 5260,   700, {}},
    { 5260,   680, {}},
    { 5240,   700, {}},
    { 5220,   700, {}},
    { 5220,   680, {}},
    { 5200,   680, {}},
    { 5180,   660, {}},
    { 5180,   640, {}},
    { 5180,   620, {}},
    { 5180,   600, {}},
    { 5160,   620, {}},
    { 5140,   620, {}},
    { 5120,   600, {}},
    { 5100,   580, {}},
    { 5100,   600, {}},
    { 5080,   600, {}},
    { 5060,   620, {}},
    { 5040,   640, {}},
    { 5020,   620, {}},
    { 5000,   620, {}},
    { 4980,   640, {}},
    { 4960,   640, {}},
    { 4940,   660, {}},
    { 4920,   680, {}},
    { 4920,   700, {}},
    { 4920,   720, {}},
    { 4920,   740, {}},
    { 4900,   760, {}},
    { 4900,   780, {}},
    { 4900,   800, {}},
    { 4900,   820, {}},
    { 4880,   800, {}},
    { 4860,   780, {}},
    { 4840,   780, {}},
    { 4820,   760, {}},
    { 4800,   760, {}},
    { 4780,   760, {}},
    { 4760,   760, {}},
    { 4740,   740, {}},
    { 4740,   720, {}},
    { 4740,   700, {}},
    { 4720,   680, {}},
    { 4700,   660, {}},
    { 4680,   640, {}},
    { 4660,   620, {}},
    { 4640,   620, {}},
    { 4620,   600, {}},
    { 4620,   620, {}},
    { 4640,   640, {}},
    { 4640,   660, {}},
    { 4640,   680, {}},
    { 4620,   680, {}},
    { 4600,   700, {}},
    { 4580,   680, {}},
    { 4560,   700, {}},
    { 4540,   720, {}},
    { 4520,   700, {}},
    { 4520,   680, {}},
    { 4500,   680, {}},
    { 4480,   700, {}},
    { 4460,   700, {}},
    { 4440,   680, {}},
    { 4420,   700, {}},
    { 4420,   720, {}},
    { 4420,   740, {}},
    { 4420,   760, {}},
    { 4400,   760, {}},
    { 4380,   760, {}},
    { 4310,   760, {}},
    { 4240,   760, {}},
    { 4152,   760, {}},
    { 4064,   760, {}},
    { 3976,   760, {}},
    { 3888,   760, {}},
    { 3800,   760, {}},
    { 3800,   840, {}},
    { 3800,   920, {}},
    { 3800,  1000, {}},
    { 3767,  1080, {}},
    { 3733,  1160, {}},
    { 3700,  1240, {}},
    { 3640,  1280, {}},
    { 3580,  1320, {}},
    { 3564,  1419, {}},
    { 3547,  1518, {}},
    { 3531,  1616, {}},
    { 3514,  1715, {}},
    { 3498,  1814, {}},
    { 3481,  1913, {}},
    { 3465,  2012, {}},
    { 3448,  2111, {}},
    { 3432,  2209, {}},
    { 3415,  2308, {}},
    { 3399,  2407, {}},
    { 3382,  2506, {}},
    { 3366,  2605, {}},
    { 3349,  2704, {}},
    { 3333,  2802, {}},
    { 3316,  2901, {}},
    { 3300,  3000, {}},
    { 3400,  3000, {}},
    { 3500,  3000, {}},
    { 3600,  3000, {}},
    { 3620,  2960, {}},
    { 3620,  2940, {}},
    { 3660,  2860, {}},
    { 3660,  2800, {}},
    { 3660,  2760, {}},
    { 3660,  2740, {}},
    { 3680,  2740, {}},
    { 3720,  2720, {}},
    { 3760,  2700, {}},
    { 3820,  2620, {}},
    { 3840,  2640, {}},
    { 3860,  2640, {}},
    { 3900,  2680, {}},
    { 3940,  2640, {}},
    { 3940,  2600, {}},
    { 4020,  2560, {}},
    { 4080,  2600, {}},
    { 4080,  2620, {}},
    { 4100,  2640, {}},
    { 4120,  2640, {}},
    { 4140,  2660, {}},
    { 4160,  2660, {}},
    { 4160,  2640, {}},
    { 4180,  2640, {}},
    { 4200,  2660, {}},
    { 4200,  2680, {}},
    { 4200,  2700, {}},
    { 4200,  2720, {}},
    { 4200,  2740, {}},
    { 4200,  2780, {}},
    { 4200,  2800, {}},
    { 4200,  2900, {}},
    { 4200,  3000, {}},
    { 4300,  3000, {}},
    { 4400,  3000, {}},
    { 4500,  3000, {}},
    { 4520,  2960, {}},
    { 4540,  2960, {}},
    { 4540,  2940, {}},
    { 4540,  2920, {}},
    { 4540,  2900, {}},
    { 4540,  2880, {}},
    { 4520,  2860, {}},
    { 4540,  2840, {}},
    { 4540,  2820, {}},
    { 4560,  2800, {}},
    { 4580,  2820, {}},
    { 4600,  2800, {}},
    { 4620,  2820, {}},
    { 4640,  2820, {}},
    { 4660,  2820, {}},
    { 4680,  2820, {}},
    { 4700,  2800, {}},
    { 4720,  2780, {}},
    { 4740,  2760, {}},
    { 4760,  2740, {}},
    { 4780,  2720, {}},
    { 4800,  2720, {}},
    { 4820,  2700, {}},
    { 4820,  2680, {}},
    { 4820,  2660, {}},
    { 4820,  2640, {}},
    { 4800,  2620, {}},
    { 4800,  2600, {}},
    { 4800,  2580, {}},
    { 4800,  2560, {}},
    { 4800,  2540, {}},
    { 4780,  2520, {}},
    { 4780,  2480, {}},
    { 4800,  2460, {}},
    { 4800,  2440, {}},
    { 4800,  2420, {}},
    { 4800,  2400, {}},
    { 4800,  2380, {}},
    { 4800,  2360, {}},
    { 4800,  2340, {}},
    { 4800,  2320, {}},
    { 4800,  2300, {}},
    { 4820,  2280, {}},
    { 4820,  2260, {}},
    { 4820,  2240, {}},
    { 4840,  2220, {}},
    { 4860,  2220, {}},
    { 4880,  2240, {}},
    { 4900,  2260, {}},
    { 4900,  2280, {}},
    { 4920,  2280, {}},
    { 4940,  2280, {}},
    { 4960,  2280, {}},
    { 4980,  2300, {}},
    { 5000,  2320, {}},
    { 5020,  2340, {}},
    { 5020,  2360, {}},
    { 5040,  2380, {}},
    { 5040,  2400, {}},
    { 5060,  2400, {}},
    { 5080,  2400, {}},
    { 5100,  2400, {}},
    { 5120,  2380, {}},
    { 5140,  2360, {}},
    { 5160,  2360, {}},
    { 5180,  2360, {}},
    { 5200,  2360, {}},
    { 5220,  2340, {}},
    { 5220,  2320, {}},
    { 5240,  2340, {}},
    { 5260,  2360, {}},
    { 5260,  2380, {}},
    { 5280,  2400, {}},
    { 5300,  2400, {}},
    { 5320,  2380, {}},
    { 5360,  2360, {}},
    { 5380,  2360, {}},
    { 5400,  2360, {}},
    { 5420,  2340, {}},
    { 5420,  2320, {}},
    { 5440,  2300, {}},
    { 5440,  2280, {}},
    { 5440,  2240, {}},
    { 5440,  2220, {}},
    { 5440,  2200, {}},
    { 5440,  2160, {}},
    { 5440,  2140, {}},
    { 5440,  2100, {}},
    { 5440,  2080, {}},
    { 5440,  2040, {}},
    { 5440,  1960, {}},
    { 5530,  1950, {}},
    { 5620,  1940, {}},
};

static ZoneVertex ituz29[] = {
    { 3788,  5140, {}},
    { 3806,  5053, {}},
    { 3823,  4967, {}},
    { 3840,  4880, {}},
    { 3840,  4860, {}},
    { 3860,  4840, {}},
    { 3880,  4820, {}},
    { 3900,  4840, {}},
    { 3920,  4820, {}},
    { 3940,  4840, {}},
    { 3960,  4800, {}},
    { 3960,  4780, {}},
    { 3960,  4760, {}},
    { 3940,  4740, {}},
    { 3940,  4720, {}},
    { 3920,  4700, {}},
    { 3900,  4680, {}},
    { 3880,  4660, {}},
    { 3900,  4640, {}},
    { 3880,  4620, {}},
    { 3880,  4600, {}},
    { 3900,  4580, {}},
    { 3900,  4560, {}},
    { 3900,  4540, {}},
    { 3920,  4520, {}},
    { 3940,  4500, {}},
    { 3960,  4500, {}},
    { 3960,  4480, {}},
    { 3980,  4460, {}},
    { 4000,  4440, {}},
    { 4000,  4420, {}},
    { 4000,  4400, {}},
    { 4000,  4380, {}},
    { 4020,  4360, {}},
    { 4040,  4360, {}},
    { 4060,  4380, {}},
    { 4080,  4380, {}},
    { 4100,  4360, {}},
    { 4120,  4340, {}},
    { 4120,  4320, {}},
    { 4140,  4300, {}},
    { 4160,  4280, {}},
    { 4160,  4260, {}},
    { 4140,  4240, {}},
    { 4140,  4220, {}},
    { 4160,  4200, {}},
    { 4140,  4180, {}},
    { 4160,  4160, {}},
    { 4177,  4063, {}},
    { 4193,  3967, {}},
    { 4210,  3870, {}},
    { 4227,  3773, {}},
    { 4243,  3677, {}},
    { 4260,  3580, {}},
    { 4277,  3483, {}},
    { 4293,  3387, {}},
    { 4310,  3290, {}},
    { 4327,  3193, {}},
    { 4343,  3097, {}},
    { 4360,  3000, {}},
    { 4430,  3000, {}},
    { 4500,  3000, {}},
    { 4520,  2960, {}},
    { 4540,  2960, {}},
    { 4540,  2940, {}},
    { 4540,  2920, {}},
    { 4540,  2900, {}},
    { 4540,  2880, {}},
    { 4520,  2860, {}},
    { 4540,  2840, {}},
    { 4540,  2820, {}},
    { 4560,  2800, {}},
    { 4580,  2820, {}},
    { 4600,  2800, {}},
    { 4620,  2820, {}},
    { 4640,  2820, {}},
    { 4660,  2820, {}},
    { 4680,  2820, {}},
    { 4700,  2800, {}},
    { 4720,  2780, {}},
    { 4740,  2760, {}},
    { 4760,  2740, {}},
    { 4780,  2720, {}},
    { 4800,  2720, {}},
    { 4820,  2700, {}},
    { 4820,  2680, {}},
    { 4820,  2660, {}},
    { 4820,  2640, {}},
    { 4800,  2620, {}},
    { 4800,  2600, {}},
    { 4800,  2580, {}},
    { 4800,  2560, {}},
    { 4800,  2540, {}},
    { 4780,  2520, {}},
    { 4780,  2480, {}},
    { 4800,  2460, {}},
    { 4800,  2440, {}},
    { 4800,  2420, {}},
    { 4800,  2400, {}},
    { 4800,  2380, {}},
    { 4800,  2360, {}},
    { 4800,  2340, {}},
    { 4800,  2320, {}},
    { 4800,  2300, {}},
    { 4820,  2280, {}},
    { 4820,  2260, {}},
    { 4820,  2240, {}},
    { 4840,  2220, {}},
    { 4860,  2220, {}},
    { 4880,  2240, {}},
    { 4900,  2260, {}},
    { 4900,  2280, {}},
    { 4920,  2280, {}},
    { 4940,  2280, {}},
    { 4960,  2280, {}},
    { 4980,  2300, {}},
    { 5000,  2320, {}},
    { 5020,  2340, {}},
    { 5020,  2360, {}},
    { 5040,  2380, {}},
    { 5040,  2400, {}},
    { 5060,  2400, {}},
    { 5080,  2400, {}},
    { 5100,  2400, {}},
    { 5120,  2380, {}},
    { 5140,  2360, {}},
    { 5160,  2360, {}},
    { 5180,  2360, {}},
    { 5200,  2360, {}},
    { 5220,  2340, {}},
    { 5220,  2320, {}},
    { 5240,  2340, {}},
    { 5260,  2360, {}},
    { 5260,  2380, {}},
    { 5280,  2400, {}},
    { 5300,  2400, {}},
    { 5320,  2380, {}},
    { 5360,  2360, {}},
    { 5380,  2360, {}},
    { 5400,  2360, {}},
    { 5420,  2340, {}},
    { 5420,  2320, {}},
    { 5440,  2300, {}},
    { 5440,  2280, {}},
    { 5440,  2240, {}},
    { 5440,  2220, {}},
    { 5440,  2200, {}},
    { 5440,  2160, {}},
    { 5440,  2140, {}},
    { 5440,  2100, {}},
    { 5440,  2080, {}},
    { 5440,  2040, {}},
    { 5440,  1960, {}},
    { 5530,  1950, {}},
    { 5620,  1940, {}},
    { 5713,  1980, {}},
    { 5807,  2020, {}},
    { 5900,  2060, {}},
    { 5917,  2160, {}},
    { 5934,  2260, {}},
    { 5951,  2360, {}},
    { 5969,  2460, {}},
    { 5986,  2560, {}},
    { 6003,  2660, {}},
    { 6020,  2760, {}},
    { 6040,  2760, {}},
    { 6060,  2780, {}},
    { 6080,  2820, {}},
    { 6100,  2860, {}},
    { 6120,  2900, {}},
    { 6120,  2920, {}},
    { 6120,  2940, {}},
    { 6120,  3040, {}},
    { 6060,  3090, {}},
    { 6000,  3140, {}},
    { 6000,  3238, {}},
    { 6000,  3336, {}},
    { 6000,  3434, {}},
    { 6000,  3532, {}},
    { 6000,  3629, {}},
    { 6000,  3727, {}},
    { 6000,  3825, {}},
    { 6000,  3923, {}},
    { 6000,  4021, {}},
    { 6000,  4119, {}},
    { 6000,  4217, {}},
    { 6000,  4315, {}},
    { 6000,  4413, {}},
    { 6000,  4511, {}},
    { 6000,  4608, {}},
    { 6000,  4706, {}},
    { 6000,  4804, {}},
    { 6000,  4902, {}},
    { 6000,  5000, {}},
    { 5900,  5000, {}},
    { 5800,  5000, {}},
    { 5700,  5000, {}},
    { 5600,  5000, {}},
    { 5500,  5000, {}},
    { 5400,  5000, {}},
    { 5300,  5000, {}},
    { 5200,  5000, {}},
    { 5100,  5000, {}},
    { 5000,  5000, {}},
    { 4900,  5000, {}},
    { 4800,  5000, {}},
    { 4700,  5000, {}},
    { 4600,  5000, {}},
    { 4500,  5000, {}},
    { 4400,  5000, {}},
    { 4311,  5020, {}},
    { 4223,  5040, {}},
    { 4134,  5060, {}},
    { 4046,  5080, {}},
    { 3957,  5100, {}},
    { 3869,  5120, {}},
    { 3780,  5140, {}},
};

static ZoneVertex ituz30[] = {
    { 3788,  5140, {}},
    { 3772,  5226, {}},
    { 3756,  5313, {}},
    { 3740,  5400, {}},
    { 3740,  5420, {}},
    { 3740,  5440, {}},
    { 3740,  5460, {}},
    { 3760,  5480, {}},
    { 3780,  5500, {}},
    { 3800,  5520, {}},
    { 3800,  5540, {}},
    { 3800,  5560, {}},
    { 3820,  5580, {}},
    { 3800,  5600, {}},
    { 3800,  5620, {}},
    { 3820,  5640, {}},
    { 3820,  5660, {}},
    { 3820,  5680, {}},
    { 3820,  5700, {}},
    { 3820,  5720, {}},
    { 3800,  5740, {}},
    { 3800,  5760, {}},
    { 3780,  5780, {}},
    { 3780,  5800, {}},
    { 3780,  5820, {}},
    { 3760,  5840, {}},
    { 3760,  5860, {}},
    { 3760,  5880, {}},
    { 3760,  5900, {}},
    { 3760,  5920, {}},
    { 3740,  5940, {}},
    { 3720,  5940, {}},
    { 3720,  5960, {}},
    { 3700,  5980, {}},
    { 3700,  6000, {}},
    { 3680,  6020, {}},
    { 3660,  6040, {}},
    { 3660,  6060, {}},
    { 3660,  6080, {}},
    { 3660,  6120, {}},
    { 3640,  6120, {}},
    { 3620,  6120, {}},
    { 3600,  6120, {}},
    { 3580,  6120, {}},
    { 3560,  6140, {}},
    { 3540,  6160, {}},
    { 3540,  6180, {}},
    { 3540,  6200, {}},
    { 3540,  6220, {}},
    { 3520,  6220, {}},
    { 3520,  6240, {}},
    { 3520,  6260, {}},
    { 3540,  6280, {}},
    { 3540,  6300, {}},
    { 3560,  6320, {}},
    { 3580,  6320, {}},
    { 3580,  6340, {}},
    { 3600,  6360, {}},
    { 3600,  6380, {}},
    { 3600,  6400, {}},
    { 3620,  6420, {}},
    { 3620,  6440, {}},
    { 3640,  6460, {}},
    { 3660,  6460, {}},
    { 3680,  6480, {}},
    { 3700,  6480, {}},
    { 3720,  6500, {}},
    { 3720,  6520, {}},
    { 3720,  6560, {}},
    { 3740,  6560, {}},
    { 3760,  6580, {}},
    { 3740,  6600, {}},
    { 3740,  6620, {}},
    { 3740,  6640, {}},
    { 3740,  6660, {}},
    { 3740,  6680, {}},
    { 3740,  6700, {}},
    { 3720,  6720, {}},
    { 3720,  6740, {}},
    { 3720,  6760, {}},
    { 3700,  6780, {}},
    { 3700,  6800, {}},
    { 3700,  6820, {}},
    { 3720,  6840, {}},
    { 3720,  6860, {}},
    { 3720,  6880, {}},
    { 3740,  6900, {}},
    { 3720,  6920, {}},
    { 3720,  6940, {}},
    { 3740,  6940, {}},
    { 3760,  6960, {}},
    { 3760,  6980, {}},
    { 3760,  7000, {}},
    { 3760,  7020, {}},
    { 3780,  7020, {}},
    { 3800,  7040, {}},
    { 3820,  7060, {}},
    { 3840,  7060, {}},
    { 3840,  7080, {}},
    { 3840,  7100, {}},
    { 3840,  7120, {}},
    { 3820,  7140, {}},
    { 3800,  7120, {}},
    { 3800,  7140, {}},
    { 3780,  7160, {}},
    { 3760,  7160, {}},
    { 3740,  7140, {}},
    { 3720,  7140, {}},
    { 3700,  7140, {}},
    { 3680,  7160, {}},
    { 3660,  7180, {}},
    { 3680,  7200, {}},
    { 3700,  7220, {}},
    { 3700,  7240, {}},
    { 3700,  7260, {}},
    { 3720,  7280, {}},
    { 3740,  7300, {}},
    { 3740,  7320, {}},
    { 3740,  7340, {}},
    { 3740,  7360, {}},
    { 3720,  7380, {}},
    { 3720,  7400, {}},
    { 3740,  7420, {}},
    { 3740,  7440, {}},
    { 3740,  7460, {}},
    { 3740,  7480, {}},
    { 3720,  7500, {}},
    { 3740,  7520, {}},
    { 3760,  7500, {}},
    { 3780,  7500, {}},
    { 3800,  7500, {}},
    { 3820,  7480, {}},
    { 3840,  7460, {}},
    { 3860,  7420, {}},
    { 3860,  7400, {}},
    { 3860,  7380, {}},
    { 3880,  7380, {}},
    { 3900,  7380, {}},
    { 3920,  7360, {}},
    { 3940,  7360, {}},
    { 3940,  7380, {}},
    { 3960,  7400, {}},
    { 3980,  7380, {}},
    { 4000,  7400, {}},
    { 4020,  7420, {}},
    { 4020,  7440, {}},
    { 4020,  7460, {}},
    { 4040,  7480, {}},
    { 4040,  7500, {}},
    { 4138,  7500, {}},
    { 4236,  7500, {}},
    { 4334,  7500, {}},
    { 4432,  7500, {}},
    { 4530,  7500, {}},
    { 4628,  7500, {}},
    { 4726,  7500, {}},
    { 4824,  7500, {}},
    { 4922,  7500, {}},
    { 5020,  7500, {}},
    { 5118,  7500, {}},
    { 5216,  7500, {}},
    { 5314,  7500, {}},
    { 5412,  7500, {}},
    { 5510,  7500, {}},
    { 5608,  7500, {}},
    { 5706,  7500, {}},
    { 5804,  7500, {}},
    { 5902,  7500, {}},
    { 6000,  7500, {}},
    { 6000,  7400, {}},
    { 6000,  7300, {}},
    { 6000,  7200, {}},
    { 6000,  7100, {}},
    { 6000,  7000, {}},
    { 6000,  6900, {}},
    { 6000,  6800, {}},
    { 6000,  6700, {}},
    { 6000,  6600, {}},
    { 6000,  6500, {}},
    { 6000,  6400, {}},
    { 6000,  6300, {}},
    { 6000,  6200, {}},
    { 6000,  6100, {}},
    { 6000,  6000, {}},
    { 6000,  5900, {}},
    { 6000,  5800, {}},
    { 6000,  5700, {}},
    { 6000,  5600, {}},
    { 6000,  5500, {}},
    { 6000,  5400, {}},
    { 6000,  5300, {}},
    { 6000,  5200, {}},
    { 6000,  5100, {}},
    { 6000,  5000, {}},
    { 5900,  5000, {}},
    { 5800,  5000, {}},
    { 5700,  5000, {}},
    { 5600,  5000, {}},
    { 5500,  5000, {}},
    { 5400,  5000, {}},
    { 5300,  5000, {}},
    { 5200,  5000, {}},
    { 5100,  5000, {}},
    { 5000,  5000, {}},
    { 4900,  5000, {}},
    { 4800,  5000, {}},
    { 4700,  5000, {}},
    { 4600,  5000, {}},
    { 4500,  5000, {}},
    { 4400,  5000, {}},
    { 4311,  5020, {}},
    { 4223,  5040, {}},
    { 4134,  5060, {}},
    { 4046,  5080, {}},
    { 3957,  5100, {}},
    { 3869,  5120, {}},
    { 3780,  5140, {}},
};

static ZoneVertex ituz31[] = {
    { 4917,  8782, {}},
    { 4920,  8800, {}},
    { 4940,  8820, {}},
    { 4940,  8840, {}},
    { 4940,  8860, {}},
    { 4940,  8880, {}},
    { 4940,  8900, {}},
    { 4960,  8920, {}},
    { 4960,  8940, {}},
    { 4960,  8960, {}},
    { 4980,  8960, {}},
    { 5000,  8980, {}},
    { 5000,  9000, {}},
    { 5100,  9000, {}},
    { 5200,  9000, {}},
    { 5300,  9000, {}},
    { 5400,  9000, {}},
    { 5500,  9000, {}},
    { 5600,  9000, {}},
    { 5700,  9000, {}},
    { 5800,  9000, {}},
    { 5900,  9000, {}},
    { 6000,  9000, {}},
    { 6000,  8900, {}},
    { 6000,  8800, {}},
    { 6000,  8700, {}},
    { 6000,  8600, {}},
    { 6000,  8500, {}},
    { 6000,  8400, {}},
    { 6000,  8300, {}},
    { 6000,  8200, {}},
    { 6000,  8100, {}},
    { 6000,  8000, {}},
    { 6000,  7900, {}},
    { 6000,  7800, {}},
    { 6000,  7700, {}},
    { 6000,  7600, {}},
    { 6000,  7500, {}},
    { 5902,  7500, {}},
    { 5804,  7500, {}},
    { 5706,  7500, {}},
    { 5608,  7500, {}},
    { 5510,  7500, {}},
    { 5412,  7500, {}},
    { 5314,  7500, {}},
    { 5216,  7500, {}},
    { 5118,  7500, {}},
    { 5020,  7500, {}},
    { 4922,  7500, {}},
    { 4824,  7500, {}},
    { 4726,  7500, {}},
    { 4628,  7500, {}},
    { 4530,  7500, {}},
    { 4432,  7500, {}},
    { 4334,  7500, {}},
    { 4236,  7500, {}},
    { 4138,  7500, {}},
    { 4040,  7500, {}},
    { 4040,  7520, {}},
    { 4060,  7540, {}},
    { 4060,  7560, {}},
    { 4040,  7560, {}},
    { 4040,  7580, {}},
    { 4040,  7600, {}},
    { 4040,  7620, {}},
    { 4040,  7640, {}},
    { 4060,  7660, {}},
    { 4080,  7680, {}},
    { 4100,  7680, {}},
    { 4100,  7700, {}},
    { 4100,  7720, {}},
    { 4100,  7740, {}},
    { 4100,  7760, {}},
    { 4100,  7780, {}},
    { 4120,  7800, {}},
    { 4140,  7820, {}},
    { 4140,  7840, {}},
    { 4140,  7860, {}},
    { 4160,  7880, {}},
    { 4160,  7900, {}},
    { 4180,  7920, {}},
    { 4180,  7940, {}},
    { 4180,  7960, {}},
    { 4200,  7980, {}},
    { 4200,  8000, {}},
    { 4200,  8020, {}},
    { 4220,  8020, {}},
    { 4240,  8020, {}},
    { 4260,  8020, {}},
    { 4280,  8020, {}},
    { 4280,  8040, {}},
    { 4280,  8060, {}},
    { 4300,  8040, {}},
    { 4320,  8060, {}},
    { 4320,  8080, {}},
    { 4340,  8080, {}},
    { 4360,  8060, {}},
    { 4380,  8060, {}},
    { 4400,  8040, {}},
    { 4420,  8040, {}},
    { 4440,  8040, {}},
    { 4460,  8040, {}},
    { 4480,  8020, {}},
    { 4480,  8000, {}},
    { 4500,  8000, {}},
    { 4500,  8020, {}},
    { 4500,  8040, {}},
    { 4520,  8060, {}},
    { 4520,  8080, {}},
    { 4520,  8100, {}},
    { 4520,  8120, {}},
    { 4520,  8140, {}},
    { 4540,  8160, {}},
    { 4540,  8180, {}},
    { 4520,  8200, {}},
    { 4520,  8220, {}},
    { 4520,  8240, {}},
    { 4540,  8260, {}},
    { 4560,  8220, {}},
    { 4580,  8240, {}},
    { 4600,  8240, {}},
    { 4620,  8260, {}},
    { 4640,  8280, {}},
    { 4660,  8280, {}},
    { 4680,  8280, {}},
    { 4700,  8300, {}},
    { 4720,  8300, {}},
    { 4720,  8320, {}},
    { 4720,  8340, {}},
    { 4700,  8360, {}},
    { 4700,  8380, {}},
    { 4700,  8400, {}},
    { 4700,  8420, {}},
    { 4700,  8440, {}},
    { 4700,  8460, {}},
    { 4700,  8480, {}},
    { 4700,  8500, {}},
    { 4700,  8520, {}},
    { 4700,  8540, {}},
    { 4720,  8560, {}},
    { 4740,  8560, {}},
    { 4800,  8560, {}},
    { 4820,  8560, {}},
    { 4840,  8580, {}},
    { 4840,  8600, {}},
    { 4840,  8620, {}},
    { 4840,  8640, {}},
    { 4860,  8660, {}},
    { 4880,  8680, {}},
    { 4900,  8680, {}},
    { 4920,  8700, {}},
    { 4920,  8720, {}},
    { 4900,  8740, {}},
    { 4920,  8760, {}},
    { 4920,  8780, {}},
};

static ZoneVertex ituz32[] = {
    { 6000,  9000, {}},
    { 6000,  9100, {}},
    { 6000,  9200, {}},
    { 6000,  9300, {}},
    { 6000,  9400, {}},
    { 6000,  9500, {}},
    { 6000,  9600, {}},
    { 6000,  9700, {}},
    { 6000,  9800, {}},
    { 6000,  9900, {}},
    { 6000, 10000, {}},
    { 6000, 10100, {}},
    { 6000, 10200, {}},
    { 6000, 10300, {}},
    { 6000, 10400, {}},
    { 6000, 10500, {}},
    { 6000, 10600, {}},
    { 6000, 10700, {}},
    { 6000, 10800, {}},
    { 6000, 10900, {}},
    { 6000, 11000, {}},
    { 5903, 11000, {}},
    { 5807, 11000, {}},
    { 5710, 11000, {}},
    { 5613, 11000, {}},
    { 5517, 11000, {}},
    { 5420, 11000, {}},
    { 5323, 11000, {}},
    { 5227, 11000, {}},
    { 5130, 11000, {}},
    { 5033, 11000, {}},
    { 4937, 11000, {}},
    { 4840, 11000, {}},
    { 4743, 11000, {}},
    { 4647, 11000, {}},
    { 4550, 11000, {}},
    { 4453, 11000, {}},
    { 4357, 11000, {}},
    { 4260, 11000, {}},
    { 4260, 10960, {}},
    { 4240, 10940, {}},
    { 4240, 10900, {}},
    { 4240, 10880, {}},
    { 4240, 10860, {}},
    { 4240, 10840, {}},
    { 4240, 10820, {}},
    { 4240, 10800, {}},
    { 4240, 10780, {}},
    { 4240, 10760, {}},
    { 4240, 10720, {}},
    { 4220, 10680, {}},
    { 4220, 10640, {}},
    { 4200, 10620, {}},
    { 4200, 10580, {}},
    { 4180, 10560, {}},
    { 4180, 10540, {}},
    { 4160, 10500, {}},
    { 4160, 10460, {}},
    { 4180, 10460, {}},
    { 4180, 10400, {}},
    { 4180, 10340, {}},
    { 4200, 10300, {}},
    { 4220, 10280, {}},
    { 4220, 10260, {}},
    { 4220, 10200, {}},
    { 4260, 10180, {}},
    { 4260, 10160, {}},
    { 4260, 10080, {}},
    { 4260, 10040, {}},
    { 4260, 10000, {}},
    { 4260,  9960, {}},
    { 4260,  9860, {}},
    { 4260,  9820, {}},
    { 4280,  9720, {}},
    { 4280,  9700, {}},
    { 4280,  9680, {}},
    { 4280,  9640, {}},
    { 4300,  9620, {}},
    { 4320,  9600, {}},
    { 4340,  9580, {}},
    { 4380,  9560, {}},
    { 4400,  9560, {}},
    { 4400,  9540, {}},
    { 4420,  9540, {}},
    { 4420,  9500, {}},
    { 4440,  9480, {}},
    { 4440,  9460, {}},
    { 4460,  9440, {}},
    { 4460,  9420, {}},
    { 4480,  9380, {}},
    { 4500,  9360, {}},
    { 4500,  9340, {}},
    { 4500,  9320, {}},
    { 4500,  9300, {}},
    { 4500,  9280, {}},
    { 4500,  9260, {}},
    { 4500,  9240, {}},
    { 4500,  9220, {}},
    { 4500,  9180, {}},
    { 4500,  9160, {}},
    { 4520,  9140, {}},
    { 4520,  9120, {}},
    { 4520,  9100, {}},
    { 4520,  9080, {}},
    { 4540,  9080, {}},
    { 4560,  9060, {}},
    { 4580,  9080, {}},
    { 4600,  9100, {}},
    { 4620,  9100, {}},
    { 4640,  9100, {}},
    { 4660,  9100, {}},
    { 4680,  9100, {}},
    { 4700,  9080, {}},
    { 4720,  9060, {}},
    { 4740,  9060, {}},
    { 4760,  9040, {}},
    { 4780,  9020, {}},
    { 4780,  9000, {}},
    { 4780,  8980, {}},
    { 4800,  8960, {}},
    { 4800,  8940, {}},
    { 4800,  8920, {}},
    { 4800,  8900, {}},
    { 4820,  8880, {}},
    { 4820,  8860, {}},
    { 4840,  8840, {}},
    { 4840,  8820, {}},
    { 4860,  8800, {}},
    { 4880,  8780, {}},
    { 4900,  8780, {}},
    { 4920,  8800, {}},
    { 4940,  8820, {}},
    { 4940,  8840, {}},
    { 4940,  8860, {}},
    { 4940,  8880, {}},
    { 4940,  8900, {}},
    { 4960,  8920, {}},
    { 4960,  8940, {}},
    { 4960,  8960, {}},
    { 4980,  8960, {}},
    { 5000,  8980, {}},
    { 5000,  9000, {}},
    { 5100,  9000, {}},
    { 5200,  9000, {}},
    { 5300,  9000, {}},
    { 5400,  9000, {}},
    { 5500,  9000, {}},
    { 5600,  9000, {}},
    { 5700,  9000, {}},
    { 5800,  9000, {}},
    { 5900,  9000, {}},
    { 6000,  9000, {}},
};

static ZoneVertex ituz33[] = {
    { 4400, 11178, {}},
    { 4400, 11275, {}},
    { 4400, 11372, {}},
    { 4400, 11469, {}},
    { 4400, 11566, {}},
    { 4400, 11664, {}},
    { 4400, 11761, {}},
    { 4400, 11858, {}},
    { 4400, 11955, {}},
    { 4400, 12052, {}},
    { 4400, 12149, {}},
    { 4400, 12246, {}},
    { 4400, 12343, {}},
    { 4400, 12440, {}},
    { 4400, 12537, {}},
    { 4400, 12635, {}},
    { 4400, 12732, {}},
    { 4400, 12829, {}},
    { 4400, 12926, {}},
    { 4400, 13023, {}},
    { 4400, 13120, {}},
    { 4440, 13120, {}},
    { 4480, 13120, {}},
    { 4480, 13100, {}},
    { 4500, 13120, {}},
    { 4500, 13140, {}},
    { 4520, 13160, {}},
    { 4520, 13180, {}},
    { 4500, 13280, {}},
    { 4500, 13300, {}},
    { 4520, 13300, {}},
    { 4540, 13320, {}},
    { 4560, 13340, {}},
    { 4580, 13340, {}},
    { 4600, 13360, {}},
    { 4620, 13380, {}},
    { 4640, 13380, {}},
    { 4660, 13400, {}},
    { 4680, 13400, {}},
    { 4700, 13420, {}},
    { 4720, 13420, {}},
    { 4740, 13440, {}},
    { 4760, 13460, {}},
    { 4780, 13460, {}},
    { 4800, 13460, {}},
    { 4820, 13460, {}},
    { 4840, 13480, {}},
    { 4937, 13482, {}},
    { 5033, 13483, {}},
    { 5130, 13485, {}},
    { 5227, 13487, {}},
    { 5323, 13488, {}},
    { 5420, 13490, {}},
    { 5517, 13492, {}},
    { 5613, 13493, {}},
    { 5710, 13495, {}},
    { 5807, 13497, {}},
    { 5903, 13498, {}},
    { 6000, 13500, {}},
    { 6000, 13400, {}},
    { 6000, 13300, {}},
    { 6000, 13200, {}},
    { 6000, 13100, {}},
    { 6000, 13000, {}},
    { 6000, 12900, {}},
    { 6000, 12800, {}},
    { 6000, 12700, {}},
    { 6000, 12600, {}},
    { 6000, 12500, {}},
    { 6000, 12400, {}},
    { 6000, 12300, {}},
    { 6000, 12200, {}},
    { 6000, 12100, {}},
    { 6000, 12000, {}},
    { 6000, 11900, {}},
    { 6000, 11800, {}},
    { 6000, 11700, {}},
    { 6000, 11600, {}},
    { 6000, 11500, {}},
    { 6000, 11400, {}},
    { 6000, 11300, {}},
    { 6000, 11200, {}},
    { 6000, 11100, {}},
    { 6000, 11000, {}},
    { 5903, 11000, {}},
    { 5807, 11000, {}},
    { 5710, 11000, {}},
    { 5613, 11000, {}},
    { 5517, 11000, {}},
    { 5420, 11000, {}},
    { 5323, 11000, {}},
    { 5227, 11000, {}},
    { 5130, 11000, {}},
    { 5033, 11000, {}},
    { 4937, 11000, {}},
    { 4840, 11000, {}},
    { 4743, 11000, {}},
    { 4647, 11000, {}},
    { 4550, 11000, {}},
    { 4453, 11000, {}},
    { 4357, 11000, {}},
    { 4260, 11000, {}},
    { 4280, 11020, {}},
    { 4280, 11040, {}},
    { 4300, 11060, {}},
    { 4320, 11080, {}},
    { 4340, 11100, {}},
    { 4340, 11120, {}},
    { 4340, 11140, {}},
    { 4360, 11160, {}},
    { 4360, 11180, {}},
    { 4380, 11200, {}},
    { 4400, 11180, {}},
};

static ZoneVertex ituz34[] = {
    { 4574, 14649, {}},
    { 4575, 14554, {}},
    { 4576, 14458, {}},
    { 4576, 14362, {}},
    { 4577, 14267, {}},
    { 4578, 14171, {}},
    { 4579, 14076, {}},
    { 4580, 13980, {}},
    { 4490, 13900, {}},
    { 4400, 13820, {}},
    { 4310, 13740, {}},
    { 4220, 13660, {}},
    { 4220, 13563, {}},
    { 4220, 13467, {}},
    { 4220, 13370, {}},
    { 4220, 13273, {}},
    { 4220, 13177, {}},
    { 4220, 13080, {}},
    { 4240, 13060, {}},
    { 4260, 13060, {}},
    { 4280, 13040, {}},
    { 4280, 13060, {}},
    { 4280, 13080, {}},
    { 4280, 13100, {}},
    { 4300, 13100, {}},
    { 4320, 13120, {}},
    { 4340, 13120, {}},
    { 4360, 13120, {}},
    { 4380, 13120, {}},
    { 4400, 13120, {}},
    { 4480, 13120, {}},
    { 4480, 13100, {}},
    { 4500, 13120, {}},
    { 4500, 13140, {}},
    { 4520, 13160, {}},
    { 4520, 13180, {}},
    { 4500, 13280, {}},
    { 4500, 13300, {}},
    { 4520, 13300, {}},
    { 4540, 13320, {}},
    { 4560, 13340, {}},
    { 4580, 13340, {}},
    { 4600, 13360, {}},
    { 4620, 13380, {}},
    { 4640, 13380, {}},
    { 4660, 13400, {}},
    { 4680, 13400, {}},
    { 4700, 13420, {}},
    { 4720, 13420, {}},
    { 4740, 13440, {}},
    { 4760, 13460, {}},
    { 4780, 13460, {}},
    { 4800, 13460, {}},
    { 4820, 13460, {}},
    { 4840, 13480, {}},
    { 4937, 13482, {}},
    { 5033, 13483, {}},
    { 5130, 13485, {}},
    { 5227, 13487, {}},
    { 5323, 13488, {}},
    { 5420, 13490, {}},
    { 5517, 13492, {}},
    { 5613, 13493, {}},
    { 5710, 13495, {}},
    { 5807, 13497, {}},
    { 5903, 13498, {}},
    { 6000, 13500, {}},
    { 6000, 13600, {}},
    { 6000, 13700, {}},
    { 6000, 13800, {}},
    { 6000, 13900, {}},
    { 6000, 14000, {}},
    { 6000, 14100, {}},
    { 6000, 14200, {}},
    { 6000, 14300, {}},
    { 6000, 14400, {}},
    { 6000, 14500, {}},
    { 6000, 14600, {}},
    { 6000, 14700, {}},
    { 6000, 14800, {}},
    { 6000, 14900, {}},
    { 6000, 15000, {}},
    { 6000, 15100, {}},
    { 6000, 15200, {}},
    { 6000, 15300, {}},
    { 6000, 15400, {}},
    { 6000, 15500, {}},
    { 5900, 15500, {}},
    { 5800, 15500, {}},
    { 5700, 15500, {}},
    { 5607, 15428, {}},
    { 5513, 15357, {}},
    { 5420, 15285, {}},
    { 5327, 15213, {}},
    { 5233, 15142, {}},
    { 5140, 15070, {}},
    { 5047, 14998, {}},
    { 4953, 14927, {}},
    { 4860, 14855, {}},
    { 4767, 14783, {}},
    { 4673, 14712, {}},
    { 4580, 14640, {}},
};

static ZoneVertex ituz35[] = {
    { 4522, 15000, {}},
    { 4471, 14905, {}},
    { 4421, 14810, {}},
    { 4370, 14715, {}},
    { 4320, 14620, {}},
    { 4360, 14560, {}},
    { 4380, 14520, {}},
    { 4480, 14580, {}},
    { 4580, 14640, {}},
    { 4673, 14712, {}},
    { 4767, 14783, {}},
    { 4860, 14855, {}},
    { 4953, 14927, {}},
    { 5047, 14998, {}},
    { 5140, 15070, {}},
    { 5233, 15142, {}},
    { 5327, 15213, {}},
    { 5420, 15285, {}},
    { 5513, 15357, {}},
    { 5607, 15428, {}},
    { 5700, 15500, {}},
    { 5800, 15500, {}},
    { 5900, 15500, {}},
    { 6000, 15500, {}},
    { 6000, 15600, {}},
    { 6000, 15700, {}},
    { 6000, 15800, {}},
    { 6000, 15900, {}},
    { 6000, 16000, {}},
    { 6000, 16100, {}},
    { 6000, 16200, {}},
    { 6000, 16300, {}},
    { 6000, 16400, {}},
    { 6000, 16500, {}},
    { 6000, 16600, {}},
    { 6000, 16700, {}},
    { 6000, 16800, {}},
    { 6000, 16900, {}},
    { 6000, 17000, {}},
    { 6000, 17100, {}},
    { 6000, 17200, {}},
    { 6000, 17300, {}},
    { 6000, 17400, {}},
    { 6000, 17500, {}},
    { 6000, 17600, {}},
    { 6000, 17700, {}},
    { 6000, 17800, {}},
    { 6000, 17900, {}},
    { 6000, -18000, {}},
    { 5950, 17900, {}},
    { 5900, 17800, {}},
    { 5850, 17700, {}},
    { 5800, 17600, {}},
    { 5750, 17500, {}},
    { 5700, 17400, {}},
    { 5650, 17300, {}},
    { 5600, 17200, {}},
    { 5550, 17100, {}},
    { 5500, 17000, {}},
    { 5450, 16900, {}},
    { 5400, 16800, {}},
    { 5350, 16700, {}},
    { 5300, 16600, {}},
    { 5250, 16500, {}},
    { 5200, 16400, {}},
    { 5150, 16300, {}},
    { 5100, 16200, {}},
    { 5050, 16100, {}},
    { 5000, 16000, {}},
    { 4952, 15900, {}},
    { 4904, 15800, {}},
    { 4856, 15700, {}},
    { 4808, 15600, {}},
    { 4760, 15500, {}},
    { 4712, 15400, {}},
    { 4664, 15300, {}},
    { 4616, 15200, {}},
    { 4568, 15100, {}},
    { 4520, 15000, {}},
};

static ZoneVertex ituz36[] = {
    { 2300, -4000, {}},
    { 2400, -4000, {}},
    { 2500, -4000, {}},
    { 2600, -4000, {}},
    { 2700, -4000, {}},
    { 2800, -4000, {}},
    { 2900, -4000, {}},
    { 3000, -4000, {}},
    { 3100, -4000, {}},
    { 3200, -4000, {}},
    { 3300, -4000, {}},
    { 3400, -4000, {}},
    { 3500, -4000, {}},
    { 3600, -4000, {}},
    { 3700, -4000, {}},
    { 3800, -4000, {}},
    { 3900, -4000, {}},
    { 4000, -4000, {}},
    { 4100, -4000, {}},
    { 4200, -4000, {}},
    { 4300, -4000, {}},
    { 4400, -4000, {}},
    { 4400, -3900, {}},
    { 4400, -3800, {}},
    { 4400, -3700, {}},
    { 4400, -3600, {}},
    { 4400, -3500, {}},
    { 4400, -3400, {}},
    { 4400, -3300, {}},
    { 4400, -3200, {}},
    { 4400, -3100, {}},
    { 4400, -3000, {}},
    { 4400, -2900, {}},
    { 4400, -2800, {}},
    { 4400, -2700, {}},
    { 4400, -2600, {}},
    { 4400, -2500, {}},
    { 4400, -2400, {}},
    { 4400, -2300, {}},
    { 4400, -2200, {}},
    { 4400, -2100, {}},
    { 4400, -2000, {}},
    { 4400, -1900, {}},
    { 4400, -1800, {}},
    { 4400, -1700, {}},
    { 4400, -1600, {}},
    { 4400, -1500, {}},
    { 4400, -1400, {}},
    { 4400, -1300, {}},
    { 4301, -1300, {}},
    { 4203, -1300, {}},
    { 4104, -1300, {}},
    { 4005, -1300, {}},
    { 3906, -1300, {}},
    { 3808, -1300, {}},
    { 3709, -1300, {}},
    { 3610, -1300, {}},
    { 3511, -1300, {}},
    { 3413, -1300, {}},
    { 3314, -1300, {}},
    { 3215, -1300, {}},
    { 3116, -1300, {}},
    { 3018, -1300, {}},
    { 2919, -1300, {}},
    { 2820, -1300, {}},
    { 2733, -1367, {}},
    { 2647, -1433, {}},
    { 2560, -1500, {}},
    { 2473, -1567, {}},
    { 2387, -1633, {}},
    { 2300, -1700, {}},
    { 2300, -1800, {}},
    { 2300, -1900, {}},
    { 2300, -2000, {}},
    { 2300, -2100, {}},
    { 2300, -2200, {}},
    { 2300, -2300, {}},
    { 2300, -2400, {}},
    { 2300, -2500, {}},
    { 2300, -2600, {}},
    { 2300, -2700, {}},
    { 2300, -2800, {}},
    { 2300, -2900, {}},
    { 2300, -3000, {}},
    { 2300, -3100, {}},
    { 2300, -3200, {}},
    { 2300, -3300, {}},
    { 2300, -3400, {}},
    { 2300, -3500, {}},
    { 2300, -3600, {}},
    { 2300, -3700, {}},
    { 2300, -3800, {}},
    { 2300, -3900, {}},
    { 2300, -4000, {}},
};

static ZoneVertex ituz37[] = {
    { 4400, -1300, {}},
    { 4301, -1300, {}},
    { 4203, -1300, {}},
    { 4104, -1300, {}},
    { 4005, -1300, {}},
    { 3906, -1300, {}},
    { 3808, -1300, {}},
    { 3709, -1300, {}},
    { 3610, -1300, {}},
    { 3511, -1300, {}},
    { 3413, -1300, {}},
    { 3314, -1300, {}},
    { 3215, -1300, {}},
    { 3116, -1300, {}},
    { 3018, -1300, {}},
    { 2919, -1300, {}},
    { 2820, -1300, {}},
    { 2760, -1340, {}},
    { 2760, -1244, {}},
    { 2760, -1148, {}},
    { 2760, -1052, {}},
    { 2760,  -956, {}},
    { 2760,  -860, {}},
    { 2720,  -860, {}},
    { 2665,  -765, {}},
    { 2610,  -670, {}},
    { 2555,  -575, {}},
    { 2500,  -480, {}},
    { 2460,  -430, {}},
    { 2420,  -380, {}},
    { 2360,  -280, {}},
    { 2300,  -180, {}},
    { 2240,   -80, {}},
    { 2180,    20, {}},
    { 2120,   120, {}},
    { 2100,   120, {}},
    { 2080,   120, {}},
    { 2060,   160, {}},
    { 2020,   180, {}},
    { 2020,   200, {}},
    { 2040,   220, {}},
    { 2020,   240, {}},
    { 2000,   260, {}},
    { 2000,   280, {}},
    { 2000,   300, {}},
    { 1980,   320, {}},
    { 1960,   320, {}},
    { 1940,   320, {}},
    { 1920,   320, {}},
    { 1900,   320, {}},
    { 1913,   407, {}},
    { 1927,   493, {}},
    { 1940,   580, {}},
    { 2010,   660, {}},
    { 2080,   740, {}},
    { 2132,   832, {}},
    { 2184,   924, {}},
    { 2236,  1016, {}},
    { 2288,  1108, {}},
    { 2340,  1200, {}},
    { 2420,  1160, {}},
    { 2440,  1120, {}},
    { 2440,  1100, {}},
    { 2460,  1080, {}},
    { 2460,  1060, {}},
    { 2460,  1040, {}},
    { 2460,  1020, {}},
    { 2480,  1020, {}},
    { 2540,  1000, {}},
    { 2620,   940, {}},
    { 2660,   980, {}},
    { 2680,  1000, {}},
    { 2700,   980, {}},
    { 2720,   980, {}},
    { 2740,   980, {}},
    { 2760,   980, {}},
    { 2780,  1000, {}},
    { 2820,   980, {}},
    { 2880,  1000, {}},
    { 2940,   980, {}},
    { 2980,   960, {}},
    { 3000,   940, {}},
    { 3040,  1000, {}},
    { 3060,  1020, {}},
    { 3080,  1040, {}},
    { 3100,  1020, {}},
    { 3140,  1020, {}},
    { 3180,  1040, {}},
    { 3180,  1060, {}},
    { 3200,  1080, {}},
    { 3220,  1120, {}},
    { 3240,  1160, {}},
    { 3260,  1140, {}},
    { 3300,  1140, {}},
    { 3320,  1160, {}},
    { 3407,  1213, {}},
    { 3493,  1267, {}},
    { 3580,  1320, {}},
    { 3640,  1280, {}},
    { 3700,  1240, {}},
    { 3733,  1160, {}},
    { 3767,  1080, {}},
    { 3800,  1000, {}},
    { 3800,   920, {}},
    { 3800,   840, {}},
    { 3800,   760, {}},
    { 3888,   760, {}},
    { 3976,   760, {}},
    { 4064,   760, {}},
    { 4152,   760, {}},
    { 4240,   760, {}},
    { 4240,   672, {}},
    { 4240,   584, {}},
    { 4240,   496, {}},
    { 4240,   408, {}},
    { 4240,   320, {}},
    { 4240,   300, {}},
    { 4240,   280, {}},
    { 4240,   260, {}},
    { 4240,   240, {}},
    { 4240,   220, {}},
    { 4240,   200, {}},
    { 4240,   180, {}},
    { 4240,   160, {}},
    { 4260,   140, {}},
    { 4280,   120, {}},
    { 4280,   100, {}},
    { 4280,    80, {}},
    { 4260,    60, {}},
    { 4260,    40, {}},
    { 4280,    20, {}},
    { 4260,     0, {}},
    { 4280,   -20, {}},
    { 4280,   -40, {}},
    { 4280,   -60, {}},
    { 4300,   -80, {}},
    { 4300,  -100, {}},
    { 4300,  -120, {}},
    { 4300,  -140, {}},
    { 4320,  -140, {}},
    { 4320,  -160, {}},
    { 4340,  -180, {}},
    { 4370,  -240, {}},
    { 4400,  -300, {}},
    { 4400,  -400, {}},
    { 4400,  -500, {}},
    { 4400,  -600, {}},
    { 4400,  -700, {}},
    { 4400,  -800, {}},
    { 4400,  -900, {}},
    { 4400, -1000, {}},
    { 4400, -1100, {}},
    { 4400, -1200, {}},
    { 4400, -1300, {}},
};

static ZoneVertex ituz38[] = {
    { 2792,  3485, {}},
    { 2710,  3520, {}},
    { 2627,  3555, {}},
    { 2545,  3590, {}},
    { 2462,  3625, {}},
    { 2380,  3660, {}},
    { 2320,  3560, {}},
    { 2280,  3520, {}},
    { 2280,  3500, {}},
    { 2260,  3480, {}},
    { 2220,  3460, {}},
    { 2220,  3420, {}},
    { 2180,  3400, {}},
    { 2180,  3360, {}},
    { 2200,  3320, {}},
    { 2200,  3233, {}},
    { 2200,  3147, {}},
    { 2200,  3060, {}},
    { 2200,  2973, {}},
    { 2200,  2887, {}},
    { 2200,  2800, {}},
    { 2200,  2700, {}},
    { 2200,  2600, {}},
    { 2200,  2500, {}},
    { 2100,  2500, {}},
    { 2000,  2500, {}},
    { 2000,  2400, {}},
    { 1960,  2400, {}},
    { 2010,  2300, {}},
    { 2060,  2200, {}},
    { 2110,  2100, {}},
    { 2160,  2000, {}},
    { 2205,  1900, {}},
    { 2250,  1800, {}},
    { 2295,  1700, {}},
    { 2340,  1600, {}},
    { 2300,  1500, {}},
    { 2260,  1420, {}},
    { 2300,  1380, {}},
    { 2320,  1360, {}},
    { 2330,  1280, {}},
    { 2340,  1200, {}},
    { 2420,  1160, {}},
    { 2440,  1120, {}},
    { 2440,  1100, {}},
    { 2460,  1080, {}},
    { 2460,  1060, {}},
    { 2460,  1040, {}},
    { 2460,  1020, {}},
    { 2480,  1020, {}},
    { 2540,  1000, {}},
    { 2620,   940, {}},
    { 2660,   980, {}},
    { 2680,  1000, {}},
    { 2700,   980, {}},
    { 2720,   980, {}},
    { 2740,   980, {}},
    { 2760,   980, {}},
    { 2780,  1000, {}},
    { 2820,   980, {}},
    { 2880,  1000, {}},
    { 2940,   980, {}},
    { 2980,   960, {}},
    { 3000,   940, {}},
    { 3040,  1000, {}},
    { 3060,  1020, {}},
    { 3080,  1040, {}},
    { 3100,  1020, {}},
    { 3140,  1020, {}},
    { 3180,  1040, {}},
    { 3180,  1060, {}},
    { 3200,  1080, {}},
    { 3220,  1120, {}},
    { 3240,  1160, {}},
    { 3260,  1140, {}},
    { 3300,  1140, {}},
    { 3320,  1160, {}},
    { 3407,  1213, {}},
    { 3493,  1267, {}},
    { 3580,  1320, {}},
    { 3563,  1420, {}},
    { 3546,  1520, {}},
    { 3529,  1620, {}},
    { 3512,  1720, {}},
    { 3495,  1820, {}},
    { 3478,  1920, {}},
    { 3461,  2020, {}},
    { 3444,  2120, {}},
    { 3427,  2220, {}},
    { 3410,  2320, {}},
    { 3393,  2420, {}},
    { 3376,  2520, {}},
    { 3359,  2620, {}},
    { 3342,  2720, {}},
    { 3325,  2820, {}},
    { 3308,  2920, {}},
    { 3291,  3020, {}},
    { 3274,  3120, {}},
    { 3257,  3220, {}},
    { 3240,  3320, {}},
    { 3140,  3420, {}},
    { 3100,  3440, {}},
    { 3060,  3440, {}},
    { 3040,  3460, {}},
    { 3000,  3480, {}},
    { 2980,  3480, {}},
    { 2960,  3480, {}},
    { 2920,  3480, {}},
    { 2860,  3460, {}},
    { 2800,  3440, {}},
    { 2800,  3480, {}},
};

static ZoneVertex ituz39[] = {
    { 3963,  4481, {}},
    { 3980,  4460, {}},
    { 4000,  4440, {}},
    { 4000,  4420, {}},
    { 4000,  4400, {}},
    { 4000,  4380, {}},
    { 4020,  4360, {}},
    { 4040,  4360, {}},
    { 4060,  4380, {}},
    { 4080,  4380, {}},
    { 4100,  4360, {}},
    { 4120,  4340, {}},
    { 4120,  4320, {}},
    { 4140,  4300, {}},
    { 4160,  4280, {}},
    { 4160,  4260, {}},
    { 4140,  4240, {}},
    { 4140,  4220, {}},
    { 4160,  4200, {}},
    { 4140,  4180, {}},
    { 4160,  4160, {}},
    { 4177,  4063, {}},
    { 4193,  3967, {}},
    { 4210,  3870, {}},
    { 4227,  3773, {}},
    { 4243,  3677, {}},
    { 4260,  3580, {}},
    { 4277,  3483, {}},
    { 4293,  3387, {}},
    { 4310,  3290, {}},
    { 4327,  3193, {}},
    { 4343,  3097, {}},
    { 4360,  3000, {}},
    { 4280,  3000, {}},
    { 4200,  3000, {}},
    { 4200,  2900, {}},
    { 4200,  2800, {}},
    { 4200,  2780, {}},
    { 4200,  2760, {}},
    { 4200,  2740, {}},
    { 4200,  2720, {}},
    { 4200,  2700, {}},
    { 4200,  2680, {}},
    { 4200,  2660, {}},
    { 4180,  2640, {}},
    { 4160,  2660, {}},
    { 4140,  2660, {}},
    { 4120,  2640, {}},
    { 4100,  2640, {}},
    { 4080,  2620, {}},
    { 4020,  2560, {}},
    { 3940,  2600, {}},
    { 3940,  2640, {}},
    { 3900,  2680, {}},
    { 3860,  2640, {}},
    { 3820,  2620, {}},
    { 3780,  2720, {}},
    { 3760,  2700, {}},
    { 3720,  2720, {}},
    { 3700,  2720, {}},
    { 3680,  2740, {}},
    { 3660,  2780, {}},
    { 3660,  2860, {}},
    { 3620,  2940, {}},
    { 3620,  2960, {}},
    { 3600,  3000, {}},
    { 3500,  3000, {}},
    { 3400,  3000, {}},
    { 3300,  3000, {}},
    { 3285,  3080, {}},
    { 3270,  3160, {}},
    { 3255,  3240, {}},
    { 3240,  3320, {}},
    { 3140,  3420, {}},
    { 3100,  3440, {}},
    { 3060,  3440, {}},
    { 3040,  3460, {}},
    { 3000,  3480, {}},
    { 2980,  3480, {}},
    { 2960,  3480, {}},
    { 2920,  3480, {}},
    { 2860,  3460, {}},
    { 2800,  3440, {}},
    { 2800,  3480, {}},
    { 2716,  3516, {}},
    { 2632,  3552, {}},
    { 2548,  3588, {}},
    { 2464,  3624, {}},
    { 2380,  3660, {}},
    { 2285,  3715, {}},
    { 2191,  3769, {}},
    { 2096,  3824, {}},
    { 2002,  3878, {}},
    { 1907,  3933, {}},
    { 1813,  3987, {}},
    { 1718,  4042, {}},
    { 1624,  4096, {}},
    { 1529,  4151, {}},
    { 1435,  4205, {}},
    { 1340,  4260, {}},
    { 1240,  4350, {}},
    { 1140,  4440, {}},
    { 1163,  4538, {}},
    { 1185,  4635, {}},
    { 1208,  4733, {}},
    { 1230,  4830, {}},
    { 1253,  4928, {}},
    { 1275,  5025, {}},
    { 1298,  5123, {}},
    { 1320,  5220, {}},
    { 1343,  5318, {}},
    { 1365,  5415, {}},
    { 1388,  5513, {}},
    { 1410,  5610, {}},
    { 1433,  5708, {}},
    { 1455,  5805, {}},
    { 1478,  5903, {}},
    { 1500,  6000, {}},
    { 1600,  6000, {}},
    { 1700,  6000, {}},
    { 1800,  6000, {}},
    { 1900,  6000, {}},
    { 2000,  6000, {}},
    { 2100,  6000, {}},
    { 2200,  6000, {}},
    { 2300,  6000, {}},
    { 2400,  6000, {}},
    { 2440,  5913, {}},
    { 2480,  5827, {}},
    { 2520,  5740, {}},
    { 2590,  5690, {}},
    { 2660,  5640, {}},
    { 2610,  5540, {}},
    { 2560,  5440, {}},
    { 2605,  5355, {}},
    { 2650,  5270, {}},
    { 2695,  5185, {}},
    { 2740,  5100, {}},
    { 2827,  5020, {}},
    { 2913,  4940, {}},
    { 3000,  4860, {}},
    { 3020,  4840, {}},
    { 3040,  4820, {}},
    { 3080,  4800, {}},
    { 3100,  4760, {}},
    { 3140,  4760, {}},
    { 3180,  4780, {}},
    { 3200,  4780, {}},
    { 3220,  4760, {}},
    { 3240,  4740, {}},
    { 3240,  4720, {}},
    { 3260,  4700, {}},
    { 3280,  4680, {}},
    { 3280,  4660, {}},
    { 3300,  4640, {}},
    { 3300,  4620, {}},
    { 3320,  4620, {}},
    { 3340,  4600, {}},
    { 3360,  4600, {}},
    { 3360,  4580, {}},
    { 3380,  4560, {}},
    { 3400,  4540, {}},
    { 3420,  4560, {}},
    { 3440,  4540, {}},
    { 3460,  4560, {}},
    { 3480,  4560, {}},
    { 3500,  4580, {}},
    { 3500,  4600, {}},
    { 3520,  4620, {}},
    { 3540,  4600, {}},
    { 3560,  4600, {}},
    { 3580,  4620, {}},
    { 3580,  4600, {}},
    { 3580,  4580, {}},
    { 3600,  4560, {}},
    { 3600,  4540, {}},
    { 3620,  4540, {}},
    { 3640,  4520, {}},
    { 3660,  4500, {}},
    { 3680,  4480, {}},
    { 3700,  4500, {}},
    { 3700,  4480, {}},
    { 3720,  4480, {}},
    { 3740,  4460, {}},
    { 3760,  4460, {}},
    { 3780,  4440, {}},
    { 3800,  4420, {}},
    { 3820,  4440, {}},
    { 3840,  4440, {}},
    { 3860,  4440, {}},
    { 3880,  4440, {}},
    { 3900,  4420, {}},
    { 3920,  4420, {}},
    { 3940,  4400, {}},
    { 3940,  4420, {}},
    { 3940,  4440, {}},
    { 3960,  4440, {}},
    { 3980,  4460, {}},
    { 3960,  4480, {}},
};

static ZoneVertex ituz40[] = {
    { 2400,  6000, {}},
    { 2440,  5913, {}},
    { 2480,  5827, {}},
    { 2520,  5740, {}},
    { 2590,  5690, {}},
    { 2660,  5640, {}},
    { 2610,  5540, {}},
    { 2560,  5440, {}},
    { 2605,  5355, {}},
    { 2650,  5270, {}},
    { 2695,  5185, {}},
    { 2740,  5100, {}},
    { 2827,  5020, {}},
    { 2913,  4940, {}},
    { 3000,  4860, {}},
    { 3020,  4840, {}},
    { 3040,  4820, {}},
    { 3080,  4800, {}},
    { 3100,  4760, {}},
    { 3140,  4760, {}},
    { 3180,  4780, {}},
    { 3200,  4780, {}},
    { 3220,  4760, {}},
    { 3240,  4740, {}},
    { 3240,  4720, {}},
    { 3260,  4700, {}},
    { 3280,  4680, {}},
    { 3280,  4660, {}},
    { 3300,  4640, {}},
    { 3300,  4620, {}},
    { 3320,  4620, {}},
    { 3340,  4600, {}},
    { 3360,  4600, {}},
    { 3360,  4580, {}},
    { 3380,  4560, {}},
    { 3400,  4540, {}},
    { 3420,  4560, {}},
    { 3440,  4540, {}},
    { 3460,  4560, {}},
    { 3480,  4560, {}},
    { 3500,  4580, {}},
    { 3500,  4600, {}},
    { 3520,  4620, {}},
    { 3540,  4600, {}},
    { 3560,  4600, {}},
    { 3580,  4620, {}},
    { 3580,  4600, {}},
    { 3580,  4580, {}},
    { 3600,  4560, {}},
    { 3600,  4540, {}},
    { 3620,  4540, {}},
    { 3640,  4520, {}},
    { 3660,  4500, {}},
    { 3680,  4480, {}},
    { 3700,  4500, {}},
    { 3700,  4480, {}},
    { 3720,  4480, {}},
    { 3740,  4460, {}},
    { 3760,  4460, {}},
    { 3780,  4440, {}},
    { 3800,  4420, {}},
    { 3820,  4440, {}},
    { 3840,  4440, {}},
    { 3860,  4440, {}},
    { 3880,  4440, {}},
    { 3900,  4420, {}},
    { 3920,  4420, {}},
    { 3940,  4400, {}},
    { 3940,  4420, {}},
    { 3940,  4440, {}},
    { 3960,  4440, {}},
    { 3980,  4460, {}},
    { 3960,  4480, {}},
    { 3940,  4500, {}},
    { 3920,  4520, {}},
    { 3900,  4540, {}},
    { 3900,  4560, {}},
    { 3900,  4580, {}},
    { 3880,  4600, {}},
    { 3880,  4620, {}},
    { 3900,  4640, {}},
    { 3900,  4660, {}},
    { 3900,  4680, {}},
    { 3920,  4700, {}},
    { 3940,  4720, {}},
    { 3940,  4740, {}},
    { 3960,  4760, {}},
    { 3960,  4780, {}},
    { 3960,  4800, {}},
    { 3940,  4840, {}},
    { 3940,  4820, {}},
    { 3920,  4820, {}},
    { 3900,  4840, {}},
    { 3900,  4820, {}},
    { 3880,  4800, {}},
    { 3880,  4820, {}},
    { 3860,  4840, {}},
    { 3840,  4860, {}},
    { 3840,  4880, {}},
    { 3820,  4967, {}},
    { 3800,  5053, {}},
    { 3780,  5140, {}},
    { 3767,  5227, {}},
    { 3753,  5313, {}},
    { 3740,  5400, {}},
    { 3740,  5420, {}},
    { 3740,  5440, {}},
    { 3740,  5460, {}},
    { 3760,  5480, {}},
    { 3780,  5500, {}},
    { 3800,  5520, {}},
    { 3800,  5540, {}},
    { 3800,  5560, {}},
    { 3820,  5580, {}},
    { 3800,  5600, {}},
    { 3800,  5620, {}},
    { 3820,  5640, {}},
    { 3820,  5660, {}},
    { 3820,  5680, {}},
    { 3820,  5700, {}},
    { 3820,  5720, {}},
    { 3800,  5740, {}},
    { 3800,  5760, {}},
    { 3780,  5780, {}},
    { 3780,  5800, {}},
    { 3780,  5820, {}},
    { 3760,  5840, {}},
    { 3760,  5860, {}},
    { 3760,  5880, {}},
    { 3760,  5900, {}},
    { 3760,  5920, {}},
    { 3740,  5940, {}},
    { 3720,  5940, {}},
    { 3720,  5960, {}},
    { 3700,  5980, {}},
    { 3700,  6000, {}},
    { 3680,  6020, {}},
    { 3660,  6040, {}},
    { 3660,  6060, {}},
    { 3660,  6080, {}},
    { 3660,  6120, {}},
    { 3640,  6120, {}},
    { 3620,  6120, {}},
    { 3600,  6120, {}},
    { 3580,  6120, {}},
    { 3560,  6140, {}},
    { 3540,  6160, {}},
    { 3540,  6180, {}},
    { 3540,  6200, {}},
    { 3540,  6220, {}},
    { 3520,  6220, {}},
    { 3520,  6240, {}},
    { 3520,  6260, {}},
    { 3540,  6280, {}},
    { 3540,  6300, {}},
    { 3560,  6320, {}},
    { 3580,  6320, {}},
    { 3580,  6340, {}},
    { 3600,  6360, {}},
    { 3600,  6380, {}},
    { 3600,  6400, {}},
    { 3620,  6420, {}},
    { 3620,  6440, {}},
    { 3640,  6460, {}},
    { 3660,  6460, {}},
    { 3680,  6480, {}},
    { 3700,  6480, {}},
    { 3720,  6500, {}},
    { 3720,  6520, {}},
    { 3720,  6560, {}},
    { 3740,  6560, {}},
    { 3760,  6580, {}},
    { 3740,  6600, {}},
    { 3740,  6620, {}},
    { 3740,  6640, {}},
    { 3740,  6660, {}},
    { 3740,  6680, {}},
    { 3740,  6700, {}},
    { 3720,  6720, {}},
    { 3720,  6740, {}},
    { 3720,  6760, {}},
    { 3700,  6780, {}},
    { 3700,  6800, {}},
    { 3700,  6820, {}},
    { 3720,  6840, {}},
    { 3720,  6860, {}},
    { 3720,  6880, {}},
    { 3740,  6900, {}},
    { 3720,  6920, {}},
    { 3720,  6940, {}},
    { 3740,  6940, {}},
    { 3760,  6960, {}},
    { 3760,  6980, {}},
    { 3760,  7000, {}},
    { 3760,  7020, {}},
    { 3780,  7020, {}},
    { 3800,  7040, {}},
    { 3820,  7060, {}},
    { 3840,  7060, {}},
    { 3840,  7080, {}},
    { 3840,  7100, {}},
    { 3840,  7120, {}},
    { 3820,  7140, {}},
    { 3800,  7120, {}},
    { 3800,  7140, {}},
    { 3780,  7160, {}},
    { 3760,  7160, {}},
    { 3740,  7140, {}},
    { 3720,  7140, {}},
    { 3700,  7140, {}},
    { 3680,  7160, {}},
    { 3660,  7180, {}},
    { 3680,  7200, {}},
    { 3700,  7220, {}},
    { 3700,  7240, {}},
    { 3700,  7260, {}},
    { 3720,  7280, {}},
    { 3740,  7300, {}},
    { 3740,  7320, {}},
    { 3740,  7340, {}},
    { 3740,  7360, {}},
    { 3720,  7380, {}},
    { 3720,  7400, {}},
    { 3740,  7420, {}},
    { 3740,  7440, {}},
    { 3740,  7460, {}},
    { 3740,  7480, {}},
    { 3720,  7460, {}},
    { 3700,  7460, {}},
    { 3700,  7440, {}},
    { 3700,  7420, {}},
    { 3680,  7400, {}},
    { 3680,  7380, {}},
    { 3700,  7360, {}},
    { 3680,  7340, {}},
    { 3680,  7320, {}},
    { 3680,  7300, {}},
    { 3680,  7280, {}},
    { 3680,  7260, {}},
    { 3680,  7240, {}},
    { 3660,  7220, {}},
    { 3660,  7200, {}},
    { 3640,  7180, {}},
    { 3640,  7160, {}},
    { 3620,  7140, {}},
    { 3600,  7120, {}},
    { 3580,  7140, {}},
    { 3560,  7160, {}},
    { 3540,  7160, {}},
    { 3520,  7160, {}},
    { 3500,  7160, {}},
    { 3500,  7140, {}},
    { 3480,  7120, {}},
    { 3460,  7100, {}},
    { 3440,  7100, {}},
    { 3420,  7120, {}},
    { 3400,  7100, {}},
    { 3400,  7080, {}},
    { 3400,  7060, {}},
    { 3400,  7040, {}},
    { 3400,  7020, {}},
    { 3400,  7000, {}},
    { 3380,  7000, {}},
    { 3360,  7020, {}},
    { 3340,  7040, {}},
    { 3320,  7020, {}},
    { 3320,  7000, {}},
    { 3320,  6980, {}},
    { 3300,  6960, {}},
    { 3280,  6940, {}},
    { 3260,  6940, {}},
    { 3240,  6920, {}},
    { 3220,  6920, {}},
    { 3200,  6920, {}},
    { 3180,  6920, {}},
    { 3160,  6900, {}},
    { 3160,  6880, {}},
    { 3180,  6860, {}},
    { 3180,  6840, {}},
    { 3180,  6820, {}},
    { 3160,  6800, {}},
    { 3160,  6780, {}},
    { 3160,  6760, {}},
    { 3140,  6760, {}},
    { 3120,  6740, {}},
    { 3120,  6720, {}},
    { 3140,  6700, {}},
    { 3120,  6680, {}},
    { 3100,  6660, {}},
    { 3100,  6640, {}},
    { 3080,  6640, {}},
    { 3060,  6620, {}},
    { 3040,  6640, {}},
    { 3020,  6620, {}},
    { 3000,  6640, {}},
    { 2980,  6620, {}},
    { 2980,  6600, {}},
    { 2980,  6580, {}},
    { 2960,  6560, {}},
    { 2960,  6540, {}},
    { 2960,  6520, {}},
    { 2960,  6500, {}},
    { 2960,  6480, {}},
    { 2960,  6460, {}},
    { 2960,  6440, {}},
    { 2940,  6420, {}},
    { 2940,  6400, {}},
    { 2940,  6380, {}},
    { 2940,  6360, {}},
    { 2940,  6340, {}},
    { 2940,  6320, {}},
    { 2940,  6300, {}},
    { 2940,  6260, {}},
    { 2940,  6220, {}},
    { 2960,  6180, {}},
    { 2960,  6160, {}},
    { 2980,  6140, {}},
    { 2980,  6120, {}},
    { 2980,  6100, {}},
    { 2960,  6120, {}},
    { 2940,  6140, {}},
    { 2920,  6140, {}},
    { 2900,  6160, {}},
    { 2880,  6160, {}},
    { 2860,  6180, {}},
    { 2860,  6200, {}},
    { 2840,  6220, {}},
    { 2840,  6240, {}},
    { 2820,  6260, {}},
    { 2800,  6280, {}},
    { 2780,  6280, {}},
    { 2760,  6280, {}},
    { 2740,  6280, {}},
    { 2720,  6300, {}},
    { 2720,  6320, {}},
    { 2700,  6320, {}},
    { 2680,  6320, {}},
    { 2660,  6300, {}},
    { 2660,  6280, {}},
    { 2660,  6260, {}},
    { 2660,  6240, {}},
    { 2640,  6220, {}},
    { 2620,  6200, {}},
    { 2600,  6180, {}},
    { 2580,  6180, {}},
    { 2560,  6160, {}},
    { 2540,  6160, {}},
    { 2500,  6160, {}},
    { 2450,  6080, {}},
    { 2400,  6000, {}},
};

static ZoneVertex ituz41[] = {
    { 2833,  9000, {}},
    { 2820,  8980, {}},
    { 2820,  8960, {}},
    { 2800,  8940, {}},
    { 2780,  8920, {}},
    { 2760,  8900, {}},
    { 2740,  8900, {}},
    { 2740,  8880, {}},
    { 2760,  8880, {}},
    { 2780,  8880, {}},
    { 2800,  8880, {}},
    { 2800,  8860, {}},
    { 2800,  8840, {}},
    { 2800,  8820, {}},
    { 2780,  8820, {}},
    { 2760,  8800, {}},
    { 2740,  8800, {}},
    { 2720,  8800, {}},
    { 2700,  8820, {}},
    { 2680,  8820, {}},
    { 2660,  8820, {}},
    { 2640,  8800, {}},
    { 2640,  8780, {}},
    { 2640,  8760, {}},
    { 2640,  8740, {}},
    { 2640,  8720, {}},
    { 2660,  8700, {}},
    { 2640,  8680, {}},
    { 2640,  8660, {}},
    { 2660,  8640, {}},
    { 2660,  8620, {}},
    { 2660,  8600, {}},
    { 2660,  8580, {}},
    { 2680,  8580, {}},
    { 2680,  8560, {}},
    { 2680,  8540, {}},
    { 2680,  8520, {}},
    { 2700,  8500, {}},
    { 2700,  8480, {}},
    { 2720,  8460, {}},
    { 2740,  8440, {}},
    { 2740,  8420, {}},
    { 2740,  8400, {}},
    { 2740,  8380, {}},
    { 2740,  8360, {}},
    { 2740,  8340, {}},
    { 2740,  8320, {}},
    { 2740,  8300, {}},
    { 2740,  8280, {}},
    { 2760,  8280, {}},
    { 2760,  8260, {}},
    { 2780,  8240, {}},
    { 2780,  8220, {}},
    { 2800,  8200, {}},
    { 2800,  8180, {}},
    { 2800,  8160, {}},
    { 2820,  8140, {}},
    { 2840,  8120, {}},
    { 2840,  8100, {}},
    { 2860,  8080, {}},
    { 2860,  8060, {}},
    { 2860,  8040, {}},
    { 2880,  8020, {}},
    { 2900,  8020, {}},
    { 2920,  8020, {}},
    { 2940,  8020, {}},
    { 2960,  8040, {}},
    { 2980,  8060, {}},
    { 3000,  8080, {}},
    { 3020,  8080, {}},
    { 3020,  8100, {}},
    { 3040,  8080, {}},
    { 3040,  8060, {}},
    { 3060,  8040, {}},
    { 3060,  8020, {}},
    { 3060,  8000, {}},
    { 3080,  8000, {}},
    { 3080,  7980, {}},
    { 3100,  7960, {}},
    { 3120,  7940, {}},
    { 3140,  7920, {}},
    { 3140,  7900, {}},
    { 3140,  7880, {}},
    { 3160,  7880, {}},
    { 3180,  7880, {}},
    { 3200,  7880, {}},
    { 3220,  7860, {}},
    { 3240,  7840, {}},
    { 3260,  7860, {}},
    { 3240,  7880, {}},
    { 3240,  7900, {}},
    { 3260,  7920, {}},
    { 3260,  7940, {}},
    { 3280,  7940, {}},
    { 3300,  7940, {}},
    { 3320,  7940, {}},
    { 3320,  7920, {}},
    { 3340,  7900, {}},
    { 3340,  7880, {}},
    { 3360,  7880, {}},
    { 3380,  7880, {}},
    { 3400,  7880, {}},
    { 3420,  7900, {}},
    { 3440,  7900, {}},
    { 3440,  7880, {}},
    { 3460,  7860, {}},
    { 3460,  7840, {}},
    { 3480,  7820, {}},
    { 3500,  7820, {}},
    { 3520,  7800, {}},
    { 3540,  7800, {}},
    { 3560,  7780, {}},
    { 3540,  7760, {}},
    { 3540,  7740, {}},
    { 3560,  7720, {}},
    { 3560,  7700, {}},
    { 3560,  7680, {}},
    { 3580,  7660, {}},
    { 3580,  7640, {}},
    { 3580,  7620, {}},
    { 3600,  7600, {}},
    { 3620,  7600, {}},
    { 3640,  7600, {}},
    { 3660,  7600, {}},
    { 3680,  7580, {}},
    { 3680,  7560, {}},
    { 3700,  7540, {}},
    { 3700,  7520, {}},
    { 3700,  7500, {}},
    { 3700,  7480, {}},
    { 3700,  7460, {}},
    { 3700,  7440, {}},
    { 3700,  7420, {}},
    { 3680,  7400, {}},
    { 3680,  7380, {}},
    { 3700,  7360, {}},
    { 3680,  7340, {}},
    { 3680,  7320, {}},
    { 3680,  7300, {}},
    { 3680,  7280, {}},
    { 3680,  7260, {}},
    { 3680,  7240, {}},
    { 3660,  7220, {}},
    { 3660,  7200, {}},
    { 3640,  7180, {}},
    { 3640,  7160, {}},
    { 3620,  7140, {}},
    { 3600,  7120, {}},
    { 3580,  7140, {}},
    { 3560,  7160, {}},
    { 3540,  7160, {}},
    { 3520,  7160, {}},
    { 3500,  7160, {}},
    { 3500,  7140, {}},
    { 3480,  7120, {}},
    { 3460,  7100, {}},
    { 3440,  7100, {}},
    { 3420,  7120, {}},
    { 3400,  7100, {}},
    { 3400,  7080, {}},
    { 3400,  7060, {}},
    { 3400,  7040, {}},
    { 3400,  7020, {}},
    { 3400,  7000, {}},
    { 3380,  7000, {}},
    { 3360,  7020, {}},
    { 3340,  7040, {}},
    { 3320,  7020, {}},
    { 3320,  7000, {}},
    { 3320,  6980, {}},
    { 3300,  6960, {}},
    { 3280,  6940, {}},
    { 3260,  6940, {}},
    { 3240,  6920, {}},
    { 3220,  6920, {}},
    { 3200,  6920, {}},
    { 3180,  6920, {}},
    { 3160,  6900, {}},
    { 3160,  6880, {}},
    { 3180,  6860, {}},
    { 3180,  6840, {}},
    { 3180,  6820, {}},
    { 3160,  6800, {}},
    { 3160,  6780, {}},
    { 3160,  6760, {}},
    { 3140,  6760, {}},
    { 3120,  6740, {}},
    { 3120,  6720, {}},
    { 3140,  6700, {}},
    { 3120,  6680, {}},
    { 3100,  6660, {}},
    { 3100,  6640, {}},
    { 3080,  6640, {}},
    { 3060,  6620, {}},
    { 3040,  6640, {}},
    { 3020,  6620, {}},
    { 3000,  6640, {}},
    { 2980,  6620, {}},
    { 2980,  6600, {}},
    { 2980,  6580, {}},
    { 2960,  6560, {}},
    { 2960,  6540, {}},
    { 2960,  6520, {}},
    { 2960,  6500, {}},
    { 2960,  6480, {}},
    { 2960,  6460, {}},
    { 2960,  6440, {}},
    { 2940,  6420, {}},
    { 2940,  6400, {}},
    { 2940,  6380, {}},
    { 2940,  6360, {}},
    { 2940,  6340, {}},
    { 2940,  6320, {}},
    { 2940,  6300, {}},
    { 2940,  6260, {}},
    { 2940,  6220, {}},
    { 2960,  6180, {}},
    { 2960,  6160, {}},
    { 2980,  6140, {}},
    { 2980,  6120, {}},
    { 2980,  6100, {}},
    { 2960,  6120, {}},
    { 2940,  6140, {}},
    { 2920,  6140, {}},
    { 2900,  6160, {}},
    { 2880,  6160, {}},
    { 2860,  6180, {}},
    { 2860,  6200, {}},
    { 2840,  6220, {}},
    { 2840,  6240, {}},
    { 2820,  6260, {}},
    { 2800,  6280, {}},
    { 2780,  6280, {}},
    { 2760,  6280, {}},
    { 2740,  6280, {}},
    { 2720,  6300, {}},
    { 2720,  6320, {}},
    { 2700,  6320, {}},
    { 2680,  6320, {}},
    { 2660,  6300, {}},
    { 2660,  6280, {}},
    { 2660,  6260, {}},
    { 2660,  6240, {}},
    { 2640,  6220, {}},
    { 2620,  6200, {}},
    { 2600,  6180, {}},
    { 2580,  6180, {}},
    { 2560,  6160, {}},
    { 2540,  6160, {}},
    { 2500,  6160, {}},
    { 2450,  6080, {}},
    { 2400,  6000, {}},
    { 2300,  6000, {}},
    { 2200,  6000, {}},
    { 2100,  6000, {}},
    { 2000,  6000, {}},
    { 1900,  6000, {}},
    { 1800,  6000, {}},
    { 1700,  6000, {}},
    { 1600,  6000, {}},
    { 1500,  6000, {}},
    { 1400,  6000, {}},
    { 1300,  6000, {}},
    { 1200,  6000, {}},
    { 1100,  6000, {}},
    { 1000,  6000, {}},
    {  900,  6000, {}},
    {  800,  6000, {}},
    {  700,  6000, {}},
    {  600,  6000, {}},
    {  500,  6000, {}},
    {  400,  6000, {}},
    {  300,  6000, {}},
    {  200,  6000, {}},
    {  100,  6000, {}},
    {    0,  6000, {}},
    { -100,  6024, {}},
    { -200,  6048, {}},
    { -300,  6072, {}},
    { -400,  6096, {}},
    { -500,  6120, {}},
    { -600,  6144, {}},
    { -700,  6168, {}},
    { -800,  6192, {}},
    { -900,  6216, {}},
    {-1000,  6240, {}},
    {-1000,  6339, {}},
    {-1000,  6437, {}},
    {-1000,  6536, {}},
    {-1000,  6634, {}},
    {-1000,  6733, {}},
    {-1000,  6831, {}},
    {-1000,  6930, {}},
    {-1000,  7029, {}},
    {-1000,  7127, {}},
    {-1000,  7226, {}},
    {-1000,  7324, {}},
    {-1000,  7423, {}},
    {-1000,  7521, {}},
    {-1000,  7620, {}},
    {-1000,  7719, {}},
    {-1000,  7817, {}},
    {-1000,  7916, {}},
    {-1000,  8014, {}},
    {-1000,  8113, {}},
    {-1000,  8211, {}},
    {-1000,  8310, {}},
    {-1000,  8409, {}},
    {-1000,  8507, {}},
    {-1000,  8606, {}},
    {-1000,  8704, {}},
    {-1000,  8803, {}},
    {-1000,  8901, {}},
    {-1000,  9000, {}},
    { -900,  9000, {}},
    { -800,  9000, {}},
    { -700,  9000, {}},
    { -600,  9000, {}},
    { -500,  9000, {}},
    { -400,  9000, {}},
    { -300,  9000, {}},
    { -200,  9000, {}},
    { -100,  9000, {}},
    {    0,  9000, {}},
    {  100,  9000, {}},
    {  200,  9000, {}},
    {  300,  9000, {}},
    {  400,  9000, {}},
    {  500,  9000, {}},
    {  600,  9000, {}},
    {  700,  9000, {}},
    {  800,  9000, {}},
    {  900,  9000, {}},
    { 1000,  9000, {}},
    { 1100,  9000, {}},
    { 1200,  9000, {}},
    { 1300,  9000, {}},
    { 1400,  9000, {}},
    { 1500,  9000, {}},
    { 1600,  9000, {}},
    { 1700,  9000, {}},
    { 1800,  9000, {}},
    { 1900,  9000, {}},
    { 2000,  9000, {}},
    { 2027,  9080, {}},
    { 2053,  9160, {}},
    { 2080,  9240, {}},
    { 2100,  9220, {}},
    { 2120,  9220, {}},
    { 2140,  9220, {}},
    { 2140,  9240, {}},
    { 2120,  9260, {}},
    { 2140,  9260, {}},
    { 2160,  9260, {}},
    { 2180,  9260, {}},
    { 2200,  9260, {}},
    { 2220,  9280, {}},
    { 2200,  9280, {}},
    { 2200,  9300, {}},
    { 2220,  9300, {}},
    { 2240,  9320, {}},
    { 2260,  9320, {}},
    { 2280,  9320, {}},
    { 2300,  9320, {}},
    { 2320,  9340, {}},
    { 2340,  9340, {}},
    { 2360,  9340, {}},
    { 2380,  9340, {}},
    { 2400,  9340, {}},
    { 2400,  9360, {}},
    { 2400,  9380, {}},
    { 2400,  9400, {}},
    { 2400,  9420, {}},
    { 2420,  9420, {}},
    { 2440,  9440, {}},
    { 2460,  9460, {}},
    { 2480,  9460, {}},
    { 2500,  9480, {}},
    { 2520,  9460, {}},
    { 2540,  9460, {}},
    { 2560,  9480, {}},
    { 2580,  9500, {}},
    { 2600,  9520, {}},
    { 2620,  9520, {}},
    { 2640,  9500, {}},
    { 2660,  9520, {}},
    { 2680,  9540, {}},
    { 2680,  9560, {}},
    { 2700,  9580, {}},
    { 2720,  9600, {}},
    { 2720,  9620, {}},
    { 2740,  9640, {}},
    { 2740,  9660, {}},
    { 2740,  9680, {}},
    { 2720,  9680, {}},
    { 2720,  9700, {}},
    { 2740,  9700, {}},
    { 2760,  9680, {}},
    { 2780,  9700, {}},
    { 2780,  9720, {}},
    { 2800,  9740, {}},
    { 2820,  9740, {}},
    { 2840,  9720, {}},
    { 2840,  9700, {}},
    { 2860,  9680, {}},
    { 2860,  9660, {}},
    { 2880,  9660, {}},
    { 2900,  9640, {}},
    { 2900,  9620, {}},
    { 2920,  9620, {}},
    { 2940,  9600, {}},
    { 2940,  9580, {}},
    { 2920,  9560, {}},
    { 2920,  9540, {}},
    { 2920,  9520, {}},
    { 2920,  9500, {}},
    { 2920,  9480, {}},
    { 2920,  9460, {}},
    { 2920,  9440, {}},
    { 2900,  9440, {}},
    { 2900,  9420, {}},
    { 2880,  9400, {}},
    { 2880,  9380, {}},
    { 2860,  9360, {}},
    { 2860,  9340, {}},
    { 2840,  9320, {}},
    { 2820,  9300, {}},
    { 2820,  9280, {}},
    { 2800,  9280, {}},
    { 2800,  9260, {}},
    { 2780,  9240, {}},
    { 2780,  9220, {}},
    { 2780,  9200, {}},
    { 2780,  9160, {}},
    { 2800,  9140, {}},
    { 2800,  9120, {}},
    { 2800,  9100, {}},
    { 2800,  9080, {}},
    { 2800,  9060, {}},
    { 2820,  9060, {}},
    { 2820,  9040, {}},
    { 2840,  9020, {}},
};

static ZoneVertex ituz42[] = {
    { 2833,  9000, {}},
    { 2820,  8980, {}},
    { 2820,  8960, {}},
    { 2800,  8940, {}},
    { 2780,  8920, {}},
    { 2760,  8900, {}},
    { 2740,  8900, {}},
    { 2740,  8880, {}},
    { 2760,  8880, {}},
    { 2780,  8880, {}},
    { 2800,  8880, {}},
    { 2800,  8860, {}},
    { 2800,  8840, {}},
    { 2800,  8820, {}},
    { 2780,  8820, {}},
    { 2760,  8800, {}},
    { 2740,  8800, {}},
    { 2720,  8800, {}},
    { 2700,  8820, {}},
    { 2680,  8820, {}},
    { 2660,  8820, {}},
    { 2640,  8800, {}},
    { 2640,  8780, {}},
    { 2640,  8760, {}},
    { 2640,  8740, {}},
    { 2640,  8720, {}},
    { 2660,  8700, {}},
    { 2640,  8680, {}},
    { 2640,  8660, {}},
    { 2660,  8640, {}},
    { 2660,  8620, {}},
    { 2660,  8600, {}},
    { 2660,  8580, {}},
    { 2680,  8580, {}},
    { 2680,  8560, {}},
    { 2680,  8540, {}},
    { 2680,  8520, {}},
    { 2700,  8500, {}},
    { 2700,  8480, {}},
    { 2720,  8460, {}},
    { 2740,  8440, {}},
    { 2740,  8420, {}},
    { 2740,  8400, {}},
    { 2740,  8380, {}},
    { 2740,  8360, {}},
    { 2740,  8340, {}},
    { 2740,  8320, {}},
    { 2740,  8300, {}},
    { 2740,  8280, {}},
    { 2760,  8280, {}},
    { 2760,  8260, {}},
    { 2780,  8240, {}},
    { 2780,  8220, {}},
    { 2800,  8200, {}},
    { 2800,  8180, {}},
    { 2800,  8160, {}},
    { 2820,  8140, {}},
    { 2840,  8120, {}},
    { 2840,  8100, {}},
    { 2860,  8080, {}},
    { 2860,  8060, {}},
    { 2860,  8040, {}},
    { 2880,  8020, {}},
    { 2900,  8020, {}},
    { 2920,  8020, {}},
    { 2940,  8020, {}},
    { 2960,  8040, {}},
    { 2980,  8060, {}},
    { 3000,  8080, {}},
    { 3020,  8080, {}},
    { 3020,  8100, {}},
    { 3040,  8080, {}},
    { 3040,  8060, {}},
    { 3060,  8040, {}},
    { 3060,  8020, {}},
    { 3060,  8000, {}},
    { 3080,  8000, {}},
    { 3080,  7980, {}},
    { 3100,  7960, {}},
    { 3120,  7940, {}},
    { 3140,  7920, {}},
    { 3140,  7900, {}},
    { 3140,  7880, {}},
    { 3160,  7880, {}},
    { 3180,  7880, {}},
    { 3200,  7880, {}},
    { 3220,  7860, {}},
    { 3240,  7840, {}},
    { 3260,  7860, {}},
    { 3240,  7880, {}},
    { 3240,  7900, {}},
    { 3260,  7920, {}},
    { 3260,  7940, {}},
    { 3280,  7940, {}},
    { 3300,  7940, {}},
    { 3320,  7940, {}},
    { 3320,  7920, {}},
    { 3340,  7900, {}},
    { 3340,  7880, {}},
    { 3360,  7880, {}},
    { 3380,  7880, {}},
    { 3400,  7880, {}},
    { 3420,  7900, {}},
    { 3440,  7900, {}},
    { 3440,  7880, {}},
    { 3460,  7860, {}},
    { 3460,  7840, {}},
    { 3480,  7820, {}},
    { 3500,  7820, {}},
    { 3520,  7800, {}},
    { 3540,  7800, {}},
    { 3560,  7780, {}},
    { 3540,  7760, {}},
    { 3540,  7740, {}},
    { 3560,  7720, {}},
    { 3560,  7700, {}},
    { 3560,  7680, {}},
    { 3580,  7660, {}},
    { 3580,  7640, {}},
    { 3580,  7620, {}},
    { 3600,  7600, {}},
    { 3620,  7600, {}},
    { 3640,  7600, {}},
    { 3660,  7600, {}},
    { 3680,  7580, {}},
    { 3680,  7560, {}},
    { 3700,  7540, {}},
    { 3700,  7520, {}},
    { 3700,  7500, {}},
    { 3700,  7480, {}},
    { 3700,  7460, {}},
    { 3720,  7440, {}},
    { 3720,  7460, {}},
    { 3720,  7480, {}},
    { 3720,  7500, {}},
    { 3740,  7520, {}},
    { 3760,  7500, {}},
    { 3780,  7500, {}},
    { 3800,  7500, {}},
    { 3820,  7480, {}},
    { 3840,  7460, {}},
    { 3860,  7420, {}},
    { 3860,  7400, {}},
    { 3860,  7380, {}},
    { 3880,  7380, {}},
    { 3900,  7380, {}},
    { 3920,  7360, {}},
    { 3940,  7360, {}},
    { 3940,  7380, {}},
    { 3960,  7400, {}},
    { 3980,  7380, {}},
    { 4000,  7400, {}},
    { 4020,  7420, {}},
    { 4020,  7440, {}},
    { 4020,  7460, {}},
    { 4040,  7480, {}},
    { 4040,  7500, {}},
    { 4040,  7520, {}},
    { 4060,  7540, {}},
    { 4060,  7560, {}},
    { 4040,  7560, {}},
    { 4040,  7580, {}},
    { 4040,  7600, {}},
    { 4040,  7620, {}},
    { 4040,  7640, {}},
    { 4060,  7660, {}},
    { 4080,  7680, {}},
    { 4100,  7680, {}},
    { 4100,  7700, {}},
    { 4100,  7720, {}},
    { 4100,  7740, {}},
    { 4100,  7760, {}},
    { 4100,  7780, {}},
    { 4120,  7800, {}},
    { 4140,  7820, {}},
    { 4140,  7840, {}},
    { 4140,  7860, {}},
    { 4160,  7880, {}},
    { 4160,  7900, {}},
    { 4180,  7920, {}},
    { 4180,  7940, {}},
    { 4180,  7960, {}},
    { 4200,  7980, {}},
    { 4200,  8000, {}},
    { 4200,  8020, {}},
    { 4220,  8020, {}},
    { 4240,  8020, {}},
    { 4260,  8020, {}},
    { 4280,  8020, {}},
    { 4280,  8040, {}},
    { 4280,  8060, {}},
    { 4300,  8040, {}},
    { 4320,  8060, {}},
    { 4320,  8080, {}},
    { 4340,  8080, {}},
    { 4360,  8060, {}},
    { 4380,  8060, {}},
    { 4400,  8040, {}},
    { 4420,  8040, {}},
    { 4440,  8040, {}},
    { 4460,  8040, {}},
    { 4480,  8020, {}},
    { 4480,  8000, {}},
    { 4500,  8000, {}},
    { 4500,  8020, {}},
    { 4500,  8040, {}},
    { 4520,  8060, {}},
    { 4520,  8080, {}},
    { 4520,  8100, {}},
    { 4520,  8120, {}},
    { 4520,  8140, {}},
    { 4540,  8160, {}},
    { 4540,  8180, {}},
    { 4520,  8200, {}},
    { 4520,  8220, {}},
    { 4520,  8240, {}},
    { 4540,  8260, {}},
    { 4560,  8220, {}},
    { 4580,  8240, {}},
    { 4600,  8240, {}},
    { 4620,  8260, {}},
    { 4640,  8280, {}},
    { 4660,  8280, {}},
    { 4680,  8280, {}},
    { 4700,  8300, {}},
    { 4720,  8300, {}},
    { 4720,  8320, {}},
    { 4720,  8340, {}},
    { 4700,  8360, {}},
    { 4700,  8380, {}},
    { 4700,  8400, {}},
    { 4700,  8420, {}},
    { 4700,  8440, {}},
    { 4700,  8460, {}},
    { 4700,  8480, {}},
    { 4700,  8500, {}},
    { 4700,  8520, {}},
    { 4700,  8540, {}},
    { 4720,  8560, {}},
    { 4740,  8560, {}},
    { 4800,  8560, {}},
    { 4820,  8560, {}},
    { 4840,  8580, {}},
    { 4840,  8600, {}},
    { 4840,  8620, {}},
    { 4840,  8640, {}},
    { 4860,  8660, {}},
    { 4880,  8680, {}},
    { 4900,  8680, {}},
    { 4920,  8700, {}},
    { 4920,  8720, {}},
    { 4900,  8740, {}},
    { 4920,  8760, {}},
    { 4920,  8780, {}},
    { 4900,  8780, {}},
    { 4880,  8780, {}},
    { 4880,  8800, {}},
    { 4860,  8800, {}},
    { 4860,  8820, {}},
    { 4840,  8840, {}},
    { 4840,  8860, {}},
    { 4820,  8860, {}},
    { 4800,  8880, {}},
    { 4800,  8900, {}},
    { 4800,  8920, {}},
    { 4800,  8940, {}},
    { 4800,  8960, {}},
    { 4780,  8980, {}},
    { 4780,  9000, {}},
    { 4683,  9000, {}},
    { 4586,  9000, {}},
    { 4489,  9000, {}},
    { 4392,  9000, {}},
    { 4295,  9000, {}},
    { 4198,  9000, {}},
    { 4101,  9000, {}},
    { 4004,  9000, {}},
    { 3907,  9000, {}},
    { 3810,  9000, {}},
    { 3713,  9000, {}},
    { 3616,  9000, {}},
    { 3519,  9000, {}},
    { 3422,  9000, {}},
    { 3325,  9000, {}},
    { 3228,  9000, {}},
    { 3131,  9000, {}},
    { 3034,  9000, {}},
    { 2937,  9000, {}},
    { 2840,  9000, {}},
};

static ZoneVertex ituz43[] = {
    { 2004, 11000, {}},
    { 2102, 11000, {}},
    { 2200, 11000, {}},
    { 2298, 11000, {}},
    { 2396, 11000, {}},
    { 2495, 11000, {}},
    { 2593, 11000, {}},
    { 2691, 11000, {}},
    { 2789, 11000, {}},
    { 2887, 11000, {}},
    { 2985, 11000, {}},
    { 3083, 11000, {}},
    { 3181, 11000, {}},
    { 3279, 11000, {}},
    { 3377, 11000, {}},
    { 3475, 11000, {}},
    { 3573, 11000, {}},
    { 3672, 11000, {}},
    { 3770, 11000, {}},
    { 3868, 11000, {}},
    { 3966, 11000, {}},
    { 4064, 11000, {}},
    { 4162, 11000, {}},
    { 4260, 11000, {}},
    { 4260, 10960, {}},
    { 4240, 10940, {}},
    { 4240, 10900, {}},
    { 4240, 10880, {}},
    { 4240, 10860, {}},
    { 4240, 10840, {}},
    { 4240, 10820, {}},
    { 4240, 10800, {}},
    { 4240, 10780, {}},
    { 4240, 10760, {}},
    { 4240, 10720, {}},
    { 4220, 10680, {}},
    { 4220, 10640, {}},
    { 4200, 10620, {}},
    { 4200, 10580, {}},
    { 4180, 10560, {}},
    { 4180, 10540, {}},
    { 4160, 10500, {}},
    { 4160, 10460, {}},
    { 4180, 10460, {}},
    { 4180, 10400, {}},
    { 4180, 10340, {}},
    { 4200, 10300, {}},
    { 4220, 10280, {}},
    { 4220, 10260, {}},
    { 4220, 10200, {}},
    { 4260, 10180, {}},
    { 4260, 10160, {}},
    { 4260, 10080, {}},
    { 4260, 10040, {}},
    { 4260, 10000, {}},
    { 4260,  9960, {}},
    { 4260,  9860, {}},
    { 4260,  9820, {}},
    { 4280,  9720, {}},
    { 4280,  9700, {}},
    { 4280,  9680, {}},
    { 4280,  9640, {}},
    { 4300,  9620, {}},
    { 4320,  9600, {}},
    { 4340,  9580, {}},
    { 4380,  9560, {}},
    { 4400,  9560, {}},
    { 4400,  9540, {}},
    { 4420,  9540, {}},
    { 4420,  9500, {}},
    { 4440,  9480, {}},
    { 4440,  9460, {}},
    { 4460,  9440, {}},
    { 4460,  9420, {}},
    { 4480,  9380, {}},
    { 4500,  9360, {}},
    { 4500,  9340, {}},
    { 4500,  9320, {}},
    { 4500,  9300, {}},
    { 4500,  9280, {}},
    { 4500,  9260, {}},
    { 4500,  9240, {}},
    { 4500,  9220, {}},
    { 4500,  9180, {}},
    { 4500,  9160, {}},
    { 4520,  9140, {}},
    { 4520,  9120, {}},
    { 4520,  9100, {}},
    { 4520,  9080, {}},
    { 4540,  9080, {}},
    { 4560,  9060, {}},
    { 4580,  9080, {}},
    { 4600,  9100, {}},
    { 4620,  9100, {}},
    { 4640,  9100, {}},
    { 4660,  9100, {}},
    { 4680,  9100, {}},
    { 4700,  9080, {}},
    { 4720,  9060, {}},
    { 4740,  9060, {}},
    { 4760,  9040, {}},
    { 4780,  9020, {}},
    { 4683,  9019, {}},
    { 4586,  9018, {}},
    { 4489,  9017, {}},
    { 4392,  9016, {}},
    { 4295,  9015, {}},
    { 4198,  9014, {}},
    { 4101,  9013, {}},
    { 4004,  9012, {}},
    { 3907,  9011, {}},
    { 3810,  9010, {}},
    { 3713,  9009, {}},
    { 3616,  9008, {}},
    { 3519,  9007, {}},
    { 3422,  9006, {}},
    { 3325,  9005, {}},
    { 3228,  9004, {}},
    { 3131,  9003, {}},
    { 3034,  9002, {}},
    { 2937,  9001, {}},
    { 2840,  9000, {}},
    { 2840,  9020, {}},
    { 2820,  9040, {}},
    { 2820,  9060, {}},
    { 2800,  9080, {}},
    { 2800,  9100, {}},
    { 2800,  9120, {}},
    { 2800,  9140, {}},
    { 2780,  9160, {}},
    { 2780,  9180, {}},
    { 2780,  9200, {}},
    { 2780,  9220, {}},
    { 2780,  9240, {}},
    { 2800,  9260, {}},
    { 2820,  9280, {}},
    { 2820,  9300, {}},
    { 2840,  9320, {}},
    { 2860,  9340, {}},
    { 2860,  9360, {}},
    { 2880,  9380, {}},
    { 2880,  9400, {}},
    { 2900,  9420, {}},
    { 2920,  9440, {}},
    { 2920,  9460, {}},
    { 2920,  9480, {}},
    { 2920,  9500, {}},
    { 2920,  9520, {}},
    { 2920,  9540, {}},
    { 2920,  9560, {}},
    { 2940,  9580, {}},
    { 2940,  9600, {}},
    { 2920,  9620, {}},
    { 2900,  9640, {}},
    { 2880,  9660, {}},
    { 2860,  9640, {}},
    { 2860,  9660, {}},
    { 2860,  9680, {}},
    { 2840,  9680, {}},
    { 2840,  9700, {}},
    { 2840,  9720, {}},
    { 2820,  9740, {}},
    { 2840,  9760, {}},
    { 2840,  9780, {}},
    { 2820,  9800, {}},
    { 2800,  9820, {}},
    { 2780,  9820, {}},
    { 2760,  9840, {}},
    { 2760,  9860, {}},
    { 2740,  9880, {}},
    { 2720,  9880, {}},
    { 2700,  9880, {}},
    { 2680,  9880, {}},
    { 2660,  9880, {}},
    { 2640,  9880, {}},
    { 2620,  9880, {}},
    { 2620,  9860, {}},
    { 2600,  9860, {}},
    { 2580,  9840, {}},
    { 2560,  9840, {}},
    { 2560,  9820, {}},
    { 2540,  9820, {}},
    { 2520,  9800, {}},
    { 2520,  9780, {}},
    { 2500,  9780, {}},
    { 2480,  9760, {}},
    { 2460,  9760, {}},
    { 2440,  9760, {}},
    { 2420,  9780, {}},
    { 2400,  9760, {}},
    { 2400,  9780, {}},
    { 2400,  9800, {}},
    { 2420,  9820, {}},
    { 2420,  9840, {}},
    { 2400,  9860, {}},
    { 2420,  9880, {}},
    { 2400,  9880, {}},
    { 2380,  9860, {}},
    { 2380,  9880, {}},
    { 2360,  9880, {}},
    { 2340,  9900, {}},
    { 2320,  9880, {}},
    { 2320,  9900, {}},
    { 2320,  9920, {}},
    { 2300,  9940, {}},
    { 2280,  9940, {}},
    { 2260,  9940, {}},
    { 2240,  9920, {}},
    { 2220,  9920, {}},
    { 2200,  9940, {}},
    { 2220,  9960, {}},
    { 2200,  9980, {}},
    { 2180, 10000, {}},
    { 2160, 10020, {}},
    { 2160, 10040, {}},
    { 2140, 10060, {}},
    { 2160, 10080, {}},
    { 2180, 10100, {}},
    { 2160, 10120, {}},
    { 2140, 10120, {}},
    { 2120, 10120, {}},
    { 2120, 10140, {}},
    { 2120, 10160, {}},
    { 2120, 10180, {}},
    { 2140, 10180, {}},
    { 2160, 10180, {}},
    { 2180, 10180, {}},
    { 2200, 10160, {}},
    { 2220, 10160, {}},
    { 2240, 10160, {}},
    { 2240, 10180, {}},
    { 2240, 10200, {}},
    { 2240, 10220, {}},
    { 2260, 10240, {}},
    { 2280, 10260, {}},
    { 2260, 10280, {}},
    { 2240, 10300, {}},
    { 2260, 10320, {}},
    { 2280, 10340, {}},
    { 2260, 10360, {}},
    { 2260, 10380, {}},
    { 2260, 10400, {}},
    { 2280, 10420, {}},
    { 2280, 10440, {}},
    { 2280, 10460, {}},
    { 2300, 10480, {}},
    { 2320, 10500, {}},
    { 2320, 10520, {}},
    { 2320, 10540, {}},
    { 2300, 10560, {}},
    { 2300, 10580, {}},
    { 2300, 10600, {}},
    { 2300, 10620, {}},
    { 2280, 10640, {}},
    { 2300, 10660, {}},
    { 2280, 10680, {}},
    { 2260, 10680, {}},
    { 2260, 10660, {}},
    { 2240, 10660, {}},
    { 2220, 10660, {}},
    { 2200, 10660, {}},
    { 2200, 10680, {}},
    { 2200, 10700, {}},
    { 2180, 10700, {}},
    { 2180, 10720, {}},
    { 2160, 10740, {}},
    { 2160, 10760, {}},
    { 2160, 10780, {}},
    { 2160, 10800, {}},
    { 2120, 10840, {}},
    { 2060, 10840, {}},
    { 2000, 10840, {}},
    { 2000, 10920, {}},
    { 2000, 11000, {}},
};

static ZoneVertex ituz44[] = {
    { 2200, 12174, {}},
    { 2295, 12218, {}},
    { 2389, 12262, {}},
    { 2484, 12306, {}},
    { 2578, 12351, {}},
    { 2673, 12395, {}},
    { 2767, 12439, {}},
    { 2862, 12483, {}},
    { 2956, 12527, {}},
    { 3051, 12572, {}},
    { 3145, 12616, {}},
    { 3240, 12660, {}},
    { 3320, 12750, {}},
    { 3400, 12840, {}},
    { 3480, 12930, {}},
    { 3560, 13020, {}},
    { 3640, 13110, {}},
    { 3720, 13200, {}},
    { 3820, 13292, {}},
    { 3920, 13384, {}},
    { 4020, 13476, {}},
    { 4120, 13568, {}},
    { 4220, 13660, {}},
    { 4220, 13563, {}},
    { 4220, 13467, {}},
    { 4220, 13370, {}},
    { 4220, 13273, {}},
    { 4220, 13177, {}},
    { 4220, 13080, {}},
    { 4240, 13060, {}},
    { 4260, 13060, {}},
    { 4280, 13040, {}},
    { 4280, 13060, {}},
    { 4280, 13080, {}},
    { 4280, 13100, {}},
    { 4300, 13100, {}},
    { 4320, 13120, {}},
    { 4340, 13120, {}},
    { 4360, 13120, {}},
    { 4380, 13120, {}},
    { 4400, 13120, {}},
    { 4400, 13023, {}},
    { 4400, 12926, {}},
    { 4400, 12829, {}},
    { 4400, 12732, {}},
    { 4400, 12635, {}},
    { 4400, 12538, {}},
    { 4400, 12441, {}},
    { 4400, 12344, {}},
    { 4400, 12247, {}},
    { 4400, 12150, {}},
    { 4400, 12053, {}},
    { 4400, 11956, {}},
    { 4400, 11859, {}},
    { 4400, 11762, {}},
    { 4400, 11665, {}},
    { 4400, 11568, {}},
    { 4400, 11471, {}},
    { 4400, 11374, {}},
    { 4400, 11277, {}},
    { 4400, 11180, {}},
    { 4380, 11200, {}},
    { 4360, 11180, {}},
    { 4340, 11160, {}},
    { 4340, 11140, {}},
    { 4340, 11120, {}},
    { 4340, 11100, {}},
    { 4320, 11080, {}},
    { 4300, 11060, {}},
    { 4280, 11040, {}},
    { 4260, 11020, {}},
    { 4162, 11019, {}},
    { 4063, 11018, {}},
    { 3965, 11017, {}},
    { 3867, 11017, {}},
    { 3769, 11016, {}},
    { 3670, 11015, {}},
    { 3572, 11014, {}},
    { 3474, 11013, {}},
    { 3376, 11012, {}},
    { 3277, 11011, {}},
    { 3179, 11010, {}},
    { 3081, 11010, {}},
    { 2983, 11009, {}},
    { 2884, 11008, {}},
    { 2786, 11007, {}},
    { 2688, 11006, {}},
    { 2590, 11005, {}},
    { 2491, 11004, {}},
    { 2393, 11003, {}},
    { 2295, 11003, {}},
    { 2197, 11002, {}},
    { 2098, 11001, {}},
    { 2000, 11000, {}},
    { 2000, 10920, {}},
    { 2000, 10840, {}},
    { 1900, 10840, {}},
    { 1800, 10840, {}},
    { 1725, 10935, {}},
    { 1650, 11030, {}},
    { 1575, 11125, {}},
    { 1500, 11220, {}},
    { 1570, 11316, {}},
    { 1640, 11412, {}},
    { 1710, 11508, {}},
    { 1780, 11604, {}},
    { 1850, 11700, {}},
    { 1920, 11796, {}},
    { 1990, 11892, {}},
    { 2060, 11988, {}},
    { 2130, 12084, {}},
    { 2200, 12180, {}},
};

static ZoneVertex ituz45[] = {
    { 4522, 15000, {}},
    { 4471, 14905, {}},
    { 4421, 14810, {}},
    { 4370, 14715, {}},
    { 4320, 14620, {}},
    { 4360, 14560, {}},
    { 4380, 14520, {}},
    { 4480, 14580, {}},
    { 4580, 14640, {}},
    { 4580, 14546, {}},
    { 4580, 14451, {}},
    { 4580, 14357, {}},
    { 4580, 14263, {}},
    { 4580, 14169, {}},
    { 4580, 14074, {}},
    { 4580, 13980, {}},
    { 4490, 13900, {}},
    { 4400, 13820, {}},
    { 4310, 13740, {}},
    { 4220, 13660, {}},
    { 4120, 13568, {}},
    { 4020, 13476, {}},
    { 3920, 13384, {}},
    { 3820, 13292, {}},
    { 3720, 13200, {}},
    { 3640, 13110, {}},
    { 3560, 13020, {}},
    { 3480, 12930, {}},
    { 3400, 12840, {}},
    { 3320, 12750, {}},
    { 3240, 12660, {}},
    { 3145, 12616, {}},
    { 3051, 12573, {}},
    { 2956, 12529, {}},
    { 2862, 12485, {}},
    { 2767, 12442, {}},
    { 2673, 12398, {}},
    { 2578, 12355, {}},
    { 2484, 12311, {}},
    { 2389, 12267, {}},
    { 2295, 12224, {}},
    { 2200, 12180, {}},
    { 2200, 12271, {}},
    { 2200, 12362, {}},
    { 2200, 12453, {}},
    { 2200, 12544, {}},
    { 2200, 12636, {}},
    { 2200, 12727, {}},
    { 2200, 12818, {}},
    { 2200, 12909, {}},
    { 2200, 13000, {}},
    { 2100, 13000, {}},
    { 2000, 13000, {}},
    { 2000, 13100, {}},
    { 2000, 13200, {}},
    { 2000, 13300, {}},
    { 2000, 13400, {}},
    { 2000, 13500, {}},
    { 2000, 13600, {}},
    { 2000, 13700, {}},
    { 2000, 13800, {}},
    { 2000, 13900, {}},
    { 2000, 14000, {}},
    { 2100, 14000, {}},
    { 2200, 14000, {}},
    { 2200, 14100, {}},
    { 2200, 14200, {}},
    { 2200, 14300, {}},
    { 2200, 14400, {}},
    { 2200, 14500, {}},
    { 2200, 14600, {}},
    { 2200, 14700, {}},
    { 2200, 14800, {}},
    { 2200, 14900, {}},
    { 2200, 15000, {}},
    { 2297, 15000, {}},
    { 2393, 15000, {}},
    { 2490, 15000, {}},
    { 2587, 15000, {}},
    { 2683, 15000, {}},
    { 2780, 15000, {}},
    { 2877, 15000, {}},
    { 2973, 15000, {}},
    { 3070, 15000, {}},
    { 3167, 15000, {}},
    { 3263, 15000, {}},
    { 3360, 15000, {}},
    { 3457, 15000, {}},
    { 3553, 15000, {}},
    { 3650, 15000, {}},
    { 3747, 15000, {}},
    { 3843, 15000, {}},
    { 3940, 15000, {}},
    { 4037, 15000, {}},
    { 4133, 15000, {}},
    { 4230, 15000, {}},
    { 4327, 15000, {}},
    { 4423, 15000, {}},
    { 4520, 15000, {}},
};

static ZoneVertex ituz46[] = {
    {    0,   500, {}},
    {    0,   400, {}},
    {    0,   300, {}},
    {    0,   200, {}},
    {    0,   100, {}},
    {    0,     0, {}},
    {    0,  -100, {}},
    {    0,  -200, {}},
    {    0,  -300, {}},
    {    0,  -400, {}},
    {    0,  -500, {}},
    {    0,  -600, {}},
    {    0,  -700, {}},
    {    0,  -800, {}},
    {    0,  -900, {}},
    {    0, -1000, {}},
    {    0, -1100, {}},
    {    0, -1200, {}},
    {    0, -1300, {}},
    {    0, -1400, {}},
    {    0, -1500, {}},
    {    0, -1600, {}},
    {    0, -1700, {}},
    {    0, -1800, {}},
    {    0, -1900, {}},
    {    0, -2000, {}},
    {    0, -2100, {}},
    {    0, -2200, {}},
    {    0, -2300, {}},
    {    0, -2400, {}},
    {    0, -2500, {}},
    {    0, -2600, {}},
    {    0, -2700, {}},
    {    0, -2800, {}},
    {  100, -2800, {}},
    {  200, -2800, {}},
    {  300, -2800, {}},
    {  400, -2800, {}},
    {  500, -2800, {}},
    {  600, -2800, {}},
    {  700, -2800, {}},
    {  800, -2875, {}},
    {  900, -2950, {}},
    { 1000, -3025, {}},
    { 1100, -3100, {}},
    { 1200, -3175, {}},
    { 1300, -3250, {}},
    { 1400, -3325, {}},
    { 1500, -3400, {}},
    { 1600, -3475, {}},
    { 1700, -3550, {}},
    { 1800, -3625, {}},
    { 1900, -3700, {}},
    { 2000, -3775, {}},
    { 2100, -3850, {}},
    { 2200, -3925, {}},
    { 2300, -4000, {}},
    { 2300, -3900, {}},
    { 2300, -3800, {}},
    { 2300, -3700, {}},
    { 2300, -3600, {}},
    { 2300, -3500, {}},
    { 2300, -3400, {}},
    { 2300, -3300, {}},
    { 2300, -3200, {}},
    { 2300, -3100, {}},
    { 2300, -3000, {}},
    { 2300, -2900, {}},
    { 2300, -2800, {}},
    { 2300, -2700, {}},
    { 2300, -2600, {}},
    { 2300, -2500, {}},
    { 2300, -2400, {}},
    { 2300, -2300, {}},
    { 2300, -2200, {}},
    { 2300, -2100, {}},
    { 2300, -2000, {}},
    { 2300, -1900, {}},
    { 2300, -1800, {}},
    { 2300, -1700, {}},
    { 2392, -1628, {}},
    { 2484, -1556, {}},
    { 2576, -1484, {}},
    { 2668, -1412, {}},
    { 2760, -1340, {}},
    { 2760, -1244, {}},
    { 2760, -1148, {}},
    { 2760, -1052, {}},
    { 2760,  -956, {}},
    { 2760,  -860, {}},
    { 2720,  -860, {}},
    { 2665,  -765, {}},
    { 2610,  -670, {}},
    { 2555,  -575, {}},
    { 2500,  -480, {}},
    { 2460,  -430, {}},
    { 2420,  -380, {}},
    { 2360,  -280, {}},
    { 2300,  -180, {}},
    { 2240,   -80, {}},
    { 2180,    20, {}},
    { 2120,   120, {}},
    { 2100,   120, {}},
    { 2080,   120, {}},
    { 2060,   160, {}},
    { 2020,   180, {}},
    { 2020,   200, {}},
    { 2040,   220, {}},
    { 2020,   240, {}},
    { 2000,   260, {}},
    { 2000,   280, {}},
    { 2000,   300, {}},
    { 1980,   320, {}},
    { 1960,   320, {}},
    { 1940,   320, {}},
    { 1920,   320, {}},
    { 1900,   320, {}},
    { 1913,   407, {}},
    { 1927,   493, {}},
    { 1940,   580, {}},
    { 2010,   660, {}},
    { 2080,   740, {}},
    { 2132,   832, {}},
    { 2184,   924, {}},
    { 2236,  1016, {}},
    { 2288,  1108, {}},
    { 2340,  1200, {}},
    { 2330,  1270, {}},
    { 2320,  1340, {}},
    { 2320,  1360, {}},
    { 2300,  1380, {}},
    { 2260,  1420, {}},
    { 2300,  1500, {}},
    { 2200,  1520, {}},
    { 2140,  1520, {}},
    { 2100,  1540, {}},
    { 2080,  1540, {}},
    { 2060,  1560, {}},
    { 2040,  1600, {}},
    { 2000,  1580, {}},
    { 1940,  1560, {}},
    { 1880,  1560, {}},
    { 1780,  1560, {}},
    { 1680,  1560, {}},
    { 1620,  1500, {}},
    { 1600,  1460, {}},
    { 1580,  1440, {}},
    { 1560,  1420, {}},
    { 1540,  1400, {}},
    { 1520,  1400, {}},
    { 1480,  1380, {}},
    { 1460,  1360, {}},
    { 1380,  1360, {}},
    { 1300,  1400, {}},
    { 1260,  1420, {}},
    { 1240,  1420, {}},
    { 1240,  1440, {}},
    { 1220,  1460, {}},
    { 1200,  1460, {}},
    { 1180,  1460, {}},
    { 1160,  1460, {}},
    { 1140,  1440, {}},
    { 1120,  1420, {}},
    { 1140,  1400, {}},
    { 1120,  1380, {}},
    { 1100,  1380, {}},
    { 1080,  1360, {}},
    { 1060,  1360, {}},
    { 1040,  1360, {}},
    { 1020,  1340, {}},
    { 1000,  1320, {}},
    {  980,  1320, {}},
    {  960,  1320, {}},
    {  940,  1300, {}},
    {  920,  1280, {}},
    {  900,  1280, {}},
    {  880,  1280, {}},
    {  860,  1260, {}},
    {  840,  1240, {}},
    {  820,  1220, {}},
    {  800,  1220, {}},
    {  780,  1200, {}},
    {  760,  1200, {}},
    {  740,  1200, {}},
    {  720,  1180, {}},
    {  700,  1160, {}},
    {  680,  1160, {}},
    {  660,  1140, {}},
    {  660,  1120, {}},
    {  660,  1100, {}},
    {  680,  1080, {}},
    {  700,  1060, {}},
    {  680,  1020, {}},
    {  700,  1020, {}},
    {  680,   980, {}},
    {  660,   980, {}},
    {  660,   960, {}},
    {  640,   940, {}},
    {  620,   920, {}},
    {  600,   900, {}},
    {  580,   880, {}},
    {  560,   900, {}},
    {  540,   880, {}},
    {  520,   880, {}},
    {  500,   860, {}},
    {  480,   860, {}},
    {  400,   800, {}},
    {  400,   700, {}},
    {  400,   600, {}},
    {  400,   500, {}},
    {  300,   500, {}},
    {  200,   500, {}},
    {  100,   500, {}},
    {    0,   500, {}},
};

static ZoneVertex ituz47[] = {
    {    0,   500, {}},
    {    0,   600, {}},
    {    0,   700, {}},
    {    0,   800, {}},
    {  100,   800, {}},
    {  100,   870, {}},
    {  100,   940, {}},
    {  100,   960, {}},
    {  100,   980, {}},
    {  100,  1060, {}},
    {  100,  1140, {}},
    {  160,  1140, {}},
    {  220,  1140, {}},
    {  240,  1160, {}},
    {  220,  1200, {}},
    {  220,  1220, {}},
    {  220,  1240, {}},
    {  220,  1260, {}},
    {  220,  1280, {}},
    {  220,  1300, {}},
    {  220,  1320, {}},
    {  220,  1420, {}},
    {  220,  1440, {}},
    {  220,  1460, {}},
    {  200,  1480, {}},
    {  200,  1500, {}},
    {  200,  1520, {}},
    {  200,  1540, {}},
    {  200,  1580, {}},
    {  180,  1580, {}},
    {  180,  1600, {}},
    {  200,  1600, {}},
    {  220,  1620, {}},
    {  280,  1660, {}},
    {  300,  1660, {}},
    {  320,  1660, {}},
    {  340,  1660, {}},
    {  360,  1680, {}},
    {  360,  1700, {}},
    {  360,  1720, {}},
    {  380,  1740, {}},
    {  360,  1760, {}},
    {  360,  1780, {}},
    {  360,  1800, {}},
    {  340,  1820, {}},
    {  360,  1840, {}},
    {  340,  1860, {}},
    {  380,  1860, {}},
    {  420,  1860, {}},
    {  440,  1880, {}},
    {  460,  1900, {}},
    {  500,  1920, {}},
    {  520,  1940, {}},
    {  520,  1960, {}},
    {  500,  1980, {}},
    {  500,  2000, {}},
    {  480,  2020, {}},
    {  460,  2040, {}},
    {  440,  2080, {}},
    {  440,  2100, {}},
    {  420,  2120, {}},
    {  420,  2140, {}},
    {  440,  2160, {}},
    {  420,  2180, {}},
    {  420,  2200, {}},
    {  420,  2220, {}},
    {  420,  2240, {}},
    {  440,  2260, {}},
    {  460,  2280, {}},
    {  480,  2300, {}},
    {  460,  2320, {}},
    {  460,  2340, {}},
    {  480,  2360, {}},
    {  480,  2380, {}},
    {  480,  2400, {}},
    {  500,  2420, {}},
    {  500,  2440, {}},
    {  500,  2460, {}},
    {  500,  2480, {}},
    {  500,  2500, {}},
    {  500,  2520, {}},
    {  520,  2540, {}},
    {  540,  2560, {}},
    {  520,  2580, {}},
    {  520,  2600, {}},
    {  520,  2620, {}},
    {  500,  2640, {}},
    {  520,  2680, {}},
    {  520,  2700, {}},
    {  520,  2720, {}},
    {  500,  2740, {}},
    {  480,  2760, {}},
    {  460,  2780, {}},
    {  460,  2800, {}},
    {  440,  2820, {}},
    {  420,  2840, {}},
    {  440,  2860, {}},
    {  460,  2880, {}},
    {  440,  2900, {}},
    {  440,  2920, {}},
    {  440,  2940, {}},
    {  460,  2940, {}},
    {  460,  2960, {}},
    {  460,  2980, {}},
    {  440,  2980, {}},
    {  420,  3000, {}},
    {  400,  3020, {}},
    {  380,  3040, {}},
    {  360,  3060, {}},
    {  360,  3080, {}},
    {  380,  3100, {}},
    {  476,  3100, {}},
    {  572,  3100, {}},
    {  667,  3100, {}},
    {  763,  3100, {}},
    {  859,  3100, {}},
    {  955,  3100, {}},
    { 1051,  3100, {}},
    { 1146,  3100, {}},
    { 1242,  3100, {}},
    { 1338,  3100, {}},
    { 1434,  3100, {}},
    { 1529,  3100, {}},
    { 1625,  3100, {}},
    { 1721,  3100, {}},
    { 1817,  3100, {}},
    { 1913,  3100, {}},
    { 2008,  3100, {}},
    { 2104,  3100, {}},
    { 2200,  3100, {}},
    { 2200,  3060, {}},
    { 2200,  2973, {}},
    { 2200,  2887, {}},
    { 2200,  2800, {}},
    { 2200,  2700, {}},
    { 2200,  2600, {}},
    { 2200,  2500, {}},
    { 2100,  2500, {}},
    { 2000,  2500, {}},
    { 2000,  2400, {}},
    { 1960,  2400, {}},
    { 2010,  2300, {}},
    { 2060,  2200, {}},
    { 2110,  2100, {}},
    { 2160,  2000, {}},
    { 2205,  1900, {}},
    { 2250,  1800, {}},
    { 2295,  1700, {}},
    { 2340,  1600, {}},
    { 2300,  1500, {}},
    { 2200,  1520, {}},
    { 2140,  1520, {}},
    { 2100,  1540, {}},
    { 2080,  1540, {}},
    { 2060,  1560, {}},
    { 2040,  1600, {}},
    { 2000,  1580, {}},
    { 1940,  1560, {}},
    { 1880,  1560, {}},
    { 1780,  1560, {}},
    { 1680,  1560, {}},
    { 1620,  1500, {}},
    { 1600,  1460, {}},
    { 1580,  1440, {}},
    { 1560,  1420, {}},
    { 1540,  1400, {}},
    { 1520,  1400, {}},
    { 1480,  1380, {}},
    { 1460,  1360, {}},
    { 1380,  1360, {}},
    { 1300,  1400, {}},
    { 1260,  1420, {}},
    { 1240,  1420, {}},
    { 1240,  1440, {}},
    { 1220,  1460, {}},
    { 1200,  1460, {}},
    { 1180,  1460, {}},
    { 1160,  1460, {}},
    { 1140,  1440, {}},
    { 1120,  1420, {}},
    { 1140,  1400, {}},
    { 1120,  1380, {}},
    { 1100,  1380, {}},
    { 1080,  1360, {}},
    { 1060,  1360, {}},
    { 1040,  1360, {}},
    { 1020,  1340, {}},
    { 1000,  1320, {}},
    {  980,  1320, {}},
    {  960,  1320, {}},
    {  940,  1300, {}},
    {  920,  1280, {}},
    {  900,  1280, {}},
    {  880,  1280, {}},
    {  860,  1260, {}},
    {  840,  1240, {}},
    {  820,  1220, {}},
    {  800,  1220, {}},
    {  780,  1200, {}},
    {  760,  1200, {}},
    {  740,  1200, {}},
    {  720,  1180, {}},
    {  700,  1160, {}},
    {  680,  1160, {}},
    {  660,  1140, {}},
    {  660,  1120, {}},
    {  660,  1100, {}},
    {  680,  1080, {}},
    {  700,  1060, {}},
    {  680,  1020, {}},
    {  700,  1020, {}},
    {  680,   980, {}},
    {  660,   980, {}},
    {  660,   960, {}},
    {  640,   940, {}},
    {  620,   920, {}},
    {  600,   900, {}},
    {  580,   880, {}},
    {  560,   900, {}},
    {  540,   880, {}},
    {  520,   880, {}},
    {  500,   860, {}},
    {  480,   860, {}},
    {  400,   800, {}},
    {  400,   700, {}},
    {  400,   600, {}},
    {  400,   500, {}},
    {  300,   500, {}},
    {  200,   500, {}},
    {  100,   500, {}},
    {    0,   500, {}},
};

static ZoneVertex ituz48[] = {
    { 2384,  3652, {}},
    { 2320,  3560, {}},
    { 2280,  3520, {}},
    { 2280,  3500, {}},
    { 2260,  3480, {}},
    { 2220,  3460, {}},
    { 2220,  3420, {}},
    { 2180,  3400, {}},
    { 2180,  3360, {}},
    { 2200,  3320, {}},
    { 2200,  3247, {}},
    { 2200,  3173, {}},
    { 2200,  3100, {}},
    { 2104,  3100, {}},
    { 2008,  3100, {}},
    { 1913,  3100, {}},
    { 1817,  3100, {}},
    { 1721,  3100, {}},
    { 1625,  3100, {}},
    { 1529,  3100, {}},
    { 1434,  3100, {}},
    { 1338,  3100, {}},
    { 1242,  3100, {}},
    { 1146,  3100, {}},
    { 1051,  3100, {}},
    {  955,  3100, {}},
    {  859,  3100, {}},
    {  763,  3100, {}},
    {  667,  3100, {}},
    {  572,  3100, {}},
    {  476,  3100, {}},
    {  380,  3100, {}},
    {  360,  3100, {}},
    {  340,  3080, {}},
    {  320,  3080, {}},
    {  300,  3080, {}},
    {  280,  3080, {}},
    {  260,  3080, {}},
    {  240,  3080, {}},
    {  240,  3100, {}},
    {  220,  3120, {}},
    {  200,  3120, {}},
    {  180,  3100, {}},
    {  160,  3080, {}},
    {  120,  3040, {}},
    {  100,  3020, {}},
    {   80,  3000, {}},
    {   60,  3000, {}},
    {   40,  2980, {}},
    {   20,  2980, {}},
    {    0,  2980, {}},
    {  -40,  2960, {}},
    {  -60,  2960, {}},
    {  -80,  2960, {}},
    { -100,  2960, {}},
    { -120,  2960, {}},
    { -140,  2980, {}},
    { -140,  3000, {}},
    { -120,  3020, {}},
    { -100,  3040, {}},
    { -100,  3060, {}},
    { -100,  3145, {}},
    { -100,  3230, {}},
    { -100,  3315, {}},
    { -100,  3400, {}},
    { -150,  3490, {}},
    { -200,  3580, {}},
    { -250,  3670, {}},
    { -300,  3760, {}},
    { -340,  3780, {}},
    { -340,  3760, {}},
    { -360,  3780, {}},
    { -440,  3860, {}},
    { -460,  3920, {}},
    { -480,  3960, {}},
    { -436,  4055, {}},
    { -393,  4149, {}},
    { -349,  4244, {}},
    { -305,  4338, {}},
    { -262,  4433, {}},
    { -218,  4527, {}},
    { -175,  4622, {}},
    { -131,  4716, {}},
    {  -87,  4811, {}},
    {  -44,  4905, {}},
    {    0,  5000, {}},
    {    0,  5100, {}},
    {    0,  5200, {}},
    {    0,  5300, {}},
    {    0,  5400, {}},
    {    0,  5500, {}},
    {    0,  5600, {}},
    {    0,  5700, {}},
    {    0,  5800, {}},
    {    0,  5900, {}},
    {    0,  6000, {}},
    {  100,  6000, {}},
    {  200,  6000, {}},
    {  300,  6000, {}},
    {  400,  6000, {}},
    {  500,  6000, {}},
    {  600,  6000, {}},
    {  700,  6000, {}},
    {  800,  6000, {}},
    {  900,  6000, {}},
    { 1000,  6000, {}},
    { 1100,  6000, {}},
    { 1200,  6000, {}},
    { 1300,  6000, {}},
    { 1400,  6000, {}},
    { 1500,  6000, {}},
    { 1478,  5903, {}},
    { 1455,  5805, {}},
    { 1433,  5708, {}},
    { 1410,  5610, {}},
    { 1388,  5513, {}},
    { 1365,  5415, {}},
    { 1343,  5318, {}},
    { 1320,  5220, {}},
    { 1298,  5123, {}},
    { 1275,  5025, {}},
    { 1253,  4928, {}},
    { 1230,  4830, {}},
    { 1208,  4733, {}},
    { 1185,  4635, {}},
    { 1163,  4538, {}},
    { 1140,  4440, {}},
    { 1240,  4350, {}},
    { 1340,  4260, {}},
    { 1435,  4205, {}},
    { 1529,  4151, {}},
    { 1624,  4096, {}},
    { 1718,  4042, {}},
    { 1813,  3987, {}},
    { 1907,  3933, {}},
    { 2002,  3878, {}},
    { 2096,  3824, {}},
    { 2191,  3769, {}},
    { 2285,  3715, {}},
    { 2380,  3660, {}},
};

static ZoneVertex ituz49[] = {
    { 2821,  9735, {}},
    { 2840,  9760, {}},
    { 2840,  9780, {}},
    { 2820,  9800, {}},
    { 2800,  9820, {}},
    { 2780,  9820, {}},
    { 2760,  9840, {}},
    { 2760,  9860, {}},
    { 2740,  9880, {}},
    { 2720,  9880, {}},
    { 2700,  9880, {}},
    { 2680,  9880, {}},
    { 2660,  9880, {}},
    { 2640,  9880, {}},
    { 2620,  9880, {}},
    { 2620,  9860, {}},
    { 2600,  9860, {}},
    { 2580,  9840, {}},
    { 2560,  9840, {}},
    { 2560,  9820, {}},
    { 2540,  9820, {}},
    { 2520,  9800, {}},
    { 2520,  9780, {}},
    { 2500,  9780, {}},
    { 2480,  9760, {}},
    { 2460,  9760, {}},
    { 2440,  9760, {}},
    { 2420,  9780, {}},
    { 2400,  9760, {}},
    { 2400,  9780, {}},
    { 2400,  9800, {}},
    { 2420,  9820, {}},
    { 2420,  9840, {}},
    { 2400,  9860, {}},
    { 2420,  9880, {}},
    { 2400,  9880, {}},
    { 2380,  9860, {}},
    { 2380,  9880, {}},
    { 2360,  9880, {}},
    { 2340,  9900, {}},
    { 2320,  9880, {}},
    { 2320,  9900, {}},
    { 2320,  9920, {}},
    { 2300,  9940, {}},
    { 2280,  9940, {}},
    { 2260,  9940, {}},
    { 2240,  9920, {}},
    { 2220,  9920, {}},
    { 2200,  9940, {}},
    { 2220,  9960, {}},
    { 2200,  9980, {}},
    { 2180, 10000, {}},
    { 2160, 10020, {}},
    { 2160, 10040, {}},
    { 2140, 10060, {}},
    { 2160, 10080, {}},
    { 2180, 10100, {}},
    { 2160, 10120, {}},
    { 2140, 10120, {}},
    { 2120, 10120, {}},
    { 2120, 10140, {}},
    { 2120, 10160, {}},
    { 2120, 10180, {}},
    { 2140, 10180, {}},
    { 2160, 10180, {}},
    { 2180, 10180, {}},
    { 2200, 10160, {}},
    { 2220, 10160, {}},
    { 2240, 10160, {}},
    { 2240, 10180, {}},
    { 2240, 10200, {}},
    { 2240, 10220, {}},
    { 2260, 10240, {}},
    { 2280, 10260, {}},
    { 2260, 10280, {}},
    { 2240, 10300, {}},
    { 2260, 10320, {}},
    { 2280, 10340, {}},
    { 2260, 10360, {}},
    { 2260, 10380, {}},
    { 2260, 10400, {}},
    { 2280, 10420, {}},
    { 2280, 10440, {}},
    { 2280, 10460, {}},
    { 2300, 10480, {}},
    { 2320, 10500, {}},
    { 2320, 10520, {}},
    { 2320, 10540, {}},
    { 2300, 10560, {}},
    { 2300, 10580, {}},
    { 2300, 10600, {}},
    { 2300, 10620, {}},
    { 2280, 10640, {}},
    { 2300, 10660, {}},
    { 2280, 10680, {}},
    { 2260, 10680, {}},
    { 2260, 10660, {}},
    { 2240, 10660, {}},
    { 2220, 10660, {}},
    { 2200, 10660, {}},
    { 2200, 10680, {}},
    { 2200, 10700, {}},
    { 2180, 10700, {}},
    { 2180, 10720, {}},
    { 2160, 10740, {}},
    { 2160, 10760, {}},
    { 2160, 10780, {}},
    { 2160, 10800, {}},
    { 2120, 10840, {}},
    { 2040, 10840, {}},
    { 1960, 10840, {}},
    { 1880, 10840, {}},
    { 1800, 10840, {}},
    { 1725, 10935, {}},
    { 1650, 11030, {}},
    { 1575, 11125, {}},
    { 1500, 11220, {}},
    { 1409, 11180, {}},
    { 1318, 11140, {}},
    { 1227, 11100, {}},
    { 1136, 11060, {}},
    { 1044, 11020, {}},
    {  953, 10980, {}},
    {  862, 10940, {}},
    {  771, 10900, {}},
    {  680, 10860, {}},
    {  671, 10769, {}},
    {  663, 10677, {}},
    {  654, 10586, {}},
    {  646, 10494, {}},
    {  637, 10403, {}},
    {  629, 10311, {}},
    {  620, 10220, {}},
    {  600, 10200, {}},
    {  580, 10180, {}},
    {  600, 10160, {}},
    {  580, 10140, {}},
    {  560, 10120, {}},
    {  580, 10100, {}},
    {  600, 10120, {}},
    {  620, 10120, {}},
    {  620, 10100, {}},
    {  640, 10080, {}},
    {  640, 10060, {}},
    {  660, 10040, {}},
    {  680, 10020, {}},
    {  660, 10020, {}},
    {  660,  9980, {}},
    {  640,  9960, {}},
    {  640,  9864, {}},
    {  640,  9768, {}},
    {  640,  9672, {}},
    {  640,  9576, {}},
    {  640,  9480, {}},
    {  640,  9384, {}},
    {  640,  9288, {}},
    {  640,  9192, {}},
    {  640,  9096, {}},
    {  640,  9000, {}},
    {  737,  9000, {}},
    {  834,  9000, {}},
    {  931,  9000, {}},
    { 1029,  9000, {}},
    { 1126,  9000, {}},
    { 1223,  9000, {}},
    { 1320,  9000, {}},
    { 1417,  9000, {}},
    { 1514,  9000, {}},
    { 1611,  9000, {}},
    { 1709,  9000, {}},
    { 1806,  9000, {}},
    { 1903,  9000, {}},
    { 2000,  9000, {}},
    { 2027,  9080, {}},
    { 2053,  9160, {}},
    { 2080,  9240, {}},
    { 2100,  9220, {}},
    { 2120,  9220, {}},
    { 2140,  9220, {}},
    { 2140,  9240, {}},
    { 2120,  9260, {}},
    { 2140,  9260, {}},
    { 2160,  9260, {}},
    { 2180,  9260, {}},
    { 2200,  9260, {}},
    { 2220,  9280, {}},
    { 2200,  9280, {}},
    { 2200,  9300, {}},
    { 2220,  9300, {}},
    { 2240,  9320, {}},
    { 2260,  9320, {}},
    { 2280,  9320, {}},
    { 2300,  9320, {}},
    { 2320,  9340, {}},
    { 2340,  9340, {}},
    { 2360,  9340, {}},
    { 2380,  9340, {}},
    { 2400,  9340, {}},
    { 2400,  9360, {}},
    { 2400,  9380, {}},
    { 2400,  9400, {}},
    { 2400,  9420, {}},
    { 2420,  9420, {}},
    { 2440,  9440, {}},
    { 2460,  9460, {}},
    { 2480,  9460, {}},
    { 2500,  9480, {}},
    { 2520,  9460, {}},
    { 2540,  9460, {}},
    { 2560,  9480, {}},
    { 2580,  9500, {}},
    { 2600,  9520, {}},
    { 2620,  9520, {}},
    { 2640,  9500, {}},
    { 2660,  9520, {}},
    { 2680,  9540, {}},
    { 2680,  9560, {}},
    { 2700,  9580, {}},
    { 2720,  9600, {}},
    { 2720,  9620, {}},
    { 2740,  9640, {}},
    { 2740,  9660, {}},
    { 2740,  9680, {}},
    { 2720,  9680, {}},
    { 2720,  9700, {}},
    { 2740,  9700, {}},
    { 2760,  9680, {}},
    { 2780,  9700, {}},
    { 2780,  9720, {}},
    { 2800,  9740, {}},
    { 2820,  9740, {}},
};

static ZoneVertex ituz50[] = {
    { 1497, 11219, {}},
    { 1568, 11315, {}},
    { 1638, 11412, {}},
    { 1708, 11508, {}},
    { 1778, 11604, {}},
    { 1849, 11700, {}},
    { 1919, 11796, {}},
    { 1989, 11892, {}},
    { 2059, 11988, {}},
    { 2130, 12084, {}},
    { 2200, 12180, {}},
    { 2200, 12271, {}},
    { 2200, 12362, {}},
    { 2200, 12453, {}},
    { 2200, 12544, {}},
    { 2200, 12636, {}},
    { 2200, 12727, {}},
    { 2200, 12818, {}},
    { 2200, 12909, {}},
    { 2200, 13000, {}},
    { 2103, 13000, {}},
    { 2006, 13000, {}},
    { 1909, 13000, {}},
    { 1812, 13000, {}},
    { 1715, 13000, {}},
    { 1618, 13000, {}},
    { 1521, 13000, {}},
    { 1424, 13000, {}},
    { 1327, 13000, {}},
    { 1230, 13000, {}},
    { 1133, 13000, {}},
    { 1036, 13000, {}},
    {  939, 13000, {}},
    {  842, 13000, {}},
    {  745, 13000, {}},
    {  648, 13000, {}},
    {  551, 13000, {}},
    {  454, 13000, {}},
    {  357, 13000, {}},
    {  260, 13000, {}},
    {  335, 12925, {}},
    {  410, 12850, {}},
    {  485, 12775, {}},
    {  560, 12700, {}},
    {  543, 12603, {}},
    {  525, 12505, {}},
    {  508, 12408, {}},
    {  490, 12310, {}},
    {  473, 12213, {}},
    {  455, 12115, {}},
    {  438, 12018, {}},
    {  420, 11920, {}},
    {  480, 11900, {}},
    {  540, 11940, {}},
    {  570, 11880, {}},
    {  600, 11820, {}},
    {  660, 11800, {}},
    {  740, 11740, {}},
    {  760, 11680, {}},
    {  670, 11580, {}},
    {  580, 11480, {}},
    {  594, 11391, {}},
    {  609, 11303, {}},
    {  623, 11214, {}},
    {  637, 11126, {}},
    {  651, 11037, {}},
    {  666, 10949, {}},
    {  680, 10860, {}},
    {  771, 10900, {}},
    {  862, 10940, {}},
    {  953, 10980, {}},
    { 1044, 11020, {}},
    { 1136, 11060, {}},
    { 1227, 11100, {}},
    { 1318, 11140, {}},
    { 1409, 11180, {}},
    { 1500, 11220, {}},
};

static ZoneVertex ituz51[] = {
    {  250, 13000, {}},
    {  225, 13100, {}},
    {  200, 13200, {}},
    {  175, 13300, {}},
    {  150, 13400, {}},
    {  125, 13500, {}},
    {  100, 13600, {}},
    {   75, 13700, {}},
    {   50, 13800, {}},
    {   25, 13900, {}},
    {    0, 14000, {}},
    {    0, 14100, {}},
    {    0, 14200, {}},
    {    0, 14300, {}},
    {    0, 14400, {}},
    {    0, 14500, {}},
    {    0, 14600, {}},
    {    0, 14700, {}},
    {    0, 14800, {}},
    {    0, 14900, {}},
    {    0, 15000, {}},
    {    0, 15100, {}},
    {    0, 15200, {}},
    {    0, 15300, {}},
    {    0, 15400, {}},
    {    0, 15500, {}},
    {    0, 15600, {}},
    {    0, 15700, {}},
    {    0, 15800, {}},
    {    0, 15900, {}},
    {    0, 16000, {}},
    {    0, 16100, {}},
    {    0, 16200, {}},
    { -100, 16292, {}},
    { -200, 16383, {}},
    { -300, 16475, {}},
    { -400, 16567, {}},
    { -500, 16658, {}},
    { -600, 16750, {}},
    { -700, 16842, {}},
    { -800, 16933, {}},
    { -900, 17025, {}},
    {-1000, 17117, {}},
    {-1100, 17208, {}},
    {-1200, 17300, {}},
    {-1201, 17204, {}},
    {-1203, 17108, {}},
    {-1204, 17012, {}},
    {-1205, 16916, {}},
    {-1207, 16820, {}},
    {-1208, 16724, {}},
    {-1209, 16628, {}},
    {-1211, 16532, {}},
    {-1212, 16436, {}},
    {-1213, 16340, {}},
    {-1215, 16244, {}},
    {-1216, 16148, {}},
    {-1217, 16052, {}},
    {-1219, 15956, {}},
    {-1220, 15860, {}},
    {-1219, 15761, {}},
    {-1217, 15663, {}},
    {-1216, 15564, {}},
    {-1214, 15466, {}},
    {-1213, 15367, {}},
    {-1211, 15269, {}},
    {-1210, 15170, {}},
    {-1209, 15071, {}},
    {-1207, 14973, {}},
    {-1206, 14874, {}},
    {-1204, 14776, {}},
    {-1203, 14677, {}},
    {-1201, 14579, {}},
    {-1200, 14480, {}},
    {-1107, 14467, {}},
    {-1013, 14453, {}},
    { -920, 14440, {}},
    { -930, 14350, {}},
    { -940, 14260, {}},
    { -920, 14220, {}},
    { -926, 14126, {}},
    { -932, 14032, {}},
    { -938, 13938, {}},
    { -945, 13845, {}},
    { -951, 13751, {}},
    { -957, 13657, {}},
    { -963, 13563, {}},
    { -969, 13469, {}},
    { -975, 13375, {}},
    { -982, 13282, {}},
    { -988, 13188, {}},
    { -994, 13094, {}},
    {-1000, 13000, {}},
    { -903, 13000, {}},
    { -806, 13000, {}},
    { -709, 13000, {}},
    { -612, 13000, {}},
    { -515, 13000, {}},
    { -418, 13000, {}},
    { -322, 13000, {}},
    { -225, 13000, {}},
    { -128, 13000, {}},
    {  -31, 13000, {}},
    {   66, 13000, {}},
    {  163, 13000, {}},
    {  260, 13000, {}},
};

static ZoneVertex ituz52[] = {
    {    0,   500, {}},
    {    0,   600, {}},
    {    0,   700, {}},
    {    0,   800, {}},
    {  100,   800, {}},
    {  100,   870, {}},
    {  100,   940, {}},
    {  100,   960, {}},
    {  100,   980, {}},
    {  100,  1060, {}},
    {  100,  1140, {}},
    {  160,  1140, {}},
    {  220,  1140, {}},
    {  240,  1160, {}},
    {  220,  1200, {}},
    {  220,  1220, {}},
    {  220,  1240, {}},
    {  220,  1260, {}},
    {  220,  1280, {}},
    {  220,  1300, {}},
    {  220,  1320, {}},
    {  220,  1420, {}},
    {  220,  1440, {}},
    {  220,  1460, {}},
    {  200,  1480, {}},
    {  200,  1500, {}},
    {  200,  1520, {}},
    {  200,  1540, {}},
    {  200,  1580, {}},
    {  180,  1580, {}},
    {  180,  1600, {}},
    {  200,  1600, {}},
    {  220,  1620, {}},
    {  280,  1660, {}},
    {  300,  1660, {}},
    {  320,  1660, {}},
    {  340,  1660, {}},
    {  360,  1680, {}},
    {  360,  1700, {}},
    {  360,  1720, {}},
    {  380,  1740, {}},
    {  360,  1760, {}},
    {  360,  1780, {}},
    {  360,  1800, {}},
    {  340,  1820, {}},
    {  360,  1840, {}},
    {  340,  1860, {}},
    {  380,  1860, {}},
    {  420,  1860, {}},
    {  440,  1880, {}},
    {  460,  1900, {}},
    {  500,  1920, {}},
    {  520,  1940, {}},
    {  520,  1960, {}},
    {  500,  1980, {}},
    {  500,  2000, {}},
    {  480,  2020, {}},
    {  460,  2040, {}},
    {  440,  2080, {}},
    {  440,  2100, {}},
    {  420,  2120, {}},
    {  420,  2140, {}},
    {  440,  2160, {}},
    {  420,  2180, {}},
    {  420,  2200, {}},
    {  420,  2220, {}},
    {  420,  2240, {}},
    {  440,  2260, {}},
    {  460,  2280, {}},
    {  480,  2300, {}},
    {  460,  2320, {}},
    {  460,  2340, {}},
    {  480,  2360, {}},
    {  480,  2380, {}},
    {  480,  2400, {}},
    {  500,  2420, {}},
    {  500,  2440, {}},
    {  500,  2460, {}},
    {  500,  2480, {}},
    {  500,  2500, {}},
    {  500,  2520, {}},
    {  520,  2540, {}},
    {  540,  2560, {}},
    {  520,  2580, {}},
    {  520,  2600, {}},
    {  520,  2620, {}},
    {  500,  2640, {}},
    {  520,  2680, {}},
    {  520,  2700, {}},
    {  520,  2720, {}},
    {  500,  2740, {}},
    {  480,  2760, {}},
    {  460,  2780, {}},
    {  460,  2800, {}},
    {  440,  2820, {}},
    {  420,  2840, {}},
    {  440,  2860, {}},
    {  460,  2880, {}},
    {  440,  2900, {}},
    {  440,  2920, {}},
    {  440,  2940, {}},
    {  460,  2940, {}},
    {  460,  2960, {}},
    {  460,  2980, {}},
    {  440,  2980, {}},
    {  420,  3000, {}},
    {  400,  3020, {}},
    {  380,  3040, {}},
    {  360,  3060, {}},
    {  360,  3080, {}},
    {  340,  3080, {}},
    {  320,  3080, {}},
    {  300,  3080, {}},
    {  280,  3080, {}},
    {  260,  3080, {}},
    {  240,  3080, {}},
    {  240,  3100, {}},
    {  220,  3120, {}},
    {  200,  3120, {}},
    {  180,  3100, {}},
    {  160,  3080, {}},
    {  120,  3040, {}},
    {  100,  3020, {}},
    {   80,  3000, {}},
    {   60,  3000, {}},
    {   40,  2980, {}},
    {   20,  2980, {}},
    {    0,  2980, {}},
    {  -40,  2960, {}},
    {  -60,  2960, {}},
    {  -80,  2960, {}},
    { -100,  2960, {}},
    { -120,  2960, {}},
    { -140,  2980, {}},
    { -140,  3000, {}},
    { -120,  3020, {}},
    { -100,  3040, {}},
    { -120,  3060, {}},
    { -140,  3080, {}},
    { -160,  3080, {}},
    { -180,  3080, {}},
    { -200,  3080, {}},
    { -220,  3080, {}},
    { -240,  3060, {}},
    { -260,  3040, {}},
    { -280,  3040, {}},
    { -300,  3060, {}},
    { -300,  3080, {}},
    { -320,  3080, {}},
    { -340,  3060, {}},
    { -360,  3040, {}},
    { -380,  3040, {}},
    { -400,  3020, {}},
    { -420,  3000, {}},
    { -440,  2980, {}},
    { -440,  2940, {}},
    { -480,  2940, {}},
    { -500,  2940, {}},
    { -540,  2960, {}},
    { -580,  2960, {}},
    { -600,  2940, {}},
    { -640,  2960, {}},
    { -660,  2980, {}},
    { -680,  3000, {}},
    { -720,  3040, {}},
    { -760,  3040, {}},
    { -780,  3060, {}},
    { -820,  3080, {}},
    { -830,  2980, {}},
    { -840,  2880, {}},
    { -860,  2900, {}},
    { -880,  2880, {}},
    { -900,  2860, {}},
    { -920,  2840, {}},
    { -940,  2860, {}},
    { -980,  2860, {}},
    {-1020,  2860, {}},
    {-1060,  2860, {}},
    {-1100,  2840, {}},
    {-1140,  2840, {}},
    {-1180,  2840, {}},
    {-1200,  2880, {}},
    {-1220,  2900, {}},
    {-1240,  2920, {}},
    {-1240,  2940, {}},
    {-1220,  2960, {}},
    {-1220,  2980, {}},
    {-1280,  2980, {}},
    {-1340,  2980, {}},
    {-1320,  2960, {}},
    {-1340,  2920, {}},
    {-1300,  2880, {}},
    {-1300,  2860, {}},
    {-1280,  2840, {}},
    {-1240,  2840, {}},
    {-1240,  2800, {}},
    {-1220,  2760, {}},
    {-1200,  2740, {}},
    {-1180,  2720, {}},
    {-1160,  2720, {}},
    {-1180,  2700, {}},
    {-1200,  2640, {}},
    {-1180,  2600, {}},
    {-1160,  2540, {}},
    {-1140,  2540, {}},
    {-1120,  2540, {}},
    {-1120,  2480, {}},
    {-1140,  2440, {}},
    {-1100,  2440, {}},
    {-1100,  2420, {}},
    {-1120,  2400, {}},
    {-1140,  2400, {}},
    {-1160,  2400, {}},
    {-1220,  2400, {}},
    {-1260,  2400, {}},
    {-1300,  2400, {}},
    {-1300,  2300, {}},
    {-1300,  2200, {}},
    {-1380,  2200, {}},
    {-1460,  2200, {}},
    {-1540,  2200, {}},
    {-1620,  2200, {}},
    {-1640,  2220, {}},
    {-1680,  2240, {}},
    {-1700,  2280, {}},
    {-1740,  2300, {}},
    {-1740,  2320, {}},
    {-1760,  2340, {}},
    {-1780,  2240, {}},
    {-1800,  2140, {}},
    {-1800,  2100, {}},
    {-1800,  2080, {}},
    {-1800,  2060, {}},
    {-1780,  2040, {}},
    {-1800,  2020, {}},
    {-1780,  1980, {}},
    {-1780,  1940, {}},
    {-1780,  1920, {}},
    {-1780,  1880, {}},
    {-1760,  1860, {}},
    {-1740,  1840, {}},
    {-1740,  1756, {}},
    {-1740,  1672, {}},
    {-1740,  1588, {}},
    {-1740,  1504, {}},
    {-1740,  1420, {}},
    {-1740,  1400, {}},
    {-1740,  1380, {}},
    {-1720,  1360, {}},
    {-1700,  1340, {}},
    {-1700,  1320, {}},
    {-1700,  1300, {}},
    {-1720,  1280, {}},
    {-1720,  1260, {}},
    {-1720,  1240, {}},
    {-1720,  1220, {}},
    {-1720,  1200, {}},
    {-1720,  1180, {}},
    {-1700,  1160, {}},
    {-1700,  1066, {}},
    {-1700,   971, {}},
    {-1700,   877, {}},
    {-1700,   783, {}},
    {-1700,   689, {}},
    {-1700,   594, {}},
    {-1700,   500, {}},
    {-1600,   500, {}},
    {-1500,   500, {}},
    {-1400,   500, {}},
    {-1300,   500, {}},
    {-1200,   500, {}},
    {-1100,   500, {}},
    {-1000,   500, {}},
    { -900,   500, {}},
    { -800,   500, {}},
    { -700,   500, {}},
    { -600,   500, {}},
    { -500,   500, {}},
    { -400,   500, {}},
    { -300,   500, {}},
    { -200,   500, {}},
    { -100,   500, {}},
    {    0,   500, {}},
};

static ZoneVertex ituz53[] = {
    {-1764,  2343, {}},
    {-1740,  2320, {}},
    {-1700,  2280, {}},
    {-1680,  2240, {}},
    {-1640,  2220, {}},
    {-1620,  2200, {}},
    {-1540,  2200, {}},
    {-1460,  2200, {}},
    {-1380,  2200, {}},
    {-1300,  2200, {}},
    {-1300,  2300, {}},
    {-1300,  2400, {}},
    {-1280,  2380, {}},
    {-1260,  2400, {}},
    {-1240,  2400, {}},
    {-1220,  2400, {}},
    {-1160,  2400, {}},
    {-1120,  2400, {}},
    {-1100,  2400, {}},
    {-1100,  2420, {}},
    {-1120,  2440, {}},
    {-1140,  2440, {}},
    {-1120,  2480, {}},
    {-1120,  2540, {}},
    {-1160,  2540, {}},
    {-1180,  2600, {}},
    {-1200,  2640, {}},
    {-1200,  2680, {}},
    {-1160,  2700, {}},
    {-1160,  2720, {}},
    {-1180,  2740, {}},
    {-1220,  2760, {}},
    {-1220,  2780, {}},
    {-1240,  2800, {}},
    {-1240,  2840, {}},
    {-1260,  2860, {}},
    {-1300,  2860, {}},
    {-1340,  2900, {}},
    {-1320,  2960, {}},
    {-1340,  2960, {}},
    {-1340,  2980, {}},
    {-1280,  2980, {}},
    {-1220,  2980, {}},
    {-1220,  2960, {}},
    {-1240,  2960, {}},
    {-1240,  2920, {}},
    {-1220,  2880, {}},
    {-1200,  2880, {}},
    {-1180,  2840, {}},
    {-1160,  2840, {}},
    {-1140,  2840, {}},
    {-1120,  2840, {}},
    {-1080,  2860, {}},
    {-1060,  2860, {}},
    {-1040,  2860, {}},
    {-1020,  2860, {}},
    {-1000,  2860, {}},
    { -980,  2860, {}},
    { -960,  2860, {}},
    { -940,  2860, {}},
    { -920,  2840, {}},
    { -900,  2860, {}},
    { -880,  2880, {}},
    { -860,  2900, {}},
    { -840,  2990, {}},
    { -820,  3080, {}},
    { -800,  3080, {}},
    { -780,  3060, {}},
    { -760,  3040, {}},
    { -740,  3040, {}},
    { -720,  3040, {}},
    { -700,  3020, {}},
    { -680,  2980, {}},
    { -640,  2960, {}},
    { -620,  2960, {}},
    { -600,  2940, {}},
    { -580,  2960, {}},
    { -560,  2960, {}},
    { -520,  2940, {}},
    { -480,  2940, {}},
    { -460,  2940, {}},
    { -440,  2960, {}},
    { -440,  2980, {}},
    { -420,  3000, {}},
    { -400,  3020, {}},
    { -380,  3040, {}},
    { -360,  3040, {}},
    { -340,  3060, {}},
    { -320,  3080, {}},
    { -300,  3080, {}},
    { -280,  3060, {}},
    { -260,  3040, {}},
    { -240,  3060, {}},
    { -240,  3080, {}},
    { -200,  3080, {}},
    { -160,  3080, {}},
    { -140,  3060, {}},
    { -120,  3060, {}},
    { -100,  3080, {}},
    { -100,  3160, {}},
    { -100,  3240, {}},
    { -100,  3320, {}},
    { -100,  3400, {}},
    { -150,  3490, {}},
    { -200,  3580, {}},
    { -250,  3670, {}},
    { -300,  3760, {}},
    { -340,  3780, {}},
    { -340,  3760, {}},
    { -360,  3780, {}},
    { -440,  3860, {}},
    { -460,  3920, {}},
    { -480,  3960, {}},
    { -436,  4055, {}},
    { -393,  4149, {}},
    { -349,  4244, {}},
    { -305,  4338, {}},
    { -262,  4433, {}},
    { -218,  4527, {}},
    { -175,  4622, {}},
    { -131,  4716, {}},
    {  -87,  4811, {}},
    {  -44,  4905, {}},
    {    0,  5000, {}},
    {    0,  5100, {}},
    {    0,  5200, {}},
    {    0,  5300, {}},
    {    0,  5400, {}},
    {    0,  5500, {}},
    {    0,  5600, {}},
    {    0,  5700, {}},
    {    0,  5800, {}},
    {    0,  5900, {}},
    {    0,  6000, {}},
    { -100,  6025, {}},
    { -200,  6050, {}},
    { -300,  6075, {}},
    { -400,  6100, {}},
    { -500,  6125, {}},
    { -600,  6150, {}},
    { -700,  6175, {}},
    { -800,  6200, {}},
    { -900,  6225, {}},
    {-1000,  6250, {}},
    {-1100,  6275, {}},
    {-1200,  6300, {}},
    {-1300,  6325, {}},
    {-1400,  6350, {}},
    {-1500,  6375, {}},
    {-1600,  6400, {}},
    {-1700,  6425, {}},
    {-1800,  6450, {}},
    {-1900,  6475, {}},
    {-2000,  6500, {}},
    {-2100,  6429, {}},
    {-2200,  6357, {}},
    {-2300,  6286, {}},
    {-2400,  6214, {}},
    {-2500,  6143, {}},
    {-2600,  6071, {}},
    {-2700,  6000, {}},
    {-2700,  5900, {}},
    {-2700,  5800, {}},
    {-2700,  5700, {}},
    {-2700,  5600, {}},
    {-2700,  5500, {}},
    {-2700,  5400, {}},
    {-2700,  5300, {}},
    {-2700,  5200, {}},
    {-2700,  5100, {}},
    {-2700,  5000, {}},
    {-2700,  4900, {}},
    {-2700,  4800, {}},
    {-2700,  4700, {}},
    {-2700,  4600, {}},
    {-2700,  4500, {}},
    {-2700,  4400, {}},
    {-2700,  4300, {}},
    {-2700,  4200, {}},
    {-2700,  4100, {}},
    {-2700,  4000, {}},
    {-2700,  3900, {}},
    {-2700,  3800, {}},
    {-2700,  3700, {}},
    {-2700,  3600, {}},
    {-2700,  3500, {}},
    {-2700,  3400, {}},
    {-2700,  3300, {}},
    {-2680,  3280, {}},
    {-2680,  3260, {}},
    {-2680,  3240, {}},
    {-2680,  3220, {}},
    {-2660,  3220, {}},
    {-2640,  3200, {}},
    {-2620,  3220, {}},
    {-2600,  3200, {}},
    {-2560,  3200, {}},
    {-2540,  3200, {}},
    {-2520,  3200, {}},
    {-2460,  3200, {}},
    {-2440,  3200, {}},
    {-2420,  3200, {}},
    {-2400,  3180, {}},
    {-2380,  3160, {}},
    {-2360,  3160, {}},
    {-2320,  3160, {}},
    {-2240,  3140, {}},
    {-2240,  3120, {}},
    {-2240,  3100, {}},
    {-2240,  3080, {}},
    {-2240,  3060, {}},
    {-2240,  3040, {}},
    {-2240,  3020, {}},
    {-2220,  3000, {}},
    {-2220,  2980, {}},
    {-2220,  2960, {}},
    {-2220,  2940, {}},
    {-2200,  2920, {}},
    {-2180,  2900, {}},
    {-2180,  2880, {}},
    {-2160,  2860, {}},
    {-2160,  2840, {}},
    {-2160,  2820, {}},
    {-2160,  2800, {}},
    {-2140,  2800, {}},
    {-2120,  2780, {}},
    {-2100,  2780, {}},
    {-2080,  2780, {}},
    {-2060,  2780, {}},
    {-2040,  2760, {}},
    {-2040,  2740, {}},
    {-2020,  2720, {}},
    {-2000,  2700, {}},
    {-2000,  2680, {}},
    {-1980,  2660, {}},
    {-1960,  2640, {}},
    {-1960,  2620, {}},
    {-1940,  2620, {}},
    {-1920,  2600, {}},
    {-1900,  2600, {}},
    {-1880,  2580, {}},
    {-1860,  2580, {}},
    {-1840,  2560, {}},
    {-1820,  2540, {}},
    {-1800,  2520, {}},
    {-1780,  2520, {}},
    {-1760,  2500, {}},
    {-1760,  2480, {}},
    {-1760,  2460, {}},
    {-1740,  2440, {}},
    {-1760,  2340, {}},
};

static ZoneVertex ituz54[] = {
    {-1300,  9000, {}},
    {-1300,  9100, {}},
    {-1300,  9200, {}},
    {-1300,  9300, {}},
    {-1300,  9400, {}},
    {-1300,  9500, {}},
    {-1300,  9600, {}},
    {-1300,  9700, {}},
    {-1300,  9800, {}},
    {-1300,  9900, {}},
    {-1300, 10000, {}},
    {-1300, 10100, {}},
    {-1300, 10200, {}},
    {-1300, 10300, {}},
    {-1300, 10400, {}},
    {-1300, 10500, {}},
    {-1300, 10600, {}},
    {-1300, 10700, {}},
    {-1300, 10800, {}},
    {-1300, 10900, {}},
    {-1300, 11000, {}},
    {-1300, 11100, {}},
    {-1300, 11200, {}},
    {-1300, 11300, {}},
    {-1300, 11400, {}},
    {-1300, 11500, {}},
    {-1279, 11600, {}},
    {-1257, 11700, {}},
    {-1236, 11800, {}},
    {-1214, 11900, {}},
    {-1193, 12000, {}},
    {-1171, 12100, {}},
    {-1150, 12200, {}},
    {-1129, 12300, {}},
    {-1107, 12400, {}},
    {-1086, 12500, {}},
    {-1064, 12600, {}},
    {-1043, 12700, {}},
    {-1021, 12800, {}},
    {-1000, 12900, {}},
    {-1000, 13000, {}},
    { -903, 13000, {}},
    { -806, 13000, {}},
    { -709, 13000, {}},
    { -612, 13000, {}},
    { -515, 13000, {}},
    { -418, 13000, {}},
    { -322, 13000, {}},
    { -225, 13000, {}},
    { -128, 13000, {}},
    {  -31, 13000, {}},
    {   66, 13000, {}},
    {  163, 13000, {}},
    {  260, 13000, {}},
    {  335, 12925, {}},
    {  410, 12850, {}},
    {  485, 12775, {}},
    {  560, 12700, {}},
    {  543, 12603, {}},
    {  525, 12505, {}},
    {  508, 12408, {}},
    {  490, 12310, {}},
    {  473, 12213, {}},
    {  455, 12115, {}},
    {  438, 12018, {}},
    {  420, 11920, {}},
    {  480, 11900, {}},
    {  540, 11940, {}},
    {  570, 11880, {}},
    {  600, 11820, {}},
    {  660, 11800, {}},
    {  740, 11740, {}},
    {  760, 11680, {}},
    {  670, 11580, {}},
    {  580, 11480, {}},
    {  594, 11391, {}},
    {  609, 11303, {}},
    {  623, 11214, {}},
    {  637, 11126, {}},
    {  651, 11037, {}},
    {  666, 10949, {}},
    {  680, 10860, {}},
    {  671, 10769, {}},
    {  663, 10677, {}},
    {  654, 10586, {}},
    {  646, 10494, {}},
    {  637, 10403, {}},
    {  629, 10311, {}},
    {  620, 10220, {}},
    {  600, 10200, {}},
    {  580, 10180, {}},
    {  600, 10160, {}},
    {  580, 10140, {}},
    {  560, 10120, {}},
    {  580, 10100, {}},
    {  600, 10120, {}},
    {  620, 10120, {}},
    {  620, 10100, {}},
    {  640, 10080, {}},
    {  640, 10060, {}},
    {  660, 10040, {}},
    {  680, 10020, {}},
    {  660, 10020, {}},
    {  660,  9980, {}},
    {  640,  9960, {}},
    {  640,  9864, {}},
    {  640,  9768, {}},
    {  640,  9672, {}},
    {  640,  9576, {}},
    {  640,  9480, {}},
    {  640,  9384, {}},
    {  640,  9288, {}},
    {  640,  9192, {}},
    {  640,  9096, {}},
    {  640,  9000, {}},
    {  543,  9000, {}},
    {  446,  9000, {}},
    {  349,  9000, {}},
    {  252,  9000, {}},
    {  155,  9000, {}},
    {   58,  9000, {}},
    {  -39,  9000, {}},
    { -136,  9000, {}},
    { -233,  9000, {}},
    { -330,  9000, {}},
    { -427,  9000, {}},
    { -524,  9000, {}},
    { -621,  9000, {}},
    { -718,  9000, {}},
    { -815,  9000, {}},
    { -912,  9000, {}},
    {-1009,  9000, {}},
    {-1106,  9000, {}},
    {-1203,  9000, {}},
    {-1300,  9000, {}},
};

static ZoneVertex ituz55[] = {
    {-1000, 13000, {}},
    {-1000, 12900, {}},
    {-1100, 12900, {}},
    {-1200, 12900, {}},
    {-1300, 12900, {}},
    {-1400, 12900, {}},
    {-1500, 12900, {}},
    {-1600, 12900, {}},
    {-1700, 12900, {}},
    {-1800, 12900, {}},
    {-1900, 12900, {}},
    {-2000, 12900, {}},
    {-2100, 12900, {}},
    {-2200, 12900, {}},
    {-2300, 12900, {}},
    {-2400, 12900, {}},
    {-2500, 12900, {}},
    {-2600, 12900, {}},
    {-2600, 13000, {}},
    {-2600, 13100, {}},
    {-2600, 13200, {}},
    {-2600, 13300, {}},
    {-2600, 13400, {}},
    {-2600, 13500, {}},
    {-2600, 13600, {}},
    {-2600, 13700, {}},
    {-2600, 13800, {}},
    {-2600, 13900, {}},
    {-2600, 14000, {}},
    {-2600, 14100, {}},
    {-2700, 14100, {}},
    {-2800, 14100, {}},
    {-2900, 14100, {}},
    {-2900, 14200, {}},
    {-2900, 14300, {}},
    {-2900, 14400, {}},
    {-2900, 14500, {}},
    {-2900, 14600, {}},
    {-2900, 14700, {}},
    {-2900, 14800, {}},
    {-2900, 14900, {}},
    {-2880, 14920, {}},
    {-2860, 14940, {}},
    {-2860, 14960, {}},
    {-2860, 14980, {}},
    {-2860, 15000, {}},
    {-2860, 15020, {}},
    {-2860, 15040, {}},
    {-2860, 15060, {}},
    {-2860, 15080, {}},
    {-2880, 15100, {}},
    {-2880, 15120, {}},
    {-2900, 15120, {}},
    {-2920, 15140, {}},
    {-2900, 15160, {}},
    {-2900, 15180, {}},
    {-2900, 15200, {}},
    {-2880, 15200, {}},
    {-2860, 15200, {}},
    {-2840, 15220, {}},
    {-2840, 15240, {}},
    {-2820, 15260, {}},
    {-2840, 15280, {}},
    {-2840, 15300, {}},
    {-2820, 15320, {}},
    {-2820, 15340, {}},
    {-2800, 15400, {}},
    {-2700, 15400, {}},
    {-2600, 15400, {}},
    {-2500, 15400, {}},
    {-2400, 15400, {}},
    {-2300, 15400, {}},
    {-2200, 15400, {}},
    {-2100, 15400, {}},
    {-2000, 15400, {}},
    {-1900, 15400, {}},
    {-1800, 15400, {}},
    {-1700, 15400, {}},
    {-1600, 15400, {}},
    {-1500, 15400, {}},
    {-1400, 15400, {}},
    {-1300, 15400, {}},
    {-1200, 15400, {}},
    {-1200, 15308, {}},
    {-1200, 15216, {}},
    {-1200, 15124, {}},
    {-1200, 15032, {}},
    {-1200, 14940, {}},
    {-1200, 14848, {}},
    {-1200, 14756, {}},
    {-1200, 14664, {}},
    {-1200, 14572, {}},
    {-1200, 14480, {}},
    {-1107, 14467, {}},
    {-1013, 14453, {}},
    { -920, 14440, {}},
    { -930, 14350, {}},
    { -940, 14260, {}},
    { -920, 14220, {}},
    { -926, 14126, {}},
    { -932, 14032, {}},
    { -938, 13938, {}},
    { -945, 13845, {}},
    { -951, 13751, {}},
    { -957, 13657, {}},
    { -963, 13563, {}},
    { -969, 13469, {}},
    { -975, 13375, {}},
    { -982, 13282, {}},
    { -988, 13188, {}},
    { -994, 13094, {}},
    {-1000, 13000, {}},
};

static ZoneVertex ituz56[] = {
    {-2800, 15400, {}},
    {-2706, 15400, {}},
    {-2612, 15400, {}},
    {-2518, 15400, {}},
    {-2424, 15400, {}},
    {-2329, 15400, {}},
    {-2235, 15400, {}},
    {-2141, 15400, {}},
    {-2047, 15400, {}},
    {-1953, 15400, {}},
    {-1859, 15400, {}},
    {-1765, 15400, {}},
    {-1671, 15400, {}},
    {-1576, 15400, {}},
    {-1482, 15400, {}},
    {-1388, 15400, {}},
    {-1294, 15400, {}},
    {-1200, 15400, {}},
    {-1200, 15500, {}},
    {-1200, 15600, {}},
    {-1200, 15700, {}},
    {-1200, 15800, {}},
    {-1200, 15900, {}},
    {-1200, 16000, {}},
    {-1200, 16100, {}},
    {-1200, 16200, {}},
    {-1200, 16300, {}},
    {-1200, 16400, {}},
    {-1200, 16500, {}},
    {-1200, 16600, {}},
    {-1200, 16700, {}},
    {-1200, 16800, {}},
    {-1200, 16900, {}},
    {-1200, 17000, {}},
    {-1200, 17100, {}},
    {-1200, 17200, {}},
    {-1200, 17300, {}},
    {-1200, 17400, {}},
    {-1200, 17500, {}},
    {-1200, 17600, {}},
    {-1200, 17700, {}},
    {-1200, 17800, {}},
    {-1280, 17900, {}},
    {-1360, -18000, {}},
    {-1440, -17900, {}},
    {-1520, -17800, {}},
    {-1600, -17700, {}},
    {-1700, -17700, {}},
    {-1800, -17700, {}},
    {-1900, -17700, {}},
    {-2000, -17700, {}},
    {-2100, -17700, {}},
    {-2200, -17700, {}},
    {-2200, -17800, {}},
    {-2200, -17900, {}},
    {-2200, -18000, {}},
    {-2300, -18000, {}},
    {-2400, -18000, {}},
    {-2500, -18000, {}},
    {-2600, -18000, {}},
    {-2700, -18000, {}},
    {-2800, -18000, {}},
    {-2800, 17900, {}},
    {-2800, 17800, {}},
    {-2800, 17700, {}},
    {-2800, 17600, {}},
    {-2800, 17500, {}},
    {-2800, 17400, {}},
    {-2800, 17300, {}},
    {-2800, 17200, {}},
    {-2800, 17100, {}},
    {-2800, 17000, {}},
    {-2800, 16900, {}},
    {-2800, 16800, {}},
    {-2800, 16700, {}},
    {-2800, 16600, {}},
    {-2800, 16500, {}},
    {-2800, 16400, {}},
    {-2800, 16300, {}},
    {-2800, 16200, {}},
    {-2800, 16100, {}},
    {-2800, 16000, {}},
    {-2800, 15900, {}},
    {-2800, 15800, {}},
    {-2800, 15700, {}},
    {-2800, 15600, {}},
    {-2800, 15500, {}},
    {-2800, 15400, {}},
};

static ZoneVertex ituz57[] = {
    {-1700,   500, {}},
    {-1800,   500, {}},
    {-1900,   500, {}},
    {-2000,   500, {}},
    {-2100,   550, {}},
    {-2200,   600, {}},
    {-2300,   650, {}},
    {-2400,   700, {}},
    {-2500,   750, {}},
    {-2600,   800, {}},
    {-2700,   850, {}},
    {-2800,   900, {}},
    {-2900,   950, {}},
    {-3000,  1000, {}},
    {-3100,  1050, {}},
    {-3200,  1100, {}},
    {-3300,  1150, {}},
    {-3400,  1200, {}},
    {-3500,  1250, {}},
    {-3600,  1300, {}},
    {-3700,  1350, {}},
    {-3800,  1400, {}},
    {-3900,  1450, {}},
    {-4000,  1500, {}},
    {-4100,  1550, {}},
    {-4200,  1600, {}},
    {-4300,  1650, {}},
    {-4400,  1700, {}},
    {-4500,  1750, {}},
    {-4600,  1800, {}},
    {-4700,  1850, {}},
    {-4800,  1900, {}},
    {-4900,  1950, {}},
    {-5000,  2000, {}},
    {-5000,  2100, {}},
    {-5000,  2200, {}},
    {-5000,  2300, {}},
    {-5000,  2400, {}},
    {-5000,  2500, {}},
    {-5000,  2600, {}},
    {-5000,  2700, {}},
    {-5000,  2800, {}},
    {-5000,  2900, {}},
    {-5000,  3000, {}},
    {-5000,  3100, {}},
    {-5000,  3200, {}},
    {-5000,  3300, {}},
    {-5000,  3400, {}},
    {-5000,  3500, {}},
    {-5000,  3600, {}},
    {-5000,  3700, {}},
    {-5000,  3800, {}},
    {-5000,  3900, {}},
    {-5000,  4000, {}},
    {-4900,  4000, {}},
    {-4800,  4000, {}},
    {-4700,  4000, {}},
    {-4600,  4000, {}},
    {-4500,  4000, {}},
    {-4400,  4000, {}},
    {-4300,  4000, {}},
    {-4200,  4000, {}},
    {-4100,  4000, {}},
    {-4000,  4000, {}},
    {-3900,  4000, {}},
    {-3800,  4000, {}},
    {-3700,  4000, {}},
    {-3600,  4000, {}},
    {-3500,  4000, {}},
    {-3400,  4000, {}},
    {-3300,  4000, {}},
    {-3200,  4000, {}},
    {-3100,  4000, {}},
    {-3000,  4000, {}},
    {-2900,  4000, {}},
    {-2800,  4000, {}},
    {-2700,  4000, {}},
    {-2700,  3900, {}},
    {-2700,  3800, {}},
    {-2700,  3700, {}},
    {-2700,  3600, {}},
    {-2700,  3500, {}},
    {-2700,  3400, {}},
    {-2700,  3300, {}},
    {-2680,  3280, {}},
    {-2680,  3260, {}},
    {-2680,  3240, {}},
    {-2680,  3220, {}},
    {-2660,  3220, {}},
    {-2640,  3200, {}},
    {-2620,  3220, {}},
    {-2600,  3200, {}},
    {-2560,  3200, {}},
    {-2540,  3200, {}},
    {-2520,  3200, {}},
    {-2460,  3200, {}},
    {-2440,  3200, {}},
    {-2420,  3200, {}},
    {-2400,  3180, {}},
    {-2380,  3160, {}},
    {-2360,  3160, {}},
    {-2320,  3160, {}},
    {-2240,  3140, {}},
    {-2240,  3120, {}},
    {-2240,  3100, {}},
    {-2240,  3080, {}},
    {-2240,  3060, {}},
    {-2240,  3040, {}},
    {-2240,  3020, {}},
    {-2220,  3000, {}},
    {-2220,  2980, {}},
    {-2220,  2960, {}},
    {-2220,  2940, {}},
    {-2200,  2920, {}},
    {-2180,  2900, {}},
    {-2180,  2880, {}},
    {-2160,  2860, {}},
    {-2160,  2840, {}},
    {-2160,  2820, {}},
    {-2160,  2800, {}},
    {-2140,  2800, {}},
    {-2120,  2780, {}},
    {-2100,  2780, {}},
    {-2080,  2780, {}},
    {-2060,  2780, {}},
    {-2040,  2760, {}},
    {-2040,  2740, {}},
    {-2020,  2720, {}},
    {-2000,  2700, {}},
    {-2000,  2680, {}},
    {-1980,  2660, {}},
    {-1960,  2640, {}},
    {-1960,  2620, {}},
    {-1940,  2620, {}},
    {-1920,  2600, {}},
    {-1900,  2600, {}},
    {-1880,  2580, {}},
    {-1860,  2580, {}},
    {-1840,  2560, {}},
    {-1820,  2540, {}},
    {-1800,  2520, {}},
    {-1780,  2520, {}},
    {-1760,  2500, {}},
    {-1760,  2480, {}},
    {-1760,  2460, {}},
    {-1740,  2440, {}},
    {-1760,  2340, {}},
    {-1780,  2240, {}},
    {-1800,  2140, {}},
    {-1800,  2100, {}},
    {-1800,  2080, {}},
    {-1800,  2060, {}},
    {-1780,  2040, {}},
    {-1800,  2020, {}},
    {-1780,  1980, {}},
    {-1780,  1940, {}},
    {-1780,  1920, {}},
    {-1780,  1880, {}},
    {-1760,  1860, {}},
    {-1740,  1840, {}},
    {-1740,  1756, {}},
    {-1740,  1672, {}},
    {-1740,  1588, {}},
    {-1740,  1504, {}},
    {-1740,  1420, {}},
    {-1740,  1400, {}},
    {-1740,  1380, {}},
    {-1720,  1360, {}},
    {-1700,  1340, {}},
    {-1700,  1320, {}},
    {-1700,  1300, {}},
    {-1720,  1280, {}},
    {-1720,  1260, {}},
    {-1720,  1240, {}},
    {-1720,  1220, {}},
    {-1720,  1200, {}},
    {-1720,  1180, {}},
    {-1700,  1160, {}},
    {-1700,  1066, {}},
    {-1700,   971, {}},
    {-1700,   877, {}},
    {-1700,   783, {}},
    {-1700,   689, {}},
    {-1700,   594, {}},
    {-1700,   500, {}},
};

static ZoneVertex ituz58[] = {
    {-1000, 12900, {}},
    {-1100, 12900, {}},
    {-1200, 12900, {}},
    {-1300, 12900, {}},
    {-1400, 12900, {}},
    {-1500, 12900, {}},
    {-1600, 12900, {}},
    {-1700, 12900, {}},
    {-1800, 12900, {}},
    {-1900, 12900, {}},
    {-2000, 12900, {}},
    {-2100, 12900, {}},
    {-2200, 12900, {}},
    {-2300, 12900, {}},
    {-2400, 12900, {}},
    {-2500, 12900, {}},
    {-2600, 12900, {}},
    {-2700, 12900, {}},
    {-2800, 12900, {}},
    {-2900, 12900, {}},
    {-3000, 12900, {}},
    {-3100, 12900, {}},
    {-3200, 12900, {}},
    {-3300, 12900, {}},
    {-3400, 12900, {}},
    {-3500, 12900, {}},
    {-3600, 12900, {}},
    {-3700, 12900, {}},
    {-3800, 12900, {}},
    {-3900, 12900, {}},
    {-4000, 12900, {}},
    {-4000, 12800, {}},
    {-4000, 12700, {}},
    {-4000, 12600, {}},
    {-4000, 12500, {}},
    {-4000, 12400, {}},
    {-4000, 12300, {}},
    {-4000, 12200, {}},
    {-4000, 12100, {}},
    {-4000, 12000, {}},
    {-4000, 11900, {}},
    {-4000, 11800, {}},
    {-4000, 11700, {}},
    {-4000, 11600, {}},
    {-4000, 11500, {}},
    {-4000, 11400, {}},
    {-4000, 11300, {}},
    {-4000, 11200, {}},
    {-4000, 11100, {}},
    {-4000, 11000, {}},
    {-3900, 11000, {}},
    {-3800, 11000, {}},
    {-3700, 11000, {}},
    {-3600, 11000, {}},
    {-3500, 11000, {}},
    {-3400, 11000, {}},
    {-3300, 11000, {}},
    {-3200, 11000, {}},
    {-3100, 11000, {}},
    {-3000, 11000, {}},
    {-2900, 11000, {}},
    {-2800, 11000, {}},
    {-2700, 11000, {}},
    {-2600, 11000, {}},
    {-2500, 11000, {}},
    {-2400, 11000, {}},
    {-2300, 11000, {}},
    {-2200, 11000, {}},
    {-2100, 11000, {}},
    {-2000, 11000, {}},
    {-1900, 11000, {}},
    {-1800, 11000, {}},
    {-1700, 11000, {}},
    {-1600, 11000, {}},
    {-1500, 11000, {}},
    {-1400, 11000, {}},
    {-1300, 11000, {}},
    {-1300, 11100, {}},
    {-1300, 11200, {}},
    {-1300, 11300, {}},
    {-1300, 11400, {}},
    {-1300, 11500, {}},
    {-1279, 11600, {}},
    {-1257, 11700, {}},
    {-1236, 11800, {}},
    {-1214, 11900, {}},
    {-1193, 12000, {}},
    {-1171, 12100, {}},
    {-1150, 12200, {}},
    {-1129, 12300, {}},
    {-1107, 12400, {}},
    {-1086, 12500, {}},
    {-1064, 12600, {}},
    {-1043, 12700, {}},
    {-1021, 12800, {}},
    {-1000, 12900, {}},
};

static ZoneVertex ituz59[] = {
    {-2600, 12900, {}},
    {-2600, 13000, {}},
    {-2600, 13100, {}},
    {-2600, 13200, {}},
    {-2600, 13300, {}},
    {-2600, 13400, {}},
    {-2600, 13500, {}},
    {-2600, 13600, {}},
    {-2600, 13700, {}},
    {-2600, 13800, {}},
    {-2600, 13900, {}},
    {-2600, 14000, {}},
    {-2600, 14100, {}},
    {-2700, 14100, {}},
    {-2800, 14100, {}},
    {-2900, 14100, {}},
    {-2900, 14200, {}},
    {-2900, 14300, {}},
    {-2900, 14400, {}},
    {-2900, 14500, {}},
    {-2900, 14600, {}},
    {-2900, 14700, {}},
    {-2900, 14800, {}},
    {-2900, 14900, {}},
    {-2880, 14920, {}},
    {-2860, 14940, {}},
    {-2860, 14960, {}},
    {-2860, 14980, {}},
    {-2860, 15000, {}},
    {-2860, 15020, {}},
    {-2860, 15040, {}},
    {-2860, 15060, {}},
    {-2860, 15080, {}},
    {-2880, 15100, {}},
    {-2880, 15120, {}},
    {-2900, 15120, {}},
    {-2920, 15140, {}},
    {-2900, 15160, {}},
    {-2900, 15180, {}},
    {-2900, 15200, {}},
    {-2880, 15200, {}},
    {-2860, 15200, {}},
    {-2840, 15220, {}},
    {-2840, 15240, {}},
    {-2820, 15260, {}},
    {-2840, 15280, {}},
    {-2840, 15300, {}},
    {-2820, 15320, {}},
    {-2820, 15340, {}},
    {-2800, 15400, {}},
    {-2900, 15400, {}},
    {-3000, 15400, {}},
    {-3100, 15400, {}},
    {-3200, 15400, {}},
    {-3300, 15400, {}},
    {-3400, 15400, {}},
    {-3500, 15400, {}},
    {-3600, 15400, {}},
    {-3700, 15400, {}},
    {-3800, 15400, {}},
    {-3900, 15400, {}},
    {-4000, 15400, {}},
    {-4100, 15400, {}},
    {-4200, 15400, {}},
    {-4300, 15400, {}},
    {-4400, 15400, {}},
    {-4500, 15400, {}},
    {-4600, 15400, {}},
    {-4700, 15400, {}},
    {-4800, 15400, {}},
    {-4900, 15400, {}},
    {-5000, 15400, {}},
    {-5000, 15300, {}},
    {-5000, 15200, {}},
    {-5000, 15100, {}},
    {-5000, 15000, {}},
    {-5000, 14900, {}},
    {-5000, 14800, {}},
    {-5000, 14700, {}},
    {-5000, 14600, {}},
    {-5000, 14500, {}},
    {-5000, 14400, {}},
    {-5000, 14300, {}},
    {-5000, 14200, {}},
    {-5000, 14100, {}},
    {-5000, 14000, {}},
    {-4909, 13900, {}},
    {-4818, 13800, {}},
    {-4727, 13700, {}},
    {-4636, 13600, {}},
    {-4545, 13500, {}},
    {-4455, 13400, {}},
    {-4364, 13300, {}},
    {-4273, 13200, {}},
    {-4182, 13100, {}},
    {-4091, 13000, {}},
    {-4000, 12900, {}},
    {-3900, 12900, {}},
    {-3800, 12900, {}},
    {-3700, 12900, {}},
    {-3600, 12900, {}},
    {-3500, 12900, {}},
    {-3400, 12900, {}},
    {-3300, 12900, {}},
    {-3200, 12900, {}},
    {-3100, 12900, {}},
    {-3000, 12900, {}},
    {-2900, 12900, {}},
    {-2800, 12900, {}},
    {-2700, 12900, {}},
    {-2600, 12900, {}},
};

static ZoneVertex ituz60[] = {
    {-2800, 15400, {}},
    {-2900, 15400, {}},
    {-3000, 15400, {}},
    {-3100, 15400, {}},
    {-3200, 15400, {}},
    {-3300, 15400, {}},
    {-3400, 15400, {}},
    {-3500, 15400, {}},
    {-3600, 15400, {}},
    {-3700, 15400, {}},
    {-3800, 15400, {}},
    {-3900, 15400, {}},
    {-4000, 15400, {}},
    {-4100, 15400, {}},
    {-4200, 15400, {}},
    {-4300, 15400, {}},
    {-4400, 15400, {}},
    {-4500, 15400, {}},
    {-4600, 15400, {}},
    {-4700, 15400, {}},
    {-4800, 15400, {}},
    {-4900, 15400, {}},
    {-5000, 15400, {}},
    {-5100, 15400, {}},
    {-5200, 15400, {}},
    {-5300, 15400, {}},
    {-5400, 15400, {}},
    {-5500, 15400, {}},
    {-5500, 15500, {}},
    {-5500, 15600, {}},
    {-5500, 15700, {}},
    {-5500, 15800, {}},
    {-5500, 15900, {}},
    {-5500, 16000, {}},
    {-5500, 16100, {}},
    {-5500, 16200, {}},
    {-5500, 16300, {}},
    {-5500, 16400, {}},
    {-5500, 16500, {}},
    {-5500, 16600, {}},
    {-5500, 16700, {}},
    {-5500, 16800, {}},
    {-5500, 16900, {}},
    {-5500, 17000, {}},
    {-5500, 17100, {}},
    {-5500, 17200, {}},
    {-5500, 17300, {}},
    {-5500, 17400, {}},
    {-5500, 17500, {}},
    {-5500, 17600, {}},
    {-5500, 17700, {}},
    {-5500, 17800, {}},
    {-5500, 17900, {}},
    {-5500, -18000, {}},
    {-5500, -17900, {}},
    {-5500, -17800, {}},
    {-5500, -17700, {}},
    {-5500, -17600, {}},
    {-5500, -17500, {}},
    {-5400, -17500, {}},
    {-5300, -17500, {}},
    {-5200, -17500, {}},
    {-5100, -17500, {}},
    {-5000, -17500, {}},
    {-4900, -17500, {}},
    {-4800, -17500, {}},
    {-4700, -17500, {}},
    {-4600, -17500, {}},
    {-4500, -17500, {}},
    {-4400, -17500, {}},
    {-4300, -17500, {}},
    {-4200, -17500, {}},
    {-4100, -17500, {}},
    {-4000, -17500, {}},
    {-3900, -17500, {}},
    {-3800, -17500, {}},
    {-3700, -17500, {}},
    {-3600, -17500, {}},
    {-3500, -17500, {}},
    {-3400, -17500, {}},
    {-3300, -17500, {}},
    {-3200, -17500, {}},
    {-3100, -17500, {}},
    {-3000, -17500, {}},
    {-2900, -17500, {}},
    {-2800, -17500, {}},
    {-2800, -17600, {}},
    {-2800, -17700, {}},
    {-2800, -17800, {}},
    {-2800, -17900, {}},
    {-2800, -18000, {}},
    {-2800, 17900, {}},
    {-2800, 17800, {}},
    {-2800, 17700, {}},
    {-2800, 17600, {}},
    {-2800, 17500, {}},
    {-2800, 17400, {}},
    {-2800, 17300, {}},
    {-2800, 17200, {}},
    {-2800, 17100, {}},
    {-2800, 17000, {}},
    {-2800, 16900, {}},
    {-2800, 16800, {}},
    {-2800, 16700, {}},
    {-2800, 16600, {}},
    {-2800, 16500, {}},
    {-2800, 16400, {}},
    {-2800, 16300, {}},
    {-2800, 16200, {}},
    {-2800, 16100, {}},
    {-2800, 16000, {}},
    {-2800, 15900, {}},
    {-2800, 15800, {}},
    {-2800, 15700, {}},
    {-2800, 15600, {}},
    {-2800, 15500, {}},
    {-2800, 15400, {}},
};

static ZoneVertex ituz61[] = {
    { 3000, 17000, {}},
    { 2906, 17000, {}},
    { 2813, 17000, {}},
    { 2719, 17000, {}},
    { 2625, 17000, {}},
    { 2531, 17000, {}},
    { 2438, 17000, {}},
    { 2344, 17000, {}},
    { 2250, 17000, {}},
    { 2156, 17000, {}},
    { 2063, 17000, {}},
    { 1969, 17000, {}},
    { 1875, 17000, {}},
    { 1781, 17000, {}},
    { 1688, 17000, {}},
    { 1594, 17000, {}},
    { 1500, 17000, {}},
    { 1500, 17100, {}},
    { 1500, 17200, {}},
    { 1500, 17300, {}},
    { 1500, 17400, {}},
    { 1500, 17500, {}},
    { 1400, 17500, {}},
    { 1300, 17500, {}},
    { 1200, 17500, {}},
    { 1100, 17500, {}},
    { 1000, 17500, {}},
    {  900, 17500, {}},
    {  800, 17500, {}},
    {  700, 17500, {}},
    {  600, 17500, {}},
    {  500, 17500, {}},
    {  400, 17500, {}},
    {  300, 17500, {}},
    {  200, 17500, {}},
    {  100, 17500, {}},
    {    0, 17500, {}},
    {    0, 17600, {}},
    {    0, 17700, {}},
    {    0, 17800, {}},
    {    0, 17900, {}},
    {    0, -18000, {}},
    {    0, -17900, {}},
    {    0, -17800, {}},
    {    0, -17700, {}},
    {    0, -17600, {}},
    {    0, -17500, {}},
    {    0, -17400, {}},
    {    0, -17300, {}},
    {    0, -17200, {}},
    {    0, -17100, {}},
    {    0, -17000, {}},
    {    0, -16900, {}},
    {    0, -16800, {}},
    {    0, -16700, {}},
    {    0, -16600, {}},
    {    0, -16500, {}},
    {    0, -16400, {}},
    {    0, -16300, {}},
    {    0, -16200, {}},
    {    0, -16100, {}},
    {    0, -16000, {}},
    {    0, -15900, {}},
    {    0, -15800, {}},
    {    0, -15700, {}},
    {    0, -15600, {}},
    {    0, -15500, {}},
    {    0, -15400, {}},
    {    0, -15300, {}},
    {    0, -15200, {}},
    {    0, -15100, {}},
    {    0, -15000, {}},
    {  100, -15000, {}},
    {  200, -15000, {}},
    {  300, -15000, {}},
    {  400, -15000, {}},
    {  500, -15000, {}},
    {  600, -15000, {}},
    {  700, -15000, {}},
    {  800, -15000, {}},
    {  900, -15000, {}},
    { 1000, -15000, {}},
    { 1100, -15000, {}},
    { 1200, -15000, {}},
    { 1300, -15000, {}},
    { 1400, -15000, {}},
    { 1500, -15000, {}},
    { 1600, -15000, {}},
    { 1700, -15000, {}},
    { 1800, -15000, {}},
    { 1900, -15000, {}},
    { 2000, -15000, {}},
    { 2100, -15000, {}},
    { 2200, -15000, {}},
    { 2300, -15000, {}},
    { 2400, -15000, {}},
    { 2500, -15000, {}},
    { 2600, -15000, {}},
    { 2700, -15000, {}},
    { 2800, -15000, {}},
    { 2900, -15000, {}},
    { 3000, -15000, {}},
    { 3000, -15100, {}},
    { 3000, -15200, {}},
    { 3000, -15300, {}},
    { 3000, -15400, {}},
    { 3000, -15500, {}},
    { 3000, -15600, {}},
    { 3000, -15700, {}},
    { 3000, -15800, {}},
    { 3000, -15900, {}},
    { 3000, -16000, {}},
    { 3000, -16100, {}},
    { 3000, -16200, {}},
    { 3000, -16300, {}},
    { 3000, -16400, {}},
    { 3000, -16500, {}},
    { 3000, -16600, {}},
    { 3000, -16700, {}},
    { 3000, -16800, {}},
    { 3000, -16900, {}},
    { 3000, -17000, {}},
    { 3000, -17100, {}},
    { 3000, -17200, {}},
    { 3000, -17300, {}},
    { 3000, -17400, {}},
    { 3000, -17500, {}},
    { 3000, -17600, {}},
    { 3000, -17700, {}},
    { 3000, -17800, {}},
    { 3000, -17900, {}},
    { 3000, -18000, {}},
    { 3000, 17900, {}},
    { 3000, 17800, {}},
    { 3000, 17700, {}},
    { 3000, 17600, {}},
    { 3000, 17500, {}},
    { 3000, 17400, {}},
    { 3000, 17300, {}},
    { 3000, 17200, {}},
    { 3000, 17100, {}},
    { 3000, 17000, {}},
};

static ZoneVertex ituz62[] = {
    {    0, -17800, {}},
    { -100, -17800, {}},
    { -200, -17800, {}},
    { -300, -17800, {}},
    { -400, -17800, {}},
    { -500, -17800, {}},
    { -600, -17800, {}},
    { -700, -17800, {}},
    { -800, -17800, {}},
    { -900, -17800, {}},
    {-1000, -17800, {}},
    {-1100, -17800, {}},
    {-1200, -17800, {}},
    {-1200, -17900, {}},
    {-1200, -18000, {}},
    {-1200, 17900, {}},
    {-1200, 17800, {}},
    {-1280, 17900, {}},
    {-1360, -18000, {}},
    {-1440, -17900, {}},
    {-1520, -17800, {}},
    {-1600, -17700, {}},
    {-1700, -17700, {}},
    {-1800, -17700, {}},
    {-1900, -17700, {}},
    {-2000, -17700, {}},
    {-2100, -17700, {}},
    {-2200, -17700, {}},
    {-2200, -17800, {}},
    {-2200, -17900, {}},
    {-2200, -18000, {}},
    {-2300, -18000, {}},
    {-2400, -18000, {}},
    {-2500, -18000, {}},
    {-2600, -18000, {}},
    {-2700, -18000, {}},
    {-2800, -18000, {}},
    {-2800, -17900, {}},
    {-2800, -17800, {}},
    {-2800, -17700, {}},
    {-2800, -17600, {}},
    {-2800, -17500, {}},
    {-2800, -17400, {}},
    {-2800, -17300, {}},
    {-2800, -17200, {}},
    {-2800, -17100, {}},
    {-2800, -17000, {}},
    {-2800, -16900, {}},
    {-2800, -16800, {}},
    {-2800, -16700, {}},
    {-2800, -16600, {}},
    {-2800, -16500, {}},
    {-2800, -16400, {}},
    {-2800, -16300, {}},
    {-2700, -16304, {}},
    {-2600, -16308, {}},
    {-2500, -16312, {}},
    {-2400, -16316, {}},
    {-2300, -16320, {}},
    {-2200, -16324, {}},
    {-2100, -16328, {}},
    {-2000, -16332, {}},
    {-1900, -16336, {}},
    {-1800, -16340, {}},
    {-1700, -16344, {}},
    {-1600, -16348, {}},
    {-1500, -16352, {}},
    {-1400, -16356, {}},
    {-1300, -16360, {}},
    {-1263, -16265, {}},
    {-1225, -16170, {}},
    {-1188, -16075, {}},
    {-1150, -15980, {}},
    {-1113, -15885, {}},
    {-1075, -15790, {}},
    {-1038, -15695, {}},
    {-1000, -15600, {}},
    { -900, -15630, {}},
    { -800, -15660, {}},
    { -700, -15690, {}},
    { -600, -15720, {}},
    { -500, -15750, {}},
    { -400, -15780, {}},
    { -300, -15810, {}},
    { -200, -15840, {}},
    { -100, -15870, {}},
    {    0, -15900, {}},
    {    0, -16000, {}},
    {    0, -16100, {}},
    {    0, -16200, {}},
    {    0, -16300, {}},
    {    0, -16400, {}},
    {    0, -16500, {}},
    {    0, -16600, {}},
    {    0, -16700, {}},
    {    0, -16800, {}},
    {    0, -16900, {}},
    {    0, -17000, {}},
    {    0, -17100, {}},
    {    0, -17200, {}},
    {    0, -17300, {}},
    {    0, -17400, {}},
    {    0, -17500, {}},
    {    0, -17600, {}},
    {    0, -17700, {}},
    {    0, -17800, {}},
};

static ZoneVertex ituz63[] = {
    {    0, -15900, {}},
    { -100, -15870, {}},
    { -200, -15840, {}},
    { -300, -15810, {}},
    { -400, -15780, {}},
    { -500, -15750, {}},
    { -600, -15720, {}},
    { -700, -15690, {}},
    { -800, -15660, {}},
    { -900, -15630, {}},
    {-1000, -15600, {}},
    {-1038, -15695, {}},
    {-1075, -15790, {}},
    {-1113, -15885, {}},
    {-1150, -15980, {}},
    {-1188, -16075, {}},
    {-1225, -16170, {}},
    {-1263, -16265, {}},
    {-1300, -16360, {}},
    {-1400, -16356, {}},
    {-1500, -16352, {}},
    {-1600, -16348, {}},
    {-1700, -16344, {}},
    {-1800, -16340, {}},
    {-1900, -16336, {}},
    {-2000, -16332, {}},
    {-2100, -16328, {}},
    {-2200, -16324, {}},
    {-2300, -16320, {}},
    {-2400, -16316, {}},
    {-2500, -16312, {}},
    {-2600, -16308, {}},
    {-2700, -16304, {}},
    {-2800, -16300, {}},
    {-2800, -16200, {}},
    {-2800, -16100, {}},
    {-2800, -16000, {}},
    {-2800, -15900, {}},
    {-2800, -15800, {}},
    {-2800, -15700, {}},
    {-2800, -15600, {}},
    {-2800, -15500, {}},
    {-2800, -15400, {}},
    {-2800, -15300, {}},
    {-2800, -15200, {}},
    {-2800, -15100, {}},
    {-2800, -15000, {}},
    {-2800, -14900, {}},
    {-2800, -14800, {}},
    {-2800, -14700, {}},
    {-2800, -14600, {}},
    {-2800, -14500, {}},
    {-2800, -14400, {}},
    {-2800, -14300, {}},
    {-2800, -14200, {}},
    {-2800, -14100, {}},
    {-2800, -14000, {}},
    {-2800, -13900, {}},
    {-2800, -13800, {}},
    {-2800, -13700, {}},
    {-2800, -13600, {}},
    {-2800, -13500, {}},
    {-2800, -13400, {}},
    {-2800, -13300, {}},
    {-2800, -13200, {}},
    {-2800, -13100, {}},
    {-2800, -13000, {}},
    {-2800, -12900, {}},
    {-2800, -12800, {}},
    {-2800, -12700, {}},
    {-2800, -12600, {}},
    {-2800, -12500, {}},
    {-2800, -12400, {}},
    {-2800, -12300, {}},
    {-2800, -12200, {}},
    {-2800, -12100, {}},
    {-2800, -12000, {}},
    {-2800, -11900, {}},
    {-2800, -11800, {}},
    {-2800, -11700, {}},
    {-2800, -11600, {}},
    {-2800, -11500, {}},
    {-2800, -11400, {}},
    {-2800, -11300, {}},
    {-2800, -11200, {}},
    {-2800, -11100, {}},
    {-2800, -11000, {}},
    {-2800, -10900, {}},
    {-2800, -10800, {}},
    {-2800, -10700, {}},
    {-2700, -10700, {}},
    {-2600, -10700, {}},
    {-2500, -10700, {}},
    {-2400, -10700, {}},
    {-2300, -10700, {}},
    {-2200, -10700, {}},
    {-2100, -10700, {}},
    {-2000, -10700, {}},
    {-1900, -10765, {}},
    {-1800, -10830, {}},
    {-1700, -10895, {}},
    {-1600, -10960, {}},
    {-1500, -11025, {}},
    {-1400, -11090, {}},
    {-1300, -11155, {}},
    {-1200, -11220, {}},
    {-1100, -11285, {}},
    {-1000, -11350, {}},
    { -900, -11415, {}},
    { -800, -11480, {}},
    { -700, -11545, {}},
    { -600, -11610, {}},
    { -500, -11675, {}},
    { -400, -11740, {}},
    { -300, -11805, {}},
    { -200, -11870, {}},
    { -100, -11935, {}},
    {    0, -12000, {}},
    {    0, -12100, {}},
    {    0, -12200, {}},
    {    0, -12300, {}},
    {    0, -12400, {}},
    {    0, -12500, {}},
    {    0, -12600, {}},
    {    0, -12700, {}},
    {    0, -12800, {}},
    {    0, -12900, {}},
    {    0, -13000, {}},
    {    0, -13100, {}},
    {    0, -13200, {}},
    {    0, -13300, {}},
    {    0, -13400, {}},
    {    0, -13500, {}},
    {    0, -13600, {}},
    {    0, -13700, {}},
    {    0, -13800, {}},
    {    0, -13900, {}},
    {    0, -14000, {}},
    {    0, -14100, {}},
    {    0, -14200, {}},
    {    0, -14300, {}},
    {    0, -14400, {}},
    {    0, -14500, {}},
    {    0, -14600, {}},
    {    0, -14700, {}},
    {    0, -14800, {}},
    {    0, -14900, {}},
    {    0, -15000, {}},
    {    0, -15100, {}},
    {    0, -15200, {}},
    {    0, -15300, {}},
    {    0, -15400, {}},
    {    0, -15500, {}},
    {    0, -15600, {}},
    {    0, -15700, {}},
    {    0, -15800, {}},
    {    0, -15900, {}},
};

static ZoneVertex ituz64[] = {
    { 2200, 15000, {}},
    { 2104, 15000, {}},
    { 2009, 15000, {}},
    { 1913, 15000, {}},
    { 1817, 15000, {}},
    { 1722, 15000, {}},
    { 1626, 15000, {}},
    { 1530, 15000, {}},
    { 1435, 15000, {}},
    { 1339, 15000, {}},
    { 1243, 15000, {}},
    { 1148, 15000, {}},
    { 1052, 15000, {}},
    {  957, 15000, {}},
    {  861, 15000, {}},
    {  765, 15000, {}},
    {  670, 15000, {}},
    {  574, 15000, {}},
    {  478, 15000, {}},
    {  383, 15000, {}},
    {  287, 15000, {}},
    {  191, 15000, {}},
    {   96, 15000, {}},
    {    0, 15000, {}},
    {    0, 14900, {}},
    {    0, 14800, {}},
    {    0, 14700, {}},
    {    0, 14600, {}},
    {    0, 14500, {}},
    {    0, 14400, {}},
    {    0, 14300, {}},
    {    0, 14200, {}},
    {    0, 14100, {}},
    {    0, 14000, {}},
    {   26, 13900, {}},
    {   52, 13800, {}},
    {   78, 13700, {}},
    {  104, 13600, {}},
    {  130, 13500, {}},
    {  156, 13400, {}},
    {  182, 13300, {}},
    {  208, 13200, {}},
    {  234, 13100, {}},
    {  260, 13000, {}},
    {  357, 13000, {}},
    {  453, 13000, {}},
    {  550, 13000, {}},
    {  647, 13000, {}},
    {  743, 13000, {}},
    {  840, 13000, {}},
    {  937, 13000, {}},
    { 1033, 13000, {}},
    { 1130, 13000, {}},
    { 1227, 13000, {}},
    { 1323, 13000, {}},
    { 1420, 13000, {}},
    { 1517, 13000, {}},
    { 1613, 13000, {}},
    { 1710, 13000, {}},
    { 1807, 13000, {}},
    { 1903, 13000, {}},
    { 2000, 13000, {}},
    { 2000, 13100, {}},
    { 2000, 13200, {}},
    { 2000, 13300, {}},
    { 2000, 13400, {}},
    { 2000, 13500, {}},
    { 2000, 13600, {}},
    { 2000, 13700, {}},
    { 2000, 13800, {}},
    { 2000, 13900, {}},
    { 2000, 14000, {}},
    { 2100, 14000, {}},
    { 2200, 14000, {}},
    { 2200, 14100, {}},
    { 2200, 14200, {}},
    { 2200, 14300, {}},
    { 2200, 14400, {}},
    { 2200, 14500, {}},
    { 2200, 14600, {}},
    { 2200, 14700, {}},
    { 2200, 14800, {}},
    { 2200, 14900, {}},
    { 2200, 15000, {}},
};

static ZoneVertex ituz65[] = {
    { 2200, 15000, {}},
    { 2200, 15100, {}},
    { 2200, 15200, {}},
    { 2200, 15300, {}},
    { 2200, 15400, {}},
    { 2200, 15500, {}},
    { 2200, 15600, {}},
    { 2200, 15700, {}},
    { 2200, 15800, {}},
    { 2200, 15900, {}},
    { 2200, 16000, {}},
    { 2200, 16100, {}},
    { 2200, 16200, {}},
    { 2200, 16300, {}},
    { 2200, 16400, {}},
    { 2200, 16500, {}},
    { 2200, 16600, {}},
    { 2200, 16700, {}},
    { 2200, 16800, {}},
    { 2200, 16900, {}},
    { 2200, 17000, {}},
    { 2100, 17000, {}},
    { 2000, 17000, {}},
    { 1900, 17000, {}},
    { 1800, 17000, {}},
    { 1700, 17000, {}},
    { 1600, 17000, {}},
    { 1500, 17000, {}},
    { 1500, 17100, {}},
    { 1500, 17200, {}},
    { 1500, 17300, {}},
    { 1500, 17400, {}},
    { 1500, 17500, {}},
    { 1400, 17500, {}},
    { 1300, 17500, {}},
    { 1200, 17500, {}},
    { 1100, 17500, {}},
    { 1000, 17500, {}},
    {  900, 17500, {}},
    {  800, 17500, {}},
    {  700, 17500, {}},
    {  600, 17500, {}},
    {  500, 17500, {}},
    {  400, 17500, {}},
    {  300, 17500, {}},
    {  200, 17500, {}},
    {  100, 17500, {}},
    {    0, 17500, {}},
    {    0, 17600, {}},
    {    0, 17700, {}},
    {    0, 17800, {}},
    {    0, 17900, {}},
    {    0, -18000, {}},
    {    0, -17900, {}},
    {    0, -17800, {}},
    { -100, -17800, {}},
    { -200, -17800, {}},
    { -300, -17800, {}},
    { -400, -17800, {}},
    { -500, -17800, {}},
    { -600, -17800, {}},
    { -700, -17800, {}},
    { -800, -17800, {}},
    { -900, -17800, {}},
    {-1000, -17800, {}},
    {-1100, -17800, {}},
    {-1200, -17800, {}},
    {-1200, -17900, {}},
    {-1200, -18000, {}},
    {-1200, 17900, {}},
    {-1200, 17800, {}},
    {-1200, 17700, {}},
    {-1200, 17600, {}},
    {-1200, 17500, {}},
    {-1200, 17400, {}},
    {-1200, 17300, {}},
    {-1100, 17208, {}},
    {-1000, 17117, {}},
    { -900, 17025, {}},
    { -800, 16933, {}},
    { -700, 16842, {}},
    { -600, 16750, {}},
    { -500, 16658, {}},
    { -400, 16567, {}},
    { -300, 16475, {}},
    { -200, 16383, {}},
    { -100, 16292, {}},
    {    0, 16200, {}},
    {    0, 16100, {}},
    {    0, 16000, {}},
    {    0, 15900, {}},
    {    0, 15800, {}},
    {    0, 15700, {}},
    {    0, 15600, {}},
    {    0, 15500, {}},
    {    0, 15400, {}},
    {    0, 15300, {}},
    {    0, 15200, {}},
    {    0, 15100, {}},
    {    0, 15000, {}},
    {  100, 15000, {}},
    {  200, 15000, {}},
    {  300, 15000, {}},
    {  400, 15000, {}},
    {  500, 15000, {}},
    {  600, 15000, {}},
    {  700, 15000, {}},
    {  800, 15000, {}},
    {  900, 15000, {}},
    { 1000, 15000, {}},
    { 1100, 15000, {}},
    { 1200, 15000, {}},
    { 1300, 15000, {}},
    { 1400, 15000, {}},
    { 1500, 15000, {}},
    { 1600, 15000, {}},
    { 1700, 15000, {}},
    { 1800, 15000, {}},
    { 1900, 15000, {}},
    { 2000, 15000, {}},
    { 2100, 15000, {}},
    { 2200, 15000, {}},
};

static ZoneVertex ituz66[] = {
    {    0, -2800, {}},
    {    0, -2700, {}},
    {    0, -2600, {}},
    {    0, -2500, {}},
    {    0, -2400, {}},
    {    0, -2300, {}},
    {    0, -2200, {}},
    {    0, -2100, {}},
    {    0, -2000, {}},
    {    0, -1900, {}},
    {    0, -1800, {}},
    {    0, -1700, {}},
    {    0, -1600, {}},
    {    0, -1500, {}},
    {    0, -1400, {}},
    {    0, -1300, {}},
    {    0, -1200, {}},
    {    0, -1100, {}},
    {    0, -1000, {}},
    {    0,  -900, {}},
    {    0,  -800, {}},
    {    0,  -700, {}},
    {    0,  -600, {}},
    {    0,  -500, {}},
    {    0,  -400, {}},
    {    0,  -300, {}},
    {    0,  -200, {}},
    {    0,  -100, {}},
    {    0,     0, {}},
    {    0,   100, {}},
    {    0,   200, {}},
    {    0,   300, {}},
    {    0,   400, {}},
    {    0,   500, {}},
    { -100,   500, {}},
    { -200,   500, {}},
    { -300,   500, {}},
    { -400,   500, {}},
    { -500,   500, {}},
    { -600,   500, {}},
    { -700,   500, {}},
    { -800,   500, {}},
    { -900,   500, {}},
    {-1000,   500, {}},
    {-1100,   500, {}},
    {-1200,   500, {}},
    {-1300,   500, {}},
    {-1400,   500, {}},
    {-1500,   500, {}},
    {-1600,   500, {}},
    {-1700,   500, {}},
    {-1800,   500, {}},
    {-1900,   500, {}},
    {-2000,   500, {}},
    {-2100,   500, {}},
    {-2200,   500, {}},
    {-2300,   500, {}},
    {-2400,   500, {}},
    {-2500,   500, {}},
    {-2600,   500, {}},
    {-2700,   500, {}},
    {-2800,   500, {}},
    {-2900,   500, {}},
    {-3000,   500, {}},
    {-3100,   500, {}},
    {-3200,   500, {}},
    {-3300,   500, {}},
    {-3400,   500, {}},
    {-3500,   500, {}},
    {-3600,   500, {}},
    {-3700,   500, {}},
    {-3800,   500, {}},
    {-3900,   500, {}},
    {-4000,   500, {}},
    {-4100,   500, {}},
    {-4200,   500, {}},
    {-4300,   500, {}},
    {-4400,   500, {}},
    {-4500,   500, {}},
    {-4500,   400, {}},
    {-4500,   300, {}},
    {-4500,   200, {}},
    {-4500,   100, {}},
    {-4500,     0, {}},
    {-4500,  -100, {}},
    {-4500,  -200, {}},
    {-4500,  -300, {}},
    {-4500,  -400, {}},
    {-4500,  -500, {}},
    {-4500,  -600, {}},
    {-4500,  -700, {}},
    {-4500,  -800, {}},
    {-4500,  -900, {}},
    {-4500, -1000, {}},
    {-4500, -1100, {}},
    {-4500, -1200, {}},
    {-4500, -1300, {}},
    {-4500, -1400, {}},
    {-4500, -1500, {}},
    {-4500, -1600, {}},
    {-4500, -1700, {}},
    {-4500, -1800, {}},
    {-4500, -1900, {}},
    {-4500, -2000, {}},
    {-4500, -2100, {}},
    {-4500, -2200, {}},
    {-4500, -2300, {}},
    {-4500, -2400, {}},
    {-4500, -2500, {}},
    {-4500, -2600, {}},
    {-4500, -2700, {}},
    {-4500, -2800, {}},
    {-4400, -2800, {}},
    {-4300, -2800, {}},
    {-4200, -2800, {}},
    {-4100, -2800, {}},
    {-4000, -2800, {}},
    {-3900, -2800, {}},
    {-3800, -2800, {}},
    {-3700, -2800, {}},
    {-3600, -2800, {}},
    {-3500, -2800, {}},
    {-3400, -2800, {}},
    {-3300, -2800, {}},
    {-3200, -2800, {}},
    {-3100, -2800, {}},
    {-3000, -2800, {}},
    {-2900, -2800, {}},
    {-2800, -2800, {}},
    {-2700, -2800, {}},
    {-2600, -2800, {}},
    {-2500, -2800, {}},
    {-2400, -2800, {}},
    {-2300, -2800, {}},
    {-2200, -2800, {}},
    {-2100, -2800, {}},
    {-2000, -2800, {}},
    {-1900, -2800, {}},
    {-1800, -2800, {}},
    {-1700, -2800, {}},
    {-1600, -2800, {}},
    {-1500, -2800, {}},
    {-1400, -2800, {}},
    {-1300, -2800, {}},
    {-1200, -2800, {}},
    {-1100, -2800, {}},
    {-1000, -2800, {}},
    { -900, -2800, {}},
    { -800, -2800, {}},
    { -700, -2800, {}},
    { -600, -2800, {}},
    { -500, -2800, {}},
    { -400, -2800, {}},
    { -300, -2800, {}},
    { -200, -2800, {}},
    { -100, -2800, {}},
    {    0, -2800, {}},
};

static ZoneVertex ituz67[] = {
    {-5000, -2000, {}},
    {-5000, -1900, {}},
    {-5000, -1800, {}},
    {-5000, -1700, {}},
    {-5000, -1600, {}},
    {-5000, -1500, {}},
    {-5000, -1400, {}},
    {-5000, -1300, {}},
    {-5000, -1200, {}},
    {-5000, -1100, {}},
    {-5000, -1000, {}},
    {-5000,  -900, {}},
    {-5000,  -800, {}},
    {-5000,  -700, {}},
    {-5000,  -600, {}},
    {-5000,  -500, {}},
    {-5000,  -400, {}},
    {-5000,  -300, {}},
    {-5000,  -200, {}},
    {-5000,  -100, {}},
    {-5000,     0, {}},
    {-5000,   100, {}},
    {-5000,   200, {}},
    {-5000,   300, {}},
    {-5000,   400, {}},
    {-5000,   500, {}},
    {-5000,   600, {}},
    {-5000,   700, {}},
    {-5000,   800, {}},
    {-5000,   900, {}},
    {-5000,  1000, {}},
    {-5000,  1100, {}},
    {-5000,  1200, {}},
    {-5000,  1300, {}},
    {-5000,  1400, {}},
    {-5000,  1500, {}},
    {-5000,  1600, {}},
    {-5000,  1700, {}},
    {-5000,  1800, {}},
    {-5000,  1900, {}},
    {-5000,  2000, {}},
    {-5000,  2100, {}},
    {-5000,  2200, {}},
    {-5000,  2300, {}},
    {-5000,  2400, {}},
    {-5000,  2500, {}},
    {-5000,  2600, {}},
    {-5000,  2700, {}},
    {-5000,  2800, {}},
    {-5000,  2900, {}},
    {-5000,  3000, {}},
    {-5000,  3100, {}},
    {-5000,  3200, {}},
    {-5000,  3300, {}},
    {-5000,  3400, {}},
    {-5000,  3500, {}},
    {-5000,  3600, {}},
    {-5000,  3700, {}},
    {-5000,  3800, {}},
    {-5000,  3900, {}},
    {-5000,  4000, {}},
    {-5100,  4000, {}},
    {-5200,  4000, {}},
    {-5300,  4000, {}},
    {-5400,  4000, {}},
    {-5500,  4000, {}},
    {-5600,  4000, {}},
    {-5700,  4000, {}},
    {-5800,  4000, {}},
    {-5900,  4000, {}},
    {-6000,  4000, {}},
    {-6100,  4000, {}},
    {-6200,  4000, {}},
    {-6300,  4000, {}},
    {-6400,  4000, {}},
    {-6500,  4000, {}},
    {-6600,  4000, {}},
    {-6700,  4000, {}},
    {-6800,  4000, {}},
    {-6900,  4000, {}},
    {-7000,  4000, {}},
    {-7100,  4000, {}},
    {-7200,  4000, {}},
    {-7300,  4000, {}},
    {-7400,  4000, {}},
    {-7500,  4000, {}},
    {-7600,  4000, {}},
    {-7700,  4000, {}},
    {-7800,  4000, {}},
    {-7900,  4000, {}},
    {-8000,  4000, {}},
    {-8000,  3900, {}},
    {-8000,  3800, {}},
    {-8000,  3700, {}},
    {-8000,  3600, {}},
    {-8000,  3500, {}},
    {-8000,  3400, {}},
    {-8000,  3300, {}},
    {-8000,  3200, {}},
    {-8000,  3100, {}},
    {-8000,  3000, {}},
    {-8000,  2900, {}},
    {-8000,  2800, {}},
    {-8000,  2700, {}},
    {-8000,  2600, {}},
    {-8000,  2500, {}},
    {-8000,  2400, {}},
    {-8000,  2300, {}},
    {-8000,  2200, {}},
    {-8000,  2100, {}},
    {-8000,  2000, {}},
    {-8000,  1900, {}},
    {-8000,  1800, {}},
    {-8000,  1700, {}},
    {-8000,  1600, {}},
    {-8000,  1500, {}},
    {-8000,  1400, {}},
    {-8000,  1300, {}},
    {-8000,  1200, {}},
    {-8000,  1100, {}},
    {-8000,  1000, {}},
    {-8000,   900, {}},
    {-8000,   800, {}},
    {-8000,   700, {}},
    {-8000,   600, {}},
    {-8000,   500, {}},
    {-8000,   400, {}},
    {-8000,   300, {}},
    {-8000,   200, {}},
    {-8000,   100, {}},
    {-8000,     0, {}},
    {-8000,  -100, {}},
    {-8000,  -200, {}},
    {-8000,  -300, {}},
    {-8000,  -400, {}},
    {-8000,  -500, {}},
    {-8000,  -600, {}},
    {-8000,  -700, {}},
    {-8000,  -800, {}},
    {-8000,  -900, {}},
    {-8000, -1000, {}},
    {-8000, -1100, {}},
    {-8000, -1200, {}},
    {-8000, -1300, {}},
    {-8000, -1400, {}},
    {-8000, -1500, {}},
    {-8000, -1600, {}},
    {-8000, -1700, {}},
    {-8000, -1800, {}},
    {-8000, -1900, {}},
    {-8000, -2000, {}},
    {-7900, -2000, {}},
    {-7800, -2000, {}},
    {-7700, -2000, {}},
    {-7600, -2000, {}},
    {-7500, -2000, {}},
    {-7400, -2000, {}},
    {-7300, -2000, {}},
    {-7200, -2000, {}},
    {-7100, -2000, {}},
    {-7000, -2000, {}},
    {-6900, -2000, {}},
    {-6800, -2000, {}},
    {-6700, -2000, {}},
    {-6600, -2000, {}},
    {-6500, -2000, {}},
    {-6400, -2000, {}},
    {-6300, -2000, {}},
    {-6200, -2000, {}},
    {-6100, -2000, {}},
    {-6000, -2000, {}},
    {-5900, -2000, {}},
    {-5800, -2000, {}},
    {-5700, -2000, {}},
    {-5600, -2000, {}},
    {-5500, -2000, {}},
    {-5400, -2000, {}},
    {-5300, -2000, {}},
    {-5200, -2000, {}},
    {-5100, -2000, {}},
    {-5000, -2000, {}},
};

static ZoneVertex ituz68[] = {
    {-6000,  4000, {}},
    {-5904,  4000, {}},
    {-5808,  4000, {}},
    {-5712,  4000, {}},
    {-5615,  4000, {}},
    {-5519,  4000, {}},
    {-5423,  4000, {}},
    {-5327,  4000, {}},
    {-5231,  4000, {}},
    {-5135,  4000, {}},
    {-5038,  4000, {}},
    {-4942,  4000, {}},
    {-4846,  4000, {}},
    {-4750,  4000, {}},
    {-4654,  4000, {}},
    {-4558,  4000, {}},
    {-4462,  4000, {}},
    {-4365,  4000, {}},
    {-4269,  4000, {}},
    {-4173,  4000, {}},
    {-4077,  4000, {}},
    {-3981,  4000, {}},
    {-3885,  4000, {}},
    {-3788,  4000, {}},
    {-3692,  4000, {}},
    {-3596,  4000, {}},
    {-3500,  4000, {}},
    {-3500,  4100, {}},
    {-3500,  4200, {}},
    {-3500,  4300, {}},
    {-3500,  4400, {}},
    {-3500,  4500, {}},
    {-3500,  4600, {}},
    {-3500,  4700, {}},
    {-3500,  4800, {}},
    {-3500,  4900, {}},
    {-3500,  5000, {}},
    {-3500,  5100, {}},
    {-3500,  5200, {}},
    {-3500,  5300, {}},
    {-3500,  5400, {}},
    {-3500,  5500, {}},
    {-3500,  5600, {}},
    {-3500,  5700, {}},
    {-3500,  5800, {}},
    {-3500,  5900, {}},
    {-3500,  6000, {}},
    {-3500,  6100, {}},
    {-3500,  6200, {}},
    {-3500,  6300, {}},
    {-3500,  6400, {}},
    {-3500,  6500, {}},
    {-3500,  6600, {}},
    {-3500,  6700, {}},
    {-3500,  6800, {}},
    {-3500,  6900, {}},
    {-3500,  7000, {}},
    {-3500,  7100, {}},
    {-3500,  7200, {}},
    {-3500,  7300, {}},
    {-3500,  7400, {}},
    {-3500,  7500, {}},
    {-3500,  7600, {}},
    {-3500,  7700, {}},
    {-3500,  7800, {}},
    {-3500,  7900, {}},
    {-3500,  8000, {}},
    {-3600,  8000, {}},
    {-3700,  8000, {}},
    {-3800,  8000, {}},
    {-3900,  8000, {}},
    {-4000,  8000, {}},
    {-4100,  8000, {}},
    {-4200,  8000, {}},
    {-4300,  8000, {}},
    {-4400,  8000, {}},
    {-4500,  8000, {}},
    {-4600,  8000, {}},
    {-4700,  8000, {}},
    {-4800,  8000, {}},
    {-4900,  8000, {}},
    {-5000,  8000, {}},
    {-5100,  8000, {}},
    {-5200,  8000, {}},
    {-5300,  8000, {}},
    {-5400,  8000, {}},
    {-5500,  8000, {}},
    {-5600,  8000, {}},
    {-5700,  8000, {}},
    {-5800,  8000, {}},
    {-5900,  8000, {}},
    {-6000,  8000, {}},
    {-6000,  7900, {}},
    {-6000,  7800, {}},
    {-6000,  7700, {}},
    {-6000,  7600, {}},
    {-6000,  7500, {}},
    {-6000,  7400, {}},
    {-6000,  7300, {}},
    {-6000,  7200, {}},
    {-6000,  7100, {}},
    {-6000,  7000, {}},
    {-6000,  6900, {}},
    {-6000,  6800, {}},
    {-6000,  6700, {}},
    {-6000,  6600, {}},
    {-6000,  6500, {}},
    {-6000,  6400, {}},
    {-6000,  6300, {}},
    {-6000,  6200, {}},
    {-6000,  6100, {}},
    {-6000,  6000, {}},
    {-6000,  5900, {}},
    {-6000,  5800, {}},
    {-6000,  5700, {}},
    {-6000,  5600, {}},
    {-6000,  5500, {}},
    {-6000,  5400, {}},
    {-6000,  5300, {}},
    {-6000,  5200, {}},
    {-6000,  5100, {}},
    {-6000,  5000, {}},
    {-6000,  4900, {}},
    {-6000,  4800, {}},
    {-6000,  4700, {}},
    {-6000,  4600, {}},
    {-6000,  4500, {}},
    {-6000,  4400, {}},
    {-6000,  4300, {}},
    {-6000,  4200, {}},
    {-6000,  4100, {}},
    {-6000,  4000, {}},
};

static ZoneVertex ituz69[] = {
    {-6000,  4000, {}},
    {-6000,  4100, {}},
    {-6000,  4200, {}},
    {-6000,  4300, {}},
    {-6000,  4400, {}},
    {-6000,  4500, {}},
    {-6000,  4600, {}},
    {-6000,  4700, {}},
    {-6000,  4800, {}},
    {-6000,  4900, {}},
    {-6000,  5000, {}},
    {-6000,  5100, {}},
    {-6000,  5200, {}},
    {-6000,  5300, {}},
    {-6000,  5400, {}},
    {-6000,  5500, {}},
    {-6000,  5600, {}},
    {-6000,  5700, {}},
    {-6000,  5800, {}},
    {-6000,  5900, {}},
    {-6000,  6000, {}},
    {-6000,  6100, {}},
    {-6000,  6200, {}},
    {-6000,  6300, {}},
    {-6000,  6400, {}},
    {-6000,  6500, {}},
    {-6000,  6600, {}},
    {-6000,  6700, {}},
    {-6000,  6800, {}},
    {-6000,  6900, {}},
    {-6000,  7000, {}},
    {-6000,  7100, {}},
    {-6000,  7200, {}},
    {-6000,  7300, {}},
    {-6000,  7400, {}},
    {-6000,  7500, {}},
    {-6000,  7600, {}},
    {-6000,  7700, {}},
    {-6000,  7800, {}},
    {-6000,  7900, {}},
    {-6000,  8000, {}},
    {-6000,  8100, {}},
    {-6000,  8200, {}},
    {-6000,  8300, {}},
    {-6000,  8400, {}},
    {-6000,  8500, {}},
    {-6000,  8600, {}},
    {-6000,  8700, {}},
    {-6000,  8800, {}},
    {-6000,  8900, {}},
    {-6000,  9000, {}},
    {-6000,  9100, {}},
    {-6000,  9200, {}},
    {-6000,  9300, {}},
    {-6000,  9400, {}},
    {-6000,  9500, {}},
    {-6000,  9600, {}},
    {-6000,  9700, {}},
    {-6000,  9800, {}},
    {-6000,  9900, {}},
    {-6000, 10000, {}},
    {-6100, 10000, {}},
    {-6200, 10000, {}},
    {-6300, 10000, {}},
    {-6400, 10000, {}},
    {-6500, 10000, {}},
    {-6600, 10000, {}},
    {-6700, 10000, {}},
    {-6800, 10000, {}},
    {-6900, 10000, {}},
    {-7000, 10000, {}},
    {-7100, 10000, {}},
    {-7200, 10000, {}},
    {-7300, 10000, {}},
    {-7400, 10000, {}},
    {-7500, 10000, {}},
    {-7600, 10000, {}},
    {-7700, 10000, {}},
    {-7800, 10000, {}},
    {-7900, 10000, {}},
    {-8000, 10000, {}},
    {-8000,  9900, {}},
    {-8000,  9800, {}},
    {-8000,  9700, {}},
    {-8000,  9600, {}},
    {-8000,  9500, {}},
    {-8000,  9400, {}},
    {-8000,  9300, {}},
    {-8000,  9200, {}},
    {-8000,  9100, {}},
    {-8000,  9000, {}},
    {-8000,  8900, {}},
    {-8000,  8800, {}},
    {-8000,  8700, {}},
    {-8000,  8600, {}},
    {-8000,  8500, {}},
    {-8000,  8400, {}},
    {-8000,  8300, {}},
    {-8000,  8200, {}},
    {-8000,  8100, {}},
    {-8000,  8000, {}},
    {-8000,  7900, {}},
    {-8000,  7800, {}},
    {-8000,  7700, {}},
    {-8000,  7600, {}},
    {-8000,  7500, {}},
    {-8000,  7400, {}},
    {-8000,  7300, {}},
    {-8000,  7200, {}},
    {-8000,  7100, {}},
    {-8000,  7000, {}},
    {-8000,  6900, {}},
    {-8000,  6800, {}},
    {-8000,  6700, {}},
    {-8000,  6600, {}},
    {-8000,  6500, {}},
    {-8000,  6400, {}},
    {-8000,  6300, {}},
    {-8000,  6200, {}},
    {-8000,  6100, {}},
    {-8000,  6000, {}},
    {-8000,  5900, {}},
    {-8000,  5800, {}},
    {-8000,  5700, {}},
    {-8000,  5600, {}},
    {-8000,  5500, {}},
    {-8000,  5400, {}},
    {-8000,  5300, {}},
    {-8000,  5200, {}},
    {-8000,  5100, {}},
    {-8000,  5000, {}},
    {-8000,  4900, {}},
    {-8000,  4800, {}},
    {-8000,  4700, {}},
    {-8000,  4600, {}},
    {-8000,  4500, {}},
    {-8000,  4400, {}},
    {-8000,  4300, {}},
    {-8000,  4200, {}},
    {-8000,  4100, {}},
    {-8000,  4000, {}},
    {-7900,  4000, {}},
    {-7800,  4000, {}},
    {-7700,  4000, {}},
    {-7600,  4000, {}},
    {-7500,  4000, {}},
    {-7400,  4000, {}},
    {-7300,  4000, {}},
    {-7200,  4000, {}},
    {-7100,  4000, {}},
    {-7000,  4000, {}},
    {-6900,  4000, {}},
    {-6800,  4000, {}},
    {-6700,  4000, {}},
    {-6600,  4000, {}},
    {-6500,  4000, {}},
    {-6400,  4000, {}},
    {-6300,  4000, {}},
    {-6200,  4000, {}},
    {-6100,  4000, {}},
    {-6000,  4000, {}},
};

static ZoneVertex ituz70[] = {
    {-6000, 10000, {}},
    {-6000, 10100, {}},
    {-6000, 10200, {}},
    {-6000, 10300, {}},
    {-6000, 10400, {}},
    {-6000, 10500, {}},
    {-6000, 10600, {}},
    {-6000, 10700, {}},
    {-6000, 10800, {}},
    {-6000, 10900, {}},
    {-6000, 11000, {}},
    {-6000, 11100, {}},
    {-6000, 11200, {}},
    {-6000, 11300, {}},
    {-6000, 11400, {}},
    {-6000, 11500, {}},
    {-6000, 11600, {}},
    {-6000, 11700, {}},
    {-6000, 11800, {}},
    {-6000, 11900, {}},
    {-6000, 12000, {}},
    {-6000, 12100, {}},
    {-6000, 12200, {}},
    {-6000, 12300, {}},
    {-6000, 12400, {}},
    {-6000, 12500, {}},
    {-6000, 12600, {}},
    {-6000, 12700, {}},
    {-6000, 12800, {}},
    {-6000, 12900, {}},
    {-6000, 13000, {}},
    {-6000, 13100, {}},
    {-6000, 13200, {}},
    {-6000, 13300, {}},
    {-6000, 13400, {}},
    {-6000, 13500, {}},
    {-6000, 13600, {}},
    {-6000, 13700, {}},
    {-6000, 13800, {}},
    {-6000, 13900, {}},
    {-6000, 14000, {}},
    {-6000, 14100, {}},
    {-6000, 14200, {}},
    {-6000, 14300, {}},
    {-6000, 14400, {}},
    {-6000, 14500, {}},
    {-6000, 14600, {}},
    {-6000, 14700, {}},
    {-6000, 14800, {}},
    {-6000, 14900, {}},
    {-6000, 15000, {}},
    {-6000, 15100, {}},
    {-6000, 15200, {}},
    {-6000, 15300, {}},
    {-6000, 15400, {}},
    {-6000, 15500, {}},
    {-6000, 15600, {}},
    {-6000, 15700, {}},
    {-6000, 15800, {}},
    {-6000, 15900, {}},
    {-6000, 16000, {}},
    {-6100, 16000, {}},
    {-6200, 16000, {}},
    {-6300, 16000, {}},
    {-6400, 16000, {}},
    {-6500, 16000, {}},
    {-6600, 16000, {}},
    {-6700, 16000, {}},
    {-6800, 16000, {}},
    {-6900, 16000, {}},
    {-7000, 16000, {}},
    {-7100, 16000, {}},
    {-7200, 16000, {}},
    {-7300, 16000, {}},
    {-7400, 16000, {}},
    {-7500, 16000, {}},
    {-7600, 16000, {}},
    {-7700, 16000, {}},
    {-7800, 16000, {}},
    {-7900, 16000, {}},
    {-8000, 16000, {}},
    {-8000, 15900, {}},
    {-8000, 15800, {}},
    {-8000, 15700, {}},
    {-8000, 15600, {}},
    {-8000, 15500, {}},
    {-8000, 15400, {}},
    {-8000, 15300, {}},
    {-8000, 15200, {}},
    {-8000, 15100, {}},
    {-8000, 15000, {}},
    {-8000, 14900, {}},
    {-8000, 14800, {}},
    {-8000, 14700, {}},
    {-8000, 14600, {}},
    {-8000, 14500, {}},
    {-8000, 14400, {}},
    {-8000, 14300, {}},
    {-8000, 14200, {}},
    {-8000, 14100, {}},
    {-8000, 14000, {}},
    {-8000, 13900, {}},
    {-8000, 13800, {}},
    {-8000, 13700, {}},
    {-8000, 13600, {}},
    {-8000, 13500, {}},
    {-8000, 13400, {}},
    {-8000, 13300, {}},
    {-8000, 13200, {}},
    {-8000, 13100, {}},
    {-8000, 13000, {}},
    {-8000, 12900, {}},
    {-8000, 12800, {}},
    {-8000, 12700, {}},
    {-8000, 12600, {}},
    {-8000, 12500, {}},
    {-8000, 12400, {}},
    {-8000, 12300, {}},
    {-8000, 12200, {}},
    {-8000, 12100, {}},
    {-8000, 12000, {}},
    {-8000, 11900, {}},
    {-8000, 11800, {}},
    {-8000, 11700, {}},
    {-8000, 11600, {}},
    {-8000, 11500, {}},
    {-8000, 11400, {}},
    {-8000, 11300, {}},
    {-8000, 11200, {}},
    {-8000, 11100, {}},
    {-8000, 11000, {}},
    {-8000, 10900, {}},
    {-8000, 10800, {}},
    {-8000, 10700, {}},
    {-8000, 10600, {}},
    {-8000, 10500, {}},
    {-8000, 10400, {}},
    {-8000, 10300, {}},
    {-8000, 10200, {}},
    {-8000, 10100, {}},
    {-8000, 10000, {}},
    {-7900, 10000, {}},
    {-7800, 10000, {}},
    {-7700, 10000, {}},
    {-7600, 10000, {}},
    {-7500, 10000, {}},
    {-7400, 10000, {}},
    {-7300, 10000, {}},
    {-7200, 10000, {}},
    {-7100, 10000, {}},
    {-7000, 10000, {}},
    {-6900, 10000, {}},
    {-6800, 10000, {}},
    {-6700, 10000, {}},
    {-6600, 10000, {}},
    {-6500, 10000, {}},
    {-6400, 10000, {}},
    {-6300, 10000, {}},
    {-6200, 10000, {}},
    {-6100, 10000, {}},
    {-6000, 10000, {}},
};

static ZoneVertex ituz71[] = {
    {-6000, 16000, {}},
    {-6000, 16100, {}},
    {-6000, 16200, {}},
    {-6000, 16300, {}},
    {-6000, 16400, {}},
    {-6000, 16500, {}},
    {-6000, 16600, {}},
    {-6000, 16700, {}},
    {-6000, 16800, {}},
    {-6000, 16900, {}},
    {-6000, 17000, {}},
    {-6000, 17100, {}},
    {-6000, 17200, {}},
    {-6000, 17300, {}},
    {-6000, 17400, {}},
    {-6000, 17500, {}},
    {-6000, 17600, {}},
    {-6000, 17700, {}},
    {-6000, 17800, {}},
    {-6000, 17900, {}},
    {-6000, -18000, {}},
    {-6000, -17900, {}},
    {-6000, -17800, {}},
    {-6000, -17700, {}},
    {-6000, -17600, {}},
    {-6000, -17500, {}},
    {-6000, -17400, {}},
    {-6000, -17300, {}},
    {-6000, -17200, {}},
    {-6000, -17100, {}},
    {-6000, -17000, {}},
    {-6000, -16900, {}},
    {-6000, -16800, {}},
    {-6000, -16700, {}},
    {-6000, -16600, {}},
    {-6000, -16500, {}},
    {-6000, -16400, {}},
    {-6000, -16300, {}},
    {-6000, -16200, {}},
    {-6000, -16100, {}},
    {-6000, -16000, {}},
    {-6000, -15900, {}},
    {-6000, -15800, {}},
    {-6000, -15700, {}},
    {-6000, -15600, {}},
    {-6000, -15500, {}},
    {-6000, -15400, {}},
    {-6000, -15300, {}},
    {-6000, -15200, {}},
    {-6000, -15100, {}},
    {-6000, -15000, {}},
    {-6000, -14900, {}},
    {-6000, -14800, {}},
    {-6000, -14700, {}},
    {-6000, -14600, {}},
    {-6000, -14500, {}},
    {-6000, -14400, {}},
    {-6000, -14300, {}},
    {-6000, -14200, {}},
    {-6000, -14100, {}},
    {-6000, -14000, {}},
    {-6100, -14000, {}},
    {-6200, -14000, {}},
    {-6300, -14000, {}},
    {-6400, -14000, {}},
    {-6500, -14000, {}},
    {-6600, -14000, {}},
    {-6700, -14000, {}},
    {-6800, -14000, {}},
    {-6900, -14000, {}},
    {-7000, -14000, {}},
    {-7100, -14000, {}},
    {-7200, -14000, {}},
    {-7300, -14000, {}},
    {-7400, -14000, {}},
    {-7500, -14000, {}},
    {-7600, -14000, {}},
    {-7700, -14000, {}},
    {-7800, -14000, {}},
    {-7900, -14000, {}},
    {-8000, -14000, {}},
    {-8000, -14100, {}},
    {-8000, -14200, {}},
    {-8000, -14300, {}},
    {-8000, -14400, {}},
    {-8000, -14500, {}},
    {-8000, -14600, {}},
    {-8000, -14700, {}},
    {-8000, -14800, {}},
    {-8000, -14900, {}},
    {-8000, -15000, {}},
    {-8000, -15100, {}},
    {-8000, -15200, {}},
    {-8000, -15300, {}},
    {-8000, -15400, {}},
    {-8000, -15500, {}},
    {-8000, -15600, {}},
    {-8000, -15700, {}},
    {-8000, -15800, {}},
    {-8000, -15900, {}},
    {-8000, -16000, {}},
    {-8000, -16100, {}},
    {-8000, -16200, {}},
    {-8000, -16300, {}},
    {-8000, -16400, {}},
    {-8000, -16500, {}},
    {-8000, -16600, {}},
    {-8000, -16700, {}},
    {-8000, -16800, {}},
    {-8000, -16900, {}},
    {-8000, -17000, {}},
    {-8000, -17100, {}},
    {-8000, -17200, {}},
    {-8000, -17300, {}},
    {-8000, -17400, {}},
    {-8000, -17500, {}},
    {-8000, -17600, {}},
    {-8000, -17700, {}},
    {-8000, -17800, {}},
    {-8000, -17900, {}},
    {-8000, -18000, {}},
    {-8000, 17900, {}},
    {-8000, 17800, {}},
    {-8000, 17700, {}},
    {-8000, 17600, {}},
    {-8000, 17500, {}},
    {-8000, 17400, {}},
    {-8000, 17300, {}},
    {-8000, 17200, {}},
    {-8000, 17100, {}},
    {-8000, 17000, {}},
    {-8000, 16900, {}},
    {-8000, 16800, {}},
    {-8000, 16700, {}},
    {-8000, 16600, {}},
    {-8000, 16500, {}},
    {-8000, 16400, {}},
    {-8000, 16300, {}},
    {-8000, 16200, {}},
    {-8000, 16100, {}},
    {-8000, 16000, {}},
    {-7900, 16000, {}},
    {-7800, 16000, {}},
    {-7700, 16000, {}},
    {-7600, 16000, {}},
    {-7500, 16000, {}},
    {-7400, 16000, {}},
    {-7300, 16000, {}},
    {-7200, 16000, {}},
    {-7100, 16000, {}},
    {-7000, 16000, {}},
    {-6900, 16000, {}},
    {-6800, 16000, {}},
    {-6700, 16000, {}},
    {-6600, 16000, {}},
    {-6500, 16000, {}},
    {-6400, 16000, {}},
    {-6300, 16000, {}},
    {-6200, 16000, {}},
    {-6100, 16000, {}},
    {-6000, 16000, {}},
};

static ZoneVertex ituz72[] = {
    {-6000, -14000, {}},
    {-6000, -13900, {}},
    {-6000, -13800, {}},
    {-6000, -13700, {}},
    {-6000, -13600, {}},
    {-6000, -13500, {}},
    {-6000, -13400, {}},
    {-6000, -13300, {}},
    {-6000, -13200, {}},
    {-6000, -13100, {}},
    {-6000, -13000, {}},
    {-6000, -12900, {}},
    {-6000, -12800, {}},
    {-6000, -12700, {}},
    {-6000, -12600, {}},
    {-6000, -12500, {}},
    {-6000, -12400, {}},
    {-6000, -12300, {}},
    {-6000, -12200, {}},
    {-6000, -12100, {}},
    {-6000, -12000, {}},
    {-6000, -11900, {}},
    {-6000, -11800, {}},
    {-6000, -11700, {}},
    {-6000, -11600, {}},
    {-6000, -11500, {}},
    {-6000, -11400, {}},
    {-6000, -11300, {}},
    {-6000, -11200, {}},
    {-6000, -11100, {}},
    {-6000, -11000, {}},
    {-6000, -10900, {}},
    {-6000, -10800, {}},
    {-6000, -10700, {}},
    {-6000, -10600, {}},
    {-6000, -10500, {}},
    {-6000, -10400, {}},
    {-6000, -10300, {}},
    {-6000, -10200, {}},
    {-6000, -10100, {}},
    {-6000, -10000, {}},
    {-6000, -9900, {}},
    {-6000, -9800, {}},
    {-6000, -9700, {}},
    {-6000, -9600, {}},
    {-6000, -9500, {}},
    {-6000, -9400, {}},
    {-6000, -9300, {}},
    {-6000, -9200, {}},
    {-6000, -9100, {}},
    {-6000, -9000, {}},
    {-6000, -8900, {}},
    {-6000, -8800, {}},
    {-6000, -8700, {}},
    {-6000, -8600, {}},
    {-6000, -8500, {}},
    {-6000, -8400, {}},
    {-6000, -8300, {}},
    {-6000, -8200, {}},
    {-6000, -8100, {}},
    {-6000, -8000, {}},
    {-6100, -8000, {}},
    {-6200, -8000, {}},
    {-6300, -8000, {}},
    {-6400, -8000, {}},
    {-6500, -8000, {}},
    {-6600, -8000, {}},
    {-6700, -8000, {}},
    {-6800, -8000, {}},
    {-6900, -8000, {}},
    {-7000, -8000, {}},
    {-7100, -8000, {}},
    {-7200, -8000, {}},
    {-7300, -8000, {}},
    {-7400, -8000, {}},
    {-7500, -8000, {}},
    {-7600, -8000, {}},
    {-7700, -8000, {}},
    {-7800, -8000, {}},
    {-7900, -8000, {}},
    {-8000, -8000, {}},
    {-8000, -8100, {}},
    {-8000, -8200, {}},
    {-8000, -8300, {}},
    {-8000, -8400, {}},
    {-8000, -8500, {}},
    {-8000, -8600, {}},
    {-8000, -8700, {}},
    {-8000, -8800, {}},
    {-8000, -8900, {}},
    {-8000, -9000, {}},
    {-8000, -9100, {}},
    {-8000, -9200, {}},
    {-8000, -9300, {}},
    {-8000, -9400, {}},
    {-8000, -9500, {}},
    {-8000, -9600, {}},
    {-8000, -9700, {}},
    {-8000, -9800, {}},
    {-8000, -9900, {}},
    {-8000, -10000, {}},
    {-8000, -10100, {}},
    {-8000, -10200, {}},
    {-8000, -10300, {}},
    {-8000, -10400, {}},
    {-8000, -10500, {}},
    {-8000, -10600, {}},
    {-8000, -10700, {}},
    {-8000, -10800, {}},
    {-8000, -10900, {}},
    {-8000, -11000, {}},
    {-8000, -11100, {}},
    {-8000, -11200, {}},
    {-8000, -11300, {}},
    {-8000, -11400, {}},
    {-8000, -11500, {}},
    {-8000, -11600, {}},
    {-8000, -11700, {}},
    {-8000, -11800, {}},
    {-8000, -11900, {}},
    {-8000, -12000, {}},
    {-8000, -12100, {}},
    {-8000, -12200, {}},
    {-8000, -12300, {}},
    {-8000, -12400, {}},
    {-8000, -12500, {}},
    {-8000, -12600, {}},
    {-8000, -12700, {}},
    {-8000, -12800, {}},
    {-8000, -12900, {}},
    {-8000, -13000, {}},
    {-8000, -13100, {}},
    {-8000, -13200, {}},
    {-8000, -13300, {}},
    {-8000, -13400, {}},
    {-8000, -13500, {}},
    {-8000, -13600, {}},
    {-8000, -13700, {}},
    {-8000, -13800, {}},
    {-8000, -13900, {}},
    {-8000, -14000, {}},
    {-7900, -14000, {}},
    {-7800, -14000, {}},
    {-7700, -14000, {}},
    {-7600, -14000, {}},
    {-7500, -14000, {}},
    {-7400, -14000, {}},
    {-7300, -14000, {}},
    {-7200, -14000, {}},
    {-7100, -14000, {}},
    {-7000, -14000, {}},
    {-6900, -14000, {}},
    {-6800, -14000, {}},
    {-6700, -14000, {}},
    {-6600, -14000, {}},
    {-6500, -14000, {}},
    {-6400, -14000, {}},
    {-6300, -14000, {}},
    {-6200, -14000, {}},
    {-6100, -14000, {}},
    {-6000, -14000, {}},
};

static ZoneVertex ituz73[] = {
    {-6000, -8000, {}},
    {-6000, -7900, {}},
    {-6000, -7800, {}},
    {-6000, -7700, {}},
    {-6000, -7600, {}},
    {-6000, -7500, {}},
    {-6000, -7400, {}},
    {-6000, -7300, {}},
    {-6000, -7200, {}},
    {-6000, -7100, {}},
    {-6000, -7000, {}},
    {-6000, -6900, {}},
    {-6000, -6800, {}},
    {-6000, -6700, {}},
    {-6000, -6600, {}},
    {-6000, -6500, {}},
    {-6000, -6400, {}},
    {-6000, -6300, {}},
    {-6000, -6200, {}},
    {-6000, -6100, {}},
    {-6000, -6000, {}},
    {-6000, -5900, {}},
    {-6000, -5800, {}},
    {-6000, -5700, {}},
    {-6000, -5600, {}},
    {-6000, -5500, {}},
    {-5900, -5500, {}},
    {-5800, -5500, {}},
    {-5700, -5500, {}},
    {-5600, -5500, {}},
    {-5500, -5500, {}},
    {-5400, -5500, {}},
    {-5300, -5500, {}},
    {-5200, -5500, {}},
    {-5100, -5500, {}},
    {-5000, -5500, {}},
    {-5000, -5400, {}},
    {-5000, -5300, {}},
    {-5000, -5200, {}},
    {-5000, -5100, {}},
    {-5000, -5000, {}},
    {-5000, -4900, {}},
    {-5000, -4800, {}},
    {-5000, -4700, {}},
    {-5000, -4600, {}},
    {-5000, -4500, {}},
    {-5000, -4400, {}},
    {-5000, -4300, {}},
    {-5000, -4200, {}},
    {-5000, -4100, {}},
    {-5000, -4000, {}},
    {-5000, -3900, {}},
    {-5000, -3800, {}},
    {-5000, -3700, {}},
    {-5000, -3600, {}},
    {-5000, -3500, {}},
    {-5000, -3400, {}},
    {-5000, -3300, {}},
    {-5000, -3200, {}},
    {-5000, -3100, {}},
    {-5000, -3000, {}},
    {-5000, -2900, {}},
    {-5000, -2800, {}},
    {-5000, -2700, {}},
    {-5000, -2600, {}},
    {-5000, -2500, {}},
    {-5000, -2400, {}},
    {-5000, -2300, {}},
    {-5000, -2200, {}},
    {-5000, -2100, {}},
    {-5000, -2000, {}},
    {-5100, -2000, {}},
    {-5200, -2000, {}},
    {-5300, -2000, {}},
    {-5400, -2000, {}},
    {-5500, -2000, {}},
    {-5600, -2000, {}},
    {-5700, -2000, {}},
    {-5800, -2000, {}},
    {-5900, -2000, {}},
    {-6000, -2000, {}},
    {-6100, -2000, {}},
    {-6200, -2000, {}},
    {-6300, -2000, {}},
    {-6400, -2000, {}},
    {-6500, -2000, {}},
    {-6600, -2000, {}},
    {-6700, -2000, {}},
    {-6800, -2000, {}},
    {-6900, -2000, {}},
    {-7000, -2000, {}},
    {-7100, -2000, {}},
    {-7200, -2000, {}},
    {-7300, -2000, {}},
    {-7400, -2000, {}},
    {-7500, -2000, {}},
    {-7600, -2000, {}},
    {-7700, -2000, {}},
    {-7800, -2000, {}},
    {-7900, -2000, {}},
    {-8000, -2000, {}},
    {-8000, -2100, {}},
    {-8000, -2200, {}},
    {-8000, -2300, {}},
    {-8000, -2400, {}},
    {-8000, -2500, {}},
    {-8000, -2600, {}},
    {-8000, -2700, {}},
    {-8000, -2800, {}},
    {-8000, -2900, {}},
    {-8000, -3000, {}},
    {-8000, -3100, {}},
    {-8000, -3200, {}},
    {-8000, -3300, {}},
    {-8000, -3400, {}},
    {-8000, -3500, {}},
    {-8000, -3600, {}},
    {-8000, -3700, {}},
    {-8000, -3800, {}},
    {-8000, -3900, {}},
    {-8000, -4000, {}},
    {-8000, -4100, {}},
    {-8000, -4200, {}},
    {-8000, -4300, {}},
    {-8000, -4400, {}},
    {-8000, -4500, {}},
    {-8000, -4600, {}},
    {-8000, -4700, {}},
    {-8000, -4800, {}},
    {-8000, -4900, {}},
    {-8000, -5000, {}},
    {-8000, -5100, {}},
    {-8000, -5200, {}},
    {-8000, -5300, {}},
    {-8000, -5400, {}},
    {-8000, -5500, {}},
    {-8000, -5600, {}},
    {-8000, -5700, {}},
    {-8000, -5800, {}},
    {-8000, -5900, {}},
    {-8000, -6000, {}},
    {-8000, -6100, {}},
    {-8000, -6200, {}},
    {-8000, -6300, {}},
    {-8000, -6400, {}},
    {-8000, -6500, {}},
    {-8000, -6600, {}},
    {-8000, -6700, {}},
    {-8000, -6800, {}},
    {-8000, -6900, {}},
    {-8000, -7000, {}},
    {-8000, -7100, {}},
    {-8000, -7200, {}},
    {-8000, -7300, {}},
    {-8000, -7400, {}},
    {-8000, -7500, {}},
    {-8000, -7600, {}},
    {-8000, -7700, {}},
    {-8000, -7800, {}},
    {-8000, -7900, {}},
    {-8000, -8000, {}},
    {-7900, -8000, {}},
    {-7800, -8000, {}},
    {-7700, -8000, {}},
    {-7600, -8000, {}},
    {-7500, -8000, {}},
    {-7400, -8000, {}},
    {-7300, -8000, {}},
    {-7200, -8000, {}},
    {-7100, -8000, {}},
    {-7000, -8000, {}},
    {-6900, -8000, {}},
    {-6800, -8000, {}},
    {-6700, -8000, {}},
    {-6600, -8000, {}},
    {-6500, -8000, {}},
    {-6400, -8000, {}},
    {-6300, -8000, {}},
    {-6200, -8000, {}},
    {-6100, -8000, {}},
    {-6000, -8000, {}},
};

static ZoneVertex ituz74[] = {
    {-8000, -18000, {}},
    {-8000, -17000, {}},
    {-8000, -16000, {}},
    {-8000, -15000, {}},
    {-8000, -14000, {}},
    {-8000, -13000, {}},
    {-8000, -12000, {}},
    {-8000, -11000, {}},
    {-8000, -10000, {}},
    {-8000, -9000, {}},
    {-8000, -8000, {}},
    {-8000, -7000, {}},
    {-8000, -6000, {}},
    {-8000, -5000, {}},
    {-8000, -4000, {}},
    {-8000, -3000, {}},
    {-8000, -2000, {}},
    {-8000, -1000, {}},
    {-8000,     0, {}},
    {-8000,  1000, {}},
    {-8000,  2000, {}},
    {-8000,  3000, {}},
    {-8000,  4000, {}},
    {-8000,  5000, {}},
    {-8000,  6000, {}},
    {-8000,  7000, {}},
    {-8000,  8000, {}},
    {-8000,  9000, {}},
    {-8000, 10000, {}},
    {-8000, 11000, {}},
    {-8000, 12000, {}},
    {-8000, 13000, {}},
    {-8000, 14000, {}},
    {-8000, 15000, {}},
    {-8000, 16000, {}},
    {-8000, 17000, {}},
    {-8000, 18000, {}},
};

static ZoneVertex ituz75[] = {
    { 8000, -18000, {}},
    { 8000, -17000, {}},
    { 8000, -16000, {}},
    { 8000, -15000, {}},
    { 8000, -14000, {}},
    { 8000, -13000, {}},
    { 8000, -12000, {}},
    { 8000, -11000, {}},
    { 8000, -10000, {}},
    { 8000, -9000, {}},
    { 8000, -8000, {}},
    { 8000, -7000, {}},
    { 8000, -6000, {}},
    { 8000, -5000, {}},
    { 8000, -4000, {}},
    { 8000, -3000, {}},
    { 8000, -2000, {}},
    { 8000, -1000, {}},
    { 8000,     0, {}},
    { 8000,  1000, {}},
    { 8000,  2000, {}},
    { 8000,  3000, {}},
    { 8000,  4000, {}},
    { 8000,  5000, {}},
    { 8000,  6000, {}},
    { 8000,  7000, {}},
    { 8000,  8000, {}},
    { 8000,  9000, {}},
    { 8000, 10000, {}},
    { 8000, 11000, {}},
    { 8000, 12000, {}},
    { 8000, 13000, {}},
    { 8000, 14000, {}},
    { 8000, 15000, {}},
    { 8000, 16000, {}},
    { 8000, 17000, {}},
    { 8000, 18000, {}},
};

static ZoneVertex ituz76[] = {
    { 3000, -17500, {}},
    { 3000, -17400, {}},
    { 3000, -17301, {}},
    { 3000, -17201, {}},
    { 3000, -17102, {}},
    { 3000, -17002, {}},
    { 3000, -16902, {}},
    { 3000, -16803, {}},
    { 3000, -16703, {}},
    { 3000, -16603, {}},
    { 3000, -16504, {}},
    { 3000, -16404, {}},
    { 3000, -16305, {}},
    { 3000, -16205, {}},
    { 3000, -16105, {}},
    { 3000, -16006, {}},
    { 3000, -15906, {}},
    { 3000, -15807, {}},
    { 3000, -15707, {}},
    { 3000, -15607, {}},
    { 3000, -15508, {}},
    { 3000, -15408, {}},
    { 3000, -15308, {}},
    { 3000, -15209, {}},
    { 3000, -15109, {}},
    { 3000, -15010, {}},
    { 3000, -14910, {}},
    { 3000, -14810, {}},
    { 3000, -14711, {}},
    { 3000, -14611, {}},
    { 3000, -14512, {}},
    { 3000, -14412, {}},
    { 3000, -14312, {}},
    { 3000, -14213, {}},
    { 3000, -14113, {}},
    { 3000, -14013, {}},
    { 3000, -13914, {}},
    { 3000, -13814, {}},
    { 3000, -13715, {}},
    { 3000, -13615, {}},
    { 3000, -13515, {}},
    { 3000, -13416, {}},
    { 3000, -13316, {}},
    { 3000, -13217, {}},
    { 3000, -13117, {}},
    { 3000, -13017, {}},
    { 3000, -12918, {}},
    { 3000, -12818, {}},
    { 3000, -12718, {}},
    { 3000, -12619, {}},
    { 3000, -12519, {}},
    { 3000, -12420, {}},
    { 3000, -12320, {}},
    { 3080, -12367, {}},
    { 3160, -12413, {}},
    { 3240, -12460, {}},
    { 3335, -12496, {}},
    { 3431, -12533, {}},
    { 3526, -12569, {}},
    { 3621, -12606, {}},
    { 3716, -12642, {}},
    { 3812, -12679, {}},
    { 3907, -12715, {}},
    { 4002, -12752, {}},
    { 4098, -12788, {}},
    { 4193, -12825, {}},
    { 4288, -12861, {}},
    { 4384, -12898, {}},
    { 4479, -12934, {}},
    { 4574, -12971, {}},
    { 4669, -13007, {}},
    { 4765, -13044, {}},
    { 4860, -13080, {}},
    { 4945, -13173, {}},
    { 5031, -13265, {}},
    { 5116, -13358, {}},
    { 5202, -13451, {}},
    { 5287, -13544, {}},
    { 5373, -13636, {}},
    { 5458, -13729, {}},
    { 5544, -13822, {}},
    { 5629, -13915, {}},
    { 5715, -14007, {}},
    { 5800, -14100, {}},
    { 5772, -14200, {}},
    { 5745, -14300, {}},
    { 5717, -14400, {}},
    { 5690, -14500, {}},
    { 5662, -14600, {}},
    { 5634, -14700, {}},
    { 5607, -14800, {}},
    { 5579, -14900, {}},
    { 5552, -15000, {}},
    { 5524, -15100, {}},
    { 5497, -15200, {}},
    { 5469, -15300, {}},
    { 5441, -15400, {}},
    { 5414, -15500, {}},
    { 5386, -15600, {}},
    { 5359, -15700, {}},
    { 5331, -15800, {}},
    { 5303, -15900, {}},
    { 5276, -16000, {}},
    { 5248, -16100, {}},
    { 5221, -16200, {}},
    { 5193, -16300, {}},
    { 5166, -16400, {}},
    { 5138, -16500, {}},
    { 5110, -16600, {}},
    { 5083, -16700, {}},
    { 5055, -16800, {}},
    { 5028, -16900, {}},
    { 5000, -17000, {}},
    { 5000, -17100, {}},
    { 5000, -17200, {}},
    { 5000, -17300, {}},
    { 5000, -17400, {}},
    { 5000, -17500, {}},
    { 4900, -17500, {}},
    { 4800, -17500, {}},
    { 4700, -17500, {}},
    { 4600, -17500, {}},
    { 4500, -17500, {}},
    { 4400, -17500, {}},
    { 4300, -17500, {}},
    { 4200, -17500, {}},
    { 4100, -17500, {}},
    { 4000, -17500, {}},
    { 3900, -17500, {}},
    { 3800, -17500, {}},
    { 3700, -17500, {}},
    { 3600, -17500, {}},
    { 3500, -17500, {}},
    { 3400, -17500, {}},
    { 3300, -17500, {}},
    { 3200, -17500, {}},
    { 3100, -17500, {}},
    { 3000, -17500, {}},
};

static ZoneVertex ituz77[] = {
    { 3000, -15000, {}},
    { 2903, -15000, {}},
    { 2806, -15000, {}},
    { 2710, -15000, {}},
    { 2613, -15000, {}},
    { 2516, -15000, {}},
    { 2419, -15000, {}},
    { 2323, -15000, {}},
    { 2226, -15000, {}},
    { 2129, -15000, {}},
    { 2032, -15000, {}},
    { 1935, -15000, {}},
    { 1839, -15000, {}},
    { 1742, -15000, {}},
    { 1645, -15000, {}},
    { 1548, -15000, {}},
    { 1452, -15000, {}},
    { 1355, -15000, {}},
    { 1258, -15000, {}},
    { 1161, -15000, {}},
    { 1065, -15000, {}},
    {  968, -15000, {}},
    {  871, -15000, {}},
    {  774, -15000, {}},
    {  677, -15000, {}},
    {  581, -15000, {}},
    {  484, -15000, {}},
    {  387, -15000, {}},
    {  290, -15000, {}},
    {  194, -15000, {}},
    {   97, -15000, {}},
    {    0, -15000, {}},
    {    0, -14900, {}},
    {    0, -14800, {}},
    {    0, -14700, {}},
    {    0, -14600, {}},
    {    0, -14500, {}},
    {    0, -14400, {}},
    {    0, -14300, {}},
    {    0, -14200, {}},
    {    0, -14100, {}},
    {    0, -14000, {}},
    {    0, -13900, {}},
    {    0, -13800, {}},
    {    0, -13700, {}},
    {    0, -13600, {}},
    {    0, -13500, {}},
    {    0, -13400, {}},
    {    0, -13300, {}},
    {    0, -13200, {}},
    {    0, -13100, {}},
    {    0, -13000, {}},
    {    0, -12900, {}},
    {    0, -12800, {}},
    {    0, -12700, {}},
    {    0, -12600, {}},
    {    0, -12500, {}},
    {    0, -12400, {}},
    {    0, -12300, {}},
    {    0, -12200, {}},
    {    0, -12100, {}},
    {    0, -12000, {}},
    {   58, -11907, {}},
    {  116, -11815, {}},
    {  175, -11722, {}},
    {  233, -11629, {}},
    {  291, -11536, {}},
    {  349, -11444, {}},
    {  407, -11351, {}},
    {  465, -11258, {}},
    {  524, -11165, {}},
    {  582, -11073, {}},
    {  640, -10980, {}},
    {  738, -11036, {}},
    {  837, -11092, {}},
    {  935, -11148, {}},
    { 1033, -11203, {}},
    { 1132, -11259, {}},
    { 1230, -11315, {}},
    { 1328, -11371, {}},
    { 1427, -11427, {}},
    { 1525, -11483, {}},
    { 1623, -11538, {}},
    { 1722, -11594, {}},
    { 1820, -11650, {}},
    { 1918, -11706, {}},
    { 2017, -11762, {}},
    { 2115, -11818, {}},
    { 2213, -11873, {}},
    { 2312, -11929, {}},
    { 2410, -11985, {}},
    { 2508, -12041, {}},
    { 2607, -12097, {}},
    { 2705, -12153, {}},
    { 2803, -12208, {}},
    { 2902, -12264, {}},
    { 3000, -12320, {}},
    { 3000, -12419, {}},
    { 3000, -12519, {}},
    { 3000, -12618, {}},
    { 3000, -12717, {}},
    { 3000, -12816, {}},
    { 3000, -12916, {}},
    { 3000, -13015, {}},
    { 3000, -13114, {}},
    { 3000, -13213, {}},
    { 3000, -13313, {}},
    { 3000, -13412, {}},
    { 3000, -13511, {}},
    { 3000, -13610, {}},
    { 3000, -13710, {}},
    { 3000, -13809, {}},
    { 3000, -13908, {}},
    { 3000, -14007, {}},
    { 3000, -14107, {}},
    { 3000, -14206, {}},
    { 3000, -14305, {}},
    { 3000, -14404, {}},
    { 3000, -14504, {}},
    { 3000, -14603, {}},
    { 3000, -14702, {}},
    { 3000, -14801, {}},
    { 3000, -14901, {}},
    { 3000, -15000, {}},
};

static ZoneVertex ituz78[] = {
    {-2800, -10700, {}},
    {-2804, -10601, {}},
    {-2808, -10502, {}},
    {-2812, -10402, {}},
    {-2816, -10303, {}},
    {-2820, -10204, {}},
    {-2824, -10105, {}},
    {-2828, -10006, {}},
    {-2832, -9906, {}},
    {-2836, -9807, {}},
    {-2840, -9708, {}},
    {-2844, -9609, {}},
    {-2848, -9510, {}},
    {-2852, -9410, {}},
    {-2856, -9311, {}},
    {-2860, -9212, {}},
    {-2864, -9113, {}},
    {-2868, -9014, {}},
    {-2872, -8914, {}},
    {-2876, -8815, {}},
    {-2880, -8716, {}},
    {-2884, -8617, {}},
    {-2888, -8518, {}},
    {-2892, -8418, {}},
    {-2896, -8319, {}},
    {-2900, -8220, {}},
    {-2804, -8175, {}},
    {-2707, -8129, {}},
    {-2611, -8084, {}},
    {-2515, -8038, {}},
    {-2418, -7993, {}},
    {-2322, -7947, {}},
    {-2225, -7902, {}},
    {-2129, -7856, {}},
    {-2033, -7811, {}},
    {-1936, -7765, {}},
    {-1840, -7720, {}},
    {-1757, -7819, {}},
    {-1675, -7917, {}},
    {-1592, -8016, {}},
    {-1509, -8115, {}},
    {-1427, -8213, {}},
    {-1344, -8312, {}},
    {-1261, -8411, {}},
    {-1179, -8509, {}},
    {-1096, -8608, {}},
    {-1013, -8707, {}},
    { -931, -8805, {}},
    { -848, -8904, {}},
    { -765, -9003, {}},
    { -683, -9101, {}},
    { -600, -9200, {}},
    { -500, -9202, {}},
    { -400, -9203, {}},
    { -300, -9205, {}},
    { -200, -9207, {}},
    { -100, -9208, {}},
    {    0, -9210, {}},
    {  100, -9212, {}},
    {  200, -9213, {}},
    {  300, -9215, {}},
    {  400, -9217, {}},
    {  500, -9218, {}},
    {  600, -9220, {}},
    {  602, -9318, {}},
    {  604, -9416, {}},
    {  607, -9513, {}},
    {  609, -9611, {}},
    {  611, -9709, {}},
    {  613, -9807, {}},
    {  616, -9904, {}},
    {  618, -10002, {}},
    {  620, -10100, {}},
    {  622, -10198, {}},
    {  624, -10296, {}},
    {  627, -10393, {}},
    {  629, -10491, {}},
    {  631, -10589, {}},
    {  633, -10687, {}},
    {  636, -10784, {}},
    {  638, -10882, {}},
    {  640, -10980, {}},
    {  582, -11073, {}},
    {  524, -11165, {}},
    {  465, -11258, {}},
    {  407, -11351, {}},
    {  349, -11444, {}},
    {  291, -11536, {}},
    {  233, -11629, {}},
    {  175, -11722, {}},
    {  116, -11815, {}},
    {   58, -11907, {}},
    {    0, -12000, {}},
    { -100, -11935, {}},
    { -200, -11870, {}},
    { -300, -11805, {}},
    { -400, -11740, {}},
    { -500, -11675, {}},
    { -600, -11610, {}},
    { -700, -11545, {}},
    { -800, -11480, {}},
    { -900, -11415, {}},
    {-1000, -11350, {}},
    {-1100, -11285, {}},
    {-1200, -11220, {}},
    {-1300, -11155, {}},
    {-1400, -11090, {}},
    {-1500, -11025, {}},
    {-1600, -10960, {}},
    {-1700, -10895, {}},
    {-1800, -10830, {}},
    {-1900, -10765, {}},
    {-2000, -10700, {}},
    {-2100, -10700, {}},
    {-2200, -10700, {}},
    {-2300, -10700, {}},
    {-2400, -10700, {}},
    {-2500, -10700, {}},
    {-2600, -10700, {}},
    {-2700, -10700, {}},
    {-2800, -10700, {}},
};

static ZoneVertex ituz79[] = {
    {-2800, -17500, {}},
    {-2900, -17500, {}},
    {-3000, -17500, {}},
    {-3100, -17500, {}},
    {-3200, -17500, {}},
    {-3300, -17500, {}},
    {-3400, -17500, {}},
    {-3500, -17500, {}},
    {-3600, -17500, {}},
    {-3700, -17500, {}},
    {-3800, -17500, {}},
    {-3900, -17500, {}},
    {-4000, -17500, {}},
    {-4100, -17500, {}},
    {-4200, -17500, {}},
    {-4300, -17500, {}},
    {-4400, -17500, {}},
    {-4500, -17500, {}},
    {-4600, -17500, {}},
    {-4700, -17500, {}},
    {-4800, -17500, {}},
    {-4900, -17500, {}},
    {-5000, -17500, {}},
    {-5100, -17500, {}},
    {-5200, -17500, {}},
    {-5300, -17500, {}},
    {-5400, -17500, {}},
    {-5500, -17500, {}},
    {-5500, -17600, {}},
    {-5500, -17700, {}},
    {-5500, -17800, {}},
    {-5500, -17900, {}},
    {-5500, -18000, {}},
    {-5600, -18000, {}},
    {-5700, -18000, {}},
    {-5800, -18000, {}},
    {-5900, -18000, {}},
    {-6000, -18000, {}},
    {-6000, -17900, {}},
    {-6000, -17800, {}},
    {-6000, -17700, {}},
    {-6000, -17600, {}},
    {-6000, -17500, {}},
    {-6000, -17400, {}},
    {-6000, -17300, {}},
    {-6000, -17200, {}},
    {-6000, -17100, {}},
    {-6000, -17000, {}},
    {-6000, -16900, {}},
    {-6000, -16800, {}},
    {-6000, -16700, {}},
    {-6000, -16600, {}},
    {-6000, -16500, {}},
    {-6000, -16400, {}},
    {-6000, -16300, {}},
    {-6000, -16200, {}},
    {-6000, -16100, {}},
    {-6000, -16000, {}},
    {-6000, -15900, {}},
    {-6000, -15800, {}},
    {-6000, -15700, {}},
    {-6000, -15600, {}},
    {-6000, -15500, {}},
    {-6000, -15400, {}},
    {-6000, -15300, {}},
    {-6000, -15200, {}},
    {-6000, -15100, {}},
    {-6000, -15000, {}},
    {-6000, -14900, {}},
    {-6000, -14800, {}},
    {-6000, -14700, {}},
    {-6000, -14600, {}},
    {-6000, -14500, {}},
    {-6000, -14400, {}},
    {-6000, -14300, {}},
    {-6000, -14200, {}},
    {-6000, -14100, {}},
    {-6000, -14000, {}},
    {-5900, -14000, {}},
    {-5800, -14000, {}},
    {-5700, -14000, {}},
    {-5600, -14000, {}},
    {-5500, -14000, {}},
    {-5400, -14000, {}},
    {-5300, -14000, {}},
    {-5200, -14000, {}},
    {-5100, -14000, {}},
    {-5000, -14000, {}},
    {-4900, -14000, {}},
    {-4800, -14000, {}},
    {-4700, -14000, {}},
    {-4600, -14000, {}},
    {-4500, -14000, {}},
    {-4400, -14000, {}},
    {-4300, -14000, {}},
    {-4200, -14000, {}},
    {-4100, -14000, {}},
    {-4000, -14000, {}},
    {-3900, -14000, {}},
    {-3800, -14000, {}},
    {-3700, -14000, {}},
    {-3600, -14000, {}},
    {-3500, -14000, {}},
    {-3400, -14000, {}},
    {-3300, -14000, {}},
    {-3200, -14000, {}},
    {-3100, -14000, {}},
    {-3000, -14000, {}},
    {-2900, -14000, {}},
    {-2800, -14000, {}},
    {-2800, -14100, {}},
    {-2800, -14200, {}},
    {-2800, -14300, {}},
    {-2800, -14400, {}},
    {-2800, -14500, {}},
    {-2800, -14600, {}},
    {-2800, -14700, {}},
    {-2800, -14800, {}},
    {-2800, -14900, {}},
    {-2800, -15000, {}},
    {-2800, -15100, {}},
    {-2800, -15200, {}},
    {-2800, -15300, {}},
    {-2800, -15400, {}},
    {-2800, -15500, {}},
    {-2800, -15600, {}},
    {-2800, -15700, {}},
    {-2800, -15800, {}},
    {-2800, -15900, {}},
    {-2800, -16000, {}},
    {-2800, -16100, {}},
    {-2800, -16200, {}},
    {-2800, -16300, {}},
    {-2800, -16400, {}},
    {-2800, -16500, {}},
    {-2800, -16600, {}},
    {-2800, -16700, {}},
    {-2800, -16800, {}},
    {-2800, -16900, {}},
    {-2800, -17000, {}},
    {-2800, -17100, {}},
    {-2800, -17200, {}},
    {-2800, -17300, {}},
    {-2800, -17400, {}},
    {-2800, -17500, {}},
};

static ZoneVertex ituz80[] = {
    {-2800, -14000, {}},
    {-2900, -14000, {}},
    {-3000, -14000, {}},
    {-3100, -14000, {}},
    {-3200, -14000, {}},
    {-3300, -14000, {}},
    {-3400, -14000, {}},
    {-3500, -14000, {}},
    {-3600, -14000, {}},
    {-3700, -14000, {}},
    {-3800, -14000, {}},
    {-3900, -14000, {}},
    {-4000, -14000, {}},
    {-4100, -14000, {}},
    {-4200, -14000, {}},
    {-4300, -14000, {}},
    {-4400, -14000, {}},
    {-4500, -14000, {}},
    {-4600, -14000, {}},
    {-4700, -14000, {}},
    {-4800, -14000, {}},
    {-4900, -14000, {}},
    {-5000, -14000, {}},
    {-5100, -14000, {}},
    {-5200, -14000, {}},
    {-5300, -14000, {}},
    {-5400, -14000, {}},
    {-5500, -14000, {}},
    {-5600, -14000, {}},
    {-5700, -14000, {}},
    {-5800, -14000, {}},
    {-5900, -14000, {}},
    {-6000, -14000, {}},
    {-6000, -13900, {}},
    {-6000, -13800, {}},
    {-6000, -13700, {}},
    {-6000, -13600, {}},
    {-6000, -13500, {}},
    {-6000, -13400, {}},
    {-6000, -13300, {}},
    {-6000, -13200, {}},
    {-6000, -13100, {}},
    {-6000, -13000, {}},
    {-6000, -12900, {}},
    {-6000, -12800, {}},
    {-6000, -12700, {}},
    {-6000, -12600, {}},
    {-6000, -12500, {}},
    {-6000, -12400, {}},
    {-6000, -12300, {}},
    {-6000, -12200, {}},
    {-6000, -12100, {}},
    {-6000, -12000, {}},
    {-6000, -11900, {}},
    {-6000, -11800, {}},
    {-6000, -11700, {}},
    {-6000, -11600, {}},
    {-6000, -11500, {}},
    {-6000, -11400, {}},
    {-6000, -11300, {}},
    {-6000, -11200, {}},
    {-6000, -11100, {}},
    {-6000, -11000, {}},
    {-6000, -10900, {}},
    {-6000, -10800, {}},
    {-6000, -10700, {}},
    {-5900, -10700, {}},
    {-5800, -10700, {}},
    {-5700, -10700, {}},
    {-5600, -10700, {}},
    {-5500, -10700, {}},
    {-5400, -10700, {}},
    {-5300, -10700, {}},
    {-5200, -10700, {}},
    {-5100, -10700, {}},
    {-5000, -10700, {}},
    {-4900, -10700, {}},
    {-4800, -10700, {}},
    {-4700, -10700, {}},
    {-4600, -10700, {}},
    {-4500, -10700, {}},
    {-4400, -10700, {}},
    {-4300, -10700, {}},
    {-4200, -10700, {}},
    {-4100, -10700, {}},
    {-4000, -10700, {}},
    {-3900, -10700, {}},
    {-3800, -10700, {}},
    {-3700, -10700, {}},
    {-3600, -10700, {}},
    {-3500, -10700, {}},
    {-3400, -10700, {}},
    {-3300, -10700, {}},
    {-3200, -10700, {}},
    {-3100, -10700, {}},
    {-3000, -10700, {}},
    {-2900, -10700, {}},
    {-2800, -10700, {}},
    {-2800, -10800, {}},
    {-2800, -10900, {}},
    {-2800, -11000, {}},
    {-2800, -11100, {}},
    {-2800, -11200, {}},
    {-2800, -11300, {}},
    {-2800, -11400, {}},
    {-2800, -11500, {}},
    {-2800, -11600, {}},
    {-2800, -11700, {}},
    {-2800, -11800, {}},
    {-2800, -11900, {}},
    {-2800, -12000, {}},
    {-2800, -12100, {}},
    {-2800, -12200, {}},
    {-2800, -12300, {}},
    {-2800, -12400, {}},
    {-2800, -12500, {}},
    {-2800, -12600, {}},
    {-2800, -12700, {}},
    {-2800, -12800, {}},
    {-2800, -12900, {}},
    {-2800, -13000, {}},
    {-2800, -13100, {}},
    {-2800, -13200, {}},
    {-2800, -13300, {}},
    {-2800, -13400, {}},
    {-2800, -13500, {}},
    {-2800, -13600, {}},
    {-2800, -13700, {}},
    {-2800, -13800, {}},
    {-2800, -13900, {}},
    {-2800, -14000, {}},
};

static ZoneVertex ituz81[] = {
    {-2800, -10700, {}},
    {-2900, -10700, {}},
    {-3000, -10700, {}},
    {-3100, -10700, {}},
    {-3200, -10700, {}},
    {-3300, -10700, {}},
    {-3400, -10700, {}},
    {-3500, -10700, {}},
    {-3600, -10700, {}},
    {-3700, -10700, {}},
    {-3800, -10700, {}},
    {-3900, -10700, {}},
    {-4000, -10700, {}},
    {-4100, -10700, {}},
    {-4200, -10700, {}},
    {-4300, -10700, {}},
    {-4400, -10700, {}},
    {-4500, -10700, {}},
    {-4600, -10700, {}},
    {-4700, -10700, {}},
    {-4800, -10700, {}},
    {-4900, -10700, {}},
    {-5000, -10700, {}},
    {-5100, -10700, {}},
    {-5200, -10700, {}},
    {-5300, -10700, {}},
    {-5400, -10700, {}},
    {-5500, -10700, {}},
    {-5600, -10700, {}},
    {-5700, -10700, {}},
    {-5800, -10700, {}},
    {-5900, -10700, {}},
    {-6000, -10700, {}},
    {-6000, -10600, {}},
    {-6000, -10500, {}},
    {-6000, -10400, {}},
    {-6000, -10300, {}},
    {-6000, -10200, {}},
    {-6000, -10100, {}},
    {-6000, -10000, {}},
    {-6000, -9900, {}},
    {-6000, -9800, {}},
    {-6000, -9700, {}},
    {-6000, -9600, {}},
    {-6000, -9500, {}},
    {-6000, -9400, {}},
    {-6000, -9300, {}},
    {-6000, -9200, {}},
    {-6000, -9100, {}},
    {-6000, -9000, {}},
    {-6000, -8900, {}},
    {-6000, -8800, {}},
    {-6000, -8700, {}},
    {-6000, -8600, {}},
    {-6000, -8500, {}},
    {-6000, -8400, {}},
    {-6000, -8300, {}},
    {-6000, -8200, {}},
    {-6000, -8100, {}},
    {-6000, -8000, {}},
    {-6000, -7900, {}},
    {-6000, -7800, {}},
    {-5900, -7800, {}},
    {-5800, -7800, {}},
    {-5700, -7800, {}},
    {-5600, -7800, {}},
    {-5500, -7800, {}},
    {-5400, -7800, {}},
    {-5300, -7800, {}},
    {-5200, -7800, {}},
    {-5100, -7800, {}},
    {-5000, -7800, {}},
    {-4900, -7800, {}},
    {-4800, -7800, {}},
    {-4700, -7800, {}},
    {-4600, -7800, {}},
    {-4500, -7800, {}},
    {-4400, -7800, {}},
    {-4300, -7800, {}},
    {-4200, -7800, {}},
    {-4100, -7800, {}},
    {-4000, -7800, {}},
    {-4000, -7870, {}},
    {-4000, -7940, {}},
    {-3900, -7965, {}},
    {-3800, -7991, {}},
    {-3700, -8016, {}},
    {-3600, -8042, {}},
    {-3500, -8067, {}},
    {-3400, -8093, {}},
    {-3300, -8118, {}},
    {-3200, -8144, {}},
    {-3100, -8169, {}},
    {-3000, -8195, {}},
    {-2900, -8220, {}},
    {-2896, -8319, {}},
    {-2892, -8418, {}},
    {-2888, -8518, {}},
    {-2884, -8617, {}},
    {-2880, -8716, {}},
    {-2876, -8815, {}},
    {-2872, -8914, {}},
    {-2868, -9014, {}},
    {-2864, -9113, {}},
    {-2860, -9212, {}},
    {-2856, -9311, {}},
    {-2852, -9410, {}},
    {-2848, -9510, {}},
    {-2844, -9609, {}},
    {-2840, -9708, {}},
    {-2836, -9807, {}},
    {-2832, -9906, {}},
    {-2828, -10006, {}},
    {-2824, -10105, {}},
    {-2820, -10204, {}},
    {-2816, -10303, {}},
    {-2812, -10402, {}},
    {-2808, -10502, {}},
    {-2804, -10601, {}},
    {-2800, -10700, {}},
};

static ZoneVertex ituz82[] = {
    { 6036, -1400, {}},
    { 5940, -1394, {}},
    { 5844, -1388, {}},
    { 5747, -1382, {}},
    { 5651, -1376, {}},
    { 5555, -1371, {}},
    { 5459, -1365, {}},
    { 5362, -1359, {}},
    { 5266, -1353, {}},
    { 5170, -1347, {}},
    { 5074, -1341, {}},
    { 4977, -1335, {}},
    { 4881, -1329, {}},
    { 4785, -1324, {}},
    { 4689, -1318, {}},
    { 4592, -1312, {}},
    { 4496, -1306, {}},
    { 4400, -1300, {}},
    { 4400, -1400, {}},
    { 4400, -1500, {}},
    { 4400, -1600, {}},
    { 4400, -1700, {}},
    { 4400, -1800, {}},
    { 4400, -1900, {}},
    { 4400, -2000, {}},
    { 4400, -2100, {}},
    { 4400, -2200, {}},
    { 4400, -2300, {}},
    { 4400, -2400, {}},
    { 4400, -2500, {}},
    { 4400, -2600, {}},
    { 4400, -2700, {}},
    { 4400, -2800, {}},
    { 4400, -2900, {}},
    { 4400, -3000, {}},
    { 4400, -3100, {}},
    { 4400, -3200, {}},
    { 4400, -3300, {}},
    { 4400, -3400, {}},
    { 4400, -3500, {}},
    { 4400, -3600, {}},
    { 4400, -3700, {}},
    { 4400, -3800, {}},
    { 4400, -3900, {}},
    { 4400, -4000, {}},
    { 4300, -4000, {}},
    { 4300, -4100, {}},
    { 4300, -4200, {}},
    { 4300, -4300, {}},
    { 4300, -4400, {}},
    { 4300, -4500, {}},
    { 4300, -4600, {}},
    { 4300, -4700, {}},
    { 4300, -4800, {}},
    { 4300, -4900, {}},
    { 4300, -5000, {}},
    { 4400, -5000, {}},
    { 4500, -5000, {}},
    { 4600, -5000, {}},
    { 4700, -5000, {}},
    { 4800, -5000, {}},
    { 4900, -5000, {}},
    { 5000, -5000, {}},
    { 5100, -5000, {}},
    { 5200, -5000, {}},
    { 5300, -5000, {}},
    { 5400, -5000, {}},
    { 5418, -4900, {}},
    { 5436, -4800, {}},
    { 5453, -4700, {}},
    { 5471, -4600, {}},
    { 5489, -4500, {}},
    { 5507, -4400, {}},
    { 5524, -4300, {}},
    { 5542, -4200, {}},
    { 5560, -4100, {}},
    { 5578, -4000, {}},
    { 5596, -3900, {}},
    { 5613, -3800, {}},
    { 5631, -3700, {}},
    { 5649, -3600, {}},
    { 5667, -3500, {}},
    { 5684, -3400, {}},
    { 5702, -3300, {}},
    { 5720, -3200, {}},
    { 5738, -3100, {}},
    { 5756, -3000, {}},
    { 5773, -2900, {}},
    { 5791, -2800, {}},
    { 5809, -2700, {}},
    { 5827, -2600, {}},
    { 5844, -2500, {}},
    { 5862, -2400, {}},
    { 5880, -2300, {}},
    { 5898, -2200, {}},
    { 5916, -2100, {}},
    { 5933, -2000, {}},
    { 5951, -1900, {}},
    { 5969, -1800, {}},
    { 5987, -1700, {}},
    { 6004, -1600, {}},
    { 6022, -1500, {}},
    { 6040, -1400, {}},
};

static ZoneVertex ituz83[] = {
    { 4300, -5700, {}},
    { 4200, -5700, {}},
    { 4100, -5700, {}},
    { 4000, -5700, {}},
    { 3900, -5700, {}},
    { 3800, -5700, {}},
    { 3700, -5700, {}},
    { 3600, -5700, {}},
    { 3500, -5700, {}},
    { 3400, -5700, {}},
    { 3300, -5700, {}},
    { 3200, -5700, {}},
    { 3100, -5700, {}},
    { 3000, -5700, {}},
    { 2900, -5700, {}},
    { 2800, -5700, {}},
    { 2700, -5700, {}},
    { 2600, -5700, {}},
    { 2500, -5700, {}},
    { 2400, -5700, {}},
    { 2300, -5700, {}},
    { 2200, -5700, {}},
    { 2100, -5700, {}},
    { 2000, -5700, {}},
    { 1900, -5700, {}},
    { 1800, -5700, {}},
    { 1700, -5700, {}},
    { 1600, -5700, {}},
    { 1500, -5700, {}},
    { 1400, -5700, {}},
    { 1300, -5700, {}},
    { 1200, -5700, {}},
    { 1100, -5700, {}},
    { 1000, -5700, {}},
    { 1000, -5800, {}},
    { 1000, -5900, {}},
    { 1000, -6000, {}},
    {  967, -5907, {}},
    {  933, -5813, {}},
    {  900, -5720, {}},
    {  867, -5627, {}},
    {  833, -5533, {}},
    {  800, -5440, {}},
    {  767, -5347, {}},
    {  733, -5253, {}},
    {  700, -5160, {}},
    {  700, -5062, {}},
    {  700, -4963, {}},
    {  700, -4865, {}},
    {  700, -4767, {}},
    {  700, -4668, {}},
    {  700, -4570, {}},
    {  700, -4472, {}},
    {  700, -4373, {}},
    {  700, -4275, {}},
    {  700, -4177, {}},
    {  700, -4078, {}},
    {  700, -3980, {}},
    {  700, -3882, {}},
    {  700, -3783, {}},
    {  700, -3685, {}},
    {  700, -3587, {}},
    {  700, -3488, {}},
    {  700, -3390, {}},
    {  700, -3292, {}},
    {  700, -3193, {}},
    {  700, -3095, {}},
    {  700, -2997, {}},
    {  700, -2898, {}},
    {  700, -2800, {}},
    {  800, -2875, {}},
    {  900, -2950, {}},
    { 1000, -3025, {}},
    { 1100, -3100, {}},
    { 1200, -3175, {}},
    { 1300, -3250, {}},
    { 1400, -3325, {}},
    { 1500, -3400, {}},
    { 1600, -3475, {}},
    { 1700, -3550, {}},
    { 1800, -3625, {}},
    { 1900, -3700, {}},
    { 2000, -3775, {}},
    { 2100, -3850, {}},
    { 2200, -3925, {}},
    { 2300, -4000, {}},
    { 2400, -4000, {}},
    { 2500, -4000, {}},
    { 2600, -4000, {}},
    { 2700, -4000, {}},
    { 2800, -4000, {}},
    { 2900, -4000, {}},
    { 3000, -4000, {}},
    { 3100, -4000, {}},
    { 3200, -4000, {}},
    { 3300, -4000, {}},
    { 3400, -4000, {}},
    { 3500, -4000, {}},
    { 3600, -4000, {}},
    { 3700, -4000, {}},
    { 3800, -4000, {}},
    { 3900, -4000, {}},
    { 4000, -4000, {}},
    { 4100, -4000, {}},
    { 4200, -4000, {}},
    { 4300, -4000, {}},
    { 4300, -4100, {}},
    { 4300, -4200, {}},
    { 4300, -4300, {}},
    { 4300, -4400, {}},
    { 4300, -4500, {}},
    { 4300, -4600, {}},
    { 4300, -4700, {}},
    { 4300, -4800, {}},
    { 4300, -4900, {}},
    { 4300, -5000, {}},
    { 4300, -5100, {}},
    { 4300, -5200, {}},
    { 4300, -5300, {}},
    { 4300, -5400, {}},
    { 4300, -5500, {}},
    { 4300, -5600, {}},
    { 4300, -5700, {}},
};

static ZoneVertex ituz84[] = {
    {-4000, -5500, {}},
    {-4100, -5500, {}},
    {-4200, -5500, {}},
    {-4300, -5500, {}},
    {-4400, -5500, {}},
    {-4500, -5500, {}},
    {-4600, -5500, {}},
    {-4700, -5500, {}},
    {-4800, -5500, {}},
    {-4900, -5500, {}},
    {-5000, -5500, {}},
    {-5000, -5400, {}},
    {-5000, -5300, {}},
    {-5000, -5200, {}},
    {-5000, -5100, {}},
    {-5000, -5000, {}},
    {-5000, -4900, {}},
    {-5000, -4800, {}},
    {-5000, -4700, {}},
    {-5000, -4600, {}},
    {-5000, -4500, {}},
    {-5000, -4400, {}},
    {-5000, -4300, {}},
    {-5000, -4200, {}},
    {-5000, -4100, {}},
    {-5000, -4000, {}},
    {-5000, -3900, {}},
    {-5000, -3800, {}},
    {-5000, -3700, {}},
    {-5000, -3600, {}},
    {-5000, -3500, {}},
    {-5000, -3400, {}},
    {-5000, -3300, {}},
    {-5000, -3200, {}},
    {-5000, -3100, {}},
    {-5000, -3000, {}},
    {-5000, -2900, {}},
    {-5000, -2800, {}},
    {-5000, -2700, {}},
    {-5000, -2600, {}},
    {-5000, -2500, {}},
    {-5000, -2400, {}},
    {-5000, -2300, {}},
    {-5000, -2200, {}},
    {-5000, -2100, {}},
    {-5000, -2000, {}},
    {-4900, -2000, {}},
    {-4800, -2000, {}},
    {-4700, -2000, {}},
    {-4600, -2000, {}},
    {-4500, -2000, {}},
    {-4500, -2100, {}},
    {-4500, -2200, {}},
    {-4500, -2300, {}},
    {-4500, -2400, {}},
    {-4500, -2500, {}},
    {-4500, -2600, {}},
    {-4500, -2700, {}},
    {-4500, -2800, {}},
    {-4400, -2800, {}},
    {-4300, -2800, {}},
    {-4200, -2800, {}},
    {-4100, -2800, {}},
    {-4000, -2800, {}},
    {-4000, -2900, {}},
    {-4000, -3000, {}},
    {-4000, -3100, {}},
    {-4000, -3200, {}},
    {-4000, -3300, {}},
    {-4000, -3400, {}},
    {-4000, -3500, {}},
    {-4000, -3600, {}},
    {-4000, -3700, {}},
    {-4000, -3800, {}},
    {-4000, -3900, {}},
    {-4000, -4000, {}},
    {-4000, -4100, {}},
    {-4000, -4200, {}},
    {-4000, -4300, {}},
    {-4000, -4400, {}},
    {-4000, -4500, {}},
    {-4000, -4600, {}},
    {-4000, -4700, {}},
    {-4000, -4800, {}},
    {-4000, -4900, {}},
    {-4000, -5000, {}},
    {-4000, -5100, {}},
    {-4000, -5200, {}},
    {-4000, -5300, {}},
    {-4000, -5400, {}},
    {-4000, -5500, {}},
};

static ZoneVertex ituz85[] = {
    {-4500, -2000, {}},
    {-4600, -2000, {}},
    {-4700, -2000, {}},
    {-4800, -2000, {}},
    {-4900, -2000, {}},
    {-5000, -2000, {}},
    {-5000, -1900, {}},
    {-5000, -1800, {}},
    {-5000, -1700, {}},
    {-5000, -1600, {}},
    {-5000, -1500, {}},
    {-5000, -1400, {}},
    {-5000, -1300, {}},
    {-5000, -1200, {}},
    {-5000, -1100, {}},
    {-5000, -1000, {}},
    {-5000,  -900, {}},
    {-5000,  -800, {}},
    {-5000,  -700, {}},
    {-5000,  -600, {}},
    {-5000,  -500, {}},
    {-5000,  -400, {}},
    {-5000,  -300, {}},
    {-5000,  -200, {}},
    {-5000,  -100, {}},
    {-5000,     0, {}},
    {-5000,   100, {}},
    {-5000,   200, {}},
    {-5000,   300, {}},
    {-5000,   400, {}},
    {-5000,   500, {}},
    {-5000,   600, {}},
    {-5000,   700, {}},
    {-5000,   800, {}},
    {-5000,   900, {}},
    {-5000,  1000, {}},
    {-5000,  1100, {}},
    {-5000,  1200, {}},
    {-5000,  1300, {}},
    {-5000,  1400, {}},
    {-5000,  1500, {}},
    {-5000,  1600, {}},
    {-5000,  1700, {}},
    {-5000,  1800, {}},
    {-5000,  1900, {}},
    {-5000,  2000, {}},
    {-4900,  1950, {}},
    {-4800,  1900, {}},
    {-4700,  1850, {}},
    {-4600,  1800, {}},
    {-4500,  1750, {}},
    {-4400,  1700, {}},
    {-4300,  1650, {}},
    {-4200,  1600, {}},
    {-4100,  1550, {}},
    {-4000,  1500, {}},
    {-3900,  1450, {}},
    {-3800,  1400, {}},
    {-3700,  1350, {}},
    {-3600,  1300, {}},
    {-3500,  1250, {}},
    {-3400,  1200, {}},
    {-3300,  1150, {}},
    {-3200,  1100, {}},
    {-3100,  1050, {}},
    {-3000,  1000, {}},
    {-2900,   950, {}},
    {-2800,   900, {}},
    {-2700,   850, {}},
    {-2600,   800, {}},
    {-2500,   750, {}},
    {-2400,   700, {}},
    {-2300,   650, {}},
    {-2200,   600, {}},
    {-2100,   550, {}},
    {-2000,   500, {}},
    {-2100,   500, {}},
    {-2200,   500, {}},
    {-2300,   500, {}},
    {-2400,   500, {}},
    {-2500,   500, {}},
    {-2600,   500, {}},
    {-2700,   500, {}},
    {-2800,   500, {}},
    {-2900,   500, {}},
    {-3000,   500, {}},
    {-3100,   500, {}},
    {-3200,   500, {}},
    {-3300,   500, {}},
    {-3400,   500, {}},
    {-3500,   500, {}},
    {-3600,   500, {}},
    {-3700,   500, {}},
    {-3800,   500, {}},
    {-3900,   500, {}},
    {-4000,   500, {}},
    {-4100,   500, {}},
    {-4200,   500, {}},
    {-4300,   500, {}},
    {-4400,   500, {}},
    {-4500,   500, {}},
    {-4500,   400, {}},
    {-4500,   300, {}},
    {-4500,   200, {}},
    {-4500,   100, {}},
    {-4500,     0, {}},
    {-4500,  -100, {}},
    {-4500,  -200, {}},
    {-4500,  -300, {}},
    {-4500,  -400, {}},
    {-4500,  -500, {}},
    {-4500,  -600, {}},
    {-4500,  -700, {}},
    {-4500,  -800, {}},
    {-4500,  -900, {}},
    {-4500, -1000, {}},
    {-4500, -1100, {}},
    {-4500, -1200, {}},
    {-4500, -1300, {}},
    {-4500, -1400, {}},
    {-4500, -1500, {}},
    {-4500, -1600, {}},
    {-4500, -1700, {}},
    {-4500, -1800, {}},
    {-4500, -1900, {}},
    {-4500, -2000, {}},
};

static ZoneVertex ituz86[] = {
    {-3500,  4000, {}},
    {-3400,  4000, {}},
    {-3300,  4000, {}},
    {-3200,  4000, {}},
    {-3100,  4000, {}},
    {-3000,  4000, {}},
    {-2900,  4000, {}},
    {-2800,  4000, {}},
    {-2700,  4000, {}},
    {-2700,  4100, {}},
    {-2700,  4200, {}},
    {-2700,  4300, {}},
    {-2700,  4400, {}},
    {-2700,  4500, {}},
    {-2700,  4600, {}},
    {-2700,  4700, {}},
    {-2700,  4800, {}},
    {-2700,  4900, {}},
    {-2700,  5000, {}},
    {-2700,  5100, {}},
    {-2700,  5200, {}},
    {-2700,  5300, {}},
    {-2700,  5400, {}},
    {-2700,  5500, {}},
    {-2700,  5600, {}},
    {-2700,  5700, {}},
    {-2700,  5800, {}},
    {-2700,  5900, {}},
    {-2700,  6000, {}},
    {-2600,  6071, {}},
    {-2500,  6143, {}},
    {-2400,  6214, {}},
    {-2300,  6286, {}},
    {-2200,  6357, {}},
    {-2100,  6429, {}},
    {-2000,  6500, {}},
    {-1900,  6474, {}},
    {-1800,  6448, {}},
    {-1700,  6422, {}},
    {-1600,  6396, {}},
    {-1500,  6370, {}},
    {-1400,  6344, {}},
    {-1300,  6318, {}},
    {-1200,  6292, {}},
    {-1100,  6266, {}},
    {-1000,  6240, {}},
    {-1000,  6338, {}},
    {-1000,  6436, {}},
    {-1000,  6533, {}},
    {-1000,  6631, {}},
    {-1000,  6729, {}},
    {-1000,  6827, {}},
    {-1000,  6924, {}},
    {-1000,  7022, {}},
    {-1000,  7120, {}},
    {-1000,  7218, {}},
    {-1000,  7316, {}},
    {-1000,  7413, {}},
    {-1000,  7511, {}},
    {-1000,  7609, {}},
    {-1000,  7707, {}},
    {-1000,  7804, {}},
    {-1000,  7902, {}},
    {-1000,  8000, {}},
    {-1100,  8000, {}},
    {-1200,  8000, {}},
    {-1300,  8000, {}},
    {-1400,  8000, {}},
    {-1500,  8000, {}},
    {-1600,  8000, {}},
    {-1700,  8000, {}},
    {-1800,  8000, {}},
    {-1900,  8000, {}},
    {-2000,  8000, {}},
    {-2100,  8000, {}},
    {-2200,  8000, {}},
    {-2300,  8000, {}},
    {-2400,  8000, {}},
    {-2500,  8000, {}},
    {-2600,  8000, {}},
    {-2700,  8000, {}},
    {-2800,  8000, {}},
    {-2900,  8000, {}},
    {-3000,  8000, {}},
    {-3100,  8000, {}},
    {-3200,  8000, {}},
    {-3300,  8000, {}},
    {-3400,  8000, {}},
    {-3500,  8000, {}},
    {-3500,  7900, {}},
    {-3500,  7800, {}},
    {-3500,  7700, {}},
    {-3500,  7600, {}},
    {-3500,  7500, {}},
    {-3500,  7400, {}},
    {-3500,  7300, {}},
    {-3500,  7200, {}},
    {-3500,  7100, {}},
    {-3500,  7000, {}},
    {-3500,  6900, {}},
    {-3500,  6800, {}},
    {-3500,  6700, {}},
    {-3500,  6600, {}},
    {-3500,  6500, {}},
    {-3500,  6400, {}},
    {-3500,  6300, {}},
    {-3500,  6200, {}},
    {-3500,  6100, {}},
    {-3500,  6000, {}},
    {-3500,  5900, {}},
    {-3500,  5800, {}},
    {-3500,  5700, {}},
    {-3500,  5600, {}},
    {-3500,  5500, {}},
    {-3500,  5400, {}},
    {-3500,  5300, {}},
    {-3500,  5200, {}},
    {-3500,  5100, {}},
    {-3500,  5000, {}},
    {-3500,  4900, {}},
    {-3500,  4800, {}},
    {-3500,  4700, {}},
    {-3500,  4600, {}},
    {-3500,  4500, {}},
    {-3500,  4400, {}},
    {-3500,  4300, {}},
    {-3500,  4200, {}},
    {-3500,  4100, {}},
    {-3500,  4000, {}},
};

static ZoneVertex ituz87[] = {
    {-4000,  8000, {}},
    {-4000,  8100, {}},
    {-4000,  8200, {}},
    {-4000,  8300, {}},
    {-4000,  8400, {}},
    {-4000,  8500, {}},
    {-4000,  8600, {}},
    {-4000,  8700, {}},
    {-4000,  8800, {}},
    {-4000,  8900, {}},
    {-4000,  9000, {}},
    {-4000,  9100, {}},
    {-4000,  9200, {}},
    {-4000,  9300, {}},
    {-4000,  9400, {}},
    {-4000,  9500, {}},
    {-4000,  9600, {}},
    {-4000,  9700, {}},
    {-4000,  9800, {}},
    {-4000,  9900, {}},
    {-4000, 10000, {}},
    {-4000, 10100, {}},
    {-4000, 10200, {}},
    {-4000, 10300, {}},
    {-4000, 10400, {}},
    {-4000, 10500, {}},
    {-4000, 10600, {}},
    {-4000, 10700, {}},
    {-4000, 10800, {}},
    {-4000, 10900, {}},
    {-4000, 11000, {}},
    {-3900, 11000, {}},
    {-3800, 11000, {}},
    {-3700, 11000, {}},
    {-3600, 11000, {}},
    {-3500, 11000, {}},
    {-3400, 11000, {}},
    {-3300, 11000, {}},
    {-3200, 11000, {}},
    {-3100, 11000, {}},
    {-3000, 11000, {}},
    {-2900, 11000, {}},
    {-2800, 11000, {}},
    {-2700, 11000, {}},
    {-2600, 11000, {}},
    {-2500, 11000, {}},
    {-2400, 11000, {}},
    {-2300, 11000, {}},
    {-2200, 11000, {}},
    {-2100, 11000, {}},
    {-2000, 11000, {}},
    {-1900, 11000, {}},
    {-1800, 11000, {}},
    {-1700, 11000, {}},
    {-1600, 11000, {}},
    {-1500, 11000, {}},
    {-1400, 11000, {}},
    {-1300, 11000, {}},
    {-1300, 10900, {}},
    {-1300, 10800, {}},
    {-1300, 10700, {}},
    {-1300, 10600, {}},
    {-1300, 10500, {}},
    {-1300, 10400, {}},
    {-1300, 10300, {}},
    {-1300, 10200, {}},
    {-1300, 10100, {}},
    {-1300, 10000, {}},
    {-1300,  9900, {}},
    {-1300,  9800, {}},
    {-1300,  9700, {}},
    {-1300,  9600, {}},
    {-1300,  9500, {}},
    {-1300,  9400, {}},
    {-1300,  9300, {}},
    {-1300,  9200, {}},
    {-1300,  9100, {}},
    {-1300,  9000, {}},
    {-1200,  9000, {}},
    {-1100,  9000, {}},
    {-1000,  9000, {}},
    {-1000,  8900, {}},
    {-1000,  8800, {}},
    {-1000,  8700, {}},
    {-1000,  8600, {}},
    {-1000,  8500, {}},
    {-1000,  8400, {}},
    {-1000,  8300, {}},
    {-1000,  8200, {}},
    {-1000,  8100, {}},
    {-1000,  8000, {}},
    {-1100,  8000, {}},
    {-1200,  8000, {}},
    {-1300,  8000, {}},
    {-1400,  8000, {}},
    {-1500,  8000, {}},
    {-1600,  8000, {}},
    {-1700,  8000, {}},
    {-1800,  8000, {}},
    {-1900,  8000, {}},
    {-2000,  8000, {}},
    {-2100,  8000, {}},
    {-2200,  8000, {}},
    {-2300,  8000, {}},
    {-2400,  8000, {}},
    {-2500,  8000, {}},
    {-2600,  8000, {}},
    {-2700,  8000, {}},
    {-2800,  8000, {}},
    {-2900,  8000, {}},
    {-3000,  8000, {}},
    {-3100,  8000, {}},
    {-3200,  8000, {}},
    {-3300,  8000, {}},
    {-3400,  8000, {}},
    {-3500,  8000, {}},
    {-3600,  8000, {}},
    {-3700,  8000, {}},
    {-3800,  8000, {}},
    {-3900,  8000, {}},
    {-4000,  8000, {}},
};

static ZoneVertex ituz88[] = {
    {-6000,  8000, {}},
    {-5905,  8000, {}},
    {-5810,  8000, {}},
    {-5714,  8000, {}},
    {-5619,  8000, {}},
    {-5524,  8000, {}},
    {-5429,  8000, {}},
    {-5333,  8000, {}},
    {-5238,  8000, {}},
    {-5143,  8000, {}},
    {-5048,  8000, {}},
    {-4952,  8000, {}},
    {-4857,  8000, {}},
    {-4762,  8000, {}},
    {-4667,  8000, {}},
    {-4571,  8000, {}},
    {-4476,  8000, {}},
    {-4381,  8000, {}},
    {-4286,  8000, {}},
    {-4190,  8000, {}},
    {-4095,  8000, {}},
    {-4000,  8000, {}},
    {-4000,  8100, {}},
    {-4000,  8200, {}},
    {-4000,  8300, {}},
    {-4000,  8400, {}},
    {-4000,  8500, {}},
    {-4000,  8600, {}},
    {-4000,  8700, {}},
    {-4000,  8800, {}},
    {-4000,  8900, {}},
    {-4000,  9000, {}},
    {-4000,  9100, {}},
    {-4000,  9200, {}},
    {-4000,  9300, {}},
    {-4000,  9400, {}},
    {-4000,  9500, {}},
    {-4000,  9600, {}},
    {-4000,  9700, {}},
    {-4000,  9800, {}},
    {-4000,  9900, {}},
    {-4000, 10000, {}},
    {-4000, 10100, {}},
    {-4000, 10200, {}},
    {-4000, 10300, {}},
    {-4000, 10400, {}},
    {-4000, 10500, {}},
    {-4000, 10600, {}},
    {-4000, 10700, {}},
    {-4000, 10800, {}},
    {-4000, 10900, {}},
    {-4000, 11000, {}},
    {-4100, 11000, {}},
    {-4200, 11000, {}},
    {-4300, 11000, {}},
    {-4400, 11000, {}},
    {-4500, 11000, {}},
    {-4600, 11000, {}},
    {-4700, 11000, {}},
    {-4800, 11000, {}},
    {-4900, 11000, {}},
    {-5000, 11000, {}},
    {-5100, 11000, {}},
    {-5200, 11000, {}},
    {-5300, 11000, {}},
    {-5400, 11000, {}},
    {-5500, 11000, {}},
    {-5600, 11000, {}},
    {-5700, 11000, {}},
    {-5800, 11000, {}},
    {-5900, 11000, {}},
    {-6000, 11000, {}},
    {-6000, 10900, {}},
    {-6000, 10800, {}},
    {-6000, 10700, {}},
    {-6000, 10600, {}},
    {-6000, 10500, {}},
    {-6000, 10400, {}},
    {-6000, 10300, {}},
    {-6000, 10200, {}},
    {-6000, 10100, {}},
    {-6000, 10000, {}},
    {-6000,  9900, {}},
    {-6000,  9800, {}},
    {-6000,  9700, {}},
    {-6000,  9600, {}},
    {-6000,  9500, {}},
    {-6000,  9400, {}},
    {-6000,  9300, {}},
    {-6000,  9200, {}},
    {-6000,  9100, {}},
    {-6000,  9000, {}},
    {-6000,  8900, {}},
    {-6000,  8800, {}},
    {-6000,  8700, {}},
    {-6000,  8600, {}},
    {-6000,  8500, {}},
    {-6000,  8400, {}},
    {-6000,  8300, {}},
    {-6000,  8200, {}},
    {-6000,  8100, {}},
    {-6000,  8000, {}},
};

static ZoneVertex ituz89[] = {
    {-6000, 11000, {}},
    {-5905, 11000, {}},
    {-5810, 11000, {}},
    {-5714, 11000, {}},
    {-5619, 11000, {}},
    {-5524, 11000, {}},
    {-5429, 11000, {}},
    {-5333, 11000, {}},
    {-5238, 11000, {}},
    {-5143, 11000, {}},
    {-5048, 11000, {}},
    {-4952, 11000, {}},
    {-4857, 11000, {}},
    {-4762, 11000, {}},
    {-4667, 11000, {}},
    {-4571, 11000, {}},
    {-4476, 11000, {}},
    {-4381, 11000, {}},
    {-4286, 11000, {}},
    {-4190, 11000, {}},
    {-4095, 11000, {}},
    {-4000, 11000, {}},
    {-4000, 11100, {}},
    {-4000, 11200, {}},
    {-4000, 11300, {}},
    {-4000, 11400, {}},
    {-4000, 11500, {}},
    {-4000, 11600, {}},
    {-4000, 11700, {}},
    {-4000, 11800, {}},
    {-4000, 11900, {}},
    {-4000, 12000, {}},
    {-4000, 12100, {}},
    {-4000, 12200, {}},
    {-4000, 12300, {}},
    {-4000, 12400, {}},
    {-4000, 12500, {}},
    {-4000, 12600, {}},
    {-4000, 12700, {}},
    {-4000, 12800, {}},
    {-4000, 12900, {}},
    {-4091, 13000, {}},
    {-4182, 13100, {}},
    {-4273, 13200, {}},
    {-4364, 13300, {}},
    {-4455, 13400, {}},
    {-4545, 13500, {}},
    {-4636, 13600, {}},
    {-4727, 13700, {}},
    {-4818, 13800, {}},
    {-4909, 13900, {}},
    {-5000, 14000, {}},
    {-5000, 14100, {}},
    {-5000, 14200, {}},
    {-5000, 14300, {}},
    {-5000, 14400, {}},
    {-5000, 14500, {}},
    {-5000, 14600, {}},
    {-5000, 14700, {}},
    {-5000, 14800, {}},
    {-5000, 14900, {}},
    {-5000, 15000, {}},
    {-5000, 15100, {}},
    {-5000, 15200, {}},
    {-5000, 15300, {}},
    {-5000, 15400, {}},
    {-5100, 15400, {}},
    {-5200, 15400, {}},
    {-5300, 15400, {}},
    {-5400, 15400, {}},
    {-5500, 15400, {}},
    {-5500, 15500, {}},
    {-5500, 15600, {}},
    {-5500, 15700, {}},
    {-5500, 15800, {}},
    {-5500, 15900, {}},
    {-5500, 16000, {}},
    {-5500, 16100, {}},
    {-5500, 16200, {}},
    {-5500, 16300, {}},
    {-5500, 16400, {}},
    {-5500, 16500, {}},
    {-5500, 16600, {}},
    {-5500, 16700, {}},
    {-5500, 16800, {}},
    {-5500, 16900, {}},
    {-5500, 17000, {}},
    {-5500, 17100, {}},
    {-5500, 17200, {}},
    {-5500, 17300, {}},
    {-5500, 17400, {}},
    {-5500, 17500, {}},
    {-5500, 17600, {}},
    {-5500, 17700, {}},
    {-5500, 17800, {}},
    {-5500, 17900, {}},
    {-5500, -18000, {}},
    {-5600, -18000, {}},
    {-5700, -18000, {}},
    {-5800, -18000, {}},
    {-5900, -18000, {}},
    {-6000, -18000, {}},
    {-6000, 17900, {}},
    {-6000, 17800, {}},
    {-6000, 17700, {}},
    {-6000, 17600, {}},
    {-6000, 17500, {}},
    {-6000, 17400, {}},
    {-6000, 17300, {}},
    {-6000, 17200, {}},
    {-6000, 17100, {}},
    {-6000, 17000, {}},
    {-6000, 16900, {}},
    {-6000, 16800, {}},
    {-6000, 16700, {}},
    {-6000, 16600, {}},
    {-6000, 16500, {}},
    {-6000, 16400, {}},
    {-6000, 16300, {}},
    {-6000, 16200, {}},
    {-6000, 16100, {}},
    {-6000, 16000, {}},
    {-6000, 15900, {}},
    {-6000, 15800, {}},
    {-6000, 15700, {}},
    {-6000, 15600, {}},
    {-6000, 15500, {}},
    {-6000, 15400, {}},
    {-6000, 15300, {}},
    {-6000, 15200, {}},
    {-6000, 15100, {}},
    {-6000, 15000, {}},
    {-6000, 14900, {}},
    {-6000, 14800, {}},
    {-6000, 14700, {}},
    {-6000, 14600, {}},
    {-6000, 14500, {}},
    {-6000, 14400, {}},
    {-6000, 14300, {}},
    {-6000, 14200, {}},
    {-6000, 14100, {}},
    {-6000, 14000, {}},
    {-6000, 13900, {}},
    {-6000, 13800, {}},
    {-6000, 13700, {}},
    {-6000, 13600, {}},
    {-6000, 13500, {}},
    {-6000, 13400, {}},
    {-6000, 13300, {}},
    {-6000, 13200, {}},
    {-6000, 13100, {}},
    {-6000, 13000, {}},
    {-6000, 12900, {}},
    {-6000, 12800, {}},
    {-6000, 12700, {}},
    {-6000, 12600, {}},
    {-6000, 12500, {}},
    {-6000, 12400, {}},
    {-6000, 12300, {}},
    {-6000, 12200, {}},
    {-6000, 12100, {}},
    {-6000, 12000, {}},
    {-6000, 11900, {}},
    {-6000, 11800, {}},
    {-6000, 11700, {}},
    {-6000, 11600, {}},
    {-6000, 11500, {}},
    {-6000, 11400, {}},
    {-6000, 11300, {}},
    {-6000, 11200, {}},
    {-6000, 11100, {}},
    {-6000, 11000, {}},
};

static ZoneVertex ituz90[] = {
    { 5000, 16000, {}},
    { 5000, 16100, {}},
    { 5000, 16200, {}},
    { 5000, 16300, {}},
    { 5000, 16400, {}},
    { 5000, 16500, {}},
    { 5000, 16600, {}},
    { 5000, 16700, {}},
    { 5000, 16800, {}},
    { 5000, 16900, {}},
    { 5000, 17000, {}},
    { 5000, 17100, {}},
    { 5000, 17200, {}},
    { 5000, 17300, {}},
    { 5000, 17400, {}},
    { 5000, 17500, {}},
    { 5000, 17600, {}},
    { 5000, 17700, {}},
    { 5000, 17800, {}},
    { 5000, 17900, {}},
    { 5000, -18000, {}},
    { 5000, -17900, {}},
    { 5000, -17800, {}},
    { 5000, -17700, {}},
    { 5000, -17600, {}},
    { 5000, -17500, {}},
    { 4900, -17500, {}},
    { 4800, -17500, {}},
    { 4700, -17500, {}},
    { 4600, -17500, {}},
    { 4500, -17500, {}},
    { 4400, -17500, {}},
    { 4300, -17500, {}},
    { 4200, -17500, {}},
    { 4100, -17500, {}},
    { 4000, -17500, {}},
    { 3900, -17500, {}},
    { 3800, -17500, {}},
    { 3700, -17500, {}},
    { 3600, -17500, {}},
    { 3500, -17500, {}},
    { 3400, -17500, {}},
    { 3300, -17500, {}},
    { 3200, -17500, {}},
    { 3100, -17500, {}},
    { 3000, -17500, {}},
    { 3000, -17600, {}},
    { 3000, -17700, {}},
    { 3000, -17800, {}},
    { 3000, -17900, {}},
    { 3000, -18000, {}},
    { 3000, 17900, {}},
    { 3000, 17800, {}},
    { 3000, 17700, {}},
    { 3000, 17600, {}},
    { 3000, 17500, {}},
    { 3000, 17400, {}},
    { 3000, 17300, {}},
    { 3000, 17200, {}},
    { 3000, 17100, {}},
    { 3000, 17000, {}},
    { 2900, 17000, {}},
    { 2800, 17000, {}},
    { 2700, 17000, {}},
    { 2600, 17000, {}},
    { 2500, 17000, {}},
    { 2400, 17000, {}},
    { 2300, 17000, {}},
    { 2200, 17000, {}},
    { 2200, 16900, {}},
    { 2200, 16800, {}},
    { 2200, 16700, {}},
    { 2200, 16600, {}},
    { 2200, 16500, {}},
    { 2200, 16400, {}},
    { 2200, 16300, {}},
    { 2200, 16200, {}},
    { 2200, 16100, {}},
    { 2200, 16000, {}},
    { 2200, 15900, {}},
    { 2200, 15800, {}},
    { 2200, 15700, {}},
    { 2200, 15600, {}},
    { 2200, 15500, {}},
    { 2200, 15400, {}},
    { 2200, 15300, {}},
    { 2200, 15200, {}},
    { 2200, 15100, {}},
    { 2200, 15000, {}},
    { 2297, 15000, {}},
    { 2393, 15000, {}},
    { 2490, 15000, {}},
    { 2587, 15000, {}},
    { 2683, 15000, {}},
    { 2780, 15000, {}},
    { 2877, 15000, {}},
    { 2973, 15000, {}},
    { 3070, 15000, {}},
    { 3167, 15000, {}},
    { 3263, 15000, {}},
    { 3360, 15000, {}},
    { 3457, 15000, {}},
    { 3553, 15000, {}},
    { 3650, 15000, {}},
    { 3747, 15000, {}},
    { 3843, 15000, {}},
    { 3940, 15000, {}},
    { 4037, 15000, {}},
    { 4133, 15000, {}},
    { 4230, 15000, {}},
    { 4327, 15000, {}},
    { 4423, 15000, {}},
    { 4520, 15000, {}},
    { 4568, 15100, {}},
    { 4616, 15200, {}},
    { 4664, 15300, {}},
    { 4712, 15400, {}},
    { 4760, 15500, {}},
    { 4808, 15600, {}},
    { 4856, 15700, {}},
    { 4904, 15800, {}},
    { 4952, 15900, {}},
    { 5000, 16000, {}},
};


static ZonePoly cqzones[] = {
    { 1,     6700, -14000,  cqz01, 327, {}, {}},
    { 2,     6200,  -6700,  cqz02, 210, {}, {}},
    { 3,     4700, -12500,  cqz03, 242, {}, {}},
    { 4,     4700, -10000,  cqz04, 357, {}, {}},
    { 5,     4000,  -6500,  cqz05, 265, {}, {}},
    { 6,     2400, -10500,  cqz06, 191, {}, {}},
    { 7,     1000,  -9800,  cqz07, 150, {}, {}},
    { 8,     2200,  -6000,  cqz08, 150, {}, {}},
    { 9,      900,  -5300,  cqz09, 313, {}, {}},
    {10,     -900,  -9300,  cqz10, 396, {}, {}},
    {11,     -700,  -4500,  cqz11, 509, {}, {}},
    {12,    -4300,  -8600,  cqz12, 426, {}, {}},
    {13,    -4300,  -4500,  cqz13, 489, {}, {}},
    {14,     5400,  -1400,  cqz14, 347, {}, {}},
    {15,     4500,   1400,  cqz15, 423, {}, {}},
    {16,     5700,   4000,  cqz16, 647, {}, {}},
    {17,     5700,   6500,  cqz17, 817, {}, {}},
    {18,     5700,   9500,  cqz18, 786, {}, {}},
    {19,     5700,  15000,  cqz19, 548, {}, {}},
    {20,     4000,   3000,  cqz20, 244, {}, {}},
    {21,     3000,   5300,  cqz21, 420, {}, {}},
    {22,      800,   7500,  cqz22, 363, {}, {}},
    {23,     4000,   8500,  cqz23, 791, {}, {}},
    {24,     3200,  11500,  cqz24, 601, {}, {}},
    {25,     4000,  13400,  cqz25, 134, {}, {}},
    {26,     1800,  10000,  cqz26, 240, {}, {}},
    {27,     1200,  14000,  cqz27, 152, {}, {}},
    {28,     -300,  12500,  cqz28, 202, {}, {}},
    {29,    -2300,  11500,  cqz29, 259, {}, {}},
    {30,    -2300,  14500,  cqz30, 244, {}, {}},
    {31,     1700, -16500,  cqz31, 241, {}, {}},
    {32,    -2300, -16500,  cqz32, 316, {}, {}},
    {33,     3200,   -600,  cqz33, 183, {}, {}},
    {34,     2700,   2400,  cqz34, 278, {}, {}},
    {35,     1400,   -600,  cqz35, 205, {}, {}},
    {36,     -700,   -600,  cqz36, 442, {}, {}},
    {37,      800,   5100,  cqz37, 365, {}, {}},
    {38,    -4300,    800,  cqz38, 359, {}, {}},
    {39,    -2300,   6500,  cqz39, 281, {}, {}},
    {40,     7200,  -1500,  cqz40, 320, {}, {}},
};

static ZonePoly ituzones[] = {
    { 1,     6200, -16000,  ituz01, 157, {}, {}},
    { 2,     5700, -12500,  ituz02, 124, {}, {}},
    { 3,     5700, -10000,  ituz03, 126, {}, {}},
    { 4,     5700,  -7800,  ituz04, 171, {}, {}},
    { 5,     7500,  -4000,  ituz05, 145, {}, {}},
    { 6,     4200, -11900,  ituz06,  85, {}, {}},
    { 7,     4200, -10000,  ituz07, 159, {}, {}},
    { 8,     3700,  -8000,  ituz08, 125, {}, {}},
    { 9,     5700,  -6000,  ituz09,  86, {}, {}},
    {10,     2200, -10200,  ituz10, 175, {}, {}},
    {11,     2300,  -7500,  ituz11, 161, {}, {}},
    {12,     -100,  -7200,  ituz12, 174, {}, {}},
    {13,     -300,  -4500,  ituz13, 145, {}, {}},
    {14,    -2800,  -6500,  ituz14, 201, {}, {}},
    {15,    -2300,  -4500,  ituz15, 203, {}, {}},
    {16,    -4800,  -6500,  ituz16,  87, {}, {}},
    {17,     6300,  -2400,  ituz17,  93, {}, {}},
    {18,     7200,   1000,  ituz18, 174, {}, {}},
    {19,     7200,   4000,  ituz19, 118, {}, {}},
    {20,     7200,   6200,  ituz20,  91, {}, {}},
    {21,     7200,   8200,  ituz21,  71, {}, {}},
    {22,     7200,  10000,  ituz22,  81, {}, {}},
    {23,     7200,  12200,  ituz23,  91, {}, {}},
    {24,     7200,  14200,  ituz24,  81, {}, {}},
    {25,     7200,  16200,  ituz25,  71, {}, {}},
    {26,     7200,  18000,  ituz26,  77, {}, {}},
    {27,     5400,   -300,  ituz27, 158, {}, {}},
    {28,     4700,   1800,  ituz28, 259, {}, {}},
    {29,     5500,   3600,  ituz29, 217, {}, {}},
    {30,     5500,   6200,  ituz30, 217, {}, {}},
    {31,     5500,   8200,  ituz31, 155, {}, {}},
    {32,     5500,  10000,  ituz32, 152, {}, {}},
    {33,     5500,  12200,  ituz33, 113, {}, {}},
    {34,     5500,  14200,  ituz34, 102, {}, {}},
    {35,     5700,  16000,  ituz35,  79, {}, {}},
    {36,     3700,  -2500,  ituz36,  94, {}, {}},
    {37,     3700,      0,  ituz37, 154, {}, {}},
    {38,     2900,   2200,  ituz38, 111, {}, {}},
    {39,     2900,   4200,  ituz39, 199, {}, {}},
    {40,     3400,   5600,  ituz40, 350, {}, {}},
    {41,     1200,   7500,  ituz41, 442, {}, {}},
    {42,     4100,   8200,  ituz42, 289, {}, {}},
    {43,     3500,  10000,  ituz43, 274, {}, {}},
    {44,     3500,  11800,  ituz44, 112, {}, {}},
    {45,     3400,  14300,  ituz45,  99, {}, {}},
    {46,     1700,  -1000,  ituz46, 214, {}, {}},
    {47,     1400,   2200,  ituz47, 231, {}, {}},
    {48,      700,   4000,  ituz48, 140, {}, {}},
    {49,     1700,  10000,  ituz49, 231, {}, {}},
    {50,     1200,  12000,  ituz50,  77, {}, {}},
    {51,     -600,  15000,  ituz51, 106, {}, {}},
    {52,     -500,   1700,  ituz52, 283, {}, {}},
    {53,    -1000,   4500,  ituz53, 251, {}, {}},
    {54,        0,  11500,  ituz54, 135, {}, {}},
    {55,    -1800,  14000,  ituz55, 112, {}, {}},
    {56,    -1800,  17000,  ituz56,  88, {}, {}},
    {57,    -2800,   2400,  ituz57, 185, {}, {}},
    {58,    -2300,  12000,  ituz58,  96, {}, {}},
    {59,    -3800,  14000,  ituz59, 111, {}, {}},
    {60,    -3800,  17000,  ituz60, 117, {}, {}},
    {61,     1700, -17000,  ituz61, 142, {}, {}},
    {62,    -1300, -17000,  ituz62, 106, {}, {}},
    {63,    -1300, -13500,  ituz63, 157, {}, {}},
    {64,     1200,  14000,  ituz64,  84, {}, {}},
    {65,     1200,  16200,  ituz65, 122, {}, {}},
    {66,    -2100,  -1100,  ituz66, 157, {}, {}},
    {67,    -6800,   1000,  ituz67, 181, {}, {}},
    {68,    -4500,   6000,  ituz68, 132, {}, {}},
    {69,    -6800,   7000,  ituz69, 161, {}, {}},
    {70,    -6800,  13000,  ituz70, 161, {}, {}},
    {71,    -6800, -17000,  ituz71, 161, {}, {}},
    {72,    -6800, -11000,  ituz72, 161, {}, {}},
    {73,    -6800,  -5000,  ituz73, 181, {}, {}},
    {74,    -8800,  17900,  ituz74,  37, {}, {}},
    {75,     8700,  17900,  ituz75,  37, {}, {}},
    {76,     4200, -15000,  ituz76, 138, {}, {}},
    {77,     1700, -13500,  ituz77, 124, {}, {}},
    {78,    -1300,  -9500,  ituz78, 121, {}, {}},
    {79,    -3800, -16000,  ituz79, 145, {}, {}},
    {80,    -3800, -12500,  ituz80, 131, {}, {}},
    {81,    -3800,  -9000,  ituz81, 120, {}, {}},
    {82,     5200,  -3000,  ituz82, 103, {}, {}},
    {83,     2700,  -4700,  ituz83, 123, {}, {}},
    {84,    -4300,  -4000,  ituz84,  91, {}, {}},
    {85,    -4300,   1000,  ituz85, 126, {}, {}},
    {86,    -2300,   7000,  ituz86, 129, {}, {}},
    {87,    -2300,   9500,  ituz87, 121, {}, {}},
    {88,    -4800,   9500,  ituz88, 102, {}, {}},
    {89,    -5200,  13000,  ituz89, 172, {}, {}},
    {90,     3700,  16500,  ituz90, 123, {}, {}},
};


/*
 * pnpoly from https://wrfranklin.org/Research/Short_Notes/pnpoly.html:
 *
 * Copyright (c) 1970-2003, Wm. Randolph Franklin
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
 * associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 * 
 * Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimers.
 * Redistributions in binary form must reproduce the above copyright notice in the documentation 
 * and/or other materials provided with the distribution.
 * The name of W. Randolph Franklin may not be used to endorse or promote products derived from this 
 * Software without specific prior written permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT 
 * NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *   int pnpoly(int nvert, float *vertx, float *verty, float testx, float testy)
 *   {
 *     int i, j, c = 0;
 *     for (i = 0, j = nvert-1; i < nvert; j = i++) {
 *       if ( ((verty[i]>testy) != (verty[j]>testy)) &&
 *   	 (testx < (vertx[j]-vertx[i]) * (testy-verty[i]) / (verty[j]-verty[i]) + vertx[i]) )
 *          c = !c;
 *     }
 *     return c;
 *   }
 */


/* return 1 if s lies within poly subpoly i, else 0
 * N.B. derived from Franklin, see above (c)
 */
static int pnpoly (int npoly, ZoneVertex *poly, int poly_i, const SCoord &s)
{
    int i, j, c = 0;

    // collect just poly_i into si as canonical coords
    StackMalloc si_mem(npoly*sizeof(SCoord));
    SCoord *si = (SCoord *) si_mem.getMem();
    int nsi = 0;
    for (i = 0; i < npoly; i++) {
        if (poly[i].s[poly_i].x) {
            SCoord &s = si[nsi++];
            s.x = poly[i].s[poly_i].x/tft.SCALESZ;
            s.y = poly[i].s[poly_i].y/tft.SCALESZ;
        }
    }

    // check bounds
    for (i = 0, j = nsi-1; i < nsi; j = i++) {
        if ( ((si[i].y>s.y) != (si[j].y>s.y)) &&
            (s.x < ((float)si[j].x-si[i].x) * (s.y-si[i].y) / (si[j].y-si[i].y) + si[i].x) )
          c = !c;
    }
    return c;
}





/* go through all of the specified zone polygons and update their bounding boxes and vertex screen
 * coordinates. this is in prep for fast calls to findZoneNumber()
 */
void updateZoneSCoords (ZoneID id)
{
    ZonePoly *zpoly = id == ZONE_CQ ? cqzones : ituzones;
    int n_z = id == ZONE_CQ ? NARRAY(cqzones) : NARRAY(ituzones);

    // handy full-res values
    const uint16_t map_ytop = tft.SCALESZ*map_b.y;                      // handy raw map top
    const uint16_t map_ycenter = tft.SCALESZ*(map_b.y + map_b.h/2);     // handy raw map y center
    const uint16_t map_ybottom = tft.SCALESZ*(map_b.y + map_b.h - 1);   // handy raw map bottom
    const uint16_t map_xleft = tft.SCALESZ*map_b.x;                     // handy raw map x left edge
    const uint16_t map_xcenter = tft.SCALESZ*(map_b.x + map_b.w/2);     // handy raw map x center
    const uint16_t map_xright = tft.SCALESZ*(map_b.x + map_b.w - 1);    // handy raw map x right edge
    const uint16_t map_hh = tft.SCALESZ*map_b.h/2;                      // handy raw map half-height
    const uint16_t map_hw = tft.SCALESZ*map_b.w/2;                      // handy raw map half-width

    // for each polygon
    const ZonePoly *end_zp = &zpoly[n_z];                         // zp loop sentinel
    for (ZonePoly *zp = zpoly; zp < end_zp; zp++) {

        // set label screen coord in app coords
        ll2s (deg2rad(LATC2DEG(zp->lat_lbl)), deg2rad(LNGC2DEG(zp->lng_lbl)), zp->s_lbl, 1);

        // start with first polygon list and handy way to swap
        int poly_s = 0;
        #define SWAP_POLYGON()  do { poly_s = 1 - poly_s; } while(0)
        #define END_POLYGON(p)  do { (p) = {0, 0}; } while(0)

        // convert each vertex to screen coords and watch for wraps
        // printf ("********* mapping %d zone %d\n", id, zp->zone_n);
        for (int vn = 0; vn < zp->n_verts; vn++) {

            // handy ref
            SCoord &sc0 = zp->verts[vn].s[poly_s];              // current vertex current polygon
            SCoord &sc1 = zp->verts[vn].s[1 - poly_s];          // current vertex opposite polygon

            // find vertex screen coord in full raw coords
            ll2sRaw (deg2rad(LATC2DEG(zp->verts[vn].lat)), deg2rad(LNGC2DEG(zp->verts[vn].lng)), sc0, 1);

            // end other poly at this index for now
            END_POLYGON(sc1);

            // no path yet if this is the first vertex
            if (vn == 0)
                continue;

            // more handy refs
            SCoord &sp0 = zp->verts[vn-1].s[poly_s];            // previous vertex current polygon
            SCoord &sp1 = zp->verts[vn-1].s[1 - poly_s];        // previous vertex opposite polygon

            // check for wraps, depending on projection

            switch ((MapProjection)map_proj) {

            case MAPP_AZIMUTHAL: {

                // find half-width at this y
                float y_frac = ((float)sp0.y - (float)map_ycenter)/map_hh;
                int hw = map_hh * sqrtf (1 - y_frac*y_frac);

                // break into two polygons if wraps around edges
                if (abs ((int)sp0.x - (int)sc0.x) > hw) {
                    uint16_t tb_edge = sc0.y < map_ycenter ? map_ytop : map_ybottom;
                    sp0.y = tb_edge;                            // extend previous vertex to edge
                    sp1 = {sc0.x, tb_edge};                     // start new poly at current edge
                    sc1 = sc0;                                  // then back to current position
                    END_POLYGON(sc0);                           // end current poly
                    SWAP_POLYGON();                             // continue with new polygon
                }

                }
                break;

            case MAPP_ROB: {

                // find half-width at this y
                int hw = map_hw * RobLat2G (90*(map_ycenter - sp0.y)/map_hh);

                // break into two polygons if wraps around edges
                if (abs ((int)sp0.x - (int)sc0.x) > hw) {
                    uint16_t tb_edge = sc0.y < map_ycenter ? map_ytop : map_ybottom;
                    sp0.y = tb_edge;                            // extend previous vertex to edge
                    sp1 = {sc0.x, tb_edge};                     // start new poly at current edge
                    sc1 = sc0;                                  // then back to current position
                    END_POLYGON(sc0);                           // end current poly
                    SWAP_POLYGON();                             // continue with new polygon
                }

                }
                break;

            case MAPP_AZIM1: {

                // discard zones near the antipodal horizon
                float dx = (int)sc0.x - (int)map_xcenter;
                float dy = (int)sc0.y - (int)map_ycenter;
                float max_rr = 0.95F*map_hh*map_hh;
                if (dx*dx + dy*dy > max_rr) {
                    // reset all vertices then abandon remainder of this zone
                    for (int ve = 0; ve <= zp->n_verts; ve++) {
                        END_POLYGON (zp->verts[ve].s[poly_s]);
                        END_POLYGON (zp->verts[ve].s[1-poly_s]);
                    }
                    vn = zp->n_verts;
                }

                }
                break;

            case MAPP_MERCATOR:

                // break into two polygons if wraps around edges
                if (abs ((int)sp0.x - (int)sc0.x) > map_hw) {
                    uint16_t p_edge = sp0.x < map_xcenter ? map_xleft : map_xright;     // prev edge
                    uint16_t c_edge = sc0.x < map_xcenter ? map_xleft : map_xright;     // current edge
                    sp0.x = p_edge;                             // extend previous vertex to prev edge
                    sp1 = {c_edge, sc0.y};                      // start new poly at current edge
                    sc1 = sc0;                                  // then back to current position
                    END_POLYGON(sc0);                           // end current poly
                    SWAP_POLYGON();                             // continue with new polygon
                }

                break;

            default:
                fatalError ("updateZoneSCoords() map_proj %d", map_proj);
            }
        }
    }

    // spin again to find bounding boxes of each polygon
    // N.B. vertex screen coords are raw but we want canonical coords for the bb.
    for (ZonePoly *zp = zpoly; zp < end_zp; zp++) {

        // check each polynomial
        for (int p = 0; p < 2; p++) {

            // init min/max
            uint16_t min_x = 50000U;
            uint16_t max_x = 0;
            uint16_t min_y = 50000U;
            uint16_t max_y = 0;

            // shrink wrap around each vertex -- N.B. there may not be any!
            const ZoneVertex *end_vp = &zp->verts[zp->n_verts];             // vp loop sentinel
            bool found_s = false;
            for (ZoneVertex *vp = zp->verts; vp < end_vp; vp++) {
                const SCoord &s = vp->s[p];
                if (s.x) {
                    if (s.x < min_x) min_x = s.x;
                    if (s.x > max_x) max_x = s.x;
                    if (s.y < min_y) min_y = s.y;
                    if (s.y > max_y) max_y = s.y;
                    found_s = true;
                }
            }

            // set bb in app coords
            if (found_s) {
                min_x /= tft.SCALESZ;
                max_x /= tft.SCALESZ;
                min_y /= tft.SCALESZ;
                max_y /= tft.SCALESZ;
                uint16_t bb_w = max_x - min_x;
                uint16_t bb_h = max_y - min_y;
                zp->bound_b[p] = {min_x, min_y, bb_w, bb_h};
            } else {
                zp->bound_b[p] = {0, 0, 0, 0};
            }
        }
    }

    // #define _PRINT_ZONES
    #ifdef _PRINT_ZONES
    for (ZonePoly *zp = zpoly; zp < end_zp; zp++) {
        // if (zp->zone_n != 32)
            // continue;
        const char *z_name = zpoly == cqzones ? "CQ" : "ITU";
        Serial.printf ("%s Zone %d bb0: [%3d, %3d]  %3d x %3d  bb1: [%3d, %3d]  %3d x %3d\n",
                    z_name, zp->zone_n,
                    zp->bound_b[0].x, zp->bound_b[0].y, zp->bound_b[0].w, zp->bound_b[0].h,
                    zp->bound_b[1].x, zp->bound_b[1].y, zp->bound_b[1].w, zp->bound_b[1].h);
        Serial.printf ("%s Zone %d: poly 0\n", z_name, zp->zone_n);
        for (int i = 0; i < zp->n_verts; i++)
            if (zp->verts[i].s[0].x)
                Serial.printf ("  %4d %4d\n",zp->verts[i].s[0].x/tft.SCALESZ,zp->verts[i].s[0].y/tft.SCALESZ);
        Serial.printf ("%s Zone %d: poly 1\n", z_name, zp->zone_n);
        for (int i = 0; i < zp->n_verts; i++)
            if (zp->verts[i].s[1].x)
                Serial.printf ("  %4d %4d\n",zp->verts[i].s[1].x/tft.SCALESZ,zp->verts[i].s[1].y/tft.SCALESZ);
    }
    #endif
}

/* given a zone id and screen coord, return enclosing zone number.
 * if none, then return closest label.
 */
bool findZoneNumber (ZoneID id, const SCoord &s, int *zone_n)
{
    ZonePoly *zpoly = id == ZONE_CQ ? cqzones : ituzones;
    int n_z = id == ZONE_CQ ? NARRAY(cqzones) : NARRAY(ituzones);

    // special case for itu polar zones in mercator projection so they can have a 1-d poly -- see mkzones
    if (map_proj == MAPP_MERCATOR && id == ZONE_ITU) {
        if (s.y > map_b.y + 170*map_b.h/180) {
            // zone 74 is south of -80
            *zone_n = 74;
            return (true);
        }
        if (s.y < map_b.y + 10*map_b.h/180) {
            // zone 75 is north of +80
            *zone_n = 75;
            return (true);
        }
    }

    // scan each polygon, fast check with bb then confirm within.
    // if none, still find closest label
    int closest_n = -1;
    int closest_r = 50000;
    const ZonePoly *end_zp = &zpoly[n_z];
    for (const ZonePoly *zp = zpoly; zp < end_zp; zp++) {

        if (inBox (s, zp->bound_b[0]) && pnpoly (zp->n_verts, zp->verts, 0, s)) {
            *zone_n = zp->zone_n;
            return (true);
        }

        if (inBox (s, zp->bound_b[1]) && pnpoly (zp->n_verts, zp->verts, 1, s)) {
            *zone_n = zp->zone_n;
            return (true);
        }

        int r = abs((int)zp->s_lbl.x - (int)s.x) + abs((int)zp->s_lbl.y - (int)s.y);
        if (r < closest_r) {
            closest_r = r;
            closest_n = zp->zone_n;
        }
    }

    // no poly, return closest label
    *zone_n = closest_n;
    return (true);
}


/* draw the specifed zone or all if n_only < 0.
 * N.B. we assume the screen coords are up to date via updateZoneSCoords().
 */
void drawZone (ZoneID id, uint16_t color, int n_only)
{
    // thickness if any
    int lw = getRawPathWidth (GRID_CSPR);
    if (lw == 0)
        return;

    ZonePoly *zpoly = id == ZONE_CQ ? cqzones : ituzones;
    int n_z = id == ZONE_CQ ? NARRAY(cqzones) : NARRAY(ituzones);

    // note whether to draw all
    bool all_zones = n_only < 0;

    // draw both polygons in each vertex
    const ZonePoly *end_zp = &zpoly[n_z];
    for (const ZonePoly *zp = zpoly; zp < end_zp; zp++) {

        // must have primary bounding box
        if ((all_zones || zp->zone_n == n_only) && zp->bound_b[0].x) {

            // draw each visible segment in either polygon
            for (int vn = 1; vn < zp->n_verts; vn++) {          // N.B. fence railings, not posts

                SCoord &sc0 = zp->verts[vn].s[0];               // current vertex first polygon
                SCoord &sc1 = zp->verts[vn].s[1];               // current vertex second polygon
                SCoord &sp0 = zp->verts[vn-1].s[0];             // previous vertex first polygon
                SCoord &sp1 = zp->verts[vn-1].s[1];             // previous vertex second polygon

                if (sp0.x > 0 && sc0.x > 0 && segmentSpanOkRaw (sp0, sc0, lw))
                    tft.drawLineRaw (sp0.x, sp0.y, sc0.x, sc0.y, lw, color);
                if (sp1.x > 0 && sc1.x > 0 && segmentSpanOkRaw (sp1, sc1, lw))
                    tft.drawLineRaw (sp1.x, sp1.y, sc1.x, sc1.y, lw, color);
            }

            if (debugLevel (DEBUG_ZONES, 1)) {
                if (!all_zones) {
                    drawSBox (zp->bound_b[0], RA8875_RED);
                    if (zp->bound_b[1].x)
                        drawSBox (zp->bound_b[1], RA8875_GREEN);
                }
            }
        }

        // add label only if drawing all
        if (all_zones && overMap(zp->s_lbl)) {
            SBox label_b;
            char zn[20];
            snprintf (zn, sizeof(zn), "%d", zp->zone_n);
            setMapTagBox (zn, zp->s_lbl, 0, label_b);
            drawMapTag (zn, label_b);
        }
    }
}
