Feature: display all executed Git commands

  Background:
    Given a Git repo with origin
    And the branches
      | NAME | TYPE    | PARENT | LOCATIONS     |
      | old  | feature | main   | local, origin |
    And the commits
      | BRANCH | LOCATION      | MESSAGE    |
      | old    | local, origin | old commit |
    And the current branch is "old"
    When I run "git-town prepend parent --verbose"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH | TYPE     | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git version                                                                                                                                                                                                                                                                                                                                      |
      |        | backend  | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |        | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |        | backend  | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |        | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |        | backend  | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |        | backend  | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |        | backend  | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |        | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |        | backend  | git remote                                                                                                                                                                                                                                                                                                                                       |
      | old    | frontend | git fetch --prune --tags                                                                                                                                                                                                                                                                                                                         |
      |        | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |        | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |        | backend  | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |        | backend  | git log main..old --format=%s --reverse                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git log --no-merges --format=%H refs/heads/main ^refs/heads/old                                                                                                                                                                                                                                                                                  |
      |        | backend  | git rev-parse old origin/old                                                                                                                                                                                                                                                                                                                     |
      |        | backend  | git rev-parse --verify -q refs/heads/old                                                                                                                                                                                                                                                                                                         |
      |        | backend  | git rev-parse old origin/old                                                                                                                                                                                                                                                                                                                     |
      |        | backend  | git rev-parse --verify -q refs/heads/main                                                                                                                                                                                                                                                                                                        |
      |        | frontend | git checkout -b parent main                                                                                                                                                                                                                                                                                                                      |
      |        | backend  | git rev-parse --verify -q refs/heads/main                                                                                                                                                                                                                                                                                                        |
      |        | backend  | git config git-town-branch.parent.parent main                                                                                                                                                                                                                                                                                                    |
      |        | backend  | git rev-parse --verify -q refs/heads/old                                                                                                                                                                                                                                                                                                         |
      |        | backend  | git config git-town-branch.old.parent parent                                                                                                                                                                                                                                                                                                     |
      |        | backend  | git rev-parse --verify -q refs/heads/old                                                                                                                                                                                                                                                                                                         |
      |        | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |        | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |        | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
    And Git Town prints:
      """
      Ran 31 shell commands.
      """

  Scenario: undo
    When I run "git-town undo --verbose"
    Then Git Town runs the commands
      | BRANCH | TYPE     | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git version                                                                                                                                                                                                                                                                                                                                      |
      |        | backend  | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |        | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |        | backend  | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |        | backend  | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |        | backend  | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |        | backend  | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |        | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |        | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |        | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |        | backend  | git remote                                                                                                                                                                                                                                                                                                                                       |
      |        | backend  | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      | parent | frontend | git checkout old                                                                                                                                                                                                                                                                                                                                 |
      | old    | frontend | git branch -D parent                                                                                                                                                                                                                                                                                                                             |
      |        | backend  | git config --unset git-town-branch.parent.parent                                                                                                                                                                                                                                                                                                 |
      |        | backend  | git config git-town-branch.old.parent main                                                                                                                                                                                                                                                                                                       |
    And Git Town prints:
      """
      Ran 17 shell commands.
      """
