/*
 * DO NOT EDIT THIS FILE. Generated by checkmk.
 * Edit the original source file "test_spoof_config_file.template" instead.
 * Run `make internals` from the base of the project to regenerate this file.
 */

#include <check.h>

#line 1 "test_spoof_config_file.template"
/**
 * This file is part of the Detox package.
 *
 * Copyright (c) Doug Harple <detox.dharple@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "config_file_spoof.h"
#include "config_file.h"
#include "detox_struct.h"
#include "parse_options.h"

static char *detoxrc =
    "sequence default{safe{builtin \"safe\";};wipeup{remove_trailing;};};"
    "sequence \"iso8859_1\"{iso8859_1{builtin \"iso8859_1\";};safe{"
    "builtin \"safe\";};wipeup{remove_trailing;};};"
    "sequence \"iso8859_1-legacy\"{iso8859_1{builtin \"cp1252\";};iso8859_1{"
    "builtin \"iso8859_1\";};safe{builtin \"safe\";};wipeup{remove_trailing;"
    "};};sequence \"utf_8\"{utf_8{builtin \"unicode\";};safe{"
    "builtin \"safe\";};wipeup{remove_trailing;};};sequence \"uncgi\"{uncgi;"
    "safe{builtin \"safe\";};wipeup{remove_trailing;};};sequence \"lower\"{"
    "safe{builtin \"safe\";};lower;wipeup{remove_trailing;};};"
    "sequence \"iso8859_1-only\"{iso8859_1{builtin \"iso8859_1\";};};"
    "sequence \"cp1252-only\"{iso8859_1{builtin \"cp1252\";};};"
    "sequence \"utf_8-only\"{utf_8{builtin \"unicode\";};};"
    "sequence \"uncgi-only\"{uncgi;};sequence \"lower-only\"{lower;};ignore{"
    "filename \"{arch}\";};"
    ;

static char *tempfile;

void setup(void)
{
    int fd;

    tempfile = malloc(1024);
    sprintf(tempfile, "/tmp/detoxrc-test-XXXXXX");
    fd = mkstemp(tempfile);
    fprintf(stderr, "writing to %s\n", tempfile);
    dprintf(fd, "%s", detoxrc);
}

void teardown(void)
{
    fprintf(stderr, "deleting %s\n", tempfile);
    unlink(tempfile);
}

START_TEST(test_spoof_config_file)
{
#line 57
    options_t *main_options;
    config_file_t *parsed;
    config_file_t *spoofed;
    sequence_t *parsed_sequence;
    sequence_t *spoofed_sequence;
    filter_t *parsed_filter;
    filter_t *spoofed_filter;

    main_options = options_init();
    parsed = parse_config_file(tempfile, NULL, main_options);
    spoofed = spoof_config_file();

    // check names

    parsed_sequence = parsed->sequences;
    spoofed_sequence = spoofed->sequences;

    do {
        if (parsed_sequence == NULL || spoofed_sequence == NULL) {
            break;
        }

        ck_assert_str_eq(parsed_sequence->name, spoofed_sequence->name);

        //
        //
        //

        parsed_filter = parsed_sequence->filters;
        spoofed_filter = spoofed_sequence->filters;

        do {
            if (parsed_filter == NULL || spoofed_filter == NULL) {
                break;
            }

            ck_assert_msg(parsed_filter->cleaner == spoofed_filter->cleaner, "unit test cleaner doesn't match spoofed cleaner");

            ck_assert_str_eq(
                parsed_filter->filename ? parsed_filter->filename : "...NULL...",
                spoofed_filter->filename ? spoofed_filter->filename : "...NULL..."
            );
            ck_assert_str_eq(
                parsed_filter->builtin ? parsed_filter->builtin : "...NULL...",
                spoofed_filter->builtin ? spoofed_filter->builtin : "...NULL..."
            );
            ck_assert_int_eq(parsed_filter->remove_trailing, spoofed_filter->remove_trailing);
            ck_assert_int_eq(parsed_filter->max_length, spoofed_filter->max_length);

            parsed_filter = parsed_filter->next;
            spoofed_filter = spoofed_filter->next;
        } while (1);

        //
        //
        //

        parsed_sequence = parsed_sequence->next;
        spoofed_sequence = spoofed_sequence->next;
    } while (1);

    ck_assert_msg(parsed_sequence == NULL, "unit test config file is too long");
    ck_assert_msg(spoofed_sequence == NULL, "spoofed config file is too long");

}
END_TEST

int main(void)
{
    Suite *s1 = suite_create("Core");
    TCase *tc1_1 = tcase_create("Core");
    SRunner *sr = srunner_create(s1);
    int nf;

    /* User-specified pre-run code */
#line 122
    tcase_add_checked_fixture(tc1_1, setup, teardown);

    suite_add_tcase(s1, tc1_1);
    tcase_add_test(tc1_1, test_spoof_config_file);

    srunner_run_all(sr, CK_ENV);
    nf = srunner_ntests_failed(sr);
    srunner_free(sr);

    return nf == 0 ? 0 : 1;
}
