/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AArch64 target                         *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 27;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AArch64InstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AArch64InstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr&, int) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static AArch64InstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AArch64InstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(1),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasJSBit = 5,
  Feature_HasComplxNumBit = 15,
  Feature_HasFPARMv8Bit = 4,
  Feature_HasNEONBit = 3,
  Feature_HasSHA2Bit = 12,
  Feature_HasAESBit = 11,
  Feature_HasDotProdBit = 1,
  Feature_HasCRCBit = 7,
  Feature_HasLSEBit = 13,
  Feature_HasRDMBit = 10,
  Feature_HasPerfMonBit = 16,
  Feature_HasFullFP16Bit = 9,
  Feature_HasFP16FMLBit = 2,
  Feature_HasFuseAESBit = 22,
  Feature_HasSVEBit = 0,
  Feature_HasSVE2Bit = 14,
  Feature_HasMTEBit = 8,
  Feature_HasTMEBit = 6,
  Feature_IsLEBit = 18,
  Feature_IsBEBit = 24,
  Feature_IsWindowsBit = 23,
  Feature_UseAlternateSExtLoadCVTF32Bit = 21,
  Feature_NotForCodeSizeBit = 20,
  Feature_UseSTRQroBit = 19,
  Feature_UseBTIBit = 26,
  Feature_NotUseBTIBit = 25,
  Feature_OptimizedGISelOrOtherSelectorBit = 17,
};

PredicateBitset AArch64InstructionSelector::
computeAvailableModuleFeatures(const AArch64Subtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->hasJS())
    Features.set(Feature_HasJSBit);
  if (Subtarget->hasComplxNum())
    Features.set(Feature_HasComplxNumBit);
  if (Subtarget->hasFPARMv8())
    Features.set(Feature_HasFPARMv8Bit);
  if (Subtarget->hasNEON())
    Features.set(Feature_HasNEONBit);
  if (Subtarget->hasSHA2())
    Features.set(Feature_HasSHA2Bit);
  if (Subtarget->hasAES())
    Features.set(Feature_HasAESBit);
  if (Subtarget->hasDotProd())
    Features.set(Feature_HasDotProdBit);
  if (Subtarget->hasCRC())
    Features.set(Feature_HasCRCBit);
  if (Subtarget->hasLSE())
    Features.set(Feature_HasLSEBit);
  if (Subtarget->hasRDM())
    Features.set(Feature_HasRDMBit);
  if (Subtarget->hasPerfMon())
    Features.set(Feature_HasPerfMonBit);
  if (Subtarget->hasFullFP16())
    Features.set(Feature_HasFullFP16Bit);
  if (Subtarget->hasFP16FML())
    Features.set(Feature_HasFP16FMLBit);
  if (Subtarget->hasFuseAES())
    Features.set(Feature_HasFuseAESBit);
  if (Subtarget->hasSVE())
    Features.set(Feature_HasSVEBit);
  if (Subtarget->hasSVE2())
    Features.set(Feature_HasSVE2Bit);
  if (Subtarget->hasMTE())
    Features.set(Feature_HasMTEBit);
  if (Subtarget->hasTME())
    Features.set(Feature_HasTMEBit);
  if (Subtarget->isLittleEndian())
    Features.set(Feature_IsLEBit);
  if (!Subtarget->isLittleEndian())
    Features.set(Feature_IsBEBit);
  if (Subtarget->isTargetWindows())
    Features.set(Feature_IsWindowsBit);
  if (Subtarget->useAlternateSExtLoadCVTF32Pattern())
    Features.set(Feature_UseAlternateSExtLoadCVTF32Bit);
  return Features;
}

void AArch64InstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AArch64Subtarget*)&MF.getSubtarget(), &MF);
}
static bool shouldOptForSize(const MachineFunction *MF) {
    return MF->getFunction().hasOptSize();
}

PredicateBitset AArch64InstructionSelector::
computeAvailableFunctionFeatures(const AArch64Subtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  if (!shouldOptForSize(MF))
    Features.set(Feature_NotForCodeSizeBit);
  if (!Subtarget->isSTRQroSlow() || shouldOptForSize(MF))
    Features.set(Feature_UseSTRQroBit);
  if ( MF->getFunction().hasFnAttribute("branch-target-enforcement") )
    Features.set(Feature_UseBTIBit);
  if ( !MF->getFunction().hasFnAttribute("branch-target-enforcement") )
    Features.set(Feature_NotUseBTIBit);
  if (!MF->getFunction().hasOptNone() || MF->getProperties().hasProperty(MachineFunctionProperties::Property::FailedISel) || !MF->getProperties().hasProperty(MachineFunctionProperties::Property::Legalized))
    Features.set(Feature_OptimizedGISelOrOtherSelectorBit);
  return Features;
}

// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_s128,
  GILLT_v2s1,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v4s1,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v8s1,
  GILLT_v8s8,
  GILLT_v8s16,
  GILLT_v16s1,
  GILLT_v16s8,
};
const static size_t NumTypeObjects = 15;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(128),
  LLT::vector(2, 1),
  LLT::vector(2, 32),
  LLT::vector(2, 64),
  LLT::vector(4, 1),
  LLT::vector(4, 16),
  LLT::vector(4, 32),
  LLT::vector(8, 1),
  LLT::vector(8, 8),
  LLT::vector(8, 16),
  LLT::vector(16, 1),
  LLT::vector(16, 8),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasAES,
  GIFBS_HasCRC,
  GIFBS_HasDotProd,
  GIFBS_HasFPARMv8,
  GIFBS_HasFullFP16,
  GIFBS_HasFuseAES,
  GIFBS_HasLSE,
  GIFBS_HasMTE,
  GIFBS_HasNEON,
  GIFBS_HasPerfMon,
  GIFBS_HasRDM,
  GIFBS_HasSHA2,
  GIFBS_HasSVE,
  GIFBS_HasTME,
  GIFBS_IsBE,
  GIFBS_IsLE,
  GIFBS_OptimizedGISelOrOtherSelector,
  GIFBS_UseSTRQro,
  GIFBS_HasComplxNum_HasNEON,
  GIFBS_HasFP16FML_HasNEON,
  GIFBS_HasFPARMv8_HasJS,
  GIFBS_HasFullFP16_HasNEON,
  GIFBS_HasNEON_HasRDM,
  GIFBS_IsLE_UseSTRQro,
  GIFBS_HasComplxNum_HasFullFP16_HasNEON,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasAESBit, },
  {Feature_HasCRCBit, },
  {Feature_HasDotProdBit, },
  {Feature_HasFPARMv8Bit, },
  {Feature_HasFullFP16Bit, },
  {Feature_HasFuseAESBit, },
  {Feature_HasLSEBit, },
  {Feature_HasMTEBit, },
  {Feature_HasNEONBit, },
  {Feature_HasPerfMonBit, },
  {Feature_HasRDMBit, },
  {Feature_HasSHA2Bit, },
  {Feature_HasSVEBit, },
  {Feature_HasTMEBit, },
  {Feature_IsBEBit, },
  {Feature_IsLEBit, },
  {Feature_OptimizedGISelOrOtherSelectorBit, },
  {Feature_UseSTRQroBit, },
  {Feature_HasComplxNumBit, Feature_HasNEONBit, },
  {Feature_HasFP16FMLBit, Feature_HasNEONBit, },
  {Feature_HasFPARMv8Bit, Feature_HasJSBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasNEONBit, Feature_HasRDMBit, },
  {Feature_IsLEBit, Feature_UseSTRQroBit, },
  {Feature_HasComplxNumBit, Feature_HasFullFP16Bit, Feature_HasNEONBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_addsub_shifted_imm32,
  GICP_gi_addsub_shifted_imm64,
  GICP_gi_am_indexed128,
  GICP_gi_am_indexed16,
  GICP_gi_am_indexed32,
  GICP_gi_am_indexed64,
  GICP_gi_am_indexed8,
  GICP_gi_am_unscaled128,
  GICP_gi_am_unscaled16,
  GICP_gi_am_unscaled32,
  GICP_gi_am_unscaled64,
  GICP_gi_am_unscaled8,
  GICP_gi_arith_extended_reg32_i32,
  GICP_gi_arith_extended_reg32_i64,
  GICP_gi_arith_extended_reg32to64_i64,
  GICP_gi_arith_shifted_reg32,
  GICP_gi_arith_shifted_reg64,
  GICP_gi_logical_shifted_reg32,
  GICP_gi_logical_shifted_reg64,
  GICP_gi_neg_addsub_shifted_imm32,
  GICP_gi_neg_addsub_shifted_imm64,
  GICP_gi_ro_Windexed128,
  GICP_gi_ro_Windexed16,
  GICP_gi_ro_Windexed32,
  GICP_gi_ro_Windexed64,
  GICP_gi_ro_Windexed8,
  GICP_gi_ro_Xindexed128,
  GICP_gi_ro_Xindexed16,
  GICP_gi_ro_Xindexed32,
  GICP_gi_ro_Xindexed64,
  GICP_gi_ro_Xindexed8,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_VectorIndex1 = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_VectorIndex132b,
  GIPFP_I64_Predicate_VectorIndexB,
  GIPFP_I64_Predicate_VectorIndexB32b,
  GIPFP_I64_Predicate_VectorIndexD,
  GIPFP_I64_Predicate_VectorIndexD32b,
  GIPFP_I64_Predicate_VectorIndexH,
  GIPFP_I64_Predicate_VectorIndexH32b,
  GIPFP_I64_Predicate_VectorIndexS,
  GIPFP_I64_Predicate_VectorIndexS32b,
  GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i16,
  GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i32,
  GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i64,
  GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i8,
  GIPFP_I64_Predicate_complexrotateop,
  GIPFP_I64_Predicate_complexrotateopodd,
  GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i16,
  GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i32,
  GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i64,
  GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i8,
  GIPFP_I64_Predicate_i32_imm0_65535,
  GIPFP_I64_Predicate_i64_imm0_65535,
  GIPFP_I64_Predicate_i64imm_32bit,
  GIPFP_I64_Predicate_imm0_1,
  GIPFP_I64_Predicate_imm0_127,
  GIPFP_I64_Predicate_imm0_127_64b,
  GIPFP_I64_Predicate_imm0_15,
  GIPFP_I64_Predicate_imm0_255,
  GIPFP_I64_Predicate_imm0_31,
  GIPFP_I64_Predicate_imm0_63,
  GIPFP_I64_Predicate_imm0_7,
  GIPFP_I64_Predicate_imm32_0_15,
  GIPFP_I64_Predicate_imm32_0_31,
  GIPFP_I64_Predicate_imm32_0_7,
  GIPFP_I64_Predicate_maski16_or_more,
  GIPFP_I64_Predicate_maski8_or_more,
  GIPFP_I64_Predicate_s64imm_32bit,
  GIPFP_I64_Predicate_simm4s1,
  GIPFP_I64_Predicate_simm4s16,
  GIPFP_I64_Predicate_simm4s2,
  GIPFP_I64_Predicate_simm4s3,
  GIPFP_I64_Predicate_simm4s4,
  GIPFP_I64_Predicate_simm5_32b,
  GIPFP_I64_Predicate_simm5_64b,
  GIPFP_I64_Predicate_simm6_32b,
  GIPFP_I64_Predicate_simm6s1,
  GIPFP_I64_Predicate_simm8,
  GIPFP_I64_Predicate_simm9,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_b,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_d,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_h,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_q,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_s,
  GIPFP_I64_Predicate_sve_incdec_imm,
  GIPFP_I64_Predicate_sve_pred_enum,
  GIPFP_I64_Predicate_sve_prfop,
  GIPFP_I64_Predicate_tbz_imm0_31_diag,
  GIPFP_I64_Predicate_tbz_imm0_31_nodiag,
  GIPFP_I64_Predicate_tbz_imm32_63,
  GIPFP_I64_Predicate_timm0_31,
  GIPFP_I64_Predicate_tuimm5s2,
  GIPFP_I64_Predicate_tuimm5s4,
  GIPFP_I64_Predicate_tuimm5s8,
  GIPFP_I64_Predicate_tvecshiftR16,
  GIPFP_I64_Predicate_tvecshiftR32,
  GIPFP_I64_Predicate_tvecshiftR8,
  GIPFP_I64_Predicate_uimm16,
  GIPFP_I64_Predicate_uimm5s2,
  GIPFP_I64_Predicate_uimm5s4,
  GIPFP_I64_Predicate_uimm5s8,
  GIPFP_I64_Predicate_uimm6,
  GIPFP_I64_Predicate_uimm6s1,
  GIPFP_I64_Predicate_uimm6s16,
  GIPFP_I64_Predicate_uimm6s2,
  GIPFP_I64_Predicate_uimm6s4,
  GIPFP_I64_Predicate_uimm6s8,
  GIPFP_I64_Predicate_vecshiftL16,
  GIPFP_I64_Predicate_vecshiftL32,
  GIPFP_I64_Predicate_vecshiftL64,
  GIPFP_I64_Predicate_vecshiftL8,
  GIPFP_I64_Predicate_vecshiftR16,
  GIPFP_I64_Predicate_vecshiftR16Narrow,
  GIPFP_I64_Predicate_vecshiftR32,
  GIPFP_I64_Predicate_vecshiftR32Narrow,
  GIPFP_I64_Predicate_vecshiftR64,
  GIPFP_I64_Predicate_vecshiftR64Narrow,
  GIPFP_I64_Predicate_vecshiftR8,
};
bool AArch64InstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_VectorIndex1: {
     return ((uint64_t)Imm) == 1; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndex132b: {
     return ((uint64_t)Imm) == 1; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexB: {
     return ((uint64_t)Imm) < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexB32b: {
     return ((uint64_t)Imm) < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexD: {
     return ((uint64_t)Imm) < 2; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexD32b: {
     return ((uint64_t)Imm) < 2; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexH: {
     return ((uint64_t)Imm) < 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexH32b: {
     return ((uint64_t)Imm) < 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexS: {
     return ((uint64_t)Imm) < 4; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexS32b: {
     return ((uint64_t)Imm) < 4; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i16: {
    
  return AArch64_AM::isSVEAddSubImm<int16_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i32: {
    
  return AArch64_AM::isSVEAddSubImm<int32_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i64: {
    
  return AArch64_AM::isSVEAddSubImm<int64_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i8: {
    
  return AArch64_AM::isSVEAddSubImm<int8_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_complexrotateop: {
     return Imm >= 0 && Imm <= 270;  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_complexrotateopodd: {
     return Imm >= 0 && Imm <= 270;  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i16: {
    
  return AArch64_AM::isSVECpyImm<int16_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i32: {
    
  return AArch64_AM::isSVECpyImm<int32_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i64: {
    
  return AArch64_AM::isSVECpyImm<int64_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i8: {
    
  return AArch64_AM::isSVECpyImm<int8_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_i32_imm0_65535: {
    
  return ((uint32_t)Imm) < 65536;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_i64_imm0_65535: {
    
  return ((uint64_t)Imm) < 65536;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_i64imm_32bit: {
    
  return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_1: {
    
  return ((uint64_t)Imm) < 2;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_127: {
    
  return ((uint32_t)Imm) < 128;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_127_64b: {
    
  return ((uint64_t)Imm) < 128;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_15: {
    
  return ((uint64_t)Imm) < 16;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_255: {
    
  return ((uint32_t)Imm) < 256;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_31: {
    
  return ((uint64_t)Imm) < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_63: {
    
  return ((uint64_t)Imm) < 64;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_7: {
    
  return ((uint64_t)Imm) < 8;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm32_0_15: {
    
  return ((uint32_t)Imm) < 16;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm32_0_31: {
    
  return ((uint64_t)Imm) < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm32_0_7: {
    
  return ((uint32_t)Imm) < 8;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_maski16_or_more: {
     return (Imm & 0xffff) == 0xffff; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_maski8_or_more: {
     return (Imm & 0xff) == 0xff; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_s64imm_32bit: {
    
  int64_t Imm64 = static_cast<int64_t>(Imm);
  return Imm64 >= std::numeric_limits<int32_t>::min() &&
         Imm64 <= std::numeric_limits<int32_t>::max();

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s1: {
     return Imm >=-8  && Imm <= 7; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s16: {
     return Imm >=-128  && Imm <= 112 && (Imm % 16) == 0x0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s2: {
     return Imm >=-16  && Imm <= 14 && (Imm % 2) == 0x0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s3: {
     return Imm >=-24  && Imm <= 21 && (Imm % 3) == 0x0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s4: {
     return Imm >=-32  && Imm <= 28 && (Imm % 4) == 0x0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_32b: {
     return Imm >= -16 && Imm < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_64b: {
     return Imm >= -16 && Imm < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm6_32b: {
     return Imm >= -32 && Imm < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm6s1: {
     return Imm >= -32 && Imm < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm8: {
     return Imm >= -128 && Imm < 127; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm9: {
     return Imm >= -256 && Imm < 256; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_b: {
     return ((uint64_t)Imm) < 64; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_d: {
     return ((uint64_t)Imm) < 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_h: {
     return ((uint64_t)Imm) < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_q: {
     return ((uint64_t)Imm) < 4; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_s: {
     return ((uint64_t)Imm) < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_incdec_imm: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_pred_enum: {
    
  return (((uint32_t)Imm) < 32);
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_prfop: {
    
    return (((uint32_t)Imm) <= 15);
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tbz_imm0_31_diag: {
    
  return (((uint32_t)Imm) < 32);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tbz_imm0_31_nodiag: {
    
  return (((uint32_t)Imm) < 32);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tbz_imm32_63: {
    
  return (((uint32_t)Imm) > 31) && (((uint32_t)Imm) < 64);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timm0_31: {
    
  return ((uint64_t)Imm) < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tuimm5s2: {
     return Imm >= 0 && Imm < (32*2) && ((Imm % 2) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tuimm5s4: {
     return Imm >= 0 && Imm < (32*4) && ((Imm % 4) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tuimm5s8: {
     return Imm >= 0 && Imm < (32*8) && ((Imm % 8) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tvecshiftR16: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tvecshiftR32: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tvecshiftR8: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm16: {
    return Imm >= 0 && Imm < 65536;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm5s2: {
     return Imm >= 0 && Imm < (32*2) && ((Imm % 2) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm5s4: {
     return Imm >= 0 && Imm < (32*4) && ((Imm % 4) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm5s8: {
     return Imm >= 0 && Imm < (32*8) && ((Imm % 8) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6: {
     return Imm >= 0 && Imm < 64; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6s1: {
     return Imm >= 0 && Imm < 64; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6s16: {
     return Imm >= 0 && Imm < (64*16) && ((Imm % 16) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6s2: {
     return Imm >= 0 && Imm < (64*2) && ((Imm % 2) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6s4: {
     return Imm >= 0 && Imm < (64*4) && ((Imm % 4) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6s8: {
     return Imm >= 0 && Imm < (64*8) && ((Imm % 8) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftL16: {
    
  return (((uint32_t)Imm) < 16);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftL32: {
    
  return (((uint32_t)Imm) < 32);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftL64: {
    
  return (((uint32_t)Imm) < 64);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftL8: {
    
  return (((uint32_t)Imm) < 8);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR16: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR16Narrow: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR32: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR32Narrow: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR64: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 65);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR64Narrow: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR8: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_APFloat_Predicate_fpimm0 = GIPFP_APFloat_Invalid + 1,
  GIPFP_APFloat_Predicate_fpimm16,
  GIPFP_APFloat_Predicate_fpimm32,
  GIPFP_APFloat_Predicate_fpimm64,
  GIPFP_APFloat_Predicate_simdimmtype10,
};
bool AArch64InstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GIPFP_APFloat_Predicate_fpimm0: {
    
  return Imm.isExactlyValue(+0.0);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_fpimm16: {
    
      return AArch64_AM::getFP16Imm(Imm) != -1;
    
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_fpimm32: {
    
      return AArch64_AM::getFP32Imm(Imm) != -1;
    
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_fpimm64: {
    
      return AArch64_AM::getFP64Imm(Imm) != -1;
    
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_simdimmtype10: {
    
      return AArch64_AM::isAdvSIMDModImmType10(
                 Imm.bitcastToAPInt().getZExtValue());
    
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_APInt_Predicate_logical_imm32 = GIPFP_APInt_Invalid + 1,
  GIPFP_APInt_Predicate_logical_imm64,
};
bool AArch64InstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GIPFP_APInt_Predicate_logical_imm32: {
    
  return AArch64_AM::isLogicalImmediate(Imm.getZExtValue(), 32);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APInt_Predicate_logical_imm64: {
    
  return AArch64_AM::isLogicalImmediate(Imm.getZExtValue(), 64);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_MI_Predicate_ldaxr_1 = GIPFP_MI_Invalid + 1,
  GIPFP_MI_Predicate_ldaxr_2,
  GIPFP_MI_Predicate_ldaxr_4,
  GIPFP_MI_Predicate_ldaxr_8,
  GIPFP_MI_Predicate_ldxr_1,
  GIPFP_MI_Predicate_ldxr_2,
  GIPFP_MI_Predicate_ldxr_4,
  GIPFP_MI_Predicate_ldxr_8,
  GIPFP_MI_Predicate_stlxr_1,
  GIPFP_MI_Predicate_stlxr_2,
  GIPFP_MI_Predicate_stlxr_4,
  GIPFP_MI_Predicate_stlxr_8,
  GIPFP_MI_Predicate_stxr_1,
  GIPFP_MI_Predicate_stxr_2,
  GIPFP_MI_Predicate_stxr_4,
  GIPFP_MI_Predicate_stxr_8,
};
bool AArch64InstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  switch (PredicateID) {
  case GIPFP_MI_Predicate_ldaxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_ldaxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_ldaxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_ldaxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_ldxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_ldxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_ldxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_ldxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stlxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stlxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stlxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stlxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}

AArch64InstructionSelector::ComplexMatcherMemFn
AArch64InstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &AArch64InstructionSelector::selectArithImmed, // gi_addsub_shifted_imm32
  &AArch64InstructionSelector::selectArithImmed, // gi_addsub_shifted_imm64
  &AArch64InstructionSelector::selectAddrModeIndexed<128>, // gi_am_indexed128
  &AArch64InstructionSelector::selectAddrModeIndexed<16>, // gi_am_indexed16
  &AArch64InstructionSelector::selectAddrModeIndexed<32>, // gi_am_indexed32
  &AArch64InstructionSelector::selectAddrModeIndexed<64>, // gi_am_indexed64
  &AArch64InstructionSelector::selectAddrModeIndexed<8>, // gi_am_indexed8
  &AArch64InstructionSelector::selectAddrModeUnscaled128, // gi_am_unscaled128
  &AArch64InstructionSelector::selectAddrModeUnscaled16, // gi_am_unscaled16
  &AArch64InstructionSelector::selectAddrModeUnscaled32, // gi_am_unscaled32
  &AArch64InstructionSelector::selectAddrModeUnscaled64, // gi_am_unscaled64
  &AArch64InstructionSelector::selectAddrModeUnscaled8, // gi_am_unscaled8
  &AArch64InstructionSelector::selectArithExtendedRegister, // gi_arith_extended_reg32_i32
  &AArch64InstructionSelector::selectArithExtendedRegister, // gi_arith_extended_reg32_i64
  &AArch64InstructionSelector::selectArithExtendedRegister, // gi_arith_extended_reg32to64_i64
  &AArch64InstructionSelector::selectArithShiftedRegister, // gi_arith_shifted_reg32
  &AArch64InstructionSelector::selectArithShiftedRegister, // gi_arith_shifted_reg64
  &AArch64InstructionSelector::selectLogicalShiftedRegister, // gi_logical_shifted_reg32
  &AArch64InstructionSelector::selectLogicalShiftedRegister, // gi_logical_shifted_reg64
  &AArch64InstructionSelector::selectNegArithImmed, // gi_neg_addsub_shifted_imm32
  &AArch64InstructionSelector::selectNegArithImmed, // gi_neg_addsub_shifted_imm64
  &AArch64InstructionSelector::selectAddrModeWRO<128>, // gi_ro_Windexed128
  &AArch64InstructionSelector::selectAddrModeWRO<16>, // gi_ro_Windexed16
  &AArch64InstructionSelector::selectAddrModeWRO<32>, // gi_ro_Windexed32
  &AArch64InstructionSelector::selectAddrModeWRO<64>, // gi_ro_Windexed64
  &AArch64InstructionSelector::selectAddrModeWRO<8>, // gi_ro_Windexed8
  &AArch64InstructionSelector::selectAddrModeXRO<128>, // gi_ro_Xindexed128
  &AArch64InstructionSelector::selectAddrModeXRO<16>, // gi_ro_Xindexed16
  &AArch64InstructionSelector::selectAddrModeXRO<32>, // gi_ro_Xindexed32
  &AArch64InstructionSelector::selectAddrModeXRO<64>, // gi_ro_Xindexed64
  &AArch64InstructionSelector::selectAddrModeXRO<8>, // gi_ro_Xindexed8
};

// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderLogicalImm32, 
  GICR_renderLogicalImm64, 
  GICR_renderTruncImm, 
};
AArch64InstructionSelector::CustomRendererFn
AArch64InstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &AArch64InstructionSelector::renderLogicalImm32, // gi_logical_imm32_XFORM
  &AArch64InstructionSelector::renderLogicalImm64, // gi_logical_imm64_XFORM
  &AArch64InstructionSelector::renderTruncImm, // gi_trunc_imm
};

bool AArch64InstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *AArch64InstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/35, 171, /*)*//*default:*//*Label 73*/ 114739,
    /*TargetOpcode::G_ADD*//*Label 0*/ 141,
    /*TargetOpcode::G_SUB*//*Label 1*/ 7282,
    /*TargetOpcode::G_MUL*//*Label 2*/ 9747,
    /*TargetOpcode::G_SDIV*//*Label 3*/ 10542,
    /*TargetOpcode::G_UDIV*//*Label 4*/ 10611, 0, 0,
    /*TargetOpcode::G_AND*//*Label 5*/ 10680,
    /*TargetOpcode::G_OR*//*Label 6*/ 12314,
    /*TargetOpcode::G_XOR*//*Label 7*/ 13308, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_CONCAT_VECTORS*//*Label 8*/ 14920, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 9*/ 21187,
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 10*/ 30112,
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 11*/ 30324,
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 12*/ 30536,
    /*TargetOpcode::G_LOAD*//*Label 13*/ 30564,
    /*TargetOpcode::G_SEXTLOAD*//*Label 14*/ 36849,
    /*TargetOpcode::G_ZEXTLOAD*//*Label 15*/ 37820, 0, 0, 0,
    /*TargetOpcode::G_STORE*//*Label 16*/ 39863, 0, 0,
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 17*/ 44202,
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 18*/ 45399,
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 19*/ 46428,
    /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 20*/ 47457,
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 21*/ 48886, 0,
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 22*/ 50315,
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 23*/ 51344,
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 24*/ 52373,
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 25*/ 53402,
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 26*/ 54431,
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 27*/ 55460, 0, 0,
    /*TargetOpcode::G_FENCE*//*Label 28*/ 56489, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 29*/ 56541,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 30*/ 94205,
    /*TargetOpcode::G_ANYEXT*//*Label 31*/ 97021,
    /*TargetOpcode::G_TRUNC*//*Label 32*/ 97201,
    /*TargetOpcode::G_CONSTANT*//*Label 33*/ 97329,
    /*TargetOpcode::G_FCONSTANT*//*Label 34*/ 97437, 0, 0,
    /*TargetOpcode::G_SEXT*//*Label 35*/ 97515, 0,
    /*TargetOpcode::G_ZEXT*//*Label 36*/ 97774,
    /*TargetOpcode::G_SHL*//*Label 37*/ 98235,
    /*TargetOpcode::G_LSHR*//*Label 38*/ 98548,
    /*TargetOpcode::G_ASHR*//*Label 39*/ 98933, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_UMULH*//*Label 40*/ 99428,
    /*TargetOpcode::G_SMULH*//*Label 41*/ 99865,
    /*TargetOpcode::G_FADD*//*Label 42*/ 100302,
    /*TargetOpcode::G_FSUB*//*Label 43*/ 100890,
    /*TargetOpcode::G_FMUL*//*Label 44*/ 101166,
    /*TargetOpcode::G_FMA*//*Label 45*/ 101835, 0,
    /*TargetOpcode::G_FDIV*//*Label 46*/ 105507, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FNEG*//*Label 47*/ 105783,
    /*TargetOpcode::G_FPEXT*//*Label 48*/ 106334,
    /*TargetOpcode::G_FPTRUNC*//*Label 49*/ 106465,
    /*TargetOpcode::G_FPTOSI*//*Label 50*/ 106596,
    /*TargetOpcode::G_FPTOUI*//*Label 51*/ 107499,
    /*TargetOpcode::G_SITOFP*//*Label 52*/ 108402,
    /*TargetOpcode::G_UITOFP*//*Label 53*/ 108683,
    /*TargetOpcode::G_FABS*//*Label 54*/ 110440, 0, 0,
    /*TargetOpcode::G_FMINNUM*//*Label 55*/ 111000,
    /*TargetOpcode::G_FMAXNUM*//*Label 56*/ 111288, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SMIN*//*Label 57*/ 111576,
    /*TargetOpcode::G_SMAX*//*Label 58*/ 111785,
    /*TargetOpcode::G_UMIN*//*Label 59*/ 111994,
    /*TargetOpcode::G_UMAX*//*Label 60*/ 112203,
    /*TargetOpcode::G_BR*//*Label 61*/ 112412, 0, 0,
    /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 62*/ 112425, 0,
    /*TargetOpcode::G_CTTZ*//*Label 63*/ 112784, 0,
    /*TargetOpcode::G_CTLZ*//*Label 64*/ 112887, 0,
    /*TargetOpcode::G_CTPOP*//*Label 65*/ 113514,
    /*TargetOpcode::G_BSWAP*//*Label 66*/ 113573,
    /*TargetOpcode::G_BITREVERSE*//*Label 67*/ 113626,
    /*TargetOpcode::G_FCEIL*//*Label 68*/ 113679, 0, 0,
    /*TargetOpcode::G_FSQRT*//*Label 69*/ 113891,
    /*TargetOpcode::G_FFLOOR*//*Label 70*/ 114103,
    /*TargetOpcode::G_FRINT*//*Label 71*/ 114315,
    /*TargetOpcode::G_FNEARBYINT*//*Label 72*/ 114527,
    // Label 0: @141
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 15, /*)*//*default:*//*Label 83*/ 7281,
    /*GILLT_s32*//*Label 74*/ 161,
    /*GILLT_s64*//*Label 75*/ 466, 0, 0,
    /*GILLT_v2s32*//*Label 76*/ 1880,
    /*GILLT_v2s64*//*Label 77*/ 2379, 0,
    /*GILLT_v4s16*//*Label 78*/ 3482,
    /*GILLT_v4s32*//*Label 79*/ 3981, 0,
    /*GILLT_v8s8*//*Label 80*/ 5340,
    /*GILLT_v8s16*//*Label 81*/ 5631, 0,
    /*GILLT_v16s8*//*Label 82*/ 6990,
    // Label 74: @161
    GIM_Try, /*On fail goto*//*Label 84*/ 465,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 85*/ 205, // Rule ID 5384 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_addsub_shifted_imm32,
        // (add:{ *:[i32] } addsub_shifted_imm32:{ *:[i32] }:$imm, GPR32sp:{ *:[i32] }:$Rn)  =>  (ADDWri:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5384,
        GIR_Done,
      // Label 85: @205
      GIM_Try, /*On fail goto*//*Label 86*/ 239, // Rule ID 61 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm32,
        // (add:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (ADDWri:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61,
        GIR_Done,
      // Label 86: @239
      GIM_Try, /*On fail goto*//*Label 87*/ 273, // Rule ID 5388 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_arith_extended_reg32_i32,
        // (add:{ *:[i32] } arith_extended_reg32_i32:{ *:[i32] }:$R3, GPR32sp:{ *:[i32] }:$R2)  =>  (ADDWrx:{ *:[i32] } GPR32sp:{ *:[i32] }:$R2, arith_extended_reg32_i32:{ *:[i32] }:$R3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // R1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // R2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // R3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5388,
        GIR_Done,
      // Label 87: @273
      GIM_Try, /*On fail goto*//*Label 88*/ 307, // Rule ID 5641 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm32,
        // (add:{ *:[i32] } neg_addsub_shifted_imm32:{ *:[i32] }:$imm, GPR32:{ *:[i32] }:$Rn)  =>  (SUBSWri:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5641,
        GIR_Done,
      // Label 88: @307
      GIM_Try, /*On fail goto*//*Label 89*/ 341, // Rule ID 67 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_extended_reg32_i32,
        // (add:{ *:[i32] } GPR32sp:{ *:[i32] }:$R2, arith_extended_reg32_i32:{ *:[i32] }:$R3)  =>  (ADDWrx:{ *:[i32] } GPR32sp:{ *:[i32] }:$R2, arith_extended_reg32_i32:{ *:[i32] }:$R3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // R1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // R2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // R3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 67,
        GIR_Done,
      // Label 89: @341
      GIM_Try, /*On fail goto*//*Label 90*/ 375, // Rule ID 2343 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm32,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (SUBSWri:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2343,
        GIR_Done,
      // Label 90: @375
      GIM_Try, /*On fail goto*//*Label 91*/ 409, // Rule ID 5386 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_arith_shifted_reg32,
        // (add:{ *:[i32] } arith_shifted_reg32:{ *:[i32] }:$Rm, GPR32:{ *:[i32] }:$Rn)  =>  (ADDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5386,
        GIR_Done,
      // Label 91: @409
      GIM_Try, /*On fail goto*//*Label 92*/ 443, // Rule ID 65 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_shifted_reg32,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm)  =>  (ADDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65,
        GIR_Done,
      // Label 92: @443
      GIM_Try, /*On fail goto*//*Label 93*/ 464, // Rule ID 63 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ADDWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 63,
        GIR_Done,
      // Label 93: @464
      GIM_Reject,
    // Label 84: @465
    GIM_Reject,
    // Label 75: @466
    GIM_Try, /*On fail goto*//*Label 94*/ 1879,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 95*/ 545, // Rule ID 4040 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 0,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] Rn
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 0:{ *:[i64] }), (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 1:{ *:[i64] }))  =>  (ADDPv2i64p:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDPv2i64p,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4040,
        GIR_Done,
      // Label 95: @545
      GIM_Try, /*On fail goto*//*Label 96*/ 614, // Rule ID 5814 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] Rn
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 0,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 1:{ *:[i64] }), (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 0:{ *:[i64] }))  =>  (ADDPv2i64p:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDPv2i64p,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5814,
        GIR_Done,
      // Label 96: @614
      GIM_Try, /*On fail goto*//*Label 97*/ 648, // Rule ID 5385 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_addsub_shifted_imm64,
        // (add:{ *:[i64] } addsub_shifted_imm64:{ *:[i64] }:$imm, GPR64sp:{ *:[i64] }:$Rn)  =>  (ADDXri:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5385,
        GIR_Done,
      // Label 97: @648
      GIM_Try, /*On fail goto*//*Label 98*/ 744, // Rule ID 2389 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C), GPR64:{ *:[i64] }:$Ra)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2389,
        GIR_Done,
      // Label 98: @744
      GIM_Try, /*On fail goto*//*Label 99*/ 840, // Rule ID 2390 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C), GPR64:{ *:[i64] }:$Ra)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2390,
        GIR_Done,
      // Label 99: @840
      GIM_Try, /*On fail goto*//*Label 100*/ 874, // Rule ID 62 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm64,
        // (add:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (ADDXri:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62,
        GIR_Done,
      // Label 100: @874
      GIM_Try, /*On fail goto*//*Label 101*/ 970, // Rule ID 5647 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5647,
        GIR_Done,
      // Label 101: @970
      GIM_Try, /*On fail goto*//*Label 102*/ 1066, // Rule ID 5648 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5648,
        GIR_Done,
      // Label 102: @1066
      GIM_Try, /*On fail goto*//*Label 103*/ 1151, // Rule ID 5396 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)), GPR64:{ *:[i64] }:$Ra)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5396,
        GIR_Done,
      // Label 103: @1151
      GIM_Try, /*On fail goto*//*Label 104*/ 1236, // Rule ID 5397 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)), GPR64:{ *:[i64] }:$Ra)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5397,
        GIR_Done,
      // Label 104: @1236
      GIM_Try, /*On fail goto*//*Label 105*/ 1321, // Rule ID 93 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 93,
        GIR_Done,
      // Label 105: @1321
      GIM_Try, /*On fail goto*//*Label 106*/ 1406, // Rule ID 95 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 95,
        GIR_Done,
      // Label 106: @1406
      GIM_Try, /*On fail goto*//*Label 107*/ 1440, // Rule ID 5389 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_arith_extended_reg32to64_i64,
        // (add:{ *:[i64] } arith_extended_reg32to64_i64:{ *:[i64] }:$R3, GPR64sp:{ *:[i64] }:$R2)  =>  (ADDXrx:{ *:[i64] } GPR64sp:{ *:[i64] }:$R2, arith_extended_reg32to64_i64:{ *:[i64] }:$R3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // R1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // R2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // R3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5389,
        GIR_Done,
      // Label 107: @1440
      GIM_Try, /*On fail goto*//*Label 108*/ 1474, // Rule ID 5642 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm64,
        // (add:{ *:[i64] } neg_addsub_shifted_imm64:{ *:[i64] }:$imm, GPR64:{ *:[i64] }:$Rn)  =>  (SUBSXri:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5642,
        GIR_Done,
      // Label 108: @1474
      GIM_Try, /*On fail goto*//*Label 109*/ 1508, // Rule ID 68 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_extended_reg32to64_i64,
        // (add:{ *:[i64] } GPR64sp:{ *:[i64] }:$R2, arith_extended_reg32to64_i64:{ *:[i64] }:$R3)  =>  (ADDXrx:{ *:[i64] } GPR64sp:{ *:[i64] }:$R2, arith_extended_reg32to64_i64:{ *:[i64] }:$R3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // R1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // R2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // R3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 68,
        GIR_Done,
      // Label 109: @1508
      GIM_Try, /*On fail goto*//*Label 110*/ 1542, // Rule ID 2344 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm64,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (SUBSXri:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2344,
        GIR_Done,
      // Label 110: @1542
      GIM_Try, /*On fail goto*//*Label 111*/ 1576, // Rule ID 5387 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_arith_shifted_reg64,
        // (add:{ *:[i64] } arith_shifted_reg64:{ *:[i64] }:$Rm, GPR64:{ *:[i64] }:$Rn)  =>  (ADDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5387,
        GIR_Done,
      // Label 111: @1576
      GIM_Try, /*On fail goto*//*Label 112*/ 1610, // Rule ID 66 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_shifted_reg64,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm)  =>  (ADDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 66,
        GIR_Done,
      // Label 112: @1610
      GIM_Try, /*On fail goto*//*Label 113*/ 1666, // Rule ID 5462 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } (intrinsic_wo_chain:{ *:[v1i64] } 371:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5462,
        GIR_Done,
      // Label 113: @1666
      GIM_Try, /*On fail goto*//*Label 114*/ 1722, // Rule ID 5468 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } (intrinsic_wo_chain:{ *:[v1i64] } 429:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5468,
        GIR_Done,
      // Label 114: @1722
      GIM_Try, /*On fail goto*//*Label 115*/ 1778, // Rule ID 791 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (intrinsic_wo_chain:{ *:[v1i64] } 371:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn))  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 791,
        GIR_Done,
      // Label 115: @1778
      GIM_Try, /*On fail goto*//*Label 116*/ 1834, // Rule ID 835 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (intrinsic_wo_chain:{ *:[v1i64] } 429:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn))  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 835,
        GIR_Done,
      // Label 116: @1834
      GIM_Try, /*On fail goto*//*Label 117*/ 1855, // Rule ID 64 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ADDXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64,
        GIR_Done,
      // Label 117: @1855
      GIM_Try, /*On fail goto*//*Label 118*/ 1878, // Rule ID 1278 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)  =>  (ADDv1i64:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv1i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1278,
        GIR_Done,
      // Label 118: @1878
      GIM_Reject,
    // Label 94: @1879
    GIM_Reject,
    // Label 76: @1880
    GIM_Try, /*On fail goto*//*Label 119*/ 2378,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 120*/ 1958, // Rule ID 5474 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 370:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V64:{ *:[v2i32] }:$Rd)  =>  (SABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5474,
        GIR_Done,
      // Label 120: @1958
      GIM_Try, /*On fail goto*//*Label 121*/ 2022, // Rule ID 5480 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 428:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V64:{ *:[v2i32] }:$Rd)  =>  (UABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5480,
        GIR_Done,
      // Label 121: @2022
      GIM_Try, /*On fail goto*//*Label 122*/ 2074, // Rule ID 5460 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 371:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5460,
        GIR_Done,
      // Label 122: @2074
      GIM_Try, /*On fail goto*//*Label 123*/ 2126, // Rule ID 5466 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 429:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5466,
        GIR_Done,
      // Label 123: @2126
      GIM_Try, /*On fail goto*//*Label 124*/ 2190, // Rule ID 1053 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 370:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (SABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1053,
        GIR_Done,
      // Label 124: @2190
      GIM_Try, /*On fail goto*//*Label 125*/ 2254, // Rule ID 1164 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 428:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (UABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1164,
        GIR_Done,
      // Label 125: @2254
      GIM_Try, /*On fail goto*//*Label 126*/ 2306, // Rule ID 789 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 371:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn))  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 789,
        GIR_Done,
      // Label 126: @2306
      GIM_Try, /*On fail goto*//*Label 127*/ 2358, // Rule ID 833 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 429:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn))  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 833,
        GIR_Done,
      // Label 127: @2358
      GIM_Try, /*On fail goto*//*Label 128*/ 2377, // Rule ID 869 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (ADDv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv2i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 869,
        GIR_Done,
      // Label 128: @2377
      GIM_Reject,
    // Label 119: @2378
    GIM_Reject,
    // Label 77: @2379
    GIM_Try, /*On fail goto*//*Label 129*/ 3481,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 130*/ 2470, // Rule ID 5528 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 370:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (SABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5528,
        GIR_Done,
      // Label 130: @2470
      GIM_Try, /*On fail goto*//*Label 131*/ 2547, // Rule ID 5546 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 428:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (UABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5546,
        GIR_Done,
      // Label 131: @2547
      GIM_Try, /*On fail goto*//*Label 132*/ 2624, // Rule ID 1360 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 370:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)))  =>  (SABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1360,
        GIR_Done,
      // Label 132: @2624
      GIM_Try, /*On fail goto*//*Label 133*/ 2701, // Rule ID 1426 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 428:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)))  =>  (UABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1426,
        GIR_Done,
      // Label 133: @2701
      GIM_Try, /*On fail goto*//*Label 134*/ 2765, // Rule ID 5540 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 387:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rd)  =>  (SMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5540,
        GIR_Done,
      // Label 134: @2765
      GIM_Try, /*On fail goto*//*Label 135*/ 2829, // Rule ID 5558 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 441:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rd)  =>  (UMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5558,
        GIR_Done,
      // Label 135: @2829
      GIM_Try, /*On fail goto*//*Label 136*/ 2881, // Rule ID 5463 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 371:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5463,
        GIR_Done,
      // Label 136: @2881
      GIM_Try, /*On fail goto*//*Label 137*/ 2933, // Rule ID 5469 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 429:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5469,
        GIR_Done,
      // Label 137: @2933
      GIM_Try, /*On fail goto*//*Label 138*/ 2997, // Rule ID 1384 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 387:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (SMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1384,
        GIR_Done,
      // Label 138: @2997
      GIM_Try, /*On fail goto*//*Label 139*/ 3061, // Rule ID 1444 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 441:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (UMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1444,
        GIR_Done,
      // Label 139: @3061
      GIM_Try, /*On fail goto*//*Label 140*/ 3113, // Rule ID 792 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 371:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn))  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 792,
        GIR_Done,
      // Label 140: @3113
      GIM_Try, /*On fail goto*//*Label 141*/ 3165, // Rule ID 836 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 429:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn))  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 836,
        GIR_Done,
      // Label 141: @3165
      GIM_Try, /*On fail goto*//*Label 142*/ 3223, // Rule ID 1372 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1372,
        GIR_Done,
      // Label 142: @3223
      GIM_Try, /*On fail goto*//*Label 143*/ 3281, // Rule ID 1432 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1432,
        GIR_Done,
      // Label 143: @3281
      GIM_Try, /*On fail goto*//*Label 144*/ 3326, // Rule ID 5534 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (SADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5534,
        GIR_Done,
      // Label 144: @3326
      GIM_Try, /*On fail goto*//*Label 145*/ 3371, // Rule ID 5552 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5552,
        GIR_Done,
      // Label 145: @3371
      GIM_Try, /*On fail goto*//*Label 146*/ 3416, // Rule ID 1378 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1378,
        GIR_Done,
      // Label 146: @3416
      GIM_Try, /*On fail goto*//*Label 147*/ 3461, // Rule ID 1438 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1438,
        GIR_Done,
      // Label 147: @3461
      GIM_Try, /*On fail goto*//*Label 148*/ 3480, // Rule ID 871 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)  =>  (ADDv2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv2i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 871,
        GIR_Done,
      // Label 148: @3480
      GIM_Reject,
    // Label 129: @3481
    GIM_Reject,
    // Label 78: @3482
    GIM_Try, /*On fail goto*//*Label 149*/ 3980,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 150*/ 3560, // Rule ID 5472 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 370:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V64:{ *:[v4i16] }:$Rd)  =>  (SABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5472,
        GIR_Done,
      // Label 150: @3560
      GIM_Try, /*On fail goto*//*Label 151*/ 3624, // Rule ID 5478 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 428:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V64:{ *:[v4i16] }:$Rd)  =>  (UABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5478,
        GIR_Done,
      // Label 151: @3624
      GIM_Try, /*On fail goto*//*Label 152*/ 3676, // Rule ID 5458 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 371:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5458,
        GIR_Done,
      // Label 152: @3676
      GIM_Try, /*On fail goto*//*Label 153*/ 3728, // Rule ID 5464 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 429:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5464,
        GIR_Done,
      // Label 153: @3728
      GIM_Try, /*On fail goto*//*Label 154*/ 3792, // Rule ID 1051 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 370:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (SABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1051,
        GIR_Done,
      // Label 154: @3792
      GIM_Try, /*On fail goto*//*Label 155*/ 3856, // Rule ID 1162 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 428:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (UABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1162,
        GIR_Done,
      // Label 155: @3856
      GIM_Try, /*On fail goto*//*Label 156*/ 3908, // Rule ID 787 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 371:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn))  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 787,
        GIR_Done,
      // Label 156: @3908
      GIM_Try, /*On fail goto*//*Label 157*/ 3960, // Rule ID 831 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 429:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn))  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 831,
        GIR_Done,
      // Label 157: @3960
      GIM_Try, /*On fail goto*//*Label 158*/ 3979, // Rule ID 867 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (ADDv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv4i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 867,
        GIR_Done,
      // Label 158: @3979
      GIM_Reject,
    // Label 149: @3980
    GIM_Reject,
    // Label 79: @3981
    GIM_Try, /*On fail goto*//*Label 159*/ 5339,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 160*/ 4072, // Rule ID 5526 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 370:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (SABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5526,
        GIR_Done,
      // Label 160: @4072
      GIM_Try, /*On fail goto*//*Label 161*/ 4149, // Rule ID 5544 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 428:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (UABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5544,
        GIR_Done,
      // Label 161: @4149
      GIM_Try, /*On fail goto*//*Label 162*/ 4226, // Rule ID 1358 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 370:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)))  =>  (SABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1358,
        GIR_Done,
      // Label 162: @4226
      GIM_Try, /*On fail goto*//*Label 163*/ 4303, // Rule ID 1424 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 428:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)))  =>  (UABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1424,
        GIR_Done,
      // Label 163: @4303
      GIM_Try, /*On fail goto*//*Label 164*/ 4367, // Rule ID 5475 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 370:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (SABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5475,
        GIR_Done,
      // Label 164: @4367
      GIM_Try, /*On fail goto*//*Label 165*/ 4431, // Rule ID 5481 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 428:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (UABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5481,
        GIR_Done,
      // Label 165: @4431
      GIM_Try, /*On fail goto*//*Label 166*/ 4495, // Rule ID 5538 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 387:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (SMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5538,
        GIR_Done,
      // Label 166: @4495
      GIM_Try, /*On fail goto*//*Label 167*/ 4559, // Rule ID 5556 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 441:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (UMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5556,
        GIR_Done,
      // Label 167: @4559
      GIM_Try, /*On fail goto*//*Label 168*/ 4611, // Rule ID 5461 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 371:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5461,
        GIR_Done,
      // Label 168: @4611
      GIM_Try, /*On fail goto*//*Label 169*/ 4663, // Rule ID 5467 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 429:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5467,
        GIR_Done,
      // Label 169: @4663
      GIM_Try, /*On fail goto*//*Label 170*/ 4727, // Rule ID 1054 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 370:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (SABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1054,
        GIR_Done,
      // Label 170: @4727
      GIM_Try, /*On fail goto*//*Label 171*/ 4791, // Rule ID 1165 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 428:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (UABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1165,
        GIR_Done,
      // Label 171: @4791
      GIM_Try, /*On fail goto*//*Label 172*/ 4855, // Rule ID 1382 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 387:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (SMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1382,
        GIR_Done,
      // Label 172: @4855
      GIM_Try, /*On fail goto*//*Label 173*/ 4919, // Rule ID 1442 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 441:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (UMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1442,
        GIR_Done,
      // Label 173: @4919
      GIM_Try, /*On fail goto*//*Label 174*/ 4971, // Rule ID 790 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 371:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn))  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 790,
        GIR_Done,
      // Label 174: @4971
      GIM_Try, /*On fail goto*//*Label 175*/ 5023, // Rule ID 834 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 429:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn))  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 834,
        GIR_Done,
      // Label 175: @5023
      GIM_Try, /*On fail goto*//*Label 176*/ 5081, // Rule ID 1370 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1370,
        GIR_Done,
      // Label 176: @5081
      GIM_Try, /*On fail goto*//*Label 177*/ 5139, // Rule ID 1430 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1430,
        GIR_Done,
      // Label 177: @5139
      GIM_Try, /*On fail goto*//*Label 178*/ 5184, // Rule ID 5532 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (SADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5532,
        GIR_Done,
      // Label 178: @5184
      GIM_Try, /*On fail goto*//*Label 179*/ 5229, // Rule ID 5550 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5550,
        GIR_Done,
      // Label 179: @5229
      GIM_Try, /*On fail goto*//*Label 180*/ 5274, // Rule ID 1376 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1376,
        GIR_Done,
      // Label 180: @5274
      GIM_Try, /*On fail goto*//*Label 181*/ 5319, // Rule ID 1436 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1436,
        GIR_Done,
      // Label 181: @5319
      GIM_Try, /*On fail goto*//*Label 182*/ 5338, // Rule ID 870 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (ADDv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv4i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 870,
        GIR_Done,
      // Label 182: @5338
      GIM_Reject,
    // Label 159: @5339
    GIM_Reject,
    // Label 80: @5340
    GIM_Try, /*On fail goto*//*Label 183*/ 5630,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 184*/ 5418, // Rule ID 5470 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 370:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V64:{ *:[v8i8] }:$Rd)  =>  (SABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5470,
        GIR_Done,
      // Label 184: @5418
      GIM_Try, /*On fail goto*//*Label 185*/ 5482, // Rule ID 5476 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 428:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V64:{ *:[v8i8] }:$Rd)  =>  (UABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5476,
        GIR_Done,
      // Label 185: @5482
      GIM_Try, /*On fail goto*//*Label 186*/ 5546, // Rule ID 1049 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 370:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (SABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1049,
        GIR_Done,
      // Label 186: @5546
      GIM_Try, /*On fail goto*//*Label 187*/ 5610, // Rule ID 1160 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 428:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (UABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1160,
        GIR_Done,
      // Label 187: @5610
      GIM_Try, /*On fail goto*//*Label 188*/ 5629, // Rule ID 865 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (ADDv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 865,
        GIR_Done,
      // Label 188: @5629
      GIM_Reject,
    // Label 183: @5630
    GIM_Reject,
    // Label 81: @5631
    GIM_Try, /*On fail goto*//*Label 189*/ 6989,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 190*/ 5722, // Rule ID 5524 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 370:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (SABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5524,
        GIR_Done,
      // Label 190: @5722
      GIM_Try, /*On fail goto*//*Label 191*/ 5799, // Rule ID 5542 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 428:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (UABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5542,
        GIR_Done,
      // Label 191: @5799
      GIM_Try, /*On fail goto*//*Label 192*/ 5876, // Rule ID 1356 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 370:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)))  =>  (SABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1356,
        GIR_Done,
      // Label 192: @5876
      GIM_Try, /*On fail goto*//*Label 193*/ 5953, // Rule ID 1422 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 428:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)))  =>  (UABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1422,
        GIR_Done,
      // Label 193: @5953
      GIM_Try, /*On fail goto*//*Label 194*/ 6017, // Rule ID 5473 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 370:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (SABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5473,
        GIR_Done,
      // Label 194: @6017
      GIM_Try, /*On fail goto*//*Label 195*/ 6081, // Rule ID 5479 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 428:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (UABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5479,
        GIR_Done,
      // Label 195: @6081
      GIM_Try, /*On fail goto*//*Label 196*/ 6145, // Rule ID 5536 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 387:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (SMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5536,
        GIR_Done,
      // Label 196: @6145
      GIM_Try, /*On fail goto*//*Label 197*/ 6209, // Rule ID 5554 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 441:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (UMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5554,
        GIR_Done,
      // Label 197: @6209
      GIM_Try, /*On fail goto*//*Label 198*/ 6261, // Rule ID 5459 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 371:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5459,
        GIR_Done,
      // Label 198: @6261
      GIM_Try, /*On fail goto*//*Label 199*/ 6313, // Rule ID 5465 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 429:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (UADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5465,
        GIR_Done,
      // Label 199: @6313
      GIM_Try, /*On fail goto*//*Label 200*/ 6377, // Rule ID 1052 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 370:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (SABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1052,
        GIR_Done,
      // Label 200: @6377
      GIM_Try, /*On fail goto*//*Label 201*/ 6441, // Rule ID 1163 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 428:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (UABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1163,
        GIR_Done,
      // Label 201: @6441
      GIM_Try, /*On fail goto*//*Label 202*/ 6505, // Rule ID 1380 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 387:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (SMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1380,
        GIR_Done,
      // Label 202: @6505
      GIM_Try, /*On fail goto*//*Label 203*/ 6569, // Rule ID 1440 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 441:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (UMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1440,
        GIR_Done,
      // Label 203: @6569
      GIM_Try, /*On fail goto*//*Label 204*/ 6621, // Rule ID 788 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 371:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn))  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 788,
        GIR_Done,
      // Label 204: @6621
      GIM_Try, /*On fail goto*//*Label 205*/ 6673, // Rule ID 832 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 429:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn))  =>  (UADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 832,
        GIR_Done,
      // Label 205: @6673
      GIM_Try, /*On fail goto*//*Label 206*/ 6731, // Rule ID 1368 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1368,
        GIR_Done,
      // Label 206: @6731
      GIM_Try, /*On fail goto*//*Label 207*/ 6789, // Rule ID 1428 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1428,
        GIR_Done,
      // Label 207: @6789
      GIM_Try, /*On fail goto*//*Label 208*/ 6834, // Rule ID 5530 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (SADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5530,
        GIR_Done,
      // Label 208: @6834
      GIM_Try, /*On fail goto*//*Label 209*/ 6879, // Rule ID 5548 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5548,
        GIR_Done,
      // Label 209: @6879
      GIM_Try, /*On fail goto*//*Label 210*/ 6924, // Rule ID 1374 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1374,
        GIR_Done,
      // Label 210: @6924
      GIM_Try, /*On fail goto*//*Label 211*/ 6969, // Rule ID 1434 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1434,
        GIR_Done,
      // Label 211: @6969
      GIM_Try, /*On fail goto*//*Label 212*/ 6988, // Rule ID 868 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)  =>  (ADDv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv8i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 868,
        GIR_Done,
      // Label 212: @6988
      GIM_Reject,
    // Label 189: @6989
    GIM_Reject,
    // Label 82: @6990
    GIM_Try, /*On fail goto*//*Label 213*/ 7280,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 214*/ 7068, // Rule ID 5471 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 370:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm), V128:{ *:[v16i8] }:$Rd)  =>  (SABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5471,
        GIR_Done,
      // Label 214: @7068
      GIM_Try, /*On fail goto*//*Label 215*/ 7132, // Rule ID 5477 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 428:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm), V128:{ *:[v16i8] }:$Rd)  =>  (UABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5477,
        GIR_Done,
      // Label 215: @7132
      GIM_Try, /*On fail goto*//*Label 216*/ 7196, // Rule ID 1050 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (intrinsic_wo_chain:{ *:[v16i8] } 370:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm))  =>  (SABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1050,
        GIR_Done,
      // Label 216: @7196
      GIM_Try, /*On fail goto*//*Label 217*/ 7260, // Rule ID 1161 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (intrinsic_wo_chain:{ *:[v16i8] } 428:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm))  =>  (UABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1161,
        GIR_Done,
      // Label 217: @7260
      GIM_Try, /*On fail goto*//*Label 218*/ 7279, // Rule ID 866 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (ADDv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 866,
        GIR_Done,
      // Label 218: @7279
      GIM_Reject,
    // Label 213: @7280
    GIM_Reject,
    // Label 83: @7281
    GIM_Reject,
    // Label 1: @7282
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 15, /*)*//*default:*//*Label 228*/ 9746,
    /*GILLT_s32*//*Label 219*/ 7302,
    /*GILLT_s64*//*Label 220*/ 7533, 0, 0,
    /*GILLT_v2s32*//*Label 221*/ 8511,
    /*GILLT_v2s64*//*Label 222*/ 8543, 0,
    /*GILLT_v4s16*//*Label 223*/ 8912,
    /*GILLT_v4s32*//*Label 224*/ 8944, 0,
    /*GILLT_v8s8*//*Label 225*/ 9313,
    /*GILLT_v8s16*//*Label 226*/ 9345, 0,
    /*GILLT_v16s8*//*Label 227*/ 9714,
    // Label 219: @7302
    GIM_Try, /*On fail goto*//*Label 229*/ 7532,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 230*/ 7371, // Rule ID 2375 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, (mul:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm))  =>  (MSUBWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2375,
        GIR_Done,
      // Label 230: @7371
      GIM_Try, /*On fail goto*//*Label 231*/ 7405, // Rule ID 2341 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_extended_reg32_i32,
        // (sub:{ *:[i32] } GPR32sp:{ *:[i32] }:$R2, arith_extended_reg32_i32:{ *:[i32] }:$R3)  =>  (SUBSWrx:{ *:[i32] }:{ *:[i32] } GPR32sp:{ *:[i32] }:$R2, arith_extended_reg32_i32:{ *:[i32] }:$R3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // R1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // R2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // R3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2341,
        GIR_Done,
      // Label 231: @7405
      GIM_Try, /*On fail goto*//*Label 232*/ 7439, // Rule ID 2345 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm32,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (ADDWri:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2345,
        GIR_Done,
      // Label 232: @7439
      GIM_Try, /*On fail goto*//*Label 233*/ 7473, // Rule ID 2335 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm32,
        // (sub:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (SUBSWri:{ *:[i32] }:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2335,
        GIR_Done,
      // Label 233: @7473
      GIM_Try, /*On fail goto*//*Label 234*/ 7507, // Rule ID 2339 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_shifted_reg32,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm)  =>  (SUBSWrs:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2339,
        GIR_Done,
      // Label 234: @7507
      GIM_Try, /*On fail goto*//*Label 235*/ 7531, // Rule ID 2337 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (SUBSWrr:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBSWrr,
        GIR_AddImplicitDef, /*InsnID*/0, AArch64::NZCV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2337,
        GIR_Done,
      // Label 235: @7531
      GIM_Reject,
    // Label 229: @7532
    GIM_Reject,
    // Label 220: @7533
    GIM_Try, /*On fail goto*//*Label 236*/ 8510,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 237*/ 7639, // Rule ID 2386 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2386,
        GIR_Done,
      // Label 237: @7639
      GIM_Try, /*On fail goto*//*Label 238*/ 7735, // Rule ID 2387 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2387,
        GIR_Done,
      // Label 238: @7735
      GIM_Try, /*On fail goto*//*Label 239*/ 7820, // Rule ID 2381 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2381,
        GIR_Done,
      // Label 239: @7820
      GIM_Try, /*On fail goto*//*Label 240*/ 7905, // Rule ID 2382 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2382,
        GIR_Done,
      // Label 240: @7905
      GIM_Try, /*On fail goto*//*Label 241*/ 8001, // Rule ID 2392 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2392,
        GIR_Done,
      // Label 241: @8001
      GIM_Try, /*On fail goto*//*Label 242*/ 8097, // Rule ID 2393 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2393,
        GIR_Done,
      // Label 242: @8097
      GIM_Try, /*On fail goto*//*Label 243*/ 8182, // Rule ID 94 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 94,
        GIR_Done,
      // Label 243: @8182
      GIM_Try, /*On fail goto*//*Label 244*/ 8267, // Rule ID 96 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 96,
        GIR_Done,
      // Label 244: @8267
      GIM_Try, /*On fail goto*//*Label 245*/ 8326, // Rule ID 2376 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm))  =>  (MSUBXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2376,
        GIR_Done,
      // Label 245: @8326
      GIM_Try, /*On fail goto*//*Label 246*/ 8360, // Rule ID 2342 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_extended_reg32to64_i64,
        // (sub:{ *:[i64] } GPR64sp:{ *:[i64] }:$R2, arith_extended_reg32to64_i64:{ *:[i64] }:$R3)  =>  (SUBSXrx:{ *:[i64] }:{ *:[i32] } GPR64sp:{ *:[i64] }:$R2, arith_extended_reg32to64_i64:{ *:[i64] }:$R3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // R1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // R2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // R3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2342,
        GIR_Done,
      // Label 246: @8360
      GIM_Try, /*On fail goto*//*Label 247*/ 8394, // Rule ID 2346 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm64,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (ADDXri:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2346,
        GIR_Done,
      // Label 247: @8394
      GIM_Try, /*On fail goto*//*Label 248*/ 8428, // Rule ID 2336 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm64,
        // (sub:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (SUBSXri:{ *:[i64] }:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2336,
        GIR_Done,
      // Label 248: @8428
      GIM_Try, /*On fail goto*//*Label 249*/ 8462, // Rule ID 2340 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_shifted_reg64,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm)  =>  (SUBSXrs:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2340,
        GIR_Done,
      // Label 249: @8462
      GIM_Try, /*On fail goto*//*Label 250*/ 8485, // Rule ID 1315 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (sub:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)  =>  (SUBv1i64:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv1i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1315,
        GIR_Done,
      // Label 250: @8485
      GIM_Try, /*On fail goto*//*Label 251*/ 8509, // Rule ID 2338 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (SUBSXrr:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBSXrr,
        GIR_AddImplicitDef, /*InsnID*/0, AArch64::NZCV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2338,
        GIR_Done,
      // Label 251: @8509
      GIM_Reject,
    // Label 236: @8510
    GIM_Reject,
    // Label 221: @8511
    GIM_Try, /*On fail goto*//*Label 252*/ 8542, // Rule ID 1157 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (sub:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (SUBv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1157,
      GIR_Done,
    // Label 252: @8542
    GIM_Reject,
    // Label 222: @8543
    GIM_Try, /*On fail goto*//*Label 253*/ 8911,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 254*/ 8621, // Rule ID 1390 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 387:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (SMLSLv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLSLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1390,
        GIR_Done,
      // Label 254: @8621
      GIM_Try, /*On fail goto*//*Label 255*/ 8685, // Rule ID 1450 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 441:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (UMLSLv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLSLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1450,
        GIR_Done,
      // Label 255: @8685
      GIM_Try, /*On fail goto*//*Label 256*/ 8743, // Rule ID 1414 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SSUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1414,
        GIR_Done,
      // Label 256: @8743
      GIM_Try, /*On fail goto*//*Label 257*/ 8801, // Rule ID 1462 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1462,
        GIR_Done,
      // Label 257: @8801
      GIM_Try, /*On fail goto*//*Label 258*/ 8846, // Rule ID 1420 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SSUBWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1420,
        GIR_Done,
      // Label 258: @8846
      GIM_Try, /*On fail goto*//*Label 259*/ 8891, // Rule ID 1468 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1468,
        GIR_Done,
      // Label 259: @8891
      GIM_Try, /*On fail goto*//*Label 260*/ 8910, // Rule ID 1159 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)  =>  (SUBv2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv2i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1159,
        GIR_Done,
      // Label 260: @8910
      GIM_Reject,
    // Label 253: @8911
    GIM_Reject,
    // Label 223: @8912
    GIM_Try, /*On fail goto*//*Label 261*/ 8943, // Rule ID 1155 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (sub:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (SUBv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1155,
      GIR_Done,
    // Label 261: @8943
    GIM_Reject,
    // Label 224: @8944
    GIM_Try, /*On fail goto*//*Label 262*/ 9312,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 263*/ 9022, // Rule ID 1388 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 387:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (SMLSLv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLSLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1388,
        GIR_Done,
      // Label 263: @9022
      GIM_Try, /*On fail goto*//*Label 264*/ 9086, // Rule ID 1448 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 441:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (UMLSLv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLSLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1448,
        GIR_Done,
      // Label 264: @9086
      GIM_Try, /*On fail goto*//*Label 265*/ 9144, // Rule ID 1412 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SSUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1412,
        GIR_Done,
      // Label 265: @9144
      GIM_Try, /*On fail goto*//*Label 266*/ 9202, // Rule ID 1460 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1460,
        GIR_Done,
      // Label 266: @9202
      GIM_Try, /*On fail goto*//*Label 267*/ 9247, // Rule ID 1418 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SSUBWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1418,
        GIR_Done,
      // Label 267: @9247
      GIM_Try, /*On fail goto*//*Label 268*/ 9292, // Rule ID 1466 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1466,
        GIR_Done,
      // Label 268: @9292
      GIM_Try, /*On fail goto*//*Label 269*/ 9311, // Rule ID 1158 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (SUBv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv4i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1158,
        GIR_Done,
      // Label 269: @9311
      GIM_Reject,
    // Label 262: @9312
    GIM_Reject,
    // Label 225: @9313
    GIM_Try, /*On fail goto*//*Label 270*/ 9344, // Rule ID 1153 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (sub:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (SUBv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1153,
      GIR_Done,
    // Label 270: @9344
    GIM_Reject,
    // Label 226: @9345
    GIM_Try, /*On fail goto*//*Label 271*/ 9713,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 272*/ 9423, // Rule ID 1386 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 387:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (SMLSLv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLSLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1386,
        GIR_Done,
      // Label 272: @9423
      GIM_Try, /*On fail goto*//*Label 273*/ 9487, // Rule ID 1446 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 441:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (UMLSLv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLSLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1446,
        GIR_Done,
      // Label 273: @9487
      GIM_Try, /*On fail goto*//*Label 274*/ 9545, // Rule ID 1410 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SSUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1410,
        GIR_Done,
      // Label 274: @9545
      GIM_Try, /*On fail goto*//*Label 275*/ 9603, // Rule ID 1458 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1458,
        GIR_Done,
      // Label 275: @9603
      GIM_Try, /*On fail goto*//*Label 276*/ 9648, // Rule ID 1416 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SSUBWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1416,
        GIR_Done,
      // Label 276: @9648
      GIM_Try, /*On fail goto*//*Label 277*/ 9693, // Rule ID 1464 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1464,
        GIR_Done,
      // Label 277: @9693
      GIM_Try, /*On fail goto*//*Label 278*/ 9712, // Rule ID 1156 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)  =>  (SUBv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv8i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1156,
        GIR_Done,
      // Label 278: @9712
      GIM_Reject,
    // Label 271: @9713
    GIM_Reject,
    // Label 227: @9714
    GIM_Try, /*On fail goto*//*Label 279*/ 9745, // Rule ID 1154 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (sub:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (SUBv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1154,
      GIR_Done,
    // Label 279: @9745
    GIM_Reject,
    // Label 228: @9746
    GIM_Reject,
    // Label 2: @9747
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 15, /*)*//*default:*//*Label 288*/ 10541,
    /*GILLT_s32*//*Label 280*/ 9767,
    /*GILLT_s64*//*Label 281*/ 9927, 0, 0,
    /*GILLT_v2s32*//*Label 282*/ 10349, 0, 0,
    /*GILLT_v4s16*//*Label 283*/ 10381,
    /*GILLT_v4s32*//*Label 284*/ 10413, 0,
    /*GILLT_v8s8*//*Label 285*/ 10445,
    /*GILLT_v8s16*//*Label 286*/ 10477, 0,
    /*GILLT_v16s8*//*Label 287*/ 10509,
    // Label 280: @9767
    GIM_Try, /*On fail goto*//*Label 289*/ 9926,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 290*/ 9836, // Rule ID 2377 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i32] } (sub:{ *:[i32] } 0:{ *:[i32] }, GPR32:{ *:[i32] }:$Rn), GPR32:{ *:[i32] }:$Rm)  =>  (MSUBWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2377,
        GIR_Done,
      // Label 290: @9836
      GIM_Try, /*On fail goto*//*Label 291*/ 9891, // Rule ID 5645 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, (sub:{ *:[i32] } 0:{ *:[i32] }, GPR32:{ *:[i32] }:$Rn))  =>  (MSUBWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5645,
        GIR_Done,
      // Label 291: @9891
      GIM_Try, /*On fail goto*//*Label 292*/ 9925, // Rule ID 2373 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (mul:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (MADDWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MADDWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2373,
        GIR_Done,
      // Label 292: @9925
      GIM_Reject,
    // Label 289: @9926
    GIM_Reject,
    // Label 281: @9927
    GIM_Try, /*On fail goto*//*Label 293*/ 10348,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 294*/ 9996, // Rule ID 2378 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i64] } (sub:{ *:[i64] } 0:{ *:[i64] }, GPR64:{ *:[i64] }:$Rn), GPR64:{ *:[i64] }:$Rm)  =>  (MSUBXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2378,
        GIR_Done,
      // Label 294: @9996
      GIM_Try, /*On fail goto*//*Label 295*/ 10051, // Rule ID 5646 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, (sub:{ *:[i64] } 0:{ *:[i64] }, GPR64:{ *:[i64] }:$Rn))  =>  (MSUBXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5646,
        GIR_Done,
      // Label 295: @10051
      GIM_Try, /*On fail goto*//*Label 296*/ 10122, // Rule ID 2383 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_s64imm_32bit,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/2, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2383,
        GIR_Done,
      // Label 296: @10122
      GIM_Try, /*On fail goto*//*Label 297*/ 10193, // Rule ID 2384 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_i64imm_32bit,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/2, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2384,
        GIR_Done,
      // Label 297: @10193
      GIM_Try, /*On fail goto*//*Label 298*/ 10253, // Rule ID 2379 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2379,
        GIR_Done,
      // Label 298: @10253
      GIM_Try, /*On fail goto*//*Label 299*/ 10313, // Rule ID 2380 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2380,
        GIR_Done,
      // Label 299: @10313
      GIM_Try, /*On fail goto*//*Label 300*/ 10347, // Rule ID 2374 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (mul:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (MADDXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MADDXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2374,
        GIR_Done,
      // Label 300: @10347
      GIM_Reject,
    // Label 293: @10348
    GIM_Reject,
    // Label 282: @10349
    GIM_Try, /*On fail goto*//*Label 301*/ 10380, // Rule ID 1045 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (mul:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (MULv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1045,
      GIR_Done,
    // Label 301: @10380
    GIM_Reject,
    // Label 283: @10381
    GIM_Try, /*On fail goto*//*Label 302*/ 10412, // Rule ID 1043 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (mul:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (MULv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1043,
      GIR_Done,
    // Label 302: @10412
    GIM_Reject,
    // Label 284: @10413
    GIM_Try, /*On fail goto*//*Label 303*/ 10444, // Rule ID 1046 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (mul:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (MULv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1046,
      GIR_Done,
    // Label 303: @10444
    GIM_Reject,
    // Label 285: @10445
    GIM_Try, /*On fail goto*//*Label 304*/ 10476, // Rule ID 1041 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (mul:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (MULv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1041,
      GIR_Done,
    // Label 304: @10476
    GIM_Reject,
    // Label 286: @10477
    GIM_Try, /*On fail goto*//*Label 305*/ 10508, // Rule ID 1044 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (mul:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)  =>  (MULv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1044,
      GIR_Done,
    // Label 305: @10508
    GIM_Reject,
    // Label 287: @10509
    GIM_Try, /*On fail goto*//*Label 306*/ 10540, // Rule ID 1042 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (mul:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (MULv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1042,
      GIR_Done,
    // Label 306: @10540
    GIM_Reject,
    // Label 288: @10541
    GIM_Reject,
    // Label 3: @10542
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 309*/ 10610,
    /*GILLT_s32*//*Label 307*/ 10550,
    /*GILLT_s64*//*Label 308*/ 10580,
    // Label 307: @10550
    GIM_Try, /*On fail goto*//*Label 310*/ 10579, // Rule ID 87 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
      // (sdiv:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (SDIVWr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SDIVWr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 87,
      GIR_Done,
    // Label 310: @10579
    GIM_Reject,
    // Label 308: @10580
    GIM_Try, /*On fail goto*//*Label 311*/ 10609, // Rule ID 88 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
      // (sdiv:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (SDIVXr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SDIVXr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 88,
      GIR_Done,
    // Label 311: @10609
    GIM_Reject,
    // Label 309: @10610
    GIM_Reject,
    // Label 4: @10611
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 314*/ 10679,
    /*GILLT_s32*//*Label 312*/ 10619,
    /*GILLT_s64*//*Label 313*/ 10649,
    // Label 312: @10619
    GIM_Try, /*On fail goto*//*Label 315*/ 10648, // Rule ID 85 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
      // (udiv:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (UDIVWr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::UDIVWr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 85,
      GIR_Done,
    // Label 315: @10648
    GIM_Reject,
    // Label 313: @10649
    GIM_Try, /*On fail goto*//*Label 316*/ 10678, // Rule ID 86 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
      // (udiv:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (UDIVXr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::UDIVXr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 86,
      GIR_Done,
    // Label 316: @10678
    GIM_Reject,
    // Label 314: @10679
    GIM_Reject,
    // Label 5: @10680
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 15, /*)*//*default:*//*Label 326*/ 12313,
    /*GILLT_s32*//*Label 317*/ 10700,
    /*GILLT_s64*//*Label 318*/ 11187, 0, 0,
    /*GILLT_v2s32*//*Label 319*/ 12089,
    /*GILLT_v2s64*//*Label 320*/ 12121, 0,
    /*GILLT_v4s16*//*Label 321*/ 12153,
    /*GILLT_v4s32*//*Label 322*/ 12185, 0,
    /*GILLT_v8s8*//*Label 323*/ 12217,
    /*GILLT_v8s16*//*Label 324*/ 12249, 0,
    /*GILLT_v16s8*//*Label 325*/ 12281,
    // Label 317: @10700
    GIM_Try, /*On fail goto*//*Label 327*/ 11186,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 328*/ 10765, // Rule ID 5408 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (and:{ *:[i32] } (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (BICWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5408,
        GIR_Done,
      // Label 328: @10765
      GIM_Try, /*On fail goto*//*Label 329*/ 10820, // Rule ID 132 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (BICWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 132,
        GIR_Done,
      // Label 329: @10820
      GIM_Try, /*On fail goto*//*Label 330*/ 10882, // Rule ID 3236 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexB,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (vector_extract:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx), 255:{ *:[i32] })  =>  (UMOVvi8:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMOVvi8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3236,
        GIR_Done,
      // Label 330: @10882
      GIM_Try, /*On fail goto*//*Label 331*/ 10944, // Rule ID 3237 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexH,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (vector_extract:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 65535:{ *:[i32] })  =>  (UMOVvi16:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMOVvi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3237,
        GIR_Done,
      // Label 331: @10944
      GIM_Try, /*On fail goto*//*Label 332*/ 10986, // Rule ID 112 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_logical_imm32,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_logical_imm32>><<X:logical_imm32_XFORM>>:$imm)  =>  (ANDWri:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (logical_imm32_XFORM:{ *:[i32] } (imm:{ *:[i32] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm32, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 112,
        GIR_Done,
      // Label 332: @10986
      GIM_Try, /*On fail goto*//*Label 333*/ 11020, // Rule ID 5404 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (and:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm, GPR32:{ *:[i32] }:$Rn)  =>  (ANDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5404,
        GIR_Done,
      // Label 333: @11020
      GIM_Try, /*On fail goto*//*Label 334*/ 11054, // Rule ID 128 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)  =>  (ANDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 128,
        GIR_Done,
      // Label 334: @11054
      GIM_Try, /*On fail goto*//*Label 335*/ 11109, // Rule ID 5406 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (BICWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5406,
        GIR_Done,
      // Label 335: @11109
      GIM_Try, /*On fail goto*//*Label 336*/ 11164, // Rule ID 130 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (BICWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 130,
        GIR_Done,
      // Label 336: @11164
      GIM_Try, /*On fail goto*//*Label 337*/ 11185, // Rule ID 126 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ANDWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 126,
        GIR_Done,
      // Label 337: @11185
      GIM_Reject,
    // Label 327: @11186
    GIM_Reject,
    // Label 318: @11187
    GIM_Try, /*On fail goto*//*Label 338*/ 12088,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 339*/ 11252, // Rule ID 5409 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (and:{ *:[i64] } (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (BICXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5409,
        GIR_Done,
      // Label 339: @11252
      GIM_Try, /*On fail goto*//*Label 340*/ 11307, // Rule ID 133 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm, -1:{ *:[i64] }))  =>  (BICXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 133,
        GIR_Done,
      // Label 340: @11307
      GIM_Try, /*On fail goto*//*Label 341*/ 11393, // Rule ID 4117 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldxr,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_ldxr_1,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 307:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldxr_1>>, 255:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDXRB:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDXRB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
        // GIR_Coverage, 4117,
        GIR_Done,
      // Label 341: @11393
      GIM_Try, /*On fail goto*//*Label 342*/ 11479, // Rule ID 4118 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldxr,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_ldxr_2,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 307:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldxr_2>>, 65535:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDXRH:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDXRH,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
        // GIR_Coverage, 4118,
        GIR_Done,
      // Label 342: @11479
      GIM_Try, /*On fail goto*//*Label 343*/ 11565, // Rule ID 4119 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldxr,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_ldxr_4,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294967295,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 307:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldxr_4>>, 4294967295:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDXRW:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDXRW,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
        // GIR_Coverage, 4119,
        GIR_Done,
      // Label 343: @11565
      GIM_Try, /*On fail goto*//*Label 344*/ 11651, // Rule ID 4124 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldaxr,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_ldaxr_1,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 304:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldaxr_1>>, 255:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDAXRB:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDAXRB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
        // GIR_Coverage, 4124,
        GIR_Done,
      // Label 344: @11651
      GIM_Try, /*On fail goto*//*Label 345*/ 11737, // Rule ID 4125 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldaxr,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_ldaxr_2,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 304:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldaxr_2>>, 65535:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDAXRH:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDAXRH,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
        // GIR_Coverage, 4125,
        GIR_Done,
      // Label 345: @11737
      GIM_Try, /*On fail goto*//*Label 346*/ 11823, // Rule ID 4126 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldaxr,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_ldaxr_4,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294967295,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 304:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldaxr_4>>, 4294967295:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDAXRW:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDAXRW,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
        // GIR_Coverage, 4126,
        GIR_Done,
      // Label 346: @11823
      GIM_Try, /*On fail goto*//*Label 347*/ 11865, // Rule ID 113 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_logical_imm64,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_logical_imm64>><<X:logical_imm64_XFORM>>:$imm)  =>  (ANDXri:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (logical_imm64_XFORM:{ *:[i64] } (imm:{ *:[i64] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm64, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 113,
        GIR_Done,
      // Label 347: @11865
      GIM_Try, /*On fail goto*//*Label 348*/ 11899, // Rule ID 5405 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (and:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm, GPR64:{ *:[i64] }:$Rn)  =>  (ANDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5405,
        GIR_Done,
      // Label 348: @11899
      GIM_Try, /*On fail goto*//*Label 349*/ 11933, // Rule ID 129 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)  =>  (ANDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 129,
        GIR_Done,
      // Label 349: @11933
      GIM_Try, /*On fail goto*//*Label 350*/ 11988, // Rule ID 5407 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (BICXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5407,
        GIR_Done,
      // Label 350: @11988
      GIM_Try, /*On fail goto*//*Label 351*/ 12043, // Rule ID 131 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }))  =>  (BICXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 131,
        GIR_Done,
      // Label 351: @12043
      GIM_Try, /*On fail goto*//*Label 352*/ 12064, // Rule ID 127 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ANDXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 127,
        GIR_Done,
      // Label 352: @12064
      GIM_Try, /*On fail goto*//*Label 353*/ 12087, // Rule ID 1863 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)  =>  (ANDv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1863,
        GIR_Done,
      // Label 353: @12087
      GIM_Reject,
    // Label 338: @12088
    GIM_Reject,
    // Label 319: @12089
    GIM_Try, /*On fail goto*//*Label 354*/ 12120, // Rule ID 1862 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)  =>  (ANDv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1862,
      GIR_Done,
    // Label 354: @12120
    GIM_Reject,
    // Label 320: @12121
    GIM_Try, /*On fail goto*//*Label 355*/ 12152, // Rule ID 1866 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)  =>  (ANDv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1866,
      GIR_Done,
    // Label 355: @12152
    GIM_Reject,
    // Label 321: @12153
    GIM_Try, /*On fail goto*//*Label 356*/ 12184, // Rule ID 1861 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)  =>  (ANDv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1861,
      GIR_Done,
    // Label 356: @12184
    GIM_Reject,
    // Label 322: @12185
    GIM_Try, /*On fail goto*//*Label 357*/ 12216, // Rule ID 1865 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)  =>  (ANDv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1865,
      GIR_Done,
    // Label 357: @12216
    GIM_Reject,
    // Label 323: @12217
    GIM_Try, /*On fail goto*//*Label 358*/ 12248, // Rule ID 1264 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (ANDv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1264,
      GIR_Done,
    // Label 358: @12248
    GIM_Reject,
    // Label 324: @12249
    GIM_Try, /*On fail goto*//*Label 359*/ 12280, // Rule ID 1864 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)  =>  (ANDv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1864,
      GIR_Done,
    // Label 359: @12280
    GIM_Reject,
    // Label 325: @12281
    GIM_Try, /*On fail goto*//*Label 360*/ 12312, // Rule ID 1265 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (ANDv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1265,
      GIR_Done,
    // Label 360: @12312
    GIM_Reject,
    // Label 326: @12313
    GIM_Reject,
    // Label 6: @12314
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 15, /*)*//*default:*//*Label 370*/ 13307,
    /*GILLT_s32*//*Label 361*/ 12334,
    /*GILLT_s64*//*Label 362*/ 12697, 0, 0,
    /*GILLT_v2s32*//*Label 363*/ 13083,
    /*GILLT_v2s64*//*Label 364*/ 13115, 0,
    /*GILLT_v4s16*//*Label 365*/ 13147,
    /*GILLT_v4s32*//*Label 366*/ 13179, 0,
    /*GILLT_v8s8*//*Label 367*/ 13211,
    /*GILLT_v8s16*//*Label 368*/ 13243, 0,
    /*GILLT_v16s8*//*Label 369*/ 13275,
    // Label 361: @12334
    GIM_Try, /*On fail goto*//*Label 371*/ 12696,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 372*/ 12399, // Rule ID 5428 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (or:{ *:[i32] } (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (ORNWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5428,
        GIR_Done,
      // Label 372: @12399
      GIM_Try, /*On fail goto*//*Label 373*/ 12454, // Rule ID 144 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (ORNWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 144,
        GIR_Done,
      // Label 373: @12454
      GIM_Try, /*On fail goto*//*Label 374*/ 12496, // Rule ID 116 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_logical_imm32,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_logical_imm32>><<X:logical_imm32_XFORM>>:$imm)  =>  (ORRWri:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (logical_imm32_XFORM:{ *:[i32] } (imm:{ *:[i32] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm32, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 116,
        GIR_Done,
      // Label 374: @12496
      GIM_Try, /*On fail goto*//*Label 375*/ 12530, // Rule ID 5430 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (or:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm, GPR32:{ *:[i32] }:$Rn)  =>  (ORRWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5430,
        GIR_Done,
      // Label 375: @12530
      GIM_Try, /*On fail goto*//*Label 376*/ 12564, // Rule ID 148 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)  =>  (ORRWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 148,
        GIR_Done,
      // Label 376: @12564
      GIM_Try, /*On fail goto*//*Label 377*/ 12619, // Rule ID 5426 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (ORNWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5426,
        GIR_Done,
      // Label 377: @12619
      GIM_Try, /*On fail goto*//*Label 378*/ 12674, // Rule ID 142 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (ORNWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 142,
        GIR_Done,
      // Label 378: @12674
      GIM_Try, /*On fail goto*//*Label 379*/ 12695, // Rule ID 146 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ORRWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 146,
        GIR_Done,
      // Label 379: @12695
      GIM_Reject,
    // Label 371: @12696
    GIM_Reject,
    // Label 362: @12697
    GIM_Try, /*On fail goto*//*Label 380*/ 13082,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 381*/ 12762, // Rule ID 5429 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (or:{ *:[i64] } (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (ORNXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5429,
        GIR_Done,
      // Label 381: @12762
      GIM_Try, /*On fail goto*//*Label 382*/ 12817, // Rule ID 145 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm, -1:{ *:[i64] }))  =>  (ORNXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 145,
        GIR_Done,
      // Label 382: @12817
      GIM_Try, /*On fail goto*//*Label 383*/ 12859, // Rule ID 117 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_logical_imm64,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_logical_imm64>><<X:logical_imm64_XFORM>>:$imm)  =>  (ORRXri:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (logical_imm64_XFORM:{ *:[i64] } (imm:{ *:[i64] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm64, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 117,
        GIR_Done,
      // Label 383: @12859
      GIM_Try, /*On fail goto*//*Label 384*/ 12893, // Rule ID 5431 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (or:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm, GPR64:{ *:[i64] }:$Rn)  =>  (ORRXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5431,
        GIR_Done,
      // Label 384: @12893
      GIM_Try, /*On fail goto*//*Label 385*/ 12927, // Rule ID 149 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)  =>  (ORRXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 149,
        GIR_Done,
      // Label 385: @12927
      GIM_Try, /*On fail goto*//*Label 386*/ 12982, // Rule ID 5427 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (ORNXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5427,
        GIR_Done,
      // Label 386: @12982
      GIM_Try, /*On fail goto*//*Label 387*/ 13037, // Rule ID 143 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }))  =>  (ORNXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 143,
        GIR_Done,
      // Label 387: @13037
      GIM_Try, /*On fail goto*//*Label 388*/ 13058, // Rule ID 147 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ORRXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 147,
        GIR_Done,
      // Label 388: @13058
      GIM_Try, /*On fail goto*//*Label 389*/ 13081, // Rule ID 2954 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (or:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)  =>  (ORRv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2954,
        GIR_Done,
      // Label 389: @13081
      GIM_Reject,
    // Label 380: @13082
    GIM_Reject,
    // Label 363: @13083
    GIM_Try, /*On fail goto*//*Label 390*/ 13114, // Rule ID 2953 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (or:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)  =>  (ORRv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2953,
      GIR_Done,
    // Label 390: @13114
    GIM_Reject,
    // Label 364: @13115
    GIM_Try, /*On fail goto*//*Label 391*/ 13146, // Rule ID 2957 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (or:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)  =>  (ORRv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2957,
      GIR_Done,
    // Label 391: @13146
    GIM_Reject,
    // Label 365: @13147
    GIM_Try, /*On fail goto*//*Label 392*/ 13178, // Rule ID 2952 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (or:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)  =>  (ORRv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2952,
      GIR_Done,
    // Label 392: @13178
    GIM_Reject,
    // Label 366: @13179
    GIM_Try, /*On fail goto*//*Label 393*/ 13210, // Rule ID 2956 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (or:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)  =>  (ORRv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2956,
      GIR_Done,
    // Label 393: @13210
    GIM_Reject,
    // Label 367: @13211
    GIM_Try, /*On fail goto*//*Label 394*/ 13242, // Rule ID 1276 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (or:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (ORRv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1276,
      GIR_Done,
    // Label 394: @13242
    GIM_Reject,
    // Label 368: @13243
    GIM_Try, /*On fail goto*//*Label 395*/ 13274, // Rule ID 2955 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (or:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)  =>  (ORRv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2955,
      GIR_Done,
    // Label 395: @13274
    GIM_Reject,
    // Label 369: @13275
    GIM_Try, /*On fail goto*//*Label 396*/ 13306, // Rule ID 1277 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (or:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (ORRv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1277,
      GIR_Done,
    // Label 396: @13306
    GIM_Reject,
    // Label 370: @13307
    GIM_Reject,
    // Label 7: @13308
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 15, /*)*//*default:*//*Label 406*/ 14919,
    /*GILLT_s32*//*Label 397*/ 13328,
    /*GILLT_s64*//*Label 398*/ 14000, 0, 0,
    /*GILLT_v2s32*//*Label 399*/ 14695,
    /*GILLT_v2s64*//*Label 400*/ 14727, 0,
    /*GILLT_v4s16*//*Label 401*/ 14759,
    /*GILLT_v4s32*//*Label 402*/ 14791, 0,
    /*GILLT_v8s8*//*Label 403*/ 14823,
    /*GILLT_v8s16*//*Label 404*/ 14855, 0,
    /*GILLT_v16s8*//*Label 405*/ 14887,
    // Label 397: @13328
    GIM_Try, /*On fail goto*//*Label 407*/ 13999,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 408*/ 13393, // Rule ID 5417 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, -1:{ *:[i32] }))  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5417,
        GIR_Done,
      // Label 408: @13393
      GIM_Try, /*On fail goto*//*Label 409*/ 13448, // Rule ID 5416 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5416,
        GIR_Done,
      // Label 409: @13448
      GIM_Try, /*On fail goto*//*Label 410*/ 13503, // Rule ID 5414 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm, GPR32:{ *:[i32] }:$Rn), -1:{ *:[i32] })  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5414,
        GIR_Done,
      // Label 410: @13503
      GIM_Try, /*On fail goto*//*Label 411*/ 13558, // Rule ID 136 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm), -1:{ *:[i32] })  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 136,
        GIR_Done,
      // Label 411: @13558
      GIM_Try, /*On fail goto*//*Label 412*/ 13613, // Rule ID 5415 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, -1:{ *:[i32] }), logical_shifted_reg32:{ *:[i32] }:$Rm)  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5415,
        GIR_Done,
      // Label 412: @13613
      GIM_Try, /*On fail goto*//*Label 413*/ 13668, // Rule ID 5418 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5418,
        GIR_Done,
      // Label 413: @13668
      GIM_Try, /*On fail goto*//*Label 414*/ 13710, // Rule ID 114 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_logical_imm32,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_logical_imm32>><<X:logical_imm32_XFORM>>:$imm)  =>  (EORWri:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (logical_imm32_XFORM:{ *:[i32] } (imm:{ *:[i32] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm32, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 114,
        GIR_Done,
      // Label 414: @13710
      GIM_Try, /*On fail goto*//*Label 415*/ 13744, // Rule ID 5424 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm, GPR32:{ *:[i32] }:$Rn)  =>  (EORWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5424,
        GIR_Done,
      // Label 415: @13744
      GIM_Try, /*On fail goto*//*Label 416*/ 13778, // Rule ID 140 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)  =>  (EORWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 140,
        GIR_Done,
      // Label 416: @13778
      GIM_Try, /*On fail goto*//*Label 417*/ 13833, // Rule ID 5410 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rm)  =>  (EONWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5410,
        GIR_Done,
      // Label 417: @13833
      GIM_Try, /*On fail goto*//*Label 418*/ 13888, // Rule ID 134 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm), -1:{ *:[i32] })  =>  (EONWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 134,
        GIR_Done,
      // Label 418: @13888
      GIM_Try, /*On fail goto*//*Label 419*/ 13943, // Rule ID 5411 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, -1:{ *:[i32] }))  =>  (EONWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5411,
        GIR_Done,
      // Label 419: @13943
      GIM_Try, /*On fail goto*//*Label 420*/ 13977, // Rule ID 2404 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Wm, -1:{ *:[i32] })  =>  (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Wm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Wm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2404,
        GIR_Done,
      // Label 420: @13977
      GIM_Try, /*On fail goto*//*Label 421*/ 13998, // Rule ID 138 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (EORWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 138,
        GIR_Done,
      // Label 421: @13998
      GIM_Reject,
    // Label 407: @13999
    GIM_Reject,
    // Label 398: @14000
    GIM_Try, /*On fail goto*//*Label 422*/ 14694,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 423*/ 14065, // Rule ID 5422 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, -1:{ *:[i64] }))  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5422,
        GIR_Done,
      // Label 423: @14065
      GIM_Try, /*On fail goto*//*Label 424*/ 14120, // Rule ID 5421 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5421,
        GIR_Done,
      // Label 424: @14120
      GIM_Try, /*On fail goto*//*Label 425*/ 14175, // Rule ID 5419 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm, GPR64:{ *:[i64] }:$Rn), -1:{ *:[i64] })  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5419,
        GIR_Done,
      // Label 425: @14175
      GIM_Try, /*On fail goto*//*Label 426*/ 14230, // Rule ID 137 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm), -1:{ *:[i64] })  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 137,
        GIR_Done,
      // Label 426: @14230
      GIM_Try, /*On fail goto*//*Label 427*/ 14285, // Rule ID 5420 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, -1:{ *:[i64] }), logical_shifted_reg64:{ *:[i64] }:$Rm)  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5420,
        GIR_Done,
      // Label 427: @14285
      GIM_Try, /*On fail goto*//*Label 428*/ 14340, // Rule ID 5423 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm, -1:{ *:[i64] }))  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5423,
        GIR_Done,
      // Label 428: @14340
      GIM_Try, /*On fail goto*//*Label 429*/ 14382, // Rule ID 115 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_logical_imm64,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_logical_imm64>><<X:logical_imm64_XFORM>>:$imm)  =>  (EORXri:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (logical_imm64_XFORM:{ *:[i64] } (imm:{ *:[i64] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm64, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 115,
        GIR_Done,
      // Label 429: @14382
      GIM_Try, /*On fail goto*//*Label 430*/ 14416, // Rule ID 5425 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm, GPR64:{ *:[i64] }:$Rn)  =>  (EORXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5425,
        GIR_Done,
      // Label 430: @14416
      GIM_Try, /*On fail goto*//*Label 431*/ 14450, // Rule ID 141 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)  =>  (EORXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 141,
        GIR_Done,
      // Label 431: @14450
      GIM_Try, /*On fail goto*//*Label 432*/ 14505, // Rule ID 5412 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rm)  =>  (EONXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5412,
        GIR_Done,
      // Label 432: @14505
      GIM_Try, /*On fail goto*//*Label 433*/ 14560, // Rule ID 135 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm), -1:{ *:[i64] })  =>  (EONXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 135,
        GIR_Done,
      // Label 433: @14560
      GIM_Try, /*On fail goto*//*Label 434*/ 14615, // Rule ID 5413 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, -1:{ *:[i64] }))  =>  (EONXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5413,
        GIR_Done,
      // Label 434: @14615
      GIM_Try, /*On fail goto*//*Label 435*/ 14649, // Rule ID 2405 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Xm, -1:{ *:[i64] })  =>  (ORNXrr:{ *:[i64] } XZR:{ *:[i64] }, GPR64:{ *:[i64] }:$Xm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Xm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2405,
        GIR_Done,
      // Label 435: @14649
      GIM_Try, /*On fail goto*//*Label 436*/ 14670, // Rule ID 139 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (EORXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 139,
        GIR_Done,
      // Label 436: @14670
      GIM_Try, /*On fail goto*//*Label 437*/ 14693, // Rule ID 2942 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)  =>  (EORv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2942,
        GIR_Done,
      // Label 437: @14693
      GIM_Reject,
    // Label 422: @14694
    GIM_Reject,
    // Label 399: @14695
    GIM_Try, /*On fail goto*//*Label 438*/ 14726, // Rule ID 2941 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)  =>  (EORv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2941,
      GIR_Done,
    // Label 438: @14726
    GIM_Reject,
    // Label 400: @14727
    GIM_Try, /*On fail goto*//*Label 439*/ 14758, // Rule ID 2945 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)  =>  (EORv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2945,
      GIR_Done,
    // Label 439: @14758
    GIM_Reject,
    // Label 401: @14759
    GIM_Try, /*On fail goto*//*Label 440*/ 14790, // Rule ID 2940 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)  =>  (EORv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2940,
      GIR_Done,
    // Label 440: @14790
    GIM_Reject,
    // Label 402: @14791
    GIM_Try, /*On fail goto*//*Label 441*/ 14822, // Rule ID 2944 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)  =>  (EORv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2944,
      GIR_Done,
    // Label 441: @14822
    GIM_Reject,
    // Label 403: @14823
    GIM_Try, /*On fail goto*//*Label 442*/ 14854, // Rule ID 1272 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (EORv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1272,
      GIR_Done,
    // Label 442: @14854
    GIM_Reject,
    // Label 404: @14855
    GIM_Try, /*On fail goto*//*Label 443*/ 14886, // Rule ID 2943 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)  =>  (EORv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2943,
      GIR_Done,
    // Label 443: @14886
    GIM_Reject,
    // Label 405: @14887
    GIM_Try, /*On fail goto*//*Label 444*/ 14918, // Rule ID 1273 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (EORv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1273,
      GIR_Done,
    // Label 444: @14918
    GIM_Reject,
    // Label 406: @14919
    GIM_Reject,
    // Label 8: @14920
    GIM_Try, /*On fail goto*//*Label 445*/ 21186,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/6, 15, /*)*//*default:*//*Label 450*/ 21185,
      /*GILLT_v2s64*//*Label 446*/ 14940, 0, 0,
      /*GILLT_v4s32*//*Label 447*/ 15316, 0, 0,
      /*GILLT_v8s16*//*Label 448*/ 17438, 0,
      /*GILLT_v16s8*//*Label 449*/ 19418,
      // Label 446: @14940
      GIM_Try, /*On fail goto*//*Label 451*/ 15315,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_Try, /*On fail goto*//*Label 452*/ 15014, // Rule ID 3286 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v2i64] } V64:{ *:[v1i64] }:$Rn, (undef:{ *:[v1i64] }))  =>  (INSERT_SUBREG:{ *:[v2i64] } (IMPLICIT_DEF:{ *:[v2i64] }), V64:{ *:[v1i64] }:$Rn, dsub:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
          GIR_AddImm, /*InsnID*/0, /*Imm*/2,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC FPR64*/16,
          // GIR_Coverage, 3286,
          GIR_Done,
        // Label 452: @15014
        GIM_Try, /*On fail goto*//*Label 453*/ 15070, // Rule ID 3287 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v2f64] } V64:{ *:[v1f64] }:$Rn, (undef:{ *:[v1f64] }))  =>  (INSERT_SUBREG:{ *:[v2f64] } (IMPLICIT_DEF:{ *:[v2f64] }), V64:{ *:[v1f64] }:$Rn, dsub:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
          GIR_AddImm, /*InsnID*/0, /*Imm*/2,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC FPR64*/16,
          // GIR_Coverage, 3287,
          GIR_Done,
        // Label 453: @15070
        GIM_Try, /*On fail goto*//*Label 454*/ 15192, // Rule ID 3279 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
          // (concat_vectors:{ *:[v2i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v1i64] }:$Rn)  =>  (INSvi64lane:{ *:[v2i64] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v1i64] }:$Rd, dsub:{ *:[i32] }), 1:{ *:[i64] }, (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v1i64] }:$Rn, dsub:{ *:[i32] }), 0:{ *:[i64] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
          GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // Rn
          GIR_AddImm, /*InsnID*/3, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INSvi64lane,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3279,
          GIR_Done,
        // Label 454: @15192
        GIM_Try, /*On fail goto*//*Label 455*/ 15314, // Rule ID 3280 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
          // (concat_vectors:{ *:[v2f64] } V64:{ *:[v1f64] }:$Rd, V64:{ *:[v1f64] }:$Rn)  =>  (INSvi64lane:{ *:[v2f64] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v1f64] }:$Rd, dsub:{ *:[i32] }), 1:{ *:[i64] }, (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v1f64] }:$Rn, dsub:{ *:[i32] }), 0:{ *:[i64] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
          GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // Rn
          GIR_AddImm, /*InsnID*/3, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INSvi64lane,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3280,
          GIR_Done,
        // Label 455: @15314
        GIM_Reject,
      // Label 451: @15315
      GIM_Reject,
      // Label 447: @15316
      GIM_Try, /*On fail goto*//*Label 456*/ 17437,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_Try, /*On fail goto*//*Label 457*/ 15446, // Rule ID 1910 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_rshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 368:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm))  =>  (RSHRNv4i32_shift:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::RSHRNv4i32_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1910,
          GIR_Done,
        // Label 457: @15446
        GIM_Try, /*On fail goto*//*Label 458*/ 15558, // Rule ID 3532 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqrshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 396:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm))  =>  (SQRSHRNv4i32_shift:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQRSHRNv4i32_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3532,
          GIR_Done,
        // Label 458: @15558
        GIM_Try, /*On fail goto*//*Label 459*/ 15670, // Rule ID 3535 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqrshrun,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 397:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm))  =>  (SQRSHRUNv4i32_shift:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQRSHRUNv4i32_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3535,
          GIR_Done,
        // Label 459: @15670
        GIM_Try, /*On fail goto*//*Label 460*/ 15782, // Rule ID 3538 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 400:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm))  =>  (SQSHRNv4i32_shift:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQSHRNv4i32_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3538,
          GIR_Done,
        // Label 460: @15782
        GIM_Try, /*On fail goto*//*Label 461*/ 15894, // Rule ID 3541 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqshrun,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 401:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm))  =>  (SQSHRUNv4i32_shift:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQSHRUNv4i32_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3541,
          GIR_Done,
        // Label 461: @15894
        GIM_Try, /*On fail goto*//*Label 462*/ 16006, // Rule ID 3545 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uqrshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 444:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm))  =>  (UQRSHRNv4i32_shift:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UQRSHRNv4i32_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3545,
          GIR_Done,
        // Label 462: @16006
        GIM_Try, /*On fail goto*//*Label 463*/ 16118, // Rule ID 3548 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uqshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 446:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm))  =>  (UQSHRNv4i32_shift:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UQSHRNv4i32_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3548,
          GIR_Done,
        // Label 463: @16118
        GIM_Try, /*On fail goto*//*Label 464*/ 16223, // Rule ID 1879 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_addhn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 309:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm))  =>  (ADDHNv2i64_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDHNv2i64_v4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1879,
          GIR_Done,
        // Label 464: @16223
        GIM_Try, /*On fail goto*//*Label 465*/ 16328, // Rule ID 3070 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_subhn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 418:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm))  =>  (SUBHNv2i64_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBHNv2i64_v4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3070,
          GIR_Done,
        // Label 465: @16328
        GIM_Try, /*On fail goto*//*Label 466*/ 16433, // Rule ID 3073 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_raddhn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 366:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm))  =>  (RADDHNv2i64_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::RADDHNv2i64_v4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3073,
          GIR_Done,
        // Label 466: @16433
        GIM_Try, /*On fail goto*//*Label 467*/ 16538, // Rule ID 3076 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_rsubhn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 369:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm))  =>  (RSUBHNv2i64_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::RSUBHNv2i64_v4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3076,
          GIR_Done,
        // Label 467: @16538
        GIM_Try, /*On fail goto*//*Label 468*/ 16631, // Rule ID 1875 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqxtn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 403:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn))  =>  (SQXTNv4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQXTNv4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1875,
          GIR_Done,
        // Label 468: @16631
        GIM_Try, /*On fail goto*//*Label 469*/ 16724, // Rule ID 1876 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_fcvtxn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v4f32] } V64:{ *:[v2f32] }:$Rd, (intrinsic_wo_chain:{ *:[v2f32] } 325:{ *:[iPTR] }, V128:{ *:[v2f64] }:$Rn))  =>  (FCVTXNv4f32:{ *:[v4f32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2f32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2f64] }:$Rn)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::FCVTXNv4f32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1876,
          GIR_Done,
        // Label 469: @16724
        GIM_Try, /*On fail goto*//*Label 470*/ 16817, // Rule ID 2868 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqxtun,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 404:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn))  =>  (SQXTUNv4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQXTUNv4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2868,
          GIR_Done,
        // Label 470: @16817
        GIM_Try, /*On fail goto*//*Label 471*/ 16910, // Rule ID 2871 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uqxtn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 448:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn))  =>  (UQXTNv4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UQXTNv4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2871,
          GIR_Done,
        // Label 471: @16910
        GIM_Try, /*On fail goto*//*Label 472*/ 16994, // Rule ID 2835 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FPTRUNC,
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v4f32] } V64:{ *:[v2f32] }:$Rd, (fpround:{ *:[v2f32] } V128:{ *:[v2f64] }:$Rn))  =>  (FCVTNv4i32:{ *:[v4f32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2f32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2f64] }:$Rn)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::FCVTNv4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2835,
          GIR_Done,
        // Label 472: @16994
        GIM_Try, /*On fail goto*//*Label 473*/ 17080, // Rule ID 2874 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (trunc:{ *:[v2i32] } V128:{ *:[v2i64] }:$Rn))  =>  (XTNv4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::XTNv4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2874,
          GIR_Done,
        // Label 473: @17080
        GIM_Try, /*On fail goto*//*Label 474*/ 17136, // Rule ID 3288 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rn, (undef:{ *:[v2i32] }))  =>  (INSERT_SUBREG:{ *:[v4i32] } (IMPLICIT_DEF:{ *:[v4i32] }), V64:{ *:[v2i32] }:$Rn, dsub:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
          GIR_AddImm, /*InsnID*/0, /*Imm*/2,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC FPR64*/16,
          // GIR_Coverage, 3288,
          GIR_Done,
        // Label 474: @17136
        GIM_Try, /*On fail goto*//*Label 475*/ 17192, // Rule ID 3289 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v4f32] } V64:{ *:[v2f32] }:$Rn, (undef:{ *:[v2f32] }))  =>  (INSERT_SUBREG:{ *:[v4f32] } (IMPLICIT_DEF:{ *:[v4f32] }), V64:{ *:[v2f32] }:$Rn, dsub:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
          GIR_AddImm, /*InsnID*/0, /*Imm*/2,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC FPR64*/16,
          // GIR_Coverage, 3289,
          GIR_Done,
        // Label 475: @17192
        GIM_Try, /*On fail goto*//*Label 476*/ 17314, // Rule ID 3281 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn)  =>  (INSvi64lane:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), 1:{ *:[i64] }, (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rn, dsub:{ *:[i32] }), 0:{ *:[i64] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
          GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // Rn
          GIR_AddImm, /*InsnID*/3, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INSvi64lane,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3281,
          GIR_Done,
        // Label 476: @17314
        GIM_Try, /*On fail goto*//*Label 477*/ 17436, // Rule ID 3282 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
          // (concat_vectors:{ *:[v4f32] } V64:{ *:[v2f32] }:$Rd, V64:{ *:[v2f32] }:$Rn)  =>  (INSvi64lane:{ *:[v4f32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2f32] }:$Rd, dsub:{ *:[i32] }), 1:{ *:[i64] }, (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2f32] }:$Rn, dsub:{ *:[i32] }), 0:{ *:[i64] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
          GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // Rn
          GIR_AddImm, /*InsnID*/3, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INSvi64lane,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3282,
          GIR_Done,
        // Label 477: @17436
        GIM_Reject,
      // Label 456: @17437
      GIM_Reject,
      // Label 448: @17438
      GIM_Try, /*On fail goto*//*Label 478*/ 19417,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_Try, /*On fail goto*//*Label 479*/ 17568, // Rule ID 1909 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_rshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 368:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32Narrow>>:$imm))  =>  (RSHRNv8i16_shift:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::RSHRNv8i16_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1909,
          GIR_Done,
        // Label 479: @17568
        GIM_Try, /*On fail goto*//*Label 480*/ 17680, // Rule ID 3531 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqrshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 396:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32Narrow>>:$imm))  =>  (SQRSHRNv8i16_shift:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQRSHRNv8i16_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3531,
          GIR_Done,
        // Label 480: @17680
        GIM_Try, /*On fail goto*//*Label 481*/ 17792, // Rule ID 3534 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqrshrun,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 397:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32Narrow>>:$imm))  =>  (SQRSHRUNv8i16_shift:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQRSHRUNv8i16_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3534,
          GIR_Done,
        // Label 481: @17792
        GIM_Try, /*On fail goto*//*Label 482*/ 17904, // Rule ID 3537 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 400:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32Narrow>>:$imm))  =>  (SQSHRNv8i16_shift:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQSHRNv8i16_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3537,
          GIR_Done,
        // Label 482: @17904
        GIM_Try, /*On fail goto*//*Label 483*/ 18016, // Rule ID 3540 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqshrun,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 401:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32Narrow>>:$imm))  =>  (SQSHRUNv8i16_shift:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQSHRUNv8i16_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3540,
          GIR_Done,
        // Label 483: @18016
        GIM_Try, /*On fail goto*//*Label 484*/ 18128, // Rule ID 3544 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uqrshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 444:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32Narrow>>:$imm))  =>  (UQRSHRNv8i16_shift:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UQRSHRNv8i16_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3544,
          GIR_Done,
        // Label 484: @18128
        GIM_Try, /*On fail goto*//*Label 485*/ 18240, // Rule ID 3547 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uqshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 446:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32Narrow>>:$imm))  =>  (UQSHRNv8i16_shift:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UQSHRNv8i16_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3547,
          GIR_Done,
        // Label 485: @18240
        GIM_Try, /*On fail goto*//*Label 486*/ 18345, // Rule ID 1878 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_addhn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 309:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (ADDHNv4i32_v8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDHNv4i32_v8i16,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1878,
          GIR_Done,
        // Label 486: @18345
        GIM_Try, /*On fail goto*//*Label 487*/ 18450, // Rule ID 3069 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_subhn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 418:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (SUBHNv4i32_v8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBHNv4i32_v8i16,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3069,
          GIR_Done,
        // Label 487: @18450
        GIM_Try, /*On fail goto*//*Label 488*/ 18555, // Rule ID 3072 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_raddhn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 366:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (RADDHNv4i32_v8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::RADDHNv4i32_v8i16,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3072,
          GIR_Done,
        // Label 488: @18555
        GIM_Try, /*On fail goto*//*Label 489*/ 18660, // Rule ID 3075 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_rsubhn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 369:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (RSUBHNv4i32_v8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::RSUBHNv4i32_v8i16,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3075,
          GIR_Done,
        // Label 489: @18660
        GIM_Try, /*On fail goto*//*Label 490*/ 18753, // Rule ID 1874 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqxtn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 403:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn))  =>  (SQXTNv8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4i32] }:$Rn)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQXTNv8i16,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1874,
          GIR_Done,
        // Label 490: @18753
        GIM_Try, /*On fail goto*//*Label 491*/ 18844, // Rule ID 2832 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_vcvtfp2hf,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 461:{ *:[iPTR] }, V128:{ *:[v4f32] }:$Rn))  =>  (FCVTNv8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4f32] }:$Rn)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::FCVTNv8i16,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2832,
          GIR_Done,
        // Label 491: @18844
        GIM_Try, /*On fail goto*//*Label 492*/ 18937, // Rule ID 2867 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqxtun,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 404:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn))  =>  (SQXTUNv8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4i32] }:$Rn)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQXTUNv8i16,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2867,
          GIR_Done,
        // Label 492: @18937
        GIM_Try, /*On fail goto*//*Label 493*/ 19030, // Rule ID 2870 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uqxtn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 448:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn))  =>  (UQXTNv8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4i32] }:$Rn)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UQXTNv8i16,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2870,
          GIR_Done,
        // Label 493: @19030
        GIM_Try, /*On fail goto*//*Label 494*/ 19116, // Rule ID 2873 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, (trunc:{ *:[v4i16] } V128:{ *:[v4i32] }:$Rn))  =>  (XTNv8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v4i32] }:$Rn)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::XTNv8i16,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2873,
          GIR_Done,
        // Label 494: @19116
        GIM_Try, /*On fail goto*//*Label 495*/ 19172, // Rule ID 3290 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rn, (undef:{ *:[v4i16] }))  =>  (INSERT_SUBREG:{ *:[v8i16] } (IMPLICIT_DEF:{ *:[v8i16] }), V64:{ *:[v4i16] }:$Rn, dsub:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
          GIR_AddImm, /*InsnID*/0, /*Imm*/2,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC FPR64*/16,
          // GIR_Coverage, 3290,
          GIR_Done,
        // Label 495: @19172
        GIM_Try, /*On fail goto*//*Label 496*/ 19294, // Rule ID 3283 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
          // (concat_vectors:{ *:[v8i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn)  =>  (INSvi64lane:{ *:[v8i16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rd, dsub:{ *:[i32] }), 1:{ *:[i64] }, (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4i16] }:$Rn, dsub:{ *:[i32] }), 0:{ *:[i64] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
          GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // Rn
          GIR_AddImm, /*InsnID*/3, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INSvi64lane,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3283,
          GIR_Done,
        // Label 496: @19294
        GIM_Try, /*On fail goto*//*Label 497*/ 19416, // Rule ID 3284 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
          // (concat_vectors:{ *:[v8f16] } V64:{ *:[v4f16] }:$Rd, V64:{ *:[v4f16] }:$Rn)  =>  (INSvi64lane:{ *:[v8f16] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4f16] }:$Rd, dsub:{ *:[i32] }), 1:{ *:[i64] }, (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v4f16] }:$Rn, dsub:{ *:[i32] }), 0:{ *:[i64] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
          GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // Rn
          GIR_AddImm, /*InsnID*/3, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INSvi64lane,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3284,
          GIR_Done,
        // Label 497: @19416
        GIM_Reject,
      // Label 478: @19417
      GIM_Reject,
      // Label 449: @19418
      GIM_Try, /*On fail goto*//*Label 498*/ 21184,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_Try, /*On fail goto*//*Label 499*/ 19548, // Rule ID 1908 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_rshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 368:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16Narrow>>:$imm))  =>  (RSHRNv16i8_shift:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::RSHRNv16i8_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1908,
          GIR_Done,
        // Label 499: @19548
        GIM_Try, /*On fail goto*//*Label 500*/ 19660, // Rule ID 3530 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqrshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 396:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16Narrow>>:$imm))  =>  (SQRSHRNv16i8_shift:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQRSHRNv16i8_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3530,
          GIR_Done,
        // Label 500: @19660
        GIM_Try, /*On fail goto*//*Label 501*/ 19772, // Rule ID 3533 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqrshrun,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 397:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16Narrow>>:$imm))  =>  (SQRSHRUNv16i8_shift:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQRSHRUNv16i8_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3533,
          GIR_Done,
        // Label 501: @19772
        GIM_Try, /*On fail goto*//*Label 502*/ 19884, // Rule ID 3536 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 400:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16Narrow>>:$imm))  =>  (SQSHRNv16i8_shift:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQSHRNv16i8_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3536,
          GIR_Done,
        // Label 502: @19884
        GIM_Try, /*On fail goto*//*Label 503*/ 19996, // Rule ID 3539 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqshrun,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 401:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16Narrow>>:$imm))  =>  (SQSHRUNv16i8_shift:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQSHRUNv16i8_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3539,
          GIR_Done,
        // Label 503: @19996
        GIM_Try, /*On fail goto*//*Label 504*/ 20108, // Rule ID 3543 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uqrshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 444:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16Narrow>>:$imm))  =>  (UQRSHRNv16i8_shift:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UQRSHRNv16i8_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3543,
          GIR_Done,
        // Label 504: @20108
        GIM_Try, /*On fail goto*//*Label 505*/ 20220, // Rule ID 3546 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uqshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 446:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16Narrow>>:$imm))  =>  (UQSHRNv16i8_shift:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UQSHRNv16i8_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3546,
          GIR_Done,
        // Label 505: @20220
        GIM_Try, /*On fail goto*//*Label 506*/ 20325, // Rule ID 1877 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_addhn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 309:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (ADDHNv8i16_v16i8:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDHNv8i16_v16i8,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1877,
          GIR_Done,
        // Label 506: @20325
        GIM_Try, /*On fail goto*//*Label 507*/ 20430, // Rule ID 3068 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_subhn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 418:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (SUBHNv8i16_v16i8:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBHNv8i16_v16i8,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3068,
          GIR_Done,
        // Label 507: @20430
        GIM_Try, /*On fail goto*//*Label 508*/ 20535, // Rule ID 3071 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_raddhn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 366:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (RADDHNv8i16_v16i8:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::RADDHNv8i16_v16i8,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3071,
          GIR_Done,
        // Label 508: @20535
        GIM_Try, /*On fail goto*//*Label 509*/ 20640, // Rule ID 3074 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_rsubhn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 369:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (RSUBHNv8i16_v16i8:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::RSUBHNv8i16_v16i8,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3074,
          GIR_Done,
        // Label 509: @20640
        GIM_Try, /*On fail goto*//*Label 510*/ 20733, // Rule ID 1873 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqxtn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 403:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn))  =>  (SQXTNv16i8:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v8i16] }:$Rn)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQXTNv16i8,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1873,
          GIR_Done,
        // Label 510: @20733
        GIM_Try, /*On fail goto*//*Label 511*/ 20826, // Rule ID 2866 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqxtun,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 404:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn))  =>  (SQXTUNv16i8:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v8i16] }:$Rn)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQXTUNv16i8,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2866,
          GIR_Done,
        // Label 511: @20826
        GIM_Try, /*On fail goto*//*Label 512*/ 20919, // Rule ID 2869 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uqxtn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 448:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn))  =>  (UQXTNv16i8:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v8i16] }:$Rn)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UQXTNv16i8,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2869,
          GIR_Done,
        // Label 512: @20919
        GIM_Try, /*On fail goto*//*Label 513*/ 21005, // Rule ID 2872 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, (trunc:{ *:[v8i8] } V128:{ *:[v8i16] }:$Rn))  =>  (XTNv16i8:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v8i16] }:$Rn)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::XTNv16i8,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2872,
          GIR_Done,
        // Label 513: @21005
        GIM_Try, /*On fail goto*//*Label 514*/ 21061, // Rule ID 3291 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rn, (undef:{ *:[v8i8] }))  =>  (INSERT_SUBREG:{ *:[v16i8] } (IMPLICIT_DEF:{ *:[v16i8] }), V64:{ *:[v8i8] }:$Rn, dsub:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
          GIR_AddImm, /*InsnID*/0, /*Imm*/2,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC FPR64*/16,
          // GIR_Coverage, 3291,
          GIR_Done,
        // Label 514: @21061
        GIM_Try, /*On fail goto*//*Label 515*/ 21183, // Rule ID 3285 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
          // (concat_vectors:{ *:[v16i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn)  =>  (INSvi64lane:{ *:[v16i8] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rd, dsub:{ *:[i32] }), 1:{ *:[i64] }, (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v8i8] }:$Rn, dsub:{ *:[i32] }), 0:{ *:[i64] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
          GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // Rn
          GIR_AddImm, /*InsnID*/3, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC FPR128*/38,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, /*RC FPR64*/16,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INSvi64lane,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3285,
          GIR_Done,
        // Label 515: @21183
        GIM_Reject,
      // Label 498: @21184
      GIM_Reject,
      // Label 450: @21185
      GIM_Reject,
    // Label 445: @21186
    GIM_Reject,
    // Label 9: @21187
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 15, /*)*//*default:*//*Label 526*/ 30111,
    /*GILLT_s32*//*Label 516*/ 21207,
    /*GILLT_s64*//*Label 517*/ 21253,
    /*GILLT_s128*//*Label 518*/ 22829, 0,
    /*GILLT_v2s32*//*Label 519*/ 23501,
    /*GILLT_v2s64*//*Label 520*/ 24396, 0,
    /*GILLT_v4s16*//*Label 521*/ 25585,
    /*GILLT_v4s32*//*Label 522*/ 26480, 0,
    /*GILLT_v8s8*//*Label 523*/ 27733,
    /*GILLT_v8s16*//*Label 524*/ 28206, 0,
    /*GILLT_v16s8*//*Label 525*/ 29459,
    // Label 516: @21207
    GIM_Try, /*On fail goto*//*Label 527*/ 21252,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 528*/ 21232, // Rule ID 3802 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        // (bitconvert:{ *:[f32] } GPR32:{ *:[i32] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[f32] } GPR32:{ *:[i32] }:$Xn, FPR32:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR32*/5,
        // GIR_Coverage, 3802,
        GIR_Done,
      // Label 528: @21232
      GIM_Try, /*On fail goto*//*Label 529*/ 21251, // Rule ID 3803 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR32RegClassID,
        // (bitconvert:{ *:[i32] } FPR32:{ *:[f32] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[i32] } FPR32:{ *:[f32] }:$Xn, GPR32:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR32*/6,
        // GIR_Coverage, 3803,
        GIR_Done,
      // Label 529: @21251
      GIM_Reject,
    // Label 527: @21252
    GIM_Reject,
    // Label 517: @21253
    GIM_Try, /*On fail goto*//*Label 530*/ 21278, // Rule ID 3780 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v8i8] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v8i8] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3780,
      GIR_Done,
    // Label 530: @21278
    GIM_Try, /*On fail goto*//*Label 531*/ 21303, // Rule ID 3781 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v4i16] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v4i16] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3781,
      GIR_Done,
    // Label 531: @21303
    GIM_Try, /*On fail goto*//*Label 532*/ 21328, // Rule ID 3782 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v2i32] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v2i32] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3782,
      GIR_Done,
    // Label 532: @21328
    GIM_Try, /*On fail goto*//*Label 533*/ 21353, // Rule ID 3783 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v4f16] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v4f16] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3783,
      GIR_Done,
    // Label 533: @21353
    GIM_Try, /*On fail goto*//*Label 534*/ 21378, // Rule ID 3784 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v2f32] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v2f32] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3784,
      GIR_Done,
    // Label 534: @21378
    GIM_Try, /*On fail goto*//*Label 535*/ 21403, // Rule ID 3785 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v1f64] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v1f64] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3785,
      GIR_Done,
    // Label 535: @21403
    GIM_Try, /*On fail goto*//*Label 536*/ 21451, // Rule ID 3791 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v8i8] }:$Vn)  =>  (REV64v8i8:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v8i8] }:$Vn, GPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3791,
      GIR_Done,
    // Label 536: @21451
    GIM_Try, /*On fail goto*//*Label 537*/ 21499, // Rule ID 3792 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v4i16] }:$Vn)  =>  (REV64v4i16:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v4i16] }:$Vn, GPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3792,
      GIR_Done,
    // Label 537: @21499
    GIM_Try, /*On fail goto*//*Label 538*/ 21547, // Rule ID 3793 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v2i32] }:$Vn)  =>  (REV64v2i32:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v2i32] }:$Vn, GPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3793,
      GIR_Done,
    // Label 538: @21547
    GIM_Try, /*On fail goto*//*Label 539*/ 21595, // Rule ID 3794 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v4f16] }:$Vn)  =>  (REV64v4i16:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v4f16] }:$Vn, GPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3794,
      GIR_Done,
    // Label 539: @21595
    GIM_Try, /*On fail goto*//*Label 540*/ 21643, // Rule ID 3795 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v2f32] }:$Vn)  =>  (REV64v2i32:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v2f32] }:$Vn, GPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3795,
      GIR_Done,
    // Label 540: @21643
    GIM_Try, /*On fail goto*//*Label 541*/ 21666, // Rule ID 3796 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[v1i64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3796,
      GIR_Done,
    // Label 541: @21666
    GIM_Try, /*On fail goto*//*Label 542*/ 21689, // Rule ID 3797 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[v1f64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3797,
      GIR_Done,
    // Label 542: @21689
    GIM_Try, /*On fail goto*//*Label 543*/ 21712, // Rule ID 3798 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v1i64] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v1i64] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3798,
      GIR_Done,
    // Label 543: @21712
    GIM_Try, /*On fail goto*//*Label 544*/ 21735, // Rule ID 3804 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[f64] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[f64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3804,
      GIR_Done,
    // Label 544: @21735
    GIM_Try, /*On fail goto*//*Label 545*/ 21758, // Rule ID 3805 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } FPR64:{ *:[f64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } FPR64:{ *:[f64] }:$Xn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3805,
      GIR_Done,
    // Label 545: @21758
    GIM_Try, /*On fail goto*//*Label 546*/ 21781, // Rule ID 3806 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v1f64] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v1f64] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3806,
      GIR_Done,
    // Label 546: @21781
    GIM_Try, /*On fail goto*//*Label 547*/ 21815, // Rule ID 3807 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v2i32] }:$src)  =>  FPR64:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3807,
      GIR_Done,
    // Label 547: @21815
    GIM_Try, /*On fail goto*//*Label 548*/ 21849, // Rule ID 3808 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v4i16] }:$src)  =>  FPR64:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3808,
      GIR_Done,
    // Label 548: @21849
    GIM_Try, /*On fail goto*//*Label 549*/ 21883, // Rule ID 3809 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v8i8] }:$src)  =>  FPR64:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3809,
      GIR_Done,
    // Label 549: @21883
    GIM_Try, /*On fail goto*//*Label 550*/ 21917, // Rule ID 3810 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v4f16] }:$src)  =>  FPR64:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3810,
      GIR_Done,
    // Label 550: @21917
    GIM_Try, /*On fail goto*//*Label 551*/ 21951, // Rule ID 3811 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v2f32] }:$src)  =>  FPR64:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3811,
      GIR_Done,
    // Label 551: @21951
    GIM_Try, /*On fail goto*//*Label 552*/ 21974, // Rule ID 3812 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v2i32] }:$src)  =>  (REV64v2i32:{ *:[v1i64] } FPR64:{ *:[v2i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3812,
      GIR_Done,
    // Label 552: @21974
    GIM_Try, /*On fail goto*//*Label 553*/ 21997, // Rule ID 3813 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v4i16] }:$src)  =>  (REV64v4i16:{ *:[v1i64] } FPR64:{ *:[v4i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3813,
      GIR_Done,
    // Label 553: @21997
    GIM_Try, /*On fail goto*//*Label 554*/ 22020, // Rule ID 3814 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v8i8] }:$src)  =>  (REV64v8i8:{ *:[v1i64] } FPR64:{ *:[v8i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3814,
      GIR_Done,
    // Label 554: @22020
    GIM_Try, /*On fail goto*//*Label 555*/ 22043, // Rule ID 3815 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v4f16] }:$src)  =>  (REV64v4i16:{ *:[v1i64] } FPR64:{ *:[v4f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3815,
      GIR_Done,
    // Label 555: @22043
    GIM_Try, /*On fail goto*//*Label 556*/ 22066, // Rule ID 3816 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v2f32] }:$src)  =>  (REV64v2i32:{ *:[v1i64] } FPR64:{ *:[v2f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3816,
      GIR_Done,
    // Label 556: @22066
    GIM_Try, /*On fail goto*//*Label 557*/ 22098, // Rule ID 3817 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v1f64] }:$src)  =>  FPR64:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3817,
      GIR_Done,
    // Label 557: @22098
    GIM_Try, /*On fail goto*//*Label 558*/ 22130, // Rule ID 3818 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[f64] }:$src)  =>  FPR64:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3818,
      GIR_Done,
    // Label 558: @22130
    GIM_Try, /*On fail goto*//*Label 559*/ 22164, // Rule ID 3872 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v2i32] }:$src)  =>  FPR64:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3872,
      GIR_Done,
    // Label 559: @22164
    GIM_Try, /*On fail goto*//*Label 560*/ 22198, // Rule ID 3873 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v4i16] }:$src)  =>  FPR64:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3873,
      GIR_Done,
    // Label 560: @22198
    GIM_Try, /*On fail goto*//*Label 561*/ 22232, // Rule ID 3874 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v2f32] }:$src)  =>  FPR64:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3874,
      GIR_Done,
    // Label 561: @22232
    GIM_Try, /*On fail goto*//*Label 562*/ 22266, // Rule ID 3875 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v8i8] }:$src)  =>  FPR64:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3875,
      GIR_Done,
    // Label 562: @22266
    GIM_Try, /*On fail goto*//*Label 563*/ 22300, // Rule ID 3876 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v4f16] }:$src)  =>  FPR64:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3876,
      GIR_Done,
    // Label 563: @22300
    GIM_Try, /*On fail goto*//*Label 564*/ 22323, // Rule ID 3877 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v2i32] }:$src)  =>  (REV64v2i32:{ *:[f64] } FPR64:{ *:[v2i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3877,
      GIR_Done,
    // Label 564: @22323
    GIM_Try, /*On fail goto*//*Label 565*/ 22346, // Rule ID 3878 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v4i16] }:$src)  =>  (REV64v4i16:{ *:[f64] } FPR64:{ *:[v4i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3878,
      GIR_Done,
    // Label 565: @22346
    GIM_Try, /*On fail goto*//*Label 566*/ 22369, // Rule ID 3879 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v2f32] }:$src)  =>  (REV64v2i32:{ *:[f64] } FPR64:{ *:[v2f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3879,
      GIR_Done,
    // Label 566: @22369
    GIM_Try, /*On fail goto*//*Label 567*/ 22392, // Rule ID 3880 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v8i8] }:$src)  =>  (REV64v8i8:{ *:[f64] } FPR64:{ *:[v8i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3880,
      GIR_Done,
    // Label 567: @22392
    GIM_Try, /*On fail goto*//*Label 568*/ 22415, // Rule ID 3881 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v4f16] }:$src)  =>  (REV64v4i16:{ *:[f64] } FPR64:{ *:[v4f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3881,
      GIR_Done,
    // Label 568: @22415
    GIM_Try, /*On fail goto*//*Label 569*/ 22447, // Rule ID 3882 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v1i64] }:$src)  =>  FPR64:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3882,
      GIR_Done,
    // Label 569: @22447
    GIM_Try, /*On fail goto*//*Label 570*/ 22479, // Rule ID 3883 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v1f64] }:$src)  =>  FPR64:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3883,
      GIR_Done,
    // Label 570: @22479
    GIM_Try, /*On fail goto*//*Label 571*/ 22513, // Rule ID 3884 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v2i32] }:$src)  =>  FPR64:{ *:[v1f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3884,
      GIR_Done,
    // Label 571: @22513
    GIM_Try, /*On fail goto*//*Label 572*/ 22547, // Rule ID 3885 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v4i16] }:$src)  =>  FPR64:{ *:[v1f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3885,
      GIR_Done,
    // Label 572: @22547
    GIM_Try, /*On fail goto*//*Label 573*/ 22581, // Rule ID 3886 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v8i8] }:$src)  =>  FPR64:{ *:[v1f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3886,
      GIR_Done,
    // Label 573: @22581
    GIM_Try, /*On fail goto*//*Label 574*/ 22615, // Rule ID 3887 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v2f32] }:$src)  =>  FPR64:{ *:[v1f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3887,
      GIR_Done,
    // Label 574: @22615
    GIM_Try, /*On fail goto*//*Label 575*/ 22649, // Rule ID 3888 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v4f16] }:$src)  =>  FPR64:{ *:[v1f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3888,
      GIR_Done,
    // Label 575: @22649
    GIM_Try, /*On fail goto*//*Label 576*/ 22672, // Rule ID 3889 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v2i32] }:$src)  =>  (REV64v2i32:{ *:[v1f64] } FPR64:{ *:[v2i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3889,
      GIR_Done,
    // Label 576: @22672
    GIM_Try, /*On fail goto*//*Label 577*/ 22695, // Rule ID 3890 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v4i16] }:$src)  =>  (REV64v4i16:{ *:[v1f64] } FPR64:{ *:[v4i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3890,
      GIR_Done,
    // Label 577: @22695
    GIM_Try, /*On fail goto*//*Label 578*/ 22718, // Rule ID 3891 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v8i8] }:$src)  =>  (REV64v8i8:{ *:[v1f64] } FPR64:{ *:[v8i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3891,
      GIR_Done,
    // Label 578: @22718
    GIM_Try, /*On fail goto*//*Label 579*/ 22741, // Rule ID 3892 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v2f32] }:$src)  =>  (REV64v2i32:{ *:[v1f64] } FPR64:{ *:[v2f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3892,
      GIR_Done,
    // Label 579: @22741
    GIM_Try, /*On fail goto*//*Label 580*/ 22764, // Rule ID 3893 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v4f16] }:$src)  =>  (REV64v4i16:{ *:[v1f64] } FPR64:{ *:[v4f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3893,
      GIR_Done,
    // Label 580: @22764
    GIM_Try, /*On fail goto*//*Label 581*/ 22796, // Rule ID 3894 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v1i64] }:$src)  =>  FPR64:{ *:[v1f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3894,
      GIR_Done,
    // Label 581: @22796
    GIM_Try, /*On fail goto*//*Label 582*/ 22828, // Rule ID 3895 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[f64] }:$src)  =>  FPR64:{ *:[v1f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3895,
      GIR_Done,
    // Label 582: @22828
    GIM_Reject,
    // Label 518: @22829
    GIM_Try, /*On fail goto*//*Label 583*/ 22863, // Rule ID 3909 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v2i64] }:$src)  =>  FPR128:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3909,
      GIR_Done,
    // Label 583: @22863
    GIM_Try, /*On fail goto*//*Label 584*/ 22897, // Rule ID 3910 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v4i32] }:$src)  =>  FPR128:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3910,
      GIR_Done,
    // Label 584: @22897
    GIM_Try, /*On fail goto*//*Label 585*/ 22931, // Rule ID 3911 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v8i16] }:$src)  =>  FPR128:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3911,
      GIR_Done,
    // Label 585: @22931
    GIM_Try, /*On fail goto*//*Label 586*/ 22965, // Rule ID 3912 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v2f64] }:$src)  =>  FPR128:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3912,
      GIR_Done,
    // Label 586: @22965
    GIM_Try, /*On fail goto*//*Label 587*/ 22999, // Rule ID 3913 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v4f32] }:$src)  =>  FPR128:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3913,
      GIR_Done,
    // Label 587: @22999
    GIM_Try, /*On fail goto*//*Label 588*/ 23033, // Rule ID 3914 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v8f16] }:$src)  =>  FPR128:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3914,
      GIR_Done,
    // Label 588: @23033
    GIM_Try, /*On fail goto*//*Label 589*/ 23067, // Rule ID 3915 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v16i8] }:$src)  =>  FPR128:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3915,
      GIR_Done,
    // Label 589: @23067
    GIM_Try, /*On fail goto*//*Label 590*/ 23106, // Rule ID 3916 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v2i64] }:$src)  =>  (EXTv16i8:{ *:[f128] } FPR128:{ *:[v2i64] }:$src, FPR128:{ *:[v2i64] }:$src, 8:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3916,
      GIR_Done,
    // Label 590: @23106
    GIM_Try, /*On fail goto*//*Label 591*/ 23177, // Rule ID 3917 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v4i32] }:$src)  =>  (EXTv16i8:{ *:[f128] } (REV64v4i32:{ *:[f128] } FPR128:{ *:[v4i32] }:$src), (REV64v4i32:{ *:[f128] } FPR128:{ *:[v4i32] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3917,
      GIR_Done,
    // Label 591: @23177
    GIM_Try, /*On fail goto*//*Label 592*/ 23248, // Rule ID 3918 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v8i16] }:$src)  =>  (EXTv16i8:{ *:[f128] } (REV64v8i16:{ *:[f128] } FPR128:{ *:[v8i16] }:$src), (REV64v8i16:{ *:[f128] } FPR128:{ *:[v8i16] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3918,
      GIR_Done,
    // Label 592: @23248
    GIM_Try, /*On fail goto*//*Label 593*/ 23319, // Rule ID 3919 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v8f16] }:$src)  =>  (EXTv16i8:{ *:[f128] } (REV64v8i16:{ *:[f128] } FPR128:{ *:[v8f16] }:$src), (REV64v8i16:{ *:[f128] } FPR128:{ *:[v8f16] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3919,
      GIR_Done,
    // Label 593: @23319
    GIM_Try, /*On fail goto*//*Label 594*/ 23358, // Rule ID 3920 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v2f64] }:$src)  =>  (EXTv16i8:{ *:[f128] } FPR128:{ *:[v2f64] }:$src, FPR128:{ *:[v2f64] }:$src, 8:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3920,
      GIR_Done,
    // Label 594: @23358
    GIM_Try, /*On fail goto*//*Label 595*/ 23429, // Rule ID 3921 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v4f32] }:$src)  =>  (EXTv16i8:{ *:[f128] } (REV64v4i32:{ *:[f128] } FPR128:{ *:[v4f32] }:$src), (REV64v4i32:{ *:[f128] } FPR128:{ *:[v4f32] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3921,
      GIR_Done,
    // Label 595: @23429
    GIM_Try, /*On fail goto*//*Label 596*/ 23500, // Rule ID 3922 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v16i8] }:$src)  =>  (EXTv16i8:{ *:[f128] } (REV64v16i8:{ *:[f128] } FPR128:{ *:[v16i8] }:$src), (REV64v16i8:{ *:[f128] } FPR128:{ *:[v16i8] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v16i8,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v16i8,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3922,
      GIR_Done,
    // Label 596: @23500
    GIM_Reject,
    // Label 519: @23501
    GIM_Try, /*On fail goto*//*Label 597*/ 23526, // Rule ID 3777 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[v2i32] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3777,
      GIR_Done,
    // Label 597: @23526
    GIM_Try, /*On fail goto*//*Label 598*/ 23551, // Rule ID 3779 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[v2f32] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3779,
      GIR_Done,
    // Label 598: @23551
    GIM_Try, /*On fail goto*//*Label 599*/ 23599, // Rule ID 3788 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } GPR64:{ *:[i64] }:$Xn)  =>  (REV64v2i32:{ *:[v2i32] } (COPY_TO_REGCLASS:{ *:[i64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Xn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3788,
      GIR_Done,
    // Label 599: @23599
    GIM_Try, /*On fail goto*//*Label 600*/ 23647, // Rule ID 3790 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } GPR64:{ *:[i64] }:$Xn)  =>  (REV64v2i32:{ *:[v2f32] } (COPY_TO_REGCLASS:{ *:[i64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Xn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3790,
      GIR_Done,
    // Label 600: @23647
    GIM_Try, /*On fail goto*//*Label 601*/ 23681, // Rule ID 3819 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v1i64] }:$src)  =>  FPR64:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3819,
      GIR_Done,
    // Label 601: @23681
    GIM_Try, /*On fail goto*//*Label 602*/ 23715, // Rule ID 3820 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v4i16] }:$src)  =>  FPR64:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3820,
      GIR_Done,
    // Label 602: @23715
    GIM_Try, /*On fail goto*//*Label 603*/ 23749, // Rule ID 3821 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v8i8] }:$src)  =>  FPR64:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3821,
      GIR_Done,
    // Label 603: @23749
    GIM_Try, /*On fail goto*//*Label 604*/ 23783, // Rule ID 3822 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[f64] }:$src)  =>  FPR64:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3822,
      GIR_Done,
    // Label 604: @23783
    GIM_Try, /*On fail goto*//*Label 605*/ 23817, // Rule ID 3823 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v1f64] }:$src)  =>  FPR64:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3823,
      GIR_Done,
    // Label 605: @23817
    GIM_Try, /*On fail goto*//*Label 606*/ 23851, // Rule ID 3824 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v4f16] }:$src)  =>  FPR64:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3824,
      GIR_Done,
    // Label 606: @23851
    GIM_Try, /*On fail goto*//*Label 607*/ 23874, // Rule ID 3825 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v1i64] }:$src)  =>  (REV64v2i32:{ *:[v2i32] } FPR64:{ *:[v1i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3825,
      GIR_Done,
    // Label 607: @23874
    GIM_Try, /*On fail goto*//*Label 608*/ 23897, // Rule ID 3826 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v4i16] }:$src)  =>  (REV32v4i16:{ *:[v2i32] } FPR64:{ *:[v4i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3826,
      GIR_Done,
    // Label 608: @23897
    GIM_Try, /*On fail goto*//*Label 609*/ 23920, // Rule ID 3827 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v8i8] }:$src)  =>  (REV32v8i8:{ *:[v2i32] } FPR64:{ *:[v8i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3827,
      GIR_Done,
    // Label 609: @23920
    GIM_Try, /*On fail goto*//*Label 610*/ 23943, // Rule ID 3828 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[f64] }:$src)  =>  (REV64v2i32:{ *:[v2i32] } FPR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3828,
      GIR_Done,
    // Label 610: @23943
    GIM_Try, /*On fail goto*//*Label 611*/ 23966, // Rule ID 3829 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v1f64] }:$src)  =>  (REV64v2i32:{ *:[v2i32] } FPR64:{ *:[v1f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3829,
      GIR_Done,
    // Label 611: @23966
    GIM_Try, /*On fail goto*//*Label 612*/ 23989, // Rule ID 3830 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v4f16] }:$src)  =>  (REV32v4i16:{ *:[v2i32] } FPR64:{ *:[v4f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3830,
      GIR_Done,
    // Label 612: @23989
    GIM_Try, /*On fail goto*//*Label 613*/ 24021, // Rule ID 3831 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v2f32] }:$src)  =>  FPR64:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3831,
      GIR_Done,
    // Label 613: @24021
    GIM_Try, /*On fail goto*//*Label 614*/ 24055, // Rule ID 3896 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v1i64] }:$src)  =>  FPR64:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3896,
      GIR_Done,
    // Label 614: @24055
    GIM_Try, /*On fail goto*//*Label 615*/ 24089, // Rule ID 3897 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v4i16] }:$src)  =>  FPR64:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3897,
      GIR_Done,
    // Label 615: @24089
    GIM_Try, /*On fail goto*//*Label 616*/ 24123, // Rule ID 3898 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v8i8] }:$src)  =>  FPR64:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3898,
      GIR_Done,
    // Label 616: @24123
    GIM_Try, /*On fail goto*//*Label 617*/ 24157, // Rule ID 3899 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v1f64] }:$src)  =>  FPR64:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3899,
      GIR_Done,
    // Label 617: @24157
    GIM_Try, /*On fail goto*//*Label 618*/ 24191, // Rule ID 3900 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[f64] }:$src)  =>  FPR64:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3900,
      GIR_Done,
    // Label 618: @24191
    GIM_Try, /*On fail goto*//*Label 619*/ 24225, // Rule ID 3901 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v4f16] }:$src)  =>  FPR64:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3901,
      GIR_Done,
    // Label 619: @24225
    GIM_Try, /*On fail goto*//*Label 620*/ 24248, // Rule ID 3902 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v1i64] }:$src)  =>  (REV64v2i32:{ *:[v2f32] } FPR64:{ *:[v1i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3902,
      GIR_Done,
    // Label 620: @24248
    GIM_Try, /*On fail goto*//*Label 621*/ 24271, // Rule ID 3903 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v4i16] }:$src)  =>  (REV32v4i16:{ *:[v2f32] } FPR64:{ *:[v4i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3903,
      GIR_Done,
    // Label 621: @24271
    GIM_Try, /*On fail goto*//*Label 622*/ 24294, // Rule ID 3904 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v8i8] }:$src)  =>  (REV32v8i8:{ *:[v2f32] } FPR64:{ *:[v8i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3904,
      GIR_Done,
    // Label 622: @24294
    GIM_Try, /*On fail goto*//*Label 623*/ 24317, // Rule ID 3905 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v1f64] }:$src)  =>  (REV64v2i32:{ *:[v2f32] } FPR64:{ *:[v1f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3905,
      GIR_Done,
    // Label 623: @24317
    GIM_Try, /*On fail goto*//*Label 624*/ 24340, // Rule ID 3906 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[f64] }:$src)  =>  (REV64v2i32:{ *:[v2f32] } FPR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3906,
      GIR_Done,
    // Label 624: @24340
    GIM_Try, /*On fail goto*//*Label 625*/ 24363, // Rule ID 3907 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v4f16] }:$src)  =>  (REV32v4i16:{ *:[v2f32] } FPR64:{ *:[v4f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3907,
      GIR_Done,
    // Label 625: @24363
    GIM_Try, /*On fail goto*//*Label 626*/ 24395, // Rule ID 3908 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v2i32] }:$src)  =>  FPR64:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3908,
      GIR_Done,
    // Label 626: @24395
    GIM_Reject,
    // Label 520: @24396
    GIM_Try, /*On fail goto*//*Label 627*/ 24430, // Rule ID 3923 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[f128] }:$src)  =>  FPR128:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3923,
      GIR_Done,
    // Label 627: @24430
    GIM_Try, /*On fail goto*//*Label 628*/ 24464, // Rule ID 3924 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v4i32] }:$src)  =>  FPR128:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3924,
      GIR_Done,
    // Label 628: @24464
    GIM_Try, /*On fail goto*//*Label 629*/ 24498, // Rule ID 3925 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v8i16] }:$src)  =>  FPR128:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3925,
      GIR_Done,
    // Label 629: @24498
    GIM_Try, /*On fail goto*//*Label 630*/ 24532, // Rule ID 3926 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v8f16] }:$src)  =>  FPR128:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3926,
      GIR_Done,
    // Label 630: @24532
    GIM_Try, /*On fail goto*//*Label 631*/ 24566, // Rule ID 3927 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v16i8] }:$src)  =>  FPR128:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3927,
      GIR_Done,
    // Label 631: @24566
    GIM_Try, /*On fail goto*//*Label 632*/ 24600, // Rule ID 3928 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v4f32] }:$src)  =>  FPR128:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3928,
      GIR_Done,
    // Label 632: @24600
    GIM_Try, /*On fail goto*//*Label 633*/ 24639, // Rule ID 3929 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[f128] }:$src)  =>  (EXTv16i8:{ *:[v2f64] } FPR128:{ *:[f128] }:$src, FPR128:{ *:[f128] }:$src, 8:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3929,
      GIR_Done,
    // Label 633: @24639
    GIM_Try, /*On fail goto*//*Label 634*/ 24662, // Rule ID 3930 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v4i32] }:$src)  =>  (REV64v4i32:{ *:[v2f64] } FPR128:{ *:[v4i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3930,
      GIR_Done,
    // Label 634: @24662
    GIM_Try, /*On fail goto*//*Label 635*/ 24685, // Rule ID 3931 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v8i16] }:$src)  =>  (REV64v8i16:{ *:[v2f64] } FPR128:{ *:[v8i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3931,
      GIR_Done,
    // Label 635: @24685
    GIM_Try, /*On fail goto*//*Label 636*/ 24708, // Rule ID 3932 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v8f16] }:$src)  =>  (REV64v8i16:{ *:[v2f64] } FPR128:{ *:[v8f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3932,
      GIR_Done,
    // Label 636: @24708
    GIM_Try, /*On fail goto*//*Label 637*/ 24731, // Rule ID 3933 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v16i8] }:$src)  =>  (REV64v16i8:{ *:[v2f64] } FPR128:{ *:[v16i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3933,
      GIR_Done,
    // Label 637: @24731
    GIM_Try, /*On fail goto*//*Label 638*/ 24754, // Rule ID 3934 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v4f32] }:$src)  =>  (REV64v4i32:{ *:[v2f64] } FPR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3934,
      GIR_Done,
    // Label 638: @24754
    GIM_Try, /*On fail goto*//*Label 639*/ 24786, // Rule ID 3935 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v2i64] }:$src)  =>  FPR128:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3935,
      GIR_Done,
    // Label 639: @24786
    GIM_Try, /*On fail goto*//*Label 640*/ 24820, // Rule ID 3949 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[f128] }:$src)  =>  FPR128:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3949,
      GIR_Done,
    // Label 640: @24820
    GIM_Try, /*On fail goto*//*Label 641*/ 24854, // Rule ID 3950 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v4i32] }:$src)  =>  FPR128:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3950,
      GIR_Done,
    // Label 641: @24854
    GIM_Try, /*On fail goto*//*Label 642*/ 24888, // Rule ID 3951 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v8i16] }:$src)  =>  FPR128:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3951,
      GIR_Done,
    // Label 642: @24888
    GIM_Try, /*On fail goto*//*Label 643*/ 24922, // Rule ID 3952 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v16i8] }:$src)  =>  FPR128:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3952,
      GIR_Done,
    // Label 643: @24922
    GIM_Try, /*On fail goto*//*Label 644*/ 24956, // Rule ID 3953 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v4f32] }:$src)  =>  FPR128:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3953,
      GIR_Done,
    // Label 644: @24956
    GIM_Try, /*On fail goto*//*Label 645*/ 24990, // Rule ID 3954 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v8f16] }:$src)  =>  FPR128:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3954,
      GIR_Done,
    // Label 645: @24990
    GIM_Try, /*On fail goto*//*Label 646*/ 25029, // Rule ID 3955 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[f128] }:$src)  =>  (EXTv16i8:{ *:[v2i64] } FPR128:{ *:[f128] }:$src, FPR128:{ *:[f128] }:$src, 8:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3955,
      GIR_Done,
    // Label 646: @25029
    GIM_Try, /*On fail goto*//*Label 647*/ 25052, // Rule ID 3956 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v4i32] }:$src)  =>  (REV64v4i32:{ *:[v2i64] } FPR128:{ *:[v4i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3956,
      GIR_Done,
    // Label 647: @25052
    GIM_Try, /*On fail goto*//*Label 648*/ 25075, // Rule ID 3957 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v8i16] }:$src)  =>  (REV64v8i16:{ *:[v2i64] } FPR128:{ *:[v8i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3957,
      GIR_Done,
    // Label 648: @25075
    GIM_Try, /*On fail goto*//*Label 649*/ 25098, // Rule ID 3958 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v16i8] }:$src)  =>  (REV64v16i8:{ *:[v2i64] } FPR128:{ *:[v16i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3958,
      GIR_Done,
    // Label 649: @25098
    GIM_Try, /*On fail goto*//*Label 650*/ 25121, // Rule ID 3959 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v4f32] }:$src)  =>  (REV64v4i32:{ *:[v2i64] } FPR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3959,
      GIR_Done,
    // Label 650: @25121
    GIM_Try, /*On fail goto*//*Label 651*/ 25144, // Rule ID 3960 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v8f16] }:$src)  =>  (REV64v8i16:{ *:[v2i64] } FPR128:{ *:[v8f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3960,
      GIR_Done,
    // Label 651: @25144
    GIM_Try, /*On fail goto*//*Label 652*/ 25176, // Rule ID 3961 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v2f64] }:$src)  =>  FPR128:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3961,
      GIR_Done,
    // Label 652: @25176
    GIM_Try, /*On fail goto*//*Label 653*/ 25210, // Rule ID 5192 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv2i64] } ZPR:{ *:[nxv16i8] }:$src)  =>  ZPR:{ *:[nxv2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5192,
      GIR_Done,
    // Label 653: @25210
    GIM_Try, /*On fail goto*//*Label 654*/ 25244, // Rule ID 5193 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv2i64] } ZPR:{ *:[nxv8i16] }:$src)  =>  ZPR:{ *:[nxv2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5193,
      GIR_Done,
    // Label 654: @25244
    GIM_Try, /*On fail goto*//*Label 655*/ 25278, // Rule ID 5194 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv2i64] } ZPR:{ *:[nxv4i32] }:$src)  =>  ZPR:{ *:[nxv2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5194,
      GIR_Done,
    // Label 655: @25278
    GIM_Try, /*On fail goto*//*Label 656*/ 25312, // Rule ID 5195 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv2i64] } ZPR:{ *:[nxv8f16] }:$src)  =>  ZPR:{ *:[nxv2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5195,
      GIR_Done,
    // Label 656: @25312
    GIM_Try, /*On fail goto*//*Label 657*/ 25346, // Rule ID 5196 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv2i64] } ZPR:{ *:[nxv4f32] }:$src)  =>  ZPR:{ *:[nxv2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5196,
      GIR_Done,
    // Label 657: @25346
    GIM_Try, /*On fail goto*//*Label 658*/ 25380, // Rule ID 5197 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv2i64] } ZPR:{ *:[nxv2f64] }:$src)  =>  ZPR:{ *:[nxv2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5197,
      GIR_Done,
    // Label 658: @25380
    GIM_Try, /*On fail goto*//*Label 659*/ 25414, // Rule ID 5210 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv2f64] } ZPR:{ *:[nxv16i8] }:$src)  =>  ZPR:{ *:[nxv2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5210,
      GIR_Done,
    // Label 659: @25414
    GIM_Try, /*On fail goto*//*Label 660*/ 25448, // Rule ID 5211 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv2f64] } ZPR:{ *:[nxv8i16] }:$src)  =>  ZPR:{ *:[nxv2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5211,
      GIR_Done,
    // Label 660: @25448
    GIM_Try, /*On fail goto*//*Label 661*/ 25482, // Rule ID 5212 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv2f64] } ZPR:{ *:[nxv4i32] }:$src)  =>  ZPR:{ *:[nxv2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5212,
      GIR_Done,
    // Label 661: @25482
    GIM_Try, /*On fail goto*//*Label 662*/ 25516, // Rule ID 5213 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv2f64] } ZPR:{ *:[nxv2i64] }:$src)  =>  ZPR:{ *:[nxv2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5213,
      GIR_Done,
    // Label 662: @25516
    GIM_Try, /*On fail goto*//*Label 663*/ 25550, // Rule ID 5214 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv2f64] } ZPR:{ *:[nxv8f16] }:$src)  =>  ZPR:{ *:[nxv2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5214,
      GIR_Done,
    // Label 663: @25550
    GIM_Try, /*On fail goto*//*Label 664*/ 25584, // Rule ID 5215 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv2f64] } ZPR:{ *:[nxv4f32] }:$src)  =>  ZPR:{ *:[nxv2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5215,
      GIR_Done,
    // Label 664: @25584
    GIM_Reject,
    // Label 521: @25585
    GIM_Try, /*On fail goto*//*Label 665*/ 25610, // Rule ID 3776 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[v4i16] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3776,
      GIR_Done,
    // Label 665: @25610
    GIM_Try, /*On fail goto*//*Label 666*/ 25635, // Rule ID 3778 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[v4f16] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3778,
      GIR_Done,
    // Label 666: @25635
    GIM_Try, /*On fail goto*//*Label 667*/ 25683, // Rule ID 3787 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } GPR64:{ *:[i64] }:$Xn)  =>  (REV64v4i16:{ *:[v4i16] } (COPY_TO_REGCLASS:{ *:[i64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Xn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3787,
      GIR_Done,
    // Label 667: @25683
    GIM_Try, /*On fail goto*//*Label 668*/ 25731, // Rule ID 3789 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } GPR64:{ *:[i64] }:$Xn)  =>  (REV64v4i16:{ *:[v4f16] } (COPY_TO_REGCLASS:{ *:[i64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Xn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3789,
      GIR_Done,
    // Label 668: @25731
    GIM_Try, /*On fail goto*//*Label 669*/ 25765, // Rule ID 3832 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v1i64] }:$src)  =>  FPR64:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3832,
      GIR_Done,
    // Label 669: @25765
    GIM_Try, /*On fail goto*//*Label 670*/ 25799, // Rule ID 3833 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v2i32] }:$src)  =>  FPR64:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3833,
      GIR_Done,
    // Label 670: @25799
    GIM_Try, /*On fail goto*//*Label 671*/ 25833, // Rule ID 3834 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v8i8] }:$src)  =>  FPR64:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3834,
      GIR_Done,
    // Label 671: @25833
    GIM_Try, /*On fail goto*//*Label 672*/ 25867, // Rule ID 3835 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[f64] }:$src)  =>  FPR64:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3835,
      GIR_Done,
    // Label 672: @25867
    GIM_Try, /*On fail goto*//*Label 673*/ 25901, // Rule ID 3836 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v2f32] }:$src)  =>  FPR64:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3836,
      GIR_Done,
    // Label 673: @25901
    GIM_Try, /*On fail goto*//*Label 674*/ 25935, // Rule ID 3837 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v1f64] }:$src)  =>  FPR64:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3837,
      GIR_Done,
    // Label 674: @25935
    GIM_Try, /*On fail goto*//*Label 675*/ 25958, // Rule ID 3838 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v1i64] }:$src)  =>  (REV64v4i16:{ *:[v4i16] } FPR64:{ *:[v1i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3838,
      GIR_Done,
    // Label 675: @25958
    GIM_Try, /*On fail goto*//*Label 676*/ 25981, // Rule ID 3839 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v2i32] }:$src)  =>  (REV32v4i16:{ *:[v4i16] } FPR64:{ *:[v2i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3839,
      GIR_Done,
    // Label 676: @25981
    GIM_Try, /*On fail goto*//*Label 677*/ 26004, // Rule ID 3840 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v8i8] }:$src)  =>  (REV16v8i8:{ *:[v4i16] } FPR64:{ *:[v8i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3840,
      GIR_Done,
    // Label 677: @26004
    GIM_Try, /*On fail goto*//*Label 678*/ 26027, // Rule ID 3841 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[f64] }:$src)  =>  (REV64v4i16:{ *:[v4i16] } FPR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3841,
      GIR_Done,
    // Label 678: @26027
    GIM_Try, /*On fail goto*//*Label 679*/ 26050, // Rule ID 3842 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v2f32] }:$src)  =>  (REV32v4i16:{ *:[v4i16] } FPR64:{ *:[v2f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3842,
      GIR_Done,
    // Label 679: @26050
    GIM_Try, /*On fail goto*//*Label 680*/ 26073, // Rule ID 3843 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v1f64] }:$src)  =>  (REV64v4i16:{ *:[v4i16] } FPR64:{ *:[v1f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3843,
      GIR_Done,
    // Label 680: @26073
    GIM_Try, /*On fail goto*//*Label 681*/ 26105, // Rule ID 3844 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v4f16] }:$src)  =>  FPR64:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3844,
      GIR_Done,
    // Label 681: @26105
    GIM_Try, /*On fail goto*//*Label 682*/ 26139, // Rule ID 3845 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v1i64] }:$src)  =>  FPR64:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3845,
      GIR_Done,
    // Label 682: @26139
    GIM_Try, /*On fail goto*//*Label 683*/ 26173, // Rule ID 3846 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v2i32] }:$src)  =>  FPR64:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3846,
      GIR_Done,
    // Label 683: @26173
    GIM_Try, /*On fail goto*//*Label 684*/ 26207, // Rule ID 3847 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v8i8] }:$src)  =>  FPR64:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3847,
      GIR_Done,
    // Label 684: @26207
    GIM_Try, /*On fail goto*//*Label 685*/ 26241, // Rule ID 3848 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[f64] }:$src)  =>  FPR64:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3848,
      GIR_Done,
    // Label 685: @26241
    GIM_Try, /*On fail goto*//*Label 686*/ 26275, // Rule ID 3849 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v2f32] }:$src)  =>  FPR64:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3849,
      GIR_Done,
    // Label 686: @26275
    GIM_Try, /*On fail goto*//*Label 687*/ 26309, // Rule ID 3850 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v1f64] }:$src)  =>  FPR64:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3850,
      GIR_Done,
    // Label 687: @26309
    GIM_Try, /*On fail goto*//*Label 688*/ 26332, // Rule ID 3851 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v1i64] }:$src)  =>  (REV64v4i16:{ *:[v4f16] } FPR64:{ *:[v1i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3851,
      GIR_Done,
    // Label 688: @26332
    GIM_Try, /*On fail goto*//*Label 689*/ 26355, // Rule ID 3852 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v2i32] }:$src)  =>  (REV32v4i16:{ *:[v4f16] } FPR64:{ *:[v2i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3852,
      GIR_Done,
    // Label 689: @26355
    GIM_Try, /*On fail goto*//*Label 690*/ 26378, // Rule ID 3853 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v8i8] }:$src)  =>  (REV16v8i8:{ *:[v4f16] } FPR64:{ *:[v8i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3853,
      GIR_Done,
    // Label 690: @26378
    GIM_Try, /*On fail goto*//*Label 691*/ 26401, // Rule ID 3854 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[f64] }:$src)  =>  (REV64v4i16:{ *:[v4f16] } FPR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3854,
      GIR_Done,
    // Label 691: @26401
    GIM_Try, /*On fail goto*//*Label 692*/ 26424, // Rule ID 3855 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v2f32] }:$src)  =>  (REV32v4i16:{ *:[v4f16] } FPR64:{ *:[v2f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3855,
      GIR_Done,
    // Label 692: @26424
    GIM_Try, /*On fail goto*//*Label 693*/ 26447, // Rule ID 3856 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v1f64] }:$src)  =>  (REV64v4i16:{ *:[v4f16] } FPR64:{ *:[v1f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3856,
      GIR_Done,
    // Label 693: @26447
    GIM_Try, /*On fail goto*//*Label 694*/ 26479, // Rule ID 3857 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v4i16] }:$src)  =>  FPR64:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3857,
      GIR_Done,
    // Label 694: @26479
    GIM_Reject,
    // Label 522: @26480
    GIM_Try, /*On fail goto*//*Label 695*/ 26514, // Rule ID 3936 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[f128] }:$src)  =>  FPR128:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3936,
      GIR_Done,
    // Label 695: @26514
    GIM_Try, /*On fail goto*//*Label 696*/ 26548, // Rule ID 3937 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v8i16] }:$src)  =>  FPR128:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3937,
      GIR_Done,
    // Label 696: @26548
    GIM_Try, /*On fail goto*//*Label 697*/ 26582, // Rule ID 3938 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v8f16] }:$src)  =>  FPR128:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3938,
      GIR_Done,
    // Label 697: @26582
    GIM_Try, /*On fail goto*//*Label 698*/ 26616, // Rule ID 3939 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v16i8] }:$src)  =>  FPR128:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3939,
      GIR_Done,
    // Label 698: @26616
    GIM_Try, /*On fail goto*//*Label 699*/ 26650, // Rule ID 3940 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v2i64] }:$src)  =>  FPR128:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3940,
      GIR_Done,
    // Label 699: @26650
    GIM_Try, /*On fail goto*//*Label 700*/ 26684, // Rule ID 3941 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v2f64] }:$src)  =>  FPR128:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3941,
      GIR_Done,
    // Label 700: @26684
    GIM_Try, /*On fail goto*//*Label 701*/ 26755, // Rule ID 3942 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[f128] }:$src)  =>  (EXTv16i8:{ *:[v4f32] } (REV64v4i32:{ *:[f128] } FPR128:{ *:[f128] }:$src), (REV64v4i32:{ *:[f128] } FPR128:{ *:[f128] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3942,
      GIR_Done,
    // Label 701: @26755
    GIM_Try, /*On fail goto*//*Label 702*/ 26778, // Rule ID 3943 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v8i16] }:$src)  =>  (REV32v8i16:{ *:[v4f32] } FPR128:{ *:[v8i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3943,
      GIR_Done,
    // Label 702: @26778
    GIM_Try, /*On fail goto*//*Label 703*/ 26801, // Rule ID 3944 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v8f16] }:$src)  =>  (REV32v8i16:{ *:[v4f32] } FPR128:{ *:[v8f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3944,
      GIR_Done,
    // Label 703: @26801
    GIM_Try, /*On fail goto*//*Label 704*/ 26824, // Rule ID 3945 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v16i8] }:$src)  =>  (REV32v16i8:{ *:[v4f32] } FPR128:{ *:[v16i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3945,
      GIR_Done,
    // Label 704: @26824
    GIM_Try, /*On fail goto*//*Label 705*/ 26847, // Rule ID 3946 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v2i64] }:$src)  =>  (REV64v4i32:{ *:[v4f32] } FPR128:{ *:[v2i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3946,
      GIR_Done,
    // Label 705: @26847
    GIM_Try, /*On fail goto*//*Label 706*/ 26870, // Rule ID 3947 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v2f64] }:$src)  =>  (REV64v4i32:{ *:[v4f32] } FPR128:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3947,
      GIR_Done,
    // Label 706: @26870
    GIM_Try, /*On fail goto*//*Label 707*/ 26902, // Rule ID 3948 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v4i32] }:$src)  =>  FPR128:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3948,
      GIR_Done,
    // Label 707: @26902
    GIM_Try, /*On fail goto*//*Label 708*/ 26936, // Rule ID 3962 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[f128] }:$src)  =>  FPR128:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3962,
      GIR_Done,
    // Label 708: @26936
    GIM_Try, /*On fail goto*//*Label 709*/ 26970, // Rule ID 3963 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v2i64] }:$src)  =>  FPR128:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3963,
      GIR_Done,
    // Label 709: @26970
    GIM_Try, /*On fail goto*//*Label 710*/ 27004, // Rule ID 3964 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v8i16] }:$src)  =>  FPR128:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3964,
      GIR_Done,
    // Label 710: @27004
    GIM_Try, /*On fail goto*//*Label 711*/ 27038, // Rule ID 3965 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v16i8] }:$src)  =>  FPR128:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3965,
      GIR_Done,
    // Label 711: @27038
    GIM_Try, /*On fail goto*//*Label 712*/ 27072, // Rule ID 3966 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v2f64] }:$src)  =>  FPR128:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3966,
      GIR_Done,
    // Label 712: @27072
    GIM_Try, /*On fail goto*//*Label 713*/ 27106, // Rule ID 3967 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v8f16] }:$src)  =>  FPR128:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3967,
      GIR_Done,
    // Label 713: @27106
    GIM_Try, /*On fail goto*//*Label 714*/ 27177, // Rule ID 3968 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[f128] }:$src)  =>  (EXTv16i8:{ *:[v4i32] } (REV64v4i32:{ *:[f128] } FPR128:{ *:[f128] }:$src), (REV64v4i32:{ *:[f128] } FPR128:{ *:[f128] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3968,
      GIR_Done,
    // Label 714: @27177
    GIM_Try, /*On fail goto*//*Label 715*/ 27200, // Rule ID 3969 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v2i64] }:$src)  =>  (REV64v4i32:{ *:[v4i32] } FPR128:{ *:[v2i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3969,
      GIR_Done,
    // Label 715: @27200
    GIM_Try, /*On fail goto*//*Label 716*/ 27223, // Rule ID 3970 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v8i16] }:$src)  =>  (REV32v8i16:{ *:[v4i32] } FPR128:{ *:[v8i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3970,
      GIR_Done,
    // Label 716: @27223
    GIM_Try, /*On fail goto*//*Label 717*/ 27246, // Rule ID 3971 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v16i8] }:$src)  =>  (REV32v16i8:{ *:[v4i32] } FPR128:{ *:[v16i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3971,
      GIR_Done,
    // Label 717: @27246
    GIM_Try, /*On fail goto*//*Label 718*/ 27269, // Rule ID 3972 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v2f64] }:$src)  =>  (REV64v4i32:{ *:[v4i32] } FPR128:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3972,
      GIR_Done,
    // Label 718: @27269
    GIM_Try, /*On fail goto*//*Label 719*/ 27292, // Rule ID 3973 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v8f16] }:$src)  =>  (REV32v8i16:{ *:[v4i32] } FPR128:{ *:[v8f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3973,
      GIR_Done,
    // Label 719: @27292
    GIM_Try, /*On fail goto*//*Label 720*/ 27324, // Rule ID 3974 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v4f32] }:$src)  =>  FPR128:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3974,
      GIR_Done,
    // Label 720: @27324
    GIM_Try, /*On fail goto*//*Label 721*/ 27358, // Rule ID 5186 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv4i32] } ZPR:{ *:[nxv16i8] }:$src)  =>  ZPR:{ *:[nxv4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5186,
      GIR_Done,
    // Label 721: @27358
    GIM_Try, /*On fail goto*//*Label 722*/ 27392, // Rule ID 5187 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv4i32] } ZPR:{ *:[nxv8i16] }:$src)  =>  ZPR:{ *:[nxv4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5187,
      GIR_Done,
    // Label 722: @27392
    GIM_Try, /*On fail goto*//*Label 723*/ 27426, // Rule ID 5188 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv4i32] } ZPR:{ *:[nxv2i64] }:$src)  =>  ZPR:{ *:[nxv4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5188,
      GIR_Done,
    // Label 723: @27426
    GIM_Try, /*On fail goto*//*Label 724*/ 27460, // Rule ID 5189 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv4i32] } ZPR:{ *:[nxv8f16] }:$src)  =>  ZPR:{ *:[nxv4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5189,
      GIR_Done,
    // Label 724: @27460
    GIM_Try, /*On fail goto*//*Label 725*/ 27494, // Rule ID 5190 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv4i32] } ZPR:{ *:[nxv4f32] }:$src)  =>  ZPR:{ *:[nxv4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5190,
      GIR_Done,
    // Label 725: @27494
    GIM_Try, /*On fail goto*//*Label 726*/ 27528, // Rule ID 5191 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv4i32] } ZPR:{ *:[nxv2f64] }:$src)  =>  ZPR:{ *:[nxv4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5191,
      GIR_Done,
    // Label 726: @27528
    GIM_Try, /*On fail goto*//*Label 727*/ 27562, // Rule ID 5204 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv4f32] } ZPR:{ *:[nxv16i8] }:$src)  =>  ZPR:{ *:[nxv4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5204,
      GIR_Done,
    // Label 727: @27562
    GIM_Try, /*On fail goto*//*Label 728*/ 27596, // Rule ID 5205 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv4f32] } ZPR:{ *:[nxv8i16] }:$src)  =>  ZPR:{ *:[nxv4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5205,
      GIR_Done,
    // Label 728: @27596
    GIM_Try, /*On fail goto*//*Label 729*/ 27630, // Rule ID 5206 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv4f32] } ZPR:{ *:[nxv4i32] }:$src)  =>  ZPR:{ *:[nxv4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5206,
      GIR_Done,
    // Label 729: @27630
    GIM_Try, /*On fail goto*//*Label 730*/ 27664, // Rule ID 5207 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv4f32] } ZPR:{ *:[nxv2i64] }:$src)  =>  ZPR:{ *:[nxv4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5207,
      GIR_Done,
    // Label 730: @27664
    GIM_Try, /*On fail goto*//*Label 731*/ 27698, // Rule ID 5208 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv4f32] } ZPR:{ *:[nxv8f16] }:$src)  =>  ZPR:{ *:[nxv4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5208,
      GIR_Done,
    // Label 731: @27698
    GIM_Try, /*On fail goto*//*Label 732*/ 27732, // Rule ID 5209 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv4f32] } ZPR:{ *:[nxv2f64] }:$src)  =>  ZPR:{ *:[nxv4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5209,
      GIR_Done,
    // Label 732: @27732
    GIM_Reject,
    // Label 523: @27733
    GIM_Try, /*On fail goto*//*Label 733*/ 27758, // Rule ID 3775 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[v8i8] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3775,
      GIR_Done,
    // Label 733: @27758
    GIM_Try, /*On fail goto*//*Label 734*/ 27806, // Rule ID 3786 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } GPR64:{ *:[i64] }:$Xn)  =>  (REV64v8i8:{ *:[v8i8] } (COPY_TO_REGCLASS:{ *:[i64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Xn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3786,
      GIR_Done,
    // Label 734: @27806
    GIM_Try, /*On fail goto*//*Label 735*/ 27840, // Rule ID 3858 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v1i64] }:$src)  =>  FPR64:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3858,
      GIR_Done,
    // Label 735: @27840
    GIM_Try, /*On fail goto*//*Label 736*/ 27874, // Rule ID 3859 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v2i32] }:$src)  =>  FPR64:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3859,
      GIR_Done,
    // Label 736: @27874
    GIM_Try, /*On fail goto*//*Label 737*/ 27908, // Rule ID 3860 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v4i16] }:$src)  =>  FPR64:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3860,
      GIR_Done,
    // Label 737: @27908
    GIM_Try, /*On fail goto*//*Label 738*/ 27942, // Rule ID 3861 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[f64] }:$src)  =>  FPR64:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3861,
      GIR_Done,
    // Label 738: @27942
    GIM_Try, /*On fail goto*//*Label 739*/ 27976, // Rule ID 3862 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v2f32] }:$src)  =>  FPR64:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3862,
      GIR_Done,
    // Label 739: @27976
    GIM_Try, /*On fail goto*//*Label 740*/ 28010, // Rule ID 3863 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v1f64] }:$src)  =>  FPR64:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3863,
      GIR_Done,
    // Label 740: @28010
    GIM_Try, /*On fail goto*//*Label 741*/ 28044, // Rule ID 3864 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v4f16] }:$src)  =>  FPR64:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3864,
      GIR_Done,
    // Label 741: @28044
    GIM_Try, /*On fail goto*//*Label 742*/ 28067, // Rule ID 3865 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v1i64] }:$src)  =>  (REV64v8i8:{ *:[v8i8] } FPR64:{ *:[v1i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3865,
      GIR_Done,
    // Label 742: @28067
    GIM_Try, /*On fail goto*//*Label 743*/ 28090, // Rule ID 3866 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v2i32] }:$src)  =>  (REV32v8i8:{ *:[v8i8] } FPR64:{ *:[v2i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3866,
      GIR_Done,
    // Label 743: @28090
    GIM_Try, /*On fail goto*//*Label 744*/ 28113, // Rule ID 3867 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v4i16] }:$src)  =>  (REV16v8i8:{ *:[v8i8] } FPR64:{ *:[v4i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3867,
      GIR_Done,
    // Label 744: @28113
    GIM_Try, /*On fail goto*//*Label 745*/ 28136, // Rule ID 3868 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[f64] }:$src)  =>  (REV64v8i8:{ *:[v8i8] } FPR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3868,
      GIR_Done,
    // Label 745: @28136
    GIM_Try, /*On fail goto*//*Label 746*/ 28159, // Rule ID 3869 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v2f32] }:$src)  =>  (REV32v8i8:{ *:[v8i8] } FPR64:{ *:[v2f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3869,
      GIR_Done,
    // Label 746: @28159
    GIM_Try, /*On fail goto*//*Label 747*/ 28182, // Rule ID 3870 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v1f64] }:$src)  =>  (REV64v8i8:{ *:[v8i8] } FPR64:{ *:[v1f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3870,
      GIR_Done,
    // Label 747: @28182
    GIM_Try, /*On fail goto*//*Label 748*/ 28205, // Rule ID 3871 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v4f16] }:$src)  =>  (REV16v8i8:{ *:[v8i8] } FPR64:{ *:[v4f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3871,
      GIR_Done,
    // Label 748: @28205
    GIM_Reject,
    // Label 524: @28206
    GIM_Try, /*On fail goto*//*Label 749*/ 28240, // Rule ID 3975 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[f128] }:$src)  =>  FPR128:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3975,
      GIR_Done,
    // Label 749: @28240
    GIM_Try, /*On fail goto*//*Label 750*/ 28274, // Rule ID 3976 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v2i64] }:$src)  =>  FPR128:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3976,
      GIR_Done,
    // Label 750: @28274
    GIM_Try, /*On fail goto*//*Label 751*/ 28308, // Rule ID 3977 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v4i32] }:$src)  =>  FPR128:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3977,
      GIR_Done,
    // Label 751: @28308
    GIM_Try, /*On fail goto*//*Label 752*/ 28342, // Rule ID 3978 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v16i8] }:$src)  =>  FPR128:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3978,
      GIR_Done,
    // Label 752: @28342
    GIM_Try, /*On fail goto*//*Label 753*/ 28376, // Rule ID 3979 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v2f64] }:$src)  =>  FPR128:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3979,
      GIR_Done,
    // Label 753: @28376
    GIM_Try, /*On fail goto*//*Label 754*/ 28410, // Rule ID 3980 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v4f32] }:$src)  =>  FPR128:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3980,
      GIR_Done,
    // Label 754: @28410
    GIM_Try, /*On fail goto*//*Label 755*/ 28481, // Rule ID 3981 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[f128] }:$src)  =>  (EXTv16i8:{ *:[v8i16] } (REV64v8i16:{ *:[f128] } FPR128:{ *:[f128] }:$src), (REV64v8i16:{ *:[f128] } FPR128:{ *:[f128] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3981,
      GIR_Done,
    // Label 755: @28481
    GIM_Try, /*On fail goto*//*Label 756*/ 28504, // Rule ID 3982 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v2i64] }:$src)  =>  (REV64v8i16:{ *:[v8i16] } FPR128:{ *:[v2i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3982,
      GIR_Done,
    // Label 756: @28504
    GIM_Try, /*On fail goto*//*Label 757*/ 28527, // Rule ID 3983 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v4i32] }:$src)  =>  (REV32v8i16:{ *:[v8i16] } FPR128:{ *:[v4i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3983,
      GIR_Done,
    // Label 757: @28527
    GIM_Try, /*On fail goto*//*Label 758*/ 28550, // Rule ID 3984 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v16i8] }:$src)  =>  (REV16v16i8:{ *:[v8i16] } FPR128:{ *:[v16i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3984,
      GIR_Done,
    // Label 758: @28550
    GIM_Try, /*On fail goto*//*Label 759*/ 28573, // Rule ID 3985 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v2f64] }:$src)  =>  (REV64v8i16:{ *:[v8i16] } FPR128:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3985,
      GIR_Done,
    // Label 759: @28573
    GIM_Try, /*On fail goto*//*Label 760*/ 28596, // Rule ID 3986 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v4f32] }:$src)  =>  (REV32v8i16:{ *:[v8i16] } FPR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3986,
      GIR_Done,
    // Label 760: @28596
    GIM_Try, /*On fail goto*//*Label 761*/ 28628, // Rule ID 3987 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v8f16] }:$src)  =>  FPR128:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3987,
      GIR_Done,
    // Label 761: @28628
    GIM_Try, /*On fail goto*//*Label 762*/ 28662, // Rule ID 3988 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[f128] }:$src)  =>  FPR128:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3988,
      GIR_Done,
    // Label 762: @28662
    GIM_Try, /*On fail goto*//*Label 763*/ 28696, // Rule ID 3989 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v2i64] }:$src)  =>  FPR128:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3989,
      GIR_Done,
    // Label 763: @28696
    GIM_Try, /*On fail goto*//*Label 764*/ 28730, // Rule ID 3990 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v4i32] }:$src)  =>  FPR128:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3990,
      GIR_Done,
    // Label 764: @28730
    GIM_Try, /*On fail goto*//*Label 765*/ 28764, // Rule ID 3991 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v16i8] }:$src)  =>  FPR128:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3991,
      GIR_Done,
    // Label 765: @28764
    GIM_Try, /*On fail goto*//*Label 766*/ 28798, // Rule ID 3992 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v2f64] }:$src)  =>  FPR128:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3992,
      GIR_Done,
    // Label 766: @28798
    GIM_Try, /*On fail goto*//*Label 767*/ 28832, // Rule ID 3993 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v4f32] }:$src)  =>  FPR128:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 3993,
      GIR_Done,
    // Label 767: @28832
    GIM_Try, /*On fail goto*//*Label 768*/ 28903, // Rule ID 3994 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[f128] }:$src)  =>  (EXTv16i8:{ *:[v8f16] } (REV64v8i16:{ *:[f128] } FPR128:{ *:[f128] }:$src), (REV64v8i16:{ *:[f128] } FPR128:{ *:[f128] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3994,
      GIR_Done,
    // Label 768: @28903
    GIM_Try, /*On fail goto*//*Label 769*/ 28926, // Rule ID 3995 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v2i64] }:$src)  =>  (REV64v8i16:{ *:[v8f16] } FPR128:{ *:[v2i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3995,
      GIR_Done,
    // Label 769: @28926
    GIM_Try, /*On fail goto*//*Label 770*/ 28949, // Rule ID 3996 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v4i32] }:$src)  =>  (REV32v8i16:{ *:[v8f16] } FPR128:{ *:[v4i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3996,
      GIR_Done,
    // Label 770: @28949
    GIM_Try, /*On fail goto*//*Label 771*/ 28972, // Rule ID 3997 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v16i8] }:$src)  =>  (REV16v16i8:{ *:[v8f16] } FPR128:{ *:[v16i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3997,
      GIR_Done,
    // Label 771: @28972
    GIM_Try, /*On fail goto*//*Label 772*/ 28995, // Rule ID 3998 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v2f64] }:$src)  =>  (REV64v8i16:{ *:[v8f16] } FPR128:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3998,
      GIR_Done,
    // Label 772: @28995
    GIM_Try, /*On fail goto*//*Label 773*/ 29018, // Rule ID 3999 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v4f32] }:$src)  =>  (REV32v8i16:{ *:[v8f16] } FPR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3999,
      GIR_Done,
    // Label 773: @29018
    GIM_Try, /*On fail goto*//*Label 774*/ 29050, // Rule ID 4000 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v8i16] }:$src)  =>  FPR128:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 4000,
      GIR_Done,
    // Label 774: @29050
    GIM_Try, /*On fail goto*//*Label 775*/ 29084, // Rule ID 5180 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv8i16] } ZPR:{ *:[nxv16i8] }:$src)  =>  ZPR:{ *:[nxv8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5180,
      GIR_Done,
    // Label 775: @29084
    GIM_Try, /*On fail goto*//*Label 776*/ 29118, // Rule ID 5181 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv8i16] } ZPR:{ *:[nxv4i32] }:$src)  =>  ZPR:{ *:[nxv8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5181,
      GIR_Done,
    // Label 776: @29118
    GIM_Try, /*On fail goto*//*Label 777*/ 29152, // Rule ID 5182 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv8i16] } ZPR:{ *:[nxv2i64] }:$src)  =>  ZPR:{ *:[nxv8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5182,
      GIR_Done,
    // Label 777: @29152
    GIM_Try, /*On fail goto*//*Label 778*/ 29186, // Rule ID 5183 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv8i16] } ZPR:{ *:[nxv8f16] }:$src)  =>  ZPR:{ *:[nxv8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5183,
      GIR_Done,
    // Label 778: @29186
    GIM_Try, /*On fail goto*//*Label 779*/ 29220, // Rule ID 5184 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv8i16] } ZPR:{ *:[nxv4f32] }:$src)  =>  ZPR:{ *:[nxv8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5184,
      GIR_Done,
    // Label 779: @29220
    GIM_Try, /*On fail goto*//*Label 780*/ 29254, // Rule ID 5185 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv8i16] } ZPR:{ *:[nxv2f64] }:$src)  =>  ZPR:{ *:[nxv8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5185,
      GIR_Done,
    // Label 780: @29254
    GIM_Try, /*On fail goto*//*Label 781*/ 29288, // Rule ID 5198 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv8f16] } ZPR:{ *:[nxv16i8] }:$src)  =>  ZPR:{ *:[nxv8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5198,
      GIR_Done,
    // Label 781: @29288
    GIM_Try, /*On fail goto*//*Label 782*/ 29322, // Rule ID 5199 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv8f16] } ZPR:{ *:[nxv8i16] }:$src)  =>  ZPR:{ *:[nxv8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5199,
      GIR_Done,
    // Label 782: @29322
    GIM_Try, /*On fail goto*//*Label 783*/ 29356, // Rule ID 5200 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv8f16] } ZPR:{ *:[nxv4i32] }:$src)  =>  ZPR:{ *:[nxv8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5200,
      GIR_Done,
    // Label 783: @29356
    GIM_Try, /*On fail goto*//*Label 784*/ 29390, // Rule ID 5201 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv8f16] } ZPR:{ *:[nxv2i64] }:$src)  =>  ZPR:{ *:[nxv8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5201,
      GIR_Done,
    // Label 784: @29390
    GIM_Try, /*On fail goto*//*Label 785*/ 29424, // Rule ID 5202 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv8f16] } ZPR:{ *:[nxv4f32] }:$src)  =>  ZPR:{ *:[nxv8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5202,
      GIR_Done,
    // Label 785: @29424
    GIM_Try, /*On fail goto*//*Label 786*/ 29458, // Rule ID 5203 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv8f16] } ZPR:{ *:[nxv2f64] }:$src)  =>  ZPR:{ *:[nxv8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5203,
      GIR_Done,
    // Label 786: @29458
    GIM_Reject,
    // Label 525: @29459
    GIM_Try, /*On fail goto*//*Label 787*/ 29493, // Rule ID 4001 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[f128] }:$src)  =>  FPR128:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 4001,
      GIR_Done,
    // Label 787: @29493
    GIM_Try, /*On fail goto*//*Label 788*/ 29527, // Rule ID 4002 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v2i64] }:$src)  =>  FPR128:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 4002,
      GIR_Done,
    // Label 788: @29527
    GIM_Try, /*On fail goto*//*Label 789*/ 29561, // Rule ID 4003 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v4i32] }:$src)  =>  FPR128:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 4003,
      GIR_Done,
    // Label 789: @29561
    GIM_Try, /*On fail goto*//*Label 790*/ 29595, // Rule ID 4004 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v8i16] }:$src)  =>  FPR128:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 4004,
      GIR_Done,
    // Label 790: @29595
    GIM_Try, /*On fail goto*//*Label 791*/ 29629, // Rule ID 4005 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v2f64] }:$src)  =>  FPR128:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 4005,
      GIR_Done,
    // Label 791: @29629
    GIM_Try, /*On fail goto*//*Label 792*/ 29663, // Rule ID 4006 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v4f32] }:$src)  =>  FPR128:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 4006,
      GIR_Done,
    // Label 792: @29663
    GIM_Try, /*On fail goto*//*Label 793*/ 29697, // Rule ID 4007 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v8f16] }:$src)  =>  FPR128:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/38,
      // GIR_Coverage, 4007,
      GIR_Done,
    // Label 793: @29697
    GIM_Try, /*On fail goto*//*Label 794*/ 29768, // Rule ID 4008 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[f128] }:$src)  =>  (EXTv16i8:{ *:[v16i8] } (REV64v16i8:{ *:[f128] } FPR128:{ *:[f128] }:$src), (REV64v16i8:{ *:[f128] } FPR128:{ *:[f128] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v16i8,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v16i8,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4008,
      GIR_Done,
    // Label 794: @29768
    GIM_Try, /*On fail goto*//*Label 795*/ 29791, // Rule ID 4009 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v2i64] }:$src)  =>  (REV64v16i8:{ *:[v16i8] } FPR128:{ *:[v2i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4009,
      GIR_Done,
    // Label 795: @29791
    GIM_Try, /*On fail goto*//*Label 796*/ 29814, // Rule ID 4010 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v4i32] }:$src)  =>  (REV32v16i8:{ *:[v16i8] } FPR128:{ *:[v4i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4010,
      GIR_Done,
    // Label 796: @29814
    GIM_Try, /*On fail goto*//*Label 797*/ 29837, // Rule ID 4011 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v8i16] }:$src)  =>  (REV16v16i8:{ *:[v16i8] } FPR128:{ *:[v8i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4011,
      GIR_Done,
    // Label 797: @29837
    GIM_Try, /*On fail goto*//*Label 798*/ 29860, // Rule ID 4012 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v2f64] }:$src)  =>  (REV64v16i8:{ *:[v16i8] } FPR128:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4012,
      GIR_Done,
    // Label 798: @29860
    GIM_Try, /*On fail goto*//*Label 799*/ 29883, // Rule ID 4013 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v4f32] }:$src)  =>  (REV32v16i8:{ *:[v16i8] } FPR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4013,
      GIR_Done,
    // Label 799: @29883
    GIM_Try, /*On fail goto*//*Label 800*/ 29906, // Rule ID 4014 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v8f16] }:$src)  =>  (REV16v16i8:{ *:[v16i8] } FPR128:{ *:[v8f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4014,
      GIR_Done,
    // Label 800: @29906
    GIM_Try, /*On fail goto*//*Label 801*/ 29940, // Rule ID 5174 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv16i8] } ZPR:{ *:[nxv8i16] }:$src)  =>  ZPR:{ *:[nxv16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5174,
      GIR_Done,
    // Label 801: @29940
    GIM_Try, /*On fail goto*//*Label 802*/ 29974, // Rule ID 5175 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv16i8] } ZPR:{ *:[nxv4i32] }:$src)  =>  ZPR:{ *:[nxv16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5175,
      GIR_Done,
    // Label 802: @29974
    GIM_Try, /*On fail goto*//*Label 803*/ 30008, // Rule ID 5176 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv16i8] } ZPR:{ *:[nxv2i64] }:$src)  =>  ZPR:{ *:[nxv16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5176,
      GIR_Done,
    // Label 803: @30008
    GIM_Try, /*On fail goto*//*Label 804*/ 30042, // Rule ID 5177 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv16i8] } ZPR:{ *:[nxv8f16] }:$src)  =>  ZPR:{ *:[nxv16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5177,
      GIR_Done,
    // Label 804: @30042
    GIM_Try, /*On fail goto*//*Label 805*/ 30076, // Rule ID 5178 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv16i8] } ZPR:{ *:[nxv4f32] }:$src)  =>  ZPR:{ *:[nxv16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5178,
      GIR_Done,
    // Label 805: @30076
    GIM_Try, /*On fail goto*//*Label 806*/ 30110, // Rule ID 5179 //
      GIM_CheckFeatures, GIFBS_HasSVE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::ZPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::ZPRRegClassID,
      // (bitconvert:{ *:[nxv16i8] } ZPR:{ *:[nxv2f64] }:$src)  =>  ZPR:{ *:[nxv16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC ZPR*/39,
      // GIR_Coverage, 5179,
      GIR_Done,
    // Label 806: @30110
    GIM_Reject,
    // Label 526: @30111
    GIM_Reject,
    // Label 10: @30112
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 13, /*)*//*default:*//*Label 815*/ 30323,
    /*GILLT_s16*//*Label 807*/ 30131,
    /*GILLT_s32*//*Label 808*/ 30155,
    /*GILLT_s64*//*Label 809*/ 30179, 0, 0,
    /*GILLT_v2s32*//*Label 810*/ 30203,
    /*GILLT_v2s64*//*Label 811*/ 30227, 0,
    /*GILLT_v4s16*//*Label 812*/ 30251,
    /*GILLT_v4s32*//*Label 813*/ 30275, 0, 0,
    /*GILLT_v8s16*//*Label 814*/ 30299,
    // Label 807: @30131
    GIM_Try, /*On fail goto*//*Label 816*/ 30154, // Rule ID 490 //
      GIM_CheckFeatures, GIFBS_HasFullFP16,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR16RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR16RegClassID,
      // (ftrunc:{ *:[f16] } FPR16:{ *:[f16] }:$Rn)  =>  (FRINTZHr:{ *:[f16] } FPR16:{ *:[f16] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTZHr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 490,
      GIR_Done,
    // Label 816: @30154
    GIM_Reject,
    // Label 808: @30155
    GIM_Try, /*On fail goto*//*Label 817*/ 30178, // Rule ID 491 //
      GIM_CheckFeatures, GIFBS_HasFPARMv8,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR32RegClassID,
      // (ftrunc:{ *:[f32] } FPR32:{ *:[f32] }:$Rn)  =>  (FRINTZSr:{ *:[f32] } FPR32:{ *:[f32] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTZSr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 491,
      GIR_Done,
    // Label 817: @30178
    GIM_Reject,
    // Label 809: @30179
    GIM_Try, /*On fail goto*//*Label 818*/ 30202, // Rule ID 492 //
      GIM_CheckFeatures, GIFBS_HasFPARMv8,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (ftrunc:{ *:[f64] } FPR64:{ *:[f64] }:$Rn)  =>  (FRINTZDr:{ *:[f64] } FPR64:{ *:[f64] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTZDr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 492,
      GIR_Done,
    // Label 818: @30202
    GIM_Reject,
    // Label 810: @30203
    GIM_Try, /*On fail goto*//*Label 819*/ 30226, // Rule ID 751 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (ftrunc:{ *:[v2f32] } V64:{ *:[v2f32] }:$Rn)  =>  (FRINTZv2f32:{ *:[v2f32] } V64:{ *:[v2f32] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTZv2f32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 751,
      GIR_Done,
    // Label 819: @30226
    GIM_Reject,
    // Label 811: @30227
    GIM_Try, /*On fail goto*//*Label 820*/ 30250, // Rule ID 753 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (ftrunc:{ *:[v2f64] } V128:{ *:[v2f64] }:$Rn)  =>  (FRINTZv2f64:{ *:[v2f64] } V128:{ *:[v2f64] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTZv2f64,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 753,
      GIR_Done,
    // Label 820: @30250
    GIM_Reject,
    // Label 812: @30251
    GIM_Try, /*On fail goto*//*Label 821*/ 30274, // Rule ID 749 //
      GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (ftrunc:{ *:[v4f16] } V64:{ *:[v4f16] }:$Rn)  =>  (FRINTZv4f16:{ *:[v4f16] } V64:{ *:[v4f16] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTZv4f16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 749,
      GIR_Done,
    // Label 821: @30274
    GIM_Reject,
    // Label 813: @30275
    GIM_Try, /*On fail goto*//*Label 822*/ 30298, // Rule ID 752 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (ftrunc:{ *:[v4f32] } V128:{ *:[v4f32] }:$Rn)  =>  (FRINTZv4f32:{ *:[v4f32] } V128:{ *:[v4f32] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTZv4f32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 752,
      GIR_Done,
    // Label 822: @30298
    GIM_Reject,
    // Label 814: @30299
    GIM_Try, /*On fail goto*//*Label 823*/ 30322, // Rule ID 750 //
      GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (ftrunc:{ *:[v8f16] } V128:{ *:[v8f16] }:$Rn)  =>  (FRINTZv8f16:{ *:[v8f16] } V128:{ *:[v8f16] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTZv8f16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 750,
      GIR_Done,
    // Label 823: @30322
    GIM_Reject,
    // Label 815: @30323
    GIM_Reject,
    // Label 11: @30324
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 13, /*)*//*default:*//*Label 832*/ 30535,
    /*GILLT_s16*//*Label 824*/ 30343,
    /*GILLT_s32*//*Label 825*/ 30367,
    /*GILLT_s64*//*Label 826*/ 30391, 0, 0,
    /*GILLT_v2s32*//*Label 827*/ 30415,
    /*GILLT_v2s64*//*Label 828*/ 30439, 0,
    /*GILLT_v4s16*//*Label 829*/ 30463,
    /*GILLT_v4s32*//*Label 830*/ 30487, 0, 0,
    /*GILLT_v8s16*//*Label 831*/ 30511,
    // Label 824: @30343
    GIM_Try, /*On fail goto*//*Label 833*/ 30366, // Rule ID 472 //
      GIM_CheckFeatures, GIFBS_HasFullFP16,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR16RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR16RegClassID,
      // (fround:{ *:[f16] } FPR16:{ *:[f16] }:$Rn)  =>  (FRINTAHr:{ *:[f16] } FPR16:{ *:[f16] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTAHr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 472,
      GIR_Done,
    // Label 833: @30366
    GIM_Reject,
    // Label 825: @30367
    GIM_Try, /*On fail goto*//*Label 834*/ 30390, // Rule ID 473 //
      GIM_CheckFeatures, GIFBS_HasFPARMv8,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR32RegClassID,
      // (fround:{ *:[f32] } FPR32:{ *:[f32] }:$Rn)  =>  (FRINTASr:{ *:[f32] } FPR32:{ *:[f32] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTASr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 473,
      GIR_Done,
    // Label 834: @30390
    GIM_Reject,
    // Label 826: @30391
    GIM_Try, /*On fail goto*//*Label 835*/ 30414, // Rule ID 474 //
      GIM_CheckFeatures, GIFBS_HasFPARMv8,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (fround:{ *:[f64] } FPR64:{ *:[f64] }:$Rn)  =>  (FRINTADr:{ *:[f64] } FPR64:{ *:[f64] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTADr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 474,
      GIR_Done,
    // Label 835: @30414
    GIM_Reject,
    // Label 827: @30415
    GIM_Try, /*On fail goto*//*Label 836*/ 30438, // Rule ID 721 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (fround:{ *:[v2f32] } V64:{ *:[v2f32] }:$Rn)  =>  (FRINTAv2f32:{ *:[v2f32] } V64:{ *:[v2f32] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTAv2f32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 721,
      GIR_Done,
    // Label 836: @30438
    GIM_Reject,
    // Label 828: @30439
    GIM_Try, /*On fail goto*//*Label 837*/ 30462, // Rule ID 723 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (fround:{ *:[v2f64] } V128:{ *:[v2f64] }:$Rn)  =>  (FRINTAv2f64:{ *:[v2f64] } V128:{ *:[v2f64] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTAv2f64,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 723,
      GIR_Done,
    // Label 837: @30462
    GIM_Reject,
    // Label 829: @30463
    GIM_Try, /*On fail goto*//*Label 838*/ 30486, // Rule ID 719 //
      GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (fround:{ *:[v4f16] } V64:{ *:[v4f16] }:$Rn)  =>  (FRINTAv4f16:{ *:[v4f16] } V64:{ *:[v4f16] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTAv4f16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 719,
      GIR_Done,
    // Label 838: @30486
    GIM_Reject,
    // Label 830: @30487
    GIM_Try, /*On fail goto*//*Label 839*/ 30510, // Rule ID 722 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (fround:{ *:[v4f32] } V128:{ *:[v4f32] }:$Rn)  =>  (FRINTAv4f32:{ *:[v4f32] } V128:{ *:[v4f32] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTAv4f32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 722,
      GIR_Done,
    // Label 839: @30510
    GIM_Reject,
    // Label 831: @30511
    GIM_Try, /*On fail goto*//*Label 840*/ 30534, // Rule ID 720 //
      GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (fround:{ *:[v8f16] } V128:{ *:[v8f16] }:$Rn)  =>  (FRINTAv8f16:{ *:[v8f16] } V128:{ *:[v8f16] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::FRINTAv8f16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 720,
      GIR_Done,
    // Label 840: @30534
    GIM_Reject,
    // Label 832: @30535
    GIM_Reject,
    // Label 12: @30536
    GIM_Try, /*On fail goto*//*Label 841*/ 30563, // Rule ID 2326 //
      GIM_CheckFeatures, GIFBS_HasPerfMon,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      // (readcyclecounter:{ *:[i64] })  =>  (MRS:{ *:[i64] } 56552:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MRS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_AddImm, /*InsnID*/0, /*Imm*/56552,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2326,
      GIR_Done,
    // Label 841: @30563
    GIM_Reject,
    // Label 13: @30564
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 15, /*)*//*default:*//*Label 853*/ 36848,
    /*GILLT_s16*//*Label 842*/ 30585,
    /*GILLT_s32*//*Label 843*/ 30736,
    /*GILLT_s64*//*Label 844*/ 32450,
    /*GILLT_s128*//*Label 845*/ 34762, 0,
    /*GILLT_v2s32*//*Label 846*/ 34944,
    /*GILLT_v2s64*//*Label 847*/ 35256, 0,
    /*GILLT_v4s16*//*Label 848*/ 35568,
    /*GILLT_v4s32*//*Label 849*/ 35880, 0,
    /*GILLT_v8s8*//*Label 850*/ 36192,
    /*GILLT_v8s16*//*Label 851*/ 36364, 0,
    /*GILLT_v16s8*//*Label 852*/ 36676,
    // Label 842: @30585
    GIM_Try, /*On fail goto*//*Label 854*/ 30735,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR16RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 855*/ 30637, // Rule ID 203 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed16,
        // (ld:{ *:[f16] } (ro_Windexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend16:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRHroW:{ *:[f16] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend16:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRHroW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 203,
        GIR_Done,
      // Label 855: @30637
      GIM_Try, /*On fail goto*//*Label 856*/ 30672, // Rule ID 204 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed16,
        // (ld:{ *:[f16] } (ro_Xindexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend16:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRHroX:{ *:[f16] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend16:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRHroX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 204,
        GIR_Done,
      // Label 856: @30672
      GIM_Try, /*On fail goto*//*Label 857*/ 30703, // Rule ID 226 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed16,
        // (ld:{ *:[f16] } (am_indexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRHui:{ *:[f16] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRHui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 226,
        GIR_Done,
      // Label 857: @30703
      GIM_Try, /*On fail goto*//*Label 858*/ 30734, // Rule ID 247 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled16,
        // (ld:{ *:[f16] } (am_unscaled16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURHi:{ *:[f16] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURHi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 247,
        GIR_Done,
      // Label 858: @30734
      GIM_Reject,
    // Label 854: @30735
    GIM_Reject,
    // Label 843: @30736
    GIM_Try, /*On fail goto*//*Label 859*/ 30786, // Rule ID 197 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed32,
      // (ld:{ *:[i32] } (ro_Windexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend32:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRWroW:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend32:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRWroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 197,
      GIR_Done,
    // Label 859: @30786
    GIM_Try, /*On fail goto*//*Label 860*/ 30836, // Rule ID 198 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed32,
      // (ld:{ *:[i32] } (ro_Xindexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend32:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRWroX:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend32:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRWroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 198,
      GIR_Done,
    // Label 860: @30836
    GIM_Try, /*On fail goto*//*Label 861*/ 30886, // Rule ID 205 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed32,
      // (ld:{ *:[f32] } (ro_Windexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend32:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRSroW:{ *:[f32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend32:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 205,
      GIR_Done,
    // Label 861: @30886
    GIM_Try, /*On fail goto*//*Label 862*/ 30936, // Rule ID 206 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed32,
      // (ld:{ *:[f32] } (ro_Xindexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend32:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRSroX:{ *:[f32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend32:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 206,
      GIR_Done,
    // Label 862: @30936
    GIM_Try, /*On fail goto*//*Label 863*/ 30990, // Rule ID 2525 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed8,
      // (ld:{ *:[i32] } (ro_Windexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend8:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>>  =>  (LDRBBroW:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend8:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRBBroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2525,
      GIR_Done,
    // Label 863: @30990
    GIM_Try, /*On fail goto*//*Label 864*/ 31044, // Rule ID 2526 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed8,
      // (ld:{ *:[i32] } (ro_Xindexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend8:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>>  =>  (LDRBBroX:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend8:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRBBroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2526,
      GIR_Done,
    // Label 864: @31044
    GIM_Try, /*On fail goto*//*Label 865*/ 31098, // Rule ID 2527 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed16,
      // (ld:{ *:[i32] } (ro_Windexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend16:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16>>  =>  (LDRHHroW:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend16:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRHHroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2527,
      GIR_Done,
    // Label 865: @31098
    GIM_Try, /*On fail goto*//*Label 866*/ 31152, // Rule ID 2528 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed16,
      // (ld:{ *:[i32] } (ro_Xindexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend16:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16>>  =>  (LDRHHroX:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend16:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRHHroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2528,
      GIR_Done,
    // Label 866: @31152
    GIM_Try, /*On fail goto*//*Label 867*/ 31206, // Rule ID 2529 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed32,
      // (ld:{ *:[i32] } (ro_Windexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend32:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi32>>  =>  (LDRWroW:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend32:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRWroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2529,
      GIR_Done,
    // Label 867: @31206
    GIM_Try, /*On fail goto*//*Label 868*/ 31260, // Rule ID 2530 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed32,
      // (ld:{ *:[i32] } (ro_Xindexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend32:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi32>>  =>  (LDRWroX:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend32:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRWroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2530,
      GIR_Done,
    // Label 868: @31260
    GIM_Try, /*On fail goto*//*Label 869*/ 31306, // Rule ID 224 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed32,
      // (ld:{ *:[i32] } (am_indexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRWui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRWui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 224,
      GIR_Done,
    // Label 869: @31306
    GIM_Try, /*On fail goto*//*Label 870*/ 31352, // Rule ID 227 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed32,
      // (ld:{ *:[f32] } (am_indexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRSui:{ *:[f32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 227,
      GIR_Done,
    // Label 870: @31352
    GIM_Try, /*On fail goto*//*Label 871*/ 31405, // Rule ID 4074 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed8,
      // (atomic_load:{ *:[i32] } (ro_Windexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend8:{ *:[i32] }:$offset))<<P:Predicate_atomic_load_8>><<P:Predicate_anonymous_6470>>  =>  (LDRBBroW:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend8:{ *:[i32] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRBBroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4074,
      GIR_Done,
    // Label 871: @31405
    GIM_Try, /*On fail goto*//*Label 872*/ 31458, // Rule ID 4075 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed8,
      // (atomic_load:{ *:[i32] } (ro_Xindexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend8:{ *:[i32] }:$offset))<<P:Predicate_atomic_load_8>><<P:Predicate_anonymous_6470>>  =>  (LDRBBroX:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend8:{ *:[i32] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRBBroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4075,
      GIR_Done,
    // Label 872: @31458
    GIM_Try, /*On fail goto*//*Label 873*/ 31511, // Rule ID 4079 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed16,
      // (atomic_load:{ *:[i32] } (ro_Windexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend16:{ *:[i32] }:$extend))<<P:Predicate_atomic_load_16>><<P:Predicate_anonymous_6477>>  =>  (LDRHHroW:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend16:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRHHroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4079,
      GIR_Done,
    // Label 873: @31511
    GIM_Try, /*On fail goto*//*Label 874*/ 31564, // Rule ID 4080 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed16,
      // (atomic_load:{ *:[i32] } (ro_Xindexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend16:{ *:[i32] }:$extend))<<P:Predicate_atomic_load_16>><<P:Predicate_anonymous_6477>>  =>  (LDRHHroX:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend16:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRHHroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4080,
      GIR_Done,
    // Label 874: @31564
    GIM_Try, /*On fail goto*//*Label 875*/ 31617, // Rule ID 4084 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed32,
      // (atomic_load:{ *:[i32] } (ro_Windexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend32:{ *:[i32] }:$extend))<<P:Predicate_atomic_load_32>><<P:Predicate_anonymous_6484>>  =>  (LDRWroW:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend32:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRWroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4084,
      GIR_Done,
    // Label 875: @31617
    GIM_Try, /*On fail goto*//*Label 876*/ 31670, // Rule ID 4085 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed32,
      // (atomic_load:{ *:[i32] } (ro_Xindexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend32:{ *:[i32] }:$extend))<<P:Predicate_atomic_load_32>><<P:Predicate_anonymous_6484>>  =>  (LDRWroX:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend32:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRWroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4085,
      GIR_Done,
    // Label 876: @31670
    GIM_Try, /*On fail goto*//*Label 877*/ 31716, // Rule ID 245 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled32,
      // (ld:{ *:[i32] } (am_unscaled32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURWi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURWi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 245,
      GIR_Done,
    // Label 877: @31716
    GIM_Try, /*On fail goto*//*Label 878*/ 31762, // Rule ID 248 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled32,
      // (ld:{ *:[f32] } (am_unscaled32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURSi:{ *:[f32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURSi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 248,
      GIR_Done,
    // Label 878: @31762
    GIM_Try, /*On fail goto*//*Label 879*/ 31811, // Rule ID 4076 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed8,
      // (atomic_load:{ *:[i32] } (am_indexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset))<<P:Predicate_atomic_load_8>><<P:Predicate_anonymous_6470>>  =>  (LDRBBui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRBBui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4076,
      GIR_Done,
    // Label 879: @31811
    GIM_Try, /*On fail goto*//*Label 880*/ 31860, // Rule ID 4077 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled8,
      // (atomic_load:{ *:[i32] } (am_unscaled8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_atomic_load_8>><<P:Predicate_anonymous_6470>>  =>  (LDURBBi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURBBi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4077,
      GIR_Done,
    // Label 880: @31860
    GIM_Try, /*On fail goto*//*Label 881*/ 31909, // Rule ID 4081 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed16,
      // (atomic_load:{ *:[i32] } (am_indexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset))<<P:Predicate_atomic_load_16>><<P:Predicate_anonymous_6477>>  =>  (LDRHHui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRHHui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4081,
      GIR_Done,
    // Label 881: @31909
    GIM_Try, /*On fail goto*//*Label 882*/ 31958, // Rule ID 4082 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled16,
      // (atomic_load:{ *:[i32] } (am_unscaled16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_atomic_load_16>><<P:Predicate_anonymous_6477>>  =>  (LDURHHi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURHHi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4082,
      GIR_Done,
    // Label 882: @31958
    GIM_Try, /*On fail goto*//*Label 883*/ 32007, // Rule ID 4086 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed32,
      // (atomic_load:{ *:[i32] } (am_indexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset))<<P:Predicate_atomic_load_32>><<P:Predicate_anonymous_6484>>  =>  (LDRWui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRWui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4086,
      GIR_Done,
    // Label 883: @32007
    GIM_Try, /*On fail goto*//*Label 884*/ 32056, // Rule ID 4087 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled32,
      // (atomic_load:{ *:[i32] } (am_unscaled32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_atomic_load_32>><<P:Predicate_anonymous_6484>>  =>  (LDURWi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURWi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4087,
      GIR_Done,
    // Label 884: @32056
    GIM_Try, /*On fail goto*//*Label 885*/ 32106, // Rule ID 2560 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed16,
      // (ld:{ *:[i32] } (am_indexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16>>  =>  (LDRHHui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRHHui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2560,
      GIR_Done,
    // Label 885: @32106
    GIM_Try, /*On fail goto*//*Label 886*/ 32156, // Rule ID 2561 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed8,
      // (ld:{ *:[i32] } (am_indexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>>  =>  (LDRBBui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRBBui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2561,
      GIR_Done,
    // Label 886: @32156
    GIM_Try, /*On fail goto*//*Label 887*/ 32206, // Rule ID 2562 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed8,
      // (ld:{ *:[i32] } (am_indexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi1>>  =>  (LDRBBui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRBBui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2562,
      GIR_Done,
    // Label 887: @32206
    GIM_Try, /*On fail goto*//*Label 888*/ 32256, // Rule ID 2583 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled16,
      // (ld:{ *:[i32] } (am_unscaled16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16>>  =>  (LDURHHi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURHHi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2583,
      GIR_Done,
    // Label 888: @32256
    GIM_Try, /*On fail goto*//*Label 889*/ 32306, // Rule ID 2584 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled8,
      // (ld:{ *:[i32] } (am_unscaled8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>>  =>  (LDURBBi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURBBi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2584,
      GIR_Done,
    // Label 889: @32306
    GIM_Try, /*On fail goto*//*Label 890*/ 32356, // Rule ID 2585 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled8,
      // (ld:{ *:[i32] } (am_unscaled8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi1>>  =>  (LDURBBi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURBBi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2585,
      GIR_Done,
    // Label 890: @32356
    GIM_Try, /*On fail goto*//*Label 891*/ 32387, // Rule ID 4073 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
      // (atomic_load:{ *:[i32] } GPR64sp:{ *:[i64] }:$ptr)<<P:Predicate_atomic_load_8>><<P:Predicate_anonymous_6468>>  =>  (LDARB:{ *:[i32] } GPR64sp:{ *:[i64] }:$ptr)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LDARB,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4073,
      GIR_Done,
    // Label 891: @32387
    GIM_Try, /*On fail goto*//*Label 892*/ 32418, // Rule ID 4078 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
      // (atomic_load:{ *:[i32] } GPR64sp:{ *:[i64] }:$ptr)<<P:Predicate_atomic_load_16>><<P:Predicate_anonymous_6475>>  =>  (LDARH:{ *:[i32] } GPR64sp:{ *:[i64] }:$ptr)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LDARH,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4078,
      GIR_Done,
    // Label 892: @32418
    GIM_Try, /*On fail goto*//*Label 893*/ 32449, // Rule ID 4083 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
      // (atomic_load:{ *:[i32] } GPR64sp:{ *:[i64] }:$ptr)<<P:Predicate_atomic_load_32>><<P:Predicate_anonymous_6482>>  =>  (LDARW:{ *:[i32] } GPR64sp:{ *:[i64] }:$ptr)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LDARW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4083,
      GIR_Done,
    // Label 893: @32449
    GIM_Reject,
    // Label 844: @32450
    GIM_Try, /*On fail goto*//*Label 894*/ 32500, // Rule ID 199 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed64,
      // (ld:{ *:[i64] } (ro_Windexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRXroW:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRXroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 199,
      GIR_Done,
    // Label 894: @32500
    GIM_Try, /*On fail goto*//*Label 895*/ 32550, // Rule ID 200 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed64,
      // (ld:{ *:[i64] } (ro_Xindexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRXroX:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRXroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 200,
      GIR_Done,
    // Label 895: @32550
    GIM_Try, /*On fail goto*//*Label 896*/ 32600, // Rule ID 207 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed64,
      // (ld:{ *:[f64] } (ro_Windexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroW:{ *:[f64] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 207,
      GIR_Done,
    // Label 896: @32600
    GIM_Try, /*On fail goto*//*Label 897*/ 32650, // Rule ID 208 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed64,
      // (ld:{ *:[f64] } (ro_Xindexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroX:{ *:[f64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 208,
      GIR_Done,
    // Label 897: @32650
    GIM_Try, /*On fail goto*//*Label 898*/ 32700, // Rule ID 2491 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed64,
      // (ld:{ *:[v1i64] } (ro_Windexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroW:{ *:[v1i64] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2491,
      GIR_Done,
    // Label 898: @32700
    GIM_Try, /*On fail goto*//*Label 899*/ 32750, // Rule ID 2492 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed64,
      // (ld:{ *:[v1i64] } (ro_Xindexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroX:{ *:[v1i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2492,
      GIR_Done,
    // Label 899: @32750
    GIM_Try, /*On fail goto*//*Label 900*/ 32800, // Rule ID 2493 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed64,
      // (ld:{ *:[v1f64] } (ro_Windexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroW:{ *:[v1f64] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2493,
      GIR_Done,
    // Label 900: @32800
    GIM_Try, /*On fail goto*//*Label 901*/ 32850, // Rule ID 2494 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed64,
      // (ld:{ *:[v1f64] } (ro_Xindexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroX:{ *:[v1f64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2494,
      GIR_Done,
    // Label 901: @32850
    GIM_Try, /*On fail goto*//*Label 902*/ 32932, // Rule ID 2517 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed8,
      // (ld:{ *:[i64] } (ro_Windexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend8:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDRBBroW:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend8:{ *:[i32] }:$extend), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDRBBroW,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2517,
      GIR_Done,
    // Label 902: @32932
    GIM_Try, /*On fail goto*//*Label 903*/ 33014, // Rule ID 2518 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed8,
      // (ld:{ *:[i64] } (ro_Xindexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend8:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDRBBroX:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend8:{ *:[i32] }:$extend), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDRBBroX,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2518,
      GIR_Done,
    // Label 903: @33014
    GIM_Try, /*On fail goto*//*Label 904*/ 33096, // Rule ID 2519 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed16,
      // (ld:{ *:[i64] } (ro_Windexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend16:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDRHHroW:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend16:{ *:[i32] }:$extend), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDRHHroW,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2519,
      GIR_Done,
    // Label 904: @33096
    GIM_Try, /*On fail goto*//*Label 905*/ 33178, // Rule ID 2520 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed16,
      // (ld:{ *:[i64] } (ro_Xindexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend16:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDRHHroX:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend16:{ *:[i32] }:$extend), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDRHHroX,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2520,
      GIR_Done,
    // Label 905: @33178
    GIM_Try, /*On fail goto*//*Label 906*/ 33260, // Rule ID 2521 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed32,
      // (ld:{ *:[i64] } (ro_Windexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend32:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi32>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDRWroW:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend32:{ *:[i32] }:$extend), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDRWroW,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2521,
      GIR_Done,
    // Label 906: @33260
    GIM_Try, /*On fail goto*//*Label 907*/ 33342, // Rule ID 2522 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed32,
      // (ld:{ *:[i64] } (ro_Xindexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend32:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi32>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDRWroX:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend32:{ *:[i32] }:$extend), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDRWroX,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2522,
      GIR_Done,
    // Label 907: @33342
    GIM_Try, /*On fail goto*//*Label 908*/ 33424, // Rule ID 2523 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed8,
      // (ld:{ *:[i64] } (ro_Windexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend8:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi1>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDRBBroW:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend8:{ *:[i32] }:$extend), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDRBBroW,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2523,
      GIR_Done,
    // Label 908: @33424
    GIM_Try, /*On fail goto*//*Label 909*/ 33506, // Rule ID 2524 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed8,
      // (ld:{ *:[i64] } (ro_Xindexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend8:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi1>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDRBBroX:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend8:{ *:[i32] }:$extend), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDRBBroX,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2524,
      GIR_Done,
    // Label 909: @33506
    GIM_Try, /*On fail goto*//*Label 910*/ 33552, // Rule ID 223 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
      // (ld:{ *:[i64] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRXui:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRXui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 223,
      GIR_Done,
    // Label 910: @33552
    GIM_Try, /*On fail goto*//*Label 911*/ 33598, // Rule ID 228 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
      // (ld:{ *:[f64] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[f64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 228,
      GIR_Done,
    // Label 911: @33598
    GIM_Try, /*On fail goto*//*Label 912*/ 33651, // Rule ID 4089 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed64,
      // (atomic_load:{ *:[i64] } (ro_Windexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend))<<P:Predicate_atomic_load_64>><<P:Predicate_anonymous_6491>>  =>  (LDRXroW:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRXroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4089,
      GIR_Done,
    // Label 912: @33651
    GIM_Try, /*On fail goto*//*Label 913*/ 33704, // Rule ID 4090 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed64,
      // (atomic_load:{ *:[i64] } (ro_Xindexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend))<<P:Predicate_atomic_load_64>><<P:Predicate_anonymous_6491>>  =>  (LDRXroX:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRXroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4090,
      GIR_Done,
    // Label 913: @33704
    GIM_Try, /*On fail goto*//*Label 914*/ 33750, // Rule ID 244 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
      // (ld:{ *:[i64] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURXi:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURXi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 244,
      GIR_Done,
    // Label 914: @33750
    GIM_Try, /*On fail goto*//*Label 915*/ 33796, // Rule ID 249 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
      // (ld:{ *:[f64] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[f64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 249,
      GIR_Done,
    // Label 915: @33796
    GIM_Try, /*On fail goto*//*Label 916*/ 33845, // Rule ID 4091 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
      // (atomic_load:{ *:[i64] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_atomic_load_64>><<P:Predicate_anonymous_6491>>  =>  (LDRXui:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRXui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4091,
      GIR_Done,
    // Label 916: @33845
    GIM_Try, /*On fail goto*//*Label 917*/ 33894, // Rule ID 4092 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckAtomicOrderingWeakerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
      // (atomic_load:{ *:[i64] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_atomic_load_64>><<P:Predicate_anonymous_6491>>  =>  (LDURXi:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURXi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4092,
      GIR_Done,
    // Label 917: @33894
    GIM_Try, /*On fail goto*//*Label 918*/ 33940, // Rule ID 2546 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
      // (ld:{ *:[v1f64] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[v1f64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2546,
      GIR_Done,
    // Label 918: @33940
    GIM_Try, /*On fail goto*//*Label 919*/ 33986, // Rule ID 2547 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
      // (ld:{ *:[v1i64] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[v1i64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2547,
      GIR_Done,
    // Label 919: @33986
    GIM_Try, /*On fail goto*//*Label 920*/ 34032, // Rule ID 2574 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
      // (ld:{ *:[v1f64] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[v1f64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2574,
      GIR_Done,
    // Label 920: @34032
    GIM_Try, /*On fail goto*//*Label 921*/ 34078, // Rule ID 2575 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
      // (ld:{ *:[v1i64] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[v1i64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2575,
      GIR_Done,
    // Label 921: @34078
    GIM_Try, /*On fail goto*//*Label 922*/ 34156, // Rule ID 2563 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed32,
      // (ld:{ *:[i64] } (am_indexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi32>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDRWui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDRWui,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2563,
      GIR_Done,
    // Label 922: @34156
    GIM_Try, /*On fail goto*//*Label 923*/ 34234, // Rule ID 2564 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed16,
      // (ld:{ *:[i64] } (am_indexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDRHHui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDRHHui,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2564,
      GIR_Done,
    // Label 923: @34234
    GIM_Try, /*On fail goto*//*Label 924*/ 34312, // Rule ID 2565 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed8,
      // (ld:{ *:[i64] } (am_indexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDRBBui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDRBBui,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2565,
      GIR_Done,
    // Label 924: @34312
    GIM_Try, /*On fail goto*//*Label 925*/ 34390, // Rule ID 2566 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed8,
      // (ld:{ *:[i64] } (am_indexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi1>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDRBBui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDRBBui,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2566,
      GIR_Done,
    // Label 925: @34390
    GIM_Try, /*On fail goto*//*Label 926*/ 34468, // Rule ID 2586 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled32,
      // (ld:{ *:[i64] } (am_unscaled32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi32>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDURWi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDURWi,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2586,
      GIR_Done,
    // Label 926: @34468
    GIM_Try, /*On fail goto*//*Label 927*/ 34546, // Rule ID 2587 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled16,
      // (ld:{ *:[i64] } (am_unscaled16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDURHHi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDURHHi,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2587,
      GIR_Done,
    // Label 927: @34546
    GIM_Try, /*On fail goto*//*Label 928*/ 34624, // Rule ID 2588 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled8,
      // (ld:{ *:[i64] } (am_unscaled8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDURBBi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDURBBi,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2588,
      GIR_Done,
    // Label 928: @34624
    GIM_Try, /*On fail goto*//*Label 929*/ 34702, // Rule ID 2589 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled8,
      // (ld:{ *:[i64] } (am_unscaled8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi1>>  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDURBBi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset), sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDURBBi,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/1, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/15,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64all*/15,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/6,
      // GIR_Coverage, 2589,
      GIR_Done,
    // Label 929: @34702
    GIM_Try, /*On fail goto*//*Label 930*/ 34733, // Rule ID 4088 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      // MIs[0] ptr
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
      // (atomic_load:{ *:[i64] } GPR64sp:{ *:[i64] }:$ptr)<<P:Predicate_atomic_load_64>><<P:Predicate_anonymous_6489>>  =>  (LDARX:{ *:[i64] } GPR64sp:{ *:[i64] }:$ptr)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LDARX,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4088,
      GIR_Done,
    // Label 930: @34733
    GIM_Try, /*On fail goto*//*Label 931*/ 34761, // Rule ID 3596 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      // MIs[0] Rn
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
      // (ld:{ *:[v1i64] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev1d:{ *:[v1i64] } GPR64sp:{ *:[i64] }:$Rn)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev1d,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3596,
      GIR_Done,
    // Label 931: @34761
    GIM_Reject,
    // Label 845: @34762
    GIM_Try, /*On fail goto*//*Label 932*/ 34943,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 933*/ 34814, // Rule ID 209 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed128,
        // (ld:{ *:[f128] } (ro_Windexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroW:{ *:[f128] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 209,
        GIR_Done,
      // Label 933: @34814
      GIM_Try, /*On fail goto*//*Label 934*/ 34849, // Rule ID 210 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed128,
        // (ld:{ *:[f128] } (ro_Xindexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroX:{ *:[f128] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 210,
        GIR_Done,
      // Label 934: @34849
      GIM_Try, /*On fail goto*//*Label 935*/ 34880, // Rule ID 229 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[f128] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[f128] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 229,
        GIR_Done,
      // Label 935: @34880
      GIM_Try, /*On fail goto*//*Label 936*/ 34911, // Rule ID 250 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[f128] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[f128] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 250,
        GIR_Done,
      // Label 936: @34911
      GIM_Try, /*On fail goto*//*Label 937*/ 34942, // Rule ID 2555 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[f128] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[f128] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2555,
        GIR_Done,
      // Label 937: @34942
      GIM_Reject,
    // Label 932: @34943
    GIM_Reject,
    // Label 846: @34944
    GIM_Try, /*On fail goto*//*Label 938*/ 35255,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 939*/ 34998, // Rule ID 2481 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed64,
        // (ld:{ *:[v2i32] } (ro_Windexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroW:{ *:[v2i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2481,
        GIR_Done,
      // Label 939: @34998
      GIM_Try, /*On fail goto*//*Label 940*/ 35035, // Rule ID 2482 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed64,
        // (ld:{ *:[v2i32] } (ro_Xindexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroX:{ *:[v2i32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2482,
        GIR_Done,
      // Label 940: @35035
      GIM_Try, /*On fail goto*//*Label 941*/ 35072, // Rule ID 2483 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed64,
        // (ld:{ *:[v2f32] } (ro_Windexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroW:{ *:[v2f32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2483,
        GIR_Done,
      // Label 941: @35072
      GIM_Try, /*On fail goto*//*Label 942*/ 35109, // Rule ID 2484 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed64,
        // (ld:{ *:[v2f32] } (ro_Xindexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroX:{ *:[v2f32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2484,
        GIR_Done,
      // Label 942: @35109
      GIM_Try, /*On fail goto*//*Label 943*/ 35142, // Rule ID 2541 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (ld:{ *:[v2f32] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[v2f32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2541,
        GIR_Done,
      // Label 943: @35142
      GIM_Try, /*On fail goto*//*Label 944*/ 35175, // Rule ID 2544 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (ld:{ *:[v2i32] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[v2i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2544,
        GIR_Done,
      // Label 944: @35175
      GIM_Try, /*On fail goto*//*Label 945*/ 35208, // Rule ID 2569 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (ld:{ *:[v2f32] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[v2f32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2569,
        GIR_Done,
      // Label 945: @35208
      GIM_Try, /*On fail goto*//*Label 946*/ 35241, // Rule ID 2570 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (ld:{ *:[v2i32] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[v2i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2570,
        GIR_Done,
      // Label 946: @35241
      GIM_Try, /*On fail goto*//*Label 947*/ 35254, // Rule ID 3595 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (ld:{ *:[v2i32] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev2s:{ *:[v2i32] } GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev2s,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3595,
        GIR_Done,
      // Label 947: @35254
      GIM_Reject,
    // Label 938: @35255
    GIM_Reject,
    // Label 847: @35256
    GIM_Try, /*On fail goto*//*Label 948*/ 35567,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 949*/ 35310, // Rule ID 2495 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed128,
        // (ld:{ *:[v2i64] } (ro_Windexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroW:{ *:[v2i64] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2495,
        GIR_Done,
      // Label 949: @35310
      GIM_Try, /*On fail goto*//*Label 950*/ 35347, // Rule ID 2496 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed128,
        // (ld:{ *:[v2i64] } (ro_Xindexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroX:{ *:[v2i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2496,
        GIR_Done,
      // Label 950: @35347
      GIM_Try, /*On fail goto*//*Label 951*/ 35384, // Rule ID 2497 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed128,
        // (ld:{ *:[v2f64] } (ro_Windexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroW:{ *:[v2f64] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2497,
        GIR_Done,
      // Label 951: @35384
      GIM_Try, /*On fail goto*//*Label 952*/ 35421, // Rule ID 2498 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed128,
        // (ld:{ *:[v2f64] } (ro_Xindexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroX:{ *:[v2f64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2498,
        GIR_Done,
      // Label 952: @35421
      GIM_Try, /*On fail goto*//*Label 953*/ 35454, // Rule ID 2549 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[v2f64] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[v2f64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2549,
        GIR_Done,
      // Label 953: @35454
      GIM_Try, /*On fail goto*//*Label 954*/ 35487, // Rule ID 2553 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[v2i64] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[v2i64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2553,
        GIR_Done,
      // Label 954: @35487
      GIM_Try, /*On fail goto*//*Label 955*/ 35520, // Rule ID 2576 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[v2f64] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[v2f64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2576,
        GIR_Done,
      // Label 955: @35520
      GIM_Try, /*On fail goto*//*Label 956*/ 35553, // Rule ID 2577 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[v2i64] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[v2i64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2577,
        GIR_Done,
      // Label 956: @35553
      GIM_Try, /*On fail goto*//*Label 957*/ 35566, // Rule ID 3592 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (ld:{ *:[v2i64] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev2d:{ *:[v2i64] } GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev2d,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3592,
        GIR_Done,
      // Label 957: @35566
      GIM_Reject,
    // Label 948: @35567
    GIM_Reject,
    // Label 848: @35568
    GIM_Try, /*On fail goto*//*Label 958*/ 35879,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 959*/ 35622, // Rule ID 2487 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed64,
        // (ld:{ *:[v4i16] } (ro_Windexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroW:{ *:[v4i16] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2487,
        GIR_Done,
      // Label 959: @35622
      GIM_Try, /*On fail goto*//*Label 960*/ 35659, // Rule ID 2488 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed64,
        // (ld:{ *:[v4i16] } (ro_Xindexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroX:{ *:[v4i16] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2488,
        GIR_Done,
      // Label 960: @35659
      GIM_Try, /*On fail goto*//*Label 961*/ 35696, // Rule ID 2489 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed64,
        // (ld:{ *:[v4f16] } (ro_Windexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroW:{ *:[v4f16] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2489,
        GIR_Done,
      // Label 961: @35696
      GIM_Try, /*On fail goto*//*Label 962*/ 35733, // Rule ID 2490 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed64,
        // (ld:{ *:[v4f16] } (ro_Xindexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroX:{ *:[v4f16] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2490,
        GIR_Done,
      // Label 962: @35733
      GIM_Try, /*On fail goto*//*Label 963*/ 35766, // Rule ID 2543 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (ld:{ *:[v4i16] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[v4i16] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2543,
        GIR_Done,
      // Label 963: @35766
      GIM_Try, /*On fail goto*//*Label 964*/ 35799, // Rule ID 2545 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (ld:{ *:[v4f16] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[v4f16] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2545,
        GIR_Done,
      // Label 964: @35799
      GIM_Try, /*On fail goto*//*Label 965*/ 35832, // Rule ID 2571 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (ld:{ *:[v4i16] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[v4i16] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2571,
        GIR_Done,
      // Label 965: @35832
      GIM_Try, /*On fail goto*//*Label 966*/ 35865, // Rule ID 2573 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (ld:{ *:[v4f16] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[v4f16] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2573,
        GIR_Done,
      // Label 966: @35865
      GIM_Try, /*On fail goto*//*Label 967*/ 35878, // Rule ID 3594 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (ld:{ *:[v4i16] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev4h:{ *:[v4i16] } GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev4h,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3594,
        GIR_Done,
      // Label 967: @35878
      GIM_Reject,
    // Label 958: @35879
    GIM_Reject,
    // Label 849: @35880
    GIM_Try, /*On fail goto*//*Label 968*/ 36191,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 969*/ 35934, // Rule ID 2499 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed128,
        // (ld:{ *:[v4i32] } (ro_Windexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroW:{ *:[v4i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2499,
        GIR_Done,
      // Label 969: @35934
      GIM_Try, /*On fail goto*//*Label 970*/ 35971, // Rule ID 2500 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed128,
        // (ld:{ *:[v4i32] } (ro_Xindexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroX:{ *:[v4i32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2500,
        GIR_Done,
      // Label 970: @35971
      GIM_Try, /*On fail goto*//*Label 971*/ 36008, // Rule ID 2501 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed128,
        // (ld:{ *:[v4f32] } (ro_Windexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroW:{ *:[v4f32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2501,
        GIR_Done,
      // Label 971: @36008
      GIM_Try, /*On fail goto*//*Label 972*/ 36045, // Rule ID 2502 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed128,
        // (ld:{ *:[v4f32] } (ro_Xindexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroX:{ *:[v4f32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2502,
        GIR_Done,
      // Label 972: @36045
      GIM_Try, /*On fail goto*//*Label 973*/ 36078, // Rule ID 2548 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[v4f32] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[v4f32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2548,
        GIR_Done,
      // Label 973: @36078
      GIM_Try, /*On fail goto*//*Label 974*/ 36111, // Rule ID 2552 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[v4i32] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[v4i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2552,
        GIR_Done,
      // Label 974: @36111
      GIM_Try, /*On fail goto*//*Label 975*/ 36144, // Rule ID 2578 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[v4f32] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[v4f32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2578,
        GIR_Done,
      // Label 975: @36144
      GIM_Try, /*On fail goto*//*Label 976*/ 36177, // Rule ID 2579 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[v4i32] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[v4i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2579,
        GIR_Done,
      // Label 976: @36177
      GIM_Try, /*On fail goto*//*Label 977*/ 36190, // Rule ID 3591 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (ld:{ *:[v4i32] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev4s:{ *:[v4i32] } GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev4s,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3591,
        GIR_Done,
      // Label 977: @36190
      GIM_Reject,
    // Label 968: @36191
    GIM_Reject,
    // Label 850: @36192
    GIM_Try, /*On fail goto*//*Label 978*/ 36363,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 979*/ 36246, // Rule ID 2485 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed64,
        // (ld:{ *:[v8i8] } (ro_Windexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroW:{ *:[v8i8] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend64:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2485,
        GIR_Done,
      // Label 979: @36246
      GIM_Try, /*On fail goto*//*Label 980*/ 36283, // Rule ID 2486 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed64,
        // (ld:{ *:[v8i8] } (ro_Xindexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDroX:{ *:[v8i8] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend64:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDroX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2486,
        GIR_Done,
      // Label 980: @36283
      GIM_Try, /*On fail goto*//*Label 981*/ 36316, // Rule ID 2542 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (ld:{ *:[v8i8] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[v8i8] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2542,
        GIR_Done,
      // Label 981: @36316
      GIM_Try, /*On fail goto*//*Label 982*/ 36349, // Rule ID 2572 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (ld:{ *:[v8i8] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[v8i8] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2572,
        GIR_Done,
      // Label 982: @36349
      GIM_Try, /*On fail goto*//*Label 983*/ 36362, // Rule ID 3593 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (ld:{ *:[v8i8] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev8b:{ *:[v8i8] } GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev8b,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3593,
        GIR_Done,
      // Label 983: @36362
      GIM_Reject,
    // Label 978: @36363
    GIM_Reject,
    // Label 851: @36364
    GIM_Try, /*On fail goto*//*Label 984*/ 36675,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 985*/ 36418, // Rule ID 2503 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed128,
        // (ld:{ *:[v8i16] } (ro_Windexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroW:{ *:[v8i16] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2503,
        GIR_Done,
      // Label 985: @36418
      GIM_Try, /*On fail goto*//*Label 986*/ 36455, // Rule ID 2504 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed128,
        // (ld:{ *:[v8i16] } (ro_Xindexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroX:{ *:[v8i16] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2504,
        GIR_Done,
      // Label 986: @36455
      GIM_Try, /*On fail goto*//*Label 987*/ 36492, // Rule ID 2505 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed128,
        // (ld:{ *:[v8f16] } (ro_Windexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroW:{ *:[v8f16] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2505,
        GIR_Done,
      // Label 987: @36492
      GIM_Try, /*On fail goto*//*Label 988*/ 36529, // Rule ID 2506 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed128,
        // (ld:{ *:[v8f16] } (ro_Xindexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroX:{ *:[v8f16] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2506,
        GIR_Done,
      // Label 988: @36529
      GIM_Try, /*On fail goto*//*Label 989*/ 36562, // Rule ID 2551 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[v8i16] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[v8i16] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2551,
        GIR_Done,
      // Label 989: @36562
      GIM_Try, /*On fail goto*//*Label 990*/ 36595, // Rule ID 2554 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[v8f16] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[v8f16] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2554,
        GIR_Done,
      // Label 990: @36595
      GIM_Try, /*On fail goto*//*Label 991*/ 36628, // Rule ID 2580 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[v8i16] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[v8i16] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2580,
        GIR_Done,
      // Label 991: @36628
      GIM_Try, /*On fail goto*//*Label 992*/ 36661, // Rule ID 2582 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[v8f16] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[v8f16] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2582,
        GIR_Done,
      // Label 992: @36661
      GIM_Try, /*On fail goto*//*Label 993*/ 36674, // Rule ID 3590 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (ld:{ *:[v8i16] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev8h:{ *:[v8i16] } GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev8h,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3590,
        GIR_Done,
      // Label 993: @36674
      GIM_Reject,
    // Label 984: @36675
    GIM_Reject,
    // Label 852: @36676
    GIM_Try, /*On fail goto*//*Label 994*/ 36847,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 995*/ 36730, // Rule ID 2507 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed128,
        // (ld:{ *:[v16i8] } (ro_Windexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroW:{ *:[v16i8] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2507,
        GIR_Done,
      // Label 995: @36730
      GIM_Try, /*On fail goto*//*Label 996*/ 36767, // Rule ID 2508 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed128,
        // (ld:{ *:[v16i8] } (ro_Xindexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQroX:{ *:[v16i8] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend128:{ *:[i32] }:$extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQroX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2508,
        GIR_Done,
      // Label 996: @36767
      GIM_Try, /*On fail goto*//*Label 997*/ 36800, // Rule ID 2550 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[v16i8] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[v16i8] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2550,
        GIR_Done,
      // Label 997: @36800
      GIM_Try, /*On fail goto*//*Label 998*/ 36833, // Rule ID 2581 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[v16i8] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[v16i8] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2581,
        GIR_Done,
      // Label 998: @36833
      GIM_Try, /*On fail goto*//*Label 999*/ 36846, // Rule ID 3589 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (ld:{ *:[v16i8] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev16b:{ *:[v16i8] } GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev16b,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3589,
        GIR_Done,
      // Label 999: @36846
      GIM_Reject,
    // Label 994: @36847
    GIM_Reject,
    // Label 853: @36848
    GIM_Reject,
    // Label 14: @36849
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1002*/ 37819,
    /*GILLT_s32*//*Label 1000*/ 36857,
    /*GILLT_s64*//*Label 1001*/ 37242,
    // Label 1000: @36857
    GIM_Try, /*On fail goto*//*Label 1003*/ 36907, // Rule ID 211 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed16,
      // (ld:{ *:[i32] } (ro_Windexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend16:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LDRSHWroW:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend16:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSHWroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 211,
      GIR_Done,
    // Label 1003: @36907
    GIM_Try, /*On fail goto*//*Label 1004*/ 36957, // Rule ID 212 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed16,
      // (ld:{ *:[i32] } (ro_Xindexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend16:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LDRSHWroX:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend16:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSHWroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 212,
      GIR_Done,
    // Label 1004: @36957
    GIM_Try, /*On fail goto*//*Label 1005*/ 37007, // Rule ID 215 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed8,
      // (ld:{ *:[i32] } (ro_Windexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend8:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>>  =>  (LDRSBWroW:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend8:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSBWroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 215,
      GIR_Done,
    // Label 1005: @37007
    GIM_Try, /*On fail goto*//*Label 1006*/ 37057, // Rule ID 216 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed8,
      // (ld:{ *:[i32] } (ro_Xindexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend8:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>>  =>  (LDRSBWroX:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend8:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSBWroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 216,
      GIR_Done,
    // Label 1006: @37057
    GIM_Try, /*On fail goto*//*Label 1007*/ 37103, // Rule ID 232 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed16,
      // (ld:{ *:[i32] } (am_indexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LDRSHWui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSHWui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 232,
      GIR_Done,
    // Label 1007: @37103
    GIM_Try, /*On fail goto*//*Label 1008*/ 37149, // Rule ID 234 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed8,
      // (ld:{ *:[i32] } (am_indexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>>  =>  (LDRSBWui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSBWui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 234,
      GIR_Done,
    // Label 1008: @37149
    GIM_Try, /*On fail goto*//*Label 1009*/ 37195, // Rule ID 253 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled16,
      // (ld:{ *:[i32] } (am_unscaled16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LDURSHWi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURSHWi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 253,
      GIR_Done,
    // Label 1009: @37195
    GIM_Try, /*On fail goto*//*Label 1010*/ 37241, // Rule ID 255 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled8,
      // (ld:{ *:[i32] } (am_unscaled8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>>  =>  (LDURSBWi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURSBWi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 255,
      GIR_Done,
    // Label 1010: @37241
    GIM_Reject,
    // Label 1001: @37242
    GIM_Try, /*On fail goto*//*Label 1011*/ 37292, // Rule ID 213 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed16,
      // (ld:{ *:[i64] } (ro_Windexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend16:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LDRSHXroW:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend16:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSHXroW,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 213,
      GIR_Done,
    // Label 1011: @37292
    GIM_Try, /*On fail goto*//*Label 1012*/ 37342, // Rule ID 214 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Xindexed16,
      // (ld:{ *:[i64] } (ro_Xindexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend16:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LDRSHXroX:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, ro_Xextend16:{ *:[i32] }:$extend)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSHXroX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // Rm
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // extend
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 214,
      GIR_Done,
    // Label 1012: @37342
    GIM_Try, /*On fail goto*//*Label 1013*/ 37392, // Rule ID 217 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ro_Windexed8,
      // (ld:{ *:[i64] } (ro_Windexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend8:{ *:[i32] }:$extend))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>>  =>  (LDRSBXroW:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm, ro_Wextend8:{ *:[i32] }:$extend)
      GIR_BuildM